/*
 * Copyright © 2010 Codethink Limited
 * Copyright © 2011 Canonical Limited
 *
 * This library is free software: you can redistribute it and/or modify it under the terms of version 3 of the
 * GNU Lesser General Public License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this program.  If not,
 * see <http://www.gnu.org/licenses/>.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#ifndef _qconfschema_h_
#define _qconfschema_h_

#include <QObject>
#include <glib.h>

typedef struct _QConfSchemaPrivate QConfSchemaPrivate;

class QConfSchema {
  public:
    static const QConfSchema* getSchema(const QString & name);

    const QMetaObject *metaObject() const;

    const GVariantType *valueType(int id) const;
    GVariant *defaultValue(int id) const;
    const char *keyName(int id) const;
    const char *path() const;
    const QString& name() const;
    int count() const;
    int findKey (const char *key) const;

  private:
    QConfSchema(const QString & name);
    void buildMetaObject();
    QConfSchemaPrivate *priv;
};

#endif /* _qconfschema_h_ */
