.\" dpkg manual page - dpkg-query(1)
.\"
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-query 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOME
dpkg\-query \- uno strumento per interrogare il database di dpkg
.
.SH SINTASSI
\fBdpkg\-query\fP [\fIopzione\fP...] \fIcomando\fP
.
.SH DESCRIZIONE
\fBdpkg\-query\fP è uno strumento per mostrare informazioni sui pacchetti
elencati nel database di \fBdpkg\fP.
.
.SH COMANDI
.TP 
\fB\-l\fP, \fB\-\-list\fP [\fImodello\-nome\-pacchetti\fP...]
List packages matching given pattern. If no \fIpackage\-name\-pattern\fP is
given, list all packages in \fI%ADMINDIR%/status\fP, excluding the ones marked
as not\-installed (i.e. those which have been previously purged). Normal
shell wildcard characters are allowed in \fIpackage\-name\-pattern\fP. Please
note you will probably have to quote \fIpackage\-name\-pattern\fP to prevent the
shell from performing filename expansion. For example this will list all
package names starting with \*(lqlibc6\*(rq:

.nf
  \fBdpkg\-query \-l 'libc6*'\fP
.fi

Le prime tre colonne dell'output mostrano, nell'ordine, l'azione desiderata,
lo stato del pacchetto e gli errori.

Azione desiderata:
.nf
  u = Sconosciuta
  i = Installazione
  h = Blocco
  r = Rimozione
  p = Eliminazione completa
.fi

Stato del pacchetto:
.nf
  n = Non\-installato
  c = File\-di\-configurazione
  H = Semi\-installato
  U = Spacchettato
  F = Semi\-configurato
  W = Triggers\-awaiting
  t = Triggers\-pending
  i = Installato
.fi

Contrassegni di errore:
.nf
  <vuoto> = (nessuno)
  R = Richiesta\-reinstallazione
.fi

Una lettera di stato o di errore maiuscola indica che il pacchetto
probabilmente causerà problemi seri. Fare riferimento a \fBdpkg\fP(1) per
informazioni su tali stati e contrassegni.

Il formato di output di questa opzione non è configurabile, ma varia
automaticamente per essere adattato alla larghezza del terminale. È pensato
per essere letto da persone e non è facilmente leggibile da macchine. Vedere
\fB\-W\fP (\fB\-\-show\fP) e \fB\-\-showformat\fP per un modo per configurare il formato
di output.
.TP 
\fB\-W\fP, \fB\-\-show\fP [\fImodello\-nome\-pacchetti\fP...]
Proprio come l'opzione \fB\-\-list\fP, questa elenca tutti i pacchetti che
corrispondono al modello indicato. Tuttavia l'output può essere
personalizzato usando l'opzione \fB\-\-showformat\fP. L'output predefinito
fornisce una riga per ogni pacchetto che corrisponde, ciascuna riga contiene
il nome (esteso con l'elemento che identifica l'architettura per i pacchetti
\fBMulti\-Arch\fP \fBsame\fP) e la versione installata del pacchetto, separati da
una tabulazione.
.TP 
\fB\-s\fP, \fB\-\-status\fP \fInome\-pacchetto\fP...
Segnala lo stato dei pacchetti specificati. Si limita a visualizzare la voce
nel database di stato dei pacchetti installati. Quando sono elencati più
\fInome\-pacchetto\fP, le voci di stato richieste sono separate da una riga
vuota, nello stesso ordine con cui sono specificate nell'elenco degli
argomenti.
.TP 
\fB\-L\fP, \fB\-\-listfiles\fP \fInome\-pacchetto\fP...
Elenca i file installati nel sistema da \fInome\-pacchetto\fP. Quando sono
elencati più \fInome\-pacchetto\fP, gli elenchi di file richiesti sono separati
da una riga vuota, nello stesso ordine con cui sono specificati nell'elenco
degli argomenti. Tuttavia, notare che i file creati da script di
installazione specifici dei pacchetti non vengono elencati.
.TP 
\fB\-\-control\-list\fP \fInome\-pacchetto\fP
List control files installed to your system from \fIpackage\-name\fP (since dpkg
1.16.5).  These can be used as input arguments to \fB\-\-control\-show\fP.
.TP 
\fB\-\-control\-show\fP \fInome\-pacchetto\fP \fIfile\-controllo\fP
Print the \fIcontrol\-file\fP installed to your system from \fIpackage\-name\fP to
the standard output (since dpkg 1.16.5).
.TP 
\fB\-c\fP, \fB\-\-control\-path\fP \fInome\-pacchetto\fP [\fIfile\-controllo\fP]
List paths for control files installed to your system from \fIpackage\-name\fP
(since dpkg 1.15.4).  If \fIcontrol\-file\fP is specified then only list the
path for that control file if it is present.

\fBAvvertimento\fP: questo comando è deprecato perché dà accesso diretto al
database interno di dpkg; passare invece all'uso di \fB\-\-control\-list\fP e
\fB\-\-control\-show\fP per tutti i casi in cui questi comandi possono fornire lo
stesso risultato finale. Tuttavia, fino a che c'è ancora almeno un caso in
cui è necessario questo comando (cioè quando si deve rimuovere uno script
postrm del manutentore pericoloso) e fino a che non c'è una buona soluzione
per il problema, questo comando non sarà rimosso.
.TP 
\fB\-S\fP, \fB\-\-search\fP \fImodello\-ricerca\-nomefile\fP...
Search for packages that own files corresponding to the given pattern.
Standard shell wildcard characters can be used in the pattern, where
asterisk (\fB*\fP) and question mark (\fB?\fP) will match a slash, and blackslash
(\fB\e\fP) will be used as an escape character.

If the first character in the \fIfilename\-search\-pattern\fP is none of
‘\fB*[?/\fP’ then it will be considered a substring match and will be
implicitly surrounded by ‘\fB*\fP’ (as in \fB*\fP\fIfilename\-search\-pattern\fP\fB*\fP).
If the subsequent string contains any of ‘\fB*[?\e\fP’, then it will handled
like a glob pattern, otherwise any trailing ‘\fB/\fP’ or ‘\fB/.\fP’ will be
removed and a literal path lookup will be performed.

This command will not list extra files created by maintainer scripts, nor
will it list alternatives.
.TP 
\fB\-p\fP, \fB\-\-print\-avail\fP \fInome\-pacchetto\fP...
Visualizza i dettagli su \fInome\-pacchetto\fP, come trovati in
\fI%ADMINDIR%/available\fP. Quando vengono elencati più \fInome\-pacchetto\fP, le
voci richieste in \fIavailable\fP sono separate da una riga vuota, e sono nello
stesso ordine con cui sono specificate nell'elenco degli argomenti.

Gli utenti di frontend basati su APT dovrebbero usare \fBapt\-cache show\fP
\fInome\-pacchetto\fP invece, dato che il file \fIavailable\fP viene mantenuto
aggiornato solo quando si usa \fBdselect\fP.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Mostra il messaggio sull'uso ed esce.
.TP 
\fB\-\-version\fP
Mostra la versione ed esce.
.
.SH OPZIONI
.TP 
\fB\-\-admindir=\fP\fIdir\fP
Change the location of the \fBdpkg\fP database. The default location is
\fI%ADMINDIR%\fP.
.TP 
\fB\-\-load\-avail\fP
Also load the available file when using the \fB\-\-show\fP and \fB\-\-list\fP
commands, which now default to only querying the status file (since dpkg
1.16.2).
.TP 
\fB\-f\fP, \fB\-\-showformat=\fP\fIformato\fP
Questa opzione viene usata per specificare il formato dell'output che verrà
prodotto da \fB\-\-show\fP. Il formato è una stringa che verrà prodotta in output
per ciascun pacchetto elencato.

Nella stringa di formato, “\fB\e\fP” introduce caratteri escape:

.nf
    \fB\en\fP  nuova riga
    \fB\er\fP  ritorno di carrello
    \fB\et\fP  tabulazione
.fi

“\fB\e\fP” prima di qualsiasi altro carattere ne annulla ogni significato
speciale e questo è utile per “\fB\e\fP” e “\fB$\fP”.

Le informazioni sul pacchetto possono essere incluse inserendo riferimenti
con variabili a campi dei pacchetti, usando la sintassi
“\fB${\fP\fIcampo\fP[\fB;\fP\fIlarghezza\fP]\fB}\fP”. I campi vengono stampati allineati a
destra, a meno che la larghezza non sia negativa nel qual caso viene usato
l'allineamento a sinistra. Vengono riconosciuti i seguenti nomi di \fIcampo\fP,
ma non sono necessariamente disponibili nel file di stato (ci vanno solo i
campi interni o i campi memorizzati nel pacchetto binario):

.nf
    \fBArchitecture\fP
    \fBBugs\fP
    \fBConffiles\fP (interno)
    \fBConfig\-Version\fP (interno)
    \fBConflicts\fP
    \fBBreaks\fP
    \fBDepends\fP
    \fBDescription\fP
    \fBEnhances\fP
    \fBEssential\fP
    \fBFilename\fP (interno, relativo al frontend)
    \fBHomepage\fP
    \fBInstalled\-Size\fP
    \fBMD5sum\fP (interno, relativo al frontend)
    \fBMSDOS\-Filename\fP (interno, relativo al frontend)
    \fBMaintainer\fP
    \fBOrigin\fP
    \fBPackage\fP
    \fBPre\-Depends\fP
    \fBPriority\fP
    \fBProvides\fP
    \fBRecommends\fP
    \fBReplaces\fP
    \fBRevision\fP (obsoleto)
    \fBSection\fP
    \fBSize\fP (interno, relativo al frontend)
    \fBSource\fP
    \fBStatus\fP (interno)
    \fBSuggests\fP
    \fBTag\fP (solitamente non nei .deb ma nei file Packages dei repository)
    \fBTriggers\-Awaited\fP (interno)
    \fBTriggers\-Pending\fP (interno)
    \fBVersion\fP
.fi

I seguenti sono campi virtuali, generati da \fBdpkg\-query\fP a partire dai
valori di altri campi (notare che questi non usano nomi validi per i campi
nei file di controllo):
.RS
.TP 
\fBbinary:Package\fP
It contains the binary package name with a possible architecture qualifier
like “libc6:amd64” (since dpkg 1.16.2).  An architecture qualifier will be
present to make the package name unambiguous, for example if the package has
a \fBMulti\-Arch\fP field with a value of \fBsame\fP or the package is of a foreign
architecture.
.TP 
\fBbinary:Summary\fP
Contiene la descrizione breve del pacchetto (a partire da dpkg 1.16.2).
.TP 
\fBdb:Status\-Abbrev\fP
It contains the abbreviated package status (as three characters), such as
“ii ” or “iHR” (since dpkg 1.16.2).  See the \fB\-\-list\fP command description
for more details.
.TP 
\fBdb:Status\-Want\fP
Contiene lo stato richiesto del pacchetto, parte del campo Status (a partire
da dpkg 1.17.11).
.TP 
\fBdb:Status\-Status\fP
Contiene la parola di stato del pacchetto, parte del campo Status (a partire
da dpkg 1.17.11).
.TP 
\fBdb:Status\-Eflag\fP
Contiene il contrassegno di errore di stato del pacchetto, parte del campo
Status (a partire da dpkg 1.17.11).
.TP 
\fBsource:Package\fP
Contiene il nome del pacchetto sorgente per questo pacchetto binario (a
partire da dpkg 1.16.2).
.TP 
\fBsource:Version\fP
Contiene la versione del pacchetto sorgente per questo pacchetto binario (a
partire da dpkg 1.16.2).
.TP 
\fBsource:Upstream\-Version\fP
It contains the source package upstream version for this binary package
(since dpkg 1.18.16)
.RE
.IP
La stringa di formato predefinita è
“\fB${binary:Package}\et${Version}\en\fP”. Di fatto, è possibile richiedere
anche tutti gli altri campi che si trovano nel file di stato (cioè i campi
definiti dall'utente). Verranno però stampati come sono, senza che vanga
fatta su di essi alcuna conversione o alcun controllo degli errori. Per
ottenere il nome del manutentore di \fBdpkg\fP e la versione installata si può
usare:

.nf
  \fBdpkg\-query \-W \-f='${binary:Package} ${Version}\et${Maintainer}\en' dpkg\fP
.fi
.
.SH "STATO D'USCITA"
.TP 
\fB0\fP
L'interrogazione richiesta è stata effettuata con successo.
.TP 
\fB1\fP
The requested query failed either fully or partially, due to no file or
package being found (except for \fB\-\-control\-path\fP, \fB\-\-control\-list\fP and
\fB\-\-control\-show\fP were such errors are fatal).
.TP 
\fB2\fP
Fatal or unrecoverable error due to invalid command\-line usage, or
interactions with the system, such as accesses to the database, memory
allocations, etc.
.
.SH AMBIENTE
.TP 
\fBDPKG_ADMINDIR\fP
Se impostata e l'opzione \fB\-\-admindir\fP non è stata specificata, verrà usata
come directory dei dati di \fBdpkg\fP.
.TP 
\fBCOLUMNS\fP
Questa impostazione influenza l'output dell'opzione \fB\-\-list\fP modificando la
larghezza del suo output.
.
.SH "VEDERE ANCHE"
\fBdpkg\fP(1).

