#! /bin/sh
# Copyright (C) 2005, 2006, 2007, 2012, 2013 Red Hat, Inc.
# Copyright (C) H.J. Lu <hjl.tools@gmail.com>, 2015.
# This file is part of elfutils.
#
# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# elfutils is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. $srcdir/test-subr.sh

regs_test()
{
  tempfiles good.regs
  cat > good.regs
  testfiles "$@"
  for f; do testrun_compare ${abs_builddir}/allregs -e $f < good.regs; done
  test_cleanup
}

regs_test testfile11 <<\EOF
integer registers:
	  0: %eax (eax), signed 32 bits
	  1: %ecx (ecx), signed 32 bits
	  2: %edx (edx), signed 32 bits
	  3: %ebx (ebx), signed 32 bits
	  4: %esp (esp), address 32 bits
	  5: %ebp (ebp), address 32 bits
	  6: %esi (esi), signed 32 bits
	  7: %edi (edi), signed 32 bits
	  8: %eip (eip), address 32 bits
	  9: %eflags (eflags), unsigned 32 bits
	 10: %trapno (trapno), unsigned 32 bits
FPU-control registers:
	 37: %fctrl (fctrl), unsigned 16 bits
	 38: %fstat (fstat), unsigned 16 bits
	 39: %mxcsr (mxcsr), unsigned 32 bits
MMX registers:
	 29: %mm0 (mm0), unsigned 64 bits
	 30: %mm1 (mm1), unsigned 64 bits
	 31: %mm2 (mm2), unsigned 64 bits
	 32: %mm3 (mm3), unsigned 64 bits
	 33: %mm4 (mm4), unsigned 64 bits
	 34: %mm5 (mm5), unsigned 64 bits
	 35: %mm6 (mm6), unsigned 64 bits
	 36: %mm7 (mm7), unsigned 64 bits
SSE registers:
	 21: %xmm0 (xmm0), unsigned 128 bits
	 22: %xmm1 (xmm1), unsigned 128 bits
	 23: %xmm2 (xmm2), unsigned 128 bits
	 24: %xmm3 (xmm3), unsigned 128 bits
	 25: %xmm4 (xmm4), unsigned 128 bits
	 26: %xmm5 (xmm5), unsigned 128 bits
	 27: %xmm6 (xmm6), unsigned 128 bits
	 28: %xmm7 (xmm7), unsigned 128 bits
segment registers:
	 40: %es (es), unsigned 16 bits
	 41: %cs (cs), unsigned 16 bits
	 42: %ss (ss), unsigned 16 bits
	 43: %ds (ds), unsigned 16 bits
	 44: %fs (fs), unsigned 16 bits
	 45: %gs (gs), unsigned 16 bits
x87 registers:
	 11: %st0 (st0), float 80 bits
	 12: %st1 (st1), float 80 bits
	 13: %st2 (st2), float 80 bits
	 14: %st3 (st3), float 80 bits
	 15: %st4 (st4), float 80 bits
	 16: %st5 (st5), float 80 bits
	 17: %st6 (st6), float 80 bits
	 18: %st7 (st7), float 80 bits
EOF

regs_test testfile12 <<\EOF
integer registers:
	  0: %rax (rax), signed 64 bits
	  1: %rdx (rdx), signed 64 bits
	  2: %rcx (rcx), signed 64 bits
	  3: %rbx (rbx), signed 64 bits
	  4: %rsi (rsi), signed 64 bits
	  5: %rdi (rdi), signed 64 bits
	  6: %rbp (rbp), address 64 bits
	  7: %rsp (rsp), address 64 bits
	  8: %r8 (r8), signed 64 bits
	  9: %r9 (r9), signed 64 bits
	 10: %r10 (r10), signed 64 bits
	 11: %r11 (r11), signed 64 bits
	 12: %r12 (r12), signed 64 bits
	 13: %r13 (r13), signed 64 bits
	 14: %r14 (r14), signed 64 bits
	 15: %r15 (r15), signed 64 bits
	 16: %rip (rip), address 64 bits
	 49: %rflags (rflags), unsigned 64 bits
MMX registers:
	 41: %mm0 (mm0), unsigned 64 bits
	 42: %mm1 (mm1), unsigned 64 bits
	 43: %mm2 (mm2), unsigned 64 bits
	 44: %mm3 (mm3), unsigned 64 bits
	 45: %mm4 (mm4), unsigned 64 bits
	 46: %mm5 (mm5), unsigned 64 bits
	 47: %mm6 (mm6), unsigned 64 bits
	 48: %mm7 (mm7), unsigned 64 bits
SSE registers:
	 17: %xmm0 (xmm0), unsigned 128 bits
	 18: %xmm1 (xmm1), unsigned 128 bits
	 19: %xmm2 (xmm2), unsigned 128 bits
	 20: %xmm3 (xmm3), unsigned 128 bits
	 21: %xmm4 (xmm4), unsigned 128 bits
	 22: %xmm5 (xmm5), unsigned 128 bits
	 23: %xmm6 (xmm6), unsigned 128 bits
	 24: %xmm7 (xmm7), unsigned 128 bits
	 25: %xmm8 (xmm8), unsigned 128 bits
	 26: %xmm9 (xmm9), unsigned 128 bits
	 27: %xmm10 (xmm10), unsigned 128 bits
	 28: %xmm11 (xmm11), unsigned 128 bits
	 29: %xmm12 (xmm12), unsigned 128 bits
	 30: %xmm13 (xmm13), unsigned 128 bits
	 31: %xmm14 (xmm14), unsigned 128 bits
	 32: %xmm15 (xmm15), unsigned 128 bits
control registers:
	 62: %tr (tr), unsigned 64 bits
	 63: %ldtr (ldtr), unsigned 64 bits
	 64: %mxcsr (mxcsr), unsigned 64 bits
	 65: %fcw (fcw), unsigned 16 bits
	 66: %fsw (fsw), unsigned 16 bits
segment registers:
	 50: %es (es), unsigned 16 bits
	 51: %cs (cs), unsigned 16 bits
	 52: %ss (ss), unsigned 16 bits
	 53: %ds (ds), unsigned 16 bits
	 54: %fs (fs), unsigned 16 bits
	 55: %gs (gs), unsigned 16 bits
	 58: %fs.base (fs.base), address 64 bits
	 59: %gs.base (gs.base), address 64 bits
x87 registers:
	 33: %st0 (st0), float 80 bits
	 34: %st1 (st1), float 80 bits
	 35: %st2 (st2), float 80 bits
	 36: %st3 (st3), float 80 bits
	 37: %st4 (st4), float 80 bits
	 38: %st5 (st5), float 80 bits
	 39: %st6 (st6), float 80 bits
	 40: %st7 (st7), float 80 bits
EOF

regs_test testfile2 <<\EOF
integer registers:
	  0: r0 (r0), signed 32 bits
	  1: r1 (r1), signed 32 bits
	  2: r2 (r2), signed 32 bits
	  3: r3 (r3), signed 32 bits
	  4: r4 (r4), signed 32 bits
	  5: r5 (r5), signed 32 bits
	  6: r6 (r6), signed 32 bits
	  7: r7 (r7), signed 32 bits
	  8: r8 (r8), signed 32 bits
	  9: r9 (r9), signed 32 bits
	 10: r10 (r10), signed 32 bits
	 11: r11 (r11), signed 32 bits
	 12: r12 (r12), signed 32 bits
	 13: r13 (r13), signed 32 bits
	 14: r14 (r14), signed 32 bits
	 15: r15 (r15), signed 32 bits
	 16: r16 (r16), signed 32 bits
	 17: r17 (r17), signed 32 bits
	 18: r18 (r18), signed 32 bits
	 19: r19 (r19), signed 32 bits
	 20: r20 (r20), signed 32 bits
	 21: r21 (r21), signed 32 bits
	 22: r22 (r22), signed 32 bits
	 23: r23 (r23), signed 32 bits
	 24: r24 (r24), signed 32 bits
	 25: r25 (r25), signed 32 bits
	 26: r26 (r26), signed 32 bits
	 27: r27 (r27), signed 32 bits
	 28: r28 (r28), signed 32 bits
	 29: r29 (r29), signed 32 bits
	 30: r30 (r30), signed 32 bits
	 31: r31 (r31), signed 32 bits
	 64: cr (cr), unsigned 32 bits
	 66: msr (msr), unsigned 32 bits
FPU registers:
	 32: f0 (f0), float 64 bits
	 33: f1 (f1), float 64 bits
	 34: f2 (f2), float 64 bits
	 35: f3 (f3), float 64 bits
	 36: f4 (f4), float 64 bits
	 37: f5 (f5), float 64 bits
	 38: f6 (f6), float 64 bits
	 39: f7 (f7), float 64 bits
	 40: f8 (f8), float 64 bits
	 41: f9 (f9), float 64 bits
	 42: f10 (f10), float 64 bits
	 43: f11 (f11), float 64 bits
	 44: f12 (f12), float 64 bits
	 45: f13 (f13), float 64 bits
	 46: f14 (f14), float 64 bits
	 47: f15 (f15), float 64 bits
	 48: f16 (f16), float 64 bits
	 49: f17 (f17), float 64 bits
	 50: f18 (f18), float 64 bits
	 51: f19 (f19), float 64 bits
	 52: f20 (f20), float 64 bits
	 53: f21 (f21), float 64 bits
	 54: f22 (f22), float 64 bits
	 55: f23 (f23), float 64 bits
	 56: f24 (f24), float 64 bits
	 57: f25 (f25), float 64 bits
	 58: f26 (f26), float 64 bits
	 59: f27 (f27), float 64 bits
	 60: f28 (f28), float 64 bits
	 61: f29 (f29), float 64 bits
	 62: f30 (f30), float 64 bits
	 63: f31 (f31), float 64 bits
	 65: fpscr (fpscr), unsigned 32 bits
privileged registers:
	 70: sr0 (sr0), unsigned 32 bits
	 71: sr1 (sr1), unsigned 32 bits
	 72: sr2 (sr2), unsigned 32 bits
	 73: sr3 (sr3), unsigned 32 bits
	 74: sr4 (sr4), unsigned 32 bits
	 75: sr5 (sr5), unsigned 32 bits
	 76: sr6 (sr6), unsigned 32 bits
	 77: sr7 (sr7), unsigned 32 bits
	 78: sr8 (sr8), unsigned 32 bits
	 79: sr9 (sr9), unsigned 32 bits
	 80: sr10 (sr10), unsigned 32 bits
	 81: sr11 (sr11), unsigned 32 bits
	 82: sr12 (sr12), unsigned 32 bits
	 83: sr13 (sr13), unsigned 32 bits
	 84: sr14 (sr14), unsigned 32 bits
	 85: sr15 (sr15), unsigned 32 bits
	100: mq (mq), unsigned 32 bits
	101: xer (xer), unsigned 32 bits
	102: spr2 (spr2), unsigned 32 bits
	103: spr3 (spr3), unsigned 32 bits
	104: spr4 (spr4), unsigned 32 bits
	105: spr5 (spr5), unsigned 32 bits
	106: spr6 (spr6), unsigned 32 bits
	107: spr7 (spr7), unsigned 32 bits
	108: lr (lr), unsigned 32 bits
	109: ctr (ctr), unsigned 32 bits
	110: spr10 (spr10), unsigned 32 bits
	111: spr11 (spr11), unsigned 32 bits
	112: spr12 (spr12), unsigned 32 bits
	113: spr13 (spr13), unsigned 32 bits
	114: spr14 (spr14), unsigned 32 bits
	115: spr15 (spr15), unsigned 32 bits
	116: spr16 (spr16), unsigned 32 bits
	117: spr17 (spr17), unsigned 32 bits
	118: dsisr (dsisr), unsigned 32 bits
	119: dar (dar), unsigned 32 bits
	120: spr20 (spr20), unsigned 32 bits
	121: spr21 (spr21), unsigned 32 bits
	122: dec (dec), unsigned 32 bits
	123: spr23 (spr23), unsigned 32 bits
	124: spr24 (spr24), unsigned 32 bits
	125: spr25 (spr25), unsigned 32 bits
	126: spr26 (spr26), unsigned 32 bits
	127: spr27 (spr27), unsigned 32 bits
	128: spr28 (spr28), unsigned 32 bits
	129: spr29 (spr29), unsigned 32 bits
	130: spr30 (spr30), unsigned 32 bits
	131: spr31 (spr31), unsigned 32 bits
	132: spr32 (spr32), unsigned 32 bits
	133: spr33 (spr33), unsigned 32 bits
	134: spr34 (spr34), unsigned 32 bits
	135: spr35 (spr35), unsigned 32 bits
	136: spr36 (spr36), unsigned 32 bits
	137: spr37 (spr37), unsigned 32 bits
	138: spr38 (spr38), unsigned 32 bits
	139: spr39 (spr39), unsigned 32 bits
	140: spr40 (spr40), unsigned 32 bits
	141: spr41 (spr41), unsigned 32 bits
	142: spr42 (spr42), unsigned 32 bits
	143: spr43 (spr43), unsigned 32 bits
	144: spr44 (spr44), unsigned 32 bits
	145: spr45 (spr45), unsigned 32 bits
	146: spr46 (spr46), unsigned 32 bits
	147: spr47 (spr47), unsigned 32 bits
	148: spr48 (spr48), unsigned 32 bits
	149: spr49 (spr49), unsigned 32 bits
	150: spr50 (spr50), unsigned 32 bits
	151: spr51 (spr51), unsigned 32 bits
	152: spr52 (spr52), unsigned 32 bits
	153: spr53 (spr53), unsigned 32 bits
	154: spr54 (spr54), unsigned 32 bits
	155: spr55 (spr55), unsigned 32 bits
	156: spr56 (spr56), unsigned 32 bits
	157: spr57 (spr57), unsigned 32 bits
	158: spr58 (spr58), unsigned 32 bits
	159: spr59 (spr59), unsigned 32 bits
	160: spr60 (spr60), unsigned 32 bits
	161: spr61 (spr61), unsigned 32 bits
	162: spr62 (spr62), unsigned 32 bits
	163: spr63 (spr63), unsigned 32 bits
	164: spr64 (spr64), unsigned 32 bits
	165: spr65 (spr65), unsigned 32 bits
	166: spr66 (spr66), unsigned 32 bits
	167: spr67 (spr67), unsigned 32 bits
	168: spr68 (spr68), unsigned 32 bits
	169: spr69 (spr69), unsigned 32 bits
	170: spr70 (spr70), unsigned 32 bits
	171: spr71 (spr71), unsigned 32 bits
	172: spr72 (spr72), unsigned 32 bits
	173: spr73 (spr73), unsigned 32 bits
	174: spr74 (spr74), unsigned 32 bits
	175: spr75 (spr75), unsigned 32 bits
	176: spr76 (spr76), unsigned 32 bits
	177: spr77 (spr77), unsigned 32 bits
	178: spr78 (spr78), unsigned 32 bits
	179: spr79 (spr79), unsigned 32 bits
	180: spr80 (spr80), unsigned 32 bits
	181: spr81 (spr81), unsigned 32 bits
	182: spr82 (spr82), unsigned 32 bits
	183: spr83 (spr83), unsigned 32 bits
	184: spr84 (spr84), unsigned 32 bits
	185: spr85 (spr85), unsigned 32 bits
	186: spr86 (spr86), unsigned 32 bits
	187: spr87 (spr87), unsigned 32 bits
	188: spr88 (spr88), unsigned 32 bits
	189: spr89 (spr89), unsigned 32 bits
	190: spr90 (spr90), unsigned 32 bits
	191: spr91 (spr91), unsigned 32 bits
	192: spr92 (spr92), unsigned 32 bits
	193: spr93 (spr93), unsigned 32 bits
	194: spr94 (spr94), unsigned 32 bits
	195: spr95 (spr95), unsigned 32 bits
	196: spr96 (spr96), unsigned 32 bits
	197: spr97 (spr97), unsigned 32 bits
	198: spr98 (spr98), unsigned 32 bits
	199: spr99 (spr99), unsigned 32 bits
	200: spr100 (spr100), unsigned 32 bits
	201: spr101 (spr101), unsigned 32 bits
	202: spr102 (spr102), unsigned 32 bits
	203: spr103 (spr103), unsigned 32 bits
	204: spr104 (spr104), unsigned 32 bits
	205: spr105 (spr105), unsigned 32 bits
	206: spr106 (spr106), unsigned 32 bits
	207: spr107 (spr107), unsigned 32 bits
	208: spr108 (spr108), unsigned 32 bits
	209: spr109 (spr109), unsigned 32 bits
	210: spr110 (spr110), unsigned 32 bits
	211: spr111 (spr111), unsigned 32 bits
	212: spr112 (spr112), unsigned 32 bits
	213: spr113 (spr113), unsigned 32 bits
	214: spr114 (spr114), unsigned 32 bits
	215: spr115 (spr115), unsigned 32 bits
	216: spr116 (spr116), unsigned 32 bits
	217: spr117 (spr117), unsigned 32 bits
	218: spr118 (spr118), unsigned 32 bits
	219: spr119 (spr119), unsigned 32 bits
	220: spr120 (spr120), unsigned 32 bits
	221: spr121 (spr121), unsigned 32 bits
	222: spr122 (spr122), unsigned 32 bits
	223: spr123 (spr123), unsigned 32 bits
	224: spr124 (spr124), unsigned 32 bits
	225: spr125 (spr125), unsigned 32 bits
	226: spr126 (spr126), unsigned 32 bits
	227: spr127 (spr127), unsigned 32 bits
	228: spr128 (spr128), unsigned 32 bits
	229: spr129 (spr129), unsigned 32 bits
	230: spr130 (spr130), unsigned 32 bits
	231: spr131 (spr131), unsigned 32 bits
	232: spr132 (spr132), unsigned 32 bits
	233: spr133 (spr133), unsigned 32 bits
	234: spr134 (spr134), unsigned 32 bits
	235: spr135 (spr135), unsigned 32 bits
	236: spr136 (spr136), unsigned 32 bits
	237: spr137 (spr137), unsigned 32 bits
	238: spr138 (spr138), unsigned 32 bits
	239: spr139 (spr139), unsigned 32 bits
	240: spr140 (spr140), unsigned 32 bits
	241: spr141 (spr141), unsigned 32 bits
	242: spr142 (spr142), unsigned 32 bits
	243: spr143 (spr143), unsigned 32 bits
	244: spr144 (spr144), unsigned 32 bits
	245: spr145 (spr145), unsigned 32 bits
	246: spr146 (spr146), unsigned 32 bits
	247: spr147 (spr147), unsigned 32 bits
	248: spr148 (spr148), unsigned 32 bits
	249: spr149 (spr149), unsigned 32 bits
	250: spr150 (spr150), unsigned 32 bits
	251: spr151 (spr151), unsigned 32 bits
	252: spr152 (spr152), unsigned 32 bits
	253: spr153 (spr153), unsigned 32 bits
	254: spr154 (spr154), unsigned 32 bits
	255: spr155 (spr155), unsigned 32 bits
	256: spr156 (spr156), unsigned 32 bits
	257: spr157 (spr157), unsigned 32 bits
	258: spr158 (spr158), unsigned 32 bits
	259: spr159 (spr159), unsigned 32 bits
	260: spr160 (spr160), unsigned 32 bits
	261: spr161 (spr161), unsigned 32 bits
	262: spr162 (spr162), unsigned 32 bits
	263: spr163 (spr163), unsigned 32 bits
	264: spr164 (spr164), unsigned 32 bits
	265: spr165 (spr165), unsigned 32 bits
	266: spr166 (spr166), unsigned 32 bits
	267: spr167 (spr167), unsigned 32 bits
	268: spr168 (spr168), unsigned 32 bits
	269: spr169 (spr169), unsigned 32 bits
	270: spr170 (spr170), unsigned 32 bits
	271: spr171 (spr171), unsigned 32 bits
	272: spr172 (spr172), unsigned 32 bits
	273: spr173 (spr173), unsigned 32 bits
	274: spr174 (spr174), unsigned 32 bits
	275: spr175 (spr175), unsigned 32 bits
	276: spr176 (spr176), unsigned 32 bits
	277: spr177 (spr177), unsigned 32 bits
	278: spr178 (spr178), unsigned 32 bits
	279: spr179 (spr179), unsigned 32 bits
	280: spr180 (spr180), unsigned 32 bits
	281: spr181 (spr181), unsigned 32 bits
	282: spr182 (spr182), unsigned 32 bits
	283: spr183 (spr183), unsigned 32 bits
	284: spr184 (spr184), unsigned 32 bits
	285: spr185 (spr185), unsigned 32 bits
	286: spr186 (spr186), unsigned 32 bits
	287: spr187 (spr187), unsigned 32 bits
	288: spr188 (spr188), unsigned 32 bits
	289: spr189 (spr189), unsigned 32 bits
	290: spr190 (spr190), unsigned 32 bits
	291: spr191 (spr191), unsigned 32 bits
	292: spr192 (spr192), unsigned 32 bits
	293: spr193 (spr193), unsigned 32 bits
	294: spr194 (spr194), unsigned 32 bits
	295: spr195 (spr195), unsigned 32 bits
	296: spr196 (spr196), unsigned 32 bits
	297: spr197 (spr197), unsigned 32 bits
	298: spr198 (spr198), unsigned 32 bits
	299: spr199 (spr199), unsigned 32 bits
	300: spr200 (spr200), unsigned 32 bits
	301: spr201 (spr201), unsigned 32 bits
	302: spr202 (spr202), unsigned 32 bits
	303: spr203 (spr203), unsigned 32 bits
	304: spr204 (spr204), unsigned 32 bits
	305: spr205 (spr205), unsigned 32 bits
	306: spr206 (spr206), unsigned 32 bits
	307: spr207 (spr207), unsigned 32 bits
	308: spr208 (spr208), unsigned 32 bits
	309: spr209 (spr209), unsigned 32 bits
	310: spr210 (spr210), unsigned 32 bits
	311: spr211 (spr211), unsigned 32 bits
	312: spr212 (spr212), unsigned 32 bits
	313: spr213 (spr213), unsigned 32 bits
	314: spr214 (spr214), unsigned 32 bits
	315: spr215 (spr215), unsigned 32 bits
	316: spr216 (spr216), unsigned 32 bits
	317: spr217 (spr217), unsigned 32 bits
	318: spr218 (spr218), unsigned 32 bits
	319: spr219 (spr219), unsigned 32 bits
	320: spr220 (spr220), unsigned 32 bits
	321: spr221 (spr221), unsigned 32 bits
	322: spr222 (spr222), unsigned 32 bits
	323: spr223 (spr223), unsigned 32 bits
	324: spr224 (spr224), unsigned 32 bits
	325: spr225 (spr225), unsigned 32 bits
	326: spr226 (spr226), unsigned 32 bits
	327: spr227 (spr227), unsigned 32 bits
	328: spr228 (spr228), unsigned 32 bits
	329: spr229 (spr229), unsigned 32 bits
	330: spr230 (spr230), unsigned 32 bits
	331: spr231 (spr231), unsigned 32 bits
	332: spr232 (spr232), unsigned 32 bits
	333: spr233 (spr233), unsigned 32 bits
	334: spr234 (spr234), unsigned 32 bits
	335: spr235 (spr235), unsigned 32 bits
	336: spr236 (spr236), unsigned 32 bits
	337: spr237 (spr237), unsigned 32 bits
	338: spr238 (spr238), unsigned 32 bits
	339: spr239 (spr239), unsigned 32 bits
	340: spr240 (spr240), unsigned 32 bits
	341: spr241 (spr241), unsigned 32 bits
	342: spr242 (spr242), unsigned 32 bits
	343: spr243 (spr243), unsigned 32 bits
	344: spr244 (spr244), unsigned 32 bits
	345: spr245 (spr245), unsigned 32 bits
	346: spr246 (spr246), unsigned 32 bits
	347: spr247 (spr247), unsigned 32 bits
	348: spr248 (spr248), unsigned 32 bits
	349: spr249 (spr249), unsigned 32 bits
	350: spr250 (spr250), unsigned 32 bits
	351: spr251 (spr251), unsigned 32 bits
	352: spr252 (spr252), unsigned 32 bits
	353: spr253 (spr253), unsigned 32 bits
	354: spr254 (spr254), unsigned 32 bits
	355: spr255 (spr255), unsigned 32 bits
	357: spr257 (spr257), unsigned 32 bits
	358: spr258 (spr258), unsigned 32 bits
	359: spr259 (spr259), unsigned 32 bits
	360: spr260 (spr260), unsigned 32 bits
	361: spr261 (spr261), unsigned 32 bits
	362: spr262 (spr262), unsigned 32 bits
	363: spr263 (spr263), unsigned 32 bits
	364: spr264 (spr264), unsigned 32 bits
	365: spr265 (spr265), unsigned 32 bits
	366: spr266 (spr266), unsigned 32 bits
	367: spr267 (spr267), unsigned 32 bits
	368: spr268 (spr268), unsigned 32 bits
	369: spr269 (spr269), unsigned 32 bits
	370: spr270 (spr270), unsigned 32 bits
	371: spr271 (spr271), unsigned 32 bits
	372: spr272 (spr272), unsigned 32 bits
	373: spr273 (spr273), unsigned 32 bits
	374: spr274 (spr274), unsigned 32 bits
	375: spr275 (spr275), unsigned 32 bits
	376: spr276 (spr276), unsigned 32 bits
	377: spr277 (spr277), unsigned 32 bits
	378: spr278 (spr278), unsigned 32 bits
	379: spr279 (spr279), unsigned 32 bits
	380: spr280 (spr280), unsigned 32 bits
	381: spr281 (spr281), unsigned 32 bits
	382: spr282 (spr282), unsigned 32 bits
	383: spr283 (spr283), unsigned 32 bits
	384: spr284 (spr284), unsigned 32 bits
	385: spr285 (spr285), unsigned 32 bits
	386: spr286 (spr286), unsigned 32 bits
	387: spr287 (spr287), unsigned 32 bits
	388: spr288 (spr288), unsigned 32 bits
	389: spr289 (spr289), unsigned 32 bits
	390: spr290 (spr290), unsigned 32 bits
	391: spr291 (spr291), unsigned 32 bits
	392: spr292 (spr292), unsigned 32 bits
	393: spr293 (spr293), unsigned 32 bits
	394: spr294 (spr294), unsigned 32 bits
	395: spr295 (spr295), unsigned 32 bits
	396: spr296 (spr296), unsigned 32 bits
	397: spr297 (spr297), unsigned 32 bits
	398: spr298 (spr298), unsigned 32 bits
	399: spr299 (spr299), unsigned 32 bits
	400: spr300 (spr300), unsigned 32 bits
	401: spr301 (spr301), unsigned 32 bits
	402: spr302 (spr302), unsigned 32 bits
	403: spr303 (spr303), unsigned 32 bits
	404: spr304 (spr304), unsigned 32 bits
	405: spr305 (spr305), unsigned 32 bits
	406: spr306 (spr306), unsigned 32 bits
	407: spr307 (spr307), unsigned 32 bits
	408: spr308 (spr308), unsigned 32 bits
	409: spr309 (spr309), unsigned 32 bits
	410: spr310 (spr310), unsigned 32 bits
	411: spr311 (spr311), unsigned 32 bits
	412: spr312 (spr312), unsigned 32 bits
	413: spr313 (spr313), unsigned 32 bits
	414: spr314 (spr314), unsigned 32 bits
	415: spr315 (spr315), unsigned 32 bits
	416: spr316 (spr316), unsigned 32 bits
	417: spr317 (spr317), unsigned 32 bits
	418: spr318 (spr318), unsigned 32 bits
	419: spr319 (spr319), unsigned 32 bits
	420: spr320 (spr320), unsigned 32 bits
	421: spr321 (spr321), unsigned 32 bits
	422: spr322 (spr322), unsigned 32 bits
	423: spr323 (spr323), unsigned 32 bits
	424: spr324 (spr324), unsigned 32 bits
	425: spr325 (spr325), unsigned 32 bits
	426: spr326 (spr326), unsigned 32 bits
	427: spr327 (spr327), unsigned 32 bits
	428: spr328 (spr328), unsigned 32 bits
	429: spr329 (spr329), unsigned 32 bits
	430: spr330 (spr330), unsigned 32 bits
	431: spr331 (spr331), unsigned 32 bits
	432: spr332 (spr332), unsigned 32 bits
	433: spr333 (spr333), unsigned 32 bits
	434: spr334 (spr334), unsigned 32 bits
	435: spr335 (spr335), unsigned 32 bits
	436: spr336 (spr336), unsigned 32 bits
	437: spr337 (spr337), unsigned 32 bits
	438: spr338 (spr338), unsigned 32 bits
	439: spr339 (spr339), unsigned 32 bits
	440: spr340 (spr340), unsigned 32 bits
	441: spr341 (spr341), unsigned 32 bits
	442: spr342 (spr342), unsigned 32 bits
	443: spr343 (spr343), unsigned 32 bits
	444: spr344 (spr344), unsigned 32 bits
	445: spr345 (spr345), unsigned 32 bits
	446: spr346 (spr346), unsigned 32 bits
	447: spr347 (spr347), unsigned 32 bits
	448: spr348 (spr348), unsigned 32 bits
	449: spr349 (spr349), unsigned 32 bits
	450: spr350 (spr350), unsigned 32 bits
	451: spr351 (spr351), unsigned 32 bits
	452: spr352 (spr352), unsigned 32 bits
	453: spr353 (spr353), unsigned 32 bits
	454: spr354 (spr354), unsigned 32 bits
	455: spr355 (spr355), unsigned 32 bits
	456: spr356 (spr356), unsigned 32 bits
	457: spr357 (spr357), unsigned 32 bits
	458: spr358 (spr358), unsigned 32 bits
	459: spr359 (spr359), unsigned 32 bits
	460: spr360 (spr360), unsigned 32 bits
	461: spr361 (spr361), unsigned 32 bits
	462: spr362 (spr362), unsigned 32 bits
	463: spr363 (spr363), unsigned 32 bits
	464: spr364 (spr364), unsigned 32 bits
	465: spr365 (spr365), unsigned 32 bits
	466: spr366 (spr366), unsigned 32 bits
	467: spr367 (spr367), unsigned 32 bits
	468: spr368 (spr368), unsigned 32 bits
	469: spr369 (spr369), unsigned 32 bits
	470: spr370 (spr370), unsigned 32 bits
	471: spr371 (spr371), unsigned 32 bits
	472: spr372 (spr372), unsigned 32 bits
	473: spr373 (spr373), unsigned 32 bits
	474: spr374 (spr374), unsigned 32 bits
	475: spr375 (spr375), unsigned 32 bits
	476: spr376 (spr376), unsigned 32 bits
	477: spr377 (spr377), unsigned 32 bits
	478: spr378 (spr378), unsigned 32 bits
	479: spr379 (spr379), unsigned 32 bits
	480: spr380 (spr380), unsigned 32 bits
	481: spr381 (spr381), unsigned 32 bits
	482: spr382 (spr382), unsigned 32 bits
	483: spr383 (spr383), unsigned 32 bits
	484: spr384 (spr384), unsigned 32 bits
	485: spr385 (spr385), unsigned 32 bits
	486: spr386 (spr386), unsigned 32 bits
	487: spr387 (spr387), unsigned 32 bits
	488: spr388 (spr388), unsigned 32 bits
	489: spr389 (spr389), unsigned 32 bits
	490: spr390 (spr390), unsigned 32 bits
	491: spr391 (spr391), unsigned 32 bits
	492: spr392 (spr392), unsigned 32 bits
	493: spr393 (spr393), unsigned 32 bits
	494: spr394 (spr394), unsigned 32 bits
	495: spr395 (spr395), unsigned 32 bits
	496: spr396 (spr396), unsigned 32 bits
	497: spr397 (spr397), unsigned 32 bits
	498: spr398 (spr398), unsigned 32 bits
	499: spr399 (spr399), unsigned 32 bits
	500: spr400 (spr400), unsigned 32 bits
	501: spr401 (spr401), unsigned 32 bits
	502: spr402 (spr402), unsigned 32 bits
	503: spr403 (spr403), unsigned 32 bits
	504: spr404 (spr404), unsigned 32 bits
	505: spr405 (spr405), unsigned 32 bits
	506: spr406 (spr406), unsigned 32 bits
	507: spr407 (spr407), unsigned 32 bits
	508: spr408 (spr408), unsigned 32 bits
	509: spr409 (spr409), unsigned 32 bits
	510: spr410 (spr410), unsigned 32 bits
	511: spr411 (spr411), unsigned 32 bits
	512: spr412 (spr412), unsigned 32 bits
	513: spr413 (spr413), unsigned 32 bits
	514: spr414 (spr414), unsigned 32 bits
	515: spr415 (spr415), unsigned 32 bits
	516: spr416 (spr416), unsigned 32 bits
	517: spr417 (spr417), unsigned 32 bits
	518: spr418 (spr418), unsigned 32 bits
	519: spr419 (spr419), unsigned 32 bits
	520: spr420 (spr420), unsigned 32 bits
	521: spr421 (spr421), unsigned 32 bits
	522: spr422 (spr422), unsigned 32 bits
	523: spr423 (spr423), unsigned 32 bits
	524: spr424 (spr424), unsigned 32 bits
	525: spr425 (spr425), unsigned 32 bits
	526: spr426 (spr426), unsigned 32 bits
	527: spr427 (spr427), unsigned 32 bits
	528: spr428 (spr428), unsigned 32 bits
	529: spr429 (spr429), unsigned 32 bits
	530: spr430 (spr430), unsigned 32 bits
	531: spr431 (spr431), unsigned 32 bits
	532: spr432 (spr432), unsigned 32 bits
	533: spr433 (spr433), unsigned 32 bits
	534: spr434 (spr434), unsigned 32 bits
	535: spr435 (spr435), unsigned 32 bits
	536: spr436 (spr436), unsigned 32 bits
	537: spr437 (spr437), unsigned 32 bits
	538: spr438 (spr438), unsigned 32 bits
	539: spr439 (spr439), unsigned 32 bits
	540: spr440 (spr440), unsigned 32 bits
	541: spr441 (spr441), unsigned 32 bits
	542: spr442 (spr442), unsigned 32 bits
	543: spr443 (spr443), unsigned 32 bits
	544: spr444 (spr444), unsigned 32 bits
	545: spr445 (spr445), unsigned 32 bits
	546: spr446 (spr446), unsigned 32 bits
	547: spr447 (spr447), unsigned 32 bits
	548: spr448 (spr448), unsigned 32 bits
	549: spr449 (spr449), unsigned 32 bits
	550: spr450 (spr450), unsigned 32 bits
	551: spr451 (spr451), unsigned 32 bits
	552: spr452 (spr452), unsigned 32 bits
	553: spr453 (spr453), unsigned 32 bits
	554: spr454 (spr454), unsigned 32 bits
	555: spr455 (spr455), unsigned 32 bits
	556: spr456 (spr456), unsigned 32 bits
	557: spr457 (spr457), unsigned 32 bits
	558: spr458 (spr458), unsigned 32 bits
	559: spr459 (spr459), unsigned 32 bits
	560: spr460 (spr460), unsigned 32 bits
	561: spr461 (spr461), unsigned 32 bits
	562: spr462 (spr462), unsigned 32 bits
	563: spr463 (spr463), unsigned 32 bits
	564: spr464 (spr464), unsigned 32 bits
	565: spr465 (spr465), unsigned 32 bits
	566: spr466 (spr466), unsigned 32 bits
	567: spr467 (spr467), unsigned 32 bits
	568: spr468 (spr468), unsigned 32 bits
	569: spr469 (spr469), unsigned 32 bits
	570: spr470 (spr470), unsigned 32 bits
	571: spr471 (spr471), unsigned 32 bits
	572: spr472 (spr472), unsigned 32 bits
	573: spr473 (spr473), unsigned 32 bits
	574: spr474 (spr474), unsigned 32 bits
	575: spr475 (spr475), unsigned 32 bits
	576: spr476 (spr476), unsigned 32 bits
	577: spr477 (spr477), unsigned 32 bits
	578: spr478 (spr478), unsigned 32 bits
	579: spr479 (spr479), unsigned 32 bits
	580: spr480 (spr480), unsigned 32 bits
	581: spr481 (spr481), unsigned 32 bits
	582: spr482 (spr482), unsigned 32 bits
	583: spr483 (spr483), unsigned 32 bits
	584: spr484 (spr484), unsigned 32 bits
	585: spr485 (spr485), unsigned 32 bits
	586: spr486 (spr486), unsigned 32 bits
	587: spr487 (spr487), unsigned 32 bits
	588: spr488 (spr488), unsigned 32 bits
	589: spr489 (spr489), unsigned 32 bits
	590: spr490 (spr490), unsigned 32 bits
	591: spr491 (spr491), unsigned 32 bits
	592: spr492 (spr492), unsigned 32 bits
	593: spr493 (spr493), unsigned 32 bits
	594: spr494 (spr494), unsigned 32 bits
	595: spr495 (spr495), unsigned 32 bits
	596: spr496 (spr496), unsigned 32 bits
	597: spr497 (spr497), unsigned 32 bits
	598: spr498 (spr498), unsigned 32 bits
	599: spr499 (spr499), unsigned 32 bits
	600: spr500 (spr500), unsigned 32 bits
	601: spr501 (spr501), unsigned 32 bits
	602: spr502 (spr502), unsigned 32 bits
	603: spr503 (spr503), unsigned 32 bits
	604: spr504 (spr504), unsigned 32 bits
	605: spr505 (spr505), unsigned 32 bits
	606: spr506 (spr506), unsigned 32 bits
	607: spr507 (spr507), unsigned 32 bits
	608: spr508 (spr508), unsigned 32 bits
	609: spr509 (spr509), unsigned 32 bits
	610: spr510 (spr510), unsigned 32 bits
	611: spr511 (spr511), unsigned 32 bits
	613: spr513 (spr513), unsigned 32 bits
	614: spr514 (spr514), unsigned 32 bits
	615: spr515 (spr515), unsigned 32 bits
	616: spr516 (spr516), unsigned 32 bits
	617: spr517 (spr517), unsigned 32 bits
	618: spr518 (spr518), unsigned 32 bits
	619: spr519 (spr519), unsigned 32 bits
	620: spr520 (spr520), unsigned 32 bits
	621: spr521 (spr521), unsigned 32 bits
	622: spr522 (spr522), unsigned 32 bits
	623: spr523 (spr523), unsigned 32 bits
	624: spr524 (spr524), unsigned 32 bits
	625: spr525 (spr525), unsigned 32 bits
	626: spr526 (spr526), unsigned 32 bits
	627: spr527 (spr527), unsigned 32 bits
	628: spr528 (spr528), unsigned 32 bits
	629: spr529 (spr529), unsigned 32 bits
	630: spr530 (spr530), unsigned 32 bits
	631: spr531 (spr531), unsigned 32 bits
	632: spr532 (spr532), unsigned 32 bits
	633: spr533 (spr533), unsigned 32 bits
	634: spr534 (spr534), unsigned 32 bits
	635: spr535 (spr535), unsigned 32 bits
	636: spr536 (spr536), unsigned 32 bits
	637: spr537 (spr537), unsigned 32 bits
	638: spr538 (spr538), unsigned 32 bits
	639: spr539 (spr539), unsigned 32 bits
	640: spr540 (spr540), unsigned 32 bits
	641: spr541 (spr541), unsigned 32 bits
	642: spr542 (spr542), unsigned 32 bits
	643: spr543 (spr543), unsigned 32 bits
	644: spr544 (spr544), unsigned 32 bits
	645: spr545 (spr545), unsigned 32 bits
	646: spr546 (spr546), unsigned 32 bits
	647: spr547 (spr547), unsigned 32 bits
	648: spr548 (spr548), unsigned 32 bits
	649: spr549 (spr549), unsigned 32 bits
	650: spr550 (spr550), unsigned 32 bits
	651: spr551 (spr551), unsigned 32 bits
	652: spr552 (spr552), unsigned 32 bits
	653: spr553 (spr553), unsigned 32 bits
	654: spr554 (spr554), unsigned 32 bits
	655: spr555 (spr555), unsigned 32 bits
	656: spr556 (spr556), unsigned 32 bits
	657: spr557 (spr557), unsigned 32 bits
	658: spr558 (spr558), unsigned 32 bits
	659: spr559 (spr559), unsigned 32 bits
	660: spr560 (spr560), unsigned 32 bits
	661: spr561 (spr561), unsigned 32 bits
	662: spr562 (spr562), unsigned 32 bits
	663: spr563 (spr563), unsigned 32 bits
	664: spr564 (spr564), unsigned 32 bits
	665: spr565 (spr565), unsigned 32 bits
	666: spr566 (spr566), unsigned 32 bits
	667: spr567 (spr567), unsigned 32 bits
	668: spr568 (spr568), unsigned 32 bits
	669: spr569 (spr569), unsigned 32 bits
	670: spr570 (spr570), unsigned 32 bits
	671: spr571 (spr571), unsigned 32 bits
	672: spr572 (spr572), unsigned 32 bits
	673: spr573 (spr573), unsigned 32 bits
	674: spr574 (spr574), unsigned 32 bits
	675: spr575 (spr575), unsigned 32 bits
	676: spr576 (spr576), unsigned 32 bits
	677: spr577 (spr577), unsigned 32 bits
	678: spr578 (spr578), unsigned 32 bits
	679: spr579 (spr579), unsigned 32 bits
	680: spr580 (spr580), unsigned 32 bits
	681: spr581 (spr581), unsigned 32 bits
	682: spr582 (spr582), unsigned 32 bits
	683: spr583 (spr583), unsigned 32 bits
	684: spr584 (spr584), unsigned 32 bits
	685: spr585 (spr585), unsigned 32 bits
	686: spr586 (spr586), unsigned 32 bits
	687: spr587 (spr587), unsigned 32 bits
	688: spr588 (spr588), unsigned 32 bits
	689: spr589 (spr589), unsigned 32 bits
	690: spr590 (spr590), unsigned 32 bits
	691: spr591 (spr591), unsigned 32 bits
	692: spr592 (spr592), unsigned 32 bits
	693: spr593 (spr593), unsigned 32 bits
	694: spr594 (spr594), unsigned 32 bits
	695: spr595 (spr595), unsigned 32 bits
	696: spr596 (spr596), unsigned 32 bits
	697: spr597 (spr597), unsigned 32 bits
	698: spr598 (spr598), unsigned 32 bits
	699: spr599 (spr599), unsigned 32 bits
	700: spr600 (spr600), unsigned 32 bits
	701: spr601 (spr601), unsigned 32 bits
	702: spr602 (spr602), unsigned 32 bits
	703: spr603 (spr603), unsigned 32 bits
	704: spr604 (spr604), unsigned 32 bits
	705: spr605 (spr605), unsigned 32 bits
	706: spr606 (spr606), unsigned 32 bits
	707: spr607 (spr607), unsigned 32 bits
	708: spr608 (spr608), unsigned 32 bits
	709: spr609 (spr609), unsigned 32 bits
	710: spr610 (spr610), unsigned 32 bits
	711: spr611 (spr611), unsigned 32 bits
	712: spr612 (spr612), unsigned 32 bits
	713: spr613 (spr613), unsigned 32 bits
	714: spr614 (spr614), unsigned 32 bits
	715: spr615 (spr615), unsigned 32 bits
	716: spr616 (spr616), unsigned 32 bits
	717: spr617 (spr617), unsigned 32 bits
	718: spr618 (spr618), unsigned 32 bits
	719: spr619 (spr619), unsigned 32 bits
	720: spr620 (spr620), unsigned 32 bits
	721: spr621 (spr621), unsigned 32 bits
	722: spr622 (spr622), unsigned 32 bits
	723: spr623 (spr623), unsigned 32 bits
	724: spr624 (spr624), unsigned 32 bits
	725: spr625 (spr625), unsigned 32 bits
	726: spr626 (spr626), unsigned 32 bits
	727: spr627 (spr627), unsigned 32 bits
	728: spr628 (spr628), unsigned 32 bits
	729: spr629 (spr629), unsigned 32 bits
	730: spr630 (spr630), unsigned 32 bits
	731: spr631 (spr631), unsigned 32 bits
	732: spr632 (spr632), unsigned 32 bits
	733: spr633 (spr633), unsigned 32 bits
	734: spr634 (spr634), unsigned 32 bits
	735: spr635 (spr635), unsigned 32 bits
	736: spr636 (spr636), unsigned 32 bits
	737: spr637 (spr637), unsigned 32 bits
	738: spr638 (spr638), unsigned 32 bits
	739: spr639 (spr639), unsigned 32 bits
	740: spr640 (spr640), unsigned 32 bits
	741: spr641 (spr641), unsigned 32 bits
	742: spr642 (spr642), unsigned 32 bits
	743: spr643 (spr643), unsigned 32 bits
	744: spr644 (spr644), unsigned 32 bits
	745: spr645 (spr645), unsigned 32 bits
	746: spr646 (spr646), unsigned 32 bits
	747: spr647 (spr647), unsigned 32 bits
	748: spr648 (spr648), unsigned 32 bits
	749: spr649 (spr649), unsigned 32 bits
	750: spr650 (spr650), unsigned 32 bits
	751: spr651 (spr651), unsigned 32 bits
	752: spr652 (spr652), unsigned 32 bits
	753: spr653 (spr653), unsigned 32 bits
	754: spr654 (spr654), unsigned 32 bits
	755: spr655 (spr655), unsigned 32 bits
	756: spr656 (spr656), unsigned 32 bits
	757: spr657 (spr657), unsigned 32 bits
	758: spr658 (spr658), unsigned 32 bits
	759: spr659 (spr659), unsigned 32 bits
	760: spr660 (spr660), unsigned 32 bits
	761: spr661 (spr661), unsigned 32 bits
	762: spr662 (spr662), unsigned 32 bits
	763: spr663 (spr663), unsigned 32 bits
	764: spr664 (spr664), unsigned 32 bits
	765: spr665 (spr665), unsigned 32 bits
	766: spr666 (spr666), unsigned 32 bits
	767: spr667 (spr667), unsigned 32 bits
	768: spr668 (spr668), unsigned 32 bits
	769: spr669 (spr669), unsigned 32 bits
	770: spr670 (spr670), unsigned 32 bits
	771: spr671 (spr671), unsigned 32 bits
	772: spr672 (spr672), unsigned 32 bits
	773: spr673 (spr673), unsigned 32 bits
	774: spr674 (spr674), unsigned 32 bits
	775: spr675 (spr675), unsigned 32 bits
	776: spr676 (spr676), unsigned 32 bits
	777: spr677 (spr677), unsigned 32 bits
	778: spr678 (spr678), unsigned 32 bits
	779: spr679 (spr679), unsigned 32 bits
	780: spr680 (spr680), unsigned 32 bits
	781: spr681 (spr681), unsigned 32 bits
	782: spr682 (spr682), unsigned 32 bits
	783: spr683 (spr683), unsigned 32 bits
	784: spr684 (spr684), unsigned 32 bits
	785: spr685 (spr685), unsigned 32 bits
	786: spr686 (spr686), unsigned 32 bits
	787: spr687 (spr687), unsigned 32 bits
	788: spr688 (spr688), unsigned 32 bits
	789: spr689 (spr689), unsigned 32 bits
	790: spr690 (spr690), unsigned 32 bits
	791: spr691 (spr691), unsigned 32 bits
	792: spr692 (spr692), unsigned 32 bits
	793: spr693 (spr693), unsigned 32 bits
	794: spr694 (spr694), unsigned 32 bits
	795: spr695 (spr695), unsigned 32 bits
	796: spr696 (spr696), unsigned 32 bits
	797: spr697 (spr697), unsigned 32 bits
	798: spr698 (spr698), unsigned 32 bits
	799: spr699 (spr699), unsigned 32 bits
	800: spr700 (spr700), unsigned 32 bits
	801: spr701 (spr701), unsigned 32 bits
	802: spr702 (spr702), unsigned 32 bits
	803: spr703 (spr703), unsigned 32 bits
	804: spr704 (spr704), unsigned 32 bits
	805: spr705 (spr705), unsigned 32 bits
	806: spr706 (spr706), unsigned 32 bits
	807: spr707 (spr707), unsigned 32 bits
	808: spr708 (spr708), unsigned 32 bits
	809: spr709 (spr709), unsigned 32 bits
	810: spr710 (spr710), unsigned 32 bits
	811: spr711 (spr711), unsigned 32 bits
	812: spr712 (spr712), unsigned 32 bits
	813: spr713 (spr713), unsigned 32 bits
	814: spr714 (spr714), unsigned 32 bits
	815: spr715 (spr715), unsigned 32 bits
	816: spr716 (spr716), unsigned 32 bits
	817: spr717 (spr717), unsigned 32 bits
	818: spr718 (spr718), unsigned 32 bits
	819: spr719 (spr719), unsigned 32 bits
	820: spr720 (spr720), unsigned 32 bits
	821: spr721 (spr721), unsigned 32 bits
	822: spr722 (spr722), unsigned 32 bits
	823: spr723 (spr723), unsigned 32 bits
	824: spr724 (spr724), unsigned 32 bits
	825: spr725 (spr725), unsigned 32 bits
	826: spr726 (spr726), unsigned 32 bits
	827: spr727 (spr727), unsigned 32 bits
	828: spr728 (spr728), unsigned 32 bits
	829: spr729 (spr729), unsigned 32 bits
	830: spr730 (spr730), unsigned 32 bits
	831: spr731 (spr731), unsigned 32 bits
	832: spr732 (spr732), unsigned 32 bits
	833: spr733 (spr733), unsigned 32 bits
	834: spr734 (spr734), unsigned 32 bits
	835: spr735 (spr735), unsigned 32 bits
	836: spr736 (spr736), unsigned 32 bits
	837: spr737 (spr737), unsigned 32 bits
	838: spr738 (spr738), unsigned 32 bits
	839: spr739 (spr739), unsigned 32 bits
	840: spr740 (spr740), unsigned 32 bits
	841: spr741 (spr741), unsigned 32 bits
	842: spr742 (spr742), unsigned 32 bits
	843: spr743 (spr743), unsigned 32 bits
	844: spr744 (spr744), unsigned 32 bits
	845: spr745 (spr745), unsigned 32 bits
	846: spr746 (spr746), unsigned 32 bits
	847: spr747 (spr747), unsigned 32 bits
	848: spr748 (spr748), unsigned 32 bits
	849: spr749 (spr749), unsigned 32 bits
	850: spr750 (spr750), unsigned 32 bits
	851: spr751 (spr751), unsigned 32 bits
	852: spr752 (spr752), unsigned 32 bits
	853: spr753 (spr753), unsigned 32 bits
	854: spr754 (spr754), unsigned 32 bits
	855: spr755 (spr755), unsigned 32 bits
	856: spr756 (spr756), unsigned 32 bits
	857: spr757 (spr757), unsigned 32 bits
	858: spr758 (spr758), unsigned 32 bits
	859: spr759 (spr759), unsigned 32 bits
	860: spr760 (spr760), unsigned 32 bits
	861: spr761 (spr761), unsigned 32 bits
	862: spr762 (spr762), unsigned 32 bits
	863: spr763 (spr763), unsigned 32 bits
	864: spr764 (spr764), unsigned 32 bits
	865: spr765 (spr765), unsigned 32 bits
	866: spr766 (spr766), unsigned 32 bits
	867: spr767 (spr767), unsigned 32 bits
	868: spr768 (spr768), unsigned 32 bits
	869: spr769 (spr769), unsigned 32 bits
	870: spr770 (spr770), unsigned 32 bits
	871: spr771 (spr771), unsigned 32 bits
	872: spr772 (spr772), unsigned 32 bits
	873: spr773 (spr773), unsigned 32 bits
	874: spr774 (spr774), unsigned 32 bits
	875: spr775 (spr775), unsigned 32 bits
	876: spr776 (spr776), unsigned 32 bits
	877: spr777 (spr777), unsigned 32 bits
	878: spr778 (spr778), unsigned 32 bits
	879: spr779 (spr779), unsigned 32 bits
	880: spr780 (spr780), unsigned 32 bits
	881: spr781 (spr781), unsigned 32 bits
	882: spr782 (spr782), unsigned 32 bits
	883: spr783 (spr783), unsigned 32 bits
	884: spr784 (spr784), unsigned 32 bits
	885: spr785 (spr785), unsigned 32 bits
	886: spr786 (spr786), unsigned 32 bits
	887: spr787 (spr787), unsigned 32 bits
	888: spr788 (spr788), unsigned 32 bits
	889: spr789 (spr789), unsigned 32 bits
	890: spr790 (spr790), unsigned 32 bits
	891: spr791 (spr791), unsigned 32 bits
	892: spr792 (spr792), unsigned 32 bits
	893: spr793 (spr793), unsigned 32 bits
	894: spr794 (spr794), unsigned 32 bits
	895: spr795 (spr795), unsigned 32 bits
	896: spr796 (spr796), unsigned 32 bits
	897: spr797 (spr797), unsigned 32 bits
	898: spr798 (spr798), unsigned 32 bits
	899: spr799 (spr799), unsigned 32 bits
	900: spr800 (spr800), unsigned 32 bits
	901: spr801 (spr801), unsigned 32 bits
	902: spr802 (spr802), unsigned 32 bits
	903: spr803 (spr803), unsigned 32 bits
	904: spr804 (spr804), unsigned 32 bits
	905: spr805 (spr805), unsigned 32 bits
	906: spr806 (spr806), unsigned 32 bits
	907: spr807 (spr807), unsigned 32 bits
	908: spr808 (spr808), unsigned 32 bits
	909: spr809 (spr809), unsigned 32 bits
	910: spr810 (spr810), unsigned 32 bits
	911: spr811 (spr811), unsigned 32 bits
	912: spr812 (spr812), unsigned 32 bits
	913: spr813 (spr813), unsigned 32 bits
	914: spr814 (spr814), unsigned 32 bits
	915: spr815 (spr815), unsigned 32 bits
	916: spr816 (spr816), unsigned 32 bits
	917: spr817 (spr817), unsigned 32 bits
	918: spr818 (spr818), unsigned 32 bits
	919: spr819 (spr819), unsigned 32 bits
	920: spr820 (spr820), unsigned 32 bits
	921: spr821 (spr821), unsigned 32 bits
	922: spr822 (spr822), unsigned 32 bits
	923: spr823 (spr823), unsigned 32 bits
	924: spr824 (spr824), unsigned 32 bits
	925: spr825 (spr825), unsigned 32 bits
	926: spr826 (spr826), unsigned 32 bits
	927: spr827 (spr827), unsigned 32 bits
	928: spr828 (spr828), unsigned 32 bits
	929: spr829 (spr829), unsigned 32 bits
	930: spr830 (spr830), unsigned 32 bits
	931: spr831 (spr831), unsigned 32 bits
	932: spr832 (spr832), unsigned 32 bits
	933: spr833 (spr833), unsigned 32 bits
	934: spr834 (spr834), unsigned 32 bits
	935: spr835 (spr835), unsigned 32 bits
	936: spr836 (spr836), unsigned 32 bits
	937: spr837 (spr837), unsigned 32 bits
	938: spr838 (spr838), unsigned 32 bits
	939: spr839 (spr839), unsigned 32 bits
	940: spr840 (spr840), unsigned 32 bits
	941: spr841 (spr841), unsigned 32 bits
	942: spr842 (spr842), unsigned 32 bits
	943: spr843 (spr843), unsigned 32 bits
	944: spr844 (spr844), unsigned 32 bits
	945: spr845 (spr845), unsigned 32 bits
	946: spr846 (spr846), unsigned 32 bits
	947: spr847 (spr847), unsigned 32 bits
	948: spr848 (spr848), unsigned 32 bits
	949: spr849 (spr849), unsigned 32 bits
	950: spr850 (spr850), unsigned 32 bits
	951: spr851 (spr851), unsigned 32 bits
	952: spr852 (spr852), unsigned 32 bits
	953: spr853 (spr853), unsigned 32 bits
	954: spr854 (spr854), unsigned 32 bits
	955: spr855 (spr855), unsigned 32 bits
	956: spr856 (spr856), unsigned 32 bits
	957: spr857 (spr857), unsigned 32 bits
	958: spr858 (spr858), unsigned 32 bits
	959: spr859 (spr859), unsigned 32 bits
	960: spr860 (spr860), unsigned 32 bits
	961: spr861 (spr861), unsigned 32 bits
	962: spr862 (spr862), unsigned 32 bits
	963: spr863 (spr863), unsigned 32 bits
	964: spr864 (spr864), unsigned 32 bits
	965: spr865 (spr865), unsigned 32 bits
	966: spr866 (spr866), unsigned 32 bits
	967: spr867 (spr867), unsigned 32 bits
	968: spr868 (spr868), unsigned 32 bits
	969: spr869 (spr869), unsigned 32 bits
	970: spr870 (spr870), unsigned 32 bits
	971: spr871 (spr871), unsigned 32 bits
	972: spr872 (spr872), unsigned 32 bits
	973: spr873 (spr873), unsigned 32 bits
	974: spr874 (spr874), unsigned 32 bits
	975: spr875 (spr875), unsigned 32 bits
	976: spr876 (spr876), unsigned 32 bits
	977: spr877 (spr877), unsigned 32 bits
	978: spr878 (spr878), unsigned 32 bits
	979: spr879 (spr879), unsigned 32 bits
	980: spr880 (spr880), unsigned 32 bits
	981: spr881 (spr881), unsigned 32 bits
	982: spr882 (spr882), unsigned 32 bits
	983: spr883 (spr883), unsigned 32 bits
	984: spr884 (spr884), unsigned 32 bits
	985: spr885 (spr885), unsigned 32 bits
	986: spr886 (spr886), unsigned 32 bits
	987: spr887 (spr887), unsigned 32 bits
	988: spr888 (spr888), unsigned 32 bits
	989: spr889 (spr889), unsigned 32 bits
	990: spr890 (spr890), unsigned 32 bits
	991: spr891 (spr891), unsigned 32 bits
	992: spr892 (spr892), unsigned 32 bits
	993: spr893 (spr893), unsigned 32 bits
	994: spr894 (spr894), unsigned 32 bits
	995: spr895 (spr895), unsigned 32 bits
	996: spr896 (spr896), unsigned 32 bits
	997: spr897 (spr897), unsigned 32 bits
	998: spr898 (spr898), unsigned 32 bits
	999: spr899 (spr899), unsigned 32 bits
vector registers:
	 67: vscr (vscr), unsigned 32 bits
	356: vrsave (vrsave), unsigned 32 bits
	612: spefscr (spefscr), unsigned 32 bits
	1124: vr0 (vr0), unsigned 128 bits
	1125: vr1 (vr1), unsigned 128 bits
	1126: vr2 (vr2), unsigned 128 bits
	1127: vr3 (vr3), unsigned 128 bits
	1128: vr4 (vr4), unsigned 128 bits
	1129: vr5 (vr5), unsigned 128 bits
	1130: vr6 (vr6), unsigned 128 bits
	1131: vr7 (vr7), unsigned 128 bits
	1132: vr8 (vr8), unsigned 128 bits
	1133: vr9 (vr9), unsigned 128 bits
	1134: vr10 (vr10), unsigned 128 bits
	1135: vr11 (vr11), unsigned 128 bits
	1136: vr12 (vr12), unsigned 128 bits
	1137: vr13 (vr13), unsigned 128 bits
	1138: vr14 (vr14), unsigned 128 bits
	1139: vr15 (vr15), unsigned 128 bits
	1140: vr16 (vr16), unsigned 128 bits
	1141: vr17 (vr17), unsigned 128 bits
	1142: vr18 (vr18), unsigned 128 bits
	1143: vr19 (vr19), unsigned 128 bits
	1144: vr20 (vr20), unsigned 128 bits
	1145: vr21 (vr21), unsigned 128 bits
	1146: vr22 (vr22), unsigned 128 bits
	1147: vr23 (vr23), unsigned 128 bits
	1148: vr24 (vr24), unsigned 128 bits
	1149: vr25 (vr25), unsigned 128 bits
	1150: vr26 (vr26), unsigned 128 bits
	1151: vr27 (vr27), unsigned 128 bits
	1152: vr28 (vr28), unsigned 128 bits
	1153: vr29 (vr29), unsigned 128 bits
	1154: vr30 (vr30), unsigned 128 bits
	1155: vr31 (vr31), unsigned 128 bits
EOF

regs_test testfile23 <<\EOF
integer registers:
	  0: r0 (r0), signed 64 bits
	  1: r1 (r1), signed 64 bits
	  2: r2 (r2), signed 64 bits
	  3: r3 (r3), signed 64 bits
	  4: r4 (r4), signed 64 bits
	  5: r5 (r5), signed 64 bits
	  6: r6 (r6), signed 64 bits
	  7: r7 (r7), signed 64 bits
	  8: r8 (r8), signed 64 bits
	  9: r9 (r9), signed 64 bits
	 10: r10 (r10), signed 64 bits
	 11: r11 (r11), signed 64 bits
	 12: r12 (r12), signed 64 bits
	 13: r13 (r13), signed 64 bits
	 14: r14 (r14), signed 64 bits
	 15: r15 (r15), signed 64 bits
	 16: r16 (r16), signed 64 bits
	 17: r17 (r17), signed 64 bits
	 18: r18 (r18), signed 64 bits
	 19: r19 (r19), signed 64 bits
	 20: r20 (r20), signed 64 bits
	 21: r21 (r21), signed 64 bits
	 22: r22 (r22), signed 64 bits
	 23: r23 (r23), signed 64 bits
	 24: r24 (r24), signed 64 bits
	 25: r25 (r25), signed 64 bits
	 26: r26 (r26), signed 64 bits
	 27: r27 (r27), signed 64 bits
	 28: r28 (r28), signed 64 bits
	 29: r29 (r29), signed 64 bits
	 30: r30 (r30), signed 64 bits
	 31: r31 (r31), signed 64 bits
	 64: cr (cr), unsigned 64 bits
	 66: msr (msr), unsigned 64 bits
FPU registers:
	 32: f0 (f0), float 64 bits
	 33: f1 (f1), float 64 bits
	 34: f2 (f2), float 64 bits
	 35: f3 (f3), float 64 bits
	 36: f4 (f4), float 64 bits
	 37: f5 (f5), float 64 bits
	 38: f6 (f6), float 64 bits
	 39: f7 (f7), float 64 bits
	 40: f8 (f8), float 64 bits
	 41: f9 (f9), float 64 bits
	 42: f10 (f10), float 64 bits
	 43: f11 (f11), float 64 bits
	 44: f12 (f12), float 64 bits
	 45: f13 (f13), float 64 bits
	 46: f14 (f14), float 64 bits
	 47: f15 (f15), float 64 bits
	 48: f16 (f16), float 64 bits
	 49: f17 (f17), float 64 bits
	 50: f18 (f18), float 64 bits
	 51: f19 (f19), float 64 bits
	 52: f20 (f20), float 64 bits
	 53: f21 (f21), float 64 bits
	 54: f22 (f22), float 64 bits
	 55: f23 (f23), float 64 bits
	 56: f24 (f24), float 64 bits
	 57: f25 (f25), float 64 bits
	 58: f26 (f26), float 64 bits
	 59: f27 (f27), float 64 bits
	 60: f28 (f28), float 64 bits
	 61: f29 (f29), float 64 bits
	 62: f30 (f30), float 64 bits
	 63: f31 (f31), float 64 bits
	 65: fpscr (fpscr), unsigned 64 bits
privileged registers:
	 70: sr0 (sr0), unsigned 64 bits
	 71: sr1 (sr1), unsigned 64 bits
	 72: sr2 (sr2), unsigned 64 bits
	 73: sr3 (sr3), unsigned 64 bits
	 74: sr4 (sr4), unsigned 64 bits
	 75: sr5 (sr5), unsigned 64 bits
	 76: sr6 (sr6), unsigned 64 bits
	 77: sr7 (sr7), unsigned 64 bits
	 78: sr8 (sr8), unsigned 64 bits
	 79: sr9 (sr9), unsigned 64 bits
	 80: sr10 (sr10), unsigned 64 bits
	 81: sr11 (sr11), unsigned 64 bits
	 82: sr12 (sr12), unsigned 64 bits
	 83: sr13 (sr13), unsigned 64 bits
	 84: sr14 (sr14), unsigned 64 bits
	 85: sr15 (sr15), unsigned 64 bits
	100: spr0 (spr0), unsigned 64 bits
	101: xer (xer), unsigned 64 bits
	102: spr2 (spr2), unsigned 64 bits
	103: spr3 (spr3), unsigned 64 bits
	104: spr4 (spr4), unsigned 64 bits
	105: spr5 (spr5), unsigned 64 bits
	106: spr6 (spr6), unsigned 64 bits
	107: spr7 (spr7), unsigned 64 bits
	108: lr (lr), unsigned 64 bits
	109: ctr (ctr), unsigned 64 bits
	110: spr10 (spr10), unsigned 64 bits
	111: spr11 (spr11), unsigned 64 bits
	112: spr12 (spr12), unsigned 64 bits
	113: spr13 (spr13), unsigned 64 bits
	114: spr14 (spr14), unsigned 64 bits
	115: spr15 (spr15), unsigned 64 bits
	116: spr16 (spr16), unsigned 64 bits
	117: spr17 (spr17), unsigned 64 bits
	118: dsisr (dsisr), unsigned 64 bits
	119: dar (dar), unsigned 64 bits
	120: spr20 (spr20), unsigned 64 bits
	121: spr21 (spr21), unsigned 64 bits
	122: dec (dec), unsigned 64 bits
	123: spr23 (spr23), unsigned 64 bits
	124: spr24 (spr24), unsigned 64 bits
	125: spr25 (spr25), unsigned 64 bits
	126: spr26 (spr26), unsigned 64 bits
	127: spr27 (spr27), unsigned 64 bits
	128: spr28 (spr28), unsigned 64 bits
	129: spr29 (spr29), unsigned 64 bits
	130: spr30 (spr30), unsigned 64 bits
	131: spr31 (spr31), unsigned 64 bits
	132: spr32 (spr32), unsigned 64 bits
	133: spr33 (spr33), unsigned 64 bits
	134: spr34 (spr34), unsigned 64 bits
	135: spr35 (spr35), unsigned 64 bits
	136: spr36 (spr36), unsigned 64 bits
	137: spr37 (spr37), unsigned 64 bits
	138: spr38 (spr38), unsigned 64 bits
	139: spr39 (spr39), unsigned 64 bits
	140: spr40 (spr40), unsigned 64 bits
	141: spr41 (spr41), unsigned 64 bits
	142: spr42 (spr42), unsigned 64 bits
	143: spr43 (spr43), unsigned 64 bits
	144: spr44 (spr44), unsigned 64 bits
	145: spr45 (spr45), unsigned 64 bits
	146: spr46 (spr46), unsigned 64 bits
	147: spr47 (spr47), unsigned 64 bits
	148: spr48 (spr48), unsigned 64 bits
	149: spr49 (spr49), unsigned 64 bits
	150: spr50 (spr50), unsigned 64 bits
	151: spr51 (spr51), unsigned 64 bits
	152: spr52 (spr52), unsigned 64 bits
	153: spr53 (spr53), unsigned 64 bits
	154: spr54 (spr54), unsigned 64 bits
	155: spr55 (spr55), unsigned 64 bits
	156: spr56 (spr56), unsigned 64 bits
	157: spr57 (spr57), unsigned 64 bits
	158: spr58 (spr58), unsigned 64 bits
	159: spr59 (spr59), unsigned 64 bits
	160: spr60 (spr60), unsigned 64 bits
	161: spr61 (spr61), unsigned 64 bits
	162: spr62 (spr62), unsigned 64 bits
	163: spr63 (spr63), unsigned 64 bits
	164: spr64 (spr64), unsigned 64 bits
	165: spr65 (spr65), unsigned 64 bits
	166: spr66 (spr66), unsigned 64 bits
	167: spr67 (spr67), unsigned 64 bits
	168: spr68 (spr68), unsigned 64 bits
	169: spr69 (spr69), unsigned 64 bits
	170: spr70 (spr70), unsigned 64 bits
	171: spr71 (spr71), unsigned 64 bits
	172: spr72 (spr72), unsigned 64 bits
	173: spr73 (spr73), unsigned 64 bits
	174: spr74 (spr74), unsigned 64 bits
	175: spr75 (spr75), unsigned 64 bits
	176: spr76 (spr76), unsigned 64 bits
	177: spr77 (spr77), unsigned 64 bits
	178: spr78 (spr78), unsigned 64 bits
	179: spr79 (spr79), unsigned 64 bits
	180: spr80 (spr80), unsigned 64 bits
	181: spr81 (spr81), unsigned 64 bits
	182: spr82 (spr82), unsigned 64 bits
	183: spr83 (spr83), unsigned 64 bits
	184: spr84 (spr84), unsigned 64 bits
	185: spr85 (spr85), unsigned 64 bits
	186: spr86 (spr86), unsigned 64 bits
	187: spr87 (spr87), unsigned 64 bits
	188: spr88 (spr88), unsigned 64 bits
	189: spr89 (spr89), unsigned 64 bits
	190: spr90 (spr90), unsigned 64 bits
	191: spr91 (spr91), unsigned 64 bits
	192: spr92 (spr92), unsigned 64 bits
	193: spr93 (spr93), unsigned 64 bits
	194: spr94 (spr94), unsigned 64 bits
	195: spr95 (spr95), unsigned 64 bits
	196: spr96 (spr96), unsigned 64 bits
	197: spr97 (spr97), unsigned 64 bits
	198: spr98 (spr98), unsigned 64 bits
	199: spr99 (spr99), unsigned 64 bits
	200: spr100 (spr100), unsigned 64 bits
	201: spr101 (spr101), unsigned 64 bits
	202: spr102 (spr102), unsigned 64 bits
	203: spr103 (spr103), unsigned 64 bits
	204: spr104 (spr104), unsigned 64 bits
	205: spr105 (spr105), unsigned 64 bits
	206: spr106 (spr106), unsigned 64 bits
	207: spr107 (spr107), unsigned 64 bits
	208: spr108 (spr108), unsigned 64 bits
	209: spr109 (spr109), unsigned 64 bits
	210: spr110 (spr110), unsigned 64 bits
	211: spr111 (spr111), unsigned 64 bits
	212: spr112 (spr112), unsigned 64 bits
	213: spr113 (spr113), unsigned 64 bits
	214: spr114 (spr114), unsigned 64 bits
	215: spr115 (spr115), unsigned 64 bits
	216: spr116 (spr116), unsigned 64 bits
	217: spr117 (spr117), unsigned 64 bits
	218: spr118 (spr118), unsigned 64 bits
	219: spr119 (spr119), unsigned 64 bits
	220: spr120 (spr120), unsigned 64 bits
	221: spr121 (spr121), unsigned 64 bits
	222: spr122 (spr122), unsigned 64 bits
	223: spr123 (spr123), unsigned 64 bits
	224: spr124 (spr124), unsigned 64 bits
	225: spr125 (spr125), unsigned 64 bits
	226: spr126 (spr126), unsigned 64 bits
	227: spr127 (spr127), unsigned 64 bits
	228: spr128 (spr128), unsigned 64 bits
	229: spr129 (spr129), unsigned 64 bits
	230: spr130 (spr130), unsigned 64 bits
	231: spr131 (spr131), unsigned 64 bits
	232: spr132 (spr132), unsigned 64 bits
	233: spr133 (spr133), unsigned 64 bits
	234: spr134 (spr134), unsigned 64 bits
	235: spr135 (spr135), unsigned 64 bits
	236: spr136 (spr136), unsigned 64 bits
	237: spr137 (spr137), unsigned 64 bits
	238: spr138 (spr138), unsigned 64 bits
	239: spr139 (spr139), unsigned 64 bits
	240: spr140 (spr140), unsigned 64 bits
	241: spr141 (spr141), unsigned 64 bits
	242: spr142 (spr142), unsigned 64 bits
	243: spr143 (spr143), unsigned 64 bits
	244: spr144 (spr144), unsigned 64 bits
	245: spr145 (spr145), unsigned 64 bits
	246: spr146 (spr146), unsigned 64 bits
	247: spr147 (spr147), unsigned 64 bits
	248: spr148 (spr148), unsigned 64 bits
	249: spr149 (spr149), unsigned 64 bits
	250: spr150 (spr150), unsigned 64 bits
	251: spr151 (spr151), unsigned 64 bits
	252: spr152 (spr152), unsigned 64 bits
	253: spr153 (spr153), unsigned 64 bits
	254: spr154 (spr154), unsigned 64 bits
	255: spr155 (spr155), unsigned 64 bits
	256: spr156 (spr156), unsigned 64 bits
	257: spr157 (spr157), unsigned 64 bits
	258: spr158 (spr158), unsigned 64 bits
	259: spr159 (spr159), unsigned 64 bits
	260: spr160 (spr160), unsigned 64 bits
	261: spr161 (spr161), unsigned 64 bits
	262: spr162 (spr162), unsigned 64 bits
	263: spr163 (spr163), unsigned 64 bits
	264: spr164 (spr164), unsigned 64 bits
	265: spr165 (spr165), unsigned 64 bits
	266: spr166 (spr166), unsigned 64 bits
	267: spr167 (spr167), unsigned 64 bits
	268: spr168 (spr168), unsigned 64 bits
	269: spr169 (spr169), unsigned 64 bits
	270: spr170 (spr170), unsigned 64 bits
	271: spr171 (spr171), unsigned 64 bits
	272: spr172 (spr172), unsigned 64 bits
	273: spr173 (spr173), unsigned 64 bits
	274: spr174 (spr174), unsigned 64 bits
	275: spr175 (spr175), unsigned 64 bits
	276: spr176 (spr176), unsigned 64 bits
	277: spr177 (spr177), unsigned 64 bits
	278: spr178 (spr178), unsigned 64 bits
	279: spr179 (spr179), unsigned 64 bits
	280: spr180 (spr180), unsigned 64 bits
	281: spr181 (spr181), unsigned 64 bits
	282: spr182 (spr182), unsigned 64 bits
	283: spr183 (spr183), unsigned 64 bits
	284: spr184 (spr184), unsigned 64 bits
	285: spr185 (spr185), unsigned 64 bits
	286: spr186 (spr186), unsigned 64 bits
	287: spr187 (spr187), unsigned 64 bits
	288: spr188 (spr188), unsigned 64 bits
	289: spr189 (spr189), unsigned 64 bits
	290: spr190 (spr190), unsigned 64 bits
	291: spr191 (spr191), unsigned 64 bits
	292: spr192 (spr192), unsigned 64 bits
	293: spr193 (spr193), unsigned 64 bits
	294: spr194 (spr194), unsigned 64 bits
	295: spr195 (spr195), unsigned 64 bits
	296: spr196 (spr196), unsigned 64 bits
	297: spr197 (spr197), unsigned 64 bits
	298: spr198 (spr198), unsigned 64 bits
	299: spr199 (spr199), unsigned 64 bits
	300: spr200 (spr200), unsigned 64 bits
	301: spr201 (spr201), unsigned 64 bits
	302: spr202 (spr202), unsigned 64 bits
	303: spr203 (spr203), unsigned 64 bits
	304: spr204 (spr204), unsigned 64 bits
	305: spr205 (spr205), unsigned 64 bits
	306: spr206 (spr206), unsigned 64 bits
	307: spr207 (spr207), unsigned 64 bits
	308: spr208 (spr208), unsigned 64 bits
	309: spr209 (spr209), unsigned 64 bits
	310: spr210 (spr210), unsigned 64 bits
	311: spr211 (spr211), unsigned 64 bits
	312: spr212 (spr212), unsigned 64 bits
	313: spr213 (spr213), unsigned 64 bits
	314: spr214 (spr214), unsigned 64 bits
	315: spr215 (spr215), unsigned 64 bits
	316: spr216 (spr216), unsigned 64 bits
	317: spr217 (spr217), unsigned 64 bits
	318: spr218 (spr218), unsigned 64 bits
	319: spr219 (spr219), unsigned 64 bits
	320: spr220 (spr220), unsigned 64 bits
	321: spr221 (spr221), unsigned 64 bits
	322: spr222 (spr222), unsigned 64 bits
	323: spr223 (spr223), unsigned 64 bits
	324: spr224 (spr224), unsigned 64 bits
	325: spr225 (spr225), unsigned 64 bits
	326: spr226 (spr226), unsigned 64 bits
	327: spr227 (spr227), unsigned 64 bits
	328: spr228 (spr228), unsigned 64 bits
	329: spr229 (spr229), unsigned 64 bits
	330: spr230 (spr230), unsigned 64 bits
	331: spr231 (spr231), unsigned 64 bits
	332: spr232 (spr232), unsigned 64 bits
	333: spr233 (spr233), unsigned 64 bits
	334: spr234 (spr234), unsigned 64 bits
	335: spr235 (spr235), unsigned 64 bits
	336: spr236 (spr236), unsigned 64 bits
	337: spr237 (spr237), unsigned 64 bits
	338: spr238 (spr238), unsigned 64 bits
	339: spr239 (spr239), unsigned 64 bits
	340: spr240 (spr240), unsigned 64 bits
	341: spr241 (spr241), unsigned 64 bits
	342: spr242 (spr242), unsigned 64 bits
	343: spr243 (spr243), unsigned 64 bits
	344: spr244 (spr244), unsigned 64 bits
	345: spr245 (spr245), unsigned 64 bits
	346: spr246 (spr246), unsigned 64 bits
	347: spr247 (spr247), unsigned 64 bits
	348: spr248 (spr248), unsigned 64 bits
	349: spr249 (spr249), unsigned 64 bits
	350: spr250 (spr250), unsigned 64 bits
	351: spr251 (spr251), unsigned 64 bits
	352: spr252 (spr252), unsigned 64 bits
	353: spr253 (spr253), unsigned 64 bits
	354: spr254 (spr254), unsigned 64 bits
	355: spr255 (spr255), unsigned 64 bits
	357: spr257 (spr257), unsigned 64 bits
	358: spr258 (spr258), unsigned 64 bits
	359: spr259 (spr259), unsigned 64 bits
	360: spr260 (spr260), unsigned 64 bits
	361: spr261 (spr261), unsigned 64 bits
	362: spr262 (spr262), unsigned 64 bits
	363: spr263 (spr263), unsigned 64 bits
	364: spr264 (spr264), unsigned 64 bits
	365: spr265 (spr265), unsigned 64 bits
	366: spr266 (spr266), unsigned 64 bits
	367: spr267 (spr267), unsigned 64 bits
	368: spr268 (spr268), unsigned 64 bits
	369: spr269 (spr269), unsigned 64 bits
	370: spr270 (spr270), unsigned 64 bits
	371: spr271 (spr271), unsigned 64 bits
	372: spr272 (spr272), unsigned 64 bits
	373: spr273 (spr273), unsigned 64 bits
	374: spr274 (spr274), unsigned 64 bits
	375: spr275 (spr275), unsigned 64 bits
	376: spr276 (spr276), unsigned 64 bits
	377: spr277 (spr277), unsigned 64 bits
	378: spr278 (spr278), unsigned 64 bits
	379: spr279 (spr279), unsigned 64 bits
	380: spr280 (spr280), unsigned 64 bits
	381: spr281 (spr281), unsigned 64 bits
	382: spr282 (spr282), unsigned 64 bits
	383: spr283 (spr283), unsigned 64 bits
	384: spr284 (spr284), unsigned 64 bits
	385: spr285 (spr285), unsigned 64 bits
	386: spr286 (spr286), unsigned 64 bits
	387: spr287 (spr287), unsigned 64 bits
	388: spr288 (spr288), unsigned 64 bits
	389: spr289 (spr289), unsigned 64 bits
	390: spr290 (spr290), unsigned 64 bits
	391: spr291 (spr291), unsigned 64 bits
	392: spr292 (spr292), unsigned 64 bits
	393: spr293 (spr293), unsigned 64 bits
	394: spr294 (spr294), unsigned 64 bits
	395: spr295 (spr295), unsigned 64 bits
	396: spr296 (spr296), unsigned 64 bits
	397: spr297 (spr297), unsigned 64 bits
	398: spr298 (spr298), unsigned 64 bits
	399: spr299 (spr299), unsigned 64 bits
	400: spr300 (spr300), unsigned 64 bits
	401: spr301 (spr301), unsigned 64 bits
	402: spr302 (spr302), unsigned 64 bits
	403: spr303 (spr303), unsigned 64 bits
	404: spr304 (spr304), unsigned 64 bits
	405: spr305 (spr305), unsigned 64 bits
	406: spr306 (spr306), unsigned 64 bits
	407: spr307 (spr307), unsigned 64 bits
	408: spr308 (spr308), unsigned 64 bits
	409: spr309 (spr309), unsigned 64 bits
	410: spr310 (spr310), unsigned 64 bits
	411: spr311 (spr311), unsigned 64 bits
	412: spr312 (spr312), unsigned 64 bits
	413: spr313 (spr313), unsigned 64 bits
	414: spr314 (spr314), unsigned 64 bits
	415: spr315 (spr315), unsigned 64 bits
	416: spr316 (spr316), unsigned 64 bits
	417: spr317 (spr317), unsigned 64 bits
	418: spr318 (spr318), unsigned 64 bits
	419: spr319 (spr319), unsigned 64 bits
	420: spr320 (spr320), unsigned 64 bits
	421: spr321 (spr321), unsigned 64 bits
	422: spr322 (spr322), unsigned 64 bits
	423: spr323 (spr323), unsigned 64 bits
	424: spr324 (spr324), unsigned 64 bits
	425: spr325 (spr325), unsigned 64 bits
	426: spr326 (spr326), unsigned 64 bits
	427: spr327 (spr327), unsigned 64 bits
	428: spr328 (spr328), unsigned 64 bits
	429: spr329 (spr329), unsigned 64 bits
	430: spr330 (spr330), unsigned 64 bits
	431: spr331 (spr331), unsigned 64 bits
	432: spr332 (spr332), unsigned 64 bits
	433: spr333 (spr333), unsigned 64 bits
	434: spr334 (spr334), unsigned 64 bits
	435: spr335 (spr335), unsigned 64 bits
	436: spr336 (spr336), unsigned 64 bits
	437: spr337 (spr337), unsigned 64 bits
	438: spr338 (spr338), unsigned 64 bits
	439: spr339 (spr339), unsigned 64 bits
	440: spr340 (spr340), unsigned 64 bits
	441: spr341 (spr341), unsigned 64 bits
	442: spr342 (spr342), unsigned 64 bits
	443: spr343 (spr343), unsigned 64 bits
	444: spr344 (spr344), unsigned 64 bits
	445: spr345 (spr345), unsigned 64 bits
	446: spr346 (spr346), unsigned 64 bits
	447: spr347 (spr347), unsigned 64 bits
	448: spr348 (spr348), unsigned 64 bits
	449: spr349 (spr349), unsigned 64 bits
	450: spr350 (spr350), unsigned 64 bits
	451: spr351 (spr351), unsigned 64 bits
	452: spr352 (spr352), unsigned 64 bits
	453: spr353 (spr353), unsigned 64 bits
	454: spr354 (spr354), unsigned 64 bits
	455: spr355 (spr355), unsigned 64 bits
	456: spr356 (spr356), unsigned 64 bits
	457: spr357 (spr357), unsigned 64 bits
	458: spr358 (spr358), unsigned 64 bits
	459: spr359 (spr359), unsigned 64 bits
	460: spr360 (spr360), unsigned 64 bits
	461: spr361 (spr361), unsigned 64 bits
	462: spr362 (spr362), unsigned 64 bits
	463: spr363 (spr363), unsigned 64 bits
	464: spr364 (spr364), unsigned 64 bits
	465: spr365 (spr365), unsigned 64 bits
	466: spr366 (spr366), unsigned 64 bits
	467: spr367 (spr367), unsigned 64 bits
	468: spr368 (spr368), unsigned 64 bits
	469: spr369 (spr369), unsigned 64 bits
	470: spr370 (spr370), unsigned 64 bits
	471: spr371 (spr371), unsigned 64 bits
	472: spr372 (spr372), unsigned 64 bits
	473: spr373 (spr373), unsigned 64 bits
	474: spr374 (spr374), unsigned 64 bits
	475: spr375 (spr375), unsigned 64 bits
	476: spr376 (spr376), unsigned 64 bits
	477: spr377 (spr377), unsigned 64 bits
	478: spr378 (spr378), unsigned 64 bits
	479: spr379 (spr379), unsigned 64 bits
	480: spr380 (spr380), unsigned 64 bits
	481: spr381 (spr381), unsigned 64 bits
	482: spr382 (spr382), unsigned 64 bits
	483: spr383 (spr383), unsigned 64 bits
	484: spr384 (spr384), unsigned 64 bits
	485: spr385 (spr385), unsigned 64 bits
	486: spr386 (spr386), unsigned 64 bits
	487: spr387 (spr387), unsigned 64 bits
	488: spr388 (spr388), unsigned 64 bits
	489: spr389 (spr389), unsigned 64 bits
	490: spr390 (spr390), unsigned 64 bits
	491: spr391 (spr391), unsigned 64 bits
	492: spr392 (spr392), unsigned 64 bits
	493: spr393 (spr393), unsigned 64 bits
	494: spr394 (spr394), unsigned 64 bits
	495: spr395 (spr395), unsigned 64 bits
	496: spr396 (spr396), unsigned 64 bits
	497: spr397 (spr397), unsigned 64 bits
	498: spr398 (spr398), unsigned 64 bits
	499: spr399 (spr399), unsigned 64 bits
	500: spr400 (spr400), unsigned 64 bits
	501: spr401 (spr401), unsigned 64 bits
	502: spr402 (spr402), unsigned 64 bits
	503: spr403 (spr403), unsigned 64 bits
	504: spr404 (spr404), unsigned 64 bits
	505: spr405 (spr405), unsigned 64 bits
	506: spr406 (spr406), unsigned 64 bits
	507: spr407 (spr407), unsigned 64 bits
	508: spr408 (spr408), unsigned 64 bits
	509: spr409 (spr409), unsigned 64 bits
	510: spr410 (spr410), unsigned 64 bits
	511: spr411 (spr411), unsigned 64 bits
	512: spr412 (spr412), unsigned 64 bits
	513: spr413 (spr413), unsigned 64 bits
	514: spr414 (spr414), unsigned 64 bits
	515: spr415 (spr415), unsigned 64 bits
	516: spr416 (spr416), unsigned 64 bits
	517: spr417 (spr417), unsigned 64 bits
	518: spr418 (spr418), unsigned 64 bits
	519: spr419 (spr419), unsigned 64 bits
	520: spr420 (spr420), unsigned 64 bits
	521: spr421 (spr421), unsigned 64 bits
	522: spr422 (spr422), unsigned 64 bits
	523: spr423 (spr423), unsigned 64 bits
	524: spr424 (spr424), unsigned 64 bits
	525: spr425 (spr425), unsigned 64 bits
	526: spr426 (spr426), unsigned 64 bits
	527: spr427 (spr427), unsigned 64 bits
	528: spr428 (spr428), unsigned 64 bits
	529: spr429 (spr429), unsigned 64 bits
	530: spr430 (spr430), unsigned 64 bits
	531: spr431 (spr431), unsigned 64 bits
	532: spr432 (spr432), unsigned 64 bits
	533: spr433 (spr433), unsigned 64 bits
	534: spr434 (spr434), unsigned 64 bits
	535: spr435 (spr435), unsigned 64 bits
	536: spr436 (spr436), unsigned 64 bits
	537: spr437 (spr437), unsigned 64 bits
	538: spr438 (spr438), unsigned 64 bits
	539: spr439 (spr439), unsigned 64 bits
	540: spr440 (spr440), unsigned 64 bits
	541: spr441 (spr441), unsigned 64 bits
	542: spr442 (spr442), unsigned 64 bits
	543: spr443 (spr443), unsigned 64 bits
	544: spr444 (spr444), unsigned 64 bits
	545: spr445 (spr445), unsigned 64 bits
	546: spr446 (spr446), unsigned 64 bits
	547: spr447 (spr447), unsigned 64 bits
	548: spr448 (spr448), unsigned 64 bits
	549: spr449 (spr449), unsigned 64 bits
	550: spr450 (spr450), unsigned 64 bits
	551: spr451 (spr451), unsigned 64 bits
	552: spr452 (spr452), unsigned 64 bits
	553: spr453 (spr453), unsigned 64 bits
	554: spr454 (spr454), unsigned 64 bits
	555: spr455 (spr455), unsigned 64 bits
	556: spr456 (spr456), unsigned 64 bits
	557: spr457 (spr457), unsigned 64 bits
	558: spr458 (spr458), unsigned 64 bits
	559: spr459 (spr459), unsigned 64 bits
	560: spr460 (spr460), unsigned 64 bits
	561: spr461 (spr461), unsigned 64 bits
	562: spr462 (spr462), unsigned 64 bits
	563: spr463 (spr463), unsigned 64 bits
	564: spr464 (spr464), unsigned 64 bits
	565: spr465 (spr465), unsigned 64 bits
	566: spr466 (spr466), unsigned 64 bits
	567: spr467 (spr467), unsigned 64 bits
	568: spr468 (spr468), unsigned 64 bits
	569: spr469 (spr469), unsigned 64 bits
	570: spr470 (spr470), unsigned 64 bits
	571: spr471 (spr471), unsigned 64 bits
	572: spr472 (spr472), unsigned 64 bits
	573: spr473 (spr473), unsigned 64 bits
	574: spr474 (spr474), unsigned 64 bits
	575: spr475 (spr475), unsigned 64 bits
	576: spr476 (spr476), unsigned 64 bits
	577: spr477 (spr477), unsigned 64 bits
	578: spr478 (spr478), unsigned 64 bits
	579: spr479 (spr479), unsigned 64 bits
	580: spr480 (spr480), unsigned 64 bits
	581: spr481 (spr481), unsigned 64 bits
	582: spr482 (spr482), unsigned 64 bits
	583: spr483 (spr483), unsigned 64 bits
	584: spr484 (spr484), unsigned 64 bits
	585: spr485 (spr485), unsigned 64 bits
	586: spr486 (spr486), unsigned 64 bits
	587: spr487 (spr487), unsigned 64 bits
	588: spr488 (spr488), unsigned 64 bits
	589: spr489 (spr489), unsigned 64 bits
	590: spr490 (spr490), unsigned 64 bits
	591: spr491 (spr491), unsigned 64 bits
	592: spr492 (spr492), unsigned 64 bits
	593: spr493 (spr493), unsigned 64 bits
	594: spr494 (spr494), unsigned 64 bits
	595: spr495 (spr495), unsigned 64 bits
	596: spr496 (spr496), unsigned 64 bits
	597: spr497 (spr497), unsigned 64 bits
	598: spr498 (spr498), unsigned 64 bits
	599: spr499 (spr499), unsigned 64 bits
	600: spr500 (spr500), unsigned 64 bits
	601: spr501 (spr501), unsigned 64 bits
	602: spr502 (spr502), unsigned 64 bits
	603: spr503 (spr503), unsigned 64 bits
	604: spr504 (spr504), unsigned 64 bits
	605: spr505 (spr505), unsigned 64 bits
	606: spr506 (spr506), unsigned 64 bits
	607: spr507 (spr507), unsigned 64 bits
	608: spr508 (spr508), unsigned 64 bits
	609: spr509 (spr509), unsigned 64 bits
	610: spr510 (spr510), unsigned 64 bits
	611: spr511 (spr511), unsigned 64 bits
	613: spr513 (spr513), unsigned 64 bits
	614: spr514 (spr514), unsigned 64 bits
	615: spr515 (spr515), unsigned 64 bits
	616: spr516 (spr516), unsigned 64 bits
	617: spr517 (spr517), unsigned 64 bits
	618: spr518 (spr518), unsigned 64 bits
	619: spr519 (spr519), unsigned 64 bits
	620: spr520 (spr520), unsigned 64 bits
	621: spr521 (spr521), unsigned 64 bits
	622: spr522 (spr522), unsigned 64 bits
	623: spr523 (spr523), unsigned 64 bits
	624: spr524 (spr524), unsigned 64 bits
	625: spr525 (spr525), unsigned 64 bits
	626: spr526 (spr526), unsigned 64 bits
	627: spr527 (spr527), unsigned 64 bits
	628: spr528 (spr528), unsigned 64 bits
	629: spr529 (spr529), unsigned 64 bits
	630: spr530 (spr530), unsigned 64 bits
	631: spr531 (spr531), unsigned 64 bits
	632: spr532 (spr532), unsigned 64 bits
	633: spr533 (spr533), unsigned 64 bits
	634: spr534 (spr534), unsigned 64 bits
	635: spr535 (spr535), unsigned 64 bits
	636: spr536 (spr536), unsigned 64 bits
	637: spr537 (spr537), unsigned 64 bits
	638: spr538 (spr538), unsigned 64 bits
	639: spr539 (spr539), unsigned 64 bits
	640: spr540 (spr540), unsigned 64 bits
	641: spr541 (spr541), unsigned 64 bits
	642: spr542 (spr542), unsigned 64 bits
	643: spr543 (spr543), unsigned 64 bits
	644: spr544 (spr544), unsigned 64 bits
	645: spr545 (spr545), unsigned 64 bits
	646: spr546 (spr546), unsigned 64 bits
	647: spr547 (spr547), unsigned 64 bits
	648: spr548 (spr548), unsigned 64 bits
	649: spr549 (spr549), unsigned 64 bits
	650: spr550 (spr550), unsigned 64 bits
	651: spr551 (spr551), unsigned 64 bits
	652: spr552 (spr552), unsigned 64 bits
	653: spr553 (spr553), unsigned 64 bits
	654: spr554 (spr554), unsigned 64 bits
	655: spr555 (spr555), unsigned 64 bits
	656: spr556 (spr556), unsigned 64 bits
	657: spr557 (spr557), unsigned 64 bits
	658: spr558 (spr558), unsigned 64 bits
	659: spr559 (spr559), unsigned 64 bits
	660: spr560 (spr560), unsigned 64 bits
	661: spr561 (spr561), unsigned 64 bits
	662: spr562 (spr562), unsigned 64 bits
	663: spr563 (spr563), unsigned 64 bits
	664: spr564 (spr564), unsigned 64 bits
	665: spr565 (spr565), unsigned 64 bits
	666: spr566 (spr566), unsigned 64 bits
	667: spr567 (spr567), unsigned 64 bits
	668: spr568 (spr568), unsigned 64 bits
	669: spr569 (spr569), unsigned 64 bits
	670: spr570 (spr570), unsigned 64 bits
	671: spr571 (spr571), unsigned 64 bits
	672: spr572 (spr572), unsigned 64 bits
	673: spr573 (spr573), unsigned 64 bits
	674: spr574 (spr574), unsigned 64 bits
	675: spr575 (spr575), unsigned 64 bits
	676: spr576 (spr576), unsigned 64 bits
	677: spr577 (spr577), unsigned 64 bits
	678: spr578 (spr578), unsigned 64 bits
	679: spr579 (spr579), unsigned 64 bits
	680: spr580 (spr580), unsigned 64 bits
	681: spr581 (spr581), unsigned 64 bits
	682: spr582 (spr582), unsigned 64 bits
	683: spr583 (spr583), unsigned 64 bits
	684: spr584 (spr584), unsigned 64 bits
	685: spr585 (spr585), unsigned 64 bits
	686: spr586 (spr586), unsigned 64 bits
	687: spr587 (spr587), unsigned 64 bits
	688: spr588 (spr588), unsigned 64 bits
	689: spr589 (spr589), unsigned 64 bits
	690: spr590 (spr590), unsigned 64 bits
	691: spr591 (spr591), unsigned 64 bits
	692: spr592 (spr592), unsigned 64 bits
	693: spr593 (spr593), unsigned 64 bits
	694: spr594 (spr594), unsigned 64 bits
	695: spr595 (spr595), unsigned 64 bits
	696: spr596 (spr596), unsigned 64 bits
	697: spr597 (spr597), unsigned 64 bits
	698: spr598 (spr598), unsigned 64 bits
	699: spr599 (spr599), unsigned 64 bits
	700: spr600 (spr600), unsigned 64 bits
	701: spr601 (spr601), unsigned 64 bits
	702: spr602 (spr602), unsigned 64 bits
	703: spr603 (spr603), unsigned 64 bits
	704: spr604 (spr604), unsigned 64 bits
	705: spr605 (spr605), unsigned 64 bits
	706: spr606 (spr606), unsigned 64 bits
	707: spr607 (spr607), unsigned 64 bits
	708: spr608 (spr608), unsigned 64 bits
	709: spr609 (spr609), unsigned 64 bits
	710: spr610 (spr610), unsigned 64 bits
	711: spr611 (spr611), unsigned 64 bits
	712: spr612 (spr612), unsigned 64 bits
	713: spr613 (spr613), unsigned 64 bits
	714: spr614 (spr614), unsigned 64 bits
	715: spr615 (spr615), unsigned 64 bits
	716: spr616 (spr616), unsigned 64 bits
	717: spr617 (spr617), unsigned 64 bits
	718: spr618 (spr618), unsigned 64 bits
	719: spr619 (spr619), unsigned 64 bits
	720: spr620 (spr620), unsigned 64 bits
	721: spr621 (spr621), unsigned 64 bits
	722: spr622 (spr622), unsigned 64 bits
	723: spr623 (spr623), unsigned 64 bits
	724: spr624 (spr624), unsigned 64 bits
	725: spr625 (spr625), unsigned 64 bits
	726: spr626 (spr626), unsigned 64 bits
	727: spr627 (spr627), unsigned 64 bits
	728: spr628 (spr628), unsigned 64 bits
	729: spr629 (spr629), unsigned 64 bits
	730: spr630 (spr630), unsigned 64 bits
	731: spr631 (spr631), unsigned 64 bits
	732: spr632 (spr632), unsigned 64 bits
	733: spr633 (spr633), unsigned 64 bits
	734: spr634 (spr634), unsigned 64 bits
	735: spr635 (spr635), unsigned 64 bits
	736: spr636 (spr636), unsigned 64 bits
	737: spr637 (spr637), unsigned 64 bits
	738: spr638 (spr638), unsigned 64 bits
	739: spr639 (spr639), unsigned 64 bits
	740: spr640 (spr640), unsigned 64 bits
	741: spr641 (spr641), unsigned 64 bits
	742: spr642 (spr642), unsigned 64 bits
	743: spr643 (spr643), unsigned 64 bits
	744: spr644 (spr644), unsigned 64 bits
	745: spr645 (spr645), unsigned 64 bits
	746: spr646 (spr646), unsigned 64 bits
	747: spr647 (spr647), unsigned 64 bits
	748: spr648 (spr648), unsigned 64 bits
	749: spr649 (spr649), unsigned 64 bits
	750: spr650 (spr650), unsigned 64 bits
	751: spr651 (spr651), unsigned 64 bits
	752: spr652 (spr652), unsigned 64 bits
	753: spr653 (spr653), unsigned 64 bits
	754: spr654 (spr654), unsigned 64 bits
	755: spr655 (spr655), unsigned 64 bits
	756: spr656 (spr656), unsigned 64 bits
	757: spr657 (spr657), unsigned 64 bits
	758: spr658 (spr658), unsigned 64 bits
	759: spr659 (spr659), unsigned 64 bits
	760: spr660 (spr660), unsigned 64 bits
	761: spr661 (spr661), unsigned 64 bits
	762: spr662 (spr662), unsigned 64 bits
	763: spr663 (spr663), unsigned 64 bits
	764: spr664 (spr664), unsigned 64 bits
	765: spr665 (spr665), unsigned 64 bits
	766: spr666 (spr666), unsigned 64 bits
	767: spr667 (spr667), unsigned 64 bits
	768: spr668 (spr668), unsigned 64 bits
	769: spr669 (spr669), unsigned 64 bits
	770: spr670 (spr670), unsigned 64 bits
	771: spr671 (spr671), unsigned 64 bits
	772: spr672 (spr672), unsigned 64 bits
	773: spr673 (spr673), unsigned 64 bits
	774: spr674 (spr674), unsigned 64 bits
	775: spr675 (spr675), unsigned 64 bits
	776: spr676 (spr676), unsigned 64 bits
	777: spr677 (spr677), unsigned 64 bits
	778: spr678 (spr678), unsigned 64 bits
	779: spr679 (spr679), unsigned 64 bits
	780: spr680 (spr680), unsigned 64 bits
	781: spr681 (spr681), unsigned 64 bits
	782: spr682 (spr682), unsigned 64 bits
	783: spr683 (spr683), unsigned 64 bits
	784: spr684 (spr684), unsigned 64 bits
	785: spr685 (spr685), unsigned 64 bits
	786: spr686 (spr686), unsigned 64 bits
	787: spr687 (spr687), unsigned 64 bits
	788: spr688 (spr688), unsigned 64 bits
	789: spr689 (spr689), unsigned 64 bits
	790: spr690 (spr690), unsigned 64 bits
	791: spr691 (spr691), unsigned 64 bits
	792: spr692 (spr692), unsigned 64 bits
	793: spr693 (spr693), unsigned 64 bits
	794: spr694 (spr694), unsigned 64 bits
	795: spr695 (spr695), unsigned 64 bits
	796: spr696 (spr696), unsigned 64 bits
	797: spr697 (spr697), unsigned 64 bits
	798: spr698 (spr698), unsigned 64 bits
	799: spr699 (spr699), unsigned 64 bits
	800: spr700 (spr700), unsigned 64 bits
	801: spr701 (spr701), unsigned 64 bits
	802: spr702 (spr702), unsigned 64 bits
	803: spr703 (spr703), unsigned 64 bits
	804: spr704 (spr704), unsigned 64 bits
	805: spr705 (spr705), unsigned 64 bits
	806: spr706 (spr706), unsigned 64 bits
	807: spr707 (spr707), unsigned 64 bits
	808: spr708 (spr708), unsigned 64 bits
	809: spr709 (spr709), unsigned 64 bits
	810: spr710 (spr710), unsigned 64 bits
	811: spr711 (spr711), unsigned 64 bits
	812: spr712 (spr712), unsigned 64 bits
	813: spr713 (spr713), unsigned 64 bits
	814: spr714 (spr714), unsigned 64 bits
	815: spr715 (spr715), unsigned 64 bits
	816: spr716 (spr716), unsigned 64 bits
	817: spr717 (spr717), unsigned 64 bits
	818: spr718 (spr718), unsigned 64 bits
	819: spr719 (spr719), unsigned 64 bits
	820: spr720 (spr720), unsigned 64 bits
	821: spr721 (spr721), unsigned 64 bits
	822: spr722 (spr722), unsigned 64 bits
	823: spr723 (spr723), unsigned 64 bits
	824: spr724 (spr724), unsigned 64 bits
	825: spr725 (spr725), unsigned 64 bits
	826: spr726 (spr726), unsigned 64 bits
	827: spr727 (spr727), unsigned 64 bits
	828: spr728 (spr728), unsigned 64 bits
	829: spr729 (spr729), unsigned 64 bits
	830: spr730 (spr730), unsigned 64 bits
	831: spr731 (spr731), unsigned 64 bits
	832: spr732 (spr732), unsigned 64 bits
	833: spr733 (spr733), unsigned 64 bits
	834: spr734 (spr734), unsigned 64 bits
	835: spr735 (spr735), unsigned 64 bits
	836: spr736 (spr736), unsigned 64 bits
	837: spr737 (spr737), unsigned 64 bits
	838: spr738 (spr738), unsigned 64 bits
	839: spr739 (spr739), unsigned 64 bits
	840: spr740 (spr740), unsigned 64 bits
	841: spr741 (spr741), unsigned 64 bits
	842: spr742 (spr742), unsigned 64 bits
	843: spr743 (spr743), unsigned 64 bits
	844: spr744 (spr744), unsigned 64 bits
	845: spr745 (spr745), unsigned 64 bits
	846: spr746 (spr746), unsigned 64 bits
	847: spr747 (spr747), unsigned 64 bits
	848: spr748 (spr748), unsigned 64 bits
	849: spr749 (spr749), unsigned 64 bits
	850: spr750 (spr750), unsigned 64 bits
	851: spr751 (spr751), unsigned 64 bits
	852: spr752 (spr752), unsigned 64 bits
	853: spr753 (spr753), unsigned 64 bits
	854: spr754 (spr754), unsigned 64 bits
	855: spr755 (spr755), unsigned 64 bits
	856: spr756 (spr756), unsigned 64 bits
	857: spr757 (spr757), unsigned 64 bits
	858: spr758 (spr758), unsigned 64 bits
	859: spr759 (spr759), unsigned 64 bits
	860: spr760 (spr760), unsigned 64 bits
	861: spr761 (spr761), unsigned 64 bits
	862: spr762 (spr762), unsigned 64 bits
	863: spr763 (spr763), unsigned 64 bits
	864: spr764 (spr764), unsigned 64 bits
	865: spr765 (spr765), unsigned 64 bits
	866: spr766 (spr766), unsigned 64 bits
	867: spr767 (spr767), unsigned 64 bits
	868: spr768 (spr768), unsigned 64 bits
	869: spr769 (spr769), unsigned 64 bits
	870: spr770 (spr770), unsigned 64 bits
	871: spr771 (spr771), unsigned 64 bits
	872: spr772 (spr772), unsigned 64 bits
	873: spr773 (spr773), unsigned 64 bits
	874: spr774 (spr774), unsigned 64 bits
	875: spr775 (spr775), unsigned 64 bits
	876: spr776 (spr776), unsigned 64 bits
	877: spr777 (spr777), unsigned 64 bits
	878: spr778 (spr778), unsigned 64 bits
	879: spr779 (spr779), unsigned 64 bits
	880: spr780 (spr780), unsigned 64 bits
	881: spr781 (spr781), unsigned 64 bits
	882: spr782 (spr782), unsigned 64 bits
	883: spr783 (spr783), unsigned 64 bits
	884: spr784 (spr784), unsigned 64 bits
	885: spr785 (spr785), unsigned 64 bits
	886: spr786 (spr786), unsigned 64 bits
	887: spr787 (spr787), unsigned 64 bits
	888: spr788 (spr788), unsigned 64 bits
	889: spr789 (spr789), unsigned 64 bits
	890: spr790 (spr790), unsigned 64 bits
	891: spr791 (spr791), unsigned 64 bits
	892: spr792 (spr792), unsigned 64 bits
	893: spr793 (spr793), unsigned 64 bits
	894: spr794 (spr794), unsigned 64 bits
	895: spr795 (spr795), unsigned 64 bits
	896: spr796 (spr796), unsigned 64 bits
	897: spr797 (spr797), unsigned 64 bits
	898: spr798 (spr798), unsigned 64 bits
	899: spr799 (spr799), unsigned 64 bits
	900: spr800 (spr800), unsigned 64 bits
	901: spr801 (spr801), unsigned 64 bits
	902: spr802 (spr802), unsigned 64 bits
	903: spr803 (spr803), unsigned 64 bits
	904: spr804 (spr804), unsigned 64 bits
	905: spr805 (spr805), unsigned 64 bits
	906: spr806 (spr806), unsigned 64 bits
	907: spr807 (spr807), unsigned 64 bits
	908: spr808 (spr808), unsigned 64 bits
	909: spr809 (spr809), unsigned 64 bits
	910: spr810 (spr810), unsigned 64 bits
	911: spr811 (spr811), unsigned 64 bits
	912: spr812 (spr812), unsigned 64 bits
	913: spr813 (spr813), unsigned 64 bits
	914: spr814 (spr814), unsigned 64 bits
	915: spr815 (spr815), unsigned 64 bits
	916: spr816 (spr816), unsigned 64 bits
	917: spr817 (spr817), unsigned 64 bits
	918: spr818 (spr818), unsigned 64 bits
	919: spr819 (spr819), unsigned 64 bits
	920: spr820 (spr820), unsigned 64 bits
	921: spr821 (spr821), unsigned 64 bits
	922: spr822 (spr822), unsigned 64 bits
	923: spr823 (spr823), unsigned 64 bits
	924: spr824 (spr824), unsigned 64 bits
	925: spr825 (spr825), unsigned 64 bits
	926: spr826 (spr826), unsigned 64 bits
	927: spr827 (spr827), unsigned 64 bits
	928: spr828 (spr828), unsigned 64 bits
	929: spr829 (spr829), unsigned 64 bits
	930: spr830 (spr830), unsigned 64 bits
	931: spr831 (spr831), unsigned 64 bits
	932: spr832 (spr832), unsigned 64 bits
	933: spr833 (spr833), unsigned 64 bits
	934: spr834 (spr834), unsigned 64 bits
	935: spr835 (spr835), unsigned 64 bits
	936: spr836 (spr836), unsigned 64 bits
	937: spr837 (spr837), unsigned 64 bits
	938: spr838 (spr838), unsigned 64 bits
	939: spr839 (spr839), unsigned 64 bits
	940: spr840 (spr840), unsigned 64 bits
	941: spr841 (spr841), unsigned 64 bits
	942: spr842 (spr842), unsigned 64 bits
	943: spr843 (spr843), unsigned 64 bits
	944: spr844 (spr844), unsigned 64 bits
	945: spr845 (spr845), unsigned 64 bits
	946: spr846 (spr846), unsigned 64 bits
	947: spr847 (spr847), unsigned 64 bits
	948: spr848 (spr848), unsigned 64 bits
	949: spr849 (spr849), unsigned 64 bits
	950: spr850 (spr850), unsigned 64 bits
	951: spr851 (spr851), unsigned 64 bits
	952: spr852 (spr852), unsigned 64 bits
	953: spr853 (spr853), unsigned 64 bits
	954: spr854 (spr854), unsigned 64 bits
	955: spr855 (spr855), unsigned 64 bits
	956: spr856 (spr856), unsigned 64 bits
	957: spr857 (spr857), unsigned 64 bits
	958: spr858 (spr858), unsigned 64 bits
	959: spr859 (spr859), unsigned 64 bits
	960: spr860 (spr860), unsigned 64 bits
	961: spr861 (spr861), unsigned 64 bits
	962: spr862 (spr862), unsigned 64 bits
	963: spr863 (spr863), unsigned 64 bits
	964: spr864 (spr864), unsigned 64 bits
	965: spr865 (spr865), unsigned 64 bits
	966: spr866 (spr866), unsigned 64 bits
	967: spr867 (spr867), unsigned 64 bits
	968: spr868 (spr868), unsigned 64 bits
	969: spr869 (spr869), unsigned 64 bits
	970: spr870 (spr870), unsigned 64 bits
	971: spr871 (spr871), unsigned 64 bits
	972: spr872 (spr872), unsigned 64 bits
	973: spr873 (spr873), unsigned 64 bits
	974: spr874 (spr874), unsigned 64 bits
	975: spr875 (spr875), unsigned 64 bits
	976: spr876 (spr876), unsigned 64 bits
	977: spr877 (spr877), unsigned 64 bits
	978: spr878 (spr878), unsigned 64 bits
	979: spr879 (spr879), unsigned 64 bits
	980: spr880 (spr880), unsigned 64 bits
	981: spr881 (spr881), unsigned 64 bits
	982: spr882 (spr882), unsigned 64 bits
	983: spr883 (spr883), unsigned 64 bits
	984: spr884 (spr884), unsigned 64 bits
	985: spr885 (spr885), unsigned 64 bits
	986: spr886 (spr886), unsigned 64 bits
	987: spr887 (spr887), unsigned 64 bits
	988: spr888 (spr888), unsigned 64 bits
	989: spr889 (spr889), unsigned 64 bits
	990: spr890 (spr890), unsigned 64 bits
	991: spr891 (spr891), unsigned 64 bits
	992: spr892 (spr892), unsigned 64 bits
	993: spr893 (spr893), unsigned 64 bits
	994: spr894 (spr894), unsigned 64 bits
	995: spr895 (spr895), unsigned 64 bits
	996: spr896 (spr896), unsigned 64 bits
	997: spr897 (spr897), unsigned 64 bits
	998: spr898 (spr898), unsigned 64 bits
	999: spr899 (spr899), unsigned 64 bits
vector registers:
	 67: vscr (vscr), unsigned 32 bits
	356: vrsave (vrsave), unsigned 32 bits
	612: spefscr (spefscr), unsigned 32 bits
	1124: vr0 (vr0), unsigned 128 bits
	1125: vr1 (vr1), unsigned 128 bits
	1126: vr2 (vr2), unsigned 128 bits
	1127: vr3 (vr3), unsigned 128 bits
	1128: vr4 (vr4), unsigned 128 bits
	1129: vr5 (vr5), unsigned 128 bits
	1130: vr6 (vr6), unsigned 128 bits
	1131: vr7 (vr7), unsigned 128 bits
	1132: vr8 (vr8), unsigned 128 bits
	1133: vr9 (vr9), unsigned 128 bits
	1134: vr10 (vr10), unsigned 128 bits
	1135: vr11 (vr11), unsigned 128 bits
	1136: vr12 (vr12), unsigned 128 bits
	1137: vr13 (vr13), unsigned 128 bits
	1138: vr14 (vr14), unsigned 128 bits
	1139: vr15 (vr15), unsigned 128 bits
	1140: vr16 (vr16), unsigned 128 bits
	1141: vr17 (vr17), unsigned 128 bits
	1142: vr18 (vr18), unsigned 128 bits
	1143: vr19 (vr19), unsigned 128 bits
	1144: vr20 (vr20), unsigned 128 bits
	1145: vr21 (vr21), unsigned 128 bits
	1146: vr22 (vr22), unsigned 128 bits
	1147: vr23 (vr23), unsigned 128 bits
	1148: vr24 (vr24), unsigned 128 bits
	1149: vr25 (vr25), unsigned 128 bits
	1150: vr26 (vr26), unsigned 128 bits
	1151: vr27 (vr27), unsigned 128 bits
	1152: vr28 (vr28), unsigned 128 bits
	1153: vr29 (vr29), unsigned 128 bits
	1154: vr30 (vr30), unsigned 128 bits
	1155: vr31 (vr31), unsigned 128 bits
EOF

regs_test testfile26 <<\EOF
integer registers:
	  0: %r0 (r0), signed 32 bits
	  1: %r1 (r1), signed 32 bits
	  2: %r2 (r2), signed 32 bits
	  3: %r3 (r3), signed 32 bits
	  4: %r4 (r4), signed 32 bits
	  5: %r5 (r5), signed 32 bits
	  6: %r6 (r6), signed 32 bits
	  7: %r7 (r7), signed 32 bits
	  8: %r8 (r8), signed 32 bits
	  9: %r9 (r9), signed 32 bits
	 10: %r10 (r10), signed 32 bits
	 11: %r11 (r11), signed 32 bits
	 12: %r12 (r12), signed 32 bits
	 13: %r13 (r13), signed 32 bits
	 14: %r14 (r14), signed 32 bits
	 15: %r15 (r15), signed 32 bits
FPU registers:
	 16: %f0 (f0), float 64 bits
	 17: %f2 (f2), float 64 bits
	 18: %f4 (f4), float 64 bits
	 19: %f6 (f6), float 64 bits
	 20: %f1 (f1), float 64 bits
	 21: %f3 (f3), float 64 bits
	 22: %f5 (f5), float 64 bits
	 23: %f7 (f7), float 64 bits
	 24: %f8 (f8), float 64 bits
	 25: %f10 (f10), float 64 bits
	 26: %f12 (f12), float 64 bits
	 27: %f14 (f14), float 64 bits
	 28: %f9 (f9), float 64 bits
	 29: %f11 (f11), float 64 bits
	 30: %f13 (f13), float 64 bits
	 31: %f15 (f15), float 64 bits
access registers:
	 48: %a0 (a0), unsigned 32 bits
	 49: %a1 (a1), unsigned 32 bits
	 50: %a2 (a2), unsigned 32 bits
	 51: %a3 (a3), unsigned 32 bits
	 52: %a4 (a4), unsigned 32 bits
	 53: %a5 (a5), unsigned 32 bits
	 54: %a6 (a6), unsigned 32 bits
	 55: %a7 (a7), unsigned 32 bits
	 56: %a8 (a8), unsigned 32 bits
	 57: %a9 (a9), unsigned 32 bits
	 58: %a10 (a10), unsigned 32 bits
	 59: %a11 (a11), unsigned 32 bits
	 60: %a12 (a12), unsigned 32 bits
	 61: %a13 (a13), unsigned 32 bits
	 62: %a14 (a14), unsigned 32 bits
	 63: %a15 (a15), unsigned 32 bits
control registers:
	 32: %c0 (c0), unsigned 32 bits
	 33: %c1 (c1), unsigned 32 bits
	 34: %c2 (c2), unsigned 32 bits
	 35: %c3 (c3), unsigned 32 bits
	 36: %c4 (c4), unsigned 32 bits
	 37: %c5 (c5), unsigned 32 bits
	 38: %c6 (c6), unsigned 32 bits
	 39: %c7 (c7), unsigned 32 bits
	 40: %c8 (c8), unsigned 32 bits
	 41: %c9 (c9), unsigned 32 bits
	 42: %c10 (c10), unsigned 32 bits
	 43: %c11 (c11), unsigned 32 bits
	 44: %c12 (c12), unsigned 32 bits
	 45: %c13 (c13), unsigned 32 bits
	 46: %c14 (c14), unsigned 32 bits
	 47: %c15 (c15), unsigned 32 bits
	 64: %pswm (pswm), unsigned 32 bits
	 65: %pswa (pswa), address 32 bits
EOF

regs_test testfile27 <<\EOF
integer registers:
	  0: %r0 (r0), signed 64 bits
	  1: %r1 (r1), signed 64 bits
	  2: %r2 (r2), signed 64 bits
	  3: %r3 (r3), signed 64 bits
	  4: %r4 (r4), signed 64 bits
	  5: %r5 (r5), signed 64 bits
	  6: %r6 (r6), signed 64 bits
	  7: %r7 (r7), signed 64 bits
	  8: %r8 (r8), signed 64 bits
	  9: %r9 (r9), signed 64 bits
	 10: %r10 (r10), signed 64 bits
	 11: %r11 (r11), signed 64 bits
	 12: %r12 (r12), signed 64 bits
	 13: %r13 (r13), signed 64 bits
	 14: %r14 (r14), signed 64 bits
	 15: %r15 (r15), signed 64 bits
FPU registers:
	 16: %f0 (f0), float 64 bits
	 17: %f2 (f2), float 64 bits
	 18: %f4 (f4), float 64 bits
	 19: %f6 (f6), float 64 bits
	 20: %f1 (f1), float 64 bits
	 21: %f3 (f3), float 64 bits
	 22: %f5 (f5), float 64 bits
	 23: %f7 (f7), float 64 bits
	 24: %f8 (f8), float 64 bits
	 25: %f10 (f10), float 64 bits
	 26: %f12 (f12), float 64 bits
	 27: %f14 (f14), float 64 bits
	 28: %f9 (f9), float 64 bits
	 29: %f11 (f11), float 64 bits
	 30: %f13 (f13), float 64 bits
	 31: %f15 (f15), float 64 bits
access registers:
	 48: %a0 (a0), unsigned 32 bits
	 49: %a1 (a1), unsigned 32 bits
	 50: %a2 (a2), unsigned 32 bits
	 51: %a3 (a3), unsigned 32 bits
	 52: %a4 (a4), unsigned 32 bits
	 53: %a5 (a5), unsigned 32 bits
	 54: %a6 (a6), unsigned 32 bits
	 55: %a7 (a7), unsigned 32 bits
	 56: %a8 (a8), unsigned 32 bits
	 57: %a9 (a9), unsigned 32 bits
	 58: %a10 (a10), unsigned 32 bits
	 59: %a11 (a11), unsigned 32 bits
	 60: %a12 (a12), unsigned 32 bits
	 61: %a13 (a13), unsigned 32 bits
	 62: %a14 (a14), unsigned 32 bits
	 63: %a15 (a15), unsigned 32 bits
control registers:
	 32: %c0 (c0), unsigned 64 bits
	 33: %c1 (c1), unsigned 64 bits
	 34: %c2 (c2), unsigned 64 bits
	 35: %c3 (c3), unsigned 64 bits
	 36: %c4 (c4), unsigned 64 bits
	 37: %c5 (c5), unsigned 64 bits
	 38: %c6 (c6), unsigned 64 bits
	 39: %c7 (c7), unsigned 64 bits
	 40: %c8 (c8), unsigned 64 bits
	 41: %c9 (c9), unsigned 64 bits
	 42: %c10 (c10), unsigned 64 bits
	 43: %c11 (c11), unsigned 64 bits
	 44: %c12 (c12), unsigned 64 bits
	 45: %c13 (c13), unsigned 64 bits
	 46: %c14 (c14), unsigned 64 bits
	 47: %c15 (c15), unsigned 64 bits
	 64: %pswm (pswm), unsigned 64 bits
	 65: %pswa (pswa), address 64 bits
EOF

regs_test testfile30 <<\EOF
integer registers:
	  0: %g0 (g0), signed 32 bits
	  1: %g1 (g1), signed 32 bits
	  2: %g2 (g2), signed 32 bits
	  3: %g3 (g3), signed 32 bits
	  4: %g4 (g4), signed 32 bits
	  5: %g5 (g5), signed 32 bits
	  6: %g6 (g6), signed 32 bits
	  7: %g7 (g7), signed 32 bits
	  8: %o0 (o0), signed 32 bits
	  9: %o1 (o1), signed 32 bits
	 10: %o2 (o2), signed 32 bits
	 11: %o3 (o3), signed 32 bits
	 12: %o4 (o4), signed 32 bits
	 13: %o5 (o5), signed 32 bits
	 14: %o6 (o6), address 32 bits
	 15: %o7 (o7), signed 32 bits
	 16: %l0 (l0), signed 32 bits
	 17: %l1 (l1), signed 32 bits
	 18: %l2 (l2), signed 32 bits
	 19: %l3 (l3), signed 32 bits
	 20: %l4 (l4), signed 32 bits
	 21: %l5 (l5), signed 32 bits
	 22: %l6 (l6), signed 32 bits
	 23: %l7 (l7), signed 32 bits
	 24: %i0 (i0), signed 32 bits
	 25: %i1 (i1), signed 32 bits
	 26: %i2 (i2), signed 32 bits
	 27: %i3 (i3), signed 32 bits
	 28: %i4 (i4), signed 32 bits
	 29: %i5 (i5), signed 32 bits
	 30: %i6 (i6), address 32 bits
	 31: %i7 (i7), signed 32 bits
FPU registers:
	 32: %f0 (f0), float 32 bits
	 33: %f1 (f1), float 32 bits
	 34: %f2 (f2), float 32 bits
	 35: %f3 (f3), float 32 bits
	 36: %f4 (f4), float 32 bits
	 37: %f5 (f5), float 32 bits
	 38: %f6 (f6), float 32 bits
	 39: %f7 (f7), float 32 bits
	 40: %f8 (f8), float 32 bits
	 41: %f9 (f9), float 32 bits
	 42: %f10 (f10), float 32 bits
	 43: %f11 (f11), float 32 bits
	 44: %f12 (f12), float 32 bits
	 45: %f13 (f13), float 32 bits
	 46: %f14 (f14), float 32 bits
	 47: %f15 (f15), float 32 bits
	 48: %f16 (f16), float 32 bits
	 49: %f17 (f17), float 32 bits
	 50: %f18 (f18), float 32 bits
	 51: %f19 (f19), float 32 bits
	 52: %f20 (f20), float 32 bits
	 53: %f21 (f21), float 32 bits
	 54: %f22 (f22), float 32 bits
	 55: %f23 (f23), float 32 bits
	 56: %f24 (f24), float 32 bits
	 57: %f25 (f25), float 32 bits
	 58: %f26 (f26), float 32 bits
	 59: %f27 (f27), float 32 bits
	 60: %f28 (f28), float 32 bits
	 61: %f29 (f29), float 32 bits
	 62: %f30 (f30), float 32 bits
	 63: %f31 (f31), float 32 bits
control registers:
	 64: %y (y), unsigned 32 bits
	 65: %psr (psr), unsigned 32 bits
	 66: %wim (wim), unsigned 32 bits
	 67: %tbr (tbr), unsigned 32 bits
	 68: %pc (pc), address 32 bits
	 69: %npc (npc), address 32 bits
	 70: %fsr (fsr), unsigned 32 bits
	 71: %csr (csr), unsigned 32 bits
EOF

regs_test testfile31 <<\EOF
integer registers:
	  0: %g0 (g0), signed 64 bits
	  1: %g1 (g1), signed 64 bits
	  2: %g2 (g2), signed 64 bits
	  3: %g3 (g3), signed 64 bits
	  4: %g4 (g4), signed 64 bits
	  5: %g5 (g5), signed 64 bits
	  6: %g6 (g6), signed 64 bits
	  7: %g7 (g7), signed 64 bits
	  8: %o0 (o0), signed 64 bits
	  9: %o1 (o1), signed 64 bits
	 10: %o2 (o2), signed 64 bits
	 11: %o3 (o3), signed 64 bits
	 12: %o4 (o4), signed 64 bits
	 13: %o5 (o5), signed 64 bits
	 14: %o6 (o6), address 64 bits
	 15: %o7 (o7), signed 64 bits
	 16: %l0 (l0), signed 64 bits
	 17: %l1 (l1), signed 64 bits
	 18: %l2 (l2), signed 64 bits
	 19: %l3 (l3), signed 64 bits
	 20: %l4 (l4), signed 64 bits
	 21: %l5 (l5), signed 64 bits
	 22: %l6 (l6), signed 64 bits
	 23: %l7 (l7), signed 64 bits
	 24: %i0 (i0), signed 64 bits
	 25: %i1 (i1), signed 64 bits
	 26: %i2 (i2), signed 64 bits
	 27: %i3 (i3), signed 64 bits
	 28: %i4 (i4), signed 64 bits
	 29: %i5 (i5), signed 64 bits
	 30: %i6 (i6), address 64 bits
	 31: %i7 (i7), signed 64 bits
FPU registers:
	 32: %f0 (f0), float 32 bits
	 33: %f1 (f1), float 32 bits
	 34: %f2 (f2), float 32 bits
	 35: %f3 (f3), float 32 bits
	 36: %f4 (f4), float 32 bits
	 37: %f5 (f5), float 32 bits
	 38: %f6 (f6), float 32 bits
	 39: %f7 (f7), float 32 bits
	 40: %f8 (f8), float 32 bits
	 41: %f9 (f9), float 32 bits
	 42: %f10 (f10), float 32 bits
	 43: %f11 (f11), float 32 bits
	 44: %f12 (f12), float 32 bits
	 45: %f13 (f13), float 32 bits
	 46: %f14 (f14), float 32 bits
	 47: %f15 (f15), float 32 bits
	 48: %f16 (f16), float 32 bits
	 49: %f17 (f17), float 32 bits
	 50: %f18 (f18), float 32 bits
	 51: %f19 (f19), float 32 bits
	 52: %f20 (f20), float 32 bits
	 53: %f21 (f21), float 32 bits
	 54: %f22 (f22), float 32 bits
	 55: %f23 (f23), float 32 bits
	 56: %f24 (f24), float 32 bits
	 57: %f25 (f25), float 32 bits
	 58: %f26 (f26), float 32 bits
	 59: %f27 (f27), float 32 bits
	 60: %f28 (f28), float 32 bits
	 61: %f29 (f29), float 32 bits
	 62: %f30 (f30), float 32 bits
	 63: %f31 (f31), float 32 bits
	 64: %f32 (f32), float 64 bits
	 65: %f34 (f34), float 64 bits
	 66: %f36 (f36), float 64 bits
	 67: %f38 (f38), float 64 bits
	 68: %f40 (f40), float 64 bits
	 69: %f42 (f42), float 64 bits
	 70: %f44 (f44), float 64 bits
	 71: %f46 (f46), float 64 bits
	 72: %f48 (f48), float 64 bits
	 73: %f50 (f50), float 64 bits
	 74: %f52 (f52), float 64 bits
	 75: %f54 (f54), float 64 bits
	 76: %f56 (f56), float 64 bits
	 77: %f58 (f58), float 64 bits
	 78: %f60 (f60), float 64 bits
	 79: %f62 (f62), float 64 bits
control registers:
	 80: %pc (pc), address 64 bits
	 81: %npc (npc), address 64 bits
	 82: %state (state), unsigned 64 bits
	 83: %fsr (fsr), unsigned 64 bits
	 84: %fprs (fprs), unsigned 64 bits
	 85: %y (y), unsigned 64 bits
EOF

regs_test testfile10 <<\EOF
integer registers:
	  0: $v0 (v0), signed 64 bits
	  1: $t0 (t0), signed 64 bits
	  2: $t1 (t1), signed 64 bits
	  3: $t2 (t2), signed 64 bits
	  4: $t3 (t3), signed 64 bits
	  5: $t4 (t4), signed 64 bits
	  6: $t5 (t5), signed 64 bits
	  7: $t6 (t6), signed 64 bits
	  8: $t7 (t7), signed 64 bits
	  9: $s0 (s0), signed 64 bits
	 10: $s1 (s1), signed 64 bits
	 11: $s2 (s2), signed 64 bits
	 12: $s3 (s3), signed 64 bits
	 13: $s4 (s4), signed 64 bits
	 14: $s5 (s5), signed 64 bits
	 15: $s6 (s6), signed 64 bits
	 16: $a0 (a0), signed 64 bits
	 17: $a1 (a1), signed 64 bits
	 18: $a2 (a2), signed 64 bits
	 19: $a3 (a3), signed 64 bits
	 20: $a4 (a4), signed 64 bits
	 21: $a5 (a5), signed 64 bits
	 22: $t8 (t8), signed 64 bits
	 23: $t9 (t9), signed 64 bits
	 24: $t10 (t10), signed 64 bits
	 25: $t11 (t11), signed 64 bits
	 26: $ra (ra), address 64 bits
	 27: $t12 (t12), signed 64 bits
	 28: $at (at), signed 64 bits
	 29: $gp (gp), address 64 bits
	 30: $sp (sp), address 64 bits
	 31: $zero (zero), signed 64 bits
	 64: $pc (pc), address 64 bits
	 66: $unique (unique), address 64 bits
FPU registers:
	 32: $f0 (f0), float 64 bits
	 33: $f1 (f1), float 64 bits
	 34: $f2 (f2), float 64 bits
	 35: $f3 (f3), float 64 bits
	 36: $f4 (f4), float 64 bits
	 37: $f5 (f5), float 64 bits
	 38: $f6 (f6), float 64 bits
	 39: $f7 (f7), float 64 bits
	 40: $f8 (f8), float 64 bits
	 41: $f9 (f9), float 64 bits
	 42: $f10 (f10), float 64 bits
	 43: $f11 (f11), float 64 bits
	 44: $f12 (f12), float 64 bits
	 45: $f13 (f13), float 64 bits
	 46: $f14 (f14), float 64 bits
	 47: $f15 (f15), float 64 bits
	 48: $f16 (f16), float 64 bits
	 49: $f17 (f17), float 64 bits
	 50: $f18 (f18), float 64 bits
	 51: $f19 (f19), float 64 bits
	 52: $f20 (f20), float 64 bits
	 53: $f21 (f21), float 64 bits
	 54: $f22 (f22), float 64 bits
	 55: $f23 (f23), float 64 bits
	 56: $f24 (f24), float 64 bits
	 57: $f25 (f25), float 64 bits
	 58: $f26 (f26), float 64 bits
	 59: $f27 (f27), float 64 bits
	 60: $f28 (f28), float 64 bits
	 61: $f29 (f29), float 64 bits
	 62: $f30 (f30), float 64 bits
	 63: $fpcr (fpcr), unsigned 64 bits
EOF

regs_test testfile60 <<\EOF
integer registers:
	  0: r0 (r0), signed 64 bits
	  1: r1 (r1), signed 64 bits
	  2: r2 (r2), signed 64 bits
	  3: r3 (r3), signed 64 bits
	  4: r4 (r4), signed 64 bits
	  5: r5 (r5), signed 64 bits
	  6: r6 (r6), signed 64 bits
	  7: r7 (r7), signed 64 bits
	  8: r8 (r8), signed 64 bits
	  9: r9 (r9), signed 64 bits
	 10: r10 (r10), signed 64 bits
	 11: r11 (r11), signed 64 bits
	 12: r12 (r12), signed 64 bits
	 13: r13 (r13), signed 64 bits
	 14: r14 (r14), signed 64 bits
	 15: r15 (r15), signed 64 bits
	 16: r16 (r16), signed 64 bits
	 17: r17 (r17), signed 64 bits
	 18: r18 (r18), signed 64 bits
	 19: r19 (r19), signed 64 bits
	 20: r20 (r20), signed 64 bits
	 21: r21 (r21), signed 64 bits
	 22: r22 (r22), signed 64 bits
	 23: r23 (r23), signed 64 bits
	 24: r24 (r24), signed 64 bits
	 25: r25 (r25), signed 64 bits
	 26: r26 (r26), signed 64 bits
	 27: r27 (r27), signed 64 bits
	 28: r28 (r28), signed 64 bits
	 29: r29 (r29), signed 64 bits
	 30: r30 (r30), signed 64 bits
	 31: r31 (r31), signed 64 bits
	 32: r32 (r32), signed 64 bits
	 33: r33 (r33), signed 64 bits
	 34: r34 (r34), signed 64 bits
	 35: r35 (r35), signed 64 bits
	 36: r36 (r36), signed 64 bits
	 37: r37 (r37), signed 64 bits
	 38: r38 (r38), signed 64 bits
	 39: r39 (r39), signed 64 bits
	 40: r40 (r40), signed 64 bits
	 41: r41 (r41), signed 64 bits
	 42: r42 (r42), signed 64 bits
	 43: r43 (r43), signed 64 bits
	 44: r44 (r44), signed 64 bits
	 45: r45 (r45), signed 64 bits
	 46: r46 (r46), signed 64 bits
	 47: r47 (r47), signed 64 bits
	 48: r48 (r48), signed 64 bits
	 49: r49 (r49), signed 64 bits
	 50: r50 (r50), signed 64 bits
	 51: r51 (r51), signed 64 bits
	 52: r52 (r52), signed 64 bits
	 53: tp (tp), address 64 bits
	 54: sp (sp), address 64 bits
	 55: lr (lr), address 64 bits
	 56: sn (sn), unsigned 64 bits
	 57: idn0 (idn0), unsigned 64 bits
	 58: idn1 (idn1), unsigned 64 bits
	 59: udn0 (udn0), unsigned 64 bits
	 60: udn1 (udn1), unsigned 64 bits
	 61: udn2 (udn2), unsigned 64 bits
	 62: udn3 (udn3), unsigned 64 bits
	 63: zero (zero), unsigned 64 bits
	 64: pc (pc), address 64 bits
EOF

regs_test testfile61 <<\EOF
integer registers:
	  0: r0 (r0), signed 32 bits
	  1: r1 (r1), signed 32 bits
	  2: r2 (r2), signed 32 bits
	  3: r3 (r3), signed 32 bits
	  4: r4 (r4), signed 32 bits
	  5: r5 (r5), signed 32 bits
	  6: r6 (r6), signed 32 bits
	  7: r7 (r7), signed 32 bits
	  8: r8 (r8), signed 32 bits
	  9: r9 (r9), signed 32 bits
	 10: r10 (r10), signed 32 bits
	 11: r11 (r11), signed 32 bits
	 12: r12 (r12), signed 32 bits
	 13: sp (sp), address 32 bits
	 14: lr (lr), address 32 bits
	 15: pc (pc), address 32 bits
	128: spsr (spsr), unsigned 32 bits
FPA registers:
	 16: f0 (f0), float 96 bits
	 17: f1 (f1), float 96 bits
	 18: f2 (f2), float 96 bits
	 19: f3 (f3), float 96 bits
	 20: f4 (f4), float 96 bits
	 21: f5 (f5), float 96 bits
	 22: f6 (f6), float 96 bits
	 23: f7 (f7), float 96 bits
	 96: f0 (f0), float 96 bits
	 97: f1 (f1), float 96 bits
	 98: f2 (f2), float 96 bits
	 99: f3 (f3), float 96 bits
	100: f4 (f4), float 96 bits
	101: f5 (f5), float 96 bits
	102: f6 (f6), float 96 bits
	103: f7 (f7), float 96 bits
VFP registers:
	256: d0 (d0), float 64 bits
	257: d1 (d1), float 64 bits
	258: d2 (d2), float 64 bits
	259: d3 (d3), float 64 bits
	260: d4 (d4), float 64 bits
	261: d5 (d5), float 64 bits
	262: d6 (d6), float 64 bits
	263: d7 (d7), float 64 bits
	264: d8 (d8), float 64 bits
	265: d9 (d9), float 64 bits
	266: d10 (d10), float 64 bits
	267: d11 (d11), float 64 bits
	268: d12 (d12), float 64 bits
	269: d13 (d13), float 64 bits
	270: d14 (d14), float 64 bits
	271: d15 (d15), float 64 bits
	272: d16 (d16), float 64 bits
	273: d17 (d17), float 64 bits
	274: d18 (d18), float 64 bits
	275: d19 (d19), float 64 bits
	276: d20 (d20), float 64 bits
	277: d21 (d21), float 64 bits
	278: d22 (d22), float 64 bits
	279: d23 (d23), float 64 bits
	280: d24 (d24), float 64 bits
	281: d25 (d25), float 64 bits
	282: d26 (d26), float 64 bits
	283: d27 (d27), float 64 bits
	284: d28 (d28), float 64 bits
	285: d29 (d29), float 64 bits
	286: d30 (d30), float 64 bits
	287: d31 (d31), float 64 bits
EOF

# See run-readelf-mixed-corenote.sh for instructions to regenerate
# this core file.
regs_test testfile_aarch64_core <<\EOF
integer registers:
	  0: x0 (x0), signed 64 bits
	  1: x1 (x1), signed 64 bits
	  2: x2 (x2), signed 64 bits
	  3: x3 (x3), signed 64 bits
	  4: x4 (x4), signed 64 bits
	  5: x5 (x5), signed 64 bits
	  6: x6 (x6), signed 64 bits
	  7: x7 (x7), signed 64 bits
	  8: x8 (x8), signed 64 bits
	  9: x9 (x9), signed 64 bits
	 10: x10 (x10), signed 64 bits
	 11: x11 (x11), signed 64 bits
	 12: x12 (x12), signed 64 bits
	 13: x13 (x13), signed 64 bits
	 14: x14 (x14), signed 64 bits
	 15: x15 (x15), signed 64 bits
	 16: x16 (x16), signed 64 bits
	 17: x17 (x17), signed 64 bits
	 18: x18 (x18), signed 64 bits
	 19: x19 (x19), signed 64 bits
	 20: x20 (x20), signed 64 bits
	 21: x21 (x21), signed 64 bits
	 22: x22 (x22), signed 64 bits
	 23: x23 (x23), signed 64 bits
	 24: x24 (x24), signed 64 bits
	 25: x25 (x25), signed 64 bits
	 26: x26 (x26), signed 64 bits
	 27: x27 (x27), signed 64 bits
	 28: x28 (x28), signed 64 bits
	 29: x29 (x29), signed 64 bits
	 30: x30 (x30), signed 64 bits
	 31: sp (sp), address 64 bits
	 33: elr (elr), address 64 bits
FP/SIMD registers:
	 64: v0 (v0), unsigned 128 bits
	 65: v1 (v1), unsigned 128 bits
	 66: v2 (v2), unsigned 128 bits
	 67: v3 (v3), unsigned 128 bits
	 68: v4 (v4), unsigned 128 bits
	 69: v5 (v5), unsigned 128 bits
	 70: v6 (v6), unsigned 128 bits
	 71: v7 (v7), unsigned 128 bits
	 72: v8 (v8), unsigned 128 bits
	 73: v9 (v9), unsigned 128 bits
	 74: v10 (v10), unsigned 128 bits
	 75: v11 (v11), unsigned 128 bits
	 76: v12 (v12), unsigned 128 bits
	 77: v13 (v13), unsigned 128 bits
	 78: v14 (v14), unsigned 128 bits
	 79: v15 (v15), unsigned 128 bits
	 80: v16 (v16), unsigned 128 bits
	 81: v17 (v17), unsigned 128 bits
	 82: v18 (v18), unsigned 128 bits
	 83: v19 (v19), unsigned 128 bits
	 84: v20 (v20), unsigned 128 bits
	 85: v21 (v21), unsigned 128 bits
	 86: v22 (v22), unsigned 128 bits
	 87: v23 (v23), unsigned 128 bits
	 88: v24 (v24), unsigned 128 bits
	 89: v25 (v25), unsigned 128 bits
	 90: v26 (v26), unsigned 128 bits
	 91: v27 (v27), unsigned 128 bits
	 92: v28 (v28), unsigned 128 bits
	 93: v29 (v29), unsigned 128 bits
	 94: v30 (v30), unsigned 128 bits
	 95: v31 (v31), unsigned 128 bits
EOF

# See run-readelf-mixed-corenote.sh for instructions to regenerate
# this core file.
regs_test testfile-x32-core <<\EOF
integer registers:
	  0: %rax (rax), signed 64 bits
	  1: %rdx (rdx), signed 64 bits
	  2: %rcx (rcx), signed 64 bits
	  3: %rbx (rbx), signed 64 bits
	  4: %rsi (rsi), signed 64 bits
	  5: %rdi (rdi), signed 64 bits
	  6: %rbp (rbp), address 64 bits
	  7: %rsp (rsp), address 64 bits
	  8: %r8 (r8), signed 64 bits
	  9: %r9 (r9), signed 64 bits
	 10: %r10 (r10), signed 64 bits
	 11: %r11 (r11), signed 64 bits
	 12: %r12 (r12), signed 64 bits
	 13: %r13 (r13), signed 64 bits
	 14: %r14 (r14), signed 64 bits
	 15: %r15 (r15), signed 64 bits
	 16: %rip (rip), address 64 bits
	 49: %rflags (rflags), unsigned 64 bits
MMX registers:
	 41: %mm0 (mm0), unsigned 64 bits
	 42: %mm1 (mm1), unsigned 64 bits
	 43: %mm2 (mm2), unsigned 64 bits
	 44: %mm3 (mm3), unsigned 64 bits
	 45: %mm4 (mm4), unsigned 64 bits
	 46: %mm5 (mm5), unsigned 64 bits
	 47: %mm6 (mm6), unsigned 64 bits
	 48: %mm7 (mm7), unsigned 64 bits
SSE registers:
	 17: %xmm0 (xmm0), unsigned 128 bits
	 18: %xmm1 (xmm1), unsigned 128 bits
	 19: %xmm2 (xmm2), unsigned 128 bits
	 20: %xmm3 (xmm3), unsigned 128 bits
	 21: %xmm4 (xmm4), unsigned 128 bits
	 22: %xmm5 (xmm5), unsigned 128 bits
	 23: %xmm6 (xmm6), unsigned 128 bits
	 24: %xmm7 (xmm7), unsigned 128 bits
	 25: %xmm8 (xmm8), unsigned 128 bits
	 26: %xmm9 (xmm9), unsigned 128 bits
	 27: %xmm10 (xmm10), unsigned 128 bits
	 28: %xmm11 (xmm11), unsigned 128 bits
	 29: %xmm12 (xmm12), unsigned 128 bits
	 30: %xmm13 (xmm13), unsigned 128 bits
	 31: %xmm14 (xmm14), unsigned 128 bits
	 32: %xmm15 (xmm15), unsigned 128 bits
control registers:
	 62: %tr (tr), unsigned 64 bits
	 63: %ldtr (ldtr), unsigned 64 bits
	 64: %mxcsr (mxcsr), unsigned 64 bits
	 65: %fcw (fcw), unsigned 16 bits
	 66: %fsw (fsw), unsigned 16 bits
segment registers:
	 50: %es (es), unsigned 16 bits
	 51: %cs (cs), unsigned 16 bits
	 52: %ss (ss), unsigned 16 bits
	 53: %ds (ds), unsigned 16 bits
	 54: %fs (fs), unsigned 16 bits
	 55: %gs (gs), unsigned 16 bits
	 58: %fs.base (fs.base), address 64 bits
	 59: %gs.base (gs.base), address 64 bits
x87 registers:
	 33: %st0 (st0), float 80 bits
	 34: %st1 (st1), float 80 bits
	 35: %st2 (st2), float 80 bits
	 36: %st3 (st3), float 80 bits
	 37: %st4 (st4), float 80 bits
	 38: %st5 (st5), float 80 bits
	 39: %st6 (st6), float 80 bits
	 40: %st7 (st7), float 80 bits
EOF
exit 0
