static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1997 Spencer Kimball                                             \n"
" * Copyright 2011 Hans Lo <hansshulo@gmail.com>                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (mask_radius, _(\"Mask Radius\"), 10.0)                       \n"
"    value_range (0.0, 50.0)                                                   \n"
"                                                                              \n"
"property_double (sharpness, _(\"Sharpness\"), 0.5)                            \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (black, _(\"Percent Black\"), 0.2)                            \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (white, _(\"Percent White\"), 0.2)                            \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE photocopy.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define THRESHOLD 0.75                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"grey_blur_buffer (GeglBuffer  *input,                                         \n"
"                  gdouble      sharpness,                                     \n"
"                  gdouble      mask_radius,                                   \n"
"                  GeglBuffer **dest1,                                         \n"
"                  GeglBuffer **dest2)                                         \n"
"{                                                                             \n"
"  GeglNode *gegl, *image, *write1, *write2, *blur1, *blur2;                   \n"
"  gdouble radius, std_dev1, std_dev2;                                         \n"
"                                                                              \n"
"  gegl = gegl_node_new ();                                                    \n"
"  image = gegl_node_new_child (gegl,                                          \n"
"                               \"operation\", \"gegl:buffer-source\",         \n"
"                               \"buffer\", input,                             \n"
"                               NULL);                                         \n"
"                                                                              \n"
"  radius   = MAX (1.0, 10 * (1.0 - sharpness));                               \n"
"  radius   = fabs (radius) + 1.0;                                             \n"
"  std_dev1 = sqrt (-(radius * radius) / (2 * log (1.0 / 255.0)));             \n"
"                                                                              \n"
"  radius   = fabs (mask_radius) + 1.0;                                        \n"
"  std_dev2 = sqrt (-(radius * radius) / (2 * log (1.0 / 255.0)));             \n"
"                                                                              \n"
"  blur1 =  gegl_node_new_child (gegl,                                         \n"
"                                \"operation\", \"gegl:gaussian-blur\",        \n"
"                                \"std_dev_x\", std_dev1,                      \n"
"                                \"std_dev_y\", std_dev1,                      \n"
"                                NULL);                                        \n"
"  blur2 =  gegl_node_new_child (gegl,                                         \n"
"                                \"operation\", \"gegl:gaussian-blur\",        \n"
"                                \"std_dev_x\", std_dev2,                      \n"
"                                \"std_dev_y\", std_dev2,                      \n"
"                                NULL);                                        \n"
"                                                                              \n"
"  write1 = gegl_node_new_child (gegl,                                         \n"
"                                \"operation\", \"gegl:buffer-sink\",          \n"
"                                \"buffer\", dest1, NULL);                     \n"
"                                                                              \n"
"  write2 = gegl_node_new_child (gegl,                                         \n"
"                                \"operation\", \"gegl:buffer-sink\",          \n"
"                                \"buffer\", dest2, NULL);                     \n"
"                                                                              \n"
"  gegl_node_link_many (image, blur1, write1, NULL);                           \n"
"  gegl_node_process (write1);                                                 \n"
"                                                                              \n"
"  gegl_node_link_many (image, blur2, write2, NULL);                           \n"
"  gegl_node_process (write2);                                                 \n"
"                                                                              \n"
"  g_object_unref (gegl);                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static gdouble                                                                \n"
"calculate_threshold (gint    *hist,                                           \n"
"                     gdouble  pct,                                            \n"
"                     gint     count,                                          \n"
"                     gint     under_threshold)                                \n"
"{                                                                             \n"
"  gint    sum;                                                                \n"
"  gint    i;                                                                  \n"
"                                                                              \n"
"  if (pct == 0.0 || count == 0)                                               \n"
"    return (under_threshold ? 1.0 : 0.0);                                     \n"
"                                                                              \n"
"  sum = 0;                                                                    \n"
"  for (i = 0; i < 2000; i++)                                                  \n"
"    {                                                                         \n"
"      sum += hist[i];                                                         \n"
"      if (((gdouble) sum / (gdouble) count) > pct)                            \n"
"        {                                                                     \n"
"          if (under_threshold)                                                \n"
"            return (THRESHOLD - (gdouble) i / 1000.0);                        \n"
"          else                                                                \n"
"            return ((gdouble) i / 1000.0 - THRESHOLD);                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return (under_threshold ? 0.0 : 1.0);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"compute_ramp (GeglBuffer          *dest1,                                     \n"
"              GeglBuffer          *dest2,                                     \n"
"              const GeglRectangle *roi,                                       \n"
"              gdouble              pct_black,                                 \n"
"              gdouble              pct_white,                                 \n"
"              gboolean             under_threshold,                           \n"
"              gdouble             *threshold_black,                           \n"
"              gdouble             *threshold_white)                           \n"
"{                                                                             \n"
"  GeglBufferIterator *iter;                                                   \n"
"                                                                              \n"
"  gint    hist1[2000];                                                        \n"
"  gint    hist2[2000];                                                        \n"
"  gdouble diff;                                                               \n"
"  gint    count;                                                              \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (dest1, roi, 0,                             \n"
"                                   babl_format (\"Y float\"),                 \n"
"                                   GEGL_ACCESS_READ,                          \n"
"                                   GEGL_ABYSS_NONE);                          \n"
"  gegl_buffer_iterator_add (iter, dest2, roi, 0,                              \n"
"                            babl_format (\"Y float\"),                        \n"
"                            GEGL_ACCESS_READ,                                 \n"
"                            GEGL_ABYSS_NONE);                                 \n"
"                                                                              \n"
"  memset (hist1, 0, sizeof (int) * 2000);                                     \n"
"  memset (hist2, 0, sizeof (int) * 2000);                                     \n"
"  count = 0;                                                                  \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"  {                                                                           \n"
"    gint n_pixels = iter->length;                                             \n"
"    gfloat *ptr1  = iter->data[0];                                            \n"
"    gfloat *ptr2  = iter->data[1];                                            \n"
"                                                                              \n"
"    while (n_pixels--)                                                        \n"
"      {                                                                       \n"
"        diff = *ptr1 / *ptr2;                                                 \n"
"        ptr1++;                                                               \n"
"        ptr2++;                                                               \n"
"                                                                              \n"
"        if (under_threshold)                                                  \n"
"          {                                                                   \n"
"            if (diff < THRESHOLD && diff >= 0.0f)                             \n"
"              {                                                               \n"
"                hist2[(int) (diff * 1000)] ++;                                \n"
"                count ++;                                                     \n"
"              }                                                               \n"
"          }                                                                   \n"
"        else                                                                  \n"
"          {                                                                   \n"
"            if (diff >= THRESHOLD && diff < 2.0)                              \n"
"              {                                                               \n"
"                hist1[(int) (diff * 1000)] ++;                                \n"
"                count ++;                                                     \n"
"              }                                                               \n"
"          }                                                                   \n"
"                                                                              \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  *threshold_black = calculate_threshold (hist1, pct_black, count, 0);        \n"
"  *threshold_white = calculate_threshold (hist2, pct_white, count, 1);        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"Y float\"));                      \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"Y float\"));                      \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  /* Don't request an infinite plane */                                       \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferIterator *iter;                                                   \n"
"                                                                              \n"
"  GeglBuffer *dest1;                                                          \n"
"  GeglBuffer *dest2;                                                          \n"
"                                                                              \n"
"  gdouble diff;                                                               \n"
"  gdouble ramp_down;                                                          \n"
"  gdouble ramp_up;                                                            \n"
"  gdouble mult;                                                               \n"
"                                                                              \n"
"  grey_blur_buffer (input, o->sharpness, o->mask_radius, &dest1, &dest2);     \n"
"                                                                              \n"
"  compute_ramp (dest1, dest2, result,                                         \n"
"                o->black, o->white, TRUE,                                     \n"
"                &ramp_down, &ramp_up);                                        \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (dest1, result, 0,                          \n"
"                                   babl_format (\"Y float\"),                 \n"
"                                   GEGL_ACCESS_READ,                          \n"
"                                   GEGL_ABYSS_NONE);                          \n"
"  gegl_buffer_iterator_add (iter, dest2, result, 0,                           \n"
"                            babl_format (\"Y float\"),                        \n"
"                            GEGL_ACCESS_READ,                                 \n"
"                            GEGL_ABYSS_NONE);                                 \n"
"  gegl_buffer_iterator_add (iter, output, result, 0,                          \n"
"                            babl_format (\"Y float\"),                        \n"
"                            GEGL_ACCESS_WRITE,                                \n"
"                            GEGL_ABYSS_NONE);                                 \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gint    n_pixels  = iter->length;                                       \n"
"      gfloat *ptr1      = iter->data[0];                                      \n"
"      gfloat *ptr2      = iter->data[1];                                      \n"
"      gfloat *out_pixel = iter->data[2];                                      \n"
"                                                                              \n"
"      while (n_pixels--)                                                      \n"
"        {                                                                     \n"
"          diff = *ptr1 / *ptr2;                                               \n"
"          if (diff < THRESHOLD)                                               \n"
"            {                                                                 \n"
"              if (ramp_down == 0.0)                                           \n"
"                *out_pixel = 0.0;                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  mult = (ramp_down - MIN (ramp_down,                         \n"
"                                           (THRESHOLD - diff))) / ramp_down;  \n"
"                  *out_pixel = *ptr1 * mult;                                  \n"
"                }                                                             \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              if (ramp_up == 0.0)                                             \n"
"                mult = 1.0;                                                   \n"
"              else                                                            \n"
"                mult = MIN (ramp_up,                                          \n"
"                            (diff - THRESHOLD)) / ramp_up;                    \n"
"                                                                              \n"
"              *out_pixel = mult + *ptr1 - mult * *ptr1;                       \n"
"            }                                                                 \n"
"                                                                              \n"
"          ptr1++;                                                             \n"
"          ptr2++;                                                             \n"
"          out_pixel++;                                                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref (dest1);                                                     \n"
"  g_object_unref (dest2);                                                     \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"  filter_class->process                    = process;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:photocopy\",                                      \n"
"    \"categories\",  \"artistic\",                                            \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"title\",       _(\"Photocopy\"),                                        \n"
"    \"description\", _(\"Simulate color distortion produced by a copy machine\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
