; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-unknown-linux-gnu -O3 -ppc-asm-full-reg-names -verify-machineinstrs < %s | FileCheck %s

; Test cases are generated from:
; long long NAME(PARAM a, PARAM b) {
;   if (LHS > RHS)
;     return b;
;   if (LHS < RHS)
;     return a;\
;   return a * b;
; }
; Please note funtion name is defined as <PARAM>_<LHS>_<RHS>. Take ll_a_op_b__1
; for example. ll is PARAM, a_op_b (i.e., a << b) is LHS, _1 (i.e., -1) is RHS.

target datalayout = "e-m:e-i64:64-n32:64"

define i64 @ll_a_op_b__2(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a_op_b__2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sld r5, r3, r4
; CHECK-NEXT:    cmpdi r5, -2
; CHECK-NEXT:    ble cr0, .LBB0_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB0_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, -2
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b__1(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a_op_b__1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sld r5, r3, r4
; CHECK-NEXT:    cmpdi r5, -1
; CHECK-NEXT:    ble cr0, .LBB1_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB1_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, -1
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_0(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a_op_b_0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sld. r5, r3, r4
; CHECK-NEXT:    ble cr0, .LBB2_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB2_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 0
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_1(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a_op_b_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sld r5, r3, r4
; CHECK-NEXT:    cmpdi r5, 1
; CHECK-NEXT:    ble cr0, .LBB3_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB3_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 1
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_2(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a_op_b_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sld r5, r3, r4
; CHECK-NEXT:    cmpdi r5, 2
; CHECK-NEXT:    ble cr0, .LBB4_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB4_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 2
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a__2(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a__2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, -2
; CHECK-NEXT:    ble cr0, .LBB5_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB5_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, -2
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a__1(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a__1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, -1
; CHECK-NEXT:    ble cr0, .LBB6_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB6_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, -1
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_0(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a_0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 0
; CHECK-NEXT:    ble cr0, .LBB7_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB7_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 0
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_1(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    ble cr0, .LBB8_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB8_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 1
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_2(i64 %a, i64 %b) {
; CHECK-LABEL: ll_a_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 2
; CHECK-NEXT:    ble cr0, .LBB9_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB9_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mulld r3, r4, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 2
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @i_a_op_b__2(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a_op_b__2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slw r5, r3, r4
; CHECK-NEXT:    cmpwi r5, -2
; CHECK-NEXT:    bgt cr0, .LBB10_2
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:  .LBB10_2: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, -2
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b__1(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a_op_b__1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slw r5, r3, r4
; CHECK-NEXT:    cmpwi r5, -1
; CHECK-NEXT:    ble cr0, .LBB11_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB11_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, -1
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_0(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a_op_b_0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slw r5, r3, r4
; CHECK-NEXT:    cmpwi r5, 0
; CHECK-NEXT:    ble cr0, .LBB12_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB12_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 0
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_1(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a_op_b_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slw r5, r3, r4
; CHECK-NEXT:    cmpwi r5, 1
; CHECK-NEXT:    bgt cr0, .LBB13_2
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:  .LBB13_2: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 1
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_2(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a_op_b_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slw r5, r3, r4
; CHECK-NEXT:    cmpwi r5, 2
; CHECK-NEXT:    bgt cr0, .LBB14_2
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:  .LBB14_2: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 2
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a__2(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a__2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, -2
; CHECK-NEXT:    bgt cr0, .LBB15_2
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:  .LBB15_2: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, -2
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a__1(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a__1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, -1
; CHECK-NEXT:    ble cr0, .LBB16_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB16_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, -1
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_0(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a_0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 0
; CHECK-NEXT:    ble cr0, .LBB17_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB17_2: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 0
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_1(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    bgt cr0, .LBB18_2
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:  .LBB18_2: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 1
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_2(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: i_a_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 2
; CHECK-NEXT:    bgt cr0, .LBB19_2
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    li r5, 1
; CHECK-NEXT:    isel r4, r5, r4, lt
; CHECK-NEXT:    mullw r4, r4, r3
; CHECK-NEXT:  .LBB19_2: # %return
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 2
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}
