; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -codegenprepare -cgp-optimize-phi-types=true %s -S | FileCheck %s

target datalayout = "e-m:e-p:32:32-f64:32:64-f80:32-n8:16:32-S128"
target triple = "i386-unknown-linux-gnu"

define float @convphi1(i32 *%s, i32 *%d, i32 %n) {
; CHECK-LABEL: @convphi1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP15:%.*]] = icmp sgt i32 [[N:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP15]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[LS:%.*]] = load i32, i32* [[S:%.*]], align 4
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[LD:%.*]] = load i32, i32* [[D:%.*]], align 4
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ [[LS]], [[THEN]] ], [ [[LD]], [[ELSE]] ]
; CHECK-NEXT:    [[B:%.*]] = bitcast i32 [[PHI]] to float
; CHECK-NEXT:    ret float [[B]]
;
entry:
  %cmp15 = icmp sgt i32 %n, 0
  br i1 %cmp15, label %then, label %else

then:
  %ls = load i32, i32* %s, align 4
  br label %end

else:
  %ld = load i32, i32* %d, align 4
  br label %end

end:
  %phi = phi i32 [ %ls, %then ], [ %ld, %else ]
  %b = bitcast i32 %phi to float
  ret float %b
}
