// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{
    Accessible, AccessibleRole, Align, Buildable, CellEditable, ConstraintTarget, Editable,
    EntryBuffer, EntryCompletion, EntryIconPosition, ImageType, InputHints, InputPurpose,
    LayoutManager, Overflow, Widget, ffi,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkEntry")]
    pub struct Entry(Object<ffi::GtkEntry, ffi::GtkEntryClass>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, CellEditable, Editable;

    match fn {
        type_ => || ffi::gtk_entry_get_type(),
    }
}

impl Entry {
    pub const NONE: Option<&'static Entry> = None;

    #[doc(alias = "gtk_entry_new")]
    pub fn new() -> Entry {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_entry_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_entry_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &impl IsA<EntryBuffer>) -> Entry {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_entry_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Entry`] objects.
    ///
    /// This method returns an instance of [`EntryBuilder`](crate::builders::EntryBuilder) which can be used to create [`Entry`] objects.
    pub fn builder() -> EntryBuilder {
        EntryBuilder::new()
    }
}

impl Default for Entry {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Entry`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct EntryBuilder {
    builder: glib::object::ObjectBuilder<'static, Entry>,
}

impl EntryBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn activates_default(self, activates_default: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("activates-default", activates_default),
        }
    }

    pub fn attributes(self, attributes: &pango::AttrList) -> Self {
        Self {
            builder: self.builder.property("attributes", attributes.clone()),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<EntryBuffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    pub fn completion(self, completion: &EntryCompletion) -> Self {
        Self {
            builder: self.builder.property("completion", completion.clone()),
        }
    }

    pub fn enable_emoji_completion(self, enable_emoji_completion: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-emoji-completion", enable_emoji_completion),
        }
    }

    pub fn extra_menu(self, extra_menu: &impl IsA<gio::MenuModel>) -> Self {
        Self {
            builder: self
                .builder
                .property("extra-menu", extra_menu.clone().upcast()),
        }
    }

    pub fn has_frame(self, has_frame: bool) -> Self {
        Self {
            builder: self.builder.property("has-frame", has_frame),
        }
    }

    pub fn im_module(self, im_module: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("im-module", im_module.into()),
        }
    }

    pub fn input_hints(self, input_hints: InputHints) -> Self {
        Self {
            builder: self.builder.property("input-hints", input_hints),
        }
    }

    pub fn input_purpose(self, input_purpose: InputPurpose) -> Self {
        Self {
            builder: self.builder.property("input-purpose", input_purpose),
        }
    }

    pub fn invisible_char(self, invisible_char: u32) -> Self {
        Self {
            builder: self.builder.property("invisible-char", invisible_char),
        }
    }

    pub fn invisible_char_set(self, invisible_char_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("invisible-char-set", invisible_char_set),
        }
    }

    pub fn max_length(self, max_length: i32) -> Self {
        Self {
            builder: self.builder.property("max-length", max_length),
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    pub fn menu_entry_icon_primary_text(
        self,
        menu_entry_icon_primary_text: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "menu-entry-icon-primary-text",
                menu_entry_icon_primary_text.into(),
            ),
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    pub fn menu_entry_icon_secondary_text(
        self,
        menu_entry_icon_secondary_text: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "menu-entry-icon-secondary-text",
                menu_entry_icon_secondary_text.into(),
            ),
        }
    }

    pub fn overwrite_mode(self, overwrite_mode: bool) -> Self {
        Self {
            builder: self.builder.property("overwrite-mode", overwrite_mode),
        }
    }

    pub fn placeholder_text(self, placeholder_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("placeholder-text", placeholder_text.into()),
        }
    }

    pub fn primary_icon_activatable(self, primary_icon_activatable: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-activatable", primary_icon_activatable),
        }
    }

    pub fn primary_icon_gicon(self, primary_icon_gicon: &impl IsA<gio::Icon>) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-gicon", primary_icon_gicon.clone().upcast()),
        }
    }

    pub fn primary_icon_name(self, primary_icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-name", primary_icon_name.into()),
        }
    }

    pub fn primary_icon_paintable(self, primary_icon_paintable: &impl IsA<gdk::Paintable>) -> Self {
        Self {
            builder: self.builder.property(
                "primary-icon-paintable",
                primary_icon_paintable.clone().upcast(),
            ),
        }
    }

    pub fn primary_icon_sensitive(self, primary_icon_sensitive: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-sensitive", primary_icon_sensitive),
        }
    }

    pub fn primary_icon_tooltip_markup(
        self,
        primary_icon_tooltip_markup: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "primary-icon-tooltip-markup",
                primary_icon_tooltip_markup.into(),
            ),
        }
    }

    pub fn primary_icon_tooltip_text(
        self,
        primary_icon_tooltip_text: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "primary-icon-tooltip-text",
                primary_icon_tooltip_text.into(),
            ),
        }
    }

    pub fn progress_fraction(self, progress_fraction: f64) -> Self {
        Self {
            builder: self
                .builder
                .property("progress-fraction", progress_fraction),
        }
    }

    pub fn progress_pulse_step(self, progress_pulse_step: f64) -> Self {
        Self {
            builder: self
                .builder
                .property("progress-pulse-step", progress_pulse_step),
        }
    }

    pub fn secondary_icon_activatable(self, secondary_icon_activatable: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("secondary-icon-activatable", secondary_icon_activatable),
        }
    }

    pub fn secondary_icon_gicon(self, secondary_icon_gicon: &impl IsA<gio::Icon>) -> Self {
        Self {
            builder: self.builder.property(
                "secondary-icon-gicon",
                secondary_icon_gicon.clone().upcast(),
            ),
        }
    }

    pub fn secondary_icon_name(self, secondary_icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("secondary-icon-name", secondary_icon_name.into()),
        }
    }

    pub fn secondary_icon_paintable(
        self,
        secondary_icon_paintable: &impl IsA<gdk::Paintable>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "secondary-icon-paintable",
                secondary_icon_paintable.clone().upcast(),
            ),
        }
    }

    pub fn secondary_icon_sensitive(self, secondary_icon_sensitive: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("secondary-icon-sensitive", secondary_icon_sensitive),
        }
    }

    pub fn secondary_icon_tooltip_markup(
        self,
        secondary_icon_tooltip_markup: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "secondary-icon-tooltip-markup",
                secondary_icon_tooltip_markup.into(),
            ),
        }
    }

    pub fn secondary_icon_tooltip_text(
        self,
        secondary_icon_tooltip_text: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "secondary-icon-tooltip-text",
                secondary_icon_tooltip_text.into(),
            ),
        }
    }

    pub fn show_emoji_icon(self, show_emoji_icon: bool) -> Self {
        Self {
            builder: self.builder.property("show-emoji-icon", show_emoji_icon),
        }
    }

    pub fn tabs(self, tabs: &pango::TabArray) -> Self {
        Self {
            builder: self.builder.property("tabs", tabs),
        }
    }

    pub fn truncate_multiline(self, truncate_multiline: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("truncate-multiline", truncate_multiline),
        }
    }

    pub fn visibility(self, visibility: bool) -> Self {
        Self {
            builder: self.builder.property("visibility", visibility),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    pub fn editing_canceled(self, editing_canceled: bool) -> Self {
        Self {
            builder: self.builder.property("editing-canceled", editing_canceled),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn enable_undo(self, enable_undo: bool) -> Self {
        Self {
            builder: self.builder.property("enable-undo", enable_undo),
        }
    }

    pub fn max_width_chars(self, max_width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("max-width-chars", max_width_chars),
        }
    }

    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    pub fn width_chars(self, width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("width-chars", width_chars),
        }
    }

    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Entry`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Entry {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

pub trait EntryExt: IsA<Entry> + 'static {
    #[doc(alias = "gtk_entry_get_activates_default")]
    #[doc(alias = "get_activates_default")]
    #[doc(alias = "activates-default")]
    fn activates_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_activates_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_alignment")]
    #[doc(alias = "get_alignment")]
    fn alignment(&self) -> f32 {
        unsafe { ffi::gtk_entry_get_alignment(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_attributes")]
    #[doc(alias = "get_attributes")]
    fn attributes(&self) -> Option<pango::AttrList> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_attributes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_buffer")]
    #[doc(alias = "get_buffer")]
    fn buffer(&self) -> EntryBuffer {
        unsafe { from_glib_none(ffi::gtk_entry_get_buffer(self.as_ref().to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_entry_get_completion")]
    #[doc(alias = "get_completion")]
    fn completion(&self) -> Option<EntryCompletion> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_completion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_current_icon_drag_source")]
    #[doc(alias = "get_current_icon_drag_source")]
    fn current_icon_drag_source(&self) -> i32 {
        unsafe { ffi::gtk_entry_get_current_icon_drag_source(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_extra_menu")]
    #[doc(alias = "get_extra_menu")]
    #[doc(alias = "extra-menu")]
    fn extra_menu(&self) -> Option<gio::MenuModel> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_extra_menu(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_has_frame")]
    #[doc(alias = "get_has_frame")]
    #[doc(alias = "has-frame")]
    fn has_frame(&self) -> bool {
        unsafe { from_glib(ffi::gtk_entry_get_has_frame(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_entry_get_icon_activatable")]
    #[doc(alias = "get_icon_activatable")]
    fn icon_is_activatable(&self, icon_pos: EntryIconPosition) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_activatable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_area")]
    #[doc(alias = "get_icon_area")]
    fn icon_area(&self, icon_pos: EntryIconPosition) -> gdk::Rectangle {
        unsafe {
            let mut icon_area = gdk::Rectangle::uninitialized();
            ffi::gtk_entry_get_icon_area(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon_area.to_glib_none_mut().0,
            );
            icon_area
        }
    }

    #[doc(alias = "gtk_entry_get_icon_at_pos")]
    #[doc(alias = "get_icon_at_pos")]
    fn icon_at_pos(&self, x: i32, y: i32) -> i32 {
        unsafe { ffi::gtk_entry_get_icon_at_pos(self.as_ref().to_glib_none().0, x, y) }
    }

    #[doc(alias = "gtk_entry_get_icon_gicon")]
    #[doc(alias = "get_icon_gicon")]
    fn icon_gicon(&self, icon_pos: EntryIconPosition) -> Option<gio::Icon> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_gicon(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    fn icon_name(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_name(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_paintable")]
    #[doc(alias = "get_icon_paintable")]
    fn icon_paintable(&self, icon_pos: EntryIconPosition) -> Option<gdk::Paintable> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_paintable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_sensitive")]
    #[doc(alias = "get_icon_sensitive")]
    fn icon_is_sensitive(&self, icon_pos: EntryIconPosition) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_sensitive(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_storage_type")]
    #[doc(alias = "get_icon_storage_type")]
    fn icon_storage_type(&self, icon_pos: EntryIconPosition) -> ImageType {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_storage_type(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_tooltip_markup")]
    #[doc(alias = "get_icon_tooltip_markup")]
    fn icon_tooltip_markup(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_entry_get_icon_tooltip_markup(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_tooltip_text")]
    #[doc(alias = "get_icon_tooltip_text")]
    fn icon_tooltip_text(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_entry_get_icon_tooltip_text(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_input_hints")]
    #[doc(alias = "get_input_hints")]
    #[doc(alias = "input-hints")]
    fn input_hints(&self) -> InputHints {
        unsafe {
            from_glib(ffi::gtk_entry_get_input_hints(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_input_purpose")]
    #[doc(alias = "get_input_purpose")]
    #[doc(alias = "input-purpose")]
    fn input_purpose(&self) -> InputPurpose {
        unsafe {
            from_glib(ffi::gtk_entry_get_input_purpose(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_max_length")]
    #[doc(alias = "get_max_length")]
    #[doc(alias = "max-length")]
    fn max_length(&self) -> i32 {
        unsafe { ffi::gtk_entry_get_max_length(self.as_ref().to_glib_none().0) }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "gtk_entry_get_menu_entry_icon_text")]
    #[doc(alias = "get_menu_entry_icon_text")]
    fn menu_entry_icon_text(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_menu_entry_icon_text(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_overwrite_mode")]
    #[doc(alias = "get_overwrite_mode")]
    #[doc(alias = "overwrite-mode")]
    fn is_overwrite_mode(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_overwrite_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_placeholder_text")]
    #[doc(alias = "get_placeholder_text")]
    #[doc(alias = "placeholder-text")]
    fn placeholder_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_placeholder_text(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_progress_fraction")]
    #[doc(alias = "get_progress_fraction")]
    #[doc(alias = "progress-fraction")]
    fn progress_fraction(&self) -> f64 {
        unsafe { ffi::gtk_entry_get_progress_fraction(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_progress_pulse_step")]
    #[doc(alias = "get_progress_pulse_step")]
    #[doc(alias = "progress-pulse-step")]
    fn progress_pulse_step(&self) -> f64 {
        unsafe { ffi::gtk_entry_get_progress_pulse_step(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_tabs")]
    #[doc(alias = "get_tabs")]
    fn tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_none(ffi::gtk_entry_get_tabs(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_entry_get_text_length")]
    #[doc(alias = "get_text_length")]
    #[doc(alias = "text-length")]
    fn text_length(&self) -> u16 {
        unsafe { ffi::gtk_entry_get_text_length(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_visibility")]
    #[doc(alias = "get_visibility")]
    #[doc(alias = "visibility")]
    fn is_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_visibility(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_grab_focus_without_selecting")]
    fn grab_focus_without_selecting(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_grab_focus_without_selecting(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_progress_pulse")]
    fn progress_pulse(&self) {
        unsafe {
            ffi::gtk_entry_progress_pulse(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_entry_reset_im_context")]
    fn reset_im_context(&self) {
        unsafe {
            ffi::gtk_entry_reset_im_context(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_entry_set_activates_default")]
    #[doc(alias = "activates-default")]
    fn set_activates_default(&self, setting: bool) {
        unsafe {
            ffi::gtk_entry_set_activates_default(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_alignment")]
    fn set_alignment(&self, xalign: f32) {
        unsafe {
            ffi::gtk_entry_set_alignment(self.as_ref().to_glib_none().0, xalign);
        }
    }

    #[doc(alias = "gtk_entry_set_attributes")]
    #[doc(alias = "attributes")]
    fn set_attributes(&self, attrs: &pango::AttrList) {
        unsafe {
            ffi::gtk_entry_set_attributes(self.as_ref().to_glib_none().0, attrs.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_entry_set_buffer")]
    #[doc(alias = "buffer")]
    fn set_buffer(&self, buffer: &impl IsA<EntryBuffer>) {
        unsafe {
            ffi::gtk_entry_set_buffer(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_entry_set_completion")]
    #[doc(alias = "completion")]
    fn set_completion(&self, completion: Option<&EntryCompletion>) {
        unsafe {
            ffi::gtk_entry_set_completion(
                self.as_ref().to_glib_none().0,
                completion.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_extra_menu")]
    #[doc(alias = "extra-menu")]
    fn set_extra_menu(&self, model: Option<&impl IsA<gio::MenuModel>>) {
        unsafe {
            ffi::gtk_entry_set_extra_menu(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_has_frame")]
    #[doc(alias = "has-frame")]
    fn set_has_frame(&self, setting: bool) {
        unsafe {
            ffi::gtk_entry_set_has_frame(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_icon_activatable")]
    fn set_icon_activatable(&self, icon_pos: EntryIconPosition, activatable: bool) {
        unsafe {
            ffi::gtk_entry_set_icon_activatable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                activatable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_drag_source")]
    fn set_icon_drag_source(
        &self,
        icon_pos: EntryIconPosition,
        provider: &impl IsA<gdk::ContentProvider>,
        actions: gdk::DragAction,
    ) {
        unsafe {
            ffi::gtk_entry_set_icon_drag_source(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                provider.as_ref().to_glib_none().0,
                actions.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_from_gicon")]
    fn set_icon_from_gicon(&self, icon_pos: EntryIconPosition, icon: Option<&impl IsA<gio::Icon>>) {
        unsafe {
            ffi::gtk_entry_set_icon_from_gicon(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_from_icon_name")]
    fn set_icon_from_icon_name(&self, icon_pos: EntryIconPosition, icon_name: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_from_icon_name(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_from_paintable")]
    fn set_icon_from_paintable(
        &self,
        icon_pos: EntryIconPosition,
        paintable: Option<&impl IsA<gdk::Paintable>>,
    ) {
        unsafe {
            ffi::gtk_entry_set_icon_from_paintable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                paintable.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_sensitive")]
    fn set_icon_sensitive(&self, icon_pos: EntryIconPosition, sensitive: bool) {
        unsafe {
            ffi::gtk_entry_set_icon_sensitive(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                sensitive.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_tooltip_markup")]
    fn set_icon_tooltip_markup(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_tooltip_markup(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                tooltip.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_tooltip_text")]
    fn set_icon_tooltip_text(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_tooltip_text(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                tooltip.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_input_hints")]
    #[doc(alias = "input-hints")]
    fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            ffi::gtk_entry_set_input_hints(self.as_ref().to_glib_none().0, hints.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_input_purpose")]
    #[doc(alias = "input-purpose")]
    fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            ffi::gtk_entry_set_input_purpose(self.as_ref().to_glib_none().0, purpose.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_invisible_char")]
    #[doc(alias = "invisible-char")]
    fn set_invisible_char(&self, ch: Option<char>) {
        unsafe {
            ffi::gtk_entry_set_invisible_char(self.as_ref().to_glib_none().0, ch.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_max_length")]
    #[doc(alias = "max-length")]
    fn set_max_length(&self, max: i32) {
        unsafe {
            ffi::gtk_entry_set_max_length(self.as_ref().to_glib_none().0, max);
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "gtk_entry_set_menu_entry_icon_text")]
    fn set_menu_entry_icon_text(&self, icon_pos: EntryIconPosition, text: &str) {
        unsafe {
            ffi::gtk_entry_set_menu_entry_icon_text(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                text.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_overwrite_mode")]
    #[doc(alias = "overwrite-mode")]
    fn set_overwrite_mode(&self, overwrite: bool) {
        unsafe {
            ffi::gtk_entry_set_overwrite_mode(
                self.as_ref().to_glib_none().0,
                overwrite.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_placeholder_text")]
    #[doc(alias = "placeholder-text")]
    fn set_placeholder_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_placeholder_text(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_progress_fraction")]
    #[doc(alias = "progress-fraction")]
    fn set_progress_fraction(&self, fraction: f64) {
        unsafe {
            ffi::gtk_entry_set_progress_fraction(self.as_ref().to_glib_none().0, fraction);
        }
    }

    #[doc(alias = "gtk_entry_set_progress_pulse_step")]
    #[doc(alias = "progress-pulse-step")]
    fn set_progress_pulse_step(&self, fraction: f64) {
        unsafe {
            ffi::gtk_entry_set_progress_pulse_step(self.as_ref().to_glib_none().0, fraction);
        }
    }

    #[doc(alias = "gtk_entry_set_tabs")]
    #[doc(alias = "tabs")]
    fn set_tabs(&self, tabs: Option<&pango::TabArray>) {
        unsafe {
            ffi::gtk_entry_set_tabs(
                self.as_ref().to_glib_none().0,
                mut_override(tabs.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_visibility")]
    #[doc(alias = "visibility")]
    fn set_visibility(&self, visible: bool) {
        unsafe {
            ffi::gtk_entry_set_visibility(self.as_ref().to_glib_none().0, visible.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_unset_invisible_char")]
    fn unset_invisible_char(&self) {
        unsafe {
            ffi::gtk_entry_unset_invisible_char(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "enable-emoji-completion")]
    fn enables_emoji_completion(&self) -> bool {
        ObjectExt::property(self.as_ref(), "enable-emoji-completion")
    }

    #[doc(alias = "enable-emoji-completion")]
    fn set_enable_emoji_completion(&self, enable_emoji_completion: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "enable-emoji-completion",
            enable_emoji_completion,
        )
    }

    #[doc(alias = "im-module")]
    fn im_module(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "im-module")
    }

    #[doc(alias = "im-module")]
    fn set_im_module(&self, im_module: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "im-module", im_module)
    }

    #[doc(alias = "invisible-char-set")]
    fn is_invisible_char_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "invisible-char-set")
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "menu-entry-icon-primary-text")]
    fn menu_entry_icon_primary_text(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "menu-entry-icon-primary-text")
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "menu-entry-icon-primary-text")]
    fn set_menu_entry_icon_primary_text(&self, menu_entry_icon_primary_text: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "menu-entry-icon-primary-text",
            menu_entry_icon_primary_text,
        )
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "menu-entry-icon-secondary-text")]
    fn menu_entry_icon_secondary_text(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "menu-entry-icon-secondary-text")
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "menu-entry-icon-secondary-text")]
    fn set_menu_entry_icon_secondary_text(&self, menu_entry_icon_secondary_text: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "menu-entry-icon-secondary-text",
            menu_entry_icon_secondary_text,
        )
    }

    #[doc(alias = "primary-icon-activatable")]
    fn is_primary_icon_activatable(&self) -> bool {
        ObjectExt::property(self.as_ref(), "primary-icon-activatable")
    }

    #[doc(alias = "primary-icon-activatable")]
    fn set_primary_icon_activatable(&self, primary_icon_activatable: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-activatable",
            primary_icon_activatable,
        )
    }

    #[doc(alias = "primary-icon-gicon")]
    fn primary_icon_gicon(&self) -> Option<gio::Icon> {
        ObjectExt::property(self.as_ref(), "primary-icon-gicon")
    }

    #[doc(alias = "primary-icon-gicon")]
    fn set_primary_icon_gicon<P: IsA<gio::Icon>>(&self, primary_icon_gicon: Option<&P>) {
        ObjectExt::set_property(self.as_ref(), "primary-icon-gicon", primary_icon_gicon)
    }

    #[doc(alias = "primary-icon-name")]
    fn primary_icon_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "primary-icon-name")
    }

    #[doc(alias = "primary-icon-name")]
    fn set_primary_icon_name(&self, primary_icon_name: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "primary-icon-name", primary_icon_name)
    }

    #[doc(alias = "primary-icon-paintable")]
    fn primary_icon_paintable(&self) -> Option<gdk::Paintable> {
        ObjectExt::property(self.as_ref(), "primary-icon-paintable")
    }

    #[doc(alias = "primary-icon-paintable")]
    fn set_primary_icon_paintable<P: IsA<gdk::Paintable>>(
        &self,
        primary_icon_paintable: Option<&P>,
    ) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-paintable",
            primary_icon_paintable,
        )
    }

    #[doc(alias = "primary-icon-sensitive")]
    fn is_primary_icon_sensitive(&self) -> bool {
        ObjectExt::property(self.as_ref(), "primary-icon-sensitive")
    }

    #[doc(alias = "primary-icon-sensitive")]
    fn set_primary_icon_sensitive(&self, primary_icon_sensitive: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-sensitive",
            primary_icon_sensitive,
        )
    }

    #[doc(alias = "primary-icon-storage-type")]
    fn primary_icon_storage_type(&self) -> ImageType {
        ObjectExt::property(self.as_ref(), "primary-icon-storage-type")
    }

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn primary_icon_tooltip_markup(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "primary-icon-tooltip-markup")
    }

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn set_primary_icon_tooltip_markup(&self, primary_icon_tooltip_markup: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-tooltip-markup",
            primary_icon_tooltip_markup,
        )
    }

    #[doc(alias = "primary-icon-tooltip-text")]
    fn primary_icon_tooltip_text(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "primary-icon-tooltip-text")
    }

    #[doc(alias = "primary-icon-tooltip-text")]
    fn set_primary_icon_tooltip_text(&self, primary_icon_tooltip_text: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-tooltip-text",
            primary_icon_tooltip_text,
        )
    }

    #[doc(alias = "scroll-offset")]
    fn scroll_offset(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "scroll-offset")
    }

    #[doc(alias = "secondary-icon-activatable")]
    fn is_secondary_icon_activatable(&self) -> bool {
        ObjectExt::property(self.as_ref(), "secondary-icon-activatable")
    }

    #[doc(alias = "secondary-icon-activatable")]
    fn set_secondary_icon_activatable(&self, secondary_icon_activatable: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-activatable",
            secondary_icon_activatable,
        )
    }

    #[doc(alias = "secondary-icon-gicon")]
    fn secondary_icon_gicon(&self) -> Option<gio::Icon> {
        ObjectExt::property(self.as_ref(), "secondary-icon-gicon")
    }

    #[doc(alias = "secondary-icon-gicon")]
    fn set_secondary_icon_gicon<P: IsA<gio::Icon>>(&self, secondary_icon_gicon: Option<&P>) {
        ObjectExt::set_property(self.as_ref(), "secondary-icon-gicon", secondary_icon_gicon)
    }

    #[doc(alias = "secondary-icon-name")]
    fn secondary_icon_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "secondary-icon-name")
    }

    #[doc(alias = "secondary-icon-name")]
    fn set_secondary_icon_name(&self, secondary_icon_name: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "secondary-icon-name", secondary_icon_name)
    }

    #[doc(alias = "secondary-icon-paintable")]
    fn secondary_icon_paintable(&self) -> Option<gdk::Paintable> {
        ObjectExt::property(self.as_ref(), "secondary-icon-paintable")
    }

    #[doc(alias = "secondary-icon-paintable")]
    fn set_secondary_icon_paintable<P: IsA<gdk::Paintable>>(
        &self,
        secondary_icon_paintable: Option<&P>,
    ) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-paintable",
            secondary_icon_paintable,
        )
    }

    #[doc(alias = "secondary-icon-sensitive")]
    fn is_secondary_icon_sensitive(&self) -> bool {
        ObjectExt::property(self.as_ref(), "secondary-icon-sensitive")
    }

    #[doc(alias = "secondary-icon-sensitive")]
    fn set_secondary_icon_sensitive(&self, secondary_icon_sensitive: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-sensitive",
            secondary_icon_sensitive,
        )
    }

    #[doc(alias = "secondary-icon-storage-type")]
    fn secondary_icon_storage_type(&self) -> ImageType {
        ObjectExt::property(self.as_ref(), "secondary-icon-storage-type")
    }

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn secondary_icon_tooltip_markup(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "secondary-icon-tooltip-markup")
    }

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn set_secondary_icon_tooltip_markup(&self, secondary_icon_tooltip_markup: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-tooltip-markup",
            secondary_icon_tooltip_markup,
        )
    }

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn secondary_icon_tooltip_text(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "secondary-icon-tooltip-text")
    }

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn set_secondary_icon_tooltip_text(&self, secondary_icon_tooltip_text: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-tooltip-text",
            secondary_icon_tooltip_text,
        )
    }

    #[doc(alias = "show-emoji-icon")]
    fn shows_emoji_icon(&self) -> bool {
        ObjectExt::property(self.as_ref(), "show-emoji-icon")
    }

    #[doc(alias = "show-emoji-icon")]
    fn set_show_emoji_icon(&self, show_emoji_icon: bool) {
        ObjectExt::set_property(self.as_ref(), "show-emoji-icon", show_emoji_icon)
    }

    #[doc(alias = "truncate-multiline")]
    fn must_truncate_multiline(&self) -> bool {
        ObjectExt::property(self.as_ref(), "truncate-multiline")
    }

    #[doc(alias = "truncate-multiline")]
    fn set_truncate_multiline(&self, truncate_multiline: bool) {
        ObjectExt::set_property(self.as_ref(), "truncate-multiline", truncate_multiline)
    }

    #[doc(alias = "activate")]
    fn connect_activate<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"activate".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate(&self) {
        self.emit_by_name::<()>("activate", &[]);
    }

    #[doc(alias = "icon-press")]
    fn connect_icon_press<F: Fn(&Self, EntryIconPosition) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn icon_press_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, EntryIconPosition) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            icon_pos: ffi::GtkEntryIconPosition,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Entry::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(icon_pos),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"icon-press".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    icon_press_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "icon-release")]
    fn connect_icon_release<F: Fn(&Self, EntryIconPosition) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn icon_release_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, EntryIconPosition) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            icon_pos: ffi::GtkEntryIconPosition,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Entry::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(icon_pos),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"icon-release".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    icon_release_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "activates-default")]
    fn connect_activates_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_activates_default_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::activates-default".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_activates_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "attributes")]
    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::attributes".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "buffer")]
    fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::buffer".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_buffer_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[doc(alias = "completion")]
    fn connect_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_completion_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::completion".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-emoji-completion")]
    fn connect_enable_emoji_completion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_emoji_completion_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::enable-emoji-completion".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_emoji_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "extra-menu")]
    fn connect_extra_menu_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_menu_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::extra-menu".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_extra_menu_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "has-frame")]
    fn connect_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_frame_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::has-frame".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_has_frame_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "im-module")]
    fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::im-module".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_im_module_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-hints")]
    fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::input-hints".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_input_hints_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-purpose")]
    fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::input-purpose".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_input_purpose_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "invisible-char")]
    fn connect_invisible_char_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::invisible-char".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_invisible_char_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "invisible-char-set")]
    fn connect_invisible_char_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_set_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::invisible-char-set".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_invisible_char_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-length")]
    fn connect_max_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_length_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::max-length".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_max_length_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "menu-entry-icon-primary-text")]
    fn connect_menu_entry_icon_primary_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_menu_entry_icon_primary_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::menu-entry-icon-primary-text".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_menu_entry_icon_primary_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "menu-entry-icon-secondary-text")]
    fn connect_menu_entry_icon_secondary_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_menu_entry_icon_secondary_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::menu-entry-icon-secondary-text".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_menu_entry_icon_secondary_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "overwrite-mode")]
    fn connect_overwrite_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_mode_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::overwrite-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_overwrite_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "placeholder-text")]
    fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::placeholder-text".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_placeholder_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-activatable")]
    fn connect_primary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_activatable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::primary-icon-activatable".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_primary_icon_activatable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-gicon")]
    fn connect_primary_icon_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_gicon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::primary-icon-gicon".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_primary_icon_gicon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-name")]
    fn connect_primary_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_name_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::primary-icon-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_primary_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-paintable")]
    fn connect_primary_icon_paintable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_paintable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::primary-icon-paintable".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_primary_icon_paintable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-sensitive")]
    fn connect_primary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_sensitive_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::primary-icon-sensitive".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_primary_icon_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-storage-type")]
    fn connect_primary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_storage_type_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::primary-icon-storage-type".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_primary_icon_storage_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn connect_primary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_tooltip_markup_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::primary-icon-tooltip-markup".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_primary_icon_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-tooltip-text")]
    fn connect_primary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_tooltip_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::primary-icon-tooltip-text".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_primary_icon_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "progress-fraction")]
    fn connect_progress_fraction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_progress_fraction_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::progress-fraction".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_progress_fraction_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "progress-pulse-step")]
    fn connect_progress_pulse_step_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_progress_pulse_step_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::progress-pulse-step".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_progress_pulse_step_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scroll-offset")]
    fn connect_scroll_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_offset_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::scroll-offset".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_scroll_offset_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-activatable")]
    fn connect_secondary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_activatable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::secondary-icon-activatable".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_secondary_icon_activatable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-gicon")]
    fn connect_secondary_icon_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_gicon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::secondary-icon-gicon".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_secondary_icon_gicon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-name")]
    fn connect_secondary_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_name_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::secondary-icon-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_secondary_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-paintable")]
    fn connect_secondary_icon_paintable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_paintable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::secondary-icon-paintable".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_secondary_icon_paintable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-sensitive")]
    fn connect_secondary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_sensitive_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::secondary-icon-sensitive".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_secondary_icon_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-storage-type")]
    fn connect_secondary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_storage_type_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::secondary-icon-storage-type".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_secondary_icon_storage_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn connect_secondary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_tooltip_markup_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::secondary-icon-tooltip-markup".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_secondary_icon_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn connect_secondary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_tooltip_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::secondary-icon-tooltip-text".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_secondary_icon_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-emoji-icon")]
    fn connect_show_emoji_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_emoji_icon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::show-emoji-icon".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_show_emoji_icon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tabs")]
    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::tabs".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text-length")]
    fn connect_text_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_length_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::text-length".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_text_length_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "truncate-multiline")]
    fn connect_truncate_multiline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_truncate_multiline_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::truncate-multiline".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_truncate_multiline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visibility")]
    fn connect_visibility_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visibility_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Entry::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::visibility".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_visibility_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Entry>> EntryExt for O {}
