/* Placed in the public domain */

#ifndef HAVE_GETPAGESIZE

#include <unistd.h>
#include <limits.h>

int
getpagesize(void)
{
#if defined(HAVE_SYSCONF) && defined(_SC_PAGESIZE)
	long r = sysconf(_SC_PAGESIZE);
	if (r > 0 && r < INT_MAX)
		return (int)r;
#endif
	/*
	 * This is at the lower end of common values and appropriate for
	 * our current use of getpagesize() in recallocarray().
	 */
	return 4096;
}

#endif /* HAVE_GETPAGESIZE */
