# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from openstack.identity import identity_service
from openstack import resource


class Service(resource.Resource):
    resource_key = 'service'
    resources_key = 'services'
    base_path = '/services'
    service = identity_service.IdentityService()

    # capabilities
    allow_create = True
    allow_retrieve = True
    allow_update = True
    allow_delete = True
    allow_list = True
    patch_update = True

    # Properties
    #: User-facing description of the service. *Type: string*
    description = resource.prop('description')
    #: Setting this value to ``False`` prevents the service and
    #: its endpoints from appearing in the service catalog. *Type: bool*
    enabled = resource.prop('enabled', type=bool)
    #: User-facing name of the service. *Type: string*
    name = resource.prop('name')
    #: Describes the API implemented by the service. The following values are
    #: recognized within the OpenStack ecosystem: ``compute``, ``image``,
    #: ``ec2``, ``identity``, ``volume``, ``network``. To support non-core and
    #: future projects, the value should not be validated against this list.
    #: *Type: string*
    type = resource.prop('type')
