from taskflow import task


class CallOnPhone(task.Task):

    default_provides = 'was_dialed'

    def execute(self, phone_number):
        print("Calling %s" % phone_number)
        return True

    def revert(self, phone_number, result, flow_failures):
        if result:
            print("Hanging up on %s" % phone_number)


class ChitChat(task.Task):
    def execute(self, was_dialed, phone_number):
        if was_dialed:
            print("Talking with %s" % phone_number)


