/*
 * Parser input reading gzipped files using zlib
 *
 * Copyright (C) 2003--2006  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/input/zlib.h>

#include <zlib.h>
#include <errno.h>

using namespace std;

namespace tagcoll {
namespace input {

struct ZlibInputData
{
	gzFile in;
	int backbuf;

	ZlibInputData() throw ()
		: in(0), backbuf(Input::Eof) {}
};

Zlib::Zlib(const std::string& fname)
	: _data(new ZlibInputData), _file(fname), _line(1)
{
	_data->in = gzopen(fname.c_str(), "r");
	if (!_data->in)
	{
		delete _data;
		_data = 0;
		throw wibble::exception::File(fname, "opening compressed file for reading");
	}
}

Zlib::~Zlib()
{
	if (_data)
	{
		gzclose(_data->in);
		delete _data;
	}
}

int Zlib::nextChar()
{
	// See if there's a previously pushed char
	if (_data->backbuf != Input::Eof)
	{
		int res = _data->backbuf;
		_data->backbuf = Input::Eof;
		return res;
	}

	int res = gzgetc(_data->in);
	if (res == -1)
		return Input::Eof;

	if (res == '\n')
		_line++;
	return res;
}

void Zlib::pushChar(int c)
{
	_data->backbuf = c;
}

}
}

// vim:set ts=4 sw=4:
