/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.implementations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class Canonicalizer11Test
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$c14n$implementations$Canonicalizer11Test == null ? (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer11Test = Canonicalizer11Test.class$("org.apache.xml.security.test.c14n.implementations.Canonicalizer11Test")) : class$org$apache$xml$security$test$c14n$implementations$Canonicalizer11Test).getName());
    private String prefix = "data/org/apache/xml/security/c14n/";
    static /* synthetic */ Class class$org$apache$xml$security$test$c14n$implementations$Canonicalizer11Test;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$c14n$implementations$Canonicalizer11Test == null ? (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer11Test = Canonicalizer11Test.class$("org.apache.xml.security.test.c14n.implementations.Canonicalizer11Test")) : class$org$apache$xml$security$test$c14n$implementations$Canonicalizer11Test);
    }

    public Canonicalizer11Test() {
        String string = System.getProperty("basedir");
        if (string != null && !"".equals(string)) {
            this.prefix = string + "/" + this.prefix;
        }
    }

    public void test31withCommentsSubtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (commented)";
        String string2 = this.prefix + "in/31_input.xml";
        String string3 = this.prefix + "in/31_c14n-comments.xml";
        String string4 = this.prefix + "out/xpath_31_output-comments.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        boolean bl = true;
        Object var7_7 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, var7_7));
    }

    public void test32subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.2 Whitespace in Document Content. (uncommented)";
        String string2 = this.prefix + "in/32_input.xml";
        String string3 = this.prefix + "in/32_c14n.xml";
        String string4 = this.prefix + "out/xpath_32_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        Object var7_7 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, var7_7));
    }

    public void test33subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.3 Start and End Tags. (uncommented)";
        String string2 = this.prefix + "in/33_input.xml";
        String string3 = this.prefix + "in/33_c14n.xml";
        String string4 = this.prefix + "out/xpath_33_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        Object var7_7 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, var7_7));
    }

    public void test34() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.4 Character Modifications and Character References. (uncommented)";
        String string2 = this.prefix + "in/34_input.xml";
        String string3 = this.prefix + "in/34_c14n.xml";
        String string4 = this.prefix + "out/xpath_34_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = false;
        Object var7_7 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, var7_7));
    }

    public void test35subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.5 Entity References. (uncommented)";
        String string2 = this.prefix + "in/35_input.xml";
        String string3 = this.prefix + "in/35_c14n.xml";
        String string4 = this.prefix + "out/xpath_35_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        Object var7_7 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, var7_7));
    }

    public void test36subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.6 UTF-8 Encoding. (uncommented)";
        String string2 = this.prefix + "in/36_input.xml";
        String string3 = this.prefix + "in/36_c14n.xml";
        String string4 = this.prefix + "out/xpath_36_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        Object var7_7 = null;
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, var7_7));
    }

    public void test37() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.7 Document Subsets. (uncommented)";
        String string2 = this.prefix + "in/37_input.xml";
        String string3 = this.prefix + "in/37_c14n.xml";
        String string4 = this.prefix + "out/xpath_37_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        Element element = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        element = XMLUtils.createElementInSignatureSpace((Document)document, (String)"XPath");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ietf", "http://www.ietf.org");
        String string6 = "(//. | //@* | //namespace::*)[ self::ietf:e1 or (parent::ietf:e1 and not(self::text() or self::e2)) or count(id(\"E3\")|ancestor-or-self::node()) = count(ancestor-or-self::node()) ]";
        element.appendChild(document.createTextNode(string6));
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, element));
    }

    public void test38() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.8 Document Subsets and XML Attributes (uncommented)";
        String string2 = this.prefix + "in/38_input.xml";
        String string3 = this.prefix + "in/38_c14n.xml";
        String string4 = this.prefix + "out/xpath_38_output.xml";
        String string5 = "http://www.w3.org/2006/12/xml-c14n11";
        boolean bl = true;
        Element element = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        element = XMLUtils.createElementInSignatureSpace((Document)document, (String)"XPath");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ietf", "http://www.ietf.org");
        String string6 = "(//. | //@* | //namespace::*)[ self::ietf:e1 or (parent::ietf:e1 and not(self::text() or self::e2)) or count(id(\"E3\")|ancestor-or-self::node()) = count(ancestor-or-self::node()) ]";
        element.appendChild(document.createTextNode(string6));
        Canonicalizer11Test.assertTrue((String)string, (boolean)this.c14nAndCompare(string2, string3, string4, string5, bl, element));
    }

    private boolean c14nAndCompare(String string, String string2, String string3, String string4, boolean bl, Object object) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        Object object2;
        Object object3;
        Object object4;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(string);
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)string4);
        byte[] byArray = null;
        if (object == null) {
            byArray = canonicalizer.canonicalizeSubtree((Node)document);
        } else {
            object4 = new CachedXPathAPI();
            NodeList nodeList = null;
            if (object instanceof String) {
                nodeList = object4.selectNodeList((Node)document, (String)object);
            } else {
                object3 = (Element)object;
                object2 = ((Text)object3.getFirstChild()).getData();
                nodeList = object4.selectNodeList((Node)document, (String)object2, (Node)object3);
            }
            byArray = canonicalizer.canonicalizeXPathNodeSet(nodeList);
        }
        object4 = JavaUtils.getBytesFromFile((String)string2);
        boolean bl2 = MessageDigest.isEqual((byte[])object4, byArray);
        if (!bl2) {
            object3 = new File(string3);
            if (!((File)object3).exists()) {
                object2 = new File(((File)object3).getParent());
                ((File)object2).mkdirs();
                ((File)object3).createNewFile();
            }
            object2 = new FileOutputStream((File)object3);
            ((FileOutputStream)object2).write(byArray);
            log.debug((Object)("Wrote errorneous result to file " + ((File)object3).toURI().toURL().toString()));
            Canonicalizer11Test.assertEquals((String)new String((byte[])object4), (String)new String(byArray));
        }
        return bl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

