/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.RoleGetAttributesRequest;
import com.amazonaws.services.identitymanagement.model.GetRoleRequest;
import com.amazonaws.services.identitymanagement.model.GetRoleResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IAMRoleGetAttributesDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMRoleGetAttributesDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof RoleGetAttributesRequest) {
            RoleGetAttributesRequest req = (RoleGetAttributesRequest)request;
            LOG.debug((Object)("Getting role " + req));
            GetRoleRequest getRoleRequest = new GetRoleRequest();
            getRoleRequest.setRoleName(req.getRoleName());
            GetRoleResult result = this.getClient().getRole(getRoleRequest);
            LOG.info((Object)result.getRole().getArn());
            LOG.info((Object)result.getRole().getRoleId());
            LOG.info((Object)this.urlDecodePolicy(result.getRole().getAssumeRolePolicyDocument()));
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

