/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PROCESSORVOLTAGESENSOR_H_
#define OPENDRIM_PROCESSORVOLTAGESENSOR_H_

#include <Instance.h>

const static char* OpenDRIM_ProcessorVoltageSensor_classnames[] = {"OpenDRIM_ProcessorVoltageSensor"};
static string OpenDRIM_ProcessorVoltageSensor_NAMESPACE = _NAMESPACE;

class OpenDRIM_ProcessorVoltageSensor {

public:
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short EnabledState;
	bool EnabledState_isNULL;
	
	string OtherEnabledState;
	bool OtherEnabledState_isNULL;
	
	unsigned short RequestedState;
	bool RequestedState_isNULL;
	
	unsigned short EnabledDefault;
	bool EnabledDefault_isNULL;
	
	string TimeOfLastStateChange;
	bool TimeOfLastStateChange_isNULL;
	
	vector<unsigned short> AvailableRequestedStates;
	bool AvailableRequestedStates_isNULL;
	
	unsigned short TransitioningToState;
	bool TransitioningToState_isNULL;
	
	string SystemCreationClassName;
	bool SystemCreationClassName_isNULL;
	
	string SystemName;
	bool SystemName_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string DeviceID;
	bool DeviceID_isNULL;
	
	bool PowerManagementSupported;
	bool PowerManagementSupported_isNULL;
	
	vector<unsigned short> PowerManagementCapabilities;
	bool PowerManagementCapabilities_isNULL;
	
	unsigned short Availability;
	bool Availability_isNULL;
	
	unsigned short StatusInfo;
	bool StatusInfo_isNULL;
	
	unsigned int LastErrorCode;
	bool LastErrorCode_isNULL;
	
	string ErrorDescription;
	bool ErrorDescription_isNULL;
	
	bool ErrorCleared;
	bool ErrorCleared_isNULL;
	
	vector<string> OtherIdentifyingInfo;
	bool OtherIdentifyingInfo_isNULL;
	
	unsigned long long PowerOnHours;
	bool PowerOnHours_isNULL;
	
	unsigned long long TotalPowerOnHours;
	bool TotalPowerOnHours_isNULL;
	
	vector<string> IdentifyingDescriptions;
	bool IdentifyingDescriptions_isNULL;
	
	vector<unsigned short> AdditionalAvailability;
	bool AdditionalAvailability_isNULL;
	
	unsigned long long MaxQuiesceTime;
	bool MaxQuiesceTime_isNULL;
	
	unsigned short SensorType;
	bool SensorType_isNULL;
	
	string OtherSensorTypeDescription;
	bool OtherSensorTypeDescription_isNULL;
	
	vector<string> PossibleStates;
	bool PossibleStates_isNULL;
	
	string CurrentState;
	bool CurrentState_isNULL;
	
	unsigned long long PollingInterval;
	bool PollingInterval_isNULL;
	
	unsigned short BaseUnits;
	bool BaseUnits_isNULL;
	
	int UnitModifier;
	bool UnitModifier_isNULL;
	
	unsigned short RateUnits;
	bool RateUnits_isNULL;
	
	int CurrentReading;
	bool CurrentReading_isNULL;
	
	int NominalReading;
	bool NominalReading_isNULL;
	
	int NormalMax;
	bool NormalMax_isNULL;
	
	int NormalMin;
	bool NormalMin_isNULL;
	
	int MaxReadable;
	bool MaxReadable_isNULL;
	
	int MinReadable;
	bool MinReadable_isNULL;
	
	unsigned int Resolution;
	bool Resolution_isNULL;
	
	int Tolerance;
	bool Tolerance_isNULL;
	
	int Accuracy;
	bool Accuracy_isNULL;
	
	bool IsLinear;
	bool IsLinear_isNULL;
	
	unsigned int Hysteresis;
	bool Hysteresis_isNULL;
	
	int LowerThresholdNonCritical;
	bool LowerThresholdNonCritical_isNULL;
	
	int UpperThresholdNonCritical;
	bool UpperThresholdNonCritical_isNULL;
	
	int LowerThresholdCritical;
	bool LowerThresholdCritical_isNULL;
	
	int UpperThresholdCritical;
	bool UpperThresholdCritical_isNULL;
	
	int LowerThresholdFatal;
	bool LowerThresholdFatal_isNULL;
	
	int UpperThresholdFatal;
	bool UpperThresholdFatal_isNULL;
	
	vector<unsigned short> SupportedThresholds;
	bool SupportedThresholds_isNULL;
	
	vector<unsigned short> EnabledThresholds;
	bool EnabledThresholds_isNULL;
	
	vector<unsigned short> SettableThresholds;
	bool SettableThresholds_isNULL;
	
	OpenDRIM_ProcessorVoltageSensor() {
		InstanceID_isNULL = true;
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		Name_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		CommunicationStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		PrimaryStatus_isNULL = true;
		EnabledState_isNULL = true;
		OtherEnabledState_isNULL = true;
		RequestedState_isNULL = true;
		EnabledDefault_isNULL = true;
		TimeOfLastStateChange_isNULL = true;
		AvailableRequestedStates_isNULL = true;
		TransitioningToState_isNULL = true;
		SystemCreationClassName_isNULL = true;
		SystemName_isNULL = true;
		CreationClassName_isNULL = true;
		DeviceID_isNULL = true;
		PowerManagementSupported_isNULL = true;
		PowerManagementCapabilities_isNULL = true;
		Availability_isNULL = true;
		StatusInfo_isNULL = true;
		LastErrorCode_isNULL = true;
		ErrorDescription_isNULL = true;
		ErrorCleared_isNULL = true;
		OtherIdentifyingInfo_isNULL = true;
		PowerOnHours_isNULL = true;
		TotalPowerOnHours_isNULL = true;
		IdentifyingDescriptions_isNULL = true;
		AdditionalAvailability_isNULL = true;
		MaxQuiesceTime_isNULL = true;
		SensorType_isNULL = true;
		OtherSensorTypeDescription_isNULL = true;
		PossibleStates_isNULL = true;
		CurrentState_isNULL = true;
		PollingInterval_isNULL = true;
		BaseUnits_isNULL = true;
		UnitModifier_isNULL = true;
		RateUnits_isNULL = true;
		CurrentReading_isNULL = true;
		NominalReading_isNULL = true;
		NormalMax_isNULL = true;
		NormalMin_isNULL = true;
		MaxReadable_isNULL = true;
		MinReadable_isNULL = true;
		Resolution_isNULL = true;
		Tolerance_isNULL = true;
		Accuracy_isNULL = true;
		IsLinear_isNULL = true;
		Hysteresis_isNULL = true;
		LowerThresholdNonCritical_isNULL = true;
		UpperThresholdNonCritical_isNULL = true;
		LowerThresholdCritical_isNULL = true;
		UpperThresholdCritical_isNULL = true;
		LowerThresholdFatal_isNULL = true;
		UpperThresholdFatal_isNULL = true;
		SupportedThresholds_isNULL = true;
		EnabledThresholds_isNULL = true;
		SettableThresholds_isNULL = true;
	}
	
	~OpenDRIM_ProcessorVoltageSensor() {}
	
	string getKeys() const {
		return CF_toLowCase(".SystemCreationClassName=\"" + CF_quoteString(SystemCreationClassName) + "\""".SystemName=\"" + CF_quoteString(SystemName) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\""".DeviceID=\"" + CF_quoteString(DeviceID) + "\"");
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getEnabledState(unsigned short& value) const {
		if (EnabledState_isNULL==true)
			return NOT_FOUND;
		value = EnabledState;
		return OK;
	}
	
	int setEnabledState(const unsigned short& newValue) {
		EnabledState = newValue;
		EnabledState_isNULL = false;
		return OK;
	}

	int getOtherEnabledState(string& value) const {
		if (OtherEnabledState_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledState;
		return OK;
	}
	
	int setOtherEnabledState(const string& newValue) {
		OtherEnabledState = newValue;
		OtherEnabledState_isNULL = false;
		return OK;
	}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL==true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	
	int setRequestedState(const unsigned short& newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getEnabledDefault(unsigned short& value) const {
		if (EnabledDefault_isNULL==true)
			return NOT_FOUND;
		value = EnabledDefault;
		return OK;
	}
	
	int setEnabledDefault(const unsigned short& newValue) {
		EnabledDefault = newValue;
		EnabledDefault_isNULL = false;
		return OK;
	}

	int getTimeOfLastStateChange(string& value) const {
		if (TimeOfLastStateChange_isNULL==true)
			return NOT_FOUND;
		value = TimeOfLastStateChange;
		return OK;
	}
	
	int setTimeOfLastStateChange(const string& newValue) {
		TimeOfLastStateChange = newValue;
		TimeOfLastStateChange_isNULL = false;
		return OK;
	}

	int getAvailableRequestedStates(vector<unsigned short>& value) const {
		if (AvailableRequestedStates_isNULL==true)
			return NOT_FOUND;
		value = AvailableRequestedStates;
		return OK;
	}
	
	int setAvailableRequestedStates(const vector<unsigned short>& newValue) {
		AvailableRequestedStates = newValue;
		AvailableRequestedStates_isNULL = false;
		return OK;
	}

	int getTransitioningToState(unsigned short& value) const {
		if (TransitioningToState_isNULL==true)
			return NOT_FOUND;
		value = TransitioningToState;
		return OK;
	}
	
	int setTransitioningToState(const unsigned short& newValue) {
		TransitioningToState = newValue;
		TransitioningToState_isNULL = false;
		return OK;
	}

	int getSystemCreationClassName(string& value) const {
		if (SystemCreationClassName_isNULL==true)
			return NOT_FOUND;
		value = SystemCreationClassName;
		return OK;
	}
	
	int setSystemCreationClassName(const string& newValue) {
		SystemCreationClassName = newValue;
		SystemCreationClassName_isNULL = false;
		return OK;
	}

	int getSystemName(string& value) const {
		if (SystemName_isNULL==true)
			return NOT_FOUND;
		value = SystemName;
		return OK;
	}
	
	int setSystemName(const string& newValue) {
		SystemName = newValue;
		SystemName_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getDeviceID(string& value) const {
		if (DeviceID_isNULL==true)
			return NOT_FOUND;
		value = DeviceID;
		return OK;
	}
	
	int setDeviceID(const string& newValue) {
		DeviceID = newValue;
		DeviceID_isNULL = false;
		return OK;
	}

	int getPowerManagementSupported(bool& value) const {
		if (PowerManagementSupported_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementSupported;
		return OK;
	}
	
	int setPowerManagementSupported(const bool& newValue) {
		PowerManagementSupported = newValue;
		PowerManagementSupported_isNULL = false;
		return OK;
	}

	int getPowerManagementCapabilities(vector<unsigned short>& value) const {
		if (PowerManagementCapabilities_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementCapabilities;
		return OK;
	}
	
	int setPowerManagementCapabilities(const vector<unsigned short>& newValue) {
		PowerManagementCapabilities = newValue;
		PowerManagementCapabilities_isNULL = false;
		return OK;
	}

	int getAvailability(unsigned short& value) const {
		if (Availability_isNULL==true)
			return NOT_FOUND;
		value = Availability;
		return OK;
	}
	
	int setAvailability(const unsigned short& newValue) {
		Availability = newValue;
		Availability_isNULL = false;
		return OK;
	}

	int getStatusInfo(unsigned short& value) const {
		if (StatusInfo_isNULL==true)
			return NOT_FOUND;
		value = StatusInfo;
		return OK;
	}
	
	int setStatusInfo(const unsigned short& newValue) {
		StatusInfo = newValue;
		StatusInfo_isNULL = false;
		return OK;
	}

	int getLastErrorCode(unsigned int& value) const {
		if (LastErrorCode_isNULL==true)
			return NOT_FOUND;
		value = LastErrorCode;
		return OK;
	}
	
	int setLastErrorCode(const unsigned int& newValue) {
		LastErrorCode = newValue;
		LastErrorCode_isNULL = false;
		return OK;
	}

	int getErrorDescription(string& value) const {
		if (ErrorDescription_isNULL==true)
			return NOT_FOUND;
		value = ErrorDescription;
		return OK;
	}
	
	int setErrorDescription(const string& newValue) {
		ErrorDescription = newValue;
		ErrorDescription_isNULL = false;
		return OK;
	}

	int getErrorCleared(bool& value) const {
		if (ErrorCleared_isNULL==true)
			return NOT_FOUND;
		value = ErrorCleared;
		return OK;
	}
	
	int setErrorCleared(const bool& newValue) {
		ErrorCleared = newValue;
		ErrorCleared_isNULL = false;
		return OK;
	}

	int getOtherIdentifyingInfo(vector<string>& value) const {
		if (OtherIdentifyingInfo_isNULL==true)
			return NOT_FOUND;
		value = OtherIdentifyingInfo;
		return OK;
	}
	
	int setOtherIdentifyingInfo(const vector<string>& newValue) {
		OtherIdentifyingInfo = newValue;
		OtherIdentifyingInfo_isNULL = false;
		return OK;
	}

	int getPowerOnHours(unsigned long long& value) const {
		if (PowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = PowerOnHours;
		return OK;
	}
	
	int setPowerOnHours(const unsigned long long& newValue) {
		PowerOnHours = newValue;
		PowerOnHours_isNULL = false;
		return OK;
	}

	int getTotalPowerOnHours(unsigned long long& value) const {
		if (TotalPowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = TotalPowerOnHours;
		return OK;
	}
	
	int setTotalPowerOnHours(const unsigned long long& newValue) {
		TotalPowerOnHours = newValue;
		TotalPowerOnHours_isNULL = false;
		return OK;
	}

	int getIdentifyingDescriptions(vector<string>& value) const {
		if (IdentifyingDescriptions_isNULL==true)
			return NOT_FOUND;
		value = IdentifyingDescriptions;
		return OK;
	}
	
	int setIdentifyingDescriptions(const vector<string>& newValue) {
		IdentifyingDescriptions = newValue;
		IdentifyingDescriptions_isNULL = false;
		return OK;
	}

	int getAdditionalAvailability(vector<unsigned short>& value) const {
		if (AdditionalAvailability_isNULL==true)
			return NOT_FOUND;
		value = AdditionalAvailability;
		return OK;
	}
	
	int setAdditionalAvailability(const vector<unsigned short>& newValue) {
		AdditionalAvailability = newValue;
		AdditionalAvailability_isNULL = false;
		return OK;
	}

	int getMaxQuiesceTime(unsigned long long& value) const {
		if (MaxQuiesceTime_isNULL==true)
			return NOT_FOUND;
		value = MaxQuiesceTime;
		return OK;
	}
	
	int setMaxQuiesceTime(const unsigned long long& newValue) {
		MaxQuiesceTime = newValue;
		MaxQuiesceTime_isNULL = false;
		return OK;
	}

	int getSensorType(unsigned short& value) const {
		if (SensorType_isNULL==true)
			return NOT_FOUND;
		value = SensorType;
		return OK;
	}
	
	int setSensorType(const unsigned short& newValue) {
		SensorType = newValue;
		SensorType_isNULL = false;
		return OK;
	}

	int getOtherSensorTypeDescription(string& value) const {
		if (OtherSensorTypeDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherSensorTypeDescription;
		return OK;
	}
	
	int setOtherSensorTypeDescription(const string& newValue) {
		OtherSensorTypeDescription = newValue;
		OtherSensorTypeDescription_isNULL = false;
		return OK;
	}

	int getPossibleStates(vector<string>& value) const {
		if (PossibleStates_isNULL==true)
			return NOT_FOUND;
		value = PossibleStates;
		return OK;
	}
	
	int setPossibleStates(const vector<string>& newValue) {
		PossibleStates = newValue;
		PossibleStates_isNULL = false;
		return OK;
	}

	int getCurrentState(string& value) const {
		if (CurrentState_isNULL==true)
			return NOT_FOUND;
		value = CurrentState;
		return OK;
	}
	
	int setCurrentState(const string& newValue) {
		CurrentState = newValue;
		CurrentState_isNULL = false;
		return OK;
	}

	int getPollingInterval(unsigned long long& value) const {
		if (PollingInterval_isNULL==true)
			return NOT_FOUND;
		value = PollingInterval;
		return OK;
	}
	
	int setPollingInterval(const unsigned long long& newValue) {
		PollingInterval = newValue;
		PollingInterval_isNULL = false;
		return OK;
	}

	int getBaseUnits(unsigned short& value) const {
		if (BaseUnits_isNULL==true)
			return NOT_FOUND;
		value = BaseUnits;
		return OK;
	}
	
	int setBaseUnits(const unsigned short& newValue) {
		BaseUnits = newValue;
		BaseUnits_isNULL = false;
		return OK;
	}

	int getUnitModifier(int& value) const {
		if (UnitModifier_isNULL==true)
			return NOT_FOUND;
		value = UnitModifier;
		return OK;
	}
	
	int setUnitModifier(const int& newValue) {
		UnitModifier = newValue;
		UnitModifier_isNULL = false;
		return OK;
	}

	int getRateUnits(unsigned short& value) const {
		if (RateUnits_isNULL==true)
			return NOT_FOUND;
		value = RateUnits;
		return OK;
	}
	
	int setRateUnits(const unsigned short& newValue) {
		RateUnits = newValue;
		RateUnits_isNULL = false;
		return OK;
	}

	int getCurrentReading(int& value) const {
		if (CurrentReading_isNULL==true)
			return NOT_FOUND;
		value = CurrentReading;
		return OK;
	}
	
	int setCurrentReading(const int& newValue) {
		CurrentReading = newValue;
		CurrentReading_isNULL = false;
		return OK;
	}

	int getNominalReading(int& value) const {
		if (NominalReading_isNULL==true)
			return NOT_FOUND;
		value = NominalReading;
		return OK;
	}
	
	int setNominalReading(const int& newValue) {
		NominalReading = newValue;
		NominalReading_isNULL = false;
		return OK;
	}

	int getNormalMax(int& value) const {
		if (NormalMax_isNULL==true)
			return NOT_FOUND;
		value = NormalMax;
		return OK;
	}
	
	int setNormalMax(const int& newValue) {
		NormalMax = newValue;
		NormalMax_isNULL = false;
		return OK;
	}

	int getNormalMin(int& value) const {
		if (NormalMin_isNULL==true)
			return NOT_FOUND;
		value = NormalMin;
		return OK;
	}
	
	int setNormalMin(const int& newValue) {
		NormalMin = newValue;
		NormalMin_isNULL = false;
		return OK;
	}

	int getMaxReadable(int& value) const {
		if (MaxReadable_isNULL==true)
			return NOT_FOUND;
		value = MaxReadable;
		return OK;
	}
	
	int setMaxReadable(const int& newValue) {
		MaxReadable = newValue;
		MaxReadable_isNULL = false;
		return OK;
	}

	int getMinReadable(int& value) const {
		if (MinReadable_isNULL==true)
			return NOT_FOUND;
		value = MinReadable;
		return OK;
	}
	
	int setMinReadable(const int& newValue) {
		MinReadable = newValue;
		MinReadable_isNULL = false;
		return OK;
	}

	int getResolution(unsigned int& value) const {
		if (Resolution_isNULL==true)
			return NOT_FOUND;
		value = Resolution;
		return OK;
	}
	
	int setResolution(const unsigned int& newValue) {
		Resolution = newValue;
		Resolution_isNULL = false;
		return OK;
	}

	int getTolerance(int& value) const {
		if (Tolerance_isNULL==true)
			return NOT_FOUND;
		value = Tolerance;
		return OK;
	}
	
	int setTolerance(const int& newValue) {
		Tolerance = newValue;
		Tolerance_isNULL = false;
		return OK;
	}

	int getAccuracy(int& value) const {
		if (Accuracy_isNULL==true)
			return NOT_FOUND;
		value = Accuracy;
		return OK;
	}
	
	int setAccuracy(const int& newValue) {
		Accuracy = newValue;
		Accuracy_isNULL = false;
		return OK;
	}

	int getIsLinear(bool& value) const {
		if (IsLinear_isNULL==true)
			return NOT_FOUND;
		value = IsLinear;
		return OK;
	}
	
	int setIsLinear(const bool& newValue) {
		IsLinear = newValue;
		IsLinear_isNULL = false;
		return OK;
	}

	int getHysteresis(unsigned int& value) const {
		if (Hysteresis_isNULL==true)
			return NOT_FOUND;
		value = Hysteresis;
		return OK;
	}
	
	int setHysteresis(const unsigned int& newValue) {
		Hysteresis = newValue;
		Hysteresis_isNULL = false;
		return OK;
	}

	int getLowerThresholdNonCritical(int& value) const {
		if (LowerThresholdNonCritical_isNULL==true)
			return NOT_FOUND;
		value = LowerThresholdNonCritical;
		return OK;
	}
	
	int setLowerThresholdNonCritical(const int& newValue) {
		LowerThresholdNonCritical = newValue;
		LowerThresholdNonCritical_isNULL = false;
		return OK;
	}

	int getUpperThresholdNonCritical(int& value) const {
		if (UpperThresholdNonCritical_isNULL==true)
			return NOT_FOUND;
		value = UpperThresholdNonCritical;
		return OK;
	}
	
	int setUpperThresholdNonCritical(const int& newValue) {
		UpperThresholdNonCritical = newValue;
		UpperThresholdNonCritical_isNULL = false;
		return OK;
	}

	int getLowerThresholdCritical(int& value) const {
		if (LowerThresholdCritical_isNULL==true)
			return NOT_FOUND;
		value = LowerThresholdCritical;
		return OK;
	}
	
	int setLowerThresholdCritical(const int& newValue) {
		LowerThresholdCritical = newValue;
		LowerThresholdCritical_isNULL = false;
		return OK;
	}

	int getUpperThresholdCritical(int& value) const {
		if (UpperThresholdCritical_isNULL==true)
			return NOT_FOUND;
		value = UpperThresholdCritical;
		return OK;
	}
	
	int setUpperThresholdCritical(const int& newValue) {
		UpperThresholdCritical = newValue;
		UpperThresholdCritical_isNULL = false;
		return OK;
	}

	int getLowerThresholdFatal(int& value) const {
		if (LowerThresholdFatal_isNULL==true)
			return NOT_FOUND;
		value = LowerThresholdFatal;
		return OK;
	}
	
	int setLowerThresholdFatal(const int& newValue) {
		LowerThresholdFatal = newValue;
		LowerThresholdFatal_isNULL = false;
		return OK;
	}

	int getUpperThresholdFatal(int& value) const {
		if (UpperThresholdFatal_isNULL==true)
			return NOT_FOUND;
		value = UpperThresholdFatal;
		return OK;
	}
	
	int setUpperThresholdFatal(const int& newValue) {
		UpperThresholdFatal = newValue;
		UpperThresholdFatal_isNULL = false;
		return OK;
	}

	int getSupportedThresholds(vector<unsigned short>& value) const {
		if (SupportedThresholds_isNULL==true)
			return NOT_FOUND;
		value = SupportedThresholds;
		return OK;
	}
	
	int setSupportedThresholds(const vector<unsigned short>& newValue) {
		SupportedThresholds = newValue;
		SupportedThresholds_isNULL = false;
		return OK;
	}

	int getEnabledThresholds(vector<unsigned short>& value) const {
		if (EnabledThresholds_isNULL==true)
			return NOT_FOUND;
		value = EnabledThresholds;
		return OK;
	}
	
	int setEnabledThresholds(const vector<unsigned short>& newValue) {
		EnabledThresholds = newValue;
		EnabledThresholds_isNULL = false;
		return OK;
	}

	int getSettableThresholds(vector<unsigned short>& value) const {
		if (SettableThresholds_isNULL==true)
			return NOT_FOUND;
		value = SettableThresholds;
		return OK;
	}
	
	int setSettableThresholds(const vector<unsigned short>& newValue) {
		SettableThresholds = newValue;
		SettableThresholds_isNULL = false;
		return OK;
	}

};

class OpenDRIM_ProcessorVoltageSensor_RequestStateChange_In {

public:

	unsigned short RequestedState;
	bool RequestedState_isNULL;

	Objectpath Job;
	bool Job_isNULL;

	string TimeoutPeriod;
	bool TimeoutPeriod_isNULL;

	OpenDRIM_ProcessorVoltageSensor_RequestStateChange_In() {
		RequestedState_isNULL = true;
		Job_isNULL = true;
		TimeoutPeriod_isNULL = true;
	}

	~OpenDRIM_ProcessorVoltageSensor_RequestStateChange_In() {}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL == true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	int setRequestedState(const unsigned short&  newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

	int getTimeoutPeriod(string& value) const {
		if (TimeoutPeriod_isNULL == true)
			return NOT_FOUND;
		value = TimeoutPeriod;
		return OK;
	}
	int setTimeoutPeriod(const string&  newValue) {
		TimeoutPeriod = newValue;
		TimeoutPeriod_isNULL = false;
		return OK;
	}

};

class OpenDRIM_ProcessorVoltageSensor_RequestStateChange_Out {

public:

	Objectpath Job;
	bool Job_isNULL;

	OpenDRIM_ProcessorVoltageSensor_RequestStateChange_Out() {
		Job_isNULL = true;
	}

	~OpenDRIM_ProcessorVoltageSensor_RequestStateChange_Out() {}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

};

class OpenDRIM_ProcessorVoltageSensor_SetPowerState_In {

public:

	unsigned short PowerState;
	bool PowerState_isNULL;

	string Time;
	bool Time_isNULL;

	OpenDRIM_ProcessorVoltageSensor_SetPowerState_In() {
		PowerState_isNULL = true;
		Time_isNULL = true;
	}

	~OpenDRIM_ProcessorVoltageSensor_SetPowerState_In() {}

	int getPowerState(unsigned short& value) const {
		if (PowerState_isNULL == true)
			return NOT_FOUND;
		value = PowerState;
		return OK;
	}
	int setPowerState(const unsigned short&  newValue) {
		PowerState = newValue;
		PowerState_isNULL = false;
		return OK;
	}

	int getTime(string& value) const {
		if (Time_isNULL == true)
			return NOT_FOUND;
		value = Time;
		return OK;
	}
	int setTime(const string&  newValue) {
		Time = newValue;
		Time_isNULL = false;
		return OK;
	}

};

class OpenDRIM_ProcessorVoltageSensor_EnableDevice_In {

public:

	bool Enabled;
	bool Enabled_isNULL;

	OpenDRIM_ProcessorVoltageSensor_EnableDevice_In() {
		Enabled_isNULL = true;
	}

	~OpenDRIM_ProcessorVoltageSensor_EnableDevice_In() {}

	int getEnabled(bool& value) const {
		if (Enabled_isNULL == true)
			return NOT_FOUND;
		value = Enabled;
		return OK;
	}
	int setEnabled(const bool&  newValue) {
		Enabled = newValue;
		Enabled_isNULL = false;
		return OK;
	}

};

class OpenDRIM_ProcessorVoltageSensor_OnlineDevice_In {

public:

	bool Online;
	bool Online_isNULL;

	OpenDRIM_ProcessorVoltageSensor_OnlineDevice_In() {
		Online_isNULL = true;
	}

	~OpenDRIM_ProcessorVoltageSensor_OnlineDevice_In() {}

	int getOnline(bool& value) const {
		if (Online_isNULL == true)
			return NOT_FOUND;
		value = Online;
		return OK;
	}
	int setOnline(const bool&  newValue) {
		Online = newValue;
		Online_isNULL = false;
		return OK;
	}

};

class OpenDRIM_ProcessorVoltageSensor_QuiesceDevice_In {

public:

	bool Quiesce;
	bool Quiesce_isNULL;

	OpenDRIM_ProcessorVoltageSensor_QuiesceDevice_In() {
		Quiesce_isNULL = true;
	}

	~OpenDRIM_ProcessorVoltageSensor_QuiesceDevice_In() {}

	int getQuiesce(bool& value) const {
		if (Quiesce_isNULL == true)
			return NOT_FOUND;
		value = Quiesce;
		return OK;
	}
	int setQuiesce(const bool&  newValue) {
		Quiesce = newValue;
		Quiesce_isNULL = false;
		return OK;
	}

};

class OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_In {

public:

	int SensorReading;
	bool SensorReading_isNULL;

	int Accuracy;
	bool Accuracy_isNULL;

	unsigned int Resolution;
	bool Resolution_isNULL;

	int Tolerance;
	bool Tolerance_isNULL;

	unsigned int Hysteresis;
	bool Hysteresis_isNULL;

	OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_In() {
		SensorReading_isNULL = true;
		Accuracy_isNULL = true;
		Resolution_isNULL = true;
		Tolerance_isNULL = true;
		Hysteresis_isNULL = true;
	}

	~OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_In() {}

	int getSensorReading(int& value) const {
		if (SensorReading_isNULL == true)
			return NOT_FOUND;
		value = SensorReading;
		return OK;
	}
	int setSensorReading(const int&  newValue) {
		SensorReading = newValue;
		SensorReading_isNULL = false;
		return OK;
	}

	int getAccuracy(int& value) const {
		if (Accuracy_isNULL == true)
			return NOT_FOUND;
		value = Accuracy;
		return OK;
	}
	int setAccuracy(const int&  newValue) {
		Accuracy = newValue;
		Accuracy_isNULL = false;
		return OK;
	}

	int getResolution(unsigned int& value) const {
		if (Resolution_isNULL == true)
			return NOT_FOUND;
		value = Resolution;
		return OK;
	}
	int setResolution(const unsigned int&  newValue) {
		Resolution = newValue;
		Resolution_isNULL = false;
		return OK;
	}

	int getTolerance(int& value) const {
		if (Tolerance_isNULL == true)
			return NOT_FOUND;
		value = Tolerance;
		return OK;
	}
	int setTolerance(const int&  newValue) {
		Tolerance = newValue;
		Tolerance_isNULL = false;
		return OK;
	}

	int getHysteresis(unsigned int& value) const {
		if (Hysteresis_isNULL == true)
			return NOT_FOUND;
		value = Hysteresis;
		return OK;
	}
	int setHysteresis(const unsigned int&  newValue) {
		Hysteresis = newValue;
		Hysteresis_isNULL = false;
		return OK;
	}

};

class OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_Out {

public:

	int Accuracy;
	bool Accuracy_isNULL;

	unsigned int Resolution;
	bool Resolution_isNULL;

	int Tolerance;
	bool Tolerance_isNULL;

	unsigned int Hysteresis;
	bool Hysteresis_isNULL;

	OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_Out() {
		Accuracy_isNULL = true;
		Resolution_isNULL = true;
		Tolerance_isNULL = true;
		Hysteresis_isNULL = true;
	}

	~OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_Out() {}

	int getAccuracy(int& value) const {
		if (Accuracy_isNULL == true)
			return NOT_FOUND;
		value = Accuracy;
		return OK;
	}
	int setAccuracy(const int&  newValue) {
		Accuracy = newValue;
		Accuracy_isNULL = false;
		return OK;
	}

	int getResolution(unsigned int& value) const {
		if (Resolution_isNULL == true)
			return NOT_FOUND;
		value = Resolution;
		return OK;
	}
	int setResolution(const unsigned int&  newValue) {
		Resolution = newValue;
		Resolution_isNULL = false;
		return OK;
	}

	int getTolerance(int& value) const {
		if (Tolerance_isNULL == true)
			return NOT_FOUND;
		value = Tolerance;
		return OK;
	}
	int setTolerance(const int&  newValue) {
		Tolerance = newValue;
		Tolerance_isNULL = false;
		return OK;
	}

	int getHysteresis(unsigned int& value) const {
		if (Hysteresis_isNULL == true)
			return NOT_FOUND;
		value = Hysteresis;
		return OK;
	}
	int setHysteresis(const unsigned int&  newValue) {
		Hysteresis = newValue;
		Hysteresis_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_PROCESSORVOLTAGESENSOR_H_*/
