#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Dark Eye: Chains of Satinav
# send your bug reports to contact@dotslashplay.it
###

script_version=20240827.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-dark-eye-chains-of-satinav'
GAME_NAME='The Dark Eye: Chains of Satinav'

ARCHIVE_BASE_1_NAME='setup_the_dark_eye_chains_of_satinav_2.0.0.4.exe'
ARCHIVE_BASE_1_MD5='022a59739b9d7b16f036fb2fecd5bca2'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_the_dark_eye_chains_of_satinav_2.0.0.4-1.bin'
ARCHIVE_BASE_1_PART1_MD5='aa50ac1bf998b7d945f58b6104f58298'
ARCHIVE_BASE_1_PART2_NAME='setup_the_dark_eye_chains_of_satinav_2.0.0.4-2.bin'
ARCHIVE_BASE_1_PART2_MD5='6748d3208d3c59f91cce0de4e6e56af7'
ARCHIVE_BASE_1_PART3_NAME='setup_the_dark_eye_chains_of_satinav_2.0.0.4-3.bin'
ARCHIVE_BASE_1_PART3_MD5='4c1208642ea83d7dde6e90ac3ce885fb'
ARCHIVE_BASE_1_PART4_NAME='setup_the_dark_eye_chains_of_satinav_2.0.0.4-4.bin'
ARCHIVE_BASE_1_PART4_MD5='284a6c2e37897e44a69fac6f8c0971e0'
ARCHIVE_BASE_1_SIZE='5500000'
ARCHIVE_BASE_1_VERSION='1.0-gog2.0.0.4'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_dark_eye_chains_of_satinav'

VISIONAIRE_NAME='satinav'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME0_BIN_FILES='
audiere.dll'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Local Settings/Application Data/Daedalic Entertainment/Satinav'

PKG_BIN_ARCH='32'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
