#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Antichamber
# send your bug reports to contact@dotslashplay.it
###

script_version=20230206.2

GAME_ID='antichamber'
GAME_NAME='Antichamber'

ARCHIVE_BASE_0='antichamber_1.01_linux_1392664980.sh'
ARCHIVE_BASE_0_MD5='37bca01c411d813c8729259b7db2dba0'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='690000'
ARCHIVE_BASE_0_VERSION='1.01-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/antichamber'

CONTENT_PATH_DEFAULT='data'
CONTENT_LIBS_BIN_PATH='data/x86/Binaries/Linux/lib'
## - The game binary is linked against libsteam_api.so,
##   so we can not drop it.
## - The libSDL2_mixer-2.0.so.0 library is a custom build,
##   it must be included to avoid the following error:
##   undefined symbol: MinorityMix_SetPosition
CONTENT_LIBS_BIN_FILES='
libPhysXCooking.so
libPhysXCore.so
libSDL2_mixer-2.0.so.0
libsteam_api.so
libtcmalloc.so.0'
CONTENT_GAME_BIN_PATH='data/x86'
CONTENT_GAME_BIN_FILES='
Binaries/Linux/UDKGame-Linux'
CONTENT_GAME_DATA_PATH='data/noarch'
CONTENT_GAME_DATA_FILES='
Engine
UDKGame
AntichamberIcon.bmp
AntichamberIcon.png'
CONTENT_DOC_DATA_PATH='data/noarch'
CONTENT_DOC_DATA_FILES='
README.linux
BuildVersion.txt
UpdateLog.txt'

APP_MAIN_EXE='Binaries/Linux/UDKGame-Linux'
APP_MAIN_ICON='noarch/AntichamberIcon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libogg.so.0
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libvorbisfile.so.3
libvorbis.so.0'

# Run the game binary from its parent directory

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")'

# Load common functions

target_version='2.21'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
