#!/bin/sh
set -o errexit

###
# Copyright © 2015-2022, Antoine Le Gonidec <vv221@dotslashplay.it>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Iratus
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220103.3

# Set game-specific variables

GAME_ID='iratus'
GAME_NAME='Iratus: Lord of the Dead'

# Archives

## The "language-specific" installers actually include all languages.
## There is no need to build distinct packages for each one.

ARCHIVE_BASE_EN_0='iratus_lord_of_the_dead_linux_181_13_00_48040.sh'
ARCHIVE_BASE_EN_0_MD5='e238fdf4277942c22805409a4d347635'
ARCHIVE_BASE_EN_0_TYPE='mojosetup'
ARCHIVE_BASE_EN_0_SIZE='3400000'
ARCHIVE_BASE_EN_0_VERSION='181.03.00-gog48040'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/iratus_lord_of_the_dead'

ARCHIVE_BASE_FR_0='iratus_lord_of_the_dead_french_linux_181_03_00_45013.sh'
ARCHIVE_BASE_FR_0_MD5='9dd7899c4f5254bb555219530a32dc95'
ARCHIVE_BASE_FR_0_TYPE='mojosetup'
ARCHIVE_BASE_FR_0_SIZE='3400000'
ARCHIVE_BASE_FR_0_VERSION='181.03.00-gog48040'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/iratus_lord_of_the_dead'


UNITY3D_NAME='Iratus'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}
${UNITY3D_NAME}_Data/Mono
${UNITY3D_NAME}_Data/Plugins"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

APP_MAIN_EXE="$UNITY3D_NAME"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libz.so.1 libgtk-x11-2.0.so.0 libgdk_pixbuf-2.0.so.0 libgobject-2.0.so.0 libglib-2.0.so.0"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"
 
# Extract game data
 
extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout
 
# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon
 
PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers
 
PKG='PKG_BIN'
launchers_write 'APP_MAIN'
 
# Build package
 
write_metadata
build_pkg
 
# Clean up
 
rm --recursive "$PLAYIT_WORKDIR"
 
# Print instructions
 
print_instructions
 
exit 0
