#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sherlock Holmes 6: The Testament of Sherlock Holmes
# send your bug reports to contact@dotslashplay.it
###

script_version=20230221.3

GAME_ID='sherlock-holmes-6-the-testament-of-sherlock-holmes'
GAME_NAME='The Testament of Sherlock Holmes'

ARCHIVE_BASE_0='setup_testament_of_sherlock_holmes_2.0.0.5.exe'
ARCHIVE_BASE_0_MD5='5942a1e7b0f21d5d4f08c3b3e0bb40e3'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--progress=1 --silent --lowercase --gog'
ARCHIVE_BASE_0_PART1='setup_testament_of_sherlock_holmes_2.0.0.5-1.bin'
ARCHIVE_BASE_0_PART1_MD5='5b223e42466e6be155fc0da569848a21'
ARCHIVE_BASE_0_PART1_TYPE='rar'
ARCHIVE_BASE_0_PART2='setup_testament_of_sherlock_holmes_2.0.0.5-2.bin'
ARCHIVE_BASE_0_PART2_MD5='e9b3a3ce285d95af9937e1269b82cdbb'
ARCHIVE_BASE_0_PART2_TYPE='rar'
ARCHIVE_BASE_0_SIZE='10000000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.5'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/testament_of_sherlock_holmes_the'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
d3dx9_32.dll
D3DX9_42.dll
game.exe
game.ini
msvcr71.dll'
CONTENT_GAME_DATA_FILES='
000
001
002
003
004
logo
data.txt
splash_screen.jpg
*.0050'

APP_WINE_LINK_DIRS='
appdata:users/${USER}/AppData/Roaming/Frogwares/The Testament of Sherlock Holmes'
USER_PERSISTENT_DIRECTORIES='
appdata/save'
USER_PERSISTENT_FILES='
appdata/setup.ini'

APP_MAIN_EXE='game.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101 --language=1033'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Ensure availability of required library PhysXLoader.dll

APP_WINETRICKS="$APP_WINETRICKS physx"

# Load common functions

target_version='2.21'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
