/*
 * Copyright (C) 2010 Motorola
 * Copyright (C) 2011-2012 Canonical, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ANDROID_AUDIO_WRAPPER_DEFINE_H
#define ANDROID_AUDIO_WRAPPER_DEFINE_H


#define ANDROID_AUDIO_WRAPPER_ERROR_START 0x9000000

typedef unsigned long uint32;
typedef int status_type;
typedef void* TrackHandle;
typedef void* RecordHandle;
typedef int AudioIOHandle;
typedef void (*callback_t)(int event, void* user, void *info);

#define AUDIO_PARAMETER_ROUTING "routing"
#define AUDIO_PARAMETER_FORMAT "format"
#define AUDIO_PARAMETER_CHANNELS "channels"
#define AUDIO_PARAMETER_FRAME_COUNT "frame_count"
#define AUDIO_PARAMETER_INPUT_SOURCE "input_source"

enum{
    OK = 0,
    NO_ERROR = 0,
    //UNKNOWN_ERROR,
    //INIT_FAIL = -ENODEV, 
    INVALID_PARAM = ANDROID_AUDIO_WRAPPER_ERROR_START
};

// Audio sub formats (see AudioSystem::audio_format).
enum pcm_sub_format {
    PCM_SUB_16_BIT          = 0x1, // must be 1 for backward compatibility
    PCM_SUB_8_BIT           = 0x2, // must be 2 for backward compatibility
};

#endif
