#!/bin/sh -e

VERSION=$2
TAR=../aspectj-maven-plugin_$VERSION.orig.tar.xz
DIR=aspectj-maven-plugin-$VERSION
TAG=$(echo "aspectj-maven-plugin-$VERSION" | sed -re's/~(alpha|beta)/-\1-/')

svn export http://svn.codehaus.org/mojo/tags/${TAG}/ $DIR
XZ_OPT=--best tar -c -J -f $TAR --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
