/* Copyright (c) 2007  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of pow() function. 500 random cases.
   $Id$
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x;		/* first argument	*/
    long y;		/* second argument	*/
    long z;		/* pow(x,y)		*/
} t[] = {

    /* x, y, pow(x,y)	*/
    { 0x3dc0d6a6,0x400e129c,0x3baccce2 }, /*   1:  9.4159409e-02  2.2198858e+00  5.2734474e-03 */
    { 0x3f2f30db,0x3f4222d7,0x3f400204 }, /*   2:  6.8433923e-01  7.5834411e-01  7.5003076e-01 */
    { 0x402b78b9,0x401df40e,0x41362a07 }, /*   3:  2.6792433e+00  2.4680209e+00  1.1385261e+01 */
    { 0x3f99b9f9,0xbff0aed5,0x3f356b09 }, /*   4:  1.2009879e+00 -1.8803355e+00  7.0866448e-01 */
    { 0x3f4c871b,0x3ff46ddb,0x3f26c11d }, /*   5:  7.9893655e-01  1.9096025e+00  6.5138417e-01 */
    { 0x3f2ee4c8,0xbfc530b0,0x3fe634f0 }, /*   6:  6.8317842e-01 -1.5405483e+00  1.7984905e+00 */
    { 0x3c76c248,0x42dbf9d3,0x00000000 }, /*   7:  1.5060969e-02  1.0998794e+02  0.0000000e+00 */
    { 0x3f284bcd,0xc04629bb,0x406a8aa2 }, /*   8:  6.5740663e-01 -3.0962970e+00  3.6647115e+00 */
    { 0xbc789220,0x40000000,0x39715b71 }, /*   9: -1.5171558e-02  2.0000000e+00  2.3017616e-04 */
    { 0x3ee5a8c9,0xbfbee616,0x40539310 }, /*  10:  4.4855335e-01 -1.4913967e+00  3.3058510e+00 */
    { 0xbfaa8a28,0xc0400000,0xbed87b9f }, /*  11: -1.3323412e+00 -3.0000000e+00 -4.2281815e-01 */
    { 0x3ed042be,0x3fcdf5eb,0x3e70d2a0 }, /*  12:  4.0675920e-01  1.6090673e+00  2.3517847e-01 */
    { 0x41c6cedb,0x3ff0f021,0x43d3934d }, /*  13:  2.4851004e+01  1.8823282e+00  4.2315079e+02 */
    { 0xbf465f60,0xc1600000,0x420e2090 }, /*  14: -7.7489281e-01 -1.4000000e+01  3.5531799e+01 */
    { 0x3a00a69c,0x3ff3a646,0x3506dbac }, /*  15:  4.9076392e-04  1.9035118e+00  5.0238555e-07 */
    { 0x40f25dab,0xbfce9ba8,0x3d1bf6d5 }, /*  16:  7.5739341e+00 -1.6141253e+00  3.8077194e-02 */
    { 0x3f6eabb4,0x4030681e,0x3f530671 }, /*  17:  9.3230748e-01  2.7563548e+00  8.2431704e-01 */
    { 0x3f92743b,0xbfc572d0,0x3f4ff9da }, /*  18:  1.1441721e+00 -1.5425663e+00  8.1240618e-01 */
    { 0x408faf8d,0x3fd14d9f,0x413a8129 }, /*  19:  4.4901795e+00  1.6351813e+00  1.1656533e+01 */
    { 0x3fded439,0x3f6ed954,0x3fd6b467 }, /*  20:  1.7408515e+00  9.3300366e-01  1.6773804e+00 */
    { 0x3f0895d8,0xc00cf7ff,0x407f59f8 }, /*  21:  5.3353643e-01 -2.2026365e+00  3.9898663e+00 */
    { 0x3f6791f8,0x3fee6837,0x3f546116 }, /*  22:  9.0457106e-01  1.8625554e+00  8.2960641e-01 */
    { 0xbf6231ee,0xc1000000,0x402c47b4 }, /*  23: -8.8357437e-01 -8.0000000e+00  2.6918764e+00 */
    { 0x3fd3a7cc,0x3e89d931,0x3f928f6c }, /*  24:  1.6535583e+00  2.6923516e-01  1.1450019e+00 */
    { 0x3dce9a60,0xc07e9c49,0x460f898a }, /*  25:  1.0088038e-01 -3.9782889e+00  9.1863848e+03 */
    { 0x3f220be1,0x3fdf3ff4,0x3ee69ccf }, /*  26:  6.3299376e-01  1.7441392e+00  4.5041510e-01 */
    { 0x3fc2d68e,0xbff8abed,0x3ee25ab4 }, /*  27:  1.5221727e+00 -1.9427468e+00  4.4209826e-01 */
    { 0xbfa7effe,0x41600000,0x4233233d }, /*  28: -1.3120115e+00  1.4000000e+01  4.4784412e+01 */
    { 0x3f183582,0x4010e8f5,0x3e9dc3cf }, /*  29:  5.9456646e-01  2.2642186e+00  3.0813453e-01 */
    { 0x40018c30,0x400f24e0,0x409aec3c }, /*  30:  2.0241814e+00  2.2366257e+00  4.8413372e+00 */
    { 0x3e74214c,0xc04548be,0x42a62428 }, /*  31:  2.3840827e-01 -3.0825648e+00  8.3070618e+01 */
    { 0x3f5fac71,0x402722e3,0x3f33f1ef }, /*  32:  8.7372500e-01  2.6115043e+00  7.0291036e-01 */
    { 0x3f2176ef,0xc05e87a5,0x409ee62c }, /*  33:  6.3072103e-01 -3.4770291e+00  4.9655972e+00 */
    { 0x413e6931,0x4158c299,0x57a977fc }, /*  34:  1.1900681e+01  1.3547509e+01  3.7266559e+14 */
    { 0x3f03ac66,0xc0416ae0,0x40eea7ad }, /*  35:  5.1434934e-01 -3.0221481e+00  7.4579682e+00 */
    { 0x3cdbc7a8,0x4055c5e2,0x36bd3645 }, /*  36:  2.6828602e-02  3.3402028e+00  5.6389567e-06 */
    { 0xbfac4be1,0xc1500000,0xbcac000a }, /*  37: -1.3460656e+00 -1.3000000e+01 -2.0996112e-02 */
    { 0xbe0cf95f,0xbf800000,0xc0e8709a }, /*  38: -1.3767003e-01 -1.0000000e+00 -7.2637453e+00 */
    { 0x4001939d,0x3fad427a,0x40264879 }, /*  39:  2.0246346e+00  1.3535912e+00  2.5981734e+00 */
    { 0xbf915839,0x00000000,0x3f800000 }, /*  40: -1.1355048e+00  0.0000000e+00  1.0000000e+00 */
    { 0x3f6ab467,0x401386f0,0x3f518dc0 }, /*  41:  9.1681522e-01  2.3051109e+00  8.1856918e-01 */
    { 0x3f1e76cf,0xc0384741,0x407eab08 }, /*  42:  6.1900038e-01 -2.8793490e+00  3.9791889e+00 */
    { 0xbf731f99,0x40400000,0xbf5b47df }, /*  43: -9.4970089e-01  3.0000000e+00 -8.5656542e-01 */
    { 0x3fe29f29,0xc0fe945a,0x3c2e0f82 }, /*  44:  1.7704822e+00 -7.9556093e+00  1.0623815e-02 */
    { 0x3f250a6c,0x3ff1e3ac,0x3edf5a08 }, /*  45:  6.4469028e-01  1.8897605e+00  4.3623376e-01 */
    { 0x3f6aa004,0xbff51bbe,0x3f97421d }, /*  46:  9.1650414e-01 -1.9149091e+00  1.1817051e+00 */
    { 0x3fdd9bd4,0xc00c6476,0x3e9996ae }, /*  47:  1.7313180e+00 -2.1936316e+00  2.9997772e-01 */
    { 0x404eefbc,0xc01b88e0,0x3d6c7863 }, /*  48:  3.2333822e+00 -2.4302292e+00  5.7731997e-02 */
    { 0x3fe1f8d4,0x3fa5aa04,0x40058dfb }, /*  49:  1.7654061e+00  1.2942510e+00  2.0867908e+00 */
    { 0x3f693d17,0x40899989,0x3f2b88bc }, /*  50:  9.1108841e-01  4.2999921e+00  6.7005515e-01 */
    { 0x3ee4691f,0xbfbadbe6,0x404fefbf }, /*  51:  4.4611451e-01 -1.4598358e+00  3.2490079e+00 */
    { 0x3d08dcf2,0x400dba8b,0x3a0d2ce6 }, /*  52:  3.3413835e-02  2.2145107e+00  5.3854135e-04 */
    { 0x3e356a32,0xbfca3a47,0x41766329 }, /*  53:  1.7716292e-01 -1.5799035e+00  1.5399209e+01 */
    { 0x3ec22770,0xbfda7f1c,0x40a77f7a }, /*  54:  3.7920713e-01 -1.7070041e+00  5.2343111e+00 */
    { 0x3eb36ffa,0xc00c1793,0x411ece7d }, /*  55:  3.5046369e-01 -2.1889389e+00  9.9254122e+00 */
    { 0xbf8d4571,0xc1500000,0xbe8e00fc }, /*  56: -1.1036817e+00 -1.3000000e+01 -2.7735126e-01 */
    { 0x4737124b,0xbff636b6,0x308e65a4 }, /*  57:  4.6866293e+04 -1.9235446e+00  1.0360748e-09 */
    { 0x3f9f79a7,0xbfee66ad,0x3f29fb45 }, /*  58:  1.2459000e+00 -1.8625084e+00  6.6399032e-01 */
    { 0x3ee961f7,0xbfb57501,0x4042ee0a }, /*  59:  4.5582554e-01 -1.4176332e+00  3.0457788e+00 */
    { 0x3fcdd691,0xbff5818f,0x3ecdd9d2 }, /*  60:  1.6081105e+00 -1.9180163e+00  4.0205246e-01 */
    { 0x3f7256ad,0xc0074a35,0x3f8fbbc0 }, /*  61:  9.4663507e-01 -2.1139042e+00  1.1229172e+00 */
    { 0xbf53e1d8,0xc0a00000,0xc024c7f6 }, /*  62: -8.2766485e-01 -5.0000000e+00 -2.5747046e+00 */
    { 0x3f9da7d4,0xbc740dee,0x3f7f34e4 }, /*  63:  1.2316842e+00 -1.4895899e-02  9.9690080e-01 */
    { 0x3f9d7f91,0xbfdb1b20,0x3f338067 }, /*  64:  1.2304555e+00 -1.7117653e+00  7.0117801e-01 */
    { 0x3f92b244,0xc02d2341,0x3f31094b }, /*  65:  1.1460652e+00 -2.7052767e+00  6.9154805e-01 */
    { 0x3fb9f638,0x401b6015,0x401e7c95 }, /*  66:  1.4528265e+00  2.4277394e+00  2.4763539e+00 */
    { 0xc354a4fe,0x41600000,0x7598734f }, /*  67: -2.1264450e+02  1.4000000e+01  3.8650774e+32 */
    { 0x4110e99e,0x3fa79e51,0x418f4fc5 }, /*  68:  9.0570354e+00  1.3095189e+00  1.7913950e+01 */
    { 0x3f3c930d,0x40a62eda,0x3e515857 }, /*  69:  7.3661882e-01  5.1932192e+00  2.0443855e-01 */
    { 0x3e873ddb,0xc007d910,0x4186fdb8 }, /*  70:  2.6414379e-01 -2.1226234e+00  1.6873886e+01 */
    { 0x3f677eb7,0x403def3b,0x3f3de9c6 }, /*  71:  9.0427727e-01  2.9677265e+00  7.4184835e-01 */
    { 0x4045cd05,0x400c39cf,0x413d989c }, /*  72:  3.0906384e+00  2.1910284e+00  1.1849758e+01 */
    { 0x40afa4f0,0x3fd3e30a,0x41860810 }, /*  73:  5.4888840e+00  1.6553662e+00  1.6753937e+01 */
    { 0x3f767fed,0xbfe10364,0x3f88cc68 }, /*  74:  9.6288949e-01 -1.7579160e+00  1.0687380e+00 */
    { 0x40e74061,0xbf924fdc,0x3dd58eab }, /*  75:  7.2266088e+00 -1.1430621e+00  1.0427602e-01 */
    { 0x4060c242,0xc02a1c56,0x3d1152b1 }, /*  76:  3.5118566e+00 -2.6579795e+00  3.5479251e-02 */
    { 0x3f959bd9,0x3fac1f53,0x3f9ddfae }, /*  77:  1.1688186e+00  1.3447059e+00  1.2333887e+00 */
    { 0x3ff19161,0x40284294,0x40a9f357 }, /*  78:  1.8872491e+00  2.6290636e+00  5.3109546e+00 */
    { 0x3ee49aae,0xc02ec4a6,0x4110ac8c }, /*  79:  4.4649261e-01 -2.7307525e+00  9.0421257e+00 */
    { 0x50e9cfc7,0xc207d414,0x00000000 }, /*  80:  3.1381666e+10 -3.3957108e+01  0.0000000e+00 */
    { 0x3f6668a3,0x3f5cbdd3,0x3f69c680 }, /*  81:  9.0003413e-01  8.6227149e-01  9.1318512e-01 */
    { 0x3fd78959,0x3f9fd561,0x3ff55c3a }, /*  82:  1.6838790e+00  1.2486993e+00  1.9168770e+00 */
    { 0x3ff74c1e,0x400c9f08,0x408802a4 }, /*  83:  1.9320104e+00  2.1972065e+00  4.2503223e+00 */
    { 0xbf8f43c6,0x41500000,0xc08a6e2f }, /*  84: -1.1192558e+00  1.3000000e+01 -4.3259501e+00 */
    { 0x3e97c664,0x4039cdca,0x3cf00d51 }, /*  85:  2.9643548e-01  2.9031854e+00  2.9303225e-02 */
    { 0x41c9db2a,0xbf0d432d,0x3e2c7657 }, /*  86:  2.5232014e+01 -5.5180627e-01  1.6842018e-01 */
    { 0x3ff92792,0x400de851,0x408c20c6 }, /*  87:  1.9465201e+00  2.2173045e+00  4.3790007e+00 */
    { 0x404fcd89,0xbfbb171d,0x3e371c11 }, /*  88:  3.2469199e+00 -1.4616429e+00  1.7881800e-01 */
    { 0x3f658b46,0xbff8120e,0x3f9e221a }, /*  89:  8.9665639e-01 -1.9380510e+00  1.2354157e+00 */
    { 0x3f45356e,0x3fcddfac,0x3f284331 }, /*  90:  7.7034652e-01  1.6083884e+00  6.5727526e-01 */
    { 0xbf1ce580,0x41500000,0xbae19caa }, /*  91: -6.1287689e-01  1.3000000e+01 -1.7212827e-03 */
    { 0x3f96f924,0xc00dea8b,0x3f3187b1 }, /*  92:  1.1794782e+00 -2.2174404e+00  6.9347674e-01 */
    { 0x3f86ad02,0xbfd1a286,0x3f6b8c2b }, /*  93:  1.0521548e+00 -1.6377723e+00  9.2010754e-01 */
    { 0x42d06773,0xc06590ef,0x33784102 }, /*  94:  1.0420205e+02 -3.5869710e+00  5.7801124e-08 */
    { 0x3f02cc97,0x40358da5,0x3e1867a0 }, /*  95:  5.1093429e-01  2.8367703e+00  1.4883280e-01 */
    { 0x3f41877c,0x3fd9e365,0x3f1f02db }, /*  96:  7.5597358e-01  1.7022520e+00  6.2113732e-01 */
    { 0x40aafd3f,0xbeab184b,0x3f1239e3 }, /*  97:  5.3434138e+00 -3.3416972e-01  5.7119578e-01 */
    { 0x29c31614,0x4038b919,0x00d86b79 }, /*  98:  8.6635695e-14  2.8862975e+00  1.9875021e-38 */
    { 0xbf76905a,0xc1700000,0xbfe0d646 }, /*  99: -9.6314013e-01 -1.5000000e+01 -1.7565391e+00 */
    { 0x4078a28e,0xbf6fb8a8,0x3e8fab7d }, /* 100:  3.8849216e+00 -9.3641138e-01  2.8060523e-01 */
    { 0x3f990903,0xc0556647,0x3f0d1bf1 }, /* 101:  1.1955875e+00 -3.3343675e+00  5.5120760e-01 */
    { 0x3ee43734,0xc01133dc,0x40c822b2 }, /* 102:  4.4573367e-01 -2.2687902e+00  6.2542353e+00 */
    { 0x3f680ad2,0xc033c727,0x3fa8afa5 }, /* 103:  9.0641510e-01 -2.8090303e+00  1.3178602e+00 */
    { 0x3f6b363f,0x3fb4f225,0x3f631d60 }, /* 104:  9.1879648e-01  1.4136397e+00  8.8716698e-01 */
    { 0x3f3a56cb,0x40b16c88,0x3e300012 }, /* 105:  7.2788686e-01  5.5444984e+00  1.7187527e-01 */
    { 0x3eabfffd,0x3ff0f5cd,0x3e035d86 }, /* 106:  3.3593741e-01  1.8825012e+00  1.2828645e-01 */
    { 0x3f9d09a7,0x400a0ee3,0x3fc6f438 }, /* 107:  1.2268571e+00  2.1571586e+00  1.5543280e+00 */
    { 0x3f0144ec,0x409a6582,0x3d17909b }, /* 108:  5.0495791e-01  4.8248911e+00  3.7003141e-02 */
    { 0x3f875f80,0xc02a0328,0x3f5c9cb3 }, /* 109:  1.0576019e+00 -2.6564426e+00  8.6176604e-01 */
    { 0x40b59c4e,0xc06e8dec,0x3acacd8b }, /* 110:  5.6753302e+00 -3.7274122e+00  1.5472634e-03 */
    { 0x402bdec9,0xc18b20eb,0x331488f2 }, /* 111:  2.6854727e+00 -1.7391073e+01  3.4583486e-08 */
    { 0x404d3be8,0xc02893fd,0x3d3e439b }, /* 112:  3.2067814e+00 -2.6340325e+00  4.6451192e-02 */
    { 0x3edd0e11,0xbfc11405,0x4063330c }, /* 113:  4.3174794e-01 -1.5084234e+00  3.5499907e+00 */
    { 0x3fde0826,0xbfb994bf,0x3ee6630b }, /* 114:  1.7346237e+00 -1.4498519e+00  4.4997439e-01 */
    { 0xc036b350,0x40000000,0x41026373 }, /* 115: -2.8546944e+00  2.0000000e+00  8.1492796e+00 */
    { 0x3fe1fcc3,0x40297c7e,0x40903006 }, /* 116:  1.7655262e+00  2.6482234e+00  4.5058622e+00 */
    { 0xbf4fc480,0xc0000000,0x3fc253d9 }, /* 117: -8.1159210e-01 -2.0000000e+00  1.5181838e+00 */
    { 0x3e685d7f,0x400cd152,0x3d1cb5f4 }, /* 118:  2.2691916e-01  2.2002759e+00  3.8259462e-02 */
    { 0x3f1f3217,0xc008e970,0x4030d14e }, /* 119:  6.2185806e-01 -2.1392479e+00  2.7627749e+00 */
    { 0x401c6f9b,0x3ff2a523,0x40ae2aa2 }, /* 120:  2.4443119e+00  1.8956646e+00  5.4427042e+00 */
    { 0x3fe34b4e,0x4044fa7c,0x40bb5ce8 }, /* 121:  1.7757356e+00  3.0777884e+00  5.8550911e+00 */
    { 0x3f2d2939,0xc02bd816,0x4036d79b }, /* 122:  6.7641026e-01 -2.6850638e+00  2.8569095e+00 */
    { 0x3f27ecfa,0xc0085376,0x401d2054 }, /* 123:  6.5595973e-01 -2.1300941e+00  2.4550982e+00 */
    { 0x1b421ec7,0x3ff3c5be,0x000008ae }, /* 124:  1.6057249e-22  1.9044721e+00  3.1136852e-42 */
    { 0x3f6973fa,0xbff15010,0x3f984c7d }, /* 125:  9.1192591e-01 -1.8852558e+00  1.1898342e+00 */
    { 0x3c8f9940,0xc03c4d94,0x480f89f9 }, /* 126:  1.7529130e-02 -2.9422350e+00  1.4698389e+05 */
    { 0x3f3e0a62,0x4021c733,0x3ef118b1 }, /* 127:  7.4234593e-01  2.5277832e+00  4.7089151e-01 */
    { 0x40076b3f,0xbf720dd0,0x3efc0f2d }, /* 128:  2.1159208e+00 -9.4552326e-01  4.9230328e-01 */
    { 0x406d9f0b,0xbfd1e066,0x3dee5865 }, /* 129:  3.7128322e+00 -1.6396606e+00  1.1637954e-01 */
    { 0x3f8bb824,0x40df0112,0x3febb202 }, /* 130:  1.0915570e+00  6.9688807e+00  1.8413699e+00 */
    { 0x3ed0ad89,0xbfd5a69b,0x408f24d3 }, /* 131:  4.0757397e-01 -1.6691469e+00  4.4732451e+00 */
    { 0x3f686269,0xc028cb31,0x3fa538d3 }, /* 132:  9.0775162e-01 -2.6374018e+00  1.2907966e+00 */
    { 0x3f96a962,0x400b9685,0x3fb6a5b8 }, /* 133:  1.1770442e+00  2.1810620e+00  1.4269323e+00 */
    { 0x402cf531,0x405b4cc3,0x41f14aa0 }, /* 134:  2.7024653e+00  3.4265602e+00  3.0161438e+01 */
    { 0xbfab83ac,0xc1500000,0xbcb67ab8 }, /* 135: -1.3399558e+00 -1.3000000e+01 -2.2275314e-02 */
    { 0xc03cd833,0x41700000,0xcb2ac29a }, /* 136: -2.9506958e+00  1.5000000e+01 -1.1190938e+07 */
    { 0x3fa6e76a,0x405a39b3,0x401e30a1 }, /* 137:  1.3039372e+00  3.4097717e+00  2.4717181e+00 */
    { 0x3f95a44f,0xc0026735,0x3f3a3623 }, /* 138:  1.1690768e+00 -2.0375493e+00  7.2738856e-01 */
    { 0x3a4904a0,0x3fd91bcb,0x36ae7566 }, /* 139:  7.6682307e-04  1.6961607e+00  5.1992711e-06 */
    { 0x3d77f95d,0x3ff34b9d,0x3b9ea582 }, /* 140:  6.0540546e-02  1.9007450e+00  4.8415074e-03 */
    { 0x4065dc2f,0xc0262213,0x3d143b12 }, /* 141:  3.5915639e+00 -2.5958297e+00  3.6189146e-02 */
    { 0x3fc44a2b,0xbfcf81cb,0x3f000037 }, /* 142:  1.5335134e+00 -1.6211485e+00  5.0000328e-01 */
    { 0x3f709de5,0x3ee9977f,0x3f78dd01 }, /* 143:  9.3990928e-01  4.5623395e-01  9.7212225e-01 */
    { 0x3f2df08a,0x410075eb,0x3d37fda7 }, /* 144:  6.7945158e-01  8.0287886e+00  4.4919636e-02 */
    { 0x40131e9c,0x3fece3ea,0x409555d3 }, /* 145:  2.2987432e+00  1.8507054e+00  4.6667266e+00 */
    { 0xbf242456,0x40800000,0x3e2d1191 }, /* 146: -6.4117944e-01  4.0000000e+00  1.6901232e-01 */
    { 0x3fcabc6d,0x3fe03aaf,0x400f3c2e }, /* 147:  1.5838753e+00  1.7517909e+00  2.2380481e+00 */
    { 0x3f9059d3,0x3faf8cfd,0x3f96f190 }, /* 148:  1.1277412e+00  1.3714901e+00  1.1792469e+00 */
    { 0x3fc4131f,0x3fd2c493,0x40012aec }, /* 149:  1.5318335e+00  1.6466240e+00  2.0182447e+00 */
    { 0xbf5bd2a4,0x40400000,0xbf221555 }, /* 150: -8.5868287e-01  3.0000000e+00 -6.3313800e-01 */
    { 0x3fda54f0,0x40906551,0x41320fb4 }, /* 151:  1.7057171e+00  4.5123677e+00  1.1128834e+01 */
    { 0x3f63a3f7,0xbf9e340c,0x3f93fd6f }, /* 152:  8.8922065e-01 -1.2359633e+00  1.1561717e+00 */
    { 0x3fcbb21f,0x3ca9fe7b,0x3f813d71 }, /* 153:  1.5913733e+00  2.0751229e-02  1.0096875e+00 */
    { 0x42554bf5,0x40412a03,0x481f2da5 }, /* 154:  5.3324177e+01  3.0181892e+00  1.6299858e+05 */
    { 0x3f2fa3be,0xc043525b,0x404a149c }, /* 155:  6.8609226e-01 -3.0519016e+00  3.1575079e+00 */
    { 0x3f641234,0x3f324d9d,0x3f6c3593 }, /* 156:  8.9090276e-01  6.9649678e-01  9.2269248e-01 */
    { 0xbf36b9d5,0x4d09d536,0x00000000 }, /* 157: -7.1377307e-01  1.4452822e+08  0.0000000e+00 */
    { 0x3ed48da6,0xc00bcc2e,0x40da5730 }, /* 158:  4.1514319e-01 -2.1843371e+00  6.8231430e+00 */
    { 0x3f7c3a43,0x3fcac148,0x3f7a0cd8 }, /* 159:  9.8526400e-01  1.5840235e+00  9.7675848e-01 */
    { 0xbf8edf9f,0xc1700000,0xbe44de00 }, /* 160: -1.1161994e+00 -1.5000000e+01 -1.9225311e-01 */
    { 0x3fe8d8bd,0xbf86a8d5,0x3f086a15 }, /* 161:  1.8191143e+00 -1.0520273e+00  5.3286868e-01 */
    { 0xbfea35c3,0x40e00000,0xc2895725 }, /* 162: -1.8297657e+00  7.0000000e+00 -6.8670204e+01 */
    { 0x3f018af7,0xbcd19f20,0x3f824028 }, /* 163:  5.0602669e-01 -2.5588572e-02  1.0175829e+00 */
    { 0x3f3cef5b,0x4005c4a7,0x3f07ac5f }, /* 164:  7.3802727e-01  2.0901277e+00  5.2997392e-01 */
    { 0x3f9a6b65,0x400bebb9,0x3fc0eb12 }, /* 165:  1.2064024e+00  2.1862624e+00  1.5071738e+00 */
    { 0x3e92e533,0xbff35c0b,0x412bd3f3 }, /* 166:  2.8690490e-01 -1.9012464e+00  1.0739245e+01 */
    { 0x3f6a017a,0xc00ba59e,0x3f9bb79a }, /* 167:  9.1408503e-01 -2.1819835e+00  1.2165406e+00 */
    { 0x400660b9,0xc04529c9,0x3dd06666 }, /* 168:  2.0996535e+00 -3.0806754e+00  1.0175781e-01 */
    { 0xbf9b969b,0x00000000,0x3f800000 }, /* 169: -1.2155336e+00  0.0000000e+00  1.0000000e+00 */
    { 0x3f923139,0xbf7d7d38,0x3f606f7e }, /* 170:  1.1421272e+00 -9.9019194e-01  8.7670124e-01 */
    { 0x3f95fc50,0x405bc301,0x3fdc978d }, /* 171:  1.1717625e+00  3.4337771e+00  1.7233750e+00 */
    { 0x3f98aae6,0x40883378,0x4007803f }, /* 172:  1.1927154e+00  4.2562828e+00  2.1172025e+00 */
    { 0x3f9b21fd,0xc0909b96,0x3ed6c3cc }, /* 173:  1.2119747e+00 -4.5189924e+00  4.1946256e-01 */
    { 0xc0741224,0x41200000,0x491edac4 }, /* 174: -3.8136072e+00  1.0000000e+01  6.5066825e+05 */
    { 0x3f707f11,0xbf87d361,0x3f88c5e0 }, /* 175:  9.3943888e-01 -1.0611383e+00  1.0685387e+00 */
    { 0x3dda6c9c,0x3fbaf784,0x3d1bca16 }, /* 176:  1.0665247e-01  1.4606786e+00  3.8034521e-02 */
    { 0x3f2f51bb,0x441b731f,0x00000000 }, /* 177:  6.8484086e-01  6.2179877e+02  0.0000000e+00 */
    { 0x3fa08a44,0xbff2ae52,0x3f269eea }, /* 178:  1.2542195e+00 -1.8959448e+00  6.5086234e-01 */
    { 0xbef112a4,0xc1600000,0x4714690c }, /* 179: -4.7084534e-01 -1.4000000e+01  3.7993047e+04 */
    { 0x3fc38450,0xc02e7334,0x3ea15c37 }, /* 180:  1.5274754e+00 -2.7257814e+00  3.1515667e-01 */
    { 0xbf5ee7a4,0xc1700000,0xc0ff3ea7 }, /* 181: -8.7072206e-01 -1.5000000e+01 -7.9763980e+00 */
    { 0x3f42f9dd,0x402bd7c1,0x3ef674d6 }, /* 182:  7.6162511e-01  2.6850436e+00  4.8136014e-01 */
    { 0x3f2f3788,0x400995e7,0x3ee29c3e }, /* 183:  6.8444109e-01  2.1497743e+00  4.4259828e-01 */
    { 0x7d430b01,0xc05be69c,0x00000000 }, /* 184:  1.6203537e+37 -3.4359503e+00  0.0000000e+00 */
    { 0xbf51dda2,0xc1000000,0x409cde76 }, /* 185: -8.1978810e-01 -8.0000000e+00  4.9021559e+00 */
    { 0xbf0d977a,0xc1600000,0x45794b05 }, /* 186: -5.5309260e-01 -1.4000000e+01  3.9886887e+03 */
    { 0xbefab240,0xc0e00000,0xc31433be }, /* 187: -4.8964119e-01 -7.0000000e+00 -1.4820212e+02 */
    { 0x3e05280a,0xbfc1f967,0x41b00f6b }, /* 188:  1.3003555e-01 -1.5154237e+00  2.2007528e+01 */
    { 0x3f4681ff,0x3ff9c34c,0x3f1bd8c4 }, /* 189:  7.7542108e-01  1.9512725e+00  6.0877633e-01 */
    { 0xbf8d1157,0x41300000,0xc03a7493 }, /* 190: -1.1020917e+00  1.1000000e+01 -2.9133651e+00 */
    { 0x3f6d8c91,0x405a722b,0x3f4650b4 }, /* 191:  9.2792612e-01  3.4132183e+00  7.7466893e-01 */
    { 0x3ffcfe87,0xbfdaae6b,0x3e9fdc18 }, /* 192:  1.9765176e+00 -1.7084478e+00  3.1222606e-01 */
    { 0x40447f34,0xc00cc16c,0x3dadbb97 }, /* 193:  3.0702639e+00 -2.1993055e+00  8.4830455e-02 */
    { 0xc02c04ec,0xbf800000,0xbebe7d87 }, /* 194: -2.6878004e+00 -1.0000000e+00 -3.7205145e-01 */
    { 0x3f6d52e2,0x41204cb2,0x3eefb2fc }, /* 195:  9.2704594e-01  1.0018724e+01  4.6816242e-01 */
    { 0x497de5fd,0x3f6ded54,0x48bef16e }, /* 196:  1.0399678e+06  9.2940259e-01  3.9105144e+05 */
    { 0x40164f6e,0x40c30613,0x4335ec96 }, /* 197:  2.3485980e+00  6.0944915e+00  1.8192416e+02 */
    { 0x3f667126,0x3fd498b8,0x3f56f79e }, /* 198:  9.0016401e-01  1.6609106e+00  8.3971584e-01 */
    { 0xbf722672,0x40a00000,0xbf41d968 }, /* 199: -9.4589913e-01  5.0000000e+00 -7.5722361e-01 */
    { 0x42eab1d2,0x3ff6730b,0x4616c89d }, /* 200:  1.1734731e+02  1.9253858e+00  9.6501533e+03 */
    { 0x3efd5f60,0xbe3517db,0x3f90f4fc }, /* 201:  4.9486828e-01 -1.7684881e-01  1.1324763e+00 */
    { 0x3ef0e1f3,0x3fbb49a5,0x3ea9dfef }, /* 202:  4.7047386e-01  1.4631850e+00  3.3178660e-01 */
    { 0x3ff0cc80,0x404ff6a8,0x40f96c79 }, /* 203:  1.8812408e+00  3.2494297e+00  7.7944913e+00 */
    { 0x3f2227b8,0xbfd92c54,0x400ae1a9 }, /* 204:  6.3341856e-01 -1.6966653e+00  2.1700232e+00 */
    { 0x3fa1f235,0xc00d4214,0x3f1851c9 }, /* 205:  1.2652041e+00 -2.2071581e+00  5.9499794e-01 */
    { 0x3f9b2831,0xbfbe1eda,0x3f405d4d }, /* 206:  1.2121640e+00 -1.4853165e+00  7.5142366e-01 */
    { 0x3f9b3cd1,0x3ff3de3a,0x3fb8dc17 }, /* 207:  1.2127935e+00  1.9052193e+00  1.4442166e+00 */
    { 0x3ee562f0,0xc01fde5d,0x40edc9aa }, /* 208:  4.4802046e-01 -2.4979470e+00  7.4308672e+00 */
    { 0x3f5efaf2,0xc024df9b,0x3fb6b034 }, /* 209:  8.7101662e-01 -2.5761478e+00  1.4272523e+00 */
    { 0x3ff38d4e,0x3f1d9bb3,0x3fbe3382 }, /* 210:  1.9027498e+00  6.1565703e-01  1.4859469e+00 */
    { 0x3d8cc168,0xc00a3dae,0x43a27874 }, /* 211:  6.8728268e-02 -2.1600146e+00  3.2494104e+02 */
    { 0x3f93649c,0xc0444e13,0x3f26148e }, /* 212:  1.1515079e+00 -3.0672653e+00  6.4875114e-01 */
    { 0x3fbcab12,0x4003d066,0x400e4c47 }, /* 213:  1.4739707e+00  2.0595946e+00  2.2234056e+00 */
    { 0x400af11a,0xc01d6f54,0x3e181c6b }, /* 214:  2.1709657e+00 -2.4599199e+00  1.4854591e-01 */
    { 0x3f9b96ad,0x402a438d,0x3fd7242c }, /* 215:  1.2155358e+00  2.6603730e+00  1.6807914e+00 */
    { 0x41ed3f98,0xc0329a3e,0x38a37a0b }, /* 216:  2.9656052e+01 -2.7906642e+00  7.7951780e-05 */
    { 0x3fd0341a,0xc1c83a3a,0x36ace5f2 }, /* 217:  1.6265900e+00 -2.5028431e+01  5.1527686e-06 */
    { 0x3ee8e67f,0xc022e470,0x40ed9b7a }, /* 218:  4.5488355e-01 -2.5451927e+00  7.4252291e+00 */
    { 0x3f9b91b8,0xc3cbbb50,0x06216950 }, /* 219:  1.2153845e+00 -4.0746338e+02  3.0358106e-35 */
    { 0x40103f2e,0xbff231c7,0x3e5c0bae }, /* 220:  2.2538562e+00 -1.8921441e+00  2.1488830e-01 */
    { 0x3f658243,0xc171689e,0x40a650ff }, /* 221:  8.9651889e-01 -1.5088041e+01  5.1973872e+00 */
    { 0x3ff8dfe5,0x40597d52,0x411943b5 }, /* 222:  1.9443327e+00  3.3982739e+00  9.5790300e+00 */
    { 0x3fe7138c,0xc1732a2d,0x3904559f }, /* 223:  1.8052840e+00 -1.5197797e+01  1.2620397e-04 */
    { 0x3e6a7d09,0x3db5a3ce,0x3f60a079 }, /* 224:  2.2899260e-01  8.8691339e-02  8.7744862e-01 */
    { 0x3f9a920d,0x3f8ff427,0x3f9e3f56 }, /* 225:  1.2075821e+00  1.1246384e+00  1.2363079e+00 */
    { 0x3be2bdaf,0xbfcc1094,0x452d84ae }, /* 226:  6.9195847e-03 -1.5942559e+00  2.7762925e+03 */
    { 0x3f30577a,0x3fd359de,0x3f0a564f }, /* 227:  6.8883479e-01  1.6511800e+00  5.4037946e-01 */
    { 0x402ab454,0xbfafdb5d,0x3e85045d }, /* 228:  2.6672564e+00 -1.3738819e+00  2.5979891e-01 */
    { 0x3f03bb39,0x3fddd27c,0x3ea1e365 }, /* 229:  5.1457554e-01  1.7329860e+00  3.1618801e-01 */
    { 0x3f9de7bf,0x3fc75b0a,0x3fb18350 }, /* 230:  1.2336348e+00  1.5574658e+00  1.3868198e+00 */
    { 0x41120bf1,0x3de4d864,0x3fa3e0f8 }, /* 231:  9.1279154e+00  1.1174086e-01  1.2803030e+00 */
    { 0x3e26d317,0x3ffa9fb4,0x3ceaa4c3 }, /* 232:  1.6291462e-01  1.9579988e+00  2.8643018e-02 */
    { 0x40280b65,0x41012e3e,0x45179ffe }, /* 233:  2.6256955e+00  8.0737896e+00  2.4259995e+03 */
    { 0xbf8b045f,0x40000000,0x3f96fb7e }, /* 234: -1.0860709e+00  2.0000000e+00  1.1795499e+00 */
    { 0x3f398c07,0xc1c69ad8,0x45389129 }, /* 235:  7.2479290e-01 -2.4825607e+01  2.9530725e+03 */
    { 0x3c6e4b4d,0xc02a33f0,0x47964791 }, /* 236:  1.4544320e-02 -2.6594200e+00  7.6943133e+04 */
    { 0x3f95db26,0xbfad5f6d,0x3f4ec778 }, /* 237:  1.1707504e+00 -1.3544747e+00  8.0773115e-01 */
    { 0x3f9a62e2,0xbff9032b,0x3f31c807 }, /* 238:  1.2061427e+00 -1.9454092e+00  6.9445843e-01 */
    { 0x4024f735,0x3fd71c82,0x409d1d79 }, /* 239:  2.5775883e+00  1.6805575e+00  4.9098477e+00 */
    { 0x3fd7863f,0x3ff0cc33,0x402a8f5e }, /* 240:  1.6837844e+00  1.8812317e+00  2.6650004e+00 */
    { 0x3ebfe59f,0xbff1848e,0x40cbdc31 }, /* 241:  3.7479874e-01 -1.8868577e+00  6.3706288e+00 */
    { 0x3f1ede71,0x4074ab5e,0x3e2543a2 }, /* 242:  6.2058169e-01  3.8229594e+00  1.6139081e-01 */
    { 0x3d73081d,0x3f1b96e6,0x3e37f882 }, /* 243:  5.9333909e-02  6.0777128e-01  1.7965892e-01 */
    { 0x3db8e47f,0x400903fc,0x3bbe5432 }, /* 244:  9.0279572e-02  2.1408682e+00  5.8083767e-03 */
    { 0x3e0ca09b,0x3fc8af00,0x3d363037 }, /* 245:  1.3733141e-01  1.5678406e+00  4.4479575e-02 */
    { 0x3f97e899,0x3fb26f68,0x3fa28336 }, /* 246:  1.1867858e+00  1.3940248e+00  1.2696292e+00 */
    { 0x3fd86f58,0xc05e9dbb,0x3e24bfa2 }, /* 247:  1.6908979e+00 -3.4783771e+00  1.6088727e-01 */
    { 0x3e7c858d,0xbf9d0691,0x40b23f5b }, /* 248:  2.4660321e-01 -1.2267629e+00  5.5702338e+00 */
    { 0x3f68a7f0,0x3ff048bb,0x3f55f006 }, /* 249:  9.0881252e-01  1.8772196e+00  8.3569372e-01 */
    { 0x3f43d198,0xc1ec1f03,0x452a3974 }, /* 250:  7.6491690e-01 -2.9515142e+01  2.7235908e+03 */
    { 0x3f44bbdf,0xc03eddaf,0x400c5b8e }, /* 251:  7.6849169e-01 -2.9822805e+00  2.1930881e+00 */
    { 0x3fa44eb0,0x3f477c5e,0x3f9b7eb8 }, /* 252:  1.2836514e+00  7.7924144e-01  1.2148046e+00 */
    { 0x3f1ccaad,0xc02b780b,0x406e0710 }, /* 253:  6.1246759e-01 -2.6792018e+00  3.7191811e+00 */
    { 0x3f1c7efb,0x406d7a59,0x3e24e563 }, /* 254:  6.1131257e-01  3.7105925e+00  1.6103129e-01 */
    { 0x4a2d5831,0x3ff0379e,0x53964ca3 }, /* 255:  2.8400762e+06  1.8766973e+00  1.2910617e+12 */
    { 0x3f9bcadb,0xc00d40bb,0x3f25eb47 }, /* 256:  1.2171282e+00 -2.2070758e+00  6.4812130e-01 */
    { 0xbf888045,0x41300000,0xc001d3d0 }, /* 257: -1.0664145e+00  1.1000000e+01 -2.0285530e+00 */
    { 0xbf596dec,0xc1100000,0xc08b2350 }, /* 258: -8.4933352e-01 -9.0000000e+00 -4.3480606e+00 */
    { 0x3f603cc4,0x3f85fecb,0x3f5ed9b0 }, /* 259:  8.7592721e-01  1.0468382e+00  8.7050915e-01 */
    { 0x3f708918,0xc00c1941,0x3f92b4aa }, /* 260:  9.3959188e-01 -2.1890414e+00  1.1461384e+00 */
    { 0x440ab448,0xc0486eda,0x312f00c8 }, /* 261:  5.5481689e+02 -3.1317658e+00  2.5466296e-09 */
    { 0x3ea4baa4,0xbfe0bd57,0x40ea5a55 }, /* 262:  3.2173645e-01 -1.7557782e+00  7.3235269e+00 */
    { 0x3f645130,0xc01031a5,0x3fa5a625 }, /* 263:  8.9186382e-01 -2.2530301e+00  1.2941328e+00 */
    { 0x3f6d7b3e,0xbf88774f,0x3f8aab16 }, /* 264:  9.2766178e-01 -1.0661410e+00  1.0833461e+00 */
    { 0x4001f41f,0x400564ac,0x408c0d42 }, /* 265:  2.0305250e+00  2.0842695e+00  4.3766184e+00 */
    { 0x3f5cd413,0x40000000,0x3f3e7d30 }, /* 266:  8.6261100e-01  2.0000000e+00  7.4409771e-01 */
    { 0x3f12f0d0,0x4034f4f5,0x3e551c9a }, /* 267:  5.7398701e-01  2.8274510e+00  2.0811692e-01 */
    { 0x409024d2,0x400d1e8f,0x41dcfd82 }, /* 268:  4.5044947e+00  2.2049901e+00  2.7623783e+01 */
    { 0x4005bfee,0x403352d6,0x40fc65a5 }, /* 269:  2.0898395e+00  2.8019309e+00  7.8874078e+00 */
    { 0x406401a2,0xbfd65821,0x3df3fbc8 }, /* 270:  3.5625997e+00 -1.6745645e+00  1.1913258e-01 */
    { 0x3f1105b8,0xbf4b42f2,0x3fc8fd01 }, /* 271:  5.6649351e-01 -7.9399025e-01  1.5702211e+00 */
    { 0x3f1547be,0xbfeed65b,0x402f15a6 }, /* 272:  5.8312595e-01 -1.8659166e+00  2.7356963e+00 */
    { 0xbf1168e7,0xc1300000,0xc3fbd067 }, /* 273: -5.6800693e-01 -1.1000000e+01 -5.0362814e+02 */
    { 0x400d77ab,0xbfa2aeb4,0x3ebad56e }, /* 274:  2.2104290e+00 -1.2709565e+00  3.6490959e-01 */
    { 0xbfb79a25,0x40000000,0x4003adbe }, /* 275: -1.4343916e+00  2.0000000e+00  2.0574794e+00 */
    { 0x3f6cb26a,0x40108435,0x3f567754 }, /* 276:  9.2459738e-01  2.2580693e+00  8.3775830e-01 */
    { 0x3f11fdd1,0xc03154c8,0x4097b2ef }, /* 277:  5.7027918e-01 -2.7707996e+00  4.7405925e+00 */
    { 0x3f98cf3c,0xbff1779f,0x3f37457b }, /* 278:  1.1938243e+00 -1.8864630e+00  7.1590394e-01 */
    { 0x3f3adf5b,0xc009381c,0x3ffb5b3f }, /* 279:  7.2997063e-01 -2.1440496e+00  1.9637221e+00 */
    { 0x4022d200,0x40296eba,0x413d8b37 }, /* 280:  2.5440674e+00  2.6473832e+00  1.1846488e+01 */
    { 0x3e214655,0xbfba6479,0x416c13b4 }, /* 281:  1.5749486e-01 -1.4561912e+00  1.4754810e+01 */
    { 0x3f68c8e2,0xc00ec3bf,0x3f9e3c70 }, /* 282:  9.0931523e-01 -2.2306974e+00  1.2362194e+00 */
    { 0x3e63037d,0x410129b4,0x36af7978 }, /* 283:  2.2169299e-01  8.0726814e+00  5.2295472e-06 */
    { 0x3fa92170,0x3f601b79,0x3fa35c3a }, /* 284:  1.3213329e+00  8.7541920e-01  1.2762520e+00 */
    { 0x3f72c3f1,0xc04fe7dc,0x3f9816e1 }, /* 285:  9.4830233e-01 -3.2485266e+00  1.1881982e+00 */
    { 0x407122fd,0x40fb51b9,0x4702aa52 }, /* 286:  3.7677605e+00  7.8537259e+00  3.3450320e+04 */
    { 0x400006a3,0x40558d9f,0x4121c37f }, /* 287:  2.0004051e+00  3.3367689e+00  1.0110229e+01 */
    { 0x4012ef0a,0x4009e8d2,0x40bfd4d4 }, /* 288:  2.2958398e+00  2.1548352e+00  5.9947300e+00 */
    { 0xbf9160b5,0x40c00000,0x40096007 }, /* 289: -1.1357638e+00  6.0000000e+00  2.1464860e+00 */
    { 0x3f89e70e,0x3c949b4e,0x3f802c53 }, /* 290:  1.0773637e+00  1.8140461e-02  1.0013527e+00 */
    { 0x40bf4fa5,0xc0511f55,0x3b3e1526 }, /* 291:  5.9784722e+00 -3.2675374e+00  2.9004305e-03 */
    { 0x405b925c,0x404dd308,0x4252d02c }, /* 292:  3.4308081e+00  3.2160053e+00  5.2703293e+01 */
    { 0x3c0df549,0x3fc05606,0x3a50cd8d }, /* 293:  8.6644376e-03  1.5026252e+00  7.9651998e-04 */
    { 0x3f213331,0x3cae3095,0x3f7d7e9d }, /* 294:  6.2968737e-01  2.1263400e-02  9.9021322e-01 */
    { 0x43e398ed,0xbff5c161,0x3704272b }, /* 295:  4.5519473e+02 -1.9199640e+00  7.8769326e-06 */
    { 0x3d839f9d,0xc01e9c3e,0x4460ee41 }, /* 296:  6.4269282e-02 -2.4782863e+00  8.9972272e+02 */
    { 0x3f0dbf1f,0x3fcd0233,0x3ec6a64d }, /* 297:  5.5369753e-01  1.6016296e+00  3.8798752e-01 */
    { 0x3f930f02,0xbfa929c3,0x3f55186a }, /* 298:  1.1488955e+00 -1.3215870e+00  8.3240378e-01 */
    { 0x3ec3b365,0x40acb971,0x3bb66171 }, /* 299:  3.8222805e-01  5.3976369e+00  5.5658151e-03 */
    { 0x3fa157cb,0xbff1b86c,0x3f2556de }, /* 300:  1.2604917e+00 -1.8884406e+00  6.4585674e-01 */
    { 0x3fe281b4,0xbfd182e5,0x3ec92a4e }, /* 301:  1.7695832e+00 -1.6368071e+00  3.9290088e-01 */
    { 0xbf8f6d26,0xc1800000,0x3e25cde7 }, /* 302: -1.1205184e+00 -1.6000000e+01  1.6191827e-01 */
    { 0x3cca158d,0xbf4a1858,0x4194b9e6 }, /* 303:  2.4668479e-02 -7.8943396e-01  1.8590771e+01 */
    { 0x3f4700d7,0xbe460315,0x3f86635b }, /* 304:  7.7735656e-01 -1.9337113e-01  1.0499071e+00 */
    { 0x3fe6822e,0x3ff36847,0x4043e26f }, /* 305:  1.8008478e+00  1.9016198e+00  3.0606954e+00 */
    { 0x3d2e0681,0x40330159,0x3918b703 }, /* 306:  4.2486671e-02  2.7969573e+00  1.4564027e-04 */
    { 0x3fe34d65,0x3fb04d68,0x400d26cd }, /* 307:  1.7757994e+00  1.3773623e+00  2.2054932e+00 */
    { 0x3f68f03a,0xc0118971,0x3f9ea696 }, /* 308:  9.0991557e-01 -2.2740138e+00  1.2394588e+00 */
    { 0x3f633e60,0x3fe1574d,0x3f4f8eb9 }, /* 309:  8.8767052e-01  1.7604767e+00  8.1077152e-01 */
    { 0x3fd0a1af,0x3f4e95f6,0x3fbddb55 }, /* 310:  1.6299342e+00  8.0697572e-01  1.4832560e+00 */
    { 0x3f9d6f0d,0x402df632,0x3fe0aabc }, /* 311:  1.2299515e+00  2.7181516e+00  1.7552104e+00 */
    { 0x4000ebce,0xbfb15784,0x3ec20958 }, /* 312:  2.0143924e+00 -1.3854833e+00  3.7897754e-01 */
    { 0x3f1ac18a,0x3f4f7416,0x3f2a4152 }, /* 313:  6.0451567e-01  8.1036508e-01  6.6505921e-01 */
    { 0x3e9b024e,0xc04bb365,0x4233562f }, /* 314:  3.0275196e-01 -3.1828244e+00  4.4834164e+01 */
    { 0x41d3ce5a,0x3fae6856,0x42adad96 }, /* 315:  2.6475758e+01  1.3625591e+00  8.6839035e+01 */
    { 0x3ffdab83,0x3fdbf33d,0x404f511c }, /* 316:  1.9817966e+00  1.7183605e+00  3.2393255e+00 */
    { 0x3f6d9a6a,0xbefab6b7,0x3f84c2bb }, /* 317:  9.2813742e-01 -4.8967525e-01  1.0371927e+00 */
    { 0x3b0860a8,0x4059f2e1,0x304a9761 }, /* 318:  2.0809565e-03  3.4054492e+00  7.3702294e-10 */
    { 0xbf70e3db,0xc0c00000,0x3fb863be }, /* 319: -9.4097680e-01 -6.0000000e+00  1.4405439e+00 */
    { 0x3fca2c39,0x3fdd2496,0x400cf9ee }, /* 320:  1.5794746e+00  1.7276790e+00  2.2027545e+00 */
    { 0x3f3e1d3a,0xbff36de5,0x3fe16885 }, /* 321:  7.4263346e-01 -1.9017912e+00  1.7610022e+00 */
    { 0x40155b1e,0x3e6ee057,0x3f9bfa9e }, /* 322:  2.3336864e+00  2.3327766e-01  1.2185857e+00 */
    { 0x40005f95,0xbbca2350,0x3f7ee734 }, /* 323:  2.0058339e+00 -6.1687604e-03  9.9571538e-01 */
    { 0xc00b2e56,0xc0400000,0xbdc7207f }, /* 324: -2.1747031e+00 -3.0000000e+00 -9.7229950e-02 */
    { 0xbf8d62c2,0x40400000,0xbfac80d3 }, /* 325: -1.1045763e+00  3.0000000e+00 -1.3476814e+00 */
    { 0x3f9d412a,0xc05f80c9,0x3ef98286 }, /* 326:  1.2285511e+00 -3.4922354e+00  4.8732394e-01 */
    { 0xc085e61b,0x41700000,0xcefb99f7 }, /* 327: -4.1843390e+00  1.5000000e+01 -2.1105857e+09 */
    { 0x3f9743ff,0x3ee5af42,0x3f89f547 }, /* 328:  1.1817626e+00  4.4860274e-01  1.0777978e+00 */
    { 0xbf48aa41,0xc1000000,0x40e08a81 }, /* 329: -7.8384787e-01 -8.0000000e+00  7.0169072e+00 */
    { 0x3e769f8a,0x41614447,0x3107a570 }, /* 330:  2.4084297e-01  1.4079169e+01  1.9739126e-09 */
    { 0xc1ff06ae,0x40c00000,0x4e7a363c }, /* 331: -3.1878262e+01  6.0000000e+00  1.0494646e+09 */
    { 0x3f366bec,0xbff29d68,0x3ff34db4 }, /* 332:  7.1258426e-01 -1.8954287e+00  1.9008088e+00 */
    { 0x3f9522bf,0x413cd8d6,0x40c25382 }, /* 333:  1.1651229e+00  1.1802938e+01  6.0726938e+00 */
    { 0x3f66dc4b,0x3ff143ee,0x3f52ae86 }, /* 334:  9.0179890e-01  1.8848855e+00  8.2297552e-01 */
    { 0x3fec655f,0x40577787,0x40fc6ccd }, /* 335:  1.8468436e+00  3.3666704e+00  7.8882813e+00 */
    { 0x3f92f34f,0xc00d2561,0x3f3cccc9 }, /* 336:  1.1480502e+00 -2.2054064e+00  7.3749977e-01 */
    { 0x3990e609,0xc03603d9,0x5044967e }, /* 337:  2.7637210e-04 -2.8439848e+00  1.3192788e+10 */
    { 0x3f105a30,0xbff7493e,0x404195ff }, /* 338:  5.6387615e-01 -1.9319227e+00  3.0247800e+00 */
    { 0x3f3e0d0e,0x4008df50,0x3f07622e }, /* 339:  7.4238670e-01  2.1386299e+00  5.2884185e-01 */
    { 0xbfa18f65,0x41400000,0x4182caba }, /* 340: -1.2621886e+00  1.2000000e+01  1.6348988e+01 */
    { 0x3fe3d6c4,0x3fd58fa2,0x40277d6e }, /* 341:  1.7799916e+00  1.6684458e+00  2.6170306e+00 */
    { 0x3ff60b5e,0xbff3476b,0x3e93ddaf }, /* 342:  1.9222219e+00 -1.9006170e+00  2.8880069e-01 */
    { 0x5d3a9471,0xbff31c43,0x06f04f27 }, /* 343:  8.4028094e+17 -1.8993000e+00  9.0394270e-35 */
    { 0x3e2c320c,0xc0502e3a,0x43a50744 }, /* 344:  1.6815966e-01 -3.2528214e+00  3.3005676e+02 */
    { 0xbfd11257,0x41000000,0x424aa5c2 }, /* 345: -1.6333722e+00  8.0000000e+00  5.0661873e+01 */
    { 0x3f09266b,0x41071b57,0x3ba88ab3 }, /* 346:  5.3574246e-01  8.4441748e+00  5.1434874e-03 */
    { 0x3f038422,0x40cd62cc,0x3c63f51b }, /* 347:  5.1373494e-01  6.4183102e+00  1.3913418e-02 */
    { 0xbf8f043f,0x40000000,0x3f9fcb7d }, /* 348: -1.1173171e+00  2.0000000e+00  1.2483975e+00 */
    { 0x3df09b66,0x3fc1e3b4,0x3d1fcee5 }, /* 349:  1.1748390e-01  1.5147614e+00  3.9015669e-02 */
    { 0x3cd93671,0xc00f9544,0x455726f1 }, /* 350:  2.6515217e-02 -2.2434855e+00  3.4424338e+03 */
    { 0xc0249705,0x41100000,0xc599c402 }, /* 351: -2.5717175e+00  9.0000000e+00 -4.9205010e+03 */
    { 0x3f994f45,0x402410bc,0x3fcb46ad }, /* 352:  1.1977316e+00  2.5635214e+00  1.5880944e+00 */
    { 0xbf8bd5a3,0x41400000,0x4038f0e1 }, /* 353: -1.0924572e+00  1.2000000e+01  2.8897021e+00 */
    { 0x3f03d4bc,0x402e3e26,0x3e281cfd }, /* 354:  5.1496482e-01  2.7225432e+00  1.6417308e-01 */
    { 0x402c7613,0x4020d0ba,0x4141251a }, /* 355:  2.6947067e+00  2.5127397e+00  1.2071558e+01 */
    { 0x3f8c8bd9,0xc03fe90e,0x3f4167cb }, /* 356:  1.0980178e+00 -2.9985995e+00  7.5549001e-01 */
    { 0xbfb112e7,0xc1300000,0xbce6ace5 }, /* 357: -1.3833894e+00 -1.1000000e+01 -2.8158614e-02 */
    { 0x3f640580,0x406860da,0x3f282a31 }, /* 358:  8.9070892e-01  3.6309114e+00  6.5689379e-01 */
    { 0x3df59cbe,0x400ab596,0x3c253f2d }, /* 359:  1.1992787e-01  2.1673331e+00  1.0085863e-02 */
    { 0x3fa20763,0xbff2eae9,0x3f23a8a5 }, /* 360:  1.2658504e+00 -1.8977939e+00  6.3929206e-01 */
    { 0xbf54a315,0x41400000,0x3ddcdc33 }, /* 361: -8.3061343e-01  1.2000000e+01  1.0784187e-01 */
    { 0x3e2dd723,0x3fd6b68f,0x3d51289f }, /* 362:  1.6976599e-01  1.6774462e+00  5.1064130e-02 */
    { 0x3f6b43ec,0xc047b47f,0x3fa69957 }, /* 363:  9.1900516e-01 -3.1203916e+00  1.3015546e+00 */
    { 0x4007afb5,0x40409fe2,0x411997fb }, /* 364:  2.1200993e+00  3.0097585e+00  9.5996046e+00 */
    { 0xbfb889a6,0x41400000,0x42a14300 }, /* 365: -1.4417007e+00  1.2000000e+01  8.0630859e+01 */
    { 0x3f4037e3,0x3fbf73ea,0x3f26c3c4 }, /* 366:  7.5085276e-01  1.4957249e+00  6.5142465e-01 */
    { 0x3f18b2b2,0xc00c8fc6,0x404715c1 }, /* 367:  5.9647667e-01 -2.1962752e+00  3.1107028e+00 */
    { 0x40fcf1de,0xc25c776d,0x00000000 }, /* 368:  7.9045248e+00 -5.5116627e+01  0.0000000e+00 */
    { 0xbf4d2bcf,0xc0000000,0x3fc746f1 }, /* 369: -8.0144972e-01 -2.0000000e+00  1.5568525e+00 */
    { 0x3f304bd5,0xc30a7929,0x64b75566 }, /* 370:  6.8865710e-01 -1.3847328e+02  2.7055262e+22 */
    { 0x3f98bb4e,0x42b2cb21,0x4adc4940 }, /* 371:  1.1932161e+00  8.9396736e+01  7.2183360e+06 */
    { 0x3fe4a1f0,0xc0580c01,0x3e107f28 }, /* 372:  1.7861919e+00 -3.3757327e+00  1.4111006e-01 */
    { 0x3fa0651f,0xbfc6a70e,0x3f345fff }, /* 373:  1.2530860e+00 -1.5519731e+00  7.0458978e-01 */
    { 0x3d78767f,0x41a5703a,0x15a7a407 }, /* 374:  6.0659882e-02  2.0679798e+01  6.7709552e-26 */
    { 0x40522c68,0xc04f6168,0x3cadd179 }, /* 375:  3.2839603e+00 -3.2403202e+00  2.1218048e-02 */
    { 0x3f8f0989,0x40273fff,0x3fab1bde }, /* 376:  1.1174785e+00  2.6132810e+00  1.3367879e+00 */
    { 0x3f918cac,0x4029a975,0x3fb3f184 }, /* 377:  1.1371055e+00  2.6509678e+00  1.4058080e+00 */
    { 0xbf8d9d42,0x40c00000,0x3feabe33 }, /* 378: -1.1063616e+00  6.0000000e+00  1.8339294e+00 */
    { 0x18354a93,0xbcdca068,0x408a88cd }, /* 379:  2.3431352e-24 -2.6931956e-02  4.3291993e+00 */
    { 0x40816fa3,0xc009484f,0x3d4c6bac }, /* 380:  4.0448775e+00 -2.1450384e+00  4.9907371e-02 */
    { 0x3ecd7481,0xc00e09c5,0x40f2cb58 }, /* 381:  4.0127948e-01 -2.2193463e+00  7.5873222e+00 */
    { 0x3f954070,0xc121375d,0x3e59d6c5 }, /* 382:  1.1660290e+00 -1.0076016e+01  2.1273334e-01 */
    { 0x40a8f73e,0xbfdc78d9,0x3d692755 }, /* 383:  5.2801809e+00 -1.7224380e+00  5.6922276e-02 */
    { 0x3ffade69,0x3ff12b62,0x406366d6 }, /* 384:  1.9599124e+00  1.8841364e+00  3.5531516e+00 */
    { 0x4102f9cb,0x400cfd71,0x42cd59da }, /* 385:  8.1859846e+00  2.2029688e+00  1.0267549e+02 */
    { 0x4008c695,0x3ff9c99c,0x408cdd2a }, /* 386:  2.1371205e+00  1.9514651e+00  4.4019976e+00 */
    { 0x414712da,0xbfcf9a5e,0x3c8945c1 }, /* 387:  1.2442102e+01 -1.6218984e+00  1.6756894e-02 */
    { 0xbf5c2645,0xc1800000,0x4132d849 }, /* 388: -8.5995895e-01 -1.6000000e+01  1.1177804e+01 */
    { 0x3f9b60ec,0xc02b9843,0x3f183e14 }, /* 389:  1.2138953e+00 -2.6811683e+00  5.9469724e-01 */
    { 0x4070366e,0xbfc2b7a0,0x3e08ecbe }, /* 390:  3.7533221e+00 -1.5212288e+00  1.3371560e-01 */
    { 0xbf449c44,0xc1500000,0xc1f75b7c }, /* 391: -7.6800942e-01 -1.3000000e+01 -3.0919670e+01 */
    { 0x4105b843,0x3fc892cc,0x41ded335 }, /* 392:  8.3574858e+00  1.5669799e+00  2.7853128e+01 */
    { 0xbf3e4bda,0x41300000,0xbd1cd6c7 }, /* 393: -7.4334490e-01  1.1000000e+01 -3.8290765e-02 */
    { 0x3f92e5af,0x3ffa6f87,0x3fa79400 }, /* 394:  1.1476344e+00  1.9565285e+00  1.3092041e+00 */
    { 0x3f6698ab,0x3feb4d73,0x3f5340e9 }, /* 395:  9.0076703e-01  1.8383011e+00  8.2520920e-01 */
    { 0x3f5f2578,0xc0f2b40c,0x403561e9 }, /* 396:  8.7166548e-01 -7.5844784e+00  2.8341010e+00 */
    { 0xbf1478d2,0xc0a00000,0xc173d5ff }, /* 397: -5.7996857e-01 -5.0000000e+00 -1.5239745e+01 */
    { 0x3f92134e,0xc05a034a,0x3f233cf6 }, /* 398:  1.1412141e+00 -3.4064507e+00  6.3764894e-01 */
    { 0x3e7478ea,0xbf6f2690,0x4073f414 }, /* 399:  2.3874250e-01 -9.3418217e-01  3.8117723e+00 */
    { 0x3f69d4a6,0xc05761d5,0x3fad9e82 }, /* 400:  9.1340101e-01 -3.3653462e+00  1.3563998e+00 */
    { 0x3eff4711,0x3fd71cbc,0x3e9ef792 }, /* 401:  4.9858907e-01  1.6805644e+00  3.1048256e-01 */
    { 0xbfae475d,0x40e00000,0xc10aca82 }, /* 402: -1.3615528e+00  7.0000000e+00 -8.6744404e+00 */
    { 0x3f6848fc,0x3fc9199b,0x3f5bbda0 }, /* 403:  9.0736365e-01  1.5710939e+00  8.5836220e-01 */
    { 0x40cb2869,0xc0233a19,0x3c12f931 }, /* 404:  6.3486829e+00 -2.5504210e+00  8.9705447e-03 */
    { 0x3ef65181,0xbff4aa8b,0x40819614 }, /* 405:  4.8109058e-01 -1.9114546e+00  4.0495701e+00 */
    { 0x3ed32d9c,0x40518c7f,0x3d617109 }, /* 406:  4.1245735e-01  3.2742002e+00  5.5039439e-02 */
    { 0x3f63992b,0xbfd15a04,0x3f9b2547 }, /* 407:  8.8905591e-01 -1.6355596e+00  1.2120751e+00 */
    { 0x3e91bc86,0xc04be9c1,0x425b26b1 }, /* 408:  2.8464144e-01 -3.1861422e+00  5.4787785e+01 */
    { 0x3f28f9aa,0x3fd80cf4,0x3efdf2bf }, /* 409:  6.6005957e-01  1.6878953e+00  4.9599263e-01 */
    { 0x400c924c,0x3f887192,0x40140f75 }, /* 410:  2.1964293e+00  1.0659659e+00  2.3134434e+00 */
    { 0x3fdc26d2,0x3f4f8004,0x3fc6a826 }, /* 411:  1.7199347e+00  8.1054711e-01  1.5520065e+00 */
    { 0x3f722be3,0x403c577a,0x3f596767 }, /* 412:  9.4598216e-01  2.9428391e+00  8.4923404e-01 */
    { 0x401c0a41,0x3fd2ced3,0x408ade99 }, /* 413:  2.4381258e+00  1.6469368e+00  4.3396726e+00 */
    { 0x3f380aac,0xc0082699,0x40012559 }, /* 414:  7.1891284e-01 -2.1273558e+00  2.0179045e+00 */
    { 0xbf8fdcdf,0x41200000,0x404ddb47 }, /* 415: -1.1239280e+00  1.0000000e+01  3.2165086e+00 */
    { 0x3f5f5be5,0xbf4e0132,0x3f8ed969 }, /* 416:  8.7249595e-01 -8.0470574e-01  1.1160098e+00 */
    { 0x3f6bf12d,0xbff69b30,0x3f95c9dd }, /* 417:  9.2164880e-01 -1.9266109e+00  1.1702229e+00 */
    { 0xbe678780,0xc0a00000,0xc4d388af }, /* 418: -2.2610283e-01 -5.0000000e+00 -1.6922714e+03 */
    { 0x3f668cd9,0xbfb9a5ab,0x3f94fe1c }, /* 419:  9.0058666e-01 -1.4503683e+00  1.1640048e+00 */
    { 0x4006c14a,0x4028ba6a,0x40e3db64 }, /* 420:  2.1055474e+00  2.6363778e+00  7.1205311e+00 */
    { 0x3fdea740,0xbff4f451,0x3eb17de7 }, /* 421:  1.7394791e+00 -1.9137059e+00  3.4666368e-01 */
    { 0x3fe294fe,0xbfa95928,0x3ef08325 }, /* 422:  1.7701719e+00 -1.3230333e+00  4.6975055e-01 */
    { 0x3f89970f,0xbed4c716,0x3f786d85 }, /* 423:  1.0749224e+00 -4.1558141e-01  9.7042114e-01 */
    { 0x3f9d0885,0x4105a3b0,0x40b07af1 }, /* 424:  1.2268225e+00  8.3524628e+00  5.5150075e+00 */
    { 0x3f9ed63f,0xbfc9a5c2,0x3f3634b6 }, /* 425:  1.2409133e+00 -1.5753710e+00  7.1174181e-01 */
    { 0x3ed61be7,0xc038759b,0x41456e23 }, /* 426:  4.1818163e-01 -2.8821781e+00  1.2339389e+01 */
    { 0x3f630155,0x4041351b,0x3f32175d }, /* 427:  8.8673908e-01  3.0188663e+00  6.9566900e-01 */
    { 0x3eaf6be0,0xbf8d6641,0x4050f5f1 }, /* 428:  3.4261990e-01 -1.1046830e+00  3.2650111e+00 */
    { 0x3f65c70a,0x400e963d,0x3f493928 }, /* 429:  8.9756835e-01  2.2279198e+00  7.8602839e-01 */
    { 0xbfe7cee2,0xc1800000,0x389ca66c }, /* 430: -1.8110011e+00 -1.6000000e+01  7.4696582e-05 */
    { 0xc0799109,0xc0800000,0x3b8db7c1 }, /* 431: -3.8994772e+00 -4.0000000e+00  4.3248837e-03 */
    { 0x3f9dbcf8,0x407981bf,0x4010813d }, /* 432:  1.2323294e+00  3.8985441e+00  2.2578881e+00 */
    { 0x3ce91caa,0xbfd10165,0x43a723ae }, /* 433:  2.8456051e-02 -1.6328551e+00  3.3427875e+02 */
    { 0x4005f838,0xbf692d82,0x3f029f24 }, /* 434:  2.0932751e+00 -9.1085064e-01  5.1024079e-01 */
    { 0xbf795c25,0xbf800000,0xbf83688f }, /* 435: -9.7406226e-01 -1.0000000e+00 -1.0266284e+00 */
    { 0xbf32c6b0,0xc0e00000,0xc14587b0 }, /* 436: -6.9834423e-01 -7.0000000e+00 -1.2345627e+01 */
    { 0x3fd91846,0x4033d729,0x408d36b1 }, /* 437:  1.6960533e+00  2.8100073e+00  4.4129262e+00 */
    { 0x3f380dd4,0xc00e7f1a,0x40056bf8 }, /* 438:  7.1896100e-01 -2.2265077e+00  2.0847149e+00 */
    { 0x405c2404,0x3ff55c49,0x412ad483 }, /* 439:  3.4396982e+00  1.9168788e+00  1.0676883e+01 */
    { 0x40186c1e,0x400d0106,0x40d8808d }, /* 440:  2.3815989e+00  2.2031875e+00  6.7656922e+00 */
    { 0x403954a0,0x4010b7ba,0x41311f65 }, /* 441:  2.8957901e+00  2.2612138e+00  1.1070165e+01 */
    { 0xbf3c3b42,0xc1100000,0xc17eb647 }, /* 442: -7.3527920e-01 -9.0000000e+00 -1.5919501e+01 */
    { 0x3fda815d,0x40566e62,0x40c000b6 }, /* 443:  1.7070729e+00  3.3504872e+00  6.0000868e+00 */
    { 0x3fa0dfd2,0xbf6f2d79,0x3f4ec50e }, /* 444:  1.2568305e+00 -9.3428761e-01  8.0769432e-01 */
    { 0xc1265d78,0x40800000,0x4636a31c }, /* 445: -1.0397820e+01  4.0000000e+00  1.1688777e+04 */
    { 0x3f645ef5,0x40505af3,0x3f30825c }, /* 446:  8.9207393e-01  3.2555511e+00  6.8948913e-01 */
    { 0x3d7c7db8,0xbfd0f72a,0x42bd0e98 }, /* 447:  6.1643332e-02 -1.6325428e+00  9.4528503e+01 */
    { 0x3d9077c7,0xc008046a,0x438c11b2 }, /* 448:  7.0540957e-02 -2.1252694e+00  2.8013824e+02 */
    { 0x412417d4,0x3f73e0bd,0x4112f776 }, /* 449:  1.0255817e+01  9.5264798e-01  9.1854153e+00 */
    { 0x6464354c,0xbfd354f0,0x0288f40b }, /* 450:  1.6838792e+22 -1.6510296e+00  2.0123478e-37 */
#if 0	/* 8kB is too small	*/
    { 0x3eb8ca23,0x3f95a778,0x3e9b86a1 }, /* 451:  3.6091718e-01  1.1691732e+00  3.0376151e-01 */
    { 0x40188091,0x40074b47,0x40c89849 }, /* 452:  2.3828471e+00  2.1139696e+00  6.2685895e+00 */
    { 0x3fc0edb8,0xbf775d9b,0x3f2c3641 }, /* 453:  1.5072546e+00 -9.6627206e-01  6.7270285e-01 */
    { 0x3eef43db,0xbfb64b6e,0x403d1c30 }, /* 454:  4.6731457e-01 -1.4241769e+00  2.9548454e+00 */
    { 0x40599c39,0xbfd70c88,0x3e03059b }, /* 455:  3.4001601e+00 -1.6800699e+00  1.2795107e-01 */
    { 0x3f8228b5,0xbfd7c3c1,0x3f78e1fe }, /* 456:  1.0168673e+00 -1.6856614e+00  9.7219837e-01 */
    { 0x3f8fa396,0x3ffb1ab5,0x3fa07acd }, /* 457:  1.1221797e+00  1.9617525e+00  1.2537476e+00 */
    { 0x404dd60a,0x3fdd618d,0x40f15553 }, /* 458:  3.2161889e+00  1.7295395e+00  7.5416656e+00 */
    { 0x40a03874,0xbfdee0ee,0x3d77e1b4 }, /* 459:  5.0068913e+00 -1.7412393e+00  6.0517982e-02 */
    { 0xbfcc4d01,0x00000000,0x3f800000 }, /* 460: -1.5961000e+00  0.0000000e+00  1.0000000e+00 */
    { 0x3e771481,0x402a3e78,0x3cba9882 }, /* 461:  2.4128915e-01  2.6600628e+00  2.2777800e-02 */
    { 0x3e86cd49,0xbff73fa6,0x4152b073 }, /* 462:  2.6328495e-01 -1.9316299e+00  1.3168078e+01 */
    { 0x3f49d267,0x44f05c52,0x00000000 }, /* 463:  7.8836673e-01  1.9228850e+03  0.0000000e+00 */
    { 0x3f776739,0x40472b48,0x3f662f00 }, /* 464:  9.6641880e-01  3.1120167e+00  8.9915466e-01 */
    { 0x3fddabb8,0xc009c44d,0x3e9cfddf }, /* 465:  1.7318029e+00 -2.1526062e+00  3.0662438e-01 */
    { 0x3f05cca7,0x4009e6fe,0x3e7d015a }, /* 466:  5.2265400e-01  2.1547236e+00  2.4707547e-01 */
    { 0xc0bb8283,0xc1700000,0xac556fd9 }, /* 467: -5.8596816e+00 -1.5000000e+01 -3.0331208e-12 */
    { 0x3f0b3dbb,0x3fd1369d,0x3ebd3b79 }, /* 468:  5.4391068e-01  1.6344792e+00  3.6959437e-01 */
    { 0xbf21cb7d,0xc1200000,0x42c4b09c }, /* 469: -6.3201123e-01 -1.0000000e+01  9.8344940e+01 */
    { 0x3f943aac,0x3ff18326,0x3fa8d403 }, /* 470:  1.1580405e+00  1.8868148e+00  1.3189701e+00 */
    { 0x3f6496d7,0x40244723,0x3f3f6c08 }, /* 471:  8.9292663e-01  2.5668418e+00  7.4774218e-01 */
    { 0x3f9b1367,0xbfefe547,0x3f32ac0b }, /* 472:  1.2115296e+00 -1.8741845e+00  6.9793767e-01 */
    { 0x3f9b509b,0x4288c275,0x4907710b }, /* 473:  1.2133974e+00  6.8379799e+01  5.5476869e+05 */
    { 0x3ff928f0,0xbf697ee8,0x3f0b71b9 }, /* 474:  1.9465618e+00 -9.1209269e-01  5.4470402e-01 */
    { 0xbfe421c3,0xc1300000,0xbae3642a }, /* 475: -1.7822803e+00 -1.1000000e+01 -1.7348577e-03 */
    { 0xbf644a55,0xc0400000,0xbfb47eee }, /* 476: -8.9175922e-01 -3.0000000e+00 -1.4101236e+00 */
    { 0x41bca9a4,0x409fcabd,0x4ada132e }, /* 477:  2.3582832e+01  4.9934983e+00  7.1458790e+06 */
    { 0x3f0d30fe,0xbfef9b96,0x4042f601 }, /* 478:  5.5152881e-01 -1.8719356e+00  3.0462649e+00 */
    { 0x3e8603de,0xbfda9928,0x411ddacc }, /* 479:  2.6174825e-01 -1.7077990e+00  9.8659172e+00 */
    { 0x3f7061d2,0xc025c978,0x3f96ab7e }, /* 480:  9.3899262e-01 -2.5904217e+00  1.1771085e+00 */
    { 0xbf715298,0x41600000,0x3ee004a5 }, /* 481: -9.4266653e-01  1.4000000e+01  4.3753543e-01 */
    { 0x3f110192,0x400d666a,0x3e91d71f }, /* 482:  5.6643021e-01  2.2093759e+00  2.8484437e-01 */
    { 0xbf42ece9,0xc1600000,0x4235a916 }, /* 483: -7.6142746e-01 -1.4000000e+01  4.5415123e+01 */
    { 0x40f55ac2,0xc04aff8a,0x3acce7e5 }, /* 484:  7.6673288e+00 -3.1718469e+00  1.5633075e-03 */
    { 0x407d40c6,0x3ff27b33,0x4158a8cb }, /* 485:  3.9570785e+00  1.8943847e+00  1.3541209e+01 */
    { 0x3fc86c96,0x3fd08fdf,0x4004e37a }, /* 486:  1.5658138e+00  1.6293906e+00  2.0763841e+00 */
    { 0x3ffe19eb,0xbfc75de5,0x3eaff803 }, /* 487:  1.9851660e+00 -1.5575529e+00  3.4368905e-01 */
    { 0x3ea4490d,0x3faaacc5,0x3e60ed1e }, /* 488:  3.2086983e-01  1.3333975e+00  2.1965453e-01 */
    { 0x4200b0a5,0x3fcf8c0a,0x438b1739 }, /* 489:  3.2172504e+01  1.6214612e+00  2.7818143e+02 */
    { 0x3f0ed916,0xbf9f8b22,0x40046ddd }, /* 490:  5.5799997e-01 -1.2464335e+00  2.0692055e+00 */
    { 0x3ff42cd6,0xbfd125d8,0x3eb23847 }, /* 491:  1.9076183e+00 -1.6339674e+00  3.4808561e-01 */
    { 0x3efc3034,0x400e3336,0x3e544fb2 }, /* 492:  4.9255526e-01  2.2218757e+00  2.0733526e-01 */
    { 0x4015c044,0xc03fdae8,0x3da02cf0 }, /* 493:  2.3398600e+00 -2.9977360e+00  7.8210711e-02 */
    { 0x3f447be0,0xbff60d6c,0x3fd4dd99 }, /* 494:  7.6751518e-01 -1.9222846e+00  1.6630126e+00 */
    { 0xbf716605,0x00000000,0x3f800000 }, /* 495: -9.4296294e-01  0.0000000e+00  1.0000000e+00 */
    { 0xbf4c2254,0x41200000,0x3dd4db1e }, /* 496: -7.9739881e-01  1.0000000e+01  1.0393356e-01 */
    { 0x40468aa3,0x402c18e5,0x41a7f594 }, /* 497:  3.1022117e+00  2.6890194e+00  2.0994911e+01 */
    { 0x3f8f8ad2,0x40337225,0x3fb0813f }, /* 498:  1.1214240e+00  2.8038418e+00  1.3789443e+00 */
    { 0x3fba6171,0xc03d3244,0x3ea8987f }, /* 499:  1.4560987e+00 -2.9561930e+00  3.2928845e-01 */
    { 0x3f68da1a,0xc007928d,0x3f9c7578 }, /* 500:  9.0957797e-01 -2.1183197e+00  1.2223349e+00 */
#endif
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, y, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	y.lo = pgm_read_dword (& t[i].y);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = pow (x.fl, y.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 260) x_exit (i+1);
    }
    return 0;
}
