//
// BAGEL - Parallel electron correlation program.
// Filename: _r2root_9.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root9(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[9] = {8.072231022867195e-01,1.523228088396698e-01,2.005142805245114e+00,3.783488407448686e+00,6.204980450274764e+00,
    9.373021010795718e+00,1.346628828726829e+01,1.883366964411048e+01,2.637417251782895e+01};
  constexpr double aw[9] = {2.056077745591990e-01,1.680638520518385e-01,9.964414277580098e-02,2.373037189135802e-02,2.799823982353893e-03,
    1.526254654547909e-04,3.296074076491241e-06,2.055392496864654e-08,1.645443281759665e-11};
  constexpr double x[4743] = {  1.519406775137123e-02,  4.186612558845981e-04,  8.582408377044060e-06,  1.547309897930941e-07,  2.578992377373183e-09,
  4.055210846674733e-11,  6.063722583365155e-13,  8.636142460753359e-15,  1.166756368117403e-16,  1.479289442188289e-18,  1.718800572104129e-20,  1.730650158736156e-22,
  1.336748761944815e-01,  3.451789821160458e-03,  6.188642643888667e-05,  8.732095059828386e-07,  9.249617178382145e-09,  4.880922613758920e-11, -7.366411342210074e-13,
 -2.807025356751849e-14, -5.100743591826481e-16, -5.811393675440386e-18, -1.818521591894739e-20,  1.028409374636615e-21,  3.549241095504103e-01,  8.028284150927954e-03,
  1.058939790902745e-04,  6.380588432540151e-07, -7.836309400326157e-09, -2.604958620213742e-10, -2.694858063442871e-12,  1.689618862211754e-14,  1.014947515005098e-15,
  1.407401834142115e-17, -2.582697138397894e-20, -4.612294975401389e-21,  6.504609031567211e-01,  1.197143545728660e-02,  8.359020198191537e-05, -7.986281993544031e-07,
 -2.165067423546783e-08, -1.554657255770928e-11,  5.143314187912673e-12,  5.202603487829647e-14, -9.465999785416132e-16, -2.440010319273444e-17,  4.771524441584785e-20,
  8.096949655240121e-21,  9.838762731581489e-01,  1.351070351157001e-02,  1.889456819613253e-06, -1.643657234699315e-06, -2.839104486387379e-10,  3.602002414136163e-10,
  3.089989369834038e-14, -9.599678489587387e-14,  3.606711563903827e-18,  2.836613619686031e-17, -5.458616126654144e-21, -8.932433222829225e-21,  1.316150156833537e+00,
  1.205568976996284e-02, -7.857544919407445e-05, -8.274769807343211e-07,  2.040612399241385e-08, -1.173298731286494e-12, -4.820495624742043e-12,  4.487317357910646e-14,
  8.838462559368109e-16, -2.124157736031205e-17, -5.223115879830823e-20,  6.945203452890639e-21,  1.610363349430784e+00,  8.339561501093226e-03, -1.024432476017497e-04,
  5.156953681153016e-07,  8.687177565545197e-09, -2.370279548125551e-10,  2.008199967221082e-12,  2.171891470726428e-14, -8.759221387375697e-16,  9.792639615369145e-18,
  6.062996043518554e-20, -3.807029614406638e-21,  1.835320572768717e+00,  3.993659521614836e-03, -6.635311072765783e-05,  8.437373470492390e-07, -7.428888875764807e-09,
  1.266963770197438e-11,  1.127711263897085e-12, -2.765608227821464e-14,  3.849820357278039e-16, -2.663967059595808e-18, -2.745521162594726e-20,  1.293082186371350e-21,
  1.968089202151202e+00,  8.270213616662869e-04, -1.582885078008191e-05,  2.635818935293541e-07, -3.998836866351028e-09,  5.606122034117040e-11, -7.250592482977764e-13,
  8.502683271442378e-15, -8.619990560259792e-17,  6.472907623742817e-19, -5.355123743652916e-22, -1.097011443635678e-22,  1.701886947196286e-02,  4.955163140770612e-04,
  1.071633362152767e-05,  2.033644009405757e-07,  3.557558426092992e-09,  5.848302467063026e-11,  9.094982120066012e-13,  1.337044411644485e-14,  1.842947490917820e-16,
  2.335698541398619e-18,  2.599050667127091e-20,  2.207544799134515e-22,  1.485422222417152e-01,  3.991377663846493e-03,  7.328119076870977e-05,  1.027749360778318e-06,
  9.974982270184031e-09,  1.965821386262392e-11, -1.782913574395170e-12, -4.776130461911295e-14, -7.166963734804421e-16, -5.087600180819115e-18,  7.070344057262561e-20,
  3.278174687410338e-21,  3.887764836721800e-01,  8.903513634562779e-03,  1.126157003909946e-04,  4.677171794732804e-07, -1.363377932882465e-08, -3.153753375682312e-10,
 -1.694953022414573e-12,  5.681736573308893e-14,  1.443915981564257e-15,  7.877166964920111e-18, -3.089685284096930e-19, -7.956309867302268e-21,  6.996151050089457e-01,
  1.259595605305535e-02,  7.194084638525040e-05, -1.140395974190792e-06, -2.063024363514504e-08,  1.211703674911134e-10,  6.050774400046403e-12,  8.783713809529546e-15,
 -1.699528406292070e-15, -1.488254369650128e-17,  4.277194148695811e-19,  7.979295055090898e-21,  1.037825008230676e+00,  1.344738966667199e-02, -1.762629316252113e-05,
 -1.591429204007409e-06,  6.713795300389430e-09,  3.296233629528831e-10, -2.506521578134556e-12, -8.032877145568918e-14,  9.304480103017002e-16,  2.085477972605982e-17,
 -3.445072594578362e-19, -5.480610375800430e-21,  1.363060605458684e+00,  1.139287744725098e-02, -8.656603537534539e-05, -5.069770384618167e-07,  1.934102268928482e-08,
 -9.929900692468794e-11, -3.282723717429923e-12,  6.106004074781587e-14,  1.465117114017917e-16, -1.820720119209229e-17,  1.755863324042940e-19,  3.124982198777637e-21,
  1.642124579618753e+00,  7.546789351147482e-03, -9.556845285172537e-05,  6.195384863529414e-07,  4.462895216953463e-09, -1.843657501562521e-10,  2.278571824215748e-12,
 -4.852918139373105e-16, -5.133820521894184e-16,  9.601094083740496e-18, -5.282891510218124e-20, -1.442516987063816e-21,  1.850294868375926e+00,  3.501340972963187e-03,
 -5.692897217035285e-05,  7.281333722825482e-07, -6.960770650858155e-09,  3.174057263957481e-11,  5.104365328855538e-13, -1.699033765415675e-14,  2.802506613993412e-16,
 -2.920027606930740e-18,  8.423534525844959e-21,  4.347731718057765e-22,  1.971162627728793e+00,  7.120342530845978e-04, -1.301561037369103e-05,  2.077004321030185e-07,
 -3.033863300149066e-09,  4.122619166572916e-11, -5.221720185994384e-13,  6.105680653820823e-15, -6.413126744730335e-17,  5.624476217665791e-19, -3.065499836885114e-21,
 -2.035189942777580e-23,  1.918934560201434e-02,  5.920734139732108e-04,  1.354105153319073e-05,  2.709689506568694e-07,  4.979624100936649e-09,  8.555520032033875e-11,
  1.380616076894934e-12,  2.083282937822998e-14,  2.894116444306691e-16,  3.564583308357030e-18,  3.497036973746474e-20,  1.490258060218361e-22,  1.657621886762010e-01,
  4.629684676600369e-03,  8.657586595703402e-05,  1.187666245751662e-06,  9.817909595111250e-09, -4.191273602214979e-11, -3.463028485216347e-12, -7.273845906660935e-14,
 -8.049807456187951e-16,  1.657231400189203e-18,  2.946278623907687e-19,  7.108041631915743e-21,  4.262220541887708e-01,  9.822690619819750e-03,  1.167058659609933e-04,
  1.975436554179222e-07, -2.019148360581884e-08, -3.315829710794786e-10,  5.643718575747213e-13,  1.044730197520189e-13,  1.418661944033346e-15, -1.160293789514076e-17,
 -6.544671358768500e-19, -6.401702082041503e-21,  7.510556980056895e-01,  1.311136778019238e-02,  5.638107328066544e-05, -1.443234404191350e-06, -1.676811054132192e-08,
  2.628331323306488e-10,  5.481852809119982e-12, -5.027959890263666e-14, -1.857776502930124e-15,  7.491770603034861e-18,  6.349414439164959e-19,  3.740793691126799e-22,
  1.091214805196090e+00,  1.323229314114117e-02, -3.587388183145301e-05, -1.435233572016985e-06,  1.254246589834891e-08,  2.464299288612928e-10, -4.247151618511394e-12,
 -4.155828125009803e-14,  1.392690401261629e-15,  4.205066999547853e-18, -4.382280752563958e-19,  1.246450052138985e-21,  1.407215724886213e+00,  1.068109917812686e-02,
 -9.087082987304320e-05, -2.171056020212210e-07,  1.670603494969267e-08, -1.575903039168046e-10, -1.595082857715804e-12,  5.681230723669143e-14, -3.604219271872409e-16,
 -9.625951878293633e-18,  2.267141921481986e-19, -5.184992230363208e-22,  1.670831095129063e+00,  6.812932406432072e-03, -8.781769420718446e-05,  6.643834554663687e-07,
  1.313036726022067e-09, -1.313971595850418e-10,  2.083480826498226e-12, -1.188354093224070e-14, -2.163392161281879e-16,  6.723338230052898e-18, -8.051480730998176e-20,
  7.295511226947741e-24,  1.863442102072939e+00,  3.079018104723311e-03, -4.883690154359277e-05,  6.223604117988904e-07, -6.237152415857330e-09,  3.920163285345020e-11,
  1.450920467812733e-13, -9.610703035808292e-15,  1.844849724407981e-16, -2.339874170704135e-18,  1.781780283343899e-20,  5.142031682455899e-23,  1.973817212581793e+00,
  6.171122924287970e-04, -1.078930315021700e-05,  1.651280826580771e-07, -2.321935339674815e-09,  3.053150707408146e-11, -3.770749941410826e-13,  4.352764566027634e-15,
 -4.619832512798147e-17,  4.331819287532228e-19, -3.187791007156544e-21,  9.054192773279956e-24,  2.179698938293635e-02,  7.149056007959848e-04,  1.733361174594284e-05,
  3.663508633705531e-07,  7.075272414303258e-09,  1.268647761890017e-10,  2.114856171274318e-12,  3.242444515019148e-14,  4.435954964714296e-16,  4.985766617237319e-18,
  3.202855049931965e-20, -4.245259066919498e-22,  1.857600485605663e-01,  5.381873363980634e-03,  1.017260752454815e-04,  1.332787766913484e-06,  7.969096607778698e-09,
 -1.522233946864780e-10, -5.831246755943285e-12, -9.458399987215696e-14, -4.468499192780482e-16,  2.087327773041947e-17,  6.908070454711958e-19,  1.036133754640027e-20,
  4.673867182821838e-01,  1.075983362444563e-02,  1.169244717294350e-04, -1.767573493692672e-07, -2.642656948121059e-08, -2.783829651586163e-10,  4.023850704046947e-12,
  1.377264732979882e-13,  4.845593538045343e-16, -4.076172078464376e-17, -7.177300272685415e-19,  5.318737027617672e-21,  8.042877232871487e-01,  1.348902328663597e-02,
  3.764755862528701e-05, -1.662917161127564e-06, -1.034286707268518e-08,  3.712077825285982e-10,  3.316512935751039e-12, -1.006635766991417e-13, -1.154941726050128e-15,
  3.015941569805844e-17,  4.259619477873701e-19, -9.399427112055924e-21,  1.143466180772836e+00,  1.288015942382463e-02, -5.174876551673271e-05, -1.200968009090201e-06,
  1.638368767742872e-08,  1.355941485078456e-10, -4.787100009119327e-12,  2.254193369032259e-15,  1.256666427353024e-15, -1.064815127913641e-17, -2.729280525428582e-19,
  5.540328073709421e-21,  1.448475773724888e+00,  9.948005038488413e-03, -9.198165135110868e-05,  2.341042588850419e-08,  1.329238708288015e-08, -1.783461254602576e-10,
 -2.058808719549228e-13,  4.140050778608489e-14, -5.550098011379036e-16, -1.616194649788375e-18,  1.630445949786207e-19, -2.000716951633480e-21,  1.696728497169214e+00,
  6.142455722657729e-03, -7.979729989950627e-05,  6.669607989418377e-07, -8.449969533944331e-10, -8.596707067634187e-11,  1.685849595865668e-12, -1.554094753776884e-14,
 -3.016636077684208e-17,  3.720777114946736e-18, -6.570445858443811e-20,  5.517939927165773e-22,  1.875021768000677e+00,  2.716560093575723e-03, -4.194108046627255e-05,
  5.289469943396409e-07, -5.436959292095511e-09,  4.004887575757061e-11, -5.303153975243317e-14, -4.916167096870076e-15,  1.131550213258194e-16, -1.630508784652301e-18,
  1.679566889833951e-20, -6.810961199105217e-23,  1.976124748410248e+00,  5.381358562313743e-04, -9.012007546315628e-06,  1.324090614808371e-07, -1.792736465068768e-09,
  2.279073582281789e-11, -2.737199372336658e-13,  3.100311073599124e-15, -3.277204660840371e-17,  3.168563298621908e-19, -2.569661503573198e-21,  1.737023024958093e-23,
  2.496478796793591e-02,  8.732962191622421e-04,  2.250262985004599e-05,  5.029510986613963e-07,  1.020269378317150e-08,  1.902933283149040e-10,  3.249887871048576e-12,
  4.967732233056869e-14,  6.377122685136382e-16,  5.431185208595086e-18, -2.535540776523052e-20, -2.607317096483983e-21,  2.090191383891177e-01,  6.261538039798556e-03,
  1.183569563108754e-04,  1.427415052098363e-06,  3.305973825026062e-09, -3.246624316959680e-10, -8.523691743879631e-12, -9.065155744838662e-14,  9.083505885531431e-16,
  5.705486095094439e-17,  1.078834258828105e-18,  4.689753596274097e-21,  5.122727560417887e-01,  1.167917453812869e-02,  1.121033136983688e-04, -6.375531365655278e-07,
 -3.071350768432358e-08, -1.353192531947038e-10,  7.841340536308612e-12,  1.249811611342446e-13, -1.395758104952659e-15, -5.955390050071884e-17, -9.177107381196913e-20,
  2.283198629386803e-20,  8.587165971922577e-01,  1.370815779018207e-02,  1.695587424918292e-05, -1.765704679632595e-06, -2.368021985625935e-09,  4.139036133232606e-10,
  1.619788660618948e-13, -1.178729800624283e-13,  1.230532144088127e-16,  3.744941320246606e-17, -7.925965296488246e-20, -1.180578889405246e-20,  1.194074077134238e+00,
  1.241314516591260e-02, -6.451803195061696e-05, -9.232782863870265e-07,  1.797352567614879e-08,  2.558796918917659e-11, -4.230775467117155e-12,  3.472441892520071e-14,
  7.383119299906036e-16, -1.645038875316711e-17, -1.880333582053738e-20,  5.353209766285738e-21,  1.486802613533444e+00,  9.216620036050106e-03, -9.054224584875657e-05,
  2.076425156993831e-07,  9.759499334780877e-09, -1.713966903411148e-10,  7.039058318069656e-13,  2.379370899025329e-14, -5.172102844275012e-16,  3.143328352662949e-18,
  7.722823677855264e-20, -1.708291742291350e-21,  1.720071772617476e+00,  5.535744477701378e-03, -7.192491311484139e-05,  6.417359686600731e-07, -2.195081953536569e-09,
 -5.073065229777174e-11,  1.253999329337203e-12, -1.481988273490270e-14,  6.274778292968250e-17,  1.619691433947623e-18, -3.890984370404070e-20,  6.157946489531180e-22,
  1.885255142708318e+00,  2.405002272917082e-03, -3.608956795813625e-05,  4.482542218686759e-07, -4.657958338367706e-09,  3.748370022351172e-11, -1.479267027895156e-13,
 -2.110973378132903e-15,  6.577439124079495e-17, -1.023304727204117e-18,  1.357910852313758e-20, -6.794792122470537e-23,  1.978142517312684e+00,  4.719402677791195e-04,
 -7.581240022538168e-06,  1.070423762356503e-07, -1.396153205980344e-09,  1.715452705048870e-11, -2.000107268384283e-13,  2.215837043375820e-15, -2.302158380669738e-17,
  2.303583561853512e-19, -1.737188174139841e-21,  1.979492615426310e-23,  2.886057614299071e-02,  1.080553346449695e-03,  2.965821964854736e-05,  7.013955923952949e-07,
  1.491383836885632e-08,  2.874548818816392e-10,  4.952863808575396e-12,  7.271252306691874e-14,  7.747348011004606e-16,  6.587855327574574e-19, -2.603166687590509e-19,
 -9.158199409115210e-21,  2.360680084693921e-01,  7.277239187076541e-03,  1.355508723957836e-04,  1.416473110259125e-06, -5.412430217036457e-09, -5.542057233690384e-10,
 -1.028612824569175e-11, -2.033084188462565e-14,  3.734418128351072e-15,  9.796132395183970e-17,  7.571326316507226e-19, -2.414106706553811e-20,  5.607226783522715e-01,
  1.253691062015920e-02,  1.014509677703794e-04, -1.139321419594149e-06, -3.128892775589351e-08,  8.786583583551513e-11,  1.040057132081035e-11,  4.747276457679828e-14,
 -3.334701497397774e-15, -4.027610486661415e-17,  1.082525263650255e-18,  2.617895838316679e-20,  9.136862439656214e-01,  1.375903187897394e-02, -4.189064252585308e-06,
 -1.738255829967399e-06,  5.689018394152309e-09,  3.798308317069867e-10, -2.890523024329062e-12, -9.391090903635327e-14,  1.302038957669178e-15,  2.543251552312229e-17,
 -4.708616952961299e-19, -5.012320178035217e-21,  1.242631110303087e+00,  1.185757721414827e-02, -7.387189201553294e-05, -6.367530969658034e-07,  1.756014510540386e-08,
 -6.215524454764335e-11, -3.015327875136584e-12,  4.914825655067544e-14,  1.827235914596256e-16, -1.324417320037108e-17,  1.572428335279596e-19,  2.382020849810116e-21,
  1.522239611470793e+00,  8.504649927500689e-03, -8.722323102580445e-05,  3.374833174611771e-07,  6.545311779484774e-09, -1.482560057178396e-10,  1.158898500991728e-12,
  9.516617896110463e-15, -3.644457258794185e-16,  4.960682642280193e-18,  1.911924019754479e-20, -9.762498700675058e-22,  1.741111791827191e+00,  4.990484268513153e-03,
 -6.446336905145804e-05,  5.999965597281492e-07, -2.940980376972811e-09, -2.534283714713650e-11,  8.740752835042006e-13, -1.212841478134356e-14,  9.924422368120352e-17,
  5.657428149359533e-19, -1.522128959309915e-20,  4.172710747708505e-22,  1.894330070813562e+00,  2.136590605423835e-03, -3.113361238548504e-05,  3.795151663860938e-07,
 -3.947476482358746e-09,  3.343158264965208e-11, -1.823900171974552e-13, -4.963175966694139e-16,  3.803678861715180e-17, -5.356129030905008e-19,  1.081981618247078e-20,
 -6.799444629863299e-23,  1.979916610005200e+00,  4.160731073503492e-04, -6.420230834659902e-06,  8.720752611376478e-08, -1.096439043377818e-09,  1.302276971359107e-11,
 -1.471201383306453e-13,  1.600094343592494e-15, -1.577526288845252e-17,  1.774838730527568e-19, -9.511358664694121e-22,  1.341392499769128e-23,  3.371698737058886e-02,
  1.356025187898580e-03,  3.971934793845815e-05,  9.932103416268154e-07,  2.203077091034926e-08,  4.334831579509872e-10,  7.319527116537029e-12,  9.486934342706067e-14,
  4.799732554175389e-16, -2.172035290323689e-17, -9.792701489692228e-19, -2.586856003606608e-20,  2.674501325347066e-01,  8.427235333497176e-03,  1.516198822917808e-04,
  1.227880871267252e-06, -1.892715820266558e-08, -7.909994953375970e-10, -8.626667681803916e-12,  1.585218100691534e-13,  7.420565352194948e-15,  9.253760126484126e-17,
 -1.409593181400325e-18, -7.555791470727645e-20,  6.123952216485929e-01,  1.328554332869786e-02,  8.487797900873733e-05, -1.612102202400582e-06, -2.699455695688230e-08,
  3.403816646543803e-10,  1.008907021870160e-11, -7.213419028759649e-14, -3.777200512937931e-15,  2.015410838727519e-17,  1.735770058930589e-18, -1.411747185026274e-21,
  9.685261489634488e-01,  1.364417929144885e-02, -2.426572762456738e-05, -1.591027678631185e-06,  1.240634248870021e-08,  2.843205345958123e-10, -4.826746350972476e-12,
 -4.151302221024504e-14,  1.847962306986659e-15,  4.605985289083879e-18, -5.186901183482049e-19,  1.955321226670072e-21,  1.288837664877569e+00,  1.124069662002139e-02,
 -7.987961878629834e-05, -3.691930069841180e-07,  1.570654591532084e-08, -1.177418564757947e-10, -1.619474129507577e-12,  4.871996270836235e-14, -1.656271350071788e-16,
 -5.965647018790639e-18,  1.787350258206750e-19, -1.436323043413756e-21,  1.554890517321523e+00,  7.824628433354262e-03, -8.263783990396352e-05,  4.200675869059251e-07,
  3.873813344228466e-09, -1.183943631391823e-10,  1.289536188912142e-12,  7.812611661891181e-16, -1.816219111326671e-16,  4.942756405877848e-18, -1.995847980164949e-20,
 -9.695194787963596e-22,  1.760086743272695e+00,  4.502745542073066e-03, -5.755907811671420e-05,  5.499170138307709e-07, -3.263644561091870e-09, -8.065929463158705e-12,
  5.813391885428399e-13, -8.715355125730399e-15,  1.119793137638682e-16,  1.988688042618348e-19, -6.814471696941506e-21, -8.789457202316460e-23,  1.902405687791720e+00,
  1.904713977406418e-03, -2.693710109657239e-05,  3.214643087636428e-07, -3.323098501452435e-09,  2.901000587845054e-11, -1.815889051477758e-13,  4.888802940113687e-16,
  2.563863820720016e-17, -1.849502544309442e-19,  5.915418004970893e-21, -1.772340635517040e-22,  1.981484410095753e+00,  3.686176104289436e-04, -5.470985765626758e-06,
  7.157057975407477e-08, -8.679341049572323e-10,  9.978138558838403e-12, -1.084715840886160e-13,  1.190983657572042e-15, -9.982918137324549e-18,  1.449076532965586e-19,
 -8.785377126934900e-22, -1.407015256194613e-23,  3.986149387501110e-02,  1.728171911989246e-03,  5.407235904108418e-05,  1.425526624513723e-06,  3.267700037115207e-08,
  6.417066797253517e-10,  1.000415814255834e-11,  8.743635447066483e-14, -1.358360408310920e-15, -9.240898524278014e-17, -2.809399604733898e-18, -6.076073527240554e-20,
  3.036693772862918e-01,  9.692718656832576e-03,  1.639843081726906e-04,  7.892633558403353e-07, -3.630826029875888e-08, -9.154293812586997e-10, -4.817408987829404e-13,
  4.311748892764771e-13,  8.831550886904726e-15, -4.076239915692917e-17, -5.368450148040992e-18, -8.899829139288315e-20,  6.667633414523975e-01,  1.388044222689635e-02,
  6.320610337225863e-05, -1.977317171427507e-06, -1.799519500035779e-08,  5.457568148209662e-10,  6.577416667234021e-12, -1.688539314509589e-13, -1.928952555708408e-15,
  7.606552908779593e-17,  7.664547112664054e-19, -4.080592175997034e-20,  1.022598976878255e+00,  1.337744847086949e-02, -4.200057642554790e-05, -1.353603378128185e-06,
  1.687486188310974e-08,  1.612275056827440e-10, -5.163665485477634e-12,  1.647742978144102e-14,  1.666261331234864e-15, -1.395957376224710e-17, -4.115747906873206e-19,
  1.785172666516857e-21,  1.332500099611331e+00,  1.058802014958159e-02, -8.288542001026062e-05, -1.383878139552751e-07,  1.306976082862419e-08, -1.409916100312159e-10,
 -3.529998805849335e-13,  4.117534657582947e-14, -2.766544276839464e-16, -1.129691078738672e-18,  3.974184180074421e-20, -4.590930819859856e-21,  1.584900014793255e+00,
  7.184573597082664e-03, -7.729783972726701e-05,  4.647847134018791e-07,  1.814462936990854e-09, -8.768308930020100e-11,  1.255160711195486e-12, -2.432030384674410e-15,
 -3.003166168442531e-17,  3.098971456079844e-18, -7.751950292181546e-20, -1.665752026034186e-21,  1.777217310217813e+00,  4.067773505270505e-03, -5.127646079005912e-05,
  4.970905965130050e-07, -3.303095515714504e-09,  3.367098489612812e-12,  3.880754142285591e-13, -5.089447583282459e-15,  1.115030279471436e-16, -3.481109140063921e-19,
 -2.527711367462673e-20, -7.253382242413305e-22,  1.909616761535537e+00,  1.703786159096671e-03, -2.338015068920231e-05,  2.727057976912316e-07, -2.784913355870013e-09,
  2.490388863406102e-11, -1.571937399467962e-13,  1.229954288094886e-15,  2.086429293568000e-17, -1.589543123291324e-19, -5.957797212151907e-21, -3.563069117375035e-22,
  1.982876469746901e+00,  3.280633357142177e-04, -4.689303549402817e-06,  5.914943704017777e-08, -6.918704868848583e-10,  7.743427501442865e-12, -7.887100074631671e-14,
  9.462932440938128e-16, -5.656346010065681e-18,  8.547461593265198e-20, -2.382505759364438e-21, -5.284658463274170e-23,  4.776162442546693e-02,  2.239127966172523e-03,
  7.478341280871407e-05,  2.064773040547227e-06,  4.806872326131534e-08,  9.022793287767728e-10,  1.115475853928717e-11, -3.699971215938720e-14, -7.477532990259350e-15,
 -2.720040028914002e-16, -6.498351956026493e-18, -1.042381662119976e-19,  3.451082303238430e-01,  1.103122898626203e-02,  1.693761861449026e-04,  6.588035312345504e-08,
 -5.360121654075779e-08, -7.531870165851515e-10,  1.499327321820546e-11,  6.424942203255795e-13,  2.766392585689609e-15, -3.081202794252684e-16, -7.047296603874329e-18,
  4.132839344844016e-20,  7.231403754442339e-01,  1.428716203740349e-02,  3.813412029413837e-05, -2.171041489167281e-06, -5.909282687328788e-09,  6.425521131856832e-10,
  1.416908304074653e-12, -1.847375740828128e-13,  8.755466653468241e-16,  6.572410286183425e-17, -1.313757167287835e-18, -4.462503109311040e-20,  1.075340637067829e+00,
  1.298126337401270e-02, -5.653855701457954e-05, -1.064284379944713e-06,  1.892626736621004e-08,  4.828601999513203e-11, -4.053386238450890e-12,  5.868061180003437e-14,
  8.784227465682529e-16, -2.968724547131924e-17, -3.900950449053975e-19, -1.156750068949103e-22,  1.373520230773445e+00,  9.921633722959898e-03, -8.338489553127075e-05,
  4.808292669410271e-08,  1.025327175484242e-08, -1.366659438621237e-10,  6.696319469330934e-13,  3.156028383790126e-14, -3.405303879717862e-16, -3.858754727429438e-18,
 -1.743388713644840e-19, -4.288891829188721e-21,  1.612437401671029e+00,  6.588871315833167e-03, -7.159886932756523e-05,  4.813995300292471e-07,  3.563103210143167e-10,
 -5.840698382096200e-11,  1.185250821112244e-12, -2.356057125027771e-15,  7.248950190555079e-18, -1.530918648960839e-18, -1.521007349751556e-19, -1.375984072199911e-21,
  1.792704501992991e+00,  3.680531919519357e-03, -4.562472469689703e-05,  4.452444268772327e-07, -3.152154434728952e-09,  1.135382537512079e-11,  2.918562387267237e-13,
 -1.985427700291097e-15,  7.224756014111610e-17, -2.074677589744597e-18, -6.104312023438861e-20, -7.100354904700780e-22,  1.916077528301701e+00,  1.529113920948068e-03,
 -2.035922514998710e-05,  2.319398019643986e-07, -2.321413596421198e-09,  2.161222732712924e-11, -1.147812561516445e-13,  1.727962623764111e-15,  6.884967695597775e-18,
 -7.264675162994832e-19, -2.211371913449967e-20, -3.090988119453002e-22,  1.984117938640910e+00,  2.932110366743750e-04, -4.041128566810230e-06,  4.922427961187632e-08,
 -5.538812034927506e-10,  6.150090587387840e-12, -5.460553064848199e-14,  7.912375621256074e-16, -4.902097648231376e-18, -6.053677542782789e-20, -4.892496722333476e-21,
 -4.834832038809765e-23,  5.809197422650783e-02,  2.951040848790564e-03,  1.048154835078377e-04,  2.991809147194429e-06,  6.852214398640410e-08,  1.119456432129838e-09,
  4.886589538685831e-12, -4.921369084390350e-13, -2.304519668002301e-14, -6.198727290284756e-16, -1.038810411953079e-17, -2.683189650992666e-20,  3.919262772073266e-01,
  1.237383396635982e-02,  1.646040847346179e-04, -8.865504663165100e-07, -6.360777732682108e-08, -1.795005080493090e-10,  3.220711765133851e-11,  5.066752536333664e-13,
 -1.235339325820050e-14, -4.866302247956407e-16, -2.399630283089208e-19,  2.596639819318652e-19,  7.807331937245445e-01,  1.448739795101734e-02,  1.193978503922200e-05,
 -2.162612014631993e-06,  6.886875676738782e-09,  6.193911944155692e-10, -3.099469330227385e-12, -1.322402538689182e-13,  1.918655480050236e-15, -1.488232803686282e-17,
 -2.361694149146064e-18,  3.241174298247732e-21,  1.126287512835650e+00,  1.248305922523330e-02, -6.747666639715830e-05, -7.584218690900588e-07,  1.906409754613388e-08,
 -2.719678144407401e-11, -2.198754699243568e-12,  6.672094888513697e-14, -4.636006906829030e-16, -4.427626449056382e-17, -2.930010757280745e-19,  6.204043776140203e-21,
  1.411879933866492e+00,  9.259450764341440e-03, -8.191019436702724e-05,  1.914180437796459e-07,  7.745133739230409e-09, -1.114062115619575e-10,  1.368494902425648e-12,
  1.679905621503157e-14, -6.387898253830897e-16, -1.324405516763669e-17, -2.511211406900428e-19,  1.672207302926153e-21,  1.637683923676310e+00,  6.039205604863618e-03,
 -6.582147372874715e-05,  4.792779031721375e-07, -5.329538917490881e-10, -3.082160616638827e-11,  1.105354372063607e-12, -4.263176084062581e-15, -1.663486964201344e-16,
 -8.168709113085817e-18, -1.585685378649208e-19,  1.516542005794669e-21,  1.806729287996908e+00,  3.336068120490827e-03, -4.057571468714455e-05,  3.969918879745471e-07,
 -2.858543501571711e-09,  1.786542635134291e-11,  2.537660820172299e-13, -1.384699589411687e-15, -5.133783366986998e-17, -4.837190802899496e-18, -6.703853451409285e-20,
  6.584569769862797e-22,  1.921885014571442e+00,  1.376773766120474e-03, -1.778497877653278e-05,  1.981219902810892e-07, -1.912795428517934e-09,  1.943215755515671e-11,
 -6.858501094001360e-14,  1.339166986468905e-15, -3.741076739620653e-17, -1.759464078468092e-18, -2.554690158453133e-20,  2.348246049491991e-22,  1.985229664871341e+00,
  2.631030393630973e-04, -3.499761671363480e-06,  4.128216317649679e-08, -4.422955397114322e-10,  5.084240858201662e-12, -3.526250099879173e-14,  5.587323195114212e-16,
 -1.093158279613044e-17, -2.770590628747394e-19, -5.223197404336767e-21,  4.850104156221986e-23,  7.182913412113957e-02,  3.953522199022340e-03,  1.480377581265925e-04,
  4.267172297254291e-06,  9.043942611436757e-08,  9.646181767258548e-10, -2.312520379631115e-11, -1.662270873233855e-12, -5.200689661962314e-14, -9.231215525387842e-16,
  3.846666776974976e-19,  6.994248784174199e-19,  4.439634836883147e-01,  1.363083089810318e-02,  1.478875050767677e-04, -1.887180331431116e-06, -5.861683966848400e-08,
  7.033795453862641e-10,  3.835149455427177e-11, -1.467044979876436e-13, -2.705964409414730e-14, -2.478249293022076e-16,  1.194477900813059e-17,  2.251315658623767e-19,
  8.387133092534842e-01,  1.448189351629221e-02, -1.295787880673633e-05, -1.958507779348380e-06,  1.826236785387288e-08,  5.063891100119858e-10, -6.146234869191484e-12,
 -9.629097585306769e-14, -1.203340877941927e-16, -8.884612762165579e-17, -9.352618313052006e-19,  5.754682523630745e-20,  1.175089729278508e+00,  1.191197007528127e-02,
 -7.477319245806715e-05, -4.600294717189882e-07,  1.812862945183501e-08, -6.076166085508743e-11, -7.898935058314689e-13,  2.486465142292208e-14, -2.170454530368914e-15,
 -4.694710562769400e-17,  2.531668263660207e-19,  1.895548669067581e-20,  1.447624487805330e+00,  8.615306811965602e-03, -7.893706924212971e-05,  2.994118012845620e-07,
  5.869508536900866e-09, -7.573121904893044e-11,  1.468771611572674e-12, -1.291317586084254e-14, -1.255357494278911e-15, -1.924197342624090e-17,  1.673549560985188e-20,
  1.062504261138661e-20,  1.660823772698794e+00,  5.535456447881051e-03, -6.013712104950015e-05,  4.672052838042937e-07, -8.981765950592935e-10, -6.637918955125390e-12,
  8.596505203458047e-13, -1.530947079578900e-14, -5.469181106003720e-16, -1.189106528106064e-17,  5.740868344544961e-21,  6.074530854034230e-21,  1.819453461152275e+00,
  3.029769708449828e-03, -3.607341801173236e-05,  3.544258222252130e-07, -2.445174724698809e-09,  2.312758475714623e-11,  1.626347372426024e-13, -6.237748064769866e-15,
 -2.611096178623854e-16, -6.311037197483332e-18,  9.781953510544461e-21,  2.910676581279783e-21,  1.927121911005566e+00,  1.243512517519843e-03, -1.557858052268723e-05,
  1.705464757909003e-07, -1.538546247748099e-09,  1.803598441310482e-11, -5.858960787096294e-14, -1.034110259022666e-15, -1.144570821050485e-16, -2.330369551715024e-18,
  3.400420566927223e-21,  1.112289063826802e-21,  1.986229058285700e+00,  2.369736378090056e-04, -3.043616897159106e-06,  3.497740769455428e-08, -3.480546957327063e-10,
  4.375639271311950e-12, -2.626543147323016e-14,  1.578001837196555e-17, -2.375412658167949e-17, -3.990308468758997e-19,  2.892248973741823e-22,  2.082460184209426e-22,
  9.037243349657631e-02,  5.368424731850511e-03,  2.084127663867316e-04,  5.818801597270218e-06,  9.931620026647899e-08, -3.655521339483631e-10, -9.745207896782960e-11,
 -3.765519272496332e-12, -7.291117734582330e-14,  2.404561827295372e-16,  7.385199993486195e-17,  2.876380391731540e-18,  5.006888743852035e-01,  1.470878221091594e-02,
  1.202321388808325e-04, -2.665725732710707e-06, -3.620500982982898e-08,  1.472113075718541e-09,  2.152389813214072e-11, -1.049061475010670e-12, -2.581541314503833e-14,
  3.355158474819311e-16,  1.473363386938594e-17, -1.021630805750750e-19,  8.962926668808224e-01,  1.428990239769980e-02, -3.440113903576149e-05, -1.594266181644823e-06,
  2.668136309579558e-08,  3.230106906538718e-10, -9.397029741270274e-12, -1.530075947201204e-13, -3.296403100396805e-15, -6.655004566091178e-17,  2.241494014728912e-18,
  8.523984072138289e-20,  1.221513108131003e+00,  1.129653559375733e-02, -7.859637163192646e-05, -1.806467406519372e-07,  1.673342416272096e-08, -8.065982904185333e-11,
 -1.295537429676507e-12, -6.779820132667496e-14, -3.439022504975148e-15, -1.581738383116684e-17,  1.429463298250229e-18,  3.682587872228133e-20,  1.480847593871584e+00,
  7.999674892967285e-03, -7.482498323832430e-05,  3.829096672300060e-07,  4.652024801710057e-09, -4.996859668495245e-11,  4.477146148323590e-13, -6.295344802507606e-14,
 -1.796956116456657e-15, -6.246194828568937e-18,  7.185795164797339e-19,  2.266601473617536e-20,  1.682038562052754e+00,  5.076537337054802e-03, -5.461812715098962e-05,
  4.527071127293095e-07, -8.711876582596419e-10,  6.492730680966440e-12,  1.254091267363605e-13, -3.899958059179612e-14, -8.919677821547767e-16, -4.673739728559338e-18,
  4.034138067090506e-19,  1.286137667652734e-20,  1.831021410344403e+00,  2.757565875143449e-03, -3.203930260235466e-05,  3.191365386076714e-07, -1.963476049705360e-09,
  2.379059728574826e-11, -1.609337892665688e-13, -1.785466162246815e-14, -4.429902914977563e-16, -2.516857012930040e-18,  2.048088661061055e-19,  6.402201403570141e-21,
  1.931859109937022e+00,  1.126678455439214e-03, -1.366811391833673e-05,  1.487208391250883e-07, -1.196689310394227e-09,  1.579462666518494e-11, -1.506006924907390e-13,
 -5.898260487205241e-15, -1.811894535672431e-16, -8.839331946670787e-19,  7.874234781422584e-20,  2.489257752721245e-21,  1.987130788077806e+00,  2.142153696665929e-04,
 -2.654527950498476e-06,  3.007282432510035e-08, -2.673081660496000e-10,  3.651988861263855e-12, -3.848846662621556e-14, -9.505722421713761e-16, -3.516415699474272e-17,
 -1.429450169015037e-19,  1.433540199344375e-20,  4.633928564643206e-22,  1.156590918230683e-01,  7.340465973058560e-03,  2.870112007046673e-04,  7.182060392102486e-06,
  5.884415509961229e-08, -4.197960931242490e-09, -2.285446045951677e-10, -5.101856155574369e-12,  2.526135087170424e-14,  6.299422463042241e-15,  2.326261314224516e-16,
  3.051875009345806e-18,  5.612343315323696e-01,  1.553520089600073e-02,  8.579931811862883e-05, -2.992886429990824e-06, -4.397429887231021e-09,  1.557804740904580e-09,
 -1.685392084035196e-11, -1.579664094112521e-12, -4.566971197051555e-15,  8.061535725654546e-16,  9.417321831775589e-18, -1.449900217465699e-20,  9.527914767463624e-01,
  1.394582902563334e-02, -5.080197137491683e-05, -1.129628226384863e-06,  3.047114620590881e-08,  3.275096292444209e-11, -1.534885984291458e-11, -2.714514183904774e-13,
 -3.057046079247519e-15,  1.120108631923853e-16,  7.155624620379791e-18,  1.488382943351548e-19,  1.265434224574528e+00,  1.066350736707176e-02, -7.921873936855790e-05,
  7.162175167065091e-08,  1.459075173843975e-08, -1.470108163549924e-10, -4.720230122278434e-12, -1.721472188149927e-13, -2.493550926699463e-15,  8.471879333216469e-17,
  3.926368759001703e-18,  8.093489812931508e-20,  1.511679881669432e+00,  7.420644430273385e-03, -6.981648101537736e-05,  4.492144015660006e-07,  3.583759954815645e-09,
 -6.682805186061135e-11, -2.101169434116601e-12, -1.161815671791779e-13, -1.205666634817996e-15,  4.910031719215295e-17,  2.240186005342513e-18,  4.820777617961081e-20,
  1.701504904389521e+00,  4.661094147775893e-03, -4.926561671282778e-05,  4.395405209227812e-07, -8.165099490667658e-10, -6.839579585150734e-12, -1.361835495011935e-12,
 -6.580123303195742e-14, -6.003291789822303e-16,  2.653316134331069e-17,  1.262832474582874e-18,  2.694182429349570e-20,  1.841562590194135e+00,  2.516069778346171e-03,
 -2.838367063377363e-05,  2.911183677492255e-07, -1.575161041086788e-09,  1.231555422349261e-11, -8.579596193803433e-13, -3.124007014473951e-14, -3.014683212591394e-16,
  1.320875270685745e-17,  6.343391259604228e-19,  1.341739961677333e-20,  1.936158006838892e+00,  1.024169049646741e-03, -1.198873981033915e-05,  1.318365120403165e-07,
 -9.337306076637281e-10,  9.541606608803646e-12, -3.959297222553321e-13, -1.134114464615376e-14, -1.233639099889394e-16,  5.197322524369855e-18,  2.457757879255877e-19,
  5.200157857873068e-21,  1.987947366839498e+00,  1.943551044703555e-04, -2.317098176484172e-06,  2.631867253547310e-08, -2.063208466301810e-10,  2.282049606530400e-12,
 -8.057379571919415e-14, -1.999791595530658e-15, -2.386044777100504e-17,  9.754124209235087e-19,  4.535447775780296e-20,  9.629219097222095e-22,  1.501704430854274e-01,
  9.988759857751764e-03,  3.749873790965190e-04,  7.110292304653247e-06, -8.992871418237472e-08, -1.102849490732501e-08, -3.124516478907687e-10,  1.222883381162172e-12,
  4.236791401058999e-13,  1.479874266873773e-14,  5.476683256695442e-17, -1.591178473910327e-17,  6.245216272171865e-01,  1.607889127419857e-02,  5.037848486271778e-05,
 -2.850939799408649e-06,  1.916933211968928e-08,  6.355764651473953e-10, -5.821313211870887e-11, -1.181201311812019e-12,  3.240857641743682e-14,  1.311667195255069e-15,
  1.842347575153957e-17,  2.762413574619112e-19,  1.007687695977860e+00,  1.349338559256354e-02, -6.148288944131009e-05, -6.595779644532077e-07,  2.679375088716442e-08,
 -4.318428710180886e-10, -2.323907201081296e-11, -2.356296985095319e-13,  7.846691208487632e-15,  5.401070884040124e-16,  1.379758572303364e-17,  6.602556239514160e-20,
  1.306831444814843e+00,  1.003689190131233e-02, -7.708029700473428e-05,  2.736439844814075e-07,  1.009714638126620e-08, -3.230688501453444e-10, -9.939686572254693e-12,
 -1.653526901588308e-13,  4.304229224565606e-15,  3.168973764605966e-16,  7.326332130410845e-18,  2.102673501997137e-20,  1.540280748840143e+00,  6.884524560301281e-03,
 -6.413800051553355e-05,  4.919655027652206e-07,  1.466416717539077e-09, -1.582932778290317e-10, -5.480066645178539e-12, -1.048199717379155e-13,  2.709636553530193e-15,
  1.818765447735254e-16,  4.141594607251424e-18,  6.781329283681676e-21,  1.719394090491662e+00,  4.287819917186493e-03, -4.408155510126407e-05,  4.229559112029343e-07,
 -1.435390861673417e-09, -6.251262909630998e-11, -3.246107879032059e-12, -5.756663457294984e-14,  1.558551426991235e-15,  1.006523242780167e-16,  2.282585618381653e-18,
  1.555586454190079e-21,  1.851194264370271e+00,  2.302555571429934e-03, -2.503780507191085e-05,  2.664580633129772e-07, -1.608648913646066e-09, -1.921812098186143e-11,
 -1.754402799323559e-12, -2.718818969135194e-14,  7.760873566548604e-16,  5.017980512356565e-17,  1.128749868165910e-18,  3.905525383224068e-23,  1.940072538438161e+00,
  9.343438993091030e-04, -1.049202272877331e-05,  1.177941646035877e-07, -8.649311352729832e-10, -3.965231438491819e-12, -7.244145666316110e-13, -9.937214321822306e-15,
  2.966897876009096e-16,  1.948425470725309e-17,  4.341553007100501e-19, -1.563097279079188e-22,  1.988689638271234e+00,  1.770281832093321e-04, -2.019969666981345e-06,
  2.325756362944973e-08, -1.848088939151640e-10, -3.628474214044717e-13, -1.389871619568112e-13, -1.766286257560639e-15,  5.424413690140761e-17,  3.610797503086905e-18,
  7.992166976438403e-20, -4.475226253544454e-23,  1.966059232927941e-01,  1.328627308914198e-02,  4.431907075253300e-04,  3.544752720412388e-06, -3.727928966279452e-07,
 -1.612185181447823e-08, -1.611699385438441e-11,  2.177611647685950e-11,  7.403195068617043e-13, -6.144860874421697e-15, -1.254782998398056e-15, -3.364172249027685e-17,
  6.894345346851409e-01,  1.635071583347296e-02,  1.815672671498783e-05, -2.526973595108321e-06,  1.604100323920456e-08, -9.922726713454401e-10, -6.861493924029572e-11,
  7.557786249588199e-13,  9.213643257519276e-14,  1.817260053472528e-15, -1.402906571392523e-17, -2.614455397591846e-18,  1.060636549524440e+00,  1.297628920290231e-02,
 -6.721312618988892e-05, -3.317420926400800e-07,  1.228168212570110e-08, -1.018684560684778e-09, -2.266707488075341e-11,  4.256862588581743e-13,  3.578789504464159e-14,
  8.899646444779854e-16, -6.021783202533223e-18, -1.266676977436119e-18,  1.345769640849459e+00,  9.435549437785552e-03, -7.308574698690698e-05,  3.694062057234726e-07,
  1.007537820151930e-09, -5.891359293437119e-10, -1.054783320323112e-11,  2.057573862614515e-13,  1.998976593059724e-14,  4.814568648110759e-16, -4.377047279901299e-18,
 -6.990604666822711e-19,  1.566830211016509e+00,  6.395142797317933e-03, -5.822337097661840e-05,  4.822219607203315e-07, -3.172093222934556e-09, -3.081050395288676e-10,
 -6.006381696563438e-12,  1.147639624372897e-13,  1.159398612690857e-14,  2.677403598670250e-16, -2.851270375011479e-18, -4.014791324703294e-19,  1.735871496187771e+00,
  3.954954271945232e-03, -3.919999930718657e-05,  3.853568844476714e-07, -3.549754318518063e-09, -1.501875606150925e-10, -3.500420594294228e-12,  6.553417005505457e-14,
  6.438901568774114e-15,  1.453090895961281e-16, -1.704403626487732e-18, -2.229121557679228e-19,  1.860023456404671e+00,  2.114560493919720e-03, -2.201536626370279e-05,
  2.351729945390237e-07, -2.453071137640042e-09, -6.569358035674081e-11, -1.840210628299389e-12,  3.400938686065453e-14,  3.193501649655964e-15,  7.134398108329054e-17,
 -8.899156833985337e-19, -1.109549258672276e-19,  1.943650645775687e+00,  8.558140527549274e-04, -9.167394757784812e-06,  1.023103118943479e-07, -1.131926793362283e-09,
 -2.285808821574388e-11, -7.427876562905177e-13,  1.362846651378986e-14,  1.230471957631087e-15,  2.739104629188957e-17, -3.547994896336817e-19, -4.292134864521380e-20,
  1.989367125809442e+00,  1.619327287155748e-04, -1.759480793167516e-06,  2.004978429841806e-08, -2.278297443284001e-10, -3.955359580543546e-12, -1.406528039911412e-13,
  2.571754279364122e-15,  2.267446758928671e-16,  5.042921572993011e-18, -6.660721750858730e-20, -7.930200337191846e-21,  2.569372990743098e-01,  1.687710946723586e-02,
  4.399000541615839e-04, -4.771446608586003e-06, -6.381824906443079e-07, -7.118828648791018e-09,  8.113634371707052e-10,  3.047046385725997e-11, -5.538360672025998e-13,
 -6.274790500138577e-14, -6.891440985363478e-16,  8.366068884302926e-17,  7.549393699772311e-01,  1.637701099381814e-02, -1.153615349232413e-05, -2.504686114496677e-06,
 -1.661691153971882e-08, -2.002729742548056e-09,  1.104361731309335e-12,  4.321193668744798e-12,  1.054141066630351e-13, -2.536486951522166e-15, -2.258884006943537e-16,
 -5.006459165827455e-18,  1.111443553918959e+00,  1.242429152660542e-02, -7.076564410006017e-05, -3.210650418962291e-07, -1.178899687615264e-08, -1.265703003459066e-09,
  8.956842201704113e-12,  1.891669445973803e-12,  4.471288844048202e-14, -1.013271027133808e-15, -9.604915374105351e-17, -1.975997624110949e-18,  1.382369654108096e+00,
  8.867899806718467e-03, -6.898065275344214e-05,  2.809490849150056e-07, -1.240867675209188e-08, -6.878906249842918e-10,  6.095425709357983e-12,  1.010984983794467e-12,
  2.416102132398511e-14, -5.707042843777604e-16, -5.094251025149124e-17, -9.541961268256657e-19,  1.591513968181756e+00,  5.951129306908312e-03, -5.296492945735115e-05,
  3.762844733876363e-07, -1.026713760855512e-08, -3.646920125909060e-10,  3.445453551497250e-12,  5.740055099003898e-13,  1.355835551095886e-14, -3.354423379034210e-16,
 -2.845784910634167e-17, -4.970831569137857e-19,  1.751091704993746e+00,  3.658632921699959e-03, -3.502757214243297e-05,  3.010619009389591e-07, -7.107659788340858e-09,
 -1.851028273179046e-10,  1.775627249194180e-12,  3.179994333158188e-13,  7.368204250207678e-15, -1.891224158503739e-16, -1.550660918134870e-17, -2.572754159159353e-19,
  1.868146235471560e+00,  1.948945731146606e-03, -1.947847384063788e-05,  1.835705695598991e-07, -4.063501351629493e-09, -8.503867744750385e-11,  8.125677073444475e-13,
  1.585155349165536e-13,  3.605805771493870e-15, -9.505397919651948e-17, -7.625003038208831e-18, -1.219413084427351e-19,  1.946934512073286e+00,  7.870378729324043e-04,
 -8.065990715710951e-06,  7.979325064623783e-08, -1.710289476506860e-09, -3.095209644526130e-11,  2.928459157490641e-13,  6.145743756068136e-14,  1.378507599368141e-15,
 -3.698641806919935e-17, -2.927835103988610e-18, -4.569859084070018e-20,  1.989988132128092e+00,  1.487502865176773e-04, -1.543853253710440e-06,  1.562928607567075e-08,
 -3.300424108093079e-10, -5.517720545570327e-12,  5.178427885755938e-14,  1.137327904788937e-14,  2.530378305617352e-16, -6.854141770840590e-18, -5.389041620127118e-19,
 -8.301670853892736e-21,  3.308723106055327e-01,  1.999094790671441e-02,  3.207528908376379e-04, -1.483621659432962e-05, -5.359293927903656e-07,  1.853055742758723e-08,
  1.090912965863864e-09, -1.955290315408800e-11, -2.155647346455061e-12,  6.618662945754543e-15,  3.914080264696252e-15,  4.323527326082095e-17,  8.200623721961632e-01,
  1.615716852480527e-02, -4.437954361617686e-05, -3.043309193808549e-06, -4.524389971318869e-08, -2.964032377812743e-10,  1.418120609334470e-10,  4.305800435956338e-12,
 -1.609630743708130e-13, -1.101566950589388e-14, -1.858036366594054e-17,  1.843938725892332e-17,  1.159977221244568e+00,  1.183779951508366e-02, -7.649300203160267e-05,
 -6.803190337113760e-07, -3.007596180694097e-08, -3.162215319988272e-10,  7.065994918773073e-11,  1.926096899902496e-12, -6.572543090552913e-14, -4.640766464496798e-15,
 -1.640833645451242e-17,  7.064132265554566e-18,  1.416752900955176e+00,  8.325223895189091e-03, -6.719950563366029e-05, -8.899080172926739e-09, -2.209496014132151e-08,
 -1.487363341430625e-10,  3.910317616976562e-11,  1.032162971220995e-12, -3.471857728901417e-14, -2.433977994463328e-15, -7.563456515181202e-18,  3.588402333574547e-18,
  1.614495043976088e+00,  5.542183686163075e-03, -4.964472748346897e-05,  1.642737790201508e-07, -1.525679362054522e-08, -5.968029903102689e-11,  2.209987385491806e-11,
  5.814691975322127e-13, -1.954880369903302e-14, -1.348227712978623e-15, -3.399264222319295e-18,  1.961854809841112e-18,  1.765185615050951e+00,  3.390680279313498e-03,
 -3.220267230774899e-05,  1.634198343642123e-07, -9.567912579593612e-09, -1.984054870389819e-11,  1.205091661895788e-11,  3.190430520762222e-13, -1.074997230062562e-14,
 -7.297301939187721e-16, -1.485567140725642e-18,  1.055644050410828e-18,  1.875642602074945e+00,  1.800709917816185e-03, -1.771386079752237e-05,  1.076892508324126e-07,
 -5.163891360399461e-09, -4.627260847338088e-12,  5.908907489944096e-12,  1.577162809619549e-13, -5.326313619014671e-15, -3.570137053420214e-16, -5.992260180954532e-19,
  5.150521379208676e-19,  1.949958960228334e+00,  7.258334468544674e-04, -7.290087646333541e-06,  4.850878391620795e-08, -2.102229252874454e-09, -3.726491800989501e-13,
  2.261544411066598e-12,  6.078171209517726e-14, -2.056144268645482e-15, -1.366115203653223e-16, -1.968639258467272e-19,  1.968353007593954e-19,  1.990559482924391e+00,
  1.370525360071907e-04, -1.391082856214267e-06,  9.653575816409594e-09, -3.989837885386026e-10,  7.677950457026119e-14,  4.153620760348343e-13,  1.121032937336180e-14,
 -3.795837703414336e-16, -2.509714513884929e-17, -3.295079933972434e-20,  3.614185940885561e-20,  4.146818212236096e-01,  2.173501731381449e-02,  1.072886940111202e-04,
 -1.933659756697351e-05,  1.671704550456996e-08,  3.163087280206209e-08, -1.787193028178884e-10, -5.672658008125222e-11,  4.606796091451948e-13,  1.046063479568609e-13,
 -9.443293036766293e-16, -1.957931442790388e-16,  8.837334072860418e-01,  1.564464337824601e-02, -8.476216427876983e-05, -3.603584330409252e-06, -1.180927761926895e-08,
  3.645177994552829e-09,  1.402008465714856e-10, -5.499474590739069e-12, -3.458775582660550e-13,  6.271857244751296e-15,  7.371626613807591e-16, -1.964824169631509e-18,
  1.206041480814236e+00,  1.118520453387099e-02, -8.741870053904185e-05, -1.107814018476334e-06, -1.691779758580344e-08,  1.647632400577085e-09,  7.323488401760170e-11,
 -2.261531473333325e-12, -1.561680708976170e-13,  1.903669409666616e-15,  3.005499878129719e-16,  8.637342518478734e-19,  1.448969607395122e+00,  7.781332201081764e-03,
 -6.934116830110538e-05, -3.286468946400596e-07, -1.431590572875479e-08,  9.367274182103946e-10,  4.093033035948493e-11, -1.179046659150226e-12, -8.328084138929136e-14,
  8.889816656200624e-16,  1.529257974240409e-16,  6.008406719611970e-19,  1.635876230647253e+00,  5.148878071426840e-03, -4.907327151890284e-05, -5.684800038241556e-08,
 -1.037148310706511e-08,  5.543746023509699e-10,  2.326081900580736e-11, -6.519738323041115e-13, -4.647549623565729e-14,  4.720446795622950e-16,  8.306090292696152e-17,
  3.398084998160942e-19,  1.778241941880527e+00,  3.138383719437005e-03, -3.111637910744853e-05,  2.491613184030327e-08, -6.646161648957704e-09,  3.155683272080867e-10,
  1.273619671262070e-11, -3.526949482381431e-13, -2.526559897333061e-14,  2.517378494208803e-16,  4.438914933243818e-17,  1.787394514105625e-19,  1.882568282031077e+00,
  1.662812103958640e-03, -1.689246665795468e-05,  3.304277261482658e-08, -3.627175364827506e-09,  1.601136810142953e-10,  6.264451536584554e-12, -1.725198927885398e-13,
 -1.239609905200162e-14,  1.226331813169755e-16,  2.153950846308812e-17,  8.439141232089926e-20,  1.952748558043282e+00,  6.692900901192920e-04, -6.899351500259161e-06,
  1.815238728724822e-08, -1.485456909214010e-09,  6.276421652845650e-11,  2.402866341437175e-12, -6.600895845869523e-14, -4.751885548949098e-15,  4.690064728547616e-17,
  8.200614312695776e-18,  3.136700519669431e-20,  1.991086021276447e+00,  1.262827508435541e-04, -1.311527303698555e-06,  3.895676842398176e-09, -2.827291214905539e-10,
  1.168193317156575e-11,  4.418591577762288e-13, -1.212607531082784e-14, -8.738063497379488e-16,  8.619357069240439e-18,  1.502624932412037e-18,  5.663319119089468e-21,
  5.019338667070617e-01,  2.171386145692933e-02, -1.043410865070544e-04, -1.471221590235070e-05,  4.990431810385098e-07,  1.281165716813216e-08, -1.126628337661354e-09,
 -2.089474734427148e-12,  2.090753997194340e-12, -3.088353891511413e-14, -3.382836098502949e-15,  1.096416868469051e-16,  9.446857718498133e-01,  1.479675396593639e-02,
 -1.263285334542461e-04, -3.096853903422001e-06,  7.735268896777425e-08,  4.296883877245116e-09, -1.011164312466804e-10, -8.612436594621252e-12,  2.168357630527731e-13,
  1.632585098957359e-14, -4.737085582204112e-16, -3.098085072453322e-17,  1.249296819483787e+00,  1.043106012380923e-02, -1.010197411070859e-04, -1.049485706636560e-06,
  2.611542937094378e-08,  2.220278810111406e-09, -3.503349867335203e-11, -4.222145603810782e-12,  7.028375115357585e-14,  7.590204054032346e-15, -1.356528769487279e-16,
 -1.383792288147236e-17,  1.478957225869354e+00,  7.208629279256360e-03, -7.391020758952275e-05, -3.703186706281351e-07,  1.028271549201097e-08,  1.290664537143973e-09,
 -1.696450575722339e-11, -2.321448244205070e-12,  3.206309065720420e-14,  4.035608864365246e-15, -5.771004520219620e-17, -7.098433940203548e-18,  1.655679576101144e+00,
  4.751740140499728e-03, -5.031032875446329e-05, -1.125726571874527e-07,  4.097463102426822e-09,  7.626778162802555e-10, -9.100322957378448e-12, -1.314017067665046e-12,
  1.639140254450117e-14,  2.237794839769472e-15, -2.836206483540331e-17, -3.840091268601844e-18,  1.790297697091369e+00,  2.889405855059512e-03, -3.120600656971499e-05,
 -1.910195877943270e-08,  1.527846374207772e-09,  4.312290379972829e-10, -4.868173267290976e-12, -7.196240702812137e-13,  8.448348198709408e-15,  1.209624208118943e-15,
 -1.428714515372625e-17, -2.040936489891757e-18,  1.888950743690748e+00,  1.528557203291646e-03, -1.671822714192579e-05,  6.454539414330784e-09,  4.935679054293736e-10,
  2.173231440475203e-10, -2.374280831096636e-12, -3.544908169690548e-13,  4.009351665075752e-15,  5.909075924474689e-16, -6.689674960906198e-18, -9.857122107023841e-19,
  1.955316284227968e+00,  6.146740672891847e-04, -6.774926867644006e-06,  6.664491379626185e-09,  1.224756352698467e-10,  8.475352860409770e-11, -9.085745248925234e-13,
 -1.361845723775241e-13,  1.506386779206018e-15,  2.258515360049287e-16, -2.494255483339077e-18, -3.740385282247810e-19,  1.991570382527875e+00,  1.159213434220645e-04,
 -1.282780998785441e-06,  1.652604446517279e-09,  1.577930409148720e-11,  1.572805930055995e-11, -1.670293190468178e-13, -2.506820010973784e-14,  2.741745076811014e-16,
  4.146441612106988e-17, -4.522737452412652e-19, -6.840953728066653e-20,  5.862074683847843e-01,  2.031900082377374e-02, -2.290527834791539e-04, -6.050824694463052e-06,
  5.123407685625491e-07, -9.054690374493603e-09, -5.368610049950097e-10,  3.219206703224791e-11, -6.679042601425252e-14, -5.334481603278253e-14,  1.673684129396899e-15,
  4.489674330055852e-17,  1.001652999826817e+00,  1.366386060563509e-02, -1.538343250997223e-04, -1.366166287013988e-06,  1.252169099831868e-07,  1.273631888602147e-10,
 -1.927118576712618e-10,  2.555580319215598e-12,  3.120866982927368e-13, -1.028965462706587e-14, -3.969877758419422e-16,  2.678573132054652e-17,  1.289338877075294e+00,
  9.582536877383462e-03, -1.098819604777497e-04, -3.550273879963561e-07,  5.470882618268794e-08,  4.069036766632827e-10, -9.331019670149857e-11,  5.271314193751094e-13,
  1.571301155942393e-13, -3.349606796751399e-15, -2.256370715001003e-16,  9.465062288308803e-18,  1.506587271849684e+00,  6.604091265757677e-03, -7.663883388333750e-05,
 -3.996428275256801e-08,  2.782949905786329e-08,  3.254245932573007e-10, -5.170704873988387e-11,  1.355737381166695e-13,  8.662499105979846e-14, -1.470939366963154e-15,
 -1.267557462897076e-16,  4.330123834477864e-18,  1.673875953440197e+00,  4.345995850012756e-03, -5.083271166487357e-05,  5.252566421927967e-08,  1.475800733229958e-08,
  2.218462136522331e-10, -2.953033164167527e-11,  3.177768599588595e-14,  4.898932795328161e-14, -7.237781396782396e-16, -7.188379037814478e-17,  2.188064094865330e-18,
  1.801355934623738e+00,  2.639840515241720e-03, -3.104091557296750e-05,  6.213747388234630e-08,  7.654199866559493e-09,  1.357956440251692e-10, -1.629546194743936e-11,
  3.110820718219523e-15,  2.679422334282286e-14, -3.616258024376738e-16, -3.928117897422789e-17,  1.113468468331611e-18,  1.894798552864480e+00,  1.395550753781878e-03,
 -1.646809402201950e-05,  4.313237450924393e-08,  3.611994622510265e-09,  7.176809233782042e-11, -8.074001808230596e-12, -2.740039335403283e-15,  1.318470385463436e-14,
 -1.677043262514823e-16, -1.929914043782849e-17,  5.229039314087071e-19,  1.957667288323276e+00,  5.609432486882445e-04, -6.634216579560253e-06,  1.988531815028013e-08,
  1.345925495917129e-09,  2.878707825245821e-11, -3.114184575403056e-12, -2.025012244150664e-15,  5.061386789905250e-15, -6.204282342227713e-17, -7.398831958793346e-18,
  1.950204427521781e-19,  1.992013703504922e+00,  1.057641463906545e-04, -1.252334944472568e-06,  3.998367237700317e-09,  2.435141798972348e-10,  5.418830274286643e-12,
 -5.745070634853196e-13, -4.633121573813392e-16,  9.312973069083226e-16, -1.119789005276805e-17, -1.360313087619003e-18,  3.535013408011147e-20,  6.635333875629706e-01,
  1.831862414776642e-02, -2.599345595637688e-04,  2.821087216216284e-07,  2.684533311980862e-07, -1.263912689656350e-08,  1.452634516000234e-10,  1.312314594623608e-11,
 -7.407539129611810e-13,  8.868996810132357e-15,  7.925909665127098e-16, -4.418521762725414e-17,  1.053789771534825e+00,  1.240041591447728e-02, -1.588329909380148e-04,
  4.460055878496569e-07,  9.147070321919296e-08, -2.906813337387744e-09, -4.605516007412425e-11,  5.713624550854160e-12, -8.895692604453785e-14, -6.835430995494769e-15,
  3.542447800979979e-16,  6.708643895098785e-19,  1.325904831324864e+00,  8.701208723997107e-03, -1.089815289657374e-04,  4.771171379796512e-07,  4.395523909119910e-08,
 -1.239062427386538e-09, -3.358983358692335e-11,  2.762442549077072e-12, -1.935869277136519e-14, -3.921341235589438e-15,  1.378758636038667e-16,  2.551368584952708e-18,
  1.531785196696397e+00,  5.996714808955213e-03, -7.443521524789975e-05,  3.959885994872776e-07,  2.355343830828521e-08, -6.301074390419417e-10, -2.155635298177618e-11,
  1.512188511682222e-12, -4.707408274331785e-15, -2.256854315448559e-15,  6.557262828055732e-17,  1.851410780432422e-18,  1.690456417339332e+00,  3.945969487057411e-03,
 -4.875643872605842e-05,  2.886711425857449e-07,  1.293842902089377e-08, -3.374652104930776e-10, -1.326662440877157e-11,  8.540339850593384e-13, -7.976306665361808e-16,
 -1.301918277295369e-15,  3.370492672623131e-17,  1.169000651362790e-18,  1.811426409597125e+00,  2.396652511913916e-03, -2.953590152014977e-05,  1.866172350243845e-07,
  6.885588140139316e-09, -1.773725518063060e-10, -7.647123099625320e-12,  4.671650034217240e-13,  1.870098273295720e-16, -7.197000542348348e-16,  1.728607102433803e-17,
  6.763235948474956e-19,  1.900121992644757e+00,  1.266902477179374e-03, -1.558873965264250e-05,  1.025971943571993e-07,  3.311044851994713e-09, -8.479709700909975e-11,
 -3.891523693482848e-12,  2.299924914098177e-13,  2.852499258196579e-16, -3.563181753606021e-16,  8.146620343176949e-18,  3.434663482257090e-19,  1.959806967735914e+00,
  5.092085752032567e-04, -6.259889439015406e-06,  4.223265426869482e-08,  1.249692448706636e-09, -3.192615245579257e-11, -1.525134895471431e-12,  8.833190096345299e-14,
  1.546113701780733e-16, -1.372629641930900e-16,  3.043001168465451e-18,  1.342213971355017e-19,  1.992417125080889e+00,  9.600719198407304e-05, -1.179710158050255e-06,
  8.060892361144114e-09,  2.277109620981204e-10, -5.812279499024529e-12, -2.836544399227939e-13,  1.625793065134577e-14,  3.271630357421681e-17, -2.530009558926259e-17,
  5.519094705999386e-19,  2.491442410584583e-20,  7.327502231334768e-01,  1.630816975580442e-02, -2.382693205764855e-04,  2.826518226444139e-06,  6.823108636001423e-08,
 -6.991290879627707e-09,  2.534692886737998e-10, -2.525148107419033e-12, -2.201265819048676e-13,  1.298615698524713e-14, -2.796755091206143e-16, -4.789180537679216e-18,
  1.100913104515403e+00,  1.117147101805390e-02, -1.466825686547971e-04,  1.431004976300039e-06,  3.295078233001323e-08, -2.549687269248868e-09,  5.498260456643300e-11,
  1.347940572675064e-12, -1.258271937367326e-13,  2.762141023412906e-15,  7.629821673212033e-17, -6.871374204946173e-18,  1.359016407626901e+00,  7.862166831978537e-03,
 -9.993011870501775e-05,  9.621082379813607e-07,  1.660680089845989e-08, -1.277931621117302e-09,  2.169602006746184e-11,  9.655641983916856e-13, -6.357666380545477e-14,
  8.625016018807370e-16,  5.930020676647273e-17, -3.312553467873390e-18,  1.554618821805190e+00,  5.425574168040010e-03, -6.789225545193896e-05,  6.572398735921631e-07,
  8.873230245002985e-09, -7.115399262363204e-10,  1.043754829016884e-11,  6.167546704436470e-13, -3.526268458673142e-14,  3.342684827390923e-16,  3.768912709531188e-17,
 -1.743288901963105e-18,  1.705486328846817e+00,  3.572706644261310e-03, -4.430797381522605e-05,  4.320189610506798e-07,  4.781865564877521e-09, -4.044773205619066e-10,
  5.373440985255129e-12,  3.781927714992127e-13, -2.000681858246062e-14,  1.416975832322134e-16,  2.283324911575385e-17, -9.501484089485493e-19,  1.820556861057228e+00,
  2.170882642799110e-03, -2.677322494904705e-05,  2.626422103595398e-07,  2.484438811610198e-09, -2.216149976596307e-10,  2.745893830584623e-12,  2.173384387326701e-13,
 -1.096124943830406e-14,  6.099688703696078e-17,  1.298139882146065e-17, -5.055993804221216e-19,  1.904949052901411e+00,  1.147866465669727e-03, -1.410636907722318e-05,
  1.390139542472915e-07,  1.167448982558395e-09, -1.090608872459467e-10,  1.287256735818882e-12,  1.103410141812994e-13, -5.398737021630207e-15,  2.476020963458949e-17,
  6.537060978055327e-18, -2.439929217726918e-19,  1.961747258048834e+00,  4.614391368876509e-04, -5.658426719556615e-06,  5.593301305787552e-08,  4.326289395060843e-10,
 -4.184634061717562e-11,  4.785266808091684e-13,  4.317317678803835e-14, -2.073519202224555e-15,  8.257397074201374e-18,  2.543730189163701e-18, -9.247888252295235e-20,
  1.992782964789820e+00,  8.700787814174448e-05, -1.065745395741933e-06,  1.055231791252448e-08,  7.796523367814147e-11, -7.696322694017069e-12,  8.652749256825397e-14,
  8.022303374338585e-15, -3.816185377628932e-16,  1.400159896357494e-18,  4.712551130339070e-19, -1.690031162558616e-20,  7.944001085635850e-01,  1.454760684235013e-02,
 -2.014341946937369e-04,  3.096514815099863e-06, -1.906286697860889e-08, -2.200839660948307e-09,  1.384708780742939e-10, -4.304586091757784e-12,  4.616570052389392e-14,
  2.664087494653130e-15, -1.712716430175510e-16,  4.846779671338541e-18,  1.143368997479253e+00,  1.007228651735476e-02, -1.277796273179737e-04,  1.627896084488640e-06,
 -3.714470476669810e-09, -1.131285261021568e-09,  5.277171896691168e-11, -9.486994886605628e-13, -2.293071211180788e-14,  2.086603517159747e-15, -5.871346725888713e-17,
 -6.801326386408908e-20,  1.388943398411210e+00,  7.111695946206390e-03, -8.752616878001175e-05,  1.057173057782013e-06, -2.582106077870877e-09, -6.238931016884580e-10,
  2.674745297846187e-11, -3.539174018238502e-13, -1.781231937892652e-14,  1.133508980577494e-15, -2.341531993670539e-17, -4.319860564279941e-19,  1.575286910711722e+00,
  4.915424607492279e-03, -5.956809005314345e-05,  7.027700973427562e-07, -2.038824980012003e-09, -3.632204123316041e-10,  1.500485567219735e-11, -1.606605515319474e-13,
 -1.172116800993221e-14,  6.486675555544987e-16, -1.099788858462805e-17, -3.495844435130659e-19,  1.719102160212579e+00,  3.239724095057880e-03, -3.890201305897758e-05,
  4.532251159991016e-07, -1.497455536769313e-09, -2.116808754732083e-10,  8.582724817301662e-12, -7.856710156083561e-14, -7.296601899004084e-15,  3.742064229586530e-16,
 -5.519596136601815e-18, -2.349079345753668e-19,  1.828832529331693e+00,  1.969673396340136e-03, -2.351363077751969e-05,  2.719243250614091e-07, -9.824579948902855e-10,
 -1.177437314968582e-10,  4.726796066544422e-12, -3.846620176744553e-14, -4.229638872009233e-15,  2.070340169567711e-16, -2.761415533311025e-18, -1.413165109787603e-19,
  1.909325630153458e+00,  1.041854730554384e-03, -1.239059351471383e-05,  1.426454358762921e-07, -5.470310258764444e-10, -5.848917264718027e-11,  2.335544280832736e-12,
 -1.743964050788510e-14, -2.158560747569347e-15,  1.025807467088713e-16, -1.274023027025442e-18, -7.358637129426715e-20,  1.963506819924017e+00,  4.189161522388993e-04,
 -4.970478509286670e-06,  5.706864854004734e-08, -2.271842117616823e-10, -2.256849965050113e-11,  8.986909554950861e-13, -6.332218161644387e-15, -8.471707731182070e-16,
  3.953855746717998e-17, -4.685125505835122e-19, -2.920296036427387e-20,  1.993114762139233e+00,  7.899895097185105e-05, -9.361947429120128e-07,  1.073431954070156e-08,
 -4.357441854950101e-11, -4.162644112120604e-12,  1.655500601292081e-13, -1.129944893418693e-15, -1.576614576453849e-16,  7.289900564661989e-18, -8.421768849761824e-20,
 -5.464132726401142e-21,  8.495924407396379e-01,  1.307722022517335e-02, -1.670767604733610e-04,  2.582711737701357e-06, -3.851186255458046e-08, -1.060819539570242e-10,
  4.581056456730287e-11, -2.244264931240108e-12,  6.282991286953790e-14, -7.613402065989906e-16, -2.382417149650084e-17,  1.749659567474678e-18,  1.181734200519577e+00,
  9.125857418305008e-03, -1.091518454153699e-04,  1.446484341576866e-06, -1.601756399157698e-08, -2.125390561042578e-10,  2.418021312703866e-11, -8.975330336174378e-13,
  1.515508849522828e-14,  2.605850326949782e-16, -2.655923371051041e-17,  8.713236621841347e-19,  1.416068128014572e+00,  6.460786896145827e-03, -7.539783914412669e-05,
  9.468030607432918e-07, -9.640960966539849e-09, -1.343913642013531e-10,  1.363536246168105e-11, -4.601057128512186e-13,  5.709923987656489e-15,  2.351799624421371e-16,
 -1.567462197420502e-17,  4.109884038625661e-19,  1.594047567618433e+00,  4.471623485633158e-03, -5.151239978080604e-05,  6.295509206621832e-07, -6.206362787979883e-09,
 -8.132790279106877e-11,  8.076082627357333e-12, -2.593947026533736e-13,  2.573541786920898e-15,  1.626023489851025e-16, -9.328872053746743e-18,  2.148782625495345e-19,
  1.731472155620144e+00,  2.949601305556248e-03, -3.371339702743677e-05,  4.055079906870122e-07, -3.939504544023245e-09, -4.785080120834687e-11,  4.771549390829702e-12,
 -1.488148992499681e-13,  1.243346546019431e-15,  1.037962315009185e-16, -5.503661409730783e-18,  1.163932025114771e-19,  1.836355105075137e+00,  1.794207907408600e-03,
 -2.040408843517775e-05,  2.429674849016588e-07, -2.343370512332308e-09, -2.658174930735622e-11,  2.682793091848008e-12, -8.212533602760118e-14,  6.009312864674504e-16,
  6.105903672075733e-17, -3.087630755596013e-18,  6.157650286794565e-20,  1.913305336764004e+00,  9.493577983353848e-04, -1.076080571664133e-05,  1.273131606554334e-07,
 -1.223313668920923e-09, -1.314029751390463e-11,  1.343488401179040e-12, -4.063749517710931e-14,  2.693199493125157e-16,  3.144381959874108e-17, -1.543443690299421e-18,
  2.957182335247529e-20,  1.965107170650432e+00,  3.818026653130886e-04, -4.318827404135271e-06,  5.089446844124575e-08, -4.880869663684051e-10, -5.045156522895856e-12,
  5.212723561368133e-13, -1.565193385499447e-14,  9.692873485113888e-17,  1.240774578551478e-17, -5.981278158769484e-19,  1.116901579952616e-20,  1.993416571224657e+00,
  7.200777829044562e-05, -8.136620053536810e-07,  9.568781834813065e-09, -9.168550477414388e-11, -9.275255861441329e-13,  9.644047719363657e-14, -2.884799335396993e-15,
  1.720650508038838e-17,  2.315506655385321e-18, -1.105874269880291e-19,  2.037029631907437e-21,  8.994097562652068e-01,  1.185423721203000e-02, -1.397071984662843e-04,
  1.991643277699425e-06, -3.367647864226958e-08,  4.375443275340092e-10,  6.356293851962405e-12, -7.460289788957089e-13,  3.086266805922532e-14, -7.968333558230469e-16,
  1.059587558934229e-17,  1.542565769189486e-19,  1.216594768134869e+00,  8.317560707205848e-03, -9.339070865301249e-05,  1.180221954025005e-06, -1.620197720796955e-08,
  1.240151150618077e-10,  6.169262824917925e-12, -4.032606495375069e-13,  1.300283037161826e-14, -2.179105668051292e-16, -1.919529823629330e-18,  2.673614323272569e-19,
  1.440773016830405e+00,  5.900319631049829e-03, -6.500376571724653e-05,  7.848811863882985e-07, -9.972988202057928e-09,  6.323277090872981e-11,  3.911828179638658e-12,
 -2.304787109059039e-13,  6.772984961851012e-15, -8.702077813501373e-17, -2.297801071651933e-18,  1.715959976874129e-19,  1.611155235061737e+00,  4.087987996127830e-03,
 -4.457940000703647e-05,  5.255134140459880e-07, -6.419850026276664e-09,  3.792896017203236e-11,  2.436441510028169e-12, -1.376792613372039e-13,  3.846802299329200e-15,
 -4.079927346074609e-17, -1.708189710577774e-18,  1.063471643914699e-19,  1.742760399304417e+00,  2.698248067337625e-03, -2.924052618712749e-05,  3.397373399276950e-07,
 -4.055703658820464e-09,  2.334249284352008e-11,  1.478382851322884e-12, -8.183585559723407e-14,  2.216213876271672e-15, -2.032443136471824e-17, -1.128951100719185e-18,
  6.423980827792017e-20,  1.843223007860874e+00,  1.641978911667317e-03, -1.772165426410816e-05,  2.039948059031385e-07, -2.400218777894183e-09,  1.369665407148576e-11,
  8.441764883520296e-13, -4.621448114703197e-14,  1.226275733855767e-15, -1.006807375071782e-17, -6.774671095621807e-19,  3.658028760422357e-20,  1.916939786902210e+00,
  8.690392373957664e-04, -9.354476719383135e-06,  1.070299829858616e-07, -1.247718748604560e-09,  7.107994677441839e-12,  4.266843356806528e-13, -2.321609314027554e-14,
  6.078261629197550e-16, -4.599907589152290e-18, -3.531331812902924e-19,  1.846175334354752e-20,  1.966568955224773e+00,  3.495582682693215e-04, -3.756461403555081e-06,
  4.281875128282296e-08, -4.963420490565192e-10,  2.829196954340921e-12,  1.664504747557432e-13, -9.026634417113868e-15,  2.343592546130036e-16, -1.678369649480687e-18,
 -1.403582447149587e-19,  7.196812041697435e-21,  1.993692274778591e+00,  6.593212333045395e-05, -7.079139630221663e-07,  8.053546742471981e-09, -9.308119870053636e-11,
  5.310011795533687e-13,  3.087817945386061e-14, -1.671906978454288e-15,  4.321863633253179e-17, -3.002717105911818e-19, -2.628998521305865e-20,  1.334690979507635e-21,
  9.447307331712524e-01,  1.082370922408392e-02, -1.187400453462478e-04,  1.525711575573803e-06, -2.461660805702272e-08,  4.275989921875403e-10, -4.404450027359513e-12,
 -1.313534952140799e-13,  1.013954100624790e-14, -3.687557971170549e-16,  8.890205652184937e-18, -1.248916533195302e-19,  1.248454529764422e+00,  7.622903570531335e-03,
 -8.068418548217041e-05,  9.457899247885231e-07, -1.294388864283243e-08,  1.762607131807270e-10, -4.827164684255578e-13, -1.113019603420050e-13,  5.610479533428615e-15,
 -1.635509711326969e-16,  2.760831293633591e-18,  5.173173769834993e-21,  1.463390213593861e+00,  5.415371159358349e-03, -5.648936452704930e-05,  6.387372215997507e-07,
 -8.179273692082989e-09,  1.009314876858993e-10, -3.814758603211508e-14, -7.062773083670405e-14,  3.244785358157608e-15, -8.682803057018278e-17,  1.183737065964927e-18,
  1.620084957071169e-20,  1.626831485647669e+00,  3.754903973086221e-03, -3.885724324646574e-05,  4.309606256651865e-07, -5.323760062260856e-09,  6.240992354498842e-11,
  3.206678220511309e-14, -4.430077343569590e-14,  1.951539550472692e-15, -4.979403832118736e-17,  5.844775369851729e-19,  1.363074137884135e-20,  1.753109864295764e+00,
  2.479572785013279e-03, -2.553317986685227e-05,  2.798629991566281e-07, -3.381861746415429e-09,  3.846601747039023e-11,  3.344008596021326e-14, -2.707233798806841e-14,
  1.165122648750863e-15, -2.885205362267698e-17,  3.033145196838306e-19,  9.489604083057128e-21,  1.849521993117769e+00,  1.509370660183298e-03, -1.549255414412145e-05,
  1.685177955126347e-07, -2.007470770978523e-09,  2.240592732663783e-11,  2.252611866762715e-14, -1.555227580175350e-14,  6.599614321117635e-16, -1.602280025420851e-17,
  1.552276062026752e-19,  5.857306731730837e-21,  1.920273945019700e+00,  7.990149566680265e-04, -8.183918734969340e-06,  8.857603568144063e-08, -1.045346260555837e-09,
  1.152806349143772e-11,  1.209305322064777e-14, -7.897769837289454e-15,  3.322206790075768e-16, -7.960819197985210e-18,  7.271501876768292e-20,  3.104447941217667e-21,
  1.967910155540795e+00,  3.214322145431085e-04, -3.287915094456084e-06,  3.547532375864974e-08, -4.162386252619019e-10,  4.556764571875278e-12,  4.815078313178442e-15,
 -3.091009906039773e-15,  1.293423624633357e-16, -3.073961325496057e-18,  2.699890369313946e-20,  1.246038211082901e-21,  1.993945254285065e+00,  6.063106429534541e-05,
 -6.197634140691480e-07,  6.676188265834151e-09, -7.809562700991876e-11,  8.517337368809482e-13,  8.981396680991756e-16, -5.744551443721704e-16,  2.397367160770591e-17,
 -5.673087769454958e-19,  4.877804021104101e-21,  2.345454174012377e-22,  9.862330356072945e-01,  9.940935928407594e-03, -1.025332169357918e-04,  1.193792317276568e-06,
 -1.727409436874853e-08,  3.043428289561168e-10, -5.108411042779613e-12,  3.866079832789611e-14,  1.962745912814011e-15, -1.189077415423796e-16,  3.896067625118486e-18,
 -8.839756745179786e-20,  1.277722449827926e+00,  7.019567094493706e-03, -7.046518027329312e-05,  7.655030756476764e-07, -9.702463542941002e-09,  1.428721733461588e-10,
 -1.823013348449507e-12, -5.526770444718502e-15,  1.577473872324836e-15, -6.727904693575553e-17,  1.811458620947099e-18, -3.073890796045951e-20,  1.484193470257854e+00,
  4.992041360920080e-03, -4.954467747230286e-05,  5.234732156458912e-07, -6.280355892697636e-09,  8.547221139009747e-11, -9.636670999776039e-13, -7.241417772090399e-15,
  1.003473170307244e-15, -3.935329437755819e-17,  9.808310869497132e-19, -1.407082448705976e-20,  1.641260217724005e+00,  3.463377562529319e-03, -3.415636024475859e-05,
  3.554936003544393e-07, -4.138253789342898e-09,  5.387282010204279e-11, -5.678199990207542e-13, -5.484284836119816e-15,  6.320255152692577e-16, -2.381963854921004e-17,
  5.684754687879339e-19, -7.277407408727289e-21,  1.762639671713283e+00,  2.287878643712076e-03, -2.247450047756879e-05,  2.317580877349056e-07, -2.647867577297814e-09,
  3.352180584618456e-11, -3.393525412259446e-13, -3.647083718832350e-15,  3.876247435307325e-16, -1.427813746237598e-17,  3.315308961601620e-19, -3.911668749337612e-21,
  1.855323675802994e+00,  1.393006714093420e-03, -1.364848983594688e-05,  1.399011255080364e-07, -1.578963956350989e-09,  1.962524635944907e-11, -1.937010866870778e-13,
 -2.191903962243284e-15,  2.233153230969625e-16, -8.109170781028158e-18,  1.848887226410018e-19, -2.056302881206341e-21,  1.923345415380020e+00,  7.375282508502069e-04,
 -7.213860285855708e-06,  7.365402365124149e-08, -8.246223852552689e-10,  1.012552835456743e-11, -9.834449134759176e-14, -1.142186289366472e-15,  1.136454798767178e-16,
 -4.089381807007773e-18,  9.211387208151665e-20, -9.825387618659722e-22,  1.969145823087098e+00,  2.967253432948079e-04, -2.899205142691846e-06,  2.952863355879792e-08,
 -3.289418669746420e-10,  4.008398491468430e-12, -3.855303533898177e-14, -4.536113972015380e-16,  4.454243960797986e-17, -1.593899147770270e-18,  3.562963182691548e-20,
 -3.697542477359791e-22,  1.994178341419175e+00,  5.597345264532233e-05, -5.465920806505940e-07,  5.559971980595687e-09, -6.177430721032031e-11,  7.497674825154108e-13,
 -7.175253970703165e-15, -8.491046437752470e-17,  8.284626745548990e-18, -2.956052774084422e-19,  6.581452046850606e-21, -6.729821914739082e-23,  1.024440900872275e+00,
  9.173695191529095e-03, -8.968551265802919e-05,  9.598945706319394e-07, -1.230231243495575e-08,  1.987792862666421e-10, -3.614614337977285e-12,  5.648617959635262e-14,
 -2.937300940377632e-16, -2.396841365586169e-17,  1.228654387807206e-18, -3.688561123118817e-20,  1.304727994746778e+00,  6.490152520632692e-03, -6.212393495213690e-05,
  6.307717524763123e-07, -7.273477469812097e-09,  1.011662216118858e-10, -1.550038980905805e-12,  1.769841402256784e-14,  1.595065878695565e-16, -1.881972325951815e-17,
  7.097806387222559e-19, -1.787999784659482e-20,  1.503406454010523e+00,  4.619224024374669e-03, -4.381363480725913e-05,  4.353884516494457e-07, -4.804528340533180e-09,
  6.247128183919093e-11, -8.828693062707276e-13,  8.571659234700940e-15,  1.463237192701015e-16, -1.201954086736700e-17,  4.196831118139343e-19, -9.865561507233426e-21,
  1.654592756382242e+00,  3.206141721368617e-03, -3.025461476808114e-05,  2.971409266705734e-07, -3.200543751297298e-09,  4.003634988821336e-11, -5.396093899234856e-13,
  4.761421525819552e-15,  1.043245909094746e-16, -7.598267924627779e-18,  2.555790239547139e-19, -5.778200263016243e-21,  1.771448254560093e+00,  2.118534797739904e-03,
 -1.992695350133760e-05,  1.942984229864810e-07, -2.061614312402934e-09,  2.516129602093325e-11, -3.289138707497026e-13,  2.733232127734844e-15,  6.804515940344033e-17,
 -4.673082081231294e-18,  1.537883184962192e-19, -3.391893187755529e-21,  1.860687390178712e+00,  1.290132705408261e-03, -1.210915104162845e-05,  1.175158257445754e-07,
 -1.234719206277268e-09,  1.482400363907125e-11, -1.898519214034220e-13,  1.517605345370460e-15,  4.060842100070060e-17, -2.697760902525429e-18,  8.756364405520142e-20,
 -1.899721394413992e-21,  1.926185406875336e+00,  6.831429927435254e-04, -6.402923554350320e-06,  6.194691804017431e-08, -6.466731639816686e-10,  7.679530963310131e-12,
 -9.701371778874896e-14,  7.563157558260719e-16,  2.111000594658300e-17, -1.374905828987986e-18,  4.423139648056506e-20, -9.491439926490909e-22,  1.970288462647287e+00,
  2.748653587678784e-04, -2.573963387761110e-06,  2.485462437759186e-08, -2.584149693894673e-10,  3.047721868342506e-12, -3.816928874922107e-14,  2.930306230741030e-16,
  8.378531747772329e-18, -5.394034255415819e-19,  1.725797521087225e-20, -3.677793241008719e-22,  1.994393890016222e+00,  5.185186869084854e-05, -4.853393645503915e-07,
  4.681810606221259e-09, -4.857439302850660e-11,  5.708129938173115e-13, -7.116325094114780e-15,  5.420215511818934e-17,  1.568281958443457e-18, -1.003780032201402e-19,
  3.202434924473377e-21, -6.799860598586523e-23,  1.059769304245205e+00,  8.499213887522977e-03, -7.923046689648641e-05,  7.906600108866813e-07, -9.073981487436564e-09,
  1.294201391862972e-10, -2.242139809519955e-12,  4.017834764288359e-14, -5.759851993326545e-16,  1.931636479869353e-18,  2.508425047080972e-19, -1.134422318738523e-20,
  1.329739954746470e+00,  6.021601195910040e-03, -5.519223419966033e-05,  5.287339574671764e-07, -5.581094260867948e-09,  7.002497686985600e-11, -1.053543278867149e-12,
  1.614073759684302e-14, -1.609797094774667e-16, -2.352378304638701e-18,  1.952838795492576e-19, -6.682178989893241e-21,  1.521213692827740e+00,  4.288394665629898e-03,
 -3.901246958877068e-05,  3.674471283237600e-07, -3.746152316706091e-09,  4.438882020886159e-11, -6.235887670651278e-13,  8.840723544531724e-15, -7.089835612885134e-17,
 -1.980099094570845e-18,  1.253632112874436e-19, -3.992016345656585e-21,  1.666954677903403e+00,  2.977553546719358e-03, -2.697189681168935e-05,  2.516838739058887e-07,
 -2.517426231948194e-09,  2.886949835733739e-11, -3.891636392012998e-13,  5.264541656056584e-15, -3.656536575746866e-17, -1.386151993453512e-18,  7.954727926905793e-20,
 -2.445363925582855e-21,  1.779617584600479e+00,  1.967920334926591e-03, -1.777799212686761e-05,  1.649383180469374e-07, -1.630383462590395e-09,  1.831223717556460e-11,
 -2.402344195353218e-13,  3.151190121459666e-15, -1.984095694911953e-17, -8.986852617795857e-19,  4.905143988367812e-20, -1.476869504750019e-21,  1.865662659431767e+00,
  1.198585416255944e-03, -1.080846851861531e-05,  9.990073995964252e-08, -9.799075243142745e-10,  1.085506530570571e-11, -1.397954969668336e-13,  1.795707195016857e-15,
 -1.056843304241493e-17, -5.351719942204858e-19,  2.836942165673356e-20, -8.429401507206121e-22,  1.928820006115387e+00,  6.347280518759406e-04, -5.716960542383643e-06,
  5.271045926287592e-08, -5.144116127988897e-10,  5.646289468400079e-12, -7.181097926102731e-14,  9.094816636364820e-16, -5.114355041946747e-18, -2.780128410848046e-19,
  1.447673983193613e-20, -4.264816794532590e-22,  1.971348536107286e+00,  2.554007093237003e-04, -2.298656946514609e-06,  2.116099356684737e-08, -2.058611057912088e-10,
  2.246520066861932e-12, -2.834511930571472e-14,  3.557779837114214e-16, -1.943866873634414e-18, -1.103268053829417e-19,  5.684166885543228e-21, -1.665699468613331e-22,
  1.994593870297626e+00,  4.818147864611555e-05, -4.334725241068033e-07,  3.987253592287257e-09, -3.872519240637515e-11,  4.213167352589624e-13, -5.293571324747500e-15,
  6.612875137924981e-17, -3.558854312525256e-19, -2.065106741603313e-20,  1.058231971451234e-21, -3.092544778493801e-23,  1.092555315646276e+00,  7.901033184401841e-03,
 -7.053674472281413e-05,  6.636061456313687e-07, -6.942872240127491e-09,  8.713954273069121e-11, -1.355459017119551e-12,  2.404322076550353e-14, -4.131709687338231e-16,
  5.430718365394960e-18, -1.120627130951199e-20, -2.304549789161841e-21,  1.352981454387167e+00,  5.604022725185866e-03, -4.934105210491760e-05,  4.494092413584763e-07,
 -4.400021463153047e-09,  4.954473554423914e-11, -6.784566103749807e-13,  1.068246422088639e-14, -1.588094070926277e-16,  1.380421026962522e-18,  2.653176655494291e-20,
 -1.795934375940198e-21,  1.537769642221132e+00,  3.992976002672201e-03, -3.493585449503211e-05,  3.138767312484591e-07, -2.989488630654844e-09,  3.209828129304338e-11,
 -4.132887869247892e-13,  6.121364741926710e-15, -8.450609251888119e-17,  5.507563163533767e-19,  2.161880782419130e-20, -1.159999812395345e-21,  1.678451557015497e+00,
  2.773215280550762e-03, -2.417582290939814e-05,  2.155640329501502e-07, -2.022309200754600e-09,  2.113761526288268e-11, -2.622847531105752e-13,  3.738815772244139e-15,
 -4.930981828696250e-17,  2.588734060258542e-19,  1.503669064873853e-20, -7.390056051406823e-22,  1.787216761619224e+00,  1.833195914921755e-03, -1.594409954399138e-05,
  1.414973115715899e-07, -1.315105262679932e-09,  1.351460414750506e-11, -1.636739362729911e-13,  2.273439119659151e-15, -2.908445793727488e-17,  1.294225759754330e-19,
  9.732325254212847e-21, -4.569107756431586e-22,  1.870291302133361e+00,  1.116661765618522e-03, -9.697112226018709e-06,  8.579298061254448e-08, -7.925340602536254e-10,
  8.053595863463350e-12, -9.594002199686800e-14,  1.308829708573557e-15, -1.639817018285120e-17,  6.439018643635244e-20,  5.793866804429544e-21, -2.647403376846559e-22,
  1.931271266014297e+00,  5.913905649255358e-04, -5.130372659519737e-06,  4.529787823411635e-08, -4.167805843784558e-10,  4.203882003983283e-12, -4.952428576070821e-14,
  6.673227861221153e-16, -8.243131937338401e-18,  2.955011240001251e-20,  3.010174203762314e-21, -1.352617383295135e-22,  1.972334893837557e+00,  2.379743779714987e-04,
 -2.063115842560260e-06,  1.819292351215234e-08, -1.669738165864370e-10,  1.676342028556697e-12, -1.960869121191311e-14,  2.621296533284632e-16, -3.208806102111048e-18,
  1.082281816998787e-20,  1.194801106642544e-21, -5.315100359198143e-23,  1.994779949604121e+00,  4.489515193606463e-05, -3.890857403559070e-07,  3.428758375970354e-09,
 -3.142802288032247e-11,  3.147516129549224e-13, -3.667974197558181e-15,  4.882701473908981e-17, -5.948523295332057e-19,  1.940882093365825e-21,  2.236763084797196e-22,
 -9.899321458240006e-24,  1.123078789899487e+00,  7.366825864086852e-03, -6.318763443546220e-05,  5.648992628726148e-07, -5.477839725955213e-09,  6.136690043261610e-11,
 -8.394014369130048e-13,  1.372886922172806e-14, -2.408278312995752e-16,  3.920145129595605e-18, -4.758066944160989e-20,  6.276475822850722e-23,  1.374640646563738e+00,
  5.229739171335744e-03, -4.434045516257569e-05,  3.861433485345225e-07, -3.550484910631118e-09,  3.632700243654657e-11, -4.422597989069911e-13,  6.485397695111534e-15,
 -1.032562672442905e-16,  1.465255831403542e-18, -1.127406569439766e-20, -2.501076111654392e-22,  1.553205339469480e+00,  3.727787664849893e-03, -3.143673890135356e-05,
  2.706947640876696e-07, -2.434315440150445e-09,  2.395283135297391e-11, -2.760361342460665e-13,  3.825504839018115e-15, -5.787505153722971e-17,  7.641969280952022e-19,
 -4.101520421318039e-21, -2.017248717162870e-22,  1.689173251032115e+00,  2.589635774014600e-03, -2.177026342746615e-05,  1.862796109653515e-07, -1.654899681146244e-09,
  1.593219079899717e-11, -1.777536773597157e-13,  2.377378738946503e-15, -3.480703457025326e-17,  4.393138406352762e-19, -1.732097531685186e-21, -1.402234463508284e-22,
  1.794304713940171e+00,  1.712096536467722e-03, -1.436409888742404e-05,  1.224243592044308e-07, -1.079456869706156e-09,  1.025132677805309e-11, -1.119936895885475e-13,
  1.462144392541912e-15, -2.092870321977431e-17,  2.562413158337865e-19, -7.711209194058569e-22, -9.082264860420337e-23,  1.874609026519625e+00,  1.042998847937820e-03,
 -8.738738044345055e-06,  7.428733778884804e-08, -6.518123835653585e-10,  6.134782526593718e-12, -6.607771521109510e-14,  8.483097421889898e-16, -1.195060100881177e-17,
  1.432789012803116e-19, -3.411543163448676e-22, -5.411442209465291e-23,  1.933558032838443e+00,  5.524145172422003e-04, -4.624227577586276e-06,  3.924326578563255e-08,
 -3.432229157461615e-10,  3.211288368283474e-12, -3.426077502656371e-14,  4.347937044811218e-16, -6.057923350051544e-18,  7.159750653639225e-20, -1.404354188583552e-22,
 -2.813486892268608e-23,  1.973255103204454e+00,  2.222996881618067e-04, -1.859800357050501e-06,  1.576628124410917e-08, -1.376160961775865e-10,  1.282802192681900e-12,
 -1.360359513542015e-14,  1.713614908947910e-16, -2.370546964187295e-18,  2.776141535703641e-20, -4.711615045992311e-23, -1.117297326767886e-23,  1.994953553951545e+00,
  4.193894749533452e-05, -3.507643078137008e-07,  2.971914654598916e-09, -2.591323973344053e-11,  2.410839886606670e-13, -2.548470179449772e-15,  3.197594766879649e-17,
 -4.406575830986009e-19,  5.135521535172165e-21, -8.004304529758548e-24, -2.092263026082300e-24,  1.151576034801354e+00,  6.887036737759519e-03, -5.689743658310530e-05,
  4.860945270582936e-07, -4.424814948545896e-09,  4.508096012794083e-11, -5.441970200890599e-13,  7.929929101396922e-15, -1.316507305256452e-16,  2.236766020441438e-18,
 -3.437153966501270e-20,  3.894960722997671e-22,  1.394878207897974e+00,  4.892636430398169e-03, -4.002531999302924e-05,  3.346268178372174e-07, -2.917113645387929e-09,
  2.756377095253031e-11, -2.996934184104599e-13,  3.926350948747288e-15, -5.986104736206105e-17,  9.393083005133648e-19, -1.264877445723949e-20,  8.866874720808586e-23,
  1.567633185590552e+00,  3.488659204847868e-03, -2.840736199403152e-05,  2.352511845045050e-07, -2.013810077839502e-09,  1.842804050988148e-11, -1.910079778114164e-13,
  2.371085243286748e-15, -3.451786609355732e-17,  5.192437751415763e-19, -6.512781187527670e-21,  3.012244394227549e-23,  1.699197021840211e+00,  2.423987770007256e-03,
 -1.968395726610221e-05,  1.621391246702111e-07, -1.374115781730331e-09,  1.235295621293919e-11, -1.245473522280091e-13,  1.495302711945711e-15, -2.112020782519923e-17,
  3.091226321763161e-19, -3.706048243633967e-21,  1.152253491028711e-23,  1.800932183670280e+00,  1.602781199494275e-03, -1.299230663471695e-05,  1.066598857539263e-07,
 -8.983488731003080e-10,  7.987247680956093e-12, -7.911761276878193e-14,  9.288316655859853e-16, -1.284497828213694e-17,  1.844543682942980e-19, -2.144546386160272e-21,
  4.473974196039816e-24,  1.878646609278678e+00,  9.764862450317843e-04, -7.906073810862470e-06,  6.476109736162101e-08, -5.432551550938684e-10,  4.795321637567329e-12,
 -4.694165634820284e-14,  5.426300409124193e-16, -7.392298961882579e-18,  1.047278161791459e-19, -1.191906301775014e-21,  1.646986180989135e-24,  1.935696560049834e+00,
  5.172156267003949e-04, -4.184272629047218e-06,  3.422460409967785e-08, -2.863370167480695e-10,  2.515512772924615e-12, -2.443088498816992e-14,  2.794443848279971e-16,
 -3.767242577754315e-18,  5.287048852320721e-20, -5.929836130836756e-22,  5.355847322971253e-25,  1.974115692978917e+00,  2.081424773497998e-04, -1.683022828017721e-06,
  1.375342166089438e-08, -1.148767561794462e-10,  1.006213966379488e-12, -9.723867392169616e-15,  1.104722161110626e-16, -1.479191985513185e-18,  2.063259252493639e-20,
 -2.292477889900434e-22,  1.370933001213468e-25,  1.995115913885079e+00,  3.926878279439870e-05, -3.174398848533844e-07,  2.592830933657833e-09, -2.163820064327277e-11,
  1.892364559577009e-13, -1.823963271265938e-15,  2.064758758520716e-17, -2.754601945480399e-19,  3.829699418960809e-21, -4.234002118031115e-23,  1.849208372471742e-26,
 -2.006028421461076e+00,  3.749266722374515e-03, -9.173612086133887e-04,  2.282786907897007e-04, -5.775993312436970e-05,  1.485852413370992e-05, -3.886287402277485e-06,
  1.033771145303693e-06, -2.798168290047387e-07,  7.710042418671777e-08, -2.152501576560979e-08,  5.680144174116696e-09, -2.005382545927586e+00,  3.309803145481481e-03,
 -7.633130231267814e-04,  1.793357550641602e-04, -4.296938877247896e-05,  1.051123298706394e-05, -2.628095733598767e-06,  6.724252702643387e-07, -1.762879403178824e-07,
  4.740272544798469e-08, -1.301665771479008e-08,  3.404356463382904e-09, -2.005005720456021e+00,  3.057612312440987e-03, -6.802585613933360e-04,  1.545440925346636e-04,
 -3.592057754111214e-05,  8.557319026143417e-06, -2.093012874188298e-06,  5.264083376871186e-07, -1.363345688963529e-07,  3.639156314094883e-08, -9.964051947928351e-09,
  2.606840881496985e-09, -2.004753770177215e+00,  2.890723427887288e-03, -6.274654509418026e-04,  1.393931783673504e-04, -3.177120321983067e-05,  7.446518512796553e-06,
 -1.798276703991410e-06,  4.481766872754558e-07, -1.154211596078627e-07,  3.073278028429098e-08, -8.415766900560818e-09,  2.205473120814999e-09, -2.004576336438258e+00,
  2.774024735359237e-03, -5.915829292150783e-04,  1.293726909917664e-04, -2.909599115066195e-05,  6.746746930363242e-06, -1.616336890680309e-06,  4.007021105447190e-07,
 -1.029002162939280e-07,  2.737771883523535e-08, -7.503287613198310e-09,  1.969558868047868e-09, -2.004449793282582e+00,  2.691216535712729e-03, -5.666395808072604e-04,
  1.225418411458503e-04, -2.730482802185535e-05,  6.285663800791991e-06, -1.498086328498461e-06,  3.701870367094727e-07, -9.491902750282496e-08,  2.525092739765213e-08,
 -6.926525947887212e-09,  1.820554268216282e-09, -2.004361418631464e+00,  2.633592447897070e-03, -5.495370196724430e-04,  1.179229689980299e-04, -2.610892194010016e-05,
  5.981212580091565e-06, -1.420729215167270e-06,  3.503705110559758e-07, -8.976330778660851e-08,  2.388151377242891e-08, -6.555676607320718e-09,  1.724749644943958e-09,
 -2.004303923563940e+00,  2.596194629491157e-03, -5.385497150515393e-04,  1.149836824803651e-04, -2.535438021627486e-05,  5.790544504110800e-06, -1.372578903122064e-06,
  3.380939940120022e-07, -8.657977117857124e-08,  2.303753853303277e-08, -6.327273835640556e-09,  1.665733264354525e-09, -2.004273154018518e+00,  2.576210106792177e-03,
 -5.327146174780383e-04,  1.134316694779162e-04, -2.495801864384687e-05,  5.690830956043050e-06, -1.347489049832505e-06,  3.317146358184103e-07, -8.492857593800622e-08,
  2.260024833253079e-08, -6.208966783287844e-09,  1.635158383013243e-09, -2.002120406789210e+00,  1.270839935616663e-03, -2.526070900325597e-04,  5.035737018912795e-05,
 -1.006743100812740e-05,  2.018307526782918e-06, -4.057363765630810e-07,  8.178308484699599e-08, -1.652799844178495e-08,  3.348594093311840e-09, -6.790471929838544e-10,
  1.327284504170912e-10, -2.002024146833748e+00,  1.208279007498845e-03, -2.343520442499472e-04,  4.558443227480656e-05, -8.892524363666415e-06,  1.739834266599923e-06,
 -3.414111422813893e-07,  6.719642582232110e-08, -1.326548127460132e-08,  2.626594649845776e-09, -5.208918115336088e-10,  9.978070524253048e-11, -2.001961018943654e+00,
  1.167505649529518e-03, -2.227679930561351e-04,  4.263646856700140e-05, -8.186273404330831e-06,  1.576916674905259e-06, -3.047811833983288e-07,  5.911013456364409e-08,
 -1.150441182789012e-08,  2.247009241291816e-09, -4.398667558417986e-10,  8.329352475467686e-11, -2.001915572219561e+00,  1.138276982975578e-03, -2.146166866975052e-04,
  4.060043663493373e-05, -7.707475721238182e-06,  1.468483619305507e-06, -2.808411045881740e-07,  5.391915568753518e-08, -1.039364851083432e-08,  2.011691211331232e-09,
 -3.904718934387220e-10,  7.339346140035731e-11, -2.001881877305094e+00,  1.116673732660207e-03, -2.086741853478964e-04,  3.913636292009864e-05, -7.367830646856092e-06,
  1.392588189865474e-06, -2.643037789840670e-07,  5.037921047280150e-08, -9.645627460677550e-09,  1.855143503249808e-09, -3.579953989651500e-10,  6.695248235390847e-11,
 -2.001856942908365e+00,  1.100724123420447e-03, -2.043317896573891e-04,  3.807741654079285e-05, -7.124638320210309e-06,  1.338781387220060e-06, -2.526924306545336e-07,
  4.791701889534700e-08, -9.130076410349728e-09,  1.748194944935184e-09, -3.359947241336829e-10,  6.262178499765661e-11, -2.001839064191786e+00,  1.089307083985317e-03,
 -2.012468914377080e-04,  3.733076194612944e-05, -6.954427764239897e-06,  1.301392983186107e-06, -2.446806420183877e-07,  4.622965023330503e-08, -8.779078139432814e-09,
  1.675840162765702e-09, -3.211994563396726e-10,  5.972486911347644e-11, -2.001827221104684e+00,  1.081753171985610e-03, -1.992165917558606e-04,  3.684192549299763e-05,
 -6.843561433498031e-06,  1.277161753999308e-06, -2.395134128764115e-07,  4.514647256294161e-08, -8.554775252680874e-09,  1.629801461226539e-09, -3.118237260469906e-10,
  5.789570446378192e-11, -2.001820813245414e+00,  1.077668977141275e-03, -1.981224407772045e-04,  3.657933438144530e-05, -6.784194409889648e-06,  1.264226140764964e-06,
 -2.367631301086081e-07,  4.457159668525580e-08, -8.436057665700960e-09,  1.605498201241441e-09, -3.068866228041865e-10,  5.693459180151353e-11, -2.000919347524464e+00,
  5.441136152326847e-04, -9.996104990585156e-05,  1.837602585834633e-05, -3.380252144275041e-06,  6.221862803992524e-07, -1.145942090306681e-07,  2.111897590506133e-08,
 -3.894462100176711e-09,  7.185681182513953e-10, -1.325176384014711e-10,  2.367156296478661e-11, -2.000899853487955e+00,  5.316501798033796e-04, -9.657650151674724e-05,
  1.755423204089777e-05, -3.192700085519612e-06,  5.810337457416984e-07, -1.058065392499690e-07,  1.927935505239171e-08, -3.515132761521755e-09,  6.412780779759427e-10,
 -1.169415128085042e-10,  2.067050940373053e-11, -2.000886493628152e+00,  5.231320969793079e-04, -9.429195250718330e-05,  1.700646957480413e-05, -3.069261075603232e-06,
  5.542905109896116e-07, -1.001679491301168e-07,  1.811388317266345e-08, -3.277849410908982e-09,  5.935408894608974e-10, -1.074417988065303e-10,  1.886154469620082e-11,
 -2.000876579127934e+00,  5.168230765893175e-04, -9.261487099380592e-05,  1.660795372595488e-05, -2.980259445593367e-06,  5.351807943544163e-07, -9.617481975673882e-08,
  1.729587369480099e-08, -3.112785838057105e-09,  5.606265415880404e-10, -1.009491672466864e-10,  1.763523941816138e-11, -2.000869062411192e+00,  5.120468744670094e-04,
 -9.135374570397588e-05,  1.631029787788887e-05, -2.914230724702114e-06,  5.210987994726286e-07, -9.325193816975649e-08,  1.670108923055227e-08, -2.993559121463603e-09,
  5.370082326313084e-10, -9.632045267894023e-11,  1.676623330289852e-11, -2.000863406645664e+00,  5.084571231305710e-04, -9.041071963732335e-05,  1.608885910626380e-05,
 -2.865359757829235e-06,  5.107289649982420e-07, -9.111041720389425e-08,  1.626748836716041e-08, -2.907074054930948e-09,  5.199602526594340e-10, -9.299560637777737e-11,
  1.614482135320384e-11, -2.000859301460424e+00,  5.058536767833882e-04, -8.972938739588850e-05,  1.592947877503242e-05, -2.830318167866158e-06,  5.033215477150748e-07,
 -8.958639230997441e-08,  1.596005653926824e-08, -2.845979252361699e-09,  5.079609084859501e-10, -9.066374612585276e-11,  1.571043615236074e-11, -2.000856558900451e+00,
  5.041153903040897e-04, -8.927568474051219e-05,  1.582363037139687e-05, -2.807108123188150e-06,  4.984281558964382e-07, -8.858224754423569e-08,  1.575802210366156e-08,
 -2.805932686211760e-09,  5.001154887285776e-10, -8.914292702043257e-11,  1.542778573287426e-11, -2.000855067211698e+00,  5.031702671826745e-04, -8.902941025073438e-05,
  1.576626993315012e-05, -2.794551062811694e-06,  4.957850682623339e-07, -8.804075284740527e-08,  1.564924761691989e-08, -2.784405923038687e-09,  4.959048289391750e-10,
 -8.832795231643772e-11,  1.527653398336207e-11, -2.000430511340877e+00,  2.534281169334481e-04, -4.494280600952344e-05,  7.971349736203011e-06, -1.414065407945389e-06,
  2.508838740824760e-07, -4.451857633512452e-08,  7.900866093496093e-09, -1.402401314958695e-09,  2.489552900547689e-10, -4.415996057188333e-11,  7.602019776508614e-12,
 -2.000426088866742e+00,  2.506208158205877e-04, -4.420497658745359e-05,  7.798065732037747e-06, -1.375828883602668e-06,  2.427749416076088e-07, -4.284550802261078e-08,
  7.562559798357525e-09, -1.335039613892992e-09,  2.357053180753900e-10, -4.158243154389137e-11,  7.121607596193147e-12, -2.000422997964932e+00,  2.486613208080123e-04,
 -4.369306140002230e-05,  7.678568474773585e-06, -1.349621580673876e-06,  2.372510537334802e-07, -4.171277516256525e-08,  7.334917278359000e-09, -1.289990777906771e-09,
  2.268986477542723e-10, -3.987973172987177e-11,  6.806063564755687e-12, -2.000420671885107e+00,  2.471880721547258e-04, -4.330985136245939e-05,  7.589507897641220e-06,
 -1.330175494586466e-06,  2.331703526541917e-07, -4.087967519985742e-08,  7.168229654494472e-09, -1.257149863482598e-09,  2.205067861338015e-10, -3.864932507039893e-11,
  6.578977156470363e-12, -2.000418889722778e+00,  2.460601232077772e-04, -4.301742973614185e-05,  7.521774150348025e-06, -1.315435560630420e-06,  2.300875782445591e-07,
 -4.025241311392574e-08,  7.043145480869780e-09, -1.232587849292788e-09,  2.157421562248683e-10, -3.773518363669936e-11,  6.410781683520250e-12, -2.000417538051332e+00,
  2.452051011757358e-04, -4.279632638843901e-05,  7.470690666952423e-06, -1.304347414013123e-06,  2.277744802136389e-07, -3.978296007388975e-08,  6.949768706059580e-09,
 -1.214298559612353e-09,  2.122033083799966e-10, -3.705792530700663e-11,  6.286462960181605e-12, -2.000416551129157e+00,  2.445810605208696e-04, -4.263525929421344e-05,
  7.433548930673010e-06, -1.296300854629048e-06,  2.260990897989243e-07, -3.944357959359055e-08,  6.882392160485058e-09, -1.201126774630539e-09,  2.096594626886281e-10,
 -3.657199826270598e-11,  6.197420797197835e-12, -2.000415889045893e+00,  2.441625384954857e-04, -4.252738193421769e-05,  7.408706163461862e-06, -1.290926057216617e-06,
  2.249814982466712e-07, -3.921749507302574e-08,  6.837568058266708e-09, -1.192375554534416e-09,  2.079715951503164e-10, -3.625000460219156e-11,  6.138490427833489e-12,
 -2.000415528007910e+00,  2.439343564404480e-04, -4.246861513376260e-05,  7.395184253188447e-06, -1.288003005288652e-06,  2.243742102649834e-07, -3.909474529747663e-08,
  6.813251553954899e-09, -1.187632050109290e-09,  2.070574568608498e-10, -3.607575695284263e-11,  6.106624337396895e-12, -2.000208573346363e+00,  1.224727387344525e-04,
 -2.135756662342469e-05,  3.724605457233603e-06, -6.495684235606042e-07,  1.132884456268996e-07, -1.975888222995988e-08,  3.446316163988758e-09, -6.011231724406956e-10,
  1.048518821375583e-10, -1.827370185367041e-11,  3.093589353200700e-12, -2.000207518267425e+00,  1.218052467326656e-04, -2.118485726221801e-05,  3.684681980966948e-06,
 -6.408987318693063e-07,  1.114791781963968e-07, -1.939157391987594e-08,  3.373240592245442e-09, -5.868082485453078e-10,  1.020819038171787e-10, -1.774360607071867e-11,
  2.996294197916129e-12, -2.000206773974958e+00,  1.213346703716537e-04, -2.106345840915291e-05,  3.656703249507483e-06, -6.348411623290297e-07,  1.102188333150645e-07,
 -1.913647580837554e-08,  3.322642150764851e-09, -5.769263286653858e-10,  1.001754974411421e-10, -1.737987074930444e-11,  2.929721333196549e-12, -2.000206210073693e+00,
  1.209783096685804e-04, -2.097172287288580e-05,  3.635607006458517e-06, -6.302836691682300e-07,  1.092726704128660e-07, -1.894538848024700e-08,  3.284823190208335e-09,
 -5.695564299769457e-10,  9.875681979493106e-11, -1.710978218706368e-11,  2.880389097838178e-12, -2.000205775818748e+00,  1.207039760343921e-04, -2.090121933579047e-05,
  3.619420399719964e-06, -6.267926536223558e-07,  1.085491248487293e-07, -1.879950508213101e-08,  3.255998959694457e-09, -5.639487381001353e-10,  9.767916053180663e-11,
 -1.690495727635146e-11,  2.843035509647964e-12, -2.000205445172203e+00,  1.204951515493521e-04, -2.084761944729188e-05,  3.607130324547628e-06, -6.241454052629579e-07,
  1.080011601959566e-07, -1.868916422411809e-08,  3.234225253176368e-09, -5.597181238498539e-10,  9.686717909991067e-11, -1.675082421179107e-11,  2.814959903484337e-12,
 -2.000205203045686e+00,  1.203422639480281e-04, -2.080841431492528e-05,  3.598149457932729e-06, -6.222128050577084e-07,  1.076015069798884e-07, -1.860876520693404e-08,
  3.218375199442962e-09, -5.566414158212756e-10,  9.627723061129708e-11, -1.663894449564548e-11,  2.794598920709237e-12, -2.000205040278848e+00,  1.202395016128675e-04,
 -2.078208052933075e-05,  3.592121157787170e-06, -6.209164492367883e-07,  1.073336080232316e-07, -1.855490795948760e-08,  3.207764837774993e-09, -5.545831939778541e-10,
  9.588283963497994e-11, -1.656420107389722e-11,  2.781004902514416e-12, -2.000204951407631e+00,  1.201833980160376e-04, -2.076770946653468e-05,  3.588832733609017e-06,
 -6.202095879916466e-07,  1.071875928663436e-07, -1.852556606256959e-08,  3.201986651065330e-09, -5.534627988758802e-10,  9.566824246998523e-11, -1.652354840145277e-11,
  2.773614046500207e-12, -2.000102684836014e+00,  6.022273414648267e-05, -1.041629249041627e-05,  1.801647638088505e-06, -3.116237393158302e-07,  5.390079800740900e-08,
 -9.323174924566686e-09,  1.612636305733302e-09, -2.789412051951880e-10,  4.824829005782431e-11, -8.338521487103454e-12,  1.400468100116922e-12, -2.000102427059042e+00,
  6.005991875128068e-05, -1.037448668022744e-05,  1.792058428828887e-06, -3.095575392331480e-07,  5.347296668342572e-08, -9.236997962676927e-09,  1.595625920641088e-09,
 -2.756351952550666e-10,  4.761360597444747e-11, -8.218015258962880e-12,  1.378513196778598e-12, -2.000102244387492e+00,  5.994457692611483e-05, -1.034491401191733e-05,
  1.785285249070653e-06, -3.081002848930389e-07,  5.317167490700084e-08, -9.176400184618729e-09,  1.583682468341287e-09, -2.733174288627126e-10,  4.716930968381445e-11,
 -8.133783338367131e-12,  1.363188515910854e-12, -2.000102105531947e+00,  5.985692121133413e-05, -1.032246392531507e-05,  1.780148958582029e-06, -3.069964097334804e-07,
  5.294369392692288e-08, -9.130597145610835e-09,  1.574664816604290e-09, -2.715693578213160e-10,  4.683458482274123e-11, -8.070393466256536e-12,  1.351667463774146e-12,
 -2.000101998330830e+00,  5.978925986642876e-05, -1.030514896297697e-05,  1.776190803502108e-06, -3.061464436956750e-07,  5.276829859714626e-08, -9.095388345284742e-09,
  1.567738731806178e-09, -2.702278573858194e-10,  4.657792539639350e-11, -8.021827920915034e-12,  1.342847589841114e-12, -2.000101916548815e+00,  5.973764902012424e-05,
 -1.029194976216761e-05,  1.773175423620342e-06, -3.054993413277308e-07,  5.263485085380420e-08, -9.068617253998602e-09,  1.562475842212377e-09, -2.692091512511844e-10,
  4.638314864645430e-11, -7.984995415298991e-12,  1.336162520603748e-12, -2.000101856574540e+00,  5.969980436401975e-05, -1.028227577774816e-05,  1.770966442338992e-06,
 -3.050255200457070e-07,  5.253718469347109e-08, -9.049033760134205e-09,  1.558627802105650e-09, -2.684646669518190e-10,  4.624087149330936e-11, -7.958103498809231e-12,
  1.331283845196085e-12, -2.000101816216200e+00,  5.967433946418817e-05, -1.027576853434949e-05,  1.769481065569888e-06, -3.047070184509774e-07,  5.247155604726133e-08,
 -9.035878733000432e-09,  1.556043796663787e-09, -2.679649067141293e-10,  4.614539559361148e-11, -7.940063624315152e-12,  1.328012125326828e-12, -2.000101794166385e+00,
  5.966042730852466e-05, -1.027221419547140e-05,  1.768669904856363e-06, -3.045331222441445e-07,  5.243573155369806e-08, -9.028699360982050e-09,  1.554633870888886e-09,
 -2.676922773153480e-10,  4.609332254740418e-11, -7.930226652347602e-12,  1.326228438953188e-12, -2.000050950143636e+00,  2.986350098780273e-05, -5.144397777697466e-06,
  8.861951239271209e-07, -1.526599661865222e-07,  2.629795382954168e-08, -4.530224717731303e-09,  7.804022492105112e-10, -1.344367334548812e-10,  2.315835420180356e-11,
 -3.986007787918327e-12,  6.668684850836487e-13, -2.000050886429310e+00,  2.982329055603558e-05, -5.134112110098018e-06,  8.838448718424979e-07, -1.521555000598406e-07,
  2.619390063588328e-08, -4.509346484285976e-09,  7.762970555540974e-10, -1.336419694660370e-10,  2.300636793798777e-11, -3.957261999315794e-12,  6.616503149163682e-13,
 -2.000050841177536e+00,  2.979473635725338e-05, -5.126813397438631e-06,  8.821783632878536e-07, -1.517980601037687e-07,  2.612022840869132e-08, -4.494575174063553e-09,
  7.733948007894571e-10, -1.330805124812713e-10,  2.289907799855066e-11, -3.936984867648916e-12,  6.579720056260720e-13, -2.000050806723687e+00,  2.977299819040382e-05,
 -5.121259896411742e-06,  8.809110223103457e-07, -1.515263827510395e-07,  2.606426320550352e-08, -4.483360233054037e-09,  7.711924979399218e-10, -1.326546970117371e-10,
  2.281775238012542e-11, -3.921623166943574e-12,  6.551867816805123e-13, -2.000050780090857e+00,  2.975619604350206e-05, -5.116969172554467e-06,  8.799322598867573e-07,
 -1.513166546334650e-07,  2.602107746326114e-08, -4.474709792938167e-09,  7.694945003768360e-10, -1.323265259979858e-10,  2.275510182322262e-11, -3.909793938813893e-12,
  6.530428643263466e-13, -2.000050759753552e+00,  2.974336648063435e-05, -5.113693951487650e-06,  8.791853830618217e-07, -1.511566658704713e-07,  2.598814425085639e-08,
 -4.468115128899096e-09,  7.682004468549098e-10, -1.320765052354591e-10,  2.270738610133878e-11, -3.900787475594168e-12,  6.514110306728107e-13, -2.000050744828566e+00,
  2.973395169129983e-05, -5.111291047225985e-06,  8.786375592015692e-07, -1.510393444880996e-07,  2.596399979932272e-08, -4.463281521192689e-09,  7.672521891020505e-10,
 -1.318933388960880e-10,  2.267243776201072e-11, -3.894192468913737e-12,  6.502163845847533e-13, -2.000050734780002e+00,  2.972761320905372e-05, -5.109673569717315e-06,
  8.782688625948274e-07, -1.509603982360086e-07,  2.594775562204918e-08, -4.460030066160283e-09,  7.666144270016016e-10, -1.317701691854635e-10,  2.264894085101313e-11,
 -3.889759182699697e-12,  6.494134489991250e-13, -2.000050729288215e+00,  2.972414914965092e-05, -5.108789690462923e-06,  8.780674076015491e-07, -1.509172667466597e-07,
  2.593888172005096e-08, -4.458254043111222e-09,  7.662661029377955e-10, -1.317029051967345e-10,  2.263611035609429e-11, -3.887338641076270e-12,  6.489750954715416e-13,
 -2.000025378002160e+00,  1.487045943329467e-05, -2.556488919317479e-06,  4.395048684137611e-07, -7.555856701261424e-08,  1.298984541091689e-08, -2.233183957363166e-09,
  3.839239929494480e-10, -6.600334457706457e-11,  1.134687626868898e-11, -1.949079224503679e-12,  3.254627653991783e-13, -2.000025362163652e+00,  1.486046766582492e-05,
 -2.553937883804412e-06,  4.389230720141066e-07, -7.543392693743040e-08,  1.296418590645365e-08, -2.228045266890705e-09,  3.829155362696267e-10, -6.580848314582611e-11,
  1.130968374329524e-11, -1.942058334438492e-12,  3.241905683371091e-13, -2.000025350902169e+00,  1.485336387563032e-05, -2.552124850005671e-06,  4.385097386897578e-07,
 -7.534540998849123e-08,  1.294596978110602e-08, -2.224398575506286e-09,  3.822001468978904e-10, -6.567030170287300e-11,  1.128331933222757e-11, -1.937083326343355e-12,
  3.232894014813179e-13, -2.000025342320909e+00,  1.484795108761244e-05, -2.550743763858343e-06,  4.381949652273274e-07, -7.527801827797545e-08,  1.293210483553838e-08,
 -2.221623702194028e-09,  3.816559343675316e-10, -6.556521261345552e-11,  1.126327425091513e-11, -1.933301811044744e-12,  3.226045964870222e-13, -2.000025335683457e+00,
  1.484376457311467e-05, -2.549675783307235e-06,  4.379516043286983e-07, -7.522592653004878e-08,  1.292138988409488e-08, -2.219479702643442e-09,  3.812355374707303e-10,
 -6.548404963167776e-11,  1.124779615313607e-11, -1.930382466209114e-12,  3.220760273042017e-13, -2.000025330612548e+00,  1.484056624892214e-05, -2.548860018923045e-06,
  4.377657455682729e-07, -7.518614955640152e-08,  1.291320931615951e-08, -2.217843080930343e-09,  3.809146790435925e-10, -6.542211376066282e-11,  1.123598663572723e-11,
 -1.928155413163772e-12,  3.216728631415145e-13, -2.000025326889808e+00,  1.483821830070155e-05, -2.548261222319904e-06,  4.376293357357070e-07, -7.515695900965146e-08,
  1.290720668436847e-08, -2.216642326320934e-09,  3.806793003863862e-10, -6.537668367644989e-11,  1.122732537508191e-11, -1.926522258168179e-12,  3.213772458107837e-13,
 -2.000025324382755e+00,  1.483663711939577e-05, -2.547858007918560e-06,  4.375374886082210e-07, -7.513730617559598e-08,  1.290316569554225e-08, -2.215834043849160e-09,
  3.805208698425236e-10, -6.534610784343954e-11,  1.122149657994744e-11, -1.925423282262804e-12,  3.211783360751550e-13, -2.000025323012371e+00,  1.483577283741765e-05,
 -2.547637620329431e-06,  4.374872897581152e-07, -7.512656553010123e-08,  1.290095733586585e-08, -2.215392349074120e-09,  3.804342983421118e-10, -6.532940112112822e-11,
  1.121831187886865e-11, -1.924822862360390e-12,  3.210696681426188e-13, -2.000012664857060e+00,  7.419990327433239e-06, -1.274344928951261e-06,  2.188621759787023e-07,
 -3.758845646440903e-08,  6.455625572688889e-09, -1.108720903983901e-09,  1.904172071131577e-10, -3.270317348007682e-11,  5.616466455836746e-12, -9.637856331111206e-13,
  1.607828929842018e-13, -2.000012660908621e+00,  7.417499939086171e-06, -1.273709696744175e-06,  2.187174406771421e-07, -3.755747892161109e-08,  6.449254354410156e-09,
 -1.107446194868008e-09,  1.901672877450802e-10, -3.265492848063346e-11,  5.607266924636033e-12, -9.620506813847894e-13,  1.604687983605960e-13, -2.000012658099648e+00,
  7.415728311928792e-06, -1.273257883834305e-06,  2.186145157237936e-07, -3.753545407299137e-08,  6.444725294723546e-09, -1.106540220002737e-09,  1.899896953319949e-10,
 -3.262065200219446e-11,  5.600732174724728e-12, -9.608185121067827e-13,  1.602457658503807e-13, -2.000012655958340e+00,  7.414377820757156e-06, -1.272913517980023e-06,
  2.185360782544254e-07, -3.751867155811187e-08,  6.441274705600269e-09, -1.105850071765994e-09,  1.898544284034236e-10, -3.259454816354317e-11,  5.595756200689791e-12,
 -9.598803871232673e-13,  1.600759792781226e-13, -2.000012654301560e+00,  7.413332937095651e-06, -1.272647107205165e-06,  2.184754031754703e-07, -3.750569084019921e-08,
  6.438606067229880e-09, -1.105316376174549e-09,  1.897498366156780e-10, -3.257436612462634e-11,  5.591909455045348e-12, -9.591552319435584e-13,  1.599447498368850e-13,
 -2.000012653035503e+00,  7.412534484599150e-06, -1.272443544274998e-06,  2.184290453898833e-07, -3.749577393109835e-08,  6.436567464663508e-09, -1.104908712853408e-09,
  1.896699505986021e-10, -3.255895255007148e-11,  5.588971826072153e-12, -9.586014998288310e-13,  1.598445498925318e-13, -2.000012652105878e+00,  7.411948213233262e-06,
 -1.272294085102668e-06,  2.183950107949029e-07, -3.748849364980446e-08,  6.435070959338137e-09, -1.104609471794395e-09,  1.896113146248539e-10, -3.254763973837225e-11,
  5.586815879713082e-12, -9.581951363730647e-13,  1.597710210113820e-13, -2.000012651479748e+00,  7.411553346047215e-06, -1.272193425152988e-06,  2.183720896494235e-07,
 -3.748359083585123e-08,  6.434063199590553e-09, -1.104407968852199e-09,  1.895718320191535e-10, -3.254002256794342e-11,  5.585364294569684e-12, -9.579215460490180e-13,
  1.597215185584618e-13, -2.000012651137471e+00,  7.411337491261553e-06, -1.272138400666179e-06,  2.183595604260349e-07, -3.748091091636416e-08,  6.433512364222988e-09,
 -1.104297831491272e-09,  1.895502522130548e-10, -3.253585940070540e-11,  5.584570951280937e-12, -9.577720230938037e-13,  1.596944650825468e-13, -2.000006326407858e+00,
  3.706195673260987e-06, -6.362010504486007e-07,  1.092095039358475e-07, -1.874677221143040e-08,  3.218048504517000e-09, -5.524063781181821e-10,  9.482542311135194e-11,
 -1.627760858321209e-11,  2.794125840166757e-12, -4.792321842735978e-13,  7.990975954210638e-14, -2.000006325422143e+00,  3.705574017166264e-06, -6.360425569290321e-07,
  1.091734089001118e-07, -1.873905050656672e-08,  3.216461122202542e-09, -5.520889373359506e-10,  9.476321543835589e-11, -1.626560561530580e-11,  2.791838165362066e-12,
 -4.788009541864610e-13,  7.983172479045518e-14, -2.000006324720697e+00,  3.705131648901213e-06, -6.359297837731737e-07,  1.091477285014029e-07, -1.873355728160393e-08,
  3.215331962051254e-09, -5.518631516017888e-10,  9.471897316082266e-11, -1.625706986137002e-11,  2.790211466180374e-12, -4.784943473097120e-13,  7.977624647623342e-14,
 -2.000006324185870e+00,  3.704794363505990e-06, -6.358438051811680e-07,  1.091281510077983e-07, -1.872936979597244e-08,  3.214471261570860e-09, -5.516910584756373e-10,
  9.468525413621140e-11, -1.625056482239691e-11,  2.788971854244873e-12, -4.782607160256977e-13,  7.973397525569809e-14, -2.000006323771997e+00,  3.704533360225191e-06,
 -6.357772753347893e-07,  1.091130028150264e-07, -1.872612987428325e-08,  3.213805359087426e-09, -5.515579212529080e-10,  9.465916928660875e-11, -1.624553282288053e-11,
  2.788012997364393e-12, -4.780800084003576e-13,  7.970128117625564e-14, -2.000006323455692e+00,  3.704333887873897e-06, -6.357264317522227e-07,  1.091014266912884e-07,
 -1.872365405184365e-08,  3.213296522623021e-09, -5.514561911050953e-10,  9.463923865334785e-11, -1.624168818073553e-11,  2.787280423045328e-12, -4.779419518491918e-13,
  7.967630457321253e-14, -2.000006323223417e+00,  3.704187409310228e-06, -6.356890968816556e-07,  1.090929265004095e-07, -1.872183614353947e-08,  3.212922913356010e-09,
 -5.513814987747058e-10,  9.462460562063718e-11, -1.623886553695213e-11,  2.786742600818648e-12, -4.778406001499791e-13,  7.965796897206986e-14, -2.000006323066964e+00,
  3.704088745921469e-06, -6.356639498057748e-07,  1.090872012785978e-07, -1.872061173493592e-08,  3.212671283145438e-09, -5.513311936902545e-10,  9.461475052276274e-11,
 -1.623696457513484e-11,  2.786380402201978e-12, -4.777723458787811e-13,  7.964562129437980e-14, -2.000006322981434e+00,  3.704034809132714e-06, -6.356502027125567e-07,
  1.090840715262538e-07, -1.871994240803978e-08,  3.212533730507890e-09, -5.513036949844808e-10,  9.460936341652477e-11, -1.623592546347882e-11,  2.786182418320693e-12,
 -4.777350374355423e-13,  7.963887201846233e-14, -2.000003161700672e+00,  1.852149254578674e-06, -3.178581036518473e-07,  5.454947796678135e-08, -9.361553280120497e-09,
  1.606590637696953e-09, -2.757163711213217e-10,  4.731729079475985e-11, -8.120389921276905e-12,  1.393552866473792e-12, -2.389543839572435e-13,  3.983513059916231e-14,
 -2.000003161454417e+00,  1.851993957979842e-06, -3.178185195074637e-07,  5.454046527948778e-08, -9.359625681010931e-09,  1.606194467727502e-09, -2.756371649327592e-10,
  4.730177276230633e-11, -8.117396432745973e-12,  1.392982466520708e-12, -2.388468883056820e-13,  3.981568268847042e-14, -2.000003161279156e+00,  1.851883433134123e-06,
 -3.177903486887857e-07,  5.453405152184326e-08, -9.358253994350583e-09,  1.605912564748531e-09, -2.755808067319300e-10,  4.729073160651890e-11, -8.115266649787587e-12,
  1.392576661799922e-12, -2.387704152479650e-13,  3.980184792625129e-14, -2.000003161145511e+00,  1.851799153908212e-06, -3.177688681286276e-07,  5.452916112560530e-08,
 -9.357208138743627e-09,  1.605697632411943e-09, -2.755378387972650e-10,  4.728231402851440e-11, -8.113642996837738e-12,  1.392267304621657e-12, -2.387121195022597e-13,
  3.979130196136688e-14, -2.000003161042083e+00,  1.851733930262056e-06, -3.177522447606124e-07,  5.452537664540791e-08, -9.356398814325318e-09,  1.605531313598311e-09,
 -2.755045902412873e-10,  4.727580068263181e-11, -8.112386680883276e-12,  1.392027942986418e-12, -2.386670149964154e-13,  3.978314255037793e-14, -2.000003160963033e+00,
  1.851684079752379e-06, -3.177395397511940e-07,  5.452248427728945e-08, -9.355780283575840e-09,  1.605404206052158e-09, -2.754791808629721e-10,  4.727082312059334e-11,
 -8.111426611323081e-12,  1.391845027847010e-12, -2.386325477683753e-13,  3.977690754123110e-14, -2.000003160904981e+00,  1.851647471259759e-06, -3.177302097692070e-07,
  5.452036028524442e-08, -9.355326076291303e-09,  1.605310868243183e-09, -2.754605224901582e-10,  4.726716809970051e-11, -8.110721643435564e-12,  1.391710717417398e-12,
 -2.386072396462618e-13,  3.977232944896544e-14, -2.000003160865877e+00,  1.851622812081695e-06, -3.177239252363887e-07,  5.451892961192778e-08, -9.355020135724954e-09,
  1.605247999331302e-09, -2.754479550312582e-10,  4.726470626475010e-11, -8.110246818231219e-12,  1.391620254721301e-12, -2.385901939365406e-13,  3.976924600988075e-14,
 -2.000003160844500e+00,  1.851609331244477e-06, -3.177204895902227e-07,  5.451814749255398e-08, -9.354852885482201e-09,  1.605213630659225e-09, -2.754410847993511e-10,
  4.726336046646880e-11, -8.109987249776489e-12,  1.391570802615901e-12, -2.385808758343186e-13,  3.976756044662041e-14,     0.993666579802855,     0.998804898671247,
     0.984267449412615,     0.970313432980018,     0.951311416761951,     0.926448393893101,     0.894319392537825,     0.852180867920722,     0.792962933247458,
     0.996840366968178,     0.999403779573482,     0.992151430877466,     0.985190487807033,     0.975711923376745,     0.963310812919827,      0.94728744835143,
     0.926275581514132,     0.896754715776694,     0.998421826216932,     0.999702199171119,     0.996079810491916,     0.992603011828689,      0.98786879396959,
     0.981674977001245,     0.973672195673312,     0.963178280316848,     0.948435433377731,     0.999211310297771,     0.999851174462944,     0.998040893606542,
     0.996303375746258,     0.993937474556125,     0.990842159331722,     0.986842849683837,     0.981598659887931,     0.974231201939397,     0.999605752876647,
     0.999925605663817,     0.999020689772748,     0.998152146930157,     0.996969491482549,      0.99542222160711,     0.993423070455702,     0.990801640661725,
     0.987118855112389,      0.99980290068071,     0.999962807405343,     0.999510405130939,     0.999076187214275,     0.998484932457698,     0.997711393179357,
      0.99671194153104,      0.99540138970407,     0.993560227117687,     0.999901456377654,     0.999981404841772,     0.999755217565416,     0.999538121919646,
     0.999242512682429,     0.998855766801585,     0.998356071715316,     0.997700836177632,     0.996780311742236,     0.999950729695263,     0.999990702705133,
     0.999877612525108,      0.99976906802248,     0.999621267926652,      0.99942790090642,     0.999178061017561,     0.998850453294257,     0.998390205206015,
     0.999975365223881,     0.999995351423563,      0.99993880719721,     0.999884535774978,     0.999810636856205,     0.999713954823723,     0.999589036789107,
     0.999425235432822,     0.999195114910513,     0.999987682705958,     0.999997675729522,     0.999969403832151,     0.999942268328183,     0.999905319150888,
     0.999856978503755,     0.999794519963431,     0.999712619910881,     0.999597560528864,     0.999993841376478,     0.999998837869195,     0.999984701974447,
     0.999971134274235,     0.999952659756086,     0.999928489524759,     0.999897260373785,     0.999856310503814,     0.999798781032426  };
  constexpr double w[4743] = {  1.606342004371624e-01, -6.969470197134132e-02,  1.622290446851340e-02, -2.567922171457861e-03,  3.075728641087094e-04,
 -2.962059762324588e-05,  2.385082038020534e-06, -1.650132014362181e-07,  1.000835599602844e-08, -5.404121866191245e-10,  2.629640407706245e-11, -1.162801837264591e-12,
  1.610344316748730e-01, -6.651734413355145e-02,  1.473258773561397e-02, -2.227627069981703e-03,  2.559795861730660e-04, -2.374844126084197e-05,  1.849087247082407e-06,
 -1.241229254138106e-07,  7.326401243811381e-09, -3.860354014949594e-10,  1.837514912540838e-11, -7.966103400835801e-13,  1.613723581947300e-01, -6.011510924165901e-02,
  1.203258376489230e-02, -1.659067862838003e-03,  1.754540997593933e-04, -1.510745944145942e-05,  1.099994170225801e-06, -6.951570355719501e-08,  3.886190797464932e-09,
 -1.949802648422470e-10,  8.879950834603737e-12, -3.699632581613936e-13,  1.604902421017985e-01, -5.059178739967597e-02,  8.662565413810643e-03, -1.038525178753125e-03,
  9.693127050793217e-05, -7.462993051035718e-06,  4.914581349897676e-07, -2.837278984717387e-08,  1.461873040803472e-09, -6.813362788808930e-11,  2.902854418003774e-12,
 -1.138741204314290e-13,  1.561801000421197e-01, -3.856787962705146e-02,  5.324284572401750e-03, -5.283483896454074e-04,  4.171068396070490e-05, -2.765621584486018e-06,
  1.592565000132474e-07, -8.146523293907817e-09,  3.762311701529959e-10, -1.587891263403742e-11,  6.182485796506150e-13, -2.235003584096677e-14,  1.450446815941452e-01,
 -2.553219769100566e-02,  2.665507877365120e-03, -2.079445334138131e-04,  1.328645584055255e-05, -7.296580219297411e-07,  3.547166585779824e-08, -1.556919609665876e-09,
  6.257175944318096e-11, -2.326852462264955e-12,  8.071394350952369e-14, -2.626115450040825e-15,  1.231575629880723e-01, -1.377116538037239e-02,  1.013945979946573e-03,
 -5.880774905849634e-05,  2.898203234609856e-06, -1.262777694795226e-07,  4.983163674755709e-09, -1.809878913601760e-10,  6.119529584722682e-12, -1.942640106333859e-13,
  5.827760369043799e-15, -1.659485751200640e-16,  8.791176984443196e-02, -5.485959660788619e-03,  2.617578678859723e-04, -1.055541971482587e-05,  3.782442240009131e-07,
 -1.239134054876703e-08,  3.776628095079307e-10, -1.083419624063448e-11,  2.949786227619668e-13, -7.669249673537833e-15,  1.913066264368559e-16, -4.593118402475542e-18,
  4.046266644527510e-02, -1.347151453775019e-03,  3.659240556578297e-05, -9.143674211201783e-07,  2.157980578514499e-08, -4.864977709815542e-10,  1.055412988975365e-11,
 -2.215393773263778e-13,  4.518430230135253e-15, -8.983476642994158e-17,  1.745541656295751e-18, -3.320316754069572e-20,  2.336569129138076e-02, -1.010922405583958e-02,
  2.346260676743242e-03, -3.703666607976111e-04,  4.424748709738066e-05, -4.251188378449499e-06,  3.415657166871261e-07, -2.358386823166899e-08,  1.427737495332241e-09,
 -7.695865437581299e-11,  3.738756065869092e-12, -1.650757858615412e-13,  2.644867422856383e-02, -1.076835296076023e-02,  2.351319787734224e-03, -3.509593962098814e-04,
  3.986380102291210e-05, -3.660089549525483e-06,  2.823322540583402e-07, -1.879352795141681e-08,  1.100923893087303e-09, -5.761269176549404e-11,  2.725358066140953e-12,
 -1.174875737788425e-13,  3.312965072169698e-02, -1.189819159208631e-02,  2.300820317403527e-03, -3.076156048503000e-04,  3.165223345342407e-05, -2.659593357283434e-06,
  1.894563750403007e-07, -1.173981232925831e-08,  6.447667427504511e-10, -3.183514982529103e-11,  1.428942611651213e-12, -5.875439939461820e-14,  4.403630688342138e-02,
 -1.299118958178361e-02,  2.096447940559530e-03, -2.385754372925213e-04,  2.126356427668784e-05, -1.571113847067247e-06,  9.970730140716307e-08, -5.567374518482971e-09,
  2.783049781130982e-10, -1.261894507170750e-11,  5.243076546028650e-13, -2.010203783058044e-14,  5.874311506640935e-02, -1.314841852698147e-02,  1.670754131066273e-03,
 -1.542864676619622e-04,  1.142944950526061e-05, -7.158501750483425e-07,  3.915227186177703e-08, -1.911078507589791e-09,  8.455690738812898e-11, -3.431075544411501e-12,
  1.288375608402425e-13, -4.504712020990311e-15,  7.370512974989468e-02, -1.144405248729814e-02,  1.081438848357612e-03, -7.741247844681755e-05,  4.582466857790593e-06,
 -2.348835730593252e-07,  1.072177297912109e-08, -4.441155564684793e-10,  1.691781284574573e-11, -5.985949021371733e-13,  1.982409959363979e-14, -6.177400144186815e-16,
  8.073088405723088e-02, -7.850966247490817e-03,  5.202832511076767e-04, -2.753715262152329e-05,  1.249960241375323e-06, -5.051347700997782e-08,  1.859216238251890e-09,
 -6.327841003330568e-11,  2.013094977826244e-12, -6.034367649737720e-14,  1.714861020038637e-15, -4.639650486304464e-17,  6.947774587901691e-02, -3.811753794779404e-03,
  1.645794033961568e-04, -6.080422314506970e-06,  2.010795112835750e-07, -6.111745579484610e-09,  1.735646327504466e-10, -4.656152824002660e-12,  1.189191987009703e-13,
 -2.908386101152778e-15,  6.841636308645671e-17, -1.552728927311671e-18,  3.559746004619199e-02, -1.093091597172212e-03,  2.741001999254562e-05, -6.350167330340693e-07,
  1.395370171664274e-08, -2.938659348142186e-10,  5.970866658151084e-12, -1.176279730155146e-13,  2.255525669584007e-15, -4.222480395448771e-17,  7.735970560542792e-19,
 -1.389291982600436e-20,  3.423277025538829e-03, -1.476043093204919e-03,  3.413756203796272e-04, -5.371087595158860e-05,  6.397462158441229e-06, -6.129530750910092e-07,
  4.912334145403296e-08, -3.383873110682920e-09,  2.044145972715351e-10, -1.099654158615003e-11,  5.332416207435596e-13, -2.350375026064997e-14,  4.493833736181395e-03,
 -1.796801583361719e-03,  3.854957510821933e-04, -5.663412787172342e-05,  6.342528994754953e-06, -5.750519690683694e-07,  4.386240921740571e-08, -2.890455164603693e-09,
  1.677974170602881e-10, -8.709729693454926e-12,  4.089871970268980e-13, -1.751400828575870e-14,  7.299953439479275e-03, -2.507300202315156e-03,  4.652606313290793e-04,
 -5.997333174924701e-05,  5.974715858588768e-06, -4.878145201340224e-07,  3.386977197917123e-08, -2.051061278905410e-09,  1.103399580980764e-10, -5.347144324426601e-12,
  2.359833560704009e-13, -9.555460832159493e-15,  1.331272163571549e-02, -3.635618140379987e-03,  5.484434803087743e-04, -5.884725952784915e-05,  4.979617942096176e-06,
 -3.513067315944056e-07,  2.138851547829155e-08, -1.150349393478341e-09,  5.558262487831672e-11, -2.443447852364462e-12,  9.869527796695001e-14, -3.687589546604513e-15,
  2.443946329097121e-02, -4.907889640319839e-03,  5.703869328799205e-04, -4.876504163000334e-05,  3.374692525184693e-06, -1.988488823914259e-07,  1.029104594613751e-08,
 -4.776387607988595e-10,  2.017964600726007e-11, -7.847607414806436e-13,  2.833421326201993e-14, -9.554257106504791e-16,  4.073082808407086e-02, -5.545364646347118e-03,
  4.733037189604952e-04, -3.103067129923899e-05,  1.698815478438701e-06, -8.112920936863888e-08,  3.471027502785080e-09, -1.354330107026592e-10,  4.880668849702100e-12,
 -1.639902167500819e-13,  5.174817431604427e-15, -1.541265560873279e-16,  5.595422095882663e-02, -4.734059446029273e-03,  2.829692939704558e-04, -1.368870894131607e-05,
  5.729420939474451e-07, -2.149142526457601e-08,  7.381226409855205e-10, -2.354591671014887e-11,  7.047627984221368e-13, -1.994308525085234e-14,  5.366438716930579e-16,
 -1.378676683787351e-17,  5.646847254791228e-02, -2.740297074344278e-03,  1.075124876973584e-04, -3.652367991870093e-06,  1.118112531463928e-07, -3.161358467930631e-09,
  8.384062584083491e-11, -2.107314908610895e-12,  5.057065571132106e-14, -1.165039701586252e-15,  2.587523025024366e-17, -5.556340313400904e-19,  3.162021960503489e-02,
 -9.008979448702575e-04,  2.095790205063635e-05, -4.519792310066031e-07,  9.279493984636318e-09, -1.831494059440283e-10,  3.495785778825374e-12, -6.481737427684041e-14,
  1.171622094961663e-15, -2.070446105118334e-17,  3.585054324740851e-19, -6.092507142952727e-21,  5.059303399017108e-04, -2.172319024235569e-04,  5.002667835680809e-05,
 -7.839937350219117e-06,  9.304445249505548e-07, -8.885532141992660e-08,  7.099765504940647e-09, -4.877329715396426e-10,  2.938941700818824e-11, -1.577371220203318e-12,
  7.632703749455150e-14, -3.357683172393185e-15,  7.958662912464533e-04, -3.110252044808957e-04,  6.528594658193699e-05, -9.405980225233126e-06,  1.035355995785129e-06,
 -9.244692931483569e-08,  6.956268674849418e-09, -4.528846413279819e-10,  2.600743042174637e-11, -1.336869051038009e-12,  6.222806555027228e-14, -2.643819430732995e-15,
  1.744202119430927e-03, -5.674560394349100e-04,  1.002584669573283e-04, -1.237920185537354e-05,  1.187413556787643e-06, -9.375012211077940e-08,  6.317618572965661e-09,
 -3.724808927822493e-10,  1.956214682981015e-11, -9.276543224928724e-13,  4.014419729664336e-14, -1.596903165713880e-15,  4.457103507343857e-03, -1.113690447110249e-03,
  1.557542749670086e-04, -1.565186187443839e-05,  1.250238033180229e-06, -8.379004500232607e-08,  4.871630135202132e-09, -2.513277613055350e-10,  1.169308193398338e-11,
 -4.966194517556078e-13,  1.943697675613500e-14, -7.055878841156090e-16,  1.121285722779651e-02, -2.000871754631436e-03,  2.115415775331762e-04, -1.667159252482113e-05,
  1.073694144271903e-06, -5.931241013064531e-08,  2.895058825495165e-09, -1.273670197743357e-10,  5.122829818745618e-12, -1.903789477456393e-13,  6.590830229607765e-15,
 -2.137535692001362e-16,  2.428419156443157e-02, -2.885556668079596e-03,  2.222513681265816e-04, -1.333393628065815e-05,  6.744890374296337e-07, -2.997977819182159e-08,
  1.200789830175163e-09, -4.407686858299628e-11,  1.500605740698466e-12, -4.780896952625133e-14,  1.435234724594107e-15, -4.079104385147763e-17,  4.068880286088448e-02,
 -2.998888755938848e-03,  1.621226204292072e-04, -7.183303353493093e-06,  2.776745235019772e-07, -9.679610716984082e-09,  3.104883496608692e-10, -9.288729451814386e-12,
  2.616730728105260e-13, -6.991222728311099e-15,  1.781241083366234e-16, -4.344300657049235e-18,  4.698729165714308e-02, -2.029280913821387e-03,  7.263774513085401e-05,
 -2.277083342105385e-06,  6.472971470035168e-08, -1.707016335201682e-09,  4.237483221970898e-11, -9.999305577803220e-13,  2.258657780738987e-14, -4.909114592152281e-16,
  1.030762192870224e-17, -2.096650284019330e-19,  2.832083403848655e-02, -7.526572618817603e-04,  1.631735028225468e-05, -3.288015098447757e-07,  6.327784076093577e-09,
 -1.173939253315081e-10,  2.110802268666894e-12, -3.693314239213016e-14,  6.308861232791894e-16, -1.055009827217882e-17,  1.729855568428946e-19, -2.790296909274531e-21,
  7.557780019149653e-05, -3.228080930121301e-05,  7.394881982325431e-06, -1.153299220243448e-06,  1.362768988914965e-07, -1.296291716398204e-08,  1.032082807493273e-09,
 -7.067198808713531e-11,  4.245964726127294e-12, -2.272739784909082e-13,  1.097037828351853e-14, -4.815026252103114e-16,  1.482827684962008e-04, -5.629016173523416e-05,
  1.149789342093149e-05, -1.617141199434103e-06,  1.742819388200204e-07, -1.527466603029031e-08,  1.130600755200121e-09, -7.253973119410735e-11,  4.111786885035458e-12,
 -2.089117640180121e-13,  9.623197240091550e-15, -4.050293263323617e-16,  4.566018667511430e-04, -1.391284440638358e-04,  2.320002207954474e-05, -2.724161547359409e-06,
  2.500510489061730e-07, -1.898983913246265e-08,  1.236220759129004e-09, -7.066873897749021e-11,  3.609814223515876e-12, -1.669490586241034e-13,  7.062965381333596e-15,
 -2.752597871283876e-16,  1.657523226226759e-03, -3.743598173850344e-04,  4.815057972881108e-05, -4.502528409891299e-06,  3.376271174750160e-07, -2.139007023595181e-08,
  1.182352893072338e-09, -5.827117924915007e-11,  2.600619212411227e-12, -1.063336964834196e-13,  4.019358306610449e-15, -1.413241254031909e-16,  5.645321791805835e-03,
 -8.872605908761992e-04,  8.498209850271397e-05, -6.152856425810853e-06,  3.676605140956319e-07, -1.898704019463807e-08,  8.716876632001040e-10, -3.625501009148541e-11,
  1.384625382891270e-12, -4.904785305434975e-14,  1.624059818126888e-15, -5.053545302471920e-17,  1.549420765916950e-02, -1.601257078001220e-03,  1.113313169501598e-04,
 -6.112102479181636e-06,  2.856169294428901e-07, -1.181106234492516e-08,  4.426222008373626e-10, -1.527316994333293e-11,  4.907912360212840e-13, -1.481144745267684e-14,
  4.225244302615565e-16, -1.144490645682624e-17,  3.083135770451599e-02, -1.983640365837635e-03,  9.729640800779609e-05, -3.958336879511444e-06,  1.415892176795764e-07,
 -4.593977330359505e-09,  1.377934505137681e-10, -3.869639704701114e-12,  1.026715790612270e-13, -2.591167420470821e-15,  6.252661774713815e-17, -1.447855311242011e-18,
  3.988114988043504e-02, -1.542150078808682e-03,  5.055627915009870e-05, -1.467508039725413e-06,  3.885339691141685e-08, -9.581986604968819e-10,  2.231648426474161e-11,
 -4.954174374136058e-13,  1.055253511775301e-14, -2.167366898222597e-16,  4.308396314072168e-18, -8.311912613105310e-20,  2.554850887209914e-02, -6.363419240919632e-04,
  1.290976462630054e-05, -2.439021356463890e-07,  4.413191084165306e-09, -7.717144238861097e-11,  1.310507390145616e-12, -2.169368769017157e-14,  3.508981719284784e-16,
 -5.571469974018325e-18,  8.645335126563574e-20, -1.332175678322597e-21,  1.144229392621503e-05, -4.854594485563143e-06,  1.104749375144771e-06, -1.712655994388717e-07,
  2.012898219456930e-08, -1.905551456687005e-09,  1.510656782115841e-10, -1.030428631119945e-11,  6.169180233582222e-13, -3.291707847697740e-14,  1.584294378554603e-15,
 -6.935309058400422e-17,  2.939084966354965e-05, -1.075105697592894e-05,  2.122533533685837e-06, -2.897868348545001e-07,  3.043253689193192e-08, -2.607451356694268e-09,
  1.891889785343442e-10, -1.192636019622218e-11,  6.655257292154604e-13, -3.334542503395622e-14,  1.516943818516425e-15, -6.313637874346561e-17,  1.322382166973237e-04,
 -3.725085790607046e-05,  5.806730293583875e-06, -6.433915490063187e-07,  5.614402744521455e-08, -4.077953792982823e-09,  2.551678691752897e-10, -1.407960027660244e-11,
  6.966948440260721e-13, -3.131046681848317e-14,  1.290695875918304e-15, -4.913320410475896e-17,  6.850100640506110e-04, -1.381345521471680e-04,  1.622011641952189e-05,
 -1.403062634934038e-06,  9.826736354095898e-08, -5.858473836752250e-09,  3.065928097730471e-10, -1.437895019393502e-11,  6.133510071814276e-13, -2.406131270365947e-14,
  8.755580906724759e-16, -2.972739922808924e-17,  3.099084604504215e-03, -4.256214632817221e-04,  3.682947404246800e-05, -2.443819225002292e-06,  1.351933842944323e-07,
 -6.513088507317797e-09,  2.806491214531791e-10, -1.101176229423827e-11,  3.984798935949882e-13, -1.342587171897916e-14,  4.242802568552710e-16, -1.263964247635426e-17,
  1.049594386219136e-02, -9.411136520520217e-04,  5.914744610876422e-05, -2.973625342613873e-06,  1.284243347630734e-07, -4.941755280132988e-09,  1.732637621217878e-10,
 -5.618791871526587e-12,  1.703463833155552e-13, -4.866662119081629e-15,  1.318278792557900e-16, -3.400248109918344e-18,  2.419914495526505e-02, -1.362731607292267e-03,
  6.085225894052083e-05, -2.279378580442001e-06,  7.561091985592598e-08, -2.287456972387839e-09,  6.425113578592656e-11, -1.695777672424453e-12,  4.241744389961603e-14,
 -1.011942975865967e-15,  2.314055216868578e-17, -5.089286587426097e-19,  3.442313148646975e-02, -1.198860420032191e-03,  3.612654796948076e-05, -9.741765610399051e-07,
  2.409220867925483e-08, -5.570813173694097e-10,  1.220070834579387e-11, -2.553397072441698e-13,  5.138028277262906e-15, -9.989612456421626e-17,  1.882749322998903e-18,
 -3.449504056057899e-20,  2.319271369826297e-02, -5.436778597939580e-04,  1.036069368494401e-05, -1.841154630963699e-07,  3.140932449027740e-09, -5.190352090397245e-11,
  8.343022933162565e-13, -1.310646257932688e-14,  2.006611343113398e-16, -3.050181500987455e-18,  4.448582021088653e-20, -6.562161154501817e-22,  1.762070561339388e-06,
 -7.410968599509480e-07,  1.672286424895827e-07, -2.572973323723753e-08,  3.003914378232599e-09, -2.826972837973029e-10,  2.229402734181971e-11, -1.513585831924542e-12,
  9.023862029781537e-14, -4.796696760520863e-15,  2.300745708727069e-16, -1.004035847168341e-17,  6.279184495397002e-06, -2.190446036855672e-06,  4.144769960548193e-07,
 -5.455404050339652e-08,  5.550646022384910e-09, -4.626610662509681e-10,  3.276945315905051e-11, -2.022349911479647e-12,  1.107509766065502e-13, -5.457072968090655e-15,
  2.445767103294579e-16, -1.004473183072999e-17,  4.271863705948980e-05, -1.096425702598844e-05,  1.581755659390167e-06, -1.640556119291156e-07,  1.351771425858652e-08,
 -9.335142355800903e-10,  5.585177435181107e-11, -2.960677960240471e-12,  1.413154689657790e-13, -6.147558988173152e-15,  2.460550119573598e-16, -9.119555423089809e-18,
  3.139568350405452e-04, -5.584639792435978e-05,  5.949134804139928e-06, -4.736259560919511e-07,  3.084650489587091e-08, -1.723620191932699e-09,  8.508285965118185e-11,
 -3.783883100894314e-12,  1.537538832098019e-13, -5.768536271568125e-15,  2.014577567605062e-16, -6.585631882990852e-18,  1.841468148226916e-03, -2.194706606982479e-04,
  1.713449024061835e-05, -1.040512744414055e-06,  5.321784621913173e-08, -2.388324643999668e-09,  9.644838593652662e-11, -3.564436406283880e-12,  1.220151375218304e-13,
 -3.903533974985854e-15,  1.175260720100289e-16, -3.345976322938152e-18,  7.492836045675236e-03, -5.820070640131263e-04,  3.313960873713092e-05, -1.527755547840690e-06,
  6.103805051962870e-08, -2.186993691790096e-09,  7.176801522787712e-11, -2.187620803668078e-12,  6.257151603644994e-14, -1.691907015128439e-15,  4.350262885401134e-17,
 -1.067937038509995e-18,  1.957367217312354e-02, -9.677604050602922e-04,  3.948174308615206e-05, -1.365573774812651e-06,  4.210608364682857e-08, -1.190041506510772e-09,
  3.135424130407888e-11, -7.787708512284524e-13,  1.838697036835541e-14, -4.150197549039821e-16,  9.000651431690605e-18, -1.881404800485306e-19,  3.013992912254319e-02,
 -9.508096741491913e-04,  2.642722257658273e-05, -6.640590625183222e-07,  1.538324123509649e-08, -3.343476054856644e-10,  6.901073117893275e-12, -1.364478062894583e-13,
  2.598175668784730e-15, -4.790470670506243e-17,  8.574621126475691e-19, -1.493232476082957e-20,  2.117089089283321e-02, -4.688479146785198e-04,  8.421793300037227e-06,
 -1.411900853639085e-07,  2.276729144515815e-09, -3.564888985106119e-11,  5.428677360696365e-13, -8.147944908090874e-15,  1.170178729217339e-16, -1.731620850321741e-18,
  2.392487503338833e-20, -3.126571299735582e-22,  2.773984808460215e-07, -1.153214703751392e-07,  2.573700883666628e-08, -3.921714175575250e-09,  4.540058192186237e-10,
 -4.241210957852566e-11,  3.323066304584891e-12, -2.243190206471997e-13,  1.330564529932533e-14, -7.040522115362754e-16,  3.363188491096348e-17, -1.462274494779066e-18,
  1.467655398207311e-06, -4.818242890758702e-07,  8.649296598068446e-08, -1.088512114449591e-08,  1.065720529549834e-09, -8.592114459786670e-11,  5.911372448988578e-12,
 -3.556275943766821e-13,  1.904164596138707e-14, -9.196877665379782e-16,  4.049205353892033e-17, -1.636834450287838e-18,  1.548269152528343e-05, -3.563835660367117e-06,
  4.710931227517086e-07, -4.537494158095566e-08,  3.506678215849567e-09, -2.288948097653310e-10,  1.302559875779967e-11, -6.601921026074707e-13,  3.026379839236463e-14,
 -1.269303903890360e-15,  4.914618428750731e-17, -1.767441468072027e-18,  1.588826901963328e-04, -2.464154088557954e-05,  2.369901475039344e-06, -1.729379446414291e-07,
  1.043623820254974e-08, -5.447448195179932e-10,  2.528380318806121e-11, -1.063025519155182e-12,  4.102569961852451e-14, -1.467839652748904e-15,  4.906113279515257e-17,
 -1.539977229295508e-18,  1.175164297201069e-03, -1.208184073616935e-04,  8.511665912767381e-06, -4.727789293347654e-07,  2.234271345184210e-08, -9.333560545974859e-10,
  3.529313794869201e-11, -1.227255531465678e-12,  3.969481972921664e-14, -1.204315366212805e-15,  3.449798485588176e-17, -9.372830284636908e-19,  5.598644935964171e-03,
 -3.764253726777379e-04,  1.947745699677372e-05, -8.248543569776137e-07,  3.052888017777186e-08, -1.019554463217279e-09,  3.134046630271174e-11, -8.983576822994267e-13,
  2.425091555453061e-14, -6.207028136941659e-16,  1.514749843356645e-17, -3.538770753190688e-19,  1.624463360183341e-02, -7.075768738513258e-04,  2.646633489577071e-05,
 -8.477700970845284e-07,  2.435696104967129e-08, -6.443893364919221e-10,  1.595519690180521e-11, -3.734220747609737e-13,  8.334593446079261e-15, -1.781782995571728e-16,
  3.666786516372844e-18, -7.295399831079528e-20,  2.671436115695389e-02, -7.675380563942152e-04,  1.974060303081335e-05, -4.635720886384549e-07,  1.008564553030618e-08,
 -2.065584242199421e-10,  4.025940255314385e-12, -7.537833762763116e-14,  1.360325700713249e-15, -2.381686617739978e-17,  4.060404847480217e-19, -6.719725534066285e-21,
  1.942032566199051e-02, -4.076813657492515e-04,  6.924647973026220e-06, -1.098289752292553e-07,  1.677524592109998e-09, -2.498622440702834e-11,  3.589588198806859e-13,
 -5.238953275490658e-15,  6.919463295267636e-17, -9.850763229241665e-19,  1.478879775172320e-20, -1.219037545688990e-22,  4.495966102440380e-08, -1.839655172605126e-08,
  4.045925559074477e-09, -6.087594106569174e-10,  6.971369854566375e-11, -6.451783268322923e-12,  5.014125083798530e-13, -3.360701897465936e-14,  1.980960376697658e-15,
 -1.042389857346627e-16,  4.954777055684921e-18, -2.144755771276955e-19,  3.813310722952017e-07, -1.158746672884524e-07,  1.949734985573388e-08, -2.323844560867180e-09,
  2.172165661186194e-10, -1.682677820808636e-11,  1.118139432717122e-12, -6.524945558889821e-14,  3.401168766058266e-15, -1.604128694792104e-16,  6.914914896693966e-18,
 -2.743124797373501e-19,  6.312877207534641e-06, -1.281585667312164e-06,  1.537926080498979e-07, -1.365431992633503e-08,  9.835082391596816e-10, -6.034060024038839e-11,
  3.249503021038619e-12, -1.567432897935306e-13,  6.871155993098595e-15, -2.767366521044682e-16,  1.032688067293821e-17, -3.591127598556565e-19,  8.822684116359537e-05,
 -1.179973127975383e-05,  1.021427431547507e-06, -6.811259694490220e-08,  3.798497886621865e-09, -1.847359976644489e-10,  8.041910239333661e-12, -3.188442718387119e-13,
  1.165834036644269e-14, -3.968010208698617e-16,  1.266218476055879e-17, -3.807122061021498e-19,  7.991718879047959e-04, -7.050999953527353e-05,  4.489618602637487e-06,
 -2.281445232905804e-07,  9.963539999066836e-09, -3.873569054440498e-10,  1.371112637685343e-11, -4.483495010633248e-13,  1.369282728086467e-14, -3.936568139141731e-16,
  1.071808667266460e-17, -2.776070008402818e-19,  4.351863102868779e-03, -2.532159368393390e-04,  1.194937896723638e-05, -4.658563411926520e-07,  1.600072523918248e-08,
 -4.986532617657818e-10,  1.437705237219795e-11, -3.877701207034968e-13,  9.885449159126750e-15, -2.396619441303543e-16,  5.550154103181599e-18, -1.234314843207527e-19,
  1.378156975222734e-02, -5.307740489238197e-04,  1.826490389323558e-05, -5.434352695815906e-07,  1.458534802888424e-08, -3.618475542827625e-10,  8.439502687140940e-12,
 -1.863037564220037e-13,  3.936678006549901e-15, -7.989818999156987e-17,  1.558446160205840e-18, -2.958060961707127e-20,  2.392832505690124e-02, -6.294044932830706e-04,
  1.502486912799881e-05, -3.306395352459768e-07,  6.772171015789292e-09, -1.310370073899707e-10,  2.415276828894562e-12, -4.292960428957449e-14,  7.359780333971092e-16,
 -1.222068665316959e-17,  1.995555673262200e-19, -3.140504941495476e-21,  1.789264521057801e-02, -3.571348547205421e-04,  5.752641687465236e-06, -8.656405003651251e-08,
  1.253236475933924e-09, -1.791020052791408e-11,  2.386993258602416e-13, -3.486455512559494e-15,  4.338077362389600e-17, -4.702513752660334e-19,  1.149035334341294e-20,
 -4.832228495051923e-23,  7.578251656031351e-09, -3.032522296372168e-09,  6.537933511779723e-10, -9.673255122976511e-11,  1.092163387600374e-11, -9.986462642222701e-13,
  7.681263505949686e-14, -5.102444752599359e-15,  2.984232176118124e-16, -1.559583521370278e-17,  7.368349956571598e-19, -3.172411834595055e-20,  1.118867022687152e-07,
 -3.083723339573330e-08,  4.798200715503907e-09, -5.358885052662804e-10,  4.740712807629126e-11, -3.502592993158848e-12,  2.233684017057219e-13, -1.257364721276015e-14,
  6.349391167463373e-16, -2.911668876779769e-17,  1.224172370954648e-18, -4.749466248279430e-20,  2.893642825196494e-06, -5.092566806845513e-07,  5.504708776376709e-08,
 -4.475471218919089e-09,  2.987851357212510e-10, -1.714309023511106e-11,  8.696163113012386e-13, -3.974820693603641e-14,  1.659502180531811e-15, -6.393554389549514e-17,
  2.291115968233853e-18, -7.677608300985210e-20,  5.335314155754881e-05, -6.089679707480408e-06,  4.739972525973077e-07, -2.882488547618817e-08,  1.483089613362773e-09,
 -6.707943000708333e-11,  2.733840094973188e-12, -1.020187568364399e-13,  3.527140484387026e-15, -1.139748767614777e-16,  3.465197849329195e-18, -9.959257583971501e-20,
  5.748007411486970e-04, -4.332460472354257e-05,  2.500811218451650e-06, -1.163458879240653e-07,  4.699677751540050e-09, -1.700584227591184e-10,  5.636766915891824e-12,
 -1.733081989868326e-13,  4.995591473461525e-15, -1.360651266142028e-16,  3.518689326100528e-18, -8.681871774375742e-20,  3.500063140561236e-03, -1.762819922227179e-04,
  7.618055506672787e-06, -2.740189447270520e-07,  8.754436727108989e-09, -2.548163514961714e-10,  6.904489603715249e-12, -1.753794193796877e-13,  4.222151751554240e-15,
 -9.717021529684092e-17,  2.134172287370741e-18, -4.517812947118897e-20,  1.191436701249078e-02, -4.072588767580162e-04,  1.293640691164157e-05, -3.585079679312271e-07,
  9.015016758055576e-09, -2.099456335888828e-10,  4.627227867212769e-12, -9.647106547816801e-14,  1.927308622590140e-15, -3.740939626428208e-17,  6.890706490695107e-19,
 -1.245164151412092e-20,  2.162833781453365e-02, -5.234147725920690e-04,  1.163002903979825e-05, -2.404667229458666e-07,  4.645942929605630e-09, -8.519085561850298e-11,
  1.486425018518001e-12, -2.511123246966812e-14,  4.117514342126661e-16, -6.435656887122697e-18,  1.012921200645751e-19, -1.532125738687558e-21,  1.655001690107122e-02,
 -3.149532704698054e-04,  4.823287050503533e-06, -6.909717347733129e-08,  9.451685572003069e-10, -1.320857691369629e-11,  1.585757977674017e-13, -2.284776535765672e-15,
  3.417393696376859e-17, -5.902720965490530e-20,  8.722603182528662e-21, -9.521584108543399e-23,  1.348028938735481e-09, -5.223265328447546e-10,  1.095475750831381e-10,
 -1.584431733515295e-11,  1.755573971174959e-12, -1.580156506498207e-13,  1.199296195643422e-14, -7.876199020177740e-16,  4.561373586387453e-17, -2.363489886637425e-18,
  1.108304245848807e-19, -4.740395496938876e-21,  3.758467417714196e-08, -9.172391814666179e-09,  1.301161991526428e-09, -1.346534704990296e-10,  1.117039663687781e-11,
 -7.809610987403298e-13,  4.747016414221766e-14, -2.562101663257372e-15,  1.246693337948983e-16, -5.532142610279236e-18,  2.258863591392093e-19, -8.538325257342907e-21,
  1.485031998917947e-06, -2.226419870343749e-07,  2.156060300968907e-08, -1.596379413971602e-09,  9.833790624526002e-11, -5.253875169534212e-12,  2.500395160184987e-13,
 -1.078832886698108e-14,  4.273968463871099e-16, -1.569605910946001e-17,  5.382941029916406e-19, -1.732595726571657e-20,  3.484700348494051e-05, -3.360729288395166e-06,
  2.355594546186757e-07, -1.304559268479666e-08,  6.189758790678695e-10, -2.600279123880477e-11,  9.910597974078148e-13, -3.476679305120105e-14,  1.134758977633285e-15,
 -3.476330878526670e-17,  1.005333119823475e-18, -2.757247979244401e-20,  4.341884264730869e-04, -2.784218642761062e-05,  1.463565332328777e-06, -6.238465700653028e-08,
  2.335443552524731e-09, -7.865589506294535e-11,  2.443378964561745e-12, -7.069573031344772e-14,  1.921434564123549e-15, -4.962052478507560e-17,  1.218384942371905e-18,
 -2.861291716198379e-20,  2.898914427279173e-03, -1.264453783028413e-04,  5.027259162705611e-06, -1.671463436597751e-07,  4.984486331271745e-09, -1.354956578102193e-10,
  3.457763418567422e-12, -8.299172536760100e-14,  1.879346197543672e-15, -4.127710812095071e-17,  8.604530648298849e-19, -1.726443461158957e-20,  1.046815281542406e-02,
 -3.188079354112513e-04,  9.378495252259366e-06, -2.426323763251863e-07,  5.739195572750109e-09, -1.254149547868162e-10,  2.619540194178635e-12, -5.193537518999088e-14,
  9.686579378575187e-16, -1.826611455733534e-17,  3.191993980111774e-19, -5.348035926276303e-21,  1.970411157269802e-02, -4.407712304213658e-04,  9.139897395960658e-06,
 -1.780386376628300e-07,  3.248794140945325e-09, -5.665420752767874e-11,  9.378388841570087e-13, -1.497555280046529e-14,  2.392007004228261e-16, -3.472190960229567e-18,
  5.223126428533754e-20, -7.909363475459981e-22,  1.536246307292629e-02, -2.794453851058624e-04,  4.076755223360946e-06, -5.590059722012157e-08,  7.145116641372095e-10,
 -1.004666238187747e-11,  1.100160901532413e-13, -1.167930385711801e-15,  3.703166435904653e-17,  1.737567787550537e-19,  2.029355086106434e-21, -2.168417106974362e-22,
  2.585008168843679e-10, -9.546934464296380e-11,  1.926039233314347e-11, -2.700354272763809e-12,  2.917350138475901e-13, -2.571682696866505e-14,  1.918145885275261e-15,
 -1.241315759320833e-16,  7.099184303810793e-18, -3.638916751685502e-19,  1.690456125139921e-20, -7.171467600795765e-22,  1.459478555095314e-08, -3.067808346969169e-09,
  3.915027111552296e-10, -3.712347615129997e-11,  2.861736280453247e-12, -1.878234036505964e-13,  1.080568978909393e-14, -5.557006671016859e-16,  2.590861415740320e-17,
 -1.106847763759436e-18,  4.368931021623191e-20, -1.602223338230465e-21,  8.475001571271850e-07, -1.063194461964526e-07,  9.207286861194133e-09, -6.179158017300948e-10,
  3.501576983737532e-11, -1.736005227816348e-12,  7.725812204116642e-14, -3.136863059114708e-15,  1.175406582399056e-16, -4.102130228653028e-18,  1.342258638149175e-19,
 -4.137234959367579e-21,  2.437602773766554e-05, -1.966596267482229e-06,  1.247041932686258e-07, -6.279726185655210e-09,  2.750719933909745e-10, -1.072383003757680e-11,
  3.819040307106963e-13, -1.259502155533905e-14,  3.874523183208941e-16, -1.124428877849791e-17,  3.089843505559807e-19, -8.073308125599881e-21,  3.422572063207836e-04,
 -1.859464151110426e-05,  8.959816684603694e-07, -3.498262071352003e-08,  1.218356163323384e-09, -3.818721009352252e-11,  1.111237162813713e-12, -3.039268637639085e-14,
  7.760598948393845e-16, -1.903148371771145e-17,  4.446927619779048e-19, -9.897316186838401e-21,  2.462541093476545e-03, -9.307468908250945e-05,  3.423293560087195e-06,
 -1.052482750667115e-07,  2.946265981401114e-09, -7.476651777480672e-11,  1.792528748552293e-12, -4.122678720884111e-14,  8.660478216809847e-16, -1.823437801339005e-17,
  3.669131733024041e-19, -6.776441150232655e-21,  9.326514695285042e-03, -2.540359275966260e-04,  6.944945944252870e-06, -1.678941650834738e-07,  3.757608626567481e-09,
 -7.702318549372919e-11,  1.515703360123508e-12, -2.938588518046102e-14,  4.945699454082239e-16, -9.102766709949749e-18,  1.616512253002758e-19, -2.196191910020864e-21,
  1.807487729006536e-02, -3.753930522226854e-04,  7.281532586672313e-06, -1.340280185409995e-07,  2.310854323024005e-09, -3.841553579286719e-11,  6.094119020507231e-13,
 -8.978452725901346e-15,  1.445340898384235e-16, -1.961580424502578e-18,  2.560163461154324e-20, -4.733525260012079e-22,  1.430591652839051e-02, -2.493346088366775e-04,
  3.468350671617782e-06, -4.594104964120988e-08,  5.380503877740584e-10, -7.658968361344218e-12,  9.483422584648651e-14,  1.112791243777666e-16,  4.199724512953732e-17,
  1.241058392895774e-20, -1.167967710615648e-20, -4.390305280418731e-22,  5.510271737320204e-11, -1.890718351620089e-11,  3.610212328799127e-12, -4.848677490706606e-13,
  5.062094367952853e-14, -4.339946074947804e-15,  3.163666574348313e-16, -2.008507739945709e-17,  1.130253719472103e-18, -5.714155092170543e-20,  2.623227719148620e-21,
 -1.101515872501808e-22,  6.578592518288188e-09, -1.154024255671240e-09,  1.311973085030615e-10, -1.127702893053556e-11,  8.012181370185006e-13, -4.899595233377427e-14,
  2.649857848154526e-15, -1.290489935236302e-16,  5.732258818827520e-18, -2.345423337983165e-19,  8.906689152860776e-21, -3.155108483190739e-22,  5.332191453874720e-07,
 -5.490334480995435e-08,  4.268005020159212e-09, -2.583389270759529e-10,  1.345192105140767e-11, -6.174225370892071e-13,  2.561880997097348e-14, -9.770117801418715e-16,
  3.452664829794254e-17, -1.142199547539238e-18,  3.557214824891481e-20, -1.046927863452336e-21,  1.811524246049759e-05, -1.209142053664376e-06,  7.001389231417922e-08,
 -3.195153677086997e-09,  1.296034370895349e-10, -4.692300875252807e-12,  1.556529689403901e-13, -4.842994748354896e-15,  1.400698567789669e-16, -3.845525031925350e-18,
  1.006406879155104e-19, -2.492169766608811e-21,  2.799573119070164e-04, -1.282444755841943e-05,  5.719581387803120e-07, -2.039572330401791e-08,  6.645824986358179e-10,
 -1.945172998214239e-11,  5.252253240934971e-13, -1.378722358519127e-14,  3.286748124956026e-16, -7.588935297920132e-18,  1.729875758014327e-19, -3.529793347213692e-21,
  2.138014697214362e-03, -7.003907620578929e-05,  2.400429631859921e-06, -6.807621771392602e-08,  1.801578700215656e-09, -4.298427234515791e-11,  9.447860249480720e-13,
 -2.166978721870171e-14,  4.163482187251096e-16, -7.995563357755236e-18,  1.758141083499581e-19, -2.500061770024916e-21,  8.410033354031572e-03, -2.056187150654067e-04,
  5.245818846799047e-06, -1.183707108834600e-07,  2.522373476197780e-09, -4.899380160470947e-11,  8.731767831997166e-13, -1.770919812898296e-14,  2.651650064793022e-16,
 -4.013158199395733e-18,  1.048195642375103e-19, -5.482493920368484e-22,  1.668043988497922e-02, -3.229992016012731e-04,  5.872045670814398e-06, -1.024830080180384e-07,
  1.670886099834727e-09, -2.634292799262801e-11,  4.133337378707304e-13, -5.324360613999808e-15,  8.760807686747667e-17, -1.327217293711592e-18,  6.351171644001590e-21,
 -4.366869318515410e-22,  1.336077247836358e-02, -2.236574460826388e-04,  2.964065977627315e-06, -3.843025760920284e-08,  4.086550874944299e-10, -5.197569745726873e-12,
  1.159357373389926e-13,  1.327243917179354e-15,  2.826813434651907e-17, -9.668610929783967e-19, -4.077408865610736e-20, -9.014338517135559e-22,  1.362425292360874e-11,
 -4.164376404159594e-12,  7.362841655778714e-13, -9.319552712855227e-14,  9.290266677446227e-15, -7.674498155579915e-16,  5.427454624850677e-17, -3.360424175821309e-18,
  1.851772808871027e-19, -9.197483018433700e-21,  4.159040401080811e-22, -1.723949317772910e-23,  3.436388249869877e-09, -4.847064922329235e-10,  4.900867849276999e-11,
 -3.777304449443023e-12,  2.457803776670548e-13, -1.391450470337429e-14,  7.028998612833643e-16, -3.224112623739241e-17,  1.356907167986919e-18, -5.290522735491373e-20,
  1.923897603108135e-21, -6.552898371144578e-23,  3.664145836128065e-07, -3.026058268056735e-08,  2.139134275317673e-09, -1.159491160365361e-10,  5.549827928047459e-12,
 -2.360224575403964e-13,  9.085021373365864e-15, -3.256857896134820e-16,  1.083014066384979e-17, -3.383576215848715e-19,  1.003840059281396e-20, -2.807043317429501e-22,
  1.419784946129568e-05, -7.731566111487686e-07,  4.156740308938354e-08, -1.707690424638640e-09,  6.429143751689169e-11, -2.182034041174481e-12,  6.649500007718679e-14,
 -1.971618821830383e-15,  5.380697757303447e-17, -1.371195646107069e-18,  3.508238589196621e-20, -8.077611362205306e-22,  2.364818977050600e-04, -9.072702388343631e-06,
  3.800764191338154e-07, -1.230247517105744e-08,  3.755562902778586e-10, -1.050152531715184e-11,  2.533901341282944e-13, -6.555279383640660e-15,  1.505536042963178e-16,
 -2.940985721285870e-18,  7.526720479742633e-20, -1.325515773964176e-21,  1.891706092294561e-03, -5.367152473301456e-05,  1.731582717340839e-06, -4.507861825345207e-08,
  1.126308737578085e-09, -2.630694089025547e-11,  4.899151949461562e-13, -1.177012352707018e-14,  2.344258784578357e-16, -2.559349619623293e-18,  1.059466459184518e-19,
 -1.161327780829610e-21,  7.663374204527382e-03, -1.687157178877863e-04,  4.038448263277066e-06, -8.486589476084899e-08,  1.716386819526747e-09, -3.313444626771686e-11,
  4.799665149041145e-13, -1.075866883098710e-14,  1.924171928824894e-16, -1.090566782680791e-19,  9.044664338954973e-20, -6.102417032574088e-22,  1.547520005928253e-02,
 -2.805243095228649e-04,  4.786888239036617e-06, -7.947025579582543e-08,  1.232605228316542e-09, -1.793844475411207e-11,  2.964478536797261e-13, -3.274050565732486e-15,
  3.978386006667773e-17, -1.449654214300284e-18, -1.128494487422859e-20, -2.450981905277545e-22,  1.251079487824949e-02, -2.016852661557487e-04,  2.539230890868009e-06,
 -3.255827090379155e-08,  3.358828673369308e-10, -1.912343774747481e-12,  1.578213191985009e-13,  1.280260137601305e-15, -4.561259250788347e-17, -3.372062714697922e-18,
 -7.366398247247692e-20,  5.475839432902334e-24,  4.125030244189362e-12, -1.047966410108909e-12,  1.674047145385270e-13, -1.953990090603467e-14,  1.831973969973757e-15,
 -1.440719179850189e-16,  9.790207389311913e-18, -5.866573857738056e-19,  3.145843832926107e-20, -1.527197633701250e-21,  6.773681560777065e-23, -2.761816872194729e-24,
  2.067114924758161e-09, -2.235207403938358e-10,  2.039483494421249e-11, -1.391466049914189e-12,  8.251687614394647e-14, -4.312926475091108e-15,  2.019612649168228e-16,
 -8.693673337648774e-18,  3.451013940624432e-19, -1.274390100855436e-20,  4.425759846717101e-22, -1.441960472132403e-23,  2.725255029829565e-07, -1.749825922434139e-08,
  1.156085584851884e-09, -5.558556489113061e-11,  2.434216285640416e-12, -9.723427549211285e-14,  3.424997029823742e-15, -1.155411899111161e-16,  3.654080166557741e-18,
 -1.054955121774088e-19,  3.021735145935992e-21, -8.080137514212037e-23,  1.166144296643352e-05, -5.079333434340863e-07,  2.604386347548582e-08, -9.572137886032346e-10,
  3.298035453897122e-11, -1.091458254808112e-12,  2.956628200479576e-14, -8.256349379550464e-16,  2.299544853636869e-17, -4.856453470201105e-19,  1.265956931726097e-20,
 -3.221191672952517e-22,  2.054628606161830e-04, -6.534547964506115e-06,  2.624901344358518e-07, -7.697079158668619e-09,  2.139377909558439e-10, -6.157951350615945e-12,
  1.249230390049594e-13, -2.951572413328664e-15,  8.664276149854823e-17, -9.214390737388424e-19,  2.688691509795573e-20, -1.151259996659531e-21,  1.701683745603603e-03,
 -4.171261401168480e-05,  1.283200466131241e-06, -3.072556493948232e-08,  6.951723154679164e-10, -1.771471761702183e-11,  2.566907058582329e-13, -5.043750320005820e-15,
  2.029770075613478e-16,  2.314199283886154e-19,  1.494091482973500e-20, -3.685899324951975e-21,  7.047273951614554e-03, -1.400615927060943e-04,  3.164739947829934e-06,
 -6.216906283943942e-08,  1.148153826982848e-09, -2.451525878621933e-11,  2.687594783725312e-13, -4.071796910863156e-15,  2.385058919456586e-16,  1.937209001944018e-18,
 -2.433151072357832e-20, -5.498888530400756e-21,  1.442409365024032e-02, -2.457334086758607e-04,  3.940907745852978e-06, -6.226138628341532e-08,  9.380850235531276e-10,
 -1.183145176996233e-11,  2.140983497986817e-13, -2.925093761788213e-15, -2.002922484216811e-17, -1.742805021460105e-18,  1.020938550590817e-20,  1.617801559086681e-21,
  1.174233396317873e-02, -1.828443827162404e-04,  2.180203523187047e-06, -2.727672712528649e-08,  3.370184383658411e-10,  2.009549930667888e-12,  1.513266275141025e-13,
 -2.606576799070775e-15, -2.066150703567362e-16, -4.727299382334654e-18,  5.972799176985161e-20,  7.291825808030801e-21,  1.619815198293586e-12, -3.056137322871384e-13,
  4.360660355776590e-14, -4.556633555308355e-15,  3.949333752172342e-16, -2.916490624772588e-17,  1.880459248961777e-18, -1.080586982898484e-19,  5.594637120754621e-21,
 -2.636298655094653e-22,  1.141112579622528e-23, -4.555700098570906e-25,  1.418385650893107e-09, -1.098879500996039e-10,  9.443502821401870e-12, -5.626538423189087e-13,
  3.002495113099752e-14, -1.465812325898431e-15,  6.283770334265665e-17, -2.519948856377264e-18,  9.521518873127253e-20, -3.275099585079293e-21,  1.081385787206027e-22,
 -3.425135368976628e-24,  2.175760987403353e-07, -1.037898419480770e-08,  6.705191172682573e-10, -2.862956548895866e-11,  1.105438133883643e-12, -4.346442602709334e-14,
  1.388758213150846e-15, -4.165586305417794e-17,  1.372431773501859e-18, -3.525440280878807e-20,  8.570996351145656e-22, -2.880854285677012e-23,  9.984414780434283e-06,
 -3.380001468869662e-07,  1.710967047565101e-08, -5.721487373932222e-10,  1.674640534652061e-11, -5.894265053958301e-13,  1.467122652024939e-14, -2.969783325550643e-16,
  1.157686853933933e-17, -2.253012743058452e-19,  1.022440160972873e-21, -2.185352896679081e-22,  1.830105333928826e-04, -4.754315155661024e-06,  1.870626832453188e-07,
 -5.119249902690358e-09,  1.155737613501098e-10, -3.864116034284267e-12,  7.695936146742976e-14, -6.123046592866786e-16,  5.898174129829728e-17, -1.028651998590610e-18,
 -3.435908889460781e-20, -1.330968804261265e-21,  1.553263312826913e-03, -3.275768670227929e-05,  9.705235295677869e-07, -2.213718187657827e-08,  3.948561786171475e-10,
 -1.251224917677236e-11,  2.062855022920419e-13,  1.313244002995088e-15,  1.728515777413363e-16, -3.429148576118373e-18, -2.073075308645303e-19, -4.486875135775895e-21,
  6.533333044984437e-03, -1.174506036190699e-04,  2.513822034115632e-06, -4.739317517848592e-08,  7.177785696664313e-10, -1.852672736599162e-11,  2.674795036955342e-13,
  3.912353485869845e-15,  2.177583486287089e-16, -5.292024984288989e-18, -3.425911482079916e-19, -5.532496269531354e-21,  1.349982129571631e-02, -2.169558500369503e-04,
  3.276842140491290e-06, -4.889570489827530e-08,  7.456093369178528e-10, -7.799098776415879e-12,  1.154115768403482e-13, -4.301168967525286e-15, -5.076300024859760e-17,
  8.678850287410046e-19,  1.318744322405052e-19,  2.912031862464722e-21,  1.104390149228126e-02, -1.666162157615697e-04,  1.887098115879527e-06, -2.140553896616887e-08,
  4.032064989640911e-10,  3.896213100442430e-12, -3.210684713566503e-14, -1.069994231356386e-14, -2.346071329390336e-16,  6.212979405609815e-18,  4.989913215280797e-19,
  7.882712608422569e-21,  8.572029684137719e-13, -1.003989483487624e-13,  1.340551233618662e-14, -1.204360141132373e-15,  9.417396690190096e-17, -6.491578751571075e-18,
  3.901825983205758e-19, -2.120664794857268e-20,  1.055880044160060e-21, -4.778510649583543e-23,  1.997768271961105e-24, -7.820152872485679e-26,  1.096310830380665e-09,
 -5.497423163233908e-11,  4.818857533218369e-12, -2.537911811205932e-13,  1.148053192695697e-14, -5.452350096333528e-16,  2.178758880615875e-17, -7.536130461901754e-19,
  2.849897013644397e-20, -9.628684511882879e-22,  2.548816077306231e-23, -8.605821822387671e-25,  1.849628040096744e-07, -6.144324073731468e-09,  4.093684518649215e-10,
 -1.640633150635672e-11,  4.963344704403501e-13, -2.015754604621614e-14,  6.813487749437407e-16, -1.348369668634010e-17,  4.791713559581538e-19, -1.925502353114967e-20,
  1.241059080084095e-22, -3.332436425481445e-24,  8.868077731779374e-06, -2.248138456566907e-07,  1.151836821139556e-08, -3.815537871156400e-10,  7.989681078829868e-12,
 -3.028523886518976e-13,  1.028837879485582e-14, -6.331969738499201e-17,  2.522381743107944e-18, -2.987554706883579e-19, -1.758764061540189e-21,  1.804191463622459e-22,
  1.666346517472560e-04, -3.477338294089244e-06,  1.344936561513033e-07, -3.790514600998782e-09,  5.628837058838699e-11, -2.055370390531210e-12,  7.831543070607422e-14,
  3.455694034103710e-16, -9.871909566655805e-18, -2.715518519740370e-18, -1.837364116160414e-20,  2.874682574558376e-21,  1.436207390310327e-03, -2.596585249471125e-05,
  7.354536124334928e-07, -1.753077416217333e-08,  1.996157459626667e-10, -6.672235537048421e-12,  2.893164012630280e-13,  3.101981140650153e-15, -1.119072192806482e-16,
 -1.141791162047254e-17, -4.706570937382210e-20,  1.460242304816523e-20,  6.100391537008216e-03, -9.944532691308672e-05,  2.003041841411199e-06, -3.847602417355533e-08,
  4.232707367391938e-10, -1.028121510159909e-11,  4.260860861787262e-13,  5.083506120809518e-15, -2.185124156853187e-16, -1.685684073352214e-17, -1.209244898428209e-20,
  2.365579187332460e-20,  1.268098295156473e-02, -1.928963920860669e-04,  2.756894039948006e-06, -3.810679964880328e-08,  6.068922238939311e-10, -6.588369273333267e-12,
 -1.487696253503375e-14, -4.269618441405274e-15,  8.772406771292893e-17,  6.425542455090052e-18,  6.127568944463812e-20, -8.321303373156670e-21,  1.040616500018863e-02,
 -1.524321284377322e-04,  1.671068941610988e-06, -1.448575899878817e-08,  4.461807196279959e-10, -9.655593038785881e-13, -3.742269505407540e-13, -1.061403136917695e-14,
  3.491219147093851e-16,  2.333972368603045e-17,  4.183289509291035e-20, -3.336029689490180e-20,  6.049246058784810e-13, -3.269088658011034e-14,  4.935749867867448e-15,
 -3.766485712304637e-16,  2.445292670008464e-17, -1.603863878890464e-18,  9.103035385772311e-20, -4.428221769598819e-21,  2.098076714251319e-22, -9.502366968782956e-24,
  3.685226853781355e-25, -1.325068779274854e-26,  9.377399566511024e-10, -2.615615179073006e-11,  2.591751867258487e-12, -1.346025541363058e-13,  4.513230235068223e-15,
 -1.989186311190641e-16,  9.323149404614739e-18, -2.522480889316369e-19,  6.228666759025092e-21, -3.656805895332700e-22,  1.095156688217785e-23,  2.838426770825724e-26,
  1.658453313371339e-07, -3.547282627343964e-09,  2.494217136410531e-10, -1.090675684942302e-11,  2.324938131925321e-13, -7.206481554115520e-15,  4.220441980765013e-16,
 -8.046179919808111e-18, -8.226333061940711e-20, -9.095331172380606e-21,  5.182609572430842e-22,  1.310178013485950e-23,  8.126685695591327e-06, -1.491842326152964e-07,
  7.548776250281606e-09, -2.893256955630599e-10,  4.263206413376362e-12, -7.794391402848940e-14,  8.068805744958908e-15, -1.434724187350846e-16, -6.255019109977999e-18,
 -7.933354899562163e-20,  1.372206604191227e-20,  2.768489494334707e-22,  1.546074616390174e-04, -2.570474271112583e-06,  9.339035290762877e-08, -3.115136746467992e-09,
  3.419834318460334e-11, -1.831667336144472e-13,  6.967706067049484e-14, -1.355393127722842e-15, -8.024596071427263e-17, -2.472093631241533e-21,  1.495200421787868e-19,
  1.976094654761285e-21,  1.342845392446505e-03, -2.087699545568721e-05,  5.411186554220761e-07, -1.500966897644475e-08,  1.390078949847526e-10,  5.524940043484058e-13,
  2.702438022483492e-13, -5.917694977437404e-15, -3.699609102409060e-16,  2.134623107554160e-18,  6.621053688262680e-19,  5.264667531279485e-21,  5.731881396975376e-03,
 -8.516457065429864e-05,  1.577060836852813e-06, -3.276566213111993e-08,  3.251420869229149e-10,  3.550991811887896e-13,  3.918994167184733e-13, -9.412478131369158e-15,
 -5.514531604959907e-16,  5.498685425043112e-18,  9.858427388768599e-19,  3.395807641910956e-21,  1.195083104854000e-02, -1.725156008797939e-04,  2.353371604863992e-06,
 -2.950226649140802e-08,  4.644101822513899e-10, -7.853738623888419e-12, -6.211294203752467e-14,  1.807181429912136e-15,  2.492123148222064e-16, -7.293229535702946e-19,
 -4.002840047214050e-19, -5.045948543510376e-21,  9.822237613346826e-03, -1.396425465228433e-04,  1.537654505445105e-06, -8.058253563617063e-09,  3.225870880139964e-10,
 -1.154299974771792e-11, -4.052334231463325e-13,  1.105464194639385e-14,  8.167250510889350e-16, -7.658103913187862e-18, -1.399089523784822e-18, -6.061062568844227e-21,
  5.314523117862768e-13, -6.464859160930943e-15,  1.999916567179781e-15, -1.550535927719281e-16,  7.057548790443763e-18, -3.846272778326377e-19,  2.493009225323179e-20,
 -1.160227050430420e-21,  3.917741785449976e-23, -1.700505011295538e-24,  9.192590381839893e-26, -3.011957194846086e-27,  8.657744256286026e-10, -1.088955649391284e-11,
  1.312021111537103e-12, -8.418213034958376e-14,  2.276354887576588e-15, -4.646357166961090e-17,  3.689860472213015e-18, -1.768708474662395e-19,  1.083417924331313e-21,
  5.990347482437036e-23,  7.290325032263975e-24, -3.369174298606132e-25,  1.548968748313323e-07, -2.019983949216872e-09,  1.376589833073971e-10, -7.873808535059284e-12,
  1.691685019153476e-13, -2.195923983702803e-16,  1.430823849848642e-16, -1.135153901039239e-17,  1.200724184724836e-20,  1.256310347658818e-20,  2.433170340075381e-22,
 -2.704486348370949e-23,  7.630297182494174e-06, -1.015806093203583e-07,  4.464070067682079e-09, -2.248305754323255e-10,  4.202093204926137e-12,  4.628941397564416e-14,
  1.623699949907456e-15, -2.781079532681589e-16,  8.282679708824035e-19,  3.915156424662955e-19,  1.822515790812949e-21, -7.242840172683971e-22,  1.455964666237135e-04,
 -1.963348166593594e-06,  5.941818923409131e-08, -2.524122215742589e-09,  4.283641422316371e-11,  7.851254898454767e-13,  3.966912804456557e-15, -2.806995604654001e-15,
  1.674246876004357e-17,  4.276513321997643e-18, -1.106340492243224e-20, -7.473594432183867e-21,  1.266911497192477e-03, -1.722793969517582e-05,  3.756472460993715e-07,
 -1.242246901888440e-08,  1.955353350134365e-10,  3.960421135006124e-12, -1.504084755986613e-14, -1.186918110281992e-14,  1.025522307992602e-16,  1.855670674450486e-17,
 -1.343191619956412e-19, -3.144627718612760e-20,  5.414094948810486e-03, -7.402911167226215e-05,  1.216655396207751e-06, -2.711611215610131e-08,  3.963649313097761e-10,
  5.041479035396075e-12, -3.956446252143890e-14, -1.731584879858957e-14,  1.937949458204603e-16,  2.690186884500627e-17, -2.991458922331771e-19, -4.459267501090999e-20,
  1.129634252752143e-02, -1.549907343757226e-04,  2.038565082708852e-06, -2.337729225881517e-08,  3.006743469301967e-10, -7.971226888740994e-12,  7.440915334350734e-14,
  6.402674483487062e-15, -3.273771558326919e-17, -1.183105026583532e-17,  4.596094365967627e-20,  2.008528170963781e-20,  9.287754756240859e-03, -1.276606258324721e-04,
  1.462994654128293e-06, -5.120712007569964e-09,  3.238018406050911e-11, -1.521940470379701e-11,  1.581025729218759e-13,  2.335256161035027e-14, -2.464121929583456e-16,
 -3.878737452837436e-17,  4.031020932423588e-19,  6.408774897481786e-20,  5.279560713515150e-13,  3.591757913622210e-15,  6.430363906107669e-16, -8.018358804932217e-17,
  3.282225032064212e-18, -7.155409748627903e-20,  4.492137721122268e-21, -4.066725694329783e-22,  1.665087420154767e-23, -1.725172764097445e-25, -6.262979967085456e-28,
 -9.107734924913086e-28,  8.376213822204006e-10, -3.862267024111065e-12,  5.009381084650973e-13, -5.195744976524011e-14,  1.864946414163214e-15, -1.022078845034723e-17,
 -2.413574736135859e-19, -8.420289936459049e-20,  4.478784129764447e-21,  3.020845481121148e-23, -6.568340304569539e-24, -6.274982526210661e-26,  1.484864930894484e-07,
 -1.250276683510189e-09,  5.959162302761086e-11, -5.117415964579057e-12,  1.754211845462524e-13, -1.307218090649762e-16, -1.018048468283601e-16, -4.200629116218063e-18,
  3.594514082203376e-19,  8.319401863075728e-22, -5.885403537215791e-22,  2.947290656512478e-24,  7.280021328341292e-06, -7.544519521500031e-08,  2.200160496483483e-09,
 -1.505073775601468e-10,  4.954578878226088e-12,  6.855366595401730e-15, -3.913499438766893e-15, -6.912643038599416e-17,  9.569467417088812e-18, -2.719167594487246e-20,
 -1.537605559720404e-20,  1.992622905046927e-22,  1.385198470186882e-04, -1.596404351744747e-06,  3.370925497786453e-08, -1.731905998499183e-09,  5.398272418922915e-11,
  1.224266887252668e-13, -4.790367572179361e-14, -4.429707820596848e-16,  9.964951679840539e-17, -6.732778313433568e-19, -1.543550448432118e-19,  2.843009851235444e-21,
  1.203148225940019e-03, -1.476047108989068e-05,  2.476222772442585e-07, -8.779110982496274e-09,  2.484229025725410e-10,  5.037517378197687e-13, -2.217263499973701e-13,
 -1.129927477082327e-15,  4.254425717663851e-16, -4.098316967139451e-18, -6.357795161986534e-19,  1.429255866570245e-20,  5.135545153529933e-03, -6.548303449194570e-05,
  9.320753822184653e-07, -2.016147889263372e-08,  4.552804142900314e-10, -2.934391591205661e-13, -3.266082654658858e-13, -8.923768064039341e-16,  6.157061624581433e-16,
 -7.479153477178394e-18, -8.842046216387285e-19,  2.316500293184043e-20,  1.070732057550819e-02, -1.397337484802719e-04,  1.782106877269558e-06, -1.969064722648734e-08,
  1.715200095429585e-10, -4.494750848682319e-12,  1.863226955908124e-13,  3.539256286347180e-16, -2.586759250930451e-16,  1.856192073912430e-18,  4.148575191809096e-19,
 -8.030446897018845e-21,  8.800115823005801e-03, -1.162144621809833e-04,  1.395814450421195e-06, -6.639758580173634e-09, -1.903918227929279e-10, -5.532237470705856e-12,
  5.401464856628452e-13,  5.394220490422737e-16, -8.705941221872275e-16,  1.014075853598944e-17,  1.279111809552163e-18, -3.252009291048870e-20,  5.476641154318293e-13,
  5.694187213281506e-15, -4.047727355589752e-17, -3.613201571885831e-17,  2.289355354865145e-18, -4.718069686948225e-20, -6.356108493201698e-22, -1.248850197319565e-23,
  6.748442068557019e-24, -3.423054553810058e-25,  1.978850692801215e-27,  4.233941480784615e-28,  8.269281847345033e-10, -1.861840128609405e-12,  4.722228480908282e-14,
 -2.458312797746085e-14,  1.493199259806083e-15, -2.883679561269029e-17, -7.657921523129232e-19,  3.144720722496174e-20,  1.764694320699784e-21, -1.280615278329150e-22,
  5.877028675289515e-25,  1.999059658381192e-25,  1.441158091888830e-07, -9.726331324392914e-10,  1.445161310030788e-11, -2.482046828187431e-12,  1.451513098309526e-13,
 -2.800280481009991e-15, -8.122271039537785e-17,  4.189379371935084e-18,  9.596517655113327e-20, -1.046907539526837e-20,  1.053675880156118e-22,  1.466583646259551e-23,
  7.003877933649215e-06, -6.374424708003288e-08,  8.573067474248056e-10, -7.532381254802914e-11,  4.157465531780094e-12, -8.011785649186280e-14, -2.379662814732977e-15,
  1.345825484183474e-16,  1.682162930854011e-18, -2.734008443166020e-19,  3.933689409863364e-21,  3.423587415089330e-22,  1.325624196802489e-04, -1.395394957642684e-06,
  1.798991790702741e-08, -9.094339061623878e-10,  4.556901925362971e-11, -8.721346996335012e-13, -2.573111564339709e-14,  1.535757306441807e-15,  1.149623602212894e-17,
 -2.786308859739499e-18,  4.880043916949746e-20,  3.174851515910591e-21,  1.147495179653648e-03, -1.313438343934342e-05,  1.655479742834217e-07, -4.999116126847509e-09,
  2.095803931295551e-10, -3.930924774611844e-12, -1.104488832885879e-13,  6.890928269002938e-15,  3.159253621615613e-17, -1.167365657257494e-17,  2.312790625172668e-19,
  1.230763390893981e-20,  4.887164825570776e-03, -5.887345582270920e-05,  7.323336050328300e-07, -1.332338908188112e-08,  3.787573777000507e-10, -6.637479363159692e-12,
 -1.504792316219756e-13,  1.020423285671704e-14,  2.571867242645813e-17, -1.655487338477230e-17,  3.616056782385479e-19,  1.616669705880089e-20,  1.017546159275959e-02,
 -1.263806905017400e-04,  1.560077871061161e-06, -1.743424897478176e-08,  1.229148049466141e-10, -6.870082874209305e-13,  1.075232483025240e-13, -4.665583941936901e-15,
 -2.230532727647363e-17,  7.396462149046585e-18, -1.339049568224018e-19, -8.381511557599800e-21,  8.357007736284530e-03, -1.054224551687256e-04,  1.296382886481316e-06,
 -9.911220730160489e-09, -1.840053415789404e-10,  5.068497874720754e-12,  2.700221506244876e-13, -1.519945443786451e-14, -3.470712935628958e-17,  2.373403778379325e-17,
 -5.097310962544661e-19, -2.365082722561011e-20,  5.678258219057397e-13,  4.182356525923422e-15, -2.876715301239737e-16, -7.694502269181371e-18,  1.247008985929753e-18,
 -5.236003400168826e-20,  4.532137557566497e-22,  4.718108388088325e-23, -1.340534958557084e-24, -7.804415309991920e-26,  6.661437136977103e-27, -1.539391330593439e-28,
  8.188776501211140e-10, -2.306445966695361e-12, -1.257113855767600e-13, -5.940488672588104e-15,  8.205682305529632e-16, -3.404089930023653e-17,  3.172517130346859e-19,
  3.037892459036468e-20, -1.143477608076002e-21, -2.039129429274733e-23,  2.743646240454104e-24, -6.552596533680497e-26,  1.403173815657717e-07, -9.414125841767857e-10,
 -3.474480299238688e-12, -6.714428873000051e-13,  7.965093476718935e-14, -3.291495087334112e-15,  3.323544304620201e-17,  2.841613702110244e-18, -1.195471276121155e-19,
 -8.792586379005322e-22,  2.168518367490752e-22, -5.920830247046711e-24,  6.758311621836948e-06, -5.950599966884881e-08,  2.931479638377382e-10, -2.343718349362228e-11,
  2.287707728442102e-12, -9.343361380356797e-14,  9.895855854432515e-16,  7.861935455315798e-17, -3.517138113870030e-18, -8.596404585673445e-21,  5.463104561203266e-21,
 -1.650298478448458e-22,  1.272151255941068e-04, -1.284205294426585e-06,  1.080653828854249e-08, -3.390728626392153e-10,  2.531955017856362e-11, -1.006867048622600e-12,
  1.099591510995383e-14,  8.253297611722358e-16, -3.840074624707386e-17,  1.386338646173222e-20,  5.409252025387169e-20, -1.755996471114717e-21,  1.097298292790740e-03,
 -1.199954299180099e-05,  1.227922344942052e-07, -2.355349854476087e-09,  1.193138702905061e-10, -4.460082090409238e-12,  4.977210828287258e-14,  3.508044762872402e-15,
 -1.680674586529465e-16,  3.626522807010448e-19,  2.215624825245034e-19, -7.580374123024606e-21,  4.662506869373465e-03, -5.356218337584509e-05,  6.040536807828713e-07,
 -8.428567152731953e-09,  2.316138981233159e-10, -7.157543510755069e-12,  8.150394647660049e-14,  4.949342844041423e-15, -2.458785982201247e-16,  8.819716051394537e-19,
  3.075273632676737e-19, -1.101893855115050e-20,  9.693621779073217e-03, -1.147038288286077e-04,  1.362548554266336e-06, -1.548050234527365e-08,  1.248519846216552e-10,
  4.427051648774410e-13, -2.978178471785109e-15, -2.543276881356595e-15,  1.079523589485393e-16, -1.292116964688323e-19, -1.437669534385479e-19,  4.735236541589404e-21,
  7.955248318359961e-03, -9.556788580275801e-05,  1.163887464851183e-06, -1.183073123465070e-08, -5.021747657554392e-11,  6.934725536908509e-12, -7.728751162043834e-14,
 -7.564676058967266e-15,  3.568124987720102e-16, -1.223485419932418e-18, -4.438725604830602e-19,  1.577659943750936e-20,  5.797486973916333e-13,  1.776894733378141e-15,
 -2.919601165771822e-16,  4.814937049622466e-18,  3.850535008771361e-19, -3.159597851568387e-20,  1.033386943518283e-21, -3.839165761534116e-24, -1.138269096562850e-24,
  4.439991387877531e-26,  1.356899386961563e-28, -8.087837960331625e-29,  8.074406512661786e-10, -3.422017404787821e-12, -1.387447380511766e-13,  2.368102422867757e-15,
  2.628037064378494e-16, -2.042997705277035e-17,  6.599850010245236e-19, -3.037571073973614e-21, -6.687986995531879e-22,  2.731454310902067e-23, -8.140060340991110e-26,
 -3.557880472380220e-26,  1.364695807717290e-07, -9.843912055798547e-10, -5.861943273062717e-12,  1.390539747830975e-13,  2.605902954099233e-14, -1.954104335752438e-15,
  6.329908628786442e-17, -3.524364213151984e-19, -6.024126735132018e-20,  2.577162651151303e-21, -1.647565463552862e-23, -2.754912482856150e-24,  6.523902017633231e-06,
 -5.779436829119526e-08,  1.755462117145911e-10,  3.509907545314674e-14,  7.722291530065979e-13, -5.512440201021775e-14,  1.785386432515109e-15, -1.107982748116452e-17,
 -1.630299106009235e-18,  7.205508590599102e-20, -6.097300080994036e-22, -6.754661807284913e-23,  1.222332977222775e-04, -1.208549599275146e-06,  8.565961761714216e-09,
 -7.523865622841064e-11,  9.019618195841843e-12, -5.928789007734843e-13,  1.908059414460642e-14, -1.268695250168717e-16, -1.688179697086252e-17,  7.636233041147419e-19,
 -7.489547530498567e-21, -6.528876212315774e-22,  1.051123351344534e-03, -1.110404277029093e-05,  1.033149882034111e-07, -1.071948252460919e-09,  4.709508763314953e-11,
 -2.637348100963594e-12,  8.315248526908911e-14, -5.819102267322225e-16, -7.121798193749135e-17,  3.279361921779748e-18, -3.522742585262266e-20, -2.620962809655343e-21,
  4.457358101297553e-03, -4.908134282590356e-05,  5.208584923546196e-07, -5.729523222499049e-09,  1.150133850926117e-10, -4.336287312379577e-12,  1.263170154401523e-13,
 -9.395356316292438e-16, -1.007605431689694e-16,  4.734015587363176e-18, -5.463252525565546e-20, -3.566840677154192e-21,  9.255479407038168e-03, -1.045119899314209e-04,
  1.188997919110555e-06, -1.343347440824520e-08,  1.291105103512744e-10, -1.268342291816825e-13, -3.209337240952328e-14,  1.268680286534116e-16,  4.789273069110412e-17,
 -2.089751046669119e-18,  2.098498077691210e-20,  1.730992532259653e-21,  7.590693298586638e-03, -8.682870236250374e-05,  1.021204310834746e-06, -1.167570124343526e-08,
  5.892726591450704e-11,  3.698043830704627e-12, -1.526683206985382e-13,  1.018716132856949e-15,  1.484539181109434e-16, -6.827254188206101e-18,  7.772796829027910e-20,
  5.171716604702753e-21,  5.826459157943696e-13, -2.626239848735160e-16, -2.139421507061434e-16,  7.175619671559260e-18, -2.284010664615444e-20, -1.080976491660067e-20,
  6.361918624413640e-22, -1.805693687453579e-23,  7.421127355591441e-26,  1.747198290699663e-26, -8.075219405054058e-28,  1.247356074216351e-29,  7.917793195970550e-10,
 -4.372567759677846e-12, -9.595403644275255e-14,  4.103320776917164e-15, -3.193426519205168e-18, -7.197209846755539e-18,  4.066474920613692e-19, -1.125596963856131e-20,
  4.658655557700154e-23,  1.023864676377694e-23, -4.621133249480622e-25,  7.144520199902872e-27,  1.324555240659586e-07, -1.019987067776413e-09, -2.730324606810077e-12,
  3.196282382051936e-13,  5.771517724751814e-16, -6.940899984554510e-16,  3.857669801841517e-17, -1.067181137540420e-18,  5.114113068671697e-21,  9.131612745771885e-22,
 -4.180834430460833e-23,  6.828780294217911e-25,  6.295740036706531e-06, -5.624778600423962e-08,  2.207792933176752e-10,  5.715676160140303e-12,  5.186674129350465e-14,
 -1.976280367899276e-14,  1.079483510470923e-15, -2.988541251634838e-17,  1.581102407613406e-19,  2.450502829954033e-20, -1.138947797103594e-21,  1.943489861960718e-23,
  1.175329042117646e-04, -1.141928960848489e-06,  8.212987348244278e-09, -2.913265050647685e-12,  1.235286672838548e-12, -2.162158938338436e-13,  1.148039871545892e-14,
 -3.173826112118404e-16,  1.794613566707401e-18,  2.521663834461752e-19, -1.186608415196966e-20,  2.089874187821775e-22,  1.008292387984624e-03, -1.031951266627509e-05,
  9.355982957403541e-08, -6.408744968341098e-10,  1.206912105010516e-11, -9.990595752588362e-13,  4.995276149133440e-14, -1.370848712247528e-15,  8.142835048270129e-18,
  1.059384418597225e-18, -5.036191138611975e-20,  9.078238780341339e-22,  4.268967767084534e-03, -4.516379395531000e-05,  4.607809139314699e-07, -4.432070662188401e-09,
  5.518651249436601e-11, -1.847261837941394e-12,  7.640042264197968e-14, -2.027812080560319e-15,  1.271723252289697e-17,  1.497558016226828e-18, -7.202329981893127e-20,
  1.325450203671233e-21,  8.855483470746958e-03, -9.561014418357507e-05,  1.039980574962470e-06, -1.142633842534962e-08,  1.197885561505356e-10, -7.425263935028427e-13,
 -1.669806689537735e-14,  7.029426106906280e-16, -3.228912426406747e-18, -6.957132850456636e-19,  3.214302397695525e-20, -5.674298988234625e-22,  7.258858909008163e-03,
 -7.919906761166419e-05,  8.885926954908793e-07, -1.032353791951516e-08,  1.004711209869910e-10,  7.146387295468572e-13, -8.873354725444296e-14,  2.682750180308304e-15,
 -1.569302469753971e-17, -2.180850679436848e-18,  1.037430248707430e-19, -1.899852484458205e-21,  5.786930545816413e-13, -1.647798998580350e-15, -1.349203289687372e-16,
  5.748631021597438e-18, -1.241627733025056e-19, -9.509261320309519e-22,  2.211950139288125e-22, -1.059285309755954e-23,  2.778565877600664e-25, -1.929950381320959e-27,
 -1.907211160375455e-28,  1.014540194418405e-29,  7.730537062992355e-10, -4.952111910671268e-12, -5.033148300968162e-14,  3.330059340958443e-15, -7.316417240600891e-17,
 -8.209404037260412e-19,  1.463888175692579e-19, -6.729420912734993e-21,  1.698250678040324e-22, -1.028364347860901e-24, -1.162536826522541e-25,  5.815520482028373e-27,
  1.283553660338965e-07, -1.027106767761062e-09,  8.391549127312993e-13,  2.585737333823464e-13, -6.279024523381640e-15, -8.789260105774520e-17,  1.400368385172793e-17,
 -6.351526571832281e-19,  1.591794919227604e-20, -9.930985142012855e-23, -1.043667123658673e-23,  5.200355619350603e-25,  6.074705945225540e-06, -5.421532846908938e-08,
  2.851275035287455e-10,  4.524623770920140e-12, -1.466810145684851e-13, -2.779553013965345e-15,  3.939260734572091e-16, -1.769428912249209e-17,  4.425880574903322e-19,
 -2.867785602818861e-21, -2.802144781984656e-22,  1.402390040274339e-23,  1.130965209382121e-04, -1.076274528594360e-06,  8.194608315976419e-09, -5.598504862270218e-12,
 -9.948316176475945e-13, -3.525119198893892e-14,  4.220156376231776e-15, -1.871804128623619e-16,  4.674763991771735e-18, -3.123716767047734e-20, -2.881019338211701e-21,
  1.449850953265237e-22,  9.684656786145718e-04, -9.599670021317819e-06,  8.654594905716823e-08, -5.546694946252808e-10,  1.225150920871327e-12, -2.079782966373777e-13,
  1.865495424899095e-14, -8.067354884360221e-16,  2.007291553308882e-17, -1.374636148442781e-19, -1.209227722015789e-20,  6.117877000027889e-22,  4.095366442681464e-03,
 -4.167752667717141e-05,  4.119477805065302e-07, -3.763033505310983e-09,  3.236444787279444e-11, -6.161264300406608e-13,  3.014901983990275e-14, -1.195585389014239e-15,
  2.928060388526398e-17, -2.058476555229698e-19, -1.709419794797057e-20,  8.706010887033011e-22,  8.488858552639807e-03, -8.780741986724656e-05,  9.138209042805471e-07,
 -9.644037480854260e-09,  1.023944052719735e-10, -9.343196411782680e-13, -7.584544681066930e-16,  3.952434239909709e-16, -1.147832730875512e-17,  7.286721424679706e-20,
  7.865608519225153e-21, -3.911745542561508e-22,  6.955534745674988e-03, -7.255807303070680e-05,  7.745181215882161e-07, -8.693528902665515e-09,  9.904186183261808e-11,
 -6.184509162832036e-13, -2.772943108664435e-14,  1.554865292653085e-15, -4.034485827349317e-17,  2.771081100756480e-19,  2.477751284086238e-20, -1.253696235965807e-21,
  5.703322779273875e-13, -2.485002335216568e-15, -7.778425056322269e-17,  3.814356695882560e-18, -1.093317752798736e-19,  1.704382765985752e-21,  3.221748223536691e-23,
 -3.607728312993919e-24,  1.494802815249197e-25, -3.732288434920570e-27,  3.737758687531995e-29,  1.521217265684473e-30,  7.526645244594573e-10, -5.215104643437270e-12,
 -1.746788546415708e-14,  2.165288917909618e-15, -6.676623764045995e-17,  9.894944414892462e-19,  2.445354251028543e-20, -2.390599892170855e-21,  9.487141495061789e-23,
 -2.258119984602073e-24,  1.940354338194398e-26,  1.003238714218990e-27,  1.242775473646489e-07, -1.009730867945181e-09,  3.326232175454599e-12,  1.572332403573982e-13,
 -5.840502089718073e-15,  8.709058431847476e-17,  2.451092056614241e-18, -2.282332864268340e-19,  8.931038918634979e-21, -2.098837987816543e-22,  1.763727920381927e-24,
  9.194057208901981e-26,  5.862691963524348e-06, -5.175863667711882e-08,  3.247762911055997e-10,  2.105245755684803e-12, -1.401936067146032e-13,  2.182146854984810e-15,
  7.154609997291321e-17, -6.394477549200491e-18,  2.481922277740665e-19, -5.802447312958193e-21,  4.881996604644104e-23,  2.488569869907305e-24,  1.089216940572817e-04,
 -1.011282489130477e-06,  8.022304983839086e-09, -2.314975235072033e-11, -1.030636625488294e-12,  1.846887455617815e-14,  8.049082211202986e-16, -6.798670074051284e-17,
  2.618289721401520e-18, -6.102648482551737e-20,  5.165267815717877e-22,  2.568370632680487e-23,  9.314097910827525e-04, -8.933784510648705e-06,  7.993104432780420e-08,
 -5.504742117457037e-10,  6.024527159549409e-14,  3.444418329172453e-14,  3.898867337387250e-15, -2.954655915701820e-16,  1.123379755632909e-17, -2.609834196092438e-19,
  2.223324900561797e-21,  1.080261054492688e-22,  3.934972964722417e-03, -3.855449718407532e-05,  3.695922968105634e-07, -3.314066666553316e-09,  2.507214894007371e-11,
 -1.983988805172564e-13,  8.089987041329250e-15, -4.501834015038214e-16,  1.640851372966618e-17, -3.777318218054746e-19,  3.242004476800856e-21,  1.530042184822004e-22,
  8.151554519123192e-03, -8.093332594011311e-05,  8.073110460838205e-07, -8.153144533258095e-09,  8.422378722916428e-11, -8.573312212826248e-13,  5.833743678339367e-15,
  1.040832428883671e-16, -6.275880383515943e-18,  1.567447912620366e-19, -1.315369722862406e-21, -6.987404556674656e-23,  6.677070609649931e-03, -6.675338963390696e-05,
  6.792129718623404e-07, -7.231625878711505e-09,  8.284693094001233e-11, -8.935922184631328e-13,  8.503236663472908e-17,  5.297948523874331e-16, -2.239227260200788e-17,
  5.306496245192177e-19, -4.534747758217969e-21, -2.212326925426826e-22,  5.593992207419466e-13, -2.951198037715570e-15, -4.132050769670408e-17,  2.353668849117534e-18,
 -7.338319048946921e-20,  1.694115458111342e-21, -1.953229627349346e-23, -6.171076667607315e-25,  4.910700085735453e-26, -1.821356408114996e-27,  4.376393751632838e-29,
 -5.437474402244202e-31,  7.316656757365749e-10, -5.267454143682630e-12,  2.813083967209066e-15,  1.269751663806304e-15, -4.505094199927442e-17,  1.047840307443108e-18,
 -1.082446646166137e-20, -4.568964080602038e-22,  3.271204170421330e-23, -1.159926206464407e-24,  2.644838257532891e-26, -2.862281094836337e-28,  1.203017405814354e-07,
 -9.770180085975019e-10,  4.715454568897683e-12,  7.924063316717311e-14, -3.888575520919729e-15,  9.516020462837805e-17, -9.485225286312532e-19, -4.520149363333982e-20,
  3.125464441789552e-21, -1.091398591514158e-22,  2.447173660552827e-24, -2.548866285401659e-26,  5.660964838426552e-06, -4.909382896137980e-08,  3.381905474057650e-10,
  2.575489707908116e-13, -9.000222146721467e-14,  2.472155963960629e-15, -2.424880728171759e-17, -1.295186986017561e-18,  8.748651385985856e-20, -3.029898440580149e-21,
  6.740970228985377e-23, -6.925298973018857e-25,  1.050028082421010e-04, -9.484632853523575e-07,  7.659744487331873e-09, -3.613650519580377e-11, -5.813174962077841e-13,
  2.255979236765050e-14, -2.195647816296937e-16, -1.410206162861598e-17,  9.275985121350488e-19, -3.192171319884693e-20,  7.069605861404200e-22, -7.223006693416349e-24,
  8.969118335572168e-04, -8.320668505986863e-06,  7.336418498332695e-08, -5.411009593790621e-10,  1.190586335839345e-12,  6.144695897757621e-14, -5.978612323512383e-16,
 -6.384182629152308e-17,  4.003165463325963e-18, -1.366596507133431e-19,  3.015493073897044e-21, -3.073731230366259e-23,  3.786425878717869e-03, -3.575026488202718e-05,
  3.321241815766702e-07, -2.937475329894704e-09,  2.228205912245700e-11, -1.076217831266209e-13,  1.017570270640581e-15, -1.101614669695179e-16,  5.940492825578390e-18,
 -1.982068762076408e-19,  4.344972056216764e-21, -4.423044684543687e-23,  7.840149243496559e-03, -7.484452987900328e-05,  7.170194598547551e-07, -6.934484775835002e-09,
  6.861650856702655e-11, -7.002913923602114e-13,  6.690483900011946e-15, -2.007404522302750e-17, -1.949031944580983e-18,  8.082032860062833e-20, -1.855136250126910e-21,
  1.895768981763796e-23,  6.420404902824198e-03, -6.164560721170455e-05,  5.998080926394811e-07, -6.045140848669351e-09,  6.584789828764663e-11, -7.784237826230639e-13,
  7.440903076739401e-15,  7.301616265423610e-17, -7.710060513989513e-18,  2.766704274720980e-19, -6.163396893213325e-21,  6.281685347521123e-23,  5.470871638292167e-13,
 -3.186355195701887e-15, -1.909548992638604e-17,  1.421779025678902e-18, -4.488756239682922e-20,  1.145831915546737e-21, -2.254690986896298e-23,  1.934184740557244e-25,
  8.934004921716941e-27, -5.741670281000429e-28,  1.946518892905225e-29, -4.514055588936066e-31,  7.107220366085759e-10, -5.194768699337918e-12,  1.436336005521223e-14,
  6.998266755055553e-16, -2.725621881959598e-17,  7.208687794106857e-19, -1.394208008942024e-20,  9.852958836516861e-23,  6.594355593733810e-24, -3.854893499704348e-25,
  1.247977004364452e-26, -2.743063073359148e-28,  1.164738236846512e-07, -9.364133596939768e-10,  5.351062808335333e-12,  3.074486153593542e-14, -2.270263887125011e-15,
  6.549443555804861e-17, -1.284115502082731e-18,  8.370717187599835e-21,  6.512354698403971e-22, -3.691831098990761e-23,  1.175694029464195e-24, -2.535266177095202e-26,
  5.469990227857108e-06, -4.639691265526034e-08,  3.341476559335393e-10, -8.263216513550976e-13, -4.804653210512745e-14,  1.687532231079594e-15, -3.439410789879665e-17,
  2.122463762378861e-19,  1.856987829144652e-20, -1.034003642748510e-21,  3.264255669416100e-23, -6.972259502036801e-25,  1.013285837089064e-04, -8.890460325109247e-07,
  7.184014348600192e-09, -4.220005369712114e-11, -2.013158037359713e-13,  1.502231661916594e-14, -3.367393417185082e-16,  1.949535746046124e-18,  2.000259038106567e-19,
 -1.095570462143432e-20,  3.437839442292765e-22, -7.301237208288586e-24,  8.647624341348182e-04, -7.759317836913511e-06,  6.702215402187459e-08, -5.133976361594251e-10,
  2.189564514968015e-12,  3.633656974185138e-14, -1.182792267115474e-15,  5.835629904081499e-18,  8.828181309690105e-19, -4.714381827962097e-20,  1.470375354900650e-21,
 -3.109775994627436e-23,  3.648523904681602e-03, -3.322836838606922e-05,  2.989447258828088e-07, -2.597590712535843e-09,  2.021106453252688e-11, -1.042320260838191e-13,
 -2.638056316868287e-16, -4.983061041320227e-18,  1.399229052686333e-18, -6.909741291087805e-20,  2.125149894027349e-21, -4.469791661772447e-23,  7.551741429604953e-03,
 -6.942357489876227e-05,  6.399581339124448e-07, -5.940231015788078e-09,  5.614413328248305e-11, -5.512908875386593e-13,  5.601169031200996e-15, -4.835907193525489e-17,
 -1.444405456705330e-19,  2.593932714952927e-20, -8.940194166678132e-22,  1.937047013134943e-23,  6.182983780002989e-03, -5.712051699235332e-05,  5.331063889248478e-07,
 -5.106123488535306e-09,  5.212008922861531e-11, -5.955374267973388e-13,  7.224428593236707e-15, -5.581430680314785e-17, -1.427055377026612e-18,  9.377967063151411e-20,
 -3.000491670135815e-21,  6.372598840759837e-23,  5.341291023426440e-13, -3.281521697154993e-15, -5.676346961851714e-18,  8.597337008090334e-19, -2.684084382237870e-20,
  6.874097899622124e-22, -1.536372506249475e-23,  2.652896287479182e-25, -1.710369628644320e-27, -1.064084904167745e-28,  5.884497638872669e-30, -1.848806890493976e-31,
  6.902167990332174e-10, -5.052700306353791e-12,  2.056486262228868e-14,  3.621180393457126e-16, -1.588183608957024e-17,  4.333015008986788e-19, -9.750605184076355e-21,
  1.631881405455499e-22, -7.598842701920837e-25, -7.897429938820486e-26,  3.988806034098689e-27, -1.196095358757226e-28,  1.128153702590154e-07, -8.926574214185183e-10,
  5.540149119107042e-12,  3.334381310437200e-15, -1.241597123494385e-15,  3.889038928238845e-17, -9.044134084065404e-19,  1.510376341036729e-20, -6.005433611913147e-23,
 -7.817174887291218e-24,  3.833034938086670e-25, -1.129708845244047e-26,  5.289670720737405e-06, -4.377417619336399e-08,  3.205954452218708e-10, -1.367045186830942e-12,
 -2.183961077643341e-14,  9.737978321250305e-16, -2.424366820099415e-17,  4.100487772001236e-19, -1.457006605617635e-21, -2.228363161170443e-22,  1.075109763001183e-23,
 -3.139625712670617e-25,  9.788408596935039e-05, -8.336341658189364e-07,  6.666853243487289e-09, -4.342892128738805e-11,  2.522568920142313e-14,  8.035178545632994e-15,
 -2.361853757700104e-16,  4.139877811055355e-18, -1.297099627991336e-20, -2.391952329534359e-21,  1.139519213786845e-22, -3.307642403099380e-24,  8.347594005645279e-04,
 -7.247142468610617e-06,  6.109081994209604e-08, -4.739967115584724e-10,  2.656785870441126e-12,  1.187977961393937e-14, -8.120587407690155e-16,  1.592100566417863e-17,
 -3.752579004452472e-20, -1.044815466470029e-20,  4.898537705955503e-22, -1.414422285362335e-23,  3.520203679261150e-03, -3.095615814369138e-05,  2.696440276383036e-07,
 -2.291215593729680e-09,  1.807005786778371e-11, -1.089768962410106e-13, -5.352986221584335e-17,  1.300239322041656e-17,  3.644024478413058e-20, -1.591546853114596e-20,
  7.136709590132808e-22, -2.040929841624540e-23,  7.283855514136221e-03, -6.457456251300415e-05,  5.737237451361061e-07, -5.123288345468831e-09,  4.635310361694970e-11,
 -4.329800551260794e-13,  4.282266338121170e-15, -4.347273139358497e-17,  3.209910723151325e-19,  3.929680626062355e-21, -2.852440333022675e-22,  8.725360552218938e-24,
  5.962662243099075e-03, -5.308743005405236e-05,  4.764722942570123e-07, -4.358658768195019e-09,  4.180057229657170e-11, -4.436497346651999e-13,  5.393295066319336e-15,
 -6.578707250501468e-17,  3.663370765320131e-19,  1.909974853112078e-20, -9.905343812332706e-22,  2.899244441759018e-23,  5.209684551014893e-13, -3.292039292867053e-15,
  2.459091429890282e-18,  5.226136401791716e-19, -1.622043268406270e-20,  3.993815733940434e-22, -9.030777277882197e-24,  1.818319975102302e-25, -2.812439506550331e-27,
  1.403720986831137e-29,  1.085133487832858e-30, -5.363233154697643e-32,  6.703572312947443e-10, -4.874536164343257e-12,  2.363448611274296e-14,  1.661016164348332e-16,
 -9.207895296543311e-18,  2.496253871501598e-19, -5.779806375514562e-21,  1.157739340738629e-22, -1.718229193638174e-24,  5.086775353428772e-27,  8.135885892050355e-28,
 -3.675024789290595e-29,  1.093332287245101e-07, -8.484617522405323e-10,  5.483193767561008e-12, -1.135064432796052e-14, -6.485014381481119e-16,  2.186719815586996e-17,
 -5.343756683198540e-19,  1.084198362474159e-20, -1.591435092578903e-22,  3.443786161817660e-25,  8.087996490857622e-26, -3.546098335320824e-27,  5.119592976880192e-06,
 -4.127967765241217e-08,  3.026448823691728e-10, -1.588546651527369e-12, -7.301906174092470e-15,  5.194353498989410e-16, -1.416161693893265e-17,  2.958934694335782e-19,
 -4.346884158137316e-21,  7.338193367250873e-24,  2.309384678208256e-24, -9.966386302087185e-26,  9.465294185983817e-05, -7.823666646887197e-07,  6.152537385439811e-09,
 -4.200985919984527e-11,  1.381486310735554e-13,  3.656624290716177e-15, -1.341485724936688e-16,  2.992857634469372e-18, -4.455568543953629e-20,  5.665204742954034e-23,
  2.477617547323756e-23, -1.057346606418455e-24,  8.067132962972941e-04, -6.780433197380816e-06,  5.566272218842412e-08, -4.305005056070488e-10,  2.733827421150630e-12,
 -2.634253995047134e-15, -4.186373728888503e-16,  1.148271969219931e-17, -1.787629790729361e-19,  1.136099799606916e-22,  1.077654223192787e-22, -4.545105656887415e-24,
  3.400525939423828e-03, -2.890423470804135e-05,  2.438123476573655e-07, -2.019479771910466e-09,  1.590619116666466e-11, -1.061310818500534e-13,  2.713849803844042e-16,
  9.064958268021765e-18, -1.928491299160811e-19, -4.221478298413956e-22,  1.610119095138577e-22, -6.602890186755253e-24,  7.034364449292373e-03, -6.021870616470858e-05,
  5.164254261927613e-07, -4.445723367948356e-09,  3.862896930317369e-11, -3.435837827814297e-13,  3.218074754351302e-15, -3.252416584170313e-17,  3.294490765353617e-19,
 -1.939655015041507e-21, -5.168166387081266e-23,  2.724952260651378e-24,  5.757620037776440e-03, -4.947412921211684e-05,  4.279095757156569e-07, -3.754397287353256e-09,
  3.408148416996400e-11, -3.345751234358146e-13,  3.776461339495918e-15, -4.865866200590685e-17,  5.820928756962952e-19, -2.019518069990595e-21, -2.082605790768274e-22,
  9.275222201405898e-24,  5.078738469942926e-13, -3.251154634483365e-15,  7.403046302317016e-18,  3.167678682652047e-19, -1.003758514883632e-20,  2.342420541738877e-22,
 -5.084935117005740e-24,  1.047864617561903e-25, -1.931781356292914e-27,  2.722947489696883e-29, -1.117571103571143e-31, -9.684110442674991e-33,  6.512467710199656e-10,
 -4.679656450542734e-12,  2.488683701207730e-14,  5.217271836511291e-17, -5.370751397524502e-18,  1.439263745043440e-19, -3.250250989165492e-21,  6.756763812383076e-23,
 -1.231573933331178e-24,  1.652626053027136e-26, -3.136294993694581e-29, -7.360270003644612e-30,  1.060260398372938e-07, -8.052882430829048e-10,  5.297162809361483e-12,
 -1.883156409381160e-14, -3.176826163936838e-16,  1.213717517994719e-17, -2.972005964370244e-19,  6.336281199140631e-21, -1.158921624402575e-22,  1.528922258691031e-24,
 -1.533305469216798e-27, -7.358432583400127e-28,  4.959193956442041e-06, -3.893607252409358e-08,  2.831713809600549e-10, -1.638192176693214e-12,  2.806464881971678e-16,
  2.639645377639990e-16, -7.697157498921298e-18,  1.722040938369528e-19, -3.191641852573145e-21,  4.186487661174486e-23, -2.013851473277993e-26, -2.106864339476072e-26,
  9.161878215401869e-05, -7.351207109279829e-07,  5.663599103645371e-09, -3.936368150807756e-11,  1.850673959880626e-13,  1.288405494360257e-15, -6.906387665684124e-17,
  1.720384229372345e-18, -3.287921553840474e-20,  4.324991476837363e-22, -2.985463404831277e-26, -2.262410898178446e-25,  7.804504896738927e-04, -6.355058897479471e-06,
  5.075592788450153e-08, -3.876286897899724e-10,  2.603469535174509e-12, -9.444255284642204e-15, -1.724880448277976e-16,  6.355868670825969e-18, -1.323904830046182e-19,
  1.774527746712339e-21,  8.058438877750371e-25, -9.826534871152701e-25,  3.288662416340731e-03, -2.704650311397012e-05,  2.210368904649290e-07, -1.781533886642666e-09,
  1.386572131265372e-11, -9.725061986313231e-14,  4.427260243307975e-16,  3.451427895994424e-18, -1.435327850475371e-19,  2.156765296799700e-21,  4.832143234553260e-24,
 -1.454016622020535e-24,  6.801428734027808e-03, -5.629068683436399e-05,  4.665711582459026e-07, -3.878726019620755e-09,  3.246171343445167e-11, -2.761608362484607e-13,
  2.442735597989885e-15, -2.331769357632350e-17,  2.433128137953735e-19, -2.445756201778341e-21,  1.061662096181982e-23,  5.245500418069342e-25,  5.566297194423187e-03,
 -4.622227222284501e-05,  3.859225856284134e-07, -3.258127707876733e-09,  2.819641188476510e-11, -2.582928423979989e-13,  2.656126533892935e-15, -3.218398528117903e-17,
  4.313059738061720e-19, -4.962629413106488e-21,  8.648789455105834e-24,  1.954352118590597e-24,  4.950083177540695e-13, -3.179138179959317e-15,  1.037622117434663e-17,
  1.878975443288632e-19, -6.367892369088924e-21,  1.412864979202055e-22, -2.878483295056821e-24,  5.725038366796165e-26, -1.091920721440821e-27,  1.864069336690999e-29,
 -2.431410590477251e-31,  8.993477260437475e-34,  6.329284946443926e-10, -4.479324184343429e-12,  2.508015954674842e-14, -1.439943083143989e-17, -3.139793948793482e-18,
  8.469906385489032e-20, -1.825020692017731e-21,  3.700606190896389e-23, -7.072525571756039e-25,  1.189364831263637e-26, -1.468085541783426e-28,  2.060033598591470e-31,
  1.028881097634011e-07, -7.638850636535667e-10,  5.047589733334862e-12, -2.230666822569114e-14, -1.338519997710559e-16,  6.763538101719940e-18, -1.637802445652208e-19,
  3.453198474174952e-21, -6.683575187177982e-23,  1.122142208138631e-24, -1.355853966442136e-26,  5.958546731524295e-30,  4.807856469436404e-06, -3.674891499250256e-08,
  2.636857385122414e-10, -1.600055354607393e-12,  4.049309675675493e-15,  1.269053878091091e-16, -4.087490321059726e-18,  9.278090617153566e-20, -1.839893325241641e-21,
  3.105524375870564e-23, -3.715334024576129e-25, -4.377883984638231e-29,  8.876599825650904e-05, -6.916495899560017e-07,  5.209600014980486e-09, -3.627209739055772e-11,
  1.976073687054217e-13,  1.040424541504086e-16, -3.336647112242337e-17,  9.036655384083817e-19, -1.885177050398045e-20,  3.230674854144065e-22, -3.854222668219775e-24,
 -2.032172390955845e-27,  7.558138684426131e-04, -5.966925056366734e-06,  4.634750110874314e-08, -3.476565424833934e-10,  2.385374316318858e-12, -1.186946555301404e-14,
 -4.454609325909133e-17,  3.088974853284594e-18, -7.456667251982191e-20,  1.333336775668308e-21, -1.601566618058792e-23, -1.551547129382362e-26,  3.183882731985906e-03,
 -2.536009408239824e-05,  2.009273470309777e-07, -1.574640697916817e-09,  1.203241011195622e-11, -8.591382791516643e-14,  4.864661824639912e-16,  5.036140004284878e-20,
 -7.233410269593156e-20,  1.639415385299780e-21, -2.071569103660915e-23, -4.484704390167853e-26,  6.583448278713946e-03, -5.273586694221153e-05,  4.229702518255888e-07,
 -3.400546173054290e-09,  2.747608390084039e-11, -2.245677177477634e-13,  1.886374723835154e-15, -1.682897487736126e-17,  1.661845005302534e-19, -1.795826006169443e-21,
  1.779350375176766e-23, -5.327182336726063e-26,  5.387345585618033e-03, -4.328398376056423e-05,  3.493718807369449e-07, -2.845128780589033e-09,  2.360241096017169e-11,
 -2.039595698440126e-13,  1.922525325757752e-15, -2.105864535427499e-17,  2.718525957985674e-19, -3.698727078506417e-21,  4.054127258790339e-23, -2.347980967419793e-26,
  1.970787045778036e+00,  1.993538318857097e-02, -7.011218557626116e-03,  2.179389597471881e-03, -6.390566573562746e-04,  1.818562397877812e-04, -5.100764314030179e-05,
  1.424251034671907e-05, -3.987889846112490e-06,  1.125832987093064e-06, -3.201479260624501e-07,  8.565546359915474e-08,  1.982755338266881e+00,  1.177258909257463e-02,
 -4.128486421323632e-03,  1.261194079443841e-03, -3.620452751047325e-04,  1.008410267395073e-04, -2.772884200627805e-05,  7.611495956790233e-06, -2.102602241076122e-06,
  5.880121910706726e-07, -1.663408995923844e-07,  4.443348222997663e-08,  1.989900257357504e+00,  6.961731331888724e-03, -2.507967032854596e-03,  7.677536792236732e-04,
 -2.192772937517587e-04,  6.064445282188988e-05, -1.656083801525730e-05,  4.520244099831494e-06, -1.243877690814433e-06,  3.472311404496268e-07, -9.823823475840603e-08,
  2.627714458385497e-08,  1.994743190379187e+00,  3.727145661166877e-03, -1.451130883738342e-03,  4.548502549374961e-04, -1.309778496168763e-04,  3.631320599671184e-05,
 -9.919997484961062e-06,  2.707361624332730e-06, -7.451787632900272e-07,  2.082045321285214e-07, -5.899788074418757e-08,  1.580971142969803e-08,  1.998185171672259e+00,
  1.441107323428379e-03, -7.200804592670475e-04,  2.425317275029296e-04, -7.205031597853059e-05,  2.029726184964500e-05, -5.595467430690743e-06,  1.535913475257416e-06,
 -4.244785438110154e-07,  1.189896446813737e-07, -3.381327432400710e-08,  9.081708733890633e-09,  2.000655721202041e+00, -1.931779903759296e-04, -2.055071822165097e-04,
  9.511239428989805e-05, -3.160315991489534e-05,  9.404969967478484e-06, -2.674613054785136e-06,  7.483657163739378e-07, -2.094267141035959e-07,  5.920854055437021e-08,
 -1.692576817248565e-08,  4.563880376432852e-09,  2.002388862157443e+00, -1.336396445852330e-03,  1.504574798066488e-04, -5.886340186789365e-06, -4.112826459110259e-06,
  2.047965090400057e-06, -7.106481268391072e-07,  2.203421190533361e-07, -6.544456824321758e-08,  1.919085741165531e-08, -5.612923611971318e-09,  1.534010309095471e-09,
  2.003519839332887e+00, -2.080964486497175e-03,  3.805278599537771e-04, -7.073785990827701e-05,  1.344463723730706e-05, -2.631565797594139e-06,  5.349634226768698e-07,
 -1.139594331586221e-07,  2.564245133198905e-08, -6.125973236997417e-09,  1.548275530386332e-09, -3.854871200390561e-10,  2.004126210441766e+00, -2.479692143737670e-03,
  5.031613196310816e-04, -1.051684481649167e-04,  2.273631497307750e-05, -5.102044431806981e-06,  1.191462086283504e-06, -2.899783752388117e-07,  7.358295097123807e-08,
 -1.945147758262746e-08,  5.319037111026930e-09, -1.396712243504601e-09,  1.996424364091659e+00,  2.413410143579010e-03, -8.006466352308088e-04,  2.194147349906316e-04,
 -5.499221847793958e-05,  1.309150784040916e-05, -3.014970537033251e-06,  6.786434466847423e-07, -1.502520515687568e-07,  3.285556330870980e-08, -7.103880440167938e-09,
  1.461348364221488e-09,  1.998135093451714e+00,  1.298868731018196e-03, -4.721592586829666e-04,  1.327713673982335e-04, -3.350262610605265e-05,  7.965706733039694e-06,
 -1.824784301802081e-06,  4.076414558043689e-07, -8.945156956541352e-08,  1.937183296723882e-08, -4.146640181576159e-09,  8.450092280408935e-10,  1.999264251991071e+00,
  5.672079055065730e-04, -2.614173195660911e-04,  7.843707160585273e-05, -2.032482659215837e-05,  4.890653869552599e-06, -1.125911235698092e-06,  2.518023826298369e-07,
 -5.519298533895166e-08,  1.192310611393764e-08, -2.543834160511614e-09,  5.166003174073272e-10,  2.000080681018897e+00,  4.015888791262526e-05, -1.120226815100601e-04,
  4.052060270357018e-05, -1.126849962331219e-05,  2.808435669276343e-06, -6.594032370580768e-07,  1.492001139341698e-07, -3.293370593779008e-08,  7.144119223116732e-09,
 -1.527738087987911e-09,  3.105904024041641e-10,  2.000687893584749e+00, -3.507571344409698e-04, -2.522852006271626e-06,  1.304915822951952e-05, -4.779847889043816e-06,
  1.332492548194556e-06, -3.321025939619607e-07,  7.791470770226851e-08, -1.761123144024908e-08,  3.883102994362976e-09, -8.400364886834559e-10,  1.721496649470574e-10,
  2.001138271621978e+00, -6.401144888623044e-04,  7.781132173810876e-05, -6.932020148541736e-06, -9.929110132415290e-08,  2.762065592881681e-07, -9.961391670355345e-08,
  2.763657238269655e-08, -6.875874040999731e-09,  1.612507533862167e-09, -3.639437872390766e-10,  7.678046367219265e-11,  2.001461748486176e+00, -8.476306338857129e-04,
  1.350475278456130e-04, -2.107829274313815e-05,  3.194464873472045e-06, -4.628575012515164e-07,  6.217524091455590e-08, -7.174617465801198e-09,  5.218275287886221e-10,
  5.470608601524007e-11, -3.861899711564742e-11,  1.183573562976001e-11,  2.001676272577203e+00, -9.851086909852670e-04,  1.727928703693495e-04, -3.036622966567410e-05,
  5.347964780918965e-06, -9.441522833555616e-07,  1.671435719091509e-07, -2.968147992112454e-08,  5.289317062776195e-09, -9.462459613777590e-10,  1.698511958419293e-10,
 -2.968602940052340e-11,  2.001792426305762e+00, -1.059498405596938e-03,  1.931593690275054e-04, -3.536419851054226e-05,  6.503808950539717e-06, -1.201849383103722e-06,
  2.232183249530430e-07, -4.167933038187044e-08,  7.825774904488695e-09, -1.477829471507989e-09,  2.803854293581696e-10, -5.167140354408807e-11,  1.999727576360066e+00,
  2.162020094938119e-04, -1.045140499275720e-04,  3.078851710912108e-05, -7.730806214837022e-06,  1.792052668217179e-06, -3.959322352527146e-07,  8.472047518247449e-08,
 -1.771911096304017e-08,  3.643010030394132e-09, -7.381072142138652e-10,  1.425942075240722e-10,  2.000066382068158e+00, -7.147625923118307e-07, -4.524268550917931e-05,
  1.631150037249876e-05, -4.408211379168612e-06,  1.059133833128092e-06, -2.386419333284654e-07,  5.163839695331655e-08, -1.086758764372510e-08,  2.241252125479731e-09,
 -4.545398732992990e-10,  8.777891828133351e-11,  2.000299170159851e+00, -1.493819883491803e-04, -5.073831317272193e-06,  6.609986142781930e-06, -2.206399014407045e-06,
  5.788046474466383e-07, -1.366871214858526e-07,  3.042714899041169e-08, -6.521737985066781e-09,  1.361574625475898e-09, -2.784469012104930e-10,  5.406706475143935e-11,
  2.000472236074237e+00, -2.597116145937286e-04,  2.449757261804557e-05, -4.749480906916798e-07, -6.111725998120979e-07,  2.335282221220136e-07, -6.396516184530426e-08,
  1.541302422605249e-08, -3.468702138099327e-09,  7.481609763936525e-10, -1.565451202780331e-10,  3.088521860782052e-11,  2.000603622994470e+00, -3.433588251033234e-04,
  4.678154650604858e-05, -5.781727937178055e-06,  5.765725779086630e-07, -2.204251927369203e-08, -1.044792755743986e-08,  4.426649955826560e-09, -1.247151600211447e-09,
  3.042530933823245e-10, -6.880031802677189e-11,  1.428062722455587e-11,  2.000702581877896e+00, -4.062969648819689e-04,  6.347125587900726e-05, -9.738080010394298e-06,
  1.458073189167665e-06, -2.108758728471869e-07,  2.892200430546632e-08, -3.620933579047741e-09,  3.733338460308384e-10, -1.822381920437818e-11, -5.312332051855806e-12,
  2.310102507142147e-12,  2.000774464029805e+00, -4.519798428110599e-04,  7.554368652992745e-05, -1.259014873486086e-05,  2.091402727422793e-06, -3.461001461255313e-07,
  5.702405963475847e-08, -9.347129491841459e-09,  1.522820149305270e-09, -2.462826556762651e-10,  3.945562861188815e-11, -6.108284937491926e-12,  2.000822511666956e+00,
 -4.824991687692464e-04,  8.358940503562722e-05, -1.448636930248145e-05,  2.511485347329299e-06, -4.355862879959665e-07,  7.557888187644488e-08, -1.311959075412849e-08,
  2.278477965815611e-09, -3.958906184719371e-10,  6.876385107020102e-11, -1.160932574610656e-11,  2.000848653419532e+00, -4.990986911839994e-04,  8.795892693369746e-05,
 -1.551465341997876e-05,  2.738956027314936e-06, -4.839729733598587e-07,  8.559778250800015e-08, -1.515379987439316e-08,  2.685406630858215e-09, -4.763515991460120e-10,
  8.450641426068711e-11, -1.456077633955441e-11,  2.000156046483262e+00, -7.938146966479899e-05, -5.849796215336093e-07,  2.670181375050440e-06, -9.228517947651518e-07,
  2.423428026253900e-07, -5.675944371727090e-08,  1.248044094704974e-08, -2.636449985572452e-09,  5.416979187792150e-10, -1.089184270775440e-10,  2.080342383619468e-11,
  2.000232060239555e+00, -1.276688941286161e-04,  1.214887813415068e-05, -3.303628084517387e-07, -2.586088390756449e-07,  1.010285627341647e-07, -2.751284482804293e-08,
  6.548774258334212e-09, -1.451908616729815e-09,  3.080358794834824e-10, -6.333851619964309e-11,  1.228668125140695e-11,  2.000285247953136e+00, -1.614155134177768e-04,
  2.099894422287568e-05, -2.404144392773068e-06,  1.979195691914478e-07,  4.443230066009042e-09, -7.633879710423867e-09,  2.539201194176699e-09, -6.555932794350324e-10,
  1.518118359367619e-10, -3.302891259883198e-11,  6.651710701295760e-12,  2.000325307837034e+00, -1.868106705826649e-04,  2.763209883428836e-05, -3.952185186589003e-06,
  5.373390655915272e-07, -6.707838447625587e-08,  7.027885290290266e-09, -4.063529107510996e-10, -7.289883498083837e-11,  3.794379717501082e-11, -1.102239894137432e-11,
  2.575102982198961e-12,  2.000356019549623e+00, -2.062668864275851e-04,  3.269847231690358e-05, -5.130944550805914e-06,  7.950006301639592e-07, -1.212070807103207e-07,
  1.809061975059242e-08, -2.622193202296164e-09,  3.641371443805983e-10, -4.720788384982055e-11,  5.386278883308368e-12, -4.562964010178263e-13,  2.000379323785643e+00,
 -2.210229372248078e-04,  3.653193245284116e-05, -6.020757593895673e-06,  9.890478326874757e-07, -1.618772455554466e-07,  2.638356787420225e-08, -4.279454590142197e-09,
  6.902622078869467e-10, -1.106070302124993e-10,  1.757617558693069e-11, -2.703671258605999e-12,  2.000396345406225e+00, -2.317968279706783e-04,  3.932596778990293e-05,
 -6.668164228747540e-06,  1.129985441202342e-06, -1.913650160379094e-07,  3.238600413481820e-08, -5.476935887286642e-09,  9.255112128905098e-10, -1.562632584059138e-10,
  2.634012623844961e-11, -4.316955391681446e-12,  2.000407767331123e+00, -2.390244515879925e-04,  4.119801582123348e-05, -7.101399559471325e-06,  1.224182668116021e-06,
 -2.110493944631546e-07,  3.638803522413141e-08, -6.274378886604804e-09,  1.081985066882548e-09, -1.865953524912500e-10,  3.215577532146044e-11, -5.386359671960664e-12,
  2.000413996742131e+00, -2.429656796443938e-04,  4.221805985401281e-05, -7.337279760593624e-06,  1.275430243522758e-06, -2.217504623386447e-07,  3.856203271848182e-08,
 -6.707245951010298e-09,  1.166859375088363e-09, -2.030360353741228e-10,  3.530572363613354e-11, -5.965198761408438e-12,  2.000142617050352e+00, -8.076657344561592e-05,
  1.059156582820757e-05, -1.241806895158636e-06,  1.116853804908024e-07, -1.304284358907876e-09, -2.921675158933612e-09,  1.055256798082911e-09, -2.786089857499617e-10,
  6.497553374985979e-11, -1.414987476994769e-11,  2.844391714485030e-12,  2.000160652059120e+00, -9.218062498841134e-05,  1.355002923705593e-05, -1.926875020161377e-06,
  2.607100055049254e-07, -3.245718352060336e-08,  3.413512610717725e-09, -2.072258462637788e-10, -3.089075182650047e-11,  1.696327889613782e-11, -4.946967671940756e-12,
  1.152763243394450e-12,  2.000173381586428e+00, -1.002321721147937e-04,  1.563120193470973e-05, -2.407458316095625e-06,  3.649618724753936e-07, -5.418997679398813e-08,
  7.820779011149460e-09, -1.083076283758460e-09,  1.404890102943481e-10, -1.616153472968154e-11,  1.384933193732746e-12, -8.151315433644216e-15,  2.000183029735010e+00,
 -1.063320964915028e-04,  1.720475045935573e-05, -2.770086369318340e-06,  4.434667051463381e-07, -7.052233331471389e-08,  1.112618697773741e-08, -1.738633030860242e-09,
  2.685057580524430e-10, -4.085546873115605e-11,  6.095866269279923e-12, -8.702684755077203e-13,  2.000190461928271e+00, -1.110294688796083e-04,  1.841463280639316e-05,
 -3.048475630149162e-06,  5.036415847216127e-07, -8.302194467588517e-08,  1.365201172799804e-08, -2.238806780728029e-09,  3.660298700966279e-10, -5.963879561053450e-11,
  9.673792781001118e-12, -1.524116427829322e-12,  2.000196122193223e+00, -1.146060289280150e-04,  1.933474613489657e-05, -3.259939004311506e-06,  5.492959559857446e-07,
 -9.249410683343745e-08,  1.556381320183188e-08, -2.616943767512442e-09,  4.396727592723304e-10, -7.380599285276782e-11,  1.236929479000681e-11, -2.016173425236159e-12,
  2.000200267821696e+00, -1.172250398412310e-04,  2.000792270946551e-05, -3.414513013422272e-06,  5.826383980680915e-07, -9.940570962609695e-08,  1.695757410711811e-08,
 -2.892374181891101e-09,  4.932662842120999e-10, -8.410714679222688e-11,  1.432753199342125e-11, -2.373355724421496e-12,  2.000203055015224e+00, -1.189856215728026e-04,
  2.046017014292562e-05, -3.518292207265639e-06,  6.050100499630542e-07, -1.040402527700480e-07,  1.789156981182898e-08, -3.076832395395076e-09,  5.291360931227726e-10,
 -9.099738913920096e-11,  1.563655767275099e-11, -2.611985626078479e-12,  2.000204576947620e+00, -1.199468983689917e-04,  2.070700095893634e-05, -3.574911395260691e-06,
  6.172106607440744e-07, -1.065667630848449e-07,  1.840053755249643e-08, -3.177311392645951e-09,  5.486677463956424e-10, -9.474779170688062e-11,  1.634879790321667e-11,
 -2.741778013590821e-12,  2.000086512834651e+00, -5.001080394828201e-05,  7.797239991768803e-06, -1.201607074415482e-06,  1.824844076417567e-07, -2.719250050897698e-08,
  3.949741890540265e-09, -5.532322351982495e-10,  7.328661645501091e-11, -8.813572747056249e-12,  8.599305125230648e-13, -3.945216842477301e-14,  2.000090907062283e+00,
 -5.278678085845721e-05,  8.510654427164357e-06, -1.365392212055230e-06,  2.178067723426448e-07, -3.451288929666426e-08,  5.425567546054159e-09, -8.447991888923493e-10,
  1.300027298731497e-10, -1.971129692790258e-11,  2.930833628785477e-12, -4.170491952323120e-13,  2.000094021825631e+00, -5.475390324972128e-05,  9.015502193817883e-06,
 -1.481134144734084e-06,  2.427333105745100e-07, -3.967160728410648e-08,  6.464143225260453e-09, -1.049696906860226e-09,  1.698044136545692e-10, -2.734838163447868e-11,
  4.380111265806618e-12, -6.809609423098545e-13,  2.000096389935123e+00, -5.624915862198823e-05,  9.398863282027073e-06, -1.568934887617890e-06,  2.616231465553240e-07,
 -4.357701644827291e-08,  7.249598754519632e-09, -1.204499998963941e-09,  1.998446594949787e-10, -3.310662221438926e-11,  5.471743700560500e-12, -8.795586454784884e-13,
  2.000098218466554e+00, -5.740352862108928e-05,  9.694598727673550e-06, -1.636614281918203e-06,  2.761726648179836e-07, -4.658274001267994e-08,  7.853639693757026e-09,
 -1.323456187606972e-09,  2.229107491179703e-10, -3.752460430853827e-11,  6.308648787634441e-12, -1.031704838355284e-12,  2.000099613583132e+00, -5.828416893406830e-05,
  9.920074531777949e-06, -1.688183907953521e-06,  2.872523277126639e-07, -4.887027300324356e-08,  8.313075999806646e-09, -1.413880853094473e-09,  2.404340198219707e-10,
 -4.087894336571810e-11,  6.943690998737876e-12, -1.147089305193757e-12,  2.000100636769801e+00, -5.892997484779460e-05,  1.008535081338716e-05, -1.725968102936829e-06,
  2.953665698496034e-07, -5.054480720485665e-08,  8.649244791340892e-09, -1.480014837675634e-09,  2.532443100536106e-10, -4.333002159540466e-11,  7.407522694109576e-12,
 -1.231330626432236e-12,  2.000101325341963e+00, -5.936455275112930e-05,  1.019653412081390e-05, -1.751377923180923e-06,  3.008216544811212e-07, -5.167021439877808e-08,
  8.875102718936621e-09, -1.524433464054271e-09,  2.618455712280033e-10, -4.497523925871534e-11,  7.718759179031087e-12, -1.287840964100367e-12,  2.000101701558154e+00,
 -5.960198387189164e-05,  1.025726710480532e-05, -1.765255095872319e-06,  3.038002745456307e-07, -5.228459507032157e-08,  8.998378434584543e-09, -1.548672859773203e-09,
  2.665383861679477e-10, -4.587268763052758e-11,  7.888502217646886e-12, -1.318655113657831e-12,  2.000046945862812e+00, -2.733668951969978e-05,  4.498423940057916e-06,
 -7.386778941891407e-07,  1.210149601925001e-07, -1.977456929547682e-08,  3.222081027608666e-09, -5.233393854547349e-10,  8.469879468878275e-11, -1.365235300959859e-11,
  2.189153928641193e-12, -3.408683988388409e-13,  2.000048030489608e+00, -2.802126782153239e-05,  4.673614595089502e-06, -7.787265851039594e-07,  1.296150210549711e-07,
 -2.154925063051742e-08,  3.578330159880035e-09, -5.934184626478046e-10,  9.827214559432987e-11, -1.624920291061616e-11,  2.680524327086797e-12, -4.301028916046488e-13,
  2.000048800924565e+00, -2.850746854284180e-05,  4.797953020782165e-06, -8.071307417350049e-07,  1.357102946959416e-07, -2.280617671518325e-08,  3.830469536410606e-09,
 -6.429831869704946e-10,  1.078654647805593e-10, -1.808331683468529e-11,  3.027331043137322e-12, -4.930432568165992e-13,  2.000049387575696e+00, -2.887764884405928e-05,
  4.892573449445459e-06, -8.287350948870770e-07,  1.403440348607924e-07, -2.376122873983208e-08,  4.021955390993949e-09, -6.806056702576676e-10,  1.151436392420502e-10,
 -1.947409807320773e-11,  3.290176229003015e-12, -5.407231925364314e-13,  2.000049841090537e+00, -2.916379601879111e-05,  4.965686311599453e-06, -8.454222126874015e-07,
  1.439217223196594e-07, -2.449833180014837e-08,  4.169685255022521e-09, -7.096197968376083e-10,  1.207543130113523e-10, -2.054581976956872e-11,  3.492643441841568e-12,
 -5.774372551971805e-13,  2.000050187422202e+00, -2.938230178884136e-05,  5.021499721532070e-06, -8.581571339533112e-07,  1.466512474373366e-07, -2.506052105106558e-08,
  4.282325146591198e-09, -7.317356176152407e-10,  1.250297280286314e-10, -2.136224251716870e-11,  3.646834164571785e-12, -6.053893670126782e-13,  2.000050441596245e+00,
 -2.954265639791506e-05,  5.062450339779221e-06, -8.674987211828661e-07,  1.486530153148129e-07, -2.547272416991215e-08,  4.364895294606222e-09, -7.479438642267990e-10,
  1.281623893376869e-10, -2.196031324101797e-11,  3.759761341033090e-12, -6.258568183844327e-13,  2.000050612729486e+00, -2.965061820190950e-05,  5.090016780600073e-06,
 -8.737861321218137e-07,  1.500001022513953e-07, -2.575007141312515e-08,  4.420443023800937e-09, -7.588459595369664e-10,  1.302691641478680e-10, -2.236246319296813e-11,
  3.835682897873325e-12, -6.396151543132704e-13,  2.000050706259750e+00, -2.970962185556560e-05,  5.105081008151450e-06, -8.772216723417402e-07,  1.507360986867837e-07,
 -2.590158821554574e-08,  4.450786134944874e-09, -7.648006699428779e-10,  1.314197676430110e-10, -2.258207340838775e-11,  3.877138839955538e-12, -6.471270139779770e-13,
  2.000024381716182e+00, -1.424198808405385e-05,  2.396077963779502e-06, -4.029317778795958e-07,  6.772569657226674e-08, -1.137777551847982e-08,  1.910438391879628e-09,
 -3.206045315673991e-10,  5.377189463308221e-11, -9.012989364456631e-12,  1.508637025576629e-12, -2.456758493947029e-13,  2.000024651155041e+00, -1.441197242239468e-05,
  2.439487038374944e-06, -4.128340148283081e-07,  6.984756523895146e-08, -1.181470125684877e-08,  1.997959006291985e-09, -3.377841536876644e-10,  5.709221974430469e-11,
 -9.646871653606807e-12,  1.628322875903145e-12, -2.673676953636111e-13,  2.000024842743769e+00, -1.453283368241948e-05,  2.470340921369001e-06, -4.198697950207665e-07,
  7.135468073553378e-08, -1.212493175524762e-08,  2.060079645345939e-09, -3.499737070794532e-10,  5.944728746532438e-11, -1.009632025994960e-11,  1.713155620058689e-12,
 -2.827377679047633e-13,  2.000024988741525e+00, -1.462492957576681e-05,  2.493845577780529e-06, -4.252283319174915e-07,  7.250222640864984e-08, -1.236108680420725e-08,
  2.107355335015216e-09, -3.592479598330540e-10,  6.123865087260574e-11, -1.043810253067161e-11,  1.777650121640099e-12, -2.944201570685759e-13,  2.000025101672357e+00,
 -1.469616383481097e-05,  2.512022438527195e-06, -4.293714444212782e-07,  7.338931236920077e-08, -1.254360579221710e-08,  2.143886516613097e-09, -3.664130189713466e-10,
  6.262234326212148e-11, -1.070205176969628e-11,  1.827447787075971e-12, -3.034387473940022e-13,  2.000025187952163e+00, -1.475058551210525e-05,  2.525907170660599e-06,
 -4.325357641190343e-07,  7.406672627380349e-08, -1.268296354196569e-08,  2.171774776729430e-09, -3.718820714689963e-10,  6.367834948616216e-11, -1.090346220900830e-11,
  1.865440952340608e-12, -3.103185211052288e-13,  2.000025251294674e+00, -1.479053836659990e-05,  2.536099302476678e-06, -4.348582819585181e-07,  7.456387212228798e-08,
 -1.278522494999431e-08,  2.192237006869792e-09, -3.758943819072668e-10,  6.445298928581065e-11, -1.105119136556764e-11,  1.893304785039216e-12, -3.153635507570211e-13,
  2.000025293952888e+00, -1.481744429322201e-05,  2.542962569631325e-06, -4.364221148394307e-07,  7.489859113957471e-08, -1.285407013580501e-08,  2.206011638362707e-09,
 -3.785951466880356e-10,  6.497437274905966e-11, -1.115061482977843e-11,  1.912055978395440e-12, -3.187583909280750e-13,  2.000025317270567e+00, -1.483215136074181e-05,
  2.546713920683270e-06, -4.372768382767827e-07,  7.508152498145282e-08, -1.289169419137520e-08,  2.213539131533971e-09, -3.800709738165821e-10,  6.525926742195950e-11,
 -1.120493915311295e-11,  1.922300998228340e-12, -3.206131308884391e-13,  2.000012416380156e+00, -7.263273971223938e-06,  1.234376508683077e-06, -2.097568490294335e-07,
  3.563993861676719e-08, -6.054928538034970e-09,  1.028564008957873e-09, -1.747039645517500e-10,  2.967030006220591e-11, -5.038232290029545e-12,  8.547516743810954e-13,
 -1.410461641054024e-13,  2.000012483526585e+00, -7.305626058077251e-06,  1.245180620370923e-06, -2.122188050683099e-07,  3.616692842799725e-08, -6.163328025907460e-09,
  1.050254298614088e-09, -1.789570458818320e-10,  3.049141807584228e-11, -5.194823882400844e-12,  8.842868375184510e-13, -1.463937605726530e-13,  2.000012531297005e+00,
 -7.335755786387461e-06,  1.252865464094636e-06, -2.139696638218300e-07,  3.654164041666762e-08, -6.240391220829078e-09,  1.065671639153508e-09, -1.819795861193779e-10,
  3.107486082695823e-11, -5.306070131468052e-12,  9.052656496217361e-13, -1.501915372455432e-13,  2.000012567713748e+00, -7.358723921348053e-06,  1.258722946931016e-06,
 -2.153040208002260e-07,  3.682717796861140e-08, -6.299107330970732e-09,  1.077416944195542e-09, -1.842819367580360e-10,  3.151922818183279e-11, -5.390787762293425e-12,
  9.212396643032241e-13, -1.530829547605154e-13,  2.000012595890741e+00, -7.376494862653309e-06,  1.263254571067626e-06, -2.163362416694300e-07,  3.704804018327744e-08,
 -6.344519576552175e-09,  1.086500114817309e-09, -1.860622732188890e-10,  3.186281002472418e-11, -5.456284444770755e-12,  9.335882494992969e-13, -1.553179375908836e-13,
  2.000012617422978e+00, -7.390074811295876e-06,  1.266717227252268e-06, -2.171249121894192e-07,  3.721677773906107e-08, -6.379211678181425e-09,  1.093438563416321e-09,
 -1.874221333598720e-10,  3.212522560118355e-11, -5.506304706485709e-12,  9.430182398864047e-13, -1.570245608483068e-13,  2.000012633233594e+00, -7.400046131163019e-06,
  1.269259602768856e-06, -2.177039427740902e-07,  3.734065543783160e-08, -6.404679243016080e-09,  1.098531808785756e-09, -1.884202972845882e-10,  3.231783285185940e-11,
 -5.543016396809314e-12,  9.499388626415319e-13, -1.582769768743708e-13,  2.000012643882580e+00, -7.406762097271751e-06,  1.270971897030650e-06, -2.180939053202822e-07,
  3.742408061684559e-08, -6.421829634306497e-09,  1.101961569255350e-09, -1.890924278291801e-10,  3.244752299268863e-11, -5.567734849472301e-12,  9.545984206290770e-13,
 -1.591201793755930e-13,  2.000012649703925e+00, -7.410433409347528e-06,  1.271907907133228e-06, -2.183070695145346e-07,  3.746968196591956e-08, -6.431204039953886e-09,
  1.103836229871745e-09, -1.894597961035962e-10,  3.251840632514533e-11, -5.581244608320989e-12,  9.571450176914370e-13, -1.595810056884092e-13,  2.000006264362743e+00,
 -3.667066616701974e-06,  6.262256735357278e-07, -1.069378948754690e-07,  1.826084916308732e-08, -3.118162656883989e-09,  5.324329216469909e-10, -9.091158800049071e-11,
  1.552248982047450e-11, -2.650216510508237e-12,  4.521070505082864e-13, -7.500157328467956e-14,  2.000006281122779e+00, -3.677636702725270e-06,  6.289207076630192e-07,
 -1.075516920762972e-07,  1.839216447924081e-08, -3.145159222697107e-09,  5.378319365180585e-10, -9.196967307088057e-11,  1.572665896335489e-11, -2.689131827618647e-12,
  4.594430628646165e-13, -7.632915794822191e-14,  2.000006293049585e+00, -3.685158469273728e-06,  6.308383534543185e-07, -1.079884003824040e-07,  1.848558541435727e-08,
 -3.164363570059452e-09,  5.416722592057938e-10, -9.272222404031247e-11,  1.587185927954691e-11, -2.716805076700826e-12,  4.646593550394089e-13, -7.727306384889716e-14,
  2.000006302143460e+00, -3.690893542435031e-06,  6.323003967677636e-07, -1.083213325553588e-07,  1.855680195616967e-08, -3.179002472895760e-09,  5.445994361012748e-10,
 -9.329579800203207e-11,  1.598251995511285e-11, -2.737894181916629e-12,  4.686343105369831e-13, -7.799230270187447e-14,  2.000006309180761e+00, -3.695331586843924e-06,
  6.334317337809885e-07, -1.085789447348298e-07,  1.861190432820201e-08, -3.190328476312495e-09,  5.468640587832206e-10, -9.373952415127610e-11,  1.606812465630565e-11,
 -2.754207456833052e-12,  4.717089490515123e-13, -7.854861036234224e-14,  2.000006314559117e+00, -3.698723397934345e-06,  6.342963351180128e-07, -1.087758122387495e-07,
  1.865401203695877e-08, -3.198983168886956e-09,  5.485944903741071e-10, -9.407856905433927e-11,  1.613353153457635e-11, -2.766671259664381e-12,  4.740579714331814e-13,
 -7.897361417176232e-14,  2.000006318508651e+00, -3.701214121212115e-06,  6.349312238600846e-07, -1.089203707073980e-07,  1.868493056767910e-08, -3.205337891424365e-09,
  5.498650266794538e-10, -9.432749923498755e-11,  1.618155256134047e-11, -2.775821790228458e-12,  4.757825008119218e-13, -7.928562147795353e-14,  2.000006321168956e+00,
 -3.702891801402470e-06,  6.353588583731085e-07, -1.090177373068343e-07,  1.870575516529739e-08, -3.209617910010658e-09,  5.507207382880073e-10, -9.449515140360999e-11,
  1.621389362781150e-11, -2.781984340079363e-12,  4.769438854498009e-13, -7.949573891459999e-14,  2.000006322623285e+00, -3.703808949182045e-06,  6.355926330972211e-07,
 -1.090709639915889e-07,  1.871713905349477e-08, -3.211957578020187e-09,  5.511885063638123e-10, -9.458679600796011e-11,  1.623157217736637e-11, -2.785352923500962e-12,
  4.775787155776883e-13, -7.961059089100131e-14,  2.000003146198644e+00, -1.842373234991955e-06,  3.153663466030780e-07, -5.398216475855110e-08,  9.240222943045303e-09,
 -1.581655124994307e-09,  2.707312018379403e-10, -4.634063510563535e-11,  7.931996187749695e-12, -1.357656345491307e-12,  2.321896945175561e-13, -3.861131779244897e-14,
  2.000003150385337e+00, -1.845013518523667e-06,  3.160393575179227e-07, -5.413540311702352e-08,  9.272997912452134e-09, -1.588391395870879e-09,  2.720780217562630e-10,
 -4.660451086888715e-11,  7.982900301456421e-12, -1.367356244154959e-12,  2.340177568272269e-13, -3.894205622361924e-14,  2.000003153365066e+00, -1.846892629013513e-06,
  3.165183241476196e-07, -5.424445466988224e-08,  9.296321094251296e-09, -1.593184823194474e-09,  2.730363564614932e-10, -4.679226446142522e-11,  8.019118153731097e-12,
 -1.374257340137717e-12,  2.353182946881218e-13, -3.917734378700585e-14,  2.000003155637248e+00, -1.848325528428978e-06,  3.168835445349944e-07, -5.432760574002555e-08,
  9.314104296350698e-09, -1.596839546177132e-09,  2.737670102968874e-10, -4.693540703915940e-11,  8.046729614981494e-12, -1.379518371424803e-12,  2.363097245407171e-13,
 -3.935670353995896e-14,  2.000003157395706e+00, -1.849434453915218e-06,  3.171661829634206e-07, -5.439195350597459e-08,  9.327865771385877e-09, -1.599667672850483e-09,
  2.743323967797268e-10, -4.704616933239337e-11,  8.068094563155708e-12, -1.383589105047335e-12,  2.370768266584075e-13, -3.949547694216931e-14,  2.000003158739708e+00,
 -1.850282010162931e-06,  3.173822006550528e-07, -5.444113293153306e-08,  9.338383132832758e-09, -1.601829059623273e-09,  2.747644834437804e-10, -4.713081586724996e-11,
  8.084421732224054e-12, -1.386699915366126e-12,  2.376630267229806e-13, -3.960152220099326e-14,  2.000003159726702e+00, -1.850904427959731e-06,  3.175408348256646e-07,
 -5.447724769395686e-08,  9.346106416301337e-09, -1.603416222577265e-09,  2.750817715097336e-10, -4.719297227421013e-11,  8.096410690447410e-12, -1.388984135352573e-12,
  2.380934582984915e-13, -3.967938746534898e-14,  2.000003160391536e+00, -1.851323684283800e-06,  3.176476886510617e-07, -5.450157386545745e-08,  9.351308611328116e-09,
 -1.604485281928136e-09,  2.752954838869722e-10, -4.723483788924755e-11,  8.104485804326657e-12, -1.390522646936116e-12,  2.383833679127719e-13, -3.973183175167156e-14,
  2.000003160754992e+00, -1.851552886299170e-06,  3.177061038977585e-07, -5.451487250482399e-08,  9.354152531278870e-09, -1.605069708351527e-09,  2.754123140512324e-10,
 -4.725772442559115e-11,  8.108900172315664e-12, -1.391363689414029e-12,  2.385418488650292e-13, -3.976050058997306e-14,   0.00161275472147171,    0.0013185369363036,
   0.00078129645410919,  0.000185960333415819,  2.19230455293979e-05,  1.19379934167203e-06,  2.57439471252298e-08,  1.60216402223268e-10,  1.27874067811003e-13,
  0.000804741402369587,  0.000657826371094664,   0.00038997031911605,  9.28600539054708e-05,  1.09541551424235e-05,  5.96999542425213e-07,  1.28887495570557e-08,
  8.03395845373797e-11,  6.42772701432514e-14,   0.00040197079278179,  0.000328574679393813,   0.00019480402076989,  4.63914061481975e-05,  5.47325551096889e-06,
   2.9834466967146e-07,  6.44254301730035e-09,  4.01711347756805e-11,  3.21546397926156e-14,  0.000200886422315482,  0.000164205062574094,  9.73555402500263e-05,
  2.31851672720116e-05,  2.73547053268659e-06,  1.49115423353868e-07,  3.22021648511909e-09,  2.00804311606096e-11,   1.6074861860219e-14,  0.000100418586286143,
  8.20822353624134e-05,  4.86660180663833e-05,  1.15898493319806e-05,  1.36742304737973e-06,  7.45414356311543e-08,  1.60977761059488e-09,  1.00383255614332e-11,
  8.03611286999968e-15,  5.02031513727023e-05,  4.10360767176621e-05,   2.4330054974633e-05,   5.7942290956831e-06,  6.83630734824212e-07,  3.72664051303548e-08,
   8.0479822399096e-10,  5.01861888738378e-12,  4.01764470543981e-15,  2.51000420267813e-05,   2.0516782176447e-05,  1.21642870131446e-05,  2.89693918873578e-06,
  3.41794836174088e-07,  1.86320946693096e-08,  4.02375502156557e-10,  2.50916480462417e-12,  2.00870948060502e-15,  1.25496378199744e-05,  1.02580775457439e-05,
  6.08195814589271e-06,  1.44842557327513e-06,  1.70892243997501e-07,  9.31576668993571e-09,  2.01181729633153e-10,  1.25454517501671e-12,  1.00432530025885e-15,
  6.27472313923102e-06,  5.12896044988233e-06,  3.04093270268263e-06,  7.24201758823372e-07,  8.54448233455562e-08,   4.6578127277118e-09,  1.00589344679562e-10,
  6.27263148211009e-13,  5.02155138626077e-16,  3.13733763037081e-06,  2.56446065200642e-06,  1.52045475502443e-06,   3.6209811964819e-07,  4.27220863699426e-08,
   2.3288886527043e-09,  5.02942904646128e-11,  3.13629197782051e-13,  2.51075672578785e-16,  1.56866283080444e-06,  1.28222543374511e-06,   7.6022447796479e-07,
  1.81048369532456e-07,  2.13609617794334e-08,  1.16443989147027e-09,  2.51470495337772e-11,  1.56814002751515e-13,  1.25537359753392e-16  };
  int offset = -9;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 9;
    if (std::isnan(t)) {
      fill_n(rr+offset, 9, 0.5);
      fill_n(ww+offset, 9, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 9; ++r) {
        ww[offset+r] = aw[9-r-1] / t;
        rr[offset+r] = 1.0 - ax[9-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=9; ++j) {
        const int boxof = it*108+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 4644 + (it - 32) * 9 + 9 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
