// bbmail.hh for bbmail - an tool to display new mail in X11.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#ifndef __MAIN_HH
#define __MAIN_HH

#include "Image.hh"
#include "Basewindow.hh"
#include "mailboxmenu.hh"
#include "resource.hh"
#include "Timer.hh"

#define LEFT_BUTTON 1
#define MIDDLE_BUTTON 2
#define RIGHT_BUTTON 3

class Resource;
class Mailboxmenu;
class Basemenu;
class BaseResource;
class Basewindow;
class ToolWindow;

struct PIXMAP
{
	Pixmap 	frame;
	Pixmap	label;
	Pixmap	envelope;
	Pixmap	envelope_pressed;
};

struct PIXMAPLIST
{
	Pixmap	envelope_newmail;
	Pixmap	envelope_newmail_pressed;
};

struct LABELSIZE
{
	int width0;
	int width1;
	int width2;
	int width3;
	int width;
	int height;
};

struct FRAMESIZE
{
	int x;
	int y;
	int height;
	int width;
};

struct ENVELOPESIZE
{
	int height;
	int width;
};

struct LOCALSPOOLFILE
{
	time_t last_mtime;
	off_t last_size;
	int newmail;
	int totalmail;
};

class Checkmail : public TimeoutHandler
{
public:
	Checkmail(ToolWindow *);
	virtual ~Checkmail(void);
	void Reconfigure(void);
	int getNewmail(void)
	{
		return(newmail);
	}
	int getLastTotalmail(void)
	{
		return(last_totalmail);
	}
	bool getBroken(void)
	{
		return(broken);
	}
	int getNewMailbox(void)
	{
		return(new_mailbox);
	}
	void forceCheck(void);
private:
	bool CheckOther(int,bool);
	bool CheckMbox(int);
	bool CheckMaildir(int);
	int ReadPipe(FILE *,int *,int);
	bool checkStatusFlag(char *,int);
	bool getChar(char *,int *);
	void timeout(void);

	struct LOCALSPOOLFILE *spoolfile;
	ToolWindow *bbtool;
	BTimer *timer;
	int new_mailbox;
	int last_totalmail;
	int last_newmail;
	int newmail;
	bool broken;
	unsigned int number_of_checks;
};

class ToolWindow : public Basewindow
{
public:
	ToolWindow(int argc,char **argv,struct CMDOPTIONS *);
	~ToolWindow(void);

	Window framewin;
	Window labelwin;
	Window envelopewin;

	struct FRAMESIZE Frame(void)
	{
		return frame;
	}
	void EnvelopePushed(bool pushed)
	{
		envelopePushed=pushed;
	}
	void CreateWindow(void);
	void MakeWindow(bool);
	void EventLoop(void);
	void reconfigure(void);
	//void CheckConfig(void);
	void Redraw(bool);

	bool raised;
	char *spooldir;

	GC getMenuTitleGC(void)
	{
		return NULL;/*menuTitleGC;*/
	}
	GC getMenuHiBGGC(void)
	{
		return menuHiBGGC;
	}
	GC getMenuHiGC(void)
	{
		return menuHiGC;
	}
	GC getMenuFrameGC(void)
	{
		return menuFrameGC;
	}
	void saveMenuSearch(Window,Basemenu *);
	void removeMenuSearch(Window window);
	Resource *getResource(void);

	enum { AlignDontCare = 1, AlignTop, AlignBottom };
	enum { Right = 1, Left };
	enum { Empty = 0, Round, Square, Triangle, Diamond };

	Mailboxmenu *mbmenu;

protected:
	virtual void process_event(XEvent *);

private:

	Checkmail *checkmail;
	Window menuwin;
	Basemenu* basemenu;
	int server_grabs;

	BColor bckColor;
	XGCValues gcv;
	GC frameGC;
	GC labelGC;
	struct LABELSIZE label;
	struct FRAMESIZE frame;
	struct ENVELOPESIZE envelope;
	//	struct LOCALSPOOLFILE *spoolfile;

	bool close_app;
	bool mapped;
	bool envelopePushed;
	XPoint points[11];
	struct PIXMAP pixmap;
	struct PIXMAPLIST *pixmaplist;

	Resource *resource;
	int max_value;

	GC menuGC;
	GC menuHiBGGC;
	GC menuHiGC;
	GC menuFrameGC;

};

#endif /* __MAIN_HH */
