# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Sat Apr  9 10:25:49 2005

import wx, os, BIB

class Pref_Paths(wx.Panel):
	def __init__(self, *args, **kwds):
		# begin wxGlade: Pref_Paths.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.label_2 = wx.StaticText(self, -1, _("You can set here the environment variable $FILES.\nThis variable is substituted when an URL is opened.\nThis allows you to set a central repository\nfor all the articles.\n"))
		self.text_ctrl_dir = wx.TextCtrl(self, -1, "")
		self.button_dir = wx.Button(self, -1, _("Directory ..."))

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		self.__set_evt()

	def __set_properties(self):
		# begin wxGlade: Pref_Paths.__set_properties
		pass
		# end wxGlade
		self.text_ctrl_dir.SetValue(BIB.FILES)

	def __do_layout(self):
		# begin wxGlade: Pref_Paths.__do_layout
		sizer_4 = wx.BoxSizer(wx.VERTICAL)
		sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_4.Add(self.label_2, 0, wx.ALL, 5)
		sizer_5.Add(self.text_ctrl_dir, 1, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
		sizer_5.Add(self.button_dir, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		sizer_4.Add(sizer_5, 0, wx.EXPAND, 0)
		self.SetAutoLayout(1)
		self.SetSizer(sizer_4)
		sizer_4.Fit(self)
		sizer_4.SetSizeHints(self)
		# end wxGlade

	def __set_evt(self):
		wx.EVT_BUTTON(self,self.button_dir.GetId(),self.onDir)

	def onDir(self,evt):
		if self.text_ctrl_dir.GetValue(): default = self.text_ctrl_dir.GetValue()
		elif BIB.FILES: default = BIB.FILES
		else: default = os.path.expanduser('~')
		ret = wx.DirSelector(_('Please, select the default directory'), default)
		if ret:
			self.text_ctrl_dir.SetValue(ret)

	def getSettings(self):
		"""return the current values"""
		return self.text_ctrl_dir.GetValue()

# end of class Pref_Pathsdefault_path


