/*-
 * Copyright (c) 2004 Free (Olivier Beyssac)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ipinfo.h"


int main(int argc, char **argv)
{
  struct ipinfo ipi;
  FILE *f;

  if ((argc >= 2 && !strcmp(argv[1], "-h"))
      || argc != 2) {
    fprintf(stderr, "Usage: %s -h|filename\n", argv[0]);
    exit(EXIT_FAILURE);
  }

  if ((f = fopen(argv[1], "r")) == NULL) {
    perror("fopen");
    exit(EXIT_FAILURE);
  }

  while (fread(&ipi, sizeof(struct ipinfo), 1, f))
    printf("%u.%u.%u.%u;%lu;%lu;%u;%u;%d;%d;%p;%p\n",
	   ipi.iptbl[3], ipi.iptbl[2], ipi.iptbl[1], ipi.iptbl[0],
	   (unsigned long)ipi.start, (unsigned long)ipi.last, ipi.count,
	   ipi.count2, ipi.options, ipi.blp ? 1 : 0, (void *)ipi.iplp,
	   (void *)ipi.blp);
  
  fclose(f);

  exit(EXIT_SUCCESS);
}

