//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotSpecular/SpecularDataWidget.h
//! @brief     Defines class SpecularDataWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTSPECULAR_SPECULARDATAWIDGET_H
#define BORNAGAIN_GUI_VIEW_PLOTSPECULAR_SPECULARDATAWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class SpecularDataCanvas;
class SpecularDataItem;
class SpecularDataPropertyWidget;

class SpecularDataWidget : public DataAccessWidget {
    Q_OBJECT

public:
    SpecularDataWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_or_real_Item) override;

    QList<QAction*> actionList() override;

private slots:
    void onContextMenuRequest(const QPoint& point);

private:
    SpecularDataCanvas* m_specular_canvas;
    SpecularDataPropertyWidget* m_propertyWidget;
    QAction* m_togglePropertiesAction;
};

#endif // BORNAGAIN_GUI_VIEW_PLOTSPECULAR_SPECULARDATAWIDGET_H
