//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/HardParticle/IFormFactorPrism.h
//! @brief     Defines interface IFormFactorPrism.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_SAMPLE_HARDPARTICLE_IFORMFACTORPRISM_H
#define BORNAGAIN_SAMPLE_HARDPARTICLE_IFORMFACTORPRISM_H

#include "Sample/HardParticle/IFormFactorPolyhedron.h"

//! A prism with a polygonal base, for form factor computation.

class IFormFactorPrism : public IFormFactorPolyhedron {
public:
    IFormFactorPrism(const std::vector<double>& PValues);
    ~IFormFactorPrism() override;

    virtual double height() const = 0;

protected:
    void setPrism(bool symmetry_Ci, const std::vector<R3>& base_vertices) const;

    // Each child must have a parameter m_height. We would like to move it here,
    // but this seems incompatible with the current initialization of m_P and
    // with the order of child constructor arguments, especially Box(l, w, h).
};

#endif // BORNAGAIN_SAMPLE_HARDPARTICLE_IFORMFACTORPRISM_H
