# ---------------------------------------------------------------
# directories for building a Python package
# ---------------------------------------------------------------

function(set_python_package_dirs pyversion)
    # Python package directory structure:
    #
    # PythonPackage/
    # |
    # +--py38  {Python package build-workspace for Python3.8, etc.}
    #    |...{Package setup config files}
    #    +--src
    #    |  |
    #    |  +--bornagain
    #    |     |...{Package init files}
    #    |     +--lib  {BornAgain libraries and their Python wrappers}
    #    |        |
    #    |        +--extra  {Extra dependencies}
    #    |
    #    +--wheel  {wheel for the Python version}

    set(BA_PY_PACKAGE_ROOT_DIR "${CMAKE_SOURCE_DIR}/Wrap/PythonPackage"
        CACHE INTERNAL "" FORCE)

    #------------------------------------------------------------
    # output directories
    # -----------------------------------------------------------
    set(BA_PY_PACKAGE_OUTPUT_DIR  "${CMAKE_BINARY_DIR}/PythonPackage")
    string(REGEX MATCH "([1-9]+)\.([0-9]+)*" _rxmatch ${pyversion})
    # NOTE: Python tag is the `py_version_nodot` defined in PEP 425.
    set(pytag "py${CMAKE_MATCH_1}${CMAKE_MATCH_2}") # eg. 'py38'
    set(_outdir "${BA_PY_PACKAGE_OUTPUT_DIR}/${pytag}")

    set(BA_PY_OUTPUT_DIR "${_outdir}"
        CACHE INTERNAL "" FORCE)
    set(BA_PY_PACKAGE_WHEEL_DIR "${_outdir}/wheel"
        CACHE INTERNAL "" FORCE)
    set(BA_PY_SOURCE_OUTPUT_DIR "${_outdir}/src"
        CACHE INTERNAL "" FORCE)
    set(BA_PY_INIT_OUTPUT_DIR "${_outdir}/src/bornagain"
        CACHE INTERNAL "" FORCE)
    set(BA_PY_LIBRARY_OUTPUT_DIR "${_outdir}/src/bornagain/lib"
        CACHE INTERNAL "" FORCE)
    set(BA_PY_EXTRA_LIBRARY_OUTPUT_DIR "${_outdir}/src/bornagain/lib/extra"
        CACHE INTERNAL "" FORCE)
    # make the directories
    file(MAKE_DIRECTORY
        "${BA_PY_PACKAGE_OUTPUT_DIR}"
        "${BA_PY_PACKAGE_WHEEL_DIR}"
        "${BA_PY_SOURCE_OUTPUT_DIR}"
        "${BA_PY_INIT_OUTPUT_DIR}"
        "${BA_PY_LIBRARY_OUTPUT_DIR}"
        "${BA_PY_EXTRA_LIBRARY_OUTPUT_DIR}"
        )

endfunction(set_python_package_dirs)
