// -*- indent-tabs-mode: nil -*-

#include <cppunit/extensions/HelperMacros.h>

#include <string>
#include <fstream>
#include <iostream>
#include <sstream>

#include "../cache.h"

class CacheTest
  : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(CacheTest);
  CPPUNIT_TEST(TestCacheInFile);
  CPPUNIT_TEST(TestCacheInMemory);
  CPPUNIT_TEST_SUITE_END();

public:
  CacheTest() {};
  void setUp();
  void tearDown();
  void TestCacheInFile();
  void TestCacheInMemory();

};

void CacheTest::setUp() {
}

void CacheTest::tearDown() {
}

void CacheTest::TestCacheInFile() {
  AuthN::Context ctx(AuthN::Context::EmptyContext);
  std::string dbdir = "./";
  std::string dbname = "test_db";
  AuthN::Utils::Cache cache(dbdir, dbname, &ctx);
  cache.SetCacheCheckInterval(10); // 10 seconds check interval

  std::string id = "123";
  std::string data = "my test data";
  AuthN::Utils::Time now = AuthN::Utils::Time();
  long till = now.GetTime() + 5; // 5 seconds from now 
  cache.StoreItem(id, data, till);
  
  std::string retrieved_data;
  retrieved_data = cache.RetrieveItem(id);
  std::cout<<"Data retrieved from cache: "<<retrieved_data<<std::endl;

  sleep(6);
  retrieved_data = cache.RetrieveItem(id);  
  //The data should not be found, becaus it has expired 
  std::cout<<"Data retrieved from cache: "<<retrieved_data<<std::endl;

  std::string id1 = "abc";
  std::string data1 = "my second test data";
  now = AuthN::Utils::Time();
  till = now.GetTime() + 5; // 5 seconds from now
  long till1 = now.GetTime() + 11; // 11 seconds from now
  cache.StoreItem(id, data, till);
  sleep(6);
  cache.StoreItem(id1,data1,till1);

  retrieved_data = cache.RetrieveItem(id);

  std::cout<<"Data1 retrieved from cache: "<<retrieved_data<<std::endl;
  retrieved_data = cache.RetrieveItem(id1);
  std::cout<<"Data2 retrieved from cache: "<<retrieved_data<<std::endl;

  sleep(6);
  retrieved_data = cache.RetrieveItem(id1);
  std::cout<<"Data2 retrieved from cache: "<<retrieved_data<<std::endl;

}

void CacheTest::TestCacheInMemory() {
  AuthN::Context ctx(AuthN::Context::EmptyContext);
  std::string dbdir = "./";
  std::string dbname = ""; //empty, "In-memory database" is used
  AuthN::Utils::Cache cache(dbdir, dbname, &ctx);
  cache.SetCacheCheckInterval(10); // 10 seconds check interval

  std::string id = "123";
  std::string data = "my test data";
  AuthN::Utils::Time now = AuthN::Utils::Time();
  long till = now.GetTime() + 5; // 5 seconds from now
  cache.StoreItem(id, data, till);

  std::string retrieved_data;
  retrieved_data = cache.RetrieveItem(id);
  std::cout<<"Data retrieved from cache: "<<retrieved_data<<std::endl;
}


CPPUNIT_TEST_SUITE_REGISTRATION(CacheTest);

