// Copyright © 2015-2017 winapi-rs developers
// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! common Configuration Manager definitions for both user mode and kernel mode code
use shared::minwindef::{DWORD, ULONG};
ENUM!{enum PNP_VETO_TYPE {
    PNP_VetoTypeUnknown,
    PNP_VetoLegacyDevice,
    PNP_VetoPendingClose,
    PNP_VetoWindowsApp,
    PNP_VetoWindowsService,
    PNP_VetoOutstandingOpen,
    PNP_VetoDevice,
    PNP_VetoDriver,
    PNP_VetoIllegalDeviceRequest,
    PNP_VetoInsufficientPower,
    PNP_VetoNonDisableable,
    PNP_VetoLegacyDriver,
    PNP_VetoInsufficientRights,
}}
pub type PPNP_VETO_TYPE = *mut PNP_VETO_TYPE;
pub const CM_PROB_NOT_CONFIGURED: DWORD = 0x00000001;
pub const CM_PROB_DEVLOADER_FAILED: DWORD = 0x00000002;
pub const CM_PROB_OUT_OF_MEMORY: DWORD = 0x00000003;
pub const CM_PROB_ENTRY_IS_WRONG_TYPE: DWORD = 0x00000004;
pub const CM_PROB_LACKED_ARBITRATOR: DWORD = 0x00000005;
pub const CM_PROB_BOOT_CONFIG_CONFLICT: DWORD = 0x00000006;
pub const CM_PROB_FAILED_FILTER: DWORD = 0x00000007;
pub const CM_PROB_DEVLOADER_NOT_FOUND: DWORD = 0x00000008;
pub const CM_PROB_INVALID_DATA: DWORD = 0x00000009;
pub const CM_PROB_FAILED_START: DWORD = 0x0000000A;
pub const CM_PROB_LIAR: DWORD = 0x0000000B;
pub const CM_PROB_NORMAL_CONFLICT: DWORD = 0x0000000C;
pub const CM_PROB_NOT_VERIFIED: DWORD = 0x0000000D;
pub const CM_PROB_NEED_RESTART: DWORD = 0x0000000E;
pub const CM_PROB_REENUMERATION: DWORD = 0x0000000F;
pub const CM_PROB_PARTIAL_LOG_CONF: DWORD = 0x00000010;
pub const CM_PROB_UNKNOWN_RESOURCE: DWORD = 0x00000011;
pub const CM_PROB_REINSTALL: DWORD = 0x00000012;
pub const CM_PROB_REGISTRY: DWORD = 0x00000013;
pub const CM_PROB_VXDLDR: DWORD = 0x00000014;
pub const CM_PROB_WILL_BE_REMOVED: DWORD = 0x00000015;
pub const CM_PROB_DISABLED: DWORD = 0x00000016;
pub const CM_PROB_DEVLOADER_NOT_READY: DWORD = 0x00000017;
pub const CM_PROB_DEVICE_NOT_THERE: DWORD = 0x00000018;
pub const CM_PROB_MOVED: DWORD = 0x00000019;
pub const CM_PROB_TOO_EARLY: DWORD = 0x0000001A;
pub const CM_PROB_NO_VALID_LOG_CONF: DWORD = 0x0000001B;
pub const CM_PROB_FAILED_INSTALL: DWORD = 0x0000001C;
pub const CM_PROB_HARDWARE_DISABLED: DWORD = 0x0000001D;
pub const CM_PROB_CANT_SHARE_IRQ: DWORD = 0x0000001E;
pub const CM_PROB_FAILED_ADD: DWORD = 0x0000001F;
pub const CM_PROB_DISABLED_SERVICE: DWORD = 0x00000020;
pub const CM_PROB_TRANSLATION_FAILED: DWORD = 0x00000021;
pub const CM_PROB_NO_SOFTCONFIG: DWORD = 0x00000022;
pub const CM_PROB_BIOS_TABLE: DWORD = 0x00000023;
pub const CM_PROB_IRQ_TRANSLATION_FAILED: DWORD = 0x00000024;
pub const CM_PROB_FAILED_DRIVER_ENTRY: DWORD = 0x00000025;
pub const CM_PROB_DRIVER_FAILED_PRIOR_UNLOAD: DWORD = 0x00000026;
pub const CM_PROB_DRIVER_FAILED_LOAD: DWORD = 0x00000027;
pub const CM_PROB_DRIVER_SERVICE_KEY_INVALID: DWORD = 0x00000028;
pub const CM_PROB_LEGACY_SERVICE_NO_DEVICES: DWORD = 0x00000029;
pub const CM_PROB_DUPLICATE_DEVICE: DWORD = 0x0000002A;
pub const CM_PROB_FAILED_POST_START: DWORD = 0x0000002B;
pub const CM_PROB_HALTED: DWORD = 0x0000002C;
pub const CM_PROB_PHANTOM: DWORD = 0x0000002D;
pub const CM_PROB_SYSTEM_SHUTDOWN: DWORD = 0x0000002E;
pub const CM_PROB_HELD_FOR_EJECT: DWORD = 0x0000002F;
pub const CM_PROB_DRIVER_BLOCKED: DWORD = 0x00000030;
pub const CM_PROB_REGISTRY_TOO_LARGE: DWORD = 0x00000031;
pub const CM_PROB_SETPROPERTIES_FAILED: DWORD = 0x00000032;
pub const CM_PROB_WAITING_ON_DEPENDENCY: DWORD = 0x00000033;
pub const CM_PROB_UNSIGNED_DRIVER: DWORD = 0x00000034;
pub const CM_PROB_USED_BY_DEBUGGER: DWORD = 0x00000035;
pub const NUM_CM_PROB_V1: DWORD = 0x00000025;
pub const NUM_CM_PROB_V2: DWORD = 0x00000032;
pub const NUM_CM_PROB_V3: DWORD = 0x00000033;
pub const NUM_CM_PROB_V4: DWORD = 0x00000034;
pub const NUM_CM_PROB_V5: DWORD = 0x00000035;
pub const NUM_CM_PROB_V6: DWORD = 0x00000036;
pub const DN_ROOT_ENUMERATED: DWORD = 0x00000001;
pub const DN_DRIVER_LOADED: DWORD = 0x00000002;
pub const DN_ENUM_LOADED: DWORD = 0x00000004;
pub const DN_STARTED: DWORD = 0x00000008;
pub const DN_MANUAL: DWORD = 0x00000010;
pub const DN_NEED_TO_ENUM: DWORD = 0x00000020;
pub const DN_NOT_FIRST_TIME: DWORD = 0x00000040;
pub const DN_HARDWARE_ENUM: DWORD = 0x00000080;
pub const DN_LIAR: DWORD = 0x00000100;
pub const DN_HAS_MARK: DWORD = 0x00000200;
pub const DN_HAS_PROBLEM: DWORD = 0x00000400;
pub const DN_FILTERED: DWORD = 0x00000800;
pub const DN_MOVED: DWORD = 0x00001000;
pub const DN_DISABLEABLE: DWORD = 0x00002000;
pub const DN_REMOVABLE: DWORD = 0x00004000;
pub const DN_PRIVATE_PROBLEM: DWORD = 0x00008000;
pub const DN_MF_PARENT: DWORD = 0x00010000;
pub const DN_MF_CHILD: DWORD = 0x00020000;
pub const DN_WILL_BE_REMOVED: DWORD = 0x00040000;
pub const DN_NOT_FIRST_TIMEE: DWORD = 0x00080000;
pub const DN_STOP_FREE_RES: DWORD = 0x00100000;
pub const DN_REBAL_CANDIDATE: DWORD = 0x00200000;
pub const DN_BAD_PARTIAL: DWORD = 0x00400000;
pub const DN_NT_ENUMERATOR: DWORD = 0x00800000;
pub const DN_NT_DRIVER: DWORD = 0x01000000;
pub const DN_NEEDS_LOCKING: DWORD = 0x02000000;
pub const DN_ARM_WAKEUP: DWORD = 0x04000000;
pub const DN_APM_ENUMERATOR: DWORD = 0x08000000;
pub const DN_APM_DRIVER: DWORD = 0x10000000;
pub const DN_SILENT_INSTALL: DWORD = 0x20000000;
pub const DN_NO_SHOW_IN_DM: DWORD = 0x40000000;
pub const DN_BOOT_LOG_PROB: DWORD = 0x80000000;
pub const DN_NEED_RESTART: DWORD = DN_LIAR;
pub const DN_DRIVER_BLOCKED: DWORD = DN_NOT_FIRST_TIME;
pub const DN_LEGACY_DRIVER: DWORD = DN_MOVED;
pub const DN_CHILD_WITH_INVALID_ID: DWORD = DN_HAS_MARK;
pub const DN_DEVICE_DISCONNECTED: DWORD = DN_NEEDS_LOCKING;
pub const DN_CHANGEABLE_FLAGS: DWORD = DN_NOT_FIRST_TIME + DN_HARDWARE_ENUM + DN_HAS_MARK
    + DN_DISABLEABLE + DN_REMOVABLE + DN_MF_CHILD + DN_MF_PARENT + DN_NOT_FIRST_TIMEE
    + DN_STOP_FREE_RES + DN_REBAL_CANDIDATE + DN_NT_ENUMERATOR + DN_NT_DRIVER + DN_SILENT_INSTALL
    + DN_NO_SHOW_IN_DM;
pub const LCPRI_FORCECONFIG: ULONG = 0x00000000;
pub const LCPRI_BOOTCONFIG: ULONG = 0x00000001;
pub const LCPRI_DESIRED: ULONG = 0x00002000;
pub const LCPRI_NORMAL: ULONG = 0x00003000;
pub const LCPRI_LASTBESTCONFIG: ULONG = 0x00003FFF;
pub const LCPRI_SUBOPTIMAL: ULONG = 0x00005000;
pub const LCPRI_LASTSOFTCONFIG: ULONG = 0x00007FFF;
pub const LCPRI_RESTART: ULONG = 0x00008000;
pub const LCPRI_REBOOT: ULONG = 0x00009000;
pub const LCPRI_POWEROFF: ULONG = 0x0000A000;
pub const LCPRI_HARDRECONFIG: ULONG = 0x0000C000;
pub const LCPRI_HARDWIRED: ULONG = 0x0000E000;
pub const LCPRI_IMPOSSIBLE: ULONG = 0x0000F000;
pub const LCPRI_DISABLED: ULONG = 0x0000FFFF;
pub const MAX_LCPRI: ULONG = 0x0000FFFF;
