# Development Report for Jan 13, 2017

### Preface

I wanted to try something different for this project during its development by giving a weekly summary on the progress and what is being working on.  I figured the best place is to keep the reports in the repo.  Please give your feedback on the format and let me know if this is a waste of time or if there is something better we can do.

## Quick Start and Vendoring

This week we merged PRs adding a quick start guide with build instructions to help get new contributors onboard quicker.  We also merged a vendoring PR so everyone has the same revision of packages for the project.  It can add a little burden on development having vendoring at this early stage, especially the way we have to do vendoring in Go, but it ensures that everyone contributing has a consistent environment.

* https://github.com/containerd/containerd/pull/400
* https://github.com/containerd/containerd/pull/390

## Milestones

I spent some time yesterday working on milestones.  The milestones are more goal focused instead of being based on a versions or a date.  We have goals that we want to hit in each of the phases and the milestones are organized that way.

We are currently in the bootstrap phase.  Much of the design work, getting the project's infrastructure up (ci, vendoring, guides for development, etc) are part of this work.

The milestones will give you the most up-to-date view on the project and what is being worked on when.

* https://github.com/containerd/containerd/milestones

## Networking

Containerd will not support networking in its core.  Based on the feedback we received and our own experience with networking we can confidently leave this out of containerd without impacting functionality.  You can see the full discussion in the issue linked below.

Networking means many different things today and is becoming more software based.  On the runtime level, overlay networking is very simple, its just veth interfaces.  All of the overlay magic happens at the upper levels with routing tables and termination outside of the runtime and interfaces.  Networking also contains various forms of service discovery which should not be at the runtime level as things like health checks come into play to make sure you are only discovering healthy services.

I personally feel like this is a good move for the project.  We have good primitives at the runtime level with the create/start split that allows a container's network namespace to be created and time for a network plugin to create and add interfaces to the container before the user's process is started.  We also have the ability for containers to join pre-existing network namespaces that have already been populated by a networking implementation.

* https://github.com/containerd/containerd/issues/362

## Runtime and Shim

We finished porting over the shim from the existing containerd implementation that is being used today.  This makes sure that the containers are not tied to the daemon's lifecycle.  This allows containerd to reattach to the STDIO and receive exit events for the containers when it is no longer the parent of these processes.

* https://github.com/containerd/containerd/pull/417

## What's Next?

Next week we will be working towards a full PoC with the runtime, storage, and fetching of images.  Getting the core functionality up and running quickly is important to us to ensure that integration between the different subsystems in the core flow well together.  We want to make sure the responsibilities of pulling an image from a remote source do not spill into the storage layer and vice-versa.

We still have more documentation work to do on the design and lifecycle of components in the core which is another focus for next week.  You can find the current design docs in the [repo here](https://github.com/containerd/containerd/tree/main/design).

I hope this status report helps.  If you are looking for ways to contribute, check out the issues on the current milestone.
