/* SPDX-License-Identifier: GPL-2.0-only */

#include <mainboard/gpio.h>
#include <soc/gpio.h>

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_A ------- */
	PAD_NC(GPP_A0, NONE),
	PAD_CFG_NF(GPP_A1, UP_20K, DEEP, NF3),	/* ESPI_IO0 */
	PAD_CFG_NF(GPP_A2, UP_20K, DEEP, NF3),	/* ESPI_IO1 */
	PAD_CFG_NF(GPP_A3, UP_20K, DEEP, NF3),	/* ESPI_IO2 */
	PAD_CFG_NF(GPP_A4, UP_20K, DEEP, NF3),	/* ESPI_IO3 */
	PAD_CFG_NF(GPP_A5, UP_20K, DEEP, NF3),	/* ESPI_CS0# */
	PAD_NC(GPP_A6, NONE),
	PAD_NC(GPP_A7, NONE),
	PAD_NC(GPP_A8, NONE),
	PAD_CFG_NF(GPP_A9, DN_20K, DEEP, NF3),	/* ESPI_CLK */
	PAD_NC(GPP_A10, NONE),
	PAD_NC(GPP_A11, NONE),
	PAD_NC(GPP_A12, NONE),
	PAD_NC(GPP_A13, NONE),
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF3),	/* ESPI_RESET# */
	PAD_NC(GPP_A15, NONE),
	PAD_NC(GPP_A16, NONE),
	PAD_NC(GPP_A17, NONE),
	PAD_NC(GPP_A18, NONE),
	PAD_NC(GPP_A19, NONE),
	PAD_NC(GPP_A20, NONE),
	PAD_NC(GPP_A21, NONE),
	PAD_NC(GPP_A22, NONE),
	PAD_NC(GPP_A23, NONE),

	/* ------- GPIO Group GPP_B ------- */
	PAD_NC(GPP_B0, NONE),
	PAD_NC(GPP_B1, NONE),
	PAD_NC(GPP_B2, NONE),
	PAD_NC(GPP_B3, NONE),
	PAD_NC(GPP_B4, NONE),
	PAD_CFG_NF(GPP_B5, NONE, DEEP, NF1),	/* SRCCLKREQ0# */
	PAD_CFG_NF(GPP_B6, NONE, PLTRST, NF1),	/* SRCCLKREQ1# */
	PAD_CFG_NF(GPP_B7, NONE, DEEP, NF1),	/* SRCCLKREQ2# */
	PAD_CFG_NF(GPP_B8, NONE, DEEP, NF1),	/* SRCCLKREQ3# */
	PAD_CFG_NF(GPP_B9, NONE, DEEP, NF1),	/* SRCCLKREQ4# */
	PAD_NC(GPP_B10, NONE),
	PAD_NC(GPP_B11, NONE),
	PAD_CFG_NF(GPP_B12, NONE, PLTRST, NF1),	/* SLP_S0# */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),	/* PLTRST# */
	PAD_CFG_NF(GPP_B14, DN_20K, PLTRST, NF1),	/* SPKR */
	PAD_CFG_GPI_TRIG_OWN(GPP_B15, NONE, PLTRST, OFF, ACPI),
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_CFG_GPO(GPP_B18, 0, DEEP),
	PAD_NC(GPP_B19, NONE),
	PAD_NC(GPP_B20, NONE),
	PAD_NC(GPP_B21, NONE),
	PAD_CFG_GPO(GPP_B22, 0, DEEP),
	PAD_CFG_GPO(GPP_B23, 0, DEEP),

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1),	/* SMBCLK */
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1),	/* SMBDATA */
	PAD_CFG_GPO(GPP_C2, 0, DEEP),
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1),	/* SML0CLK */
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1),	/* SML0DATA */
	PAD_CFG_GPO(GPP_C5, 0, DEEP),
	/* GPP_C6 - RESERVED */
	/* GPP_C7 - RESERVED */
	PAD_CFG_GPI_APIC(GPP_C8, NONE, PLTRST, LEVEL, NONE),
	PAD_CFG_GPI_TRIG_OWN(GPP_C9, NONE, PLTRST, OFF, ACPI),
	PAD_NC(GPP_C10, NONE),
	PAD_NC(GPP_C11, NONE),
	PAD_NC(GPP_C12, NONE),
	PAD_NC(GPP_C13, NONE),
	PAD_NC(GPP_C14, NONE),
	PAD_NC(GPP_C15, NONE),
	PAD_NC(GPP_C16, NONE),
	PAD_NC(GPP_C17, NONE),
	PAD_NC(GPP_C18, NONE),
	PAD_NC(GPP_C19, NONE),
	PAD_NC(GPP_C20, NONE),
	PAD_NC(GPP_C21, NONE),
	PAD_NC(GPP_C22, NONE),
	PAD_NC(GPP_C23, NONE),

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),
	PAD_CFG_GPO(GPP_D1, 1, PLTRST),
	PAD_NC(GPP_D2, NONE),
	PAD_NC(GPP_D3, NONE),
	PAD_NC(GPP_D4, NONE),
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF3),	/* CNV_RF_RESET# */
	PAD_CFG_NF(GPP_D6, NONE, DEEP, NF3),	/* MODEM_CLKREQ */
	PAD_NC(GPP_D7, NONE),
	PAD_NC(GPP_D8, NONE),
	PAD_NC(GPP_D9, NONE),
	PAD_NC(GPP_D10, NONE),
	PAD_CFG_GPI_TRIG_OWN(GPP_D11, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_NF(GPP_D12, NONE, DEEP, NF2),	/* GP_BSSB_DI */
	PAD_NC(GPP_D13, NONE),
	PAD_NC(GPP_D14, NONE),
	PAD_NC(GPP_D15, NONE),
	PAD_NC(GPP_D16, NONE),
	PAD_CFG_NF(GPP_D17, NONE, DEEP, NF1),	/* DMIC_CLK1 */
	PAD_CFG_NF(GPP_D18, NONE, PLTRST, NF1),	/* DMIC_DATA1 */
	PAD_CFG_NF(GPP_D19, NONE, DEEP, NF1),	/* DMIC_CLK0 */
	PAD_CFG_NF(GPP_D20, NONE, DEEP, NF1),	/* DMIC_DATA0 */
	PAD_NC(GPP_D21, NONE),
	PAD_NC(GPP_D22, NONE),
	PAD_NC(GPP_D23, NONE),

	/* ------- GPIO Group GPP_G ------- */
	PAD_NC(GPP_G0, NONE),
	PAD_NC(GPP_G1, NONE),
	PAD_NC(GPP_G2, NONE),
	PAD_NC(GPP_G3, NONE),
	PAD_NC(GPP_G4, NONE),
	PAD_NC(GPP_G5, NONE),
	PAD_NC(GPP_G6, NONE),
	PAD_NC(GPP_G7, NONE),

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, NONE, RSMRST, NF1),	/* BATLOW# */
	PAD_CFG_GPI_TRIG_OWN(GPD1, UP_20K, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPD2, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_NF(GPD3, UP_20K, RSMRST, NF1),	/* PRWBTN# */
	PAD_CFG_NF(GPD4, NONE, RSMRST, NF1),	/* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, RSMRST, NF1),	/* SLP_S4# */
	PAD_CFG_NF(GPD6, NONE, RSMRST, NF1),	/* SLP_A# */
	PAD_CFG_GPO(GPD7, 0, RSMRST),
	PAD_CFG_NF(GPD8, NONE, RSMRST, NF1),	/* SUSCLK */
	PAD_CFG_NF(GPD9, NONE, RSMRST, NF1),	/* SLP_WLAN# */
	PAD_CFG_NF(GPD10, NONE, RSMRST, NF1),	/* SLP_S5# */
	PAD_CFG_NF(GPD11, NONE, RSMRST, NF1),	/* LANPHYPC */

	/* ------- GPIO Community 3 ------- */

	/* ------- GPIO Group GPP_K ------- */
	PAD_NC(GPP_K0, NONE),
	PAD_NC(GPP_K1, NONE),
	PAD_NC(GPP_K2, NONE),
	PAD_NC(GPP_K3, NONE),
	PAD_CFG_GPI_TRIG_OWN(GPP_K4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K5, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K6, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K7, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K8, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K9, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K10, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF(GPP_K11, NONE, DEEP, NF1),	/* Reserved */
	PAD_CFG_GPI_SCI(GPP_K12, NONE, PLTRST, LEVEL, INVERT),
	PAD_NC(GPP_K13, NONE),
	PAD_NC(GPP_K14, NONE),
	PAD_NC(GPP_K15, NONE),
	PAD_CFG_GPO(GPP_K16, 0, PLTRST),
	PAD_NC(GPP_K17, NONE),
	PAD_NC(GPP_K18, NONE),
	PAD_NC(GPP_K19, NONE),
	PAD_CFG_NF(GPP_K20, NONE, DEEP, NF1),	/* Reserved */
	PAD_CFG_GPI_TRIG_OWN(GPP_K21, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_K22, 1, PLTRST),
	PAD_NC(GPP_K23, NONE),

	/* ------- GPIO Group GPP_H ------- */
	PAD_CFG_NF(GPP_H0, NONE, DEEP, NF1),	/* SRCCLKREQ6# */
	PAD_NC(GPP_H1, NONE),
	PAD_NC(GPP_H2, NONE),
	PAD_NC(GPP_H3, NONE),
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1),	/* SRCCLKREQ10# */
	PAD_NC(GPP_H5, NONE),
	PAD_NC(GPP_H6, NONE),
	PAD_NC(GPP_H7, NONE),
	PAD_NC(GPP_H8, NONE),
	PAD_NC(GPP_H9, NONE),
	PAD_NC(GPP_H10, NONE),
	PAD_NC(GPP_H11, NONE),
	PAD_CFG_GPO(GPP_H12, 0, DEEP),
	PAD_NC(GPP_H13, NONE),
	PAD_CFG_GPO(GPP_H14, 0, PLTRST),
	PAD_NC(GPP_H15, NONE),
	PAD_CFG_GPO(GPP_H16, 0, PLTRST),
	PAD_CFG_GPO(GPP_H17, 0, PLTRST),
	PAD_CFG_GPO(GPP_H18, 0, PLTRST),
	PAD_NC(GPP_H19, NONE),
	PAD_NC(GPP_H20, NONE),
	PAD_CFG_GPI_TRIG_OWN(GPP_H21, NONE, PLTRST, OFF, ACPI),
	PAD_NC(GPP_H22, NONE),
	PAD_NC(GPP_H23, NONE),

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_NF(GPP_E0, NONE, DEEP, NF1),	/* SATAXPCIE0 */
	PAD_CFG_NF(GPP_E1, NONE, DEEP, NF1),	/* SATAXPCIE1 */
	PAD_CFG_GPI_SCI(GPP_E2, NONE, PLTRST, LEVEL, NONE),
	PAD_NC(GPP_E3, NONE),
	PAD_NC(GPP_E4, NONE),
	PAD_NC(GPP_E5, NONE),
	PAD_CFG_GPO(GPP_E6, 0, PLTRST),
	PAD_NC(GPP_E7, NONE),
	PAD_CFG_NF(GPP_E8, NONE, PLTRST, NF1),	/* SATALED# */
	PAD_CFG_NF(GPP_E9, NONE, PLTRST, NF1),	/* USB2_OC0# */
	PAD_CFG_NF(GPP_E10, NONE, PLTRST, NF1),	/* USB2_OC1# */
	PAD_CFG_NF(GPP_E11, NONE, PLTRST, NF1),	/* USB2_OC2# */
	PAD_CFG_NF(GPP_E12, NONE, PLTRST, NF1),	/* USB2_OC3# */

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF1),	/* SATAXPCIE3 */
	PAD_CFG_NF(GPP_F1, NONE, PLTRST, NF1),	/* SATAXPCIE4 */
	PAD_CFG_NF(GPP_F2, NONE, DEEP, NF1),	/* SATAXPCIE5 */
	PAD_CFG_NF(GPP_F3, NONE, DEEP, NF1),	/* SATAXPCIE6 */
	PAD_CFG_NF(GPP_F4, NONE, DEEP, NF1),	/* SATAXPCIE7 */
	PAD_NC(GPP_F5, NONE),
	PAD_NC(GPP_F6, NONE),
	PAD_NC(GPP_F7, NONE),
	PAD_NC(GPP_F8, NONE),
	PAD_NC(GPP_F9, NONE),
	PAD_NC(GPP_F10, NONE),
	PAD_NC(GPP_F11, NONE),
	PAD_NC(GPP_F12, NONE),
	PAD_NC(GPP_F13, NONE),
	PAD_CFG_NF(GPP_F14, NONE, DEEP, NF2),	/* PS_ON# */
	PAD_CFG_NF(GPP_F15, NONE, PLTRST, NF1),	/* USB2_OC4# */
	PAD_CFG_NF(GPP_F16, NONE, PLTRST, NF1),	/* USB2_OC5# */
	PAD_CFG_NF(GPP_F17, NONE, PLTRST, NF1),	/* USB2_OC6# */
	PAD_NC(GPP_F18, NONE),
	PAD_CFG_NF(GPP_F19, NONE, DEEP, NF1),	/* eDP_VDDEN */
	PAD_CFG_NF(GPP_F20, NONE, DEEP, NF1),	/* eDP_BKLTEN */
	PAD_CFG_NF(GPP_F21, NONE, DEEP, NF1),	/* eDP_BKLTCTL */
	PAD_CFG_GPO(GPP_F22, 1, PLTRST),
	PAD_CFG_GPO(GPP_F23, 1, PLTRST),

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPP_I ------- */
	PAD_CFG_NF(GPP_I0, NONE, DEEP, NF1),	/* DDPB_HPD0 */
	PAD_CFG_NF(GPP_I1, NONE, DEEP, NF1),	/* DDPB_HPD1 */
	PAD_CFG_NF(GPP_I2, NONE, DEEP, NF1),	/* DDPB_HPD2 */
	PAD_NC(GPP_I3, NONE),
	PAD_CFG_NF(GPP_I4, NONE, DEEP, NF1),	/* EDP_HPD */
	PAD_CFG_NF(GPP_I5, NONE, DEEP, NF1),	/* DDPB_CTRLCLK */
	PAD_CFG_NF(GPP_I6, NONE, DEEP, NF1),	/* DDPB_CTRLDATA */
	PAD_CFG_NF(GPP_I7, NONE, DEEP, NF1),	/* DDPC_CTRLCLK */
	PAD_CFG_NF(GPP_I8, NONE, DEEP, NF1),	/* DDPC_CTRLDATA */
	PAD_CFG_NF(GPP_I9, NONE, DEEP, NF1),	/* DDPD_CTRLCLK */
	PAD_CFG_NF(GPP_I10, NONE, DEEP, NF1),	/* DDPD_CTRLDATA */
	PAD_NC(GPP_I11, NONE),
	PAD_NC(GPP_I12, NONE),
	PAD_NC(GPP_I13, NONE),
	PAD_NC(GPP_I14, NONE),

	/* ------- GPIO Group GPP_J ------- */
	PAD_NC(GPP_J0, NONE),
	PAD_CFG_NF(GPP_J1, NONE, DEEP, NF2),	/* CPU_C10_GATE# */
	PAD_NC(GPP_J2, NONE),
	PAD_NC(GPP_J3, NONE),
	PAD_CFG_NF(GPP_J4, NONE, DEEP, NF1),	/* CNV_BRI_DT */
	PAD_CFG_NF(GPP_J5, UP_20K, DEEP, NF1),	/* CNV_BRI_RSP */
	PAD_CFG_NF(GPP_J6, NONE, DEEP, NF1),	/* CNV_RGI_DT */
	PAD_CFG_NF(GPP_J7, UP_20K, DEEP, NF1),	/* CNV_RGI_RSP */
	PAD_NC(GPP_J8, NONE),
	PAD_CFG_GPO(GPP_J9, 0, DEEP),
	PAD_NC(GPP_J10, NONE),
	PAD_CFG_NF(GPP_J11, DN_20K, DEEP, NF1),	/* A4WP_PRESENT */
};

void mainboard_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
