/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;

public class DoubleSortComparer
implements AtomicComparer {
    private static DoubleSortComparer THE_INSTANCE = new DoubleSortComparer();

    public static DoubleSortComparer getInstance() {
        return THE_INSTANCE;
    }

    private DoubleSortComparer() {
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        NumericValue numericValue = (NumericValue)((AtomicValue)object).getPrimitiveValue();
        NumericValue numericValue2 = (NumericValue)((AtomicValue)object2).getPrimitiveValue();
        if (numericValue.isNaN()) {
            if (numericValue2.isNaN()) {
                return 0;
            }
            return -1;
        }
        if (numericValue2.isNaN()) {
            return 1;
        }
        return numericValue.compareTo(numericValue2);
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compare(atomicValue, atomicValue2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        AtomicValue atomicValue2 = atomicValue.getPrimitiveValue();
        if (((NumericValue)atomicValue2).isNaN()) {
            return new ComparisonKey(646, AtomicSortComparer.COLLATION_KEY_NaN);
        }
        return new ComparisonKey(646, atomicValue2);
    }
}

