#include "config"

void Config::setdispatchmode (string s) {
    if (s.substr(0, 2) == "e:") {
	dmode.mode (Dispatchmode::m_external);
	external_algorithm = s.substr (2);
    } else if (s.substr (0, 9) == "external:") {
	dmode.mode (Dispatchmode::m_external);
	external_algorithm = s.substr(9);
    } else if (s == "f" || s == "first-available")
	dmode.mode (Dispatchmode::m_firstactive);
    else if (s == "h" || s == "strict-hashed-ip")
	dmode.mode (Dispatchmode::m_strict_hashed_ip);
    else if (s == "H" || s == "lax-hashed-ip")
	dmode.mode (Dispatchmode::m_lax_hashed_ip);
    else if (s == "l" || s == "least-connections")
	dmode.mode (Dispatchmode::m_leastconn);
    else if (s == "r" || s == "round-robin")
	dmode.mode (Dispatchmode::m_roundrobin);
    else if (s == "L" || s == "weighted-load" ) {
	timeval t1;
	gettimeofday(&t1, NULL);
	mt_srand(t1.tv_sec * t1.tv_usec);
	dmode.mode (Dispatchmode::m_weighted_load);
    }
    else if (s.substr(0, 2) == "s:") {
	dmode.mode (Dispatchmode::m_strict_stored_ip);
	ipstoretimeout(setinteger(s.substr(2)));
    } else if (s.substr(0, 17) == "strict-stored-ip:") {
	dmode.mode (Dispatchmode::m_strict_stored_ip);
	ipstoretimeout(setinteger(s.substr(17)));
    } else if (s.substr(0, 2) == "S:") {
	dmode.mode (Dispatchmode::m_lax_stored_ip);
	ipstoretimeout(setinteger(s.substr(2)));
    } else if (s.substr(0, 14) == "lax-stored-ip:") {
	dmode.mode (Dispatchmode::m_lax_stored_ip);
	ipstoretimeout(setinteger(s.substr(14)));
    } else
	throw Error("Bad dispatch mode -d" + s);

    if (dmode.mode() == Dispatchmode::m_external &&
	external_algorithm.size() < 1)
	throw Error("External algorithm handler missing");
}
