#include "ipstore"

void IPStore::weed() {
    time_t now = time(0);
    bool done = false;
    static int lock;
    
    mutex_lock(&lock);

    while (!done) {
	done = true;
	for (StoreMap::iterator iter = store.begin();
	     iter != store.end();
	     iter++) {
	    if (now - ((*iter).second.lastaccess) > config.ipstoretimeout()) {
		if (config.debug()) {
		    Timestamp tm((*iter).second.lastaccess);
		    debugmsg ("Stale entry: " << inet2string(iter->first) <<
			      " visited on " << tm.desc() << ", erasing\n");
		}
		done = false;
		store.erase(iter);
		break;
	    }
	}
    }
    
    mutex_unlock(&lock);
}
