#ifndef _UDPSTREAM_H
#define _UDPSTREAM_H 1

// A single UDP destination. This is done a lot less efficient than HTTP streaming
// since we expect to have so few of them, which also means things are a lot simpler.
// In particular, we run in the input's thread, so there is no backlog, which means
// that there is no state (UDP itself is, of course, stateless).

#include <arpa/inet.h>
#include <netinet/in.h>
#include <stddef.h>
#include <stdint.h>
#include <sys/types.h>

class MarkPool;

class UDPStream {
public:
	UDPStream(const sockaddr_in6 &dst, uint32_t pacing_rate, int ttl, int multicast_iface_index);
	~UDPStream();

	void send(const char *data, size_t bytes);

private:
	UDPStream(const UDPStream& other);

	sockaddr_in6 dst;
	int sock;
};

#endif  // !defined(_UDPSTREAM_H)
