/*
 *  createfavouritedialog.cpp
 *  ui
 *
 *  Created by Mikael Gransell on 4/18/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#include "createfavouritedialog.h"

#include "rpctypes.h"

CreateFavouriteDialog::CreateFavouriteDialog( const BackendConnectionPtr& backendConn,
											  QWidget* parent )
: QDialog(parent),
  backendConnection(backendConn)
{
	  ui.setupUi(this);
}

void CreateFavouriteDialog::on_createButton_clicked()
{
	rpc_types::FavouriteHub hubEntry;
	hubEntry.name = ui.nameEdit->text().toStdString();
	hubEntry.server = ui.serverEdit->text().toStdString();
	hubEntry.nick = ui.nickEdit->text().toStdString();
	hubEntry.password = ui.pwdEdit->text().toStdString();
	hubEntry.autoConnect = ui.autoConnectCheckBox->isChecked();
	
	// Add the favourite and close the dialog
	backendConnection->addFavouriteHub(hubEntry);
	done(QDialog::Accepted);
}