#! /bin/sh
### BEGIN INIT INFO
# Provides:          ddns3-client
# Required-Start:    $network $remote_fs
# Required-Stop:     $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6   
### END INIT INFO
# (C) 2003 Ian Maclaine-cross <iml@debian.org> 
# Copyright conditions are in file GPL.

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/ddns3
NAME=ddns3-client
DESC='Dynamic DNS v3'
FILE=/etc/default/ddns3-client

test -x $DAEMON || exit 0

set -e

if test -r $FILE; then . $FILE; fi;
if [ $USER. = . ] || [ $PASS. = . ] || [ $HANDLE. = . ]; then
    echo $NAME: Please edit $FILE to activate $DESC!
    exit 0
fi; 

case "$1" in
    start|restart|force-reload)
    echo -n "Setting $DESC: "

# ddns3 command and arguments 
    dc="$DAEMON --user $USER --pass $PASS\
	--host $HOST --auth $AUTH --port $PORT";

    if sm=`$dc guess $HANDLE remote 2>/dev/null`; then
	echo Updated $HANDLE IP at $HOST,
	$dc list;   
	echo $sm;
    else
        echo $HANDLE IP at $HOST unchanged,
	$dc list;   
    fi;

    echo "$NAME."
	;;
  stop) ;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
