/*
* modulator.cc
* DIN Is Noise is copyright (c) 2006-2021 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#include "multi_curve.h"
#include "modulator.h"
#include "audio.h"
#include "chrono.h"
#include "drone.h"
#include "console.h"

extern float TWO_PI;
extern const char spc;

mod_params::mod_params (multi_curve* c, int i, point<float>& p, const std::string& n) {

  setdir (i, &p.x, &p.y);

	bv.name = n;
	bv.crv = c;
  bv.setup ();
	depth = result = initial = 0;

  t = ui_clk ();

}

void mod_params::clear () {
  depth = 0;
	result = 0;
	initial = 0;
  bv.set_bpm (bv.bpm);
}

void mod_params::calc () {
  double t1 = ui_clk ();
  double dt = t1 - t;
  t = t1;
  bv.delta = dt * bv.bps;
  result = depth * bv.sol (bv.now, bv.delta);
  if (autorot.yes) autorot.calc (dt);
}


void mod_params::calcdir (drone& dd) {
  float* px [] = {&vertical.x, &horizontal.x, &dd.vx, &dd.ax};
  float* py [] = {&vertical.y, &horizontal.y, &dd.vy, &dd.ay};
  dirx = px[id];
  diry = py[id];
}

void autorotator::set_rpm (float r) {
  if (r > 0) {
    rpm = r;
    angle.persec = TWO_PI * r / 60.0f;
  } else {
    rpm = 0;
    angle.persec = 0.0f;
  }
}

void autorotator::chgdeg (float d) {
  setdeg (deg + d);
}

void autorotator::chgtps (float t) {
  settps (tps + t);
  setdeg (deg);
}

void autorotator::calc (float dt) {
  if (movement == SMOOTH) 
    angle.theta = dt * angle.persec;
  else {
    if (tik (ui_clk())) angle.theta = tik.triggert * angle.persec; else angle.theta = 0.0f;
  }

  if (autoflip.yes) autoflip.calc (angle.theta, dir);
  angle.theta *= dir;
}

void autoflipt::calc (float theta, int& dir) {
  total += theta;
  if (total > angle.rad) {
    dir = -dir;
    total = 0.0f;
  }
}

void autoflipt::set (float d) {
  angle = d;
}

autoflipt::autoflipt () : angle (90) {
  yes = 0;
  total = 0.0f;
}

using namespace std;
istream& operator>> (istream& file, autorotator& ar) {
  file >> ar.yes >> ar.dir >> ar.rpm >> ar.movement >> ar.deg >> ar.tps >> ar.autoflip;
  if (ar.movement == autorotator::SMOOTH)
    ar.set_rpm (ar.rpm);
  else {
    ar.setdeg (ar.deg);
    ar.settps (ar.tps);
  }
  return file;
}

ostream& operator<< (ostream& file, autorotator& ar) {
  file << ar.yes << spc << ar.dir << spc << ar.rpm << spc << ar.movement << spc << ar.deg << spc << ar.tps << spc << ar.autoflip;
  return file;
}

istream& operator>> (istream& file, autoflipt& af) {
  float d;
  file >> af.yes >> d >> af.total;
  af.angle = d;
  return file;
}


ostream& operator<< (ostream& file, autoflipt& af) {
  file << af.yes << spc << af.angle.deg << spc << af.total;
  return file;
}
