// Copyright (c) .NET Foundation and contributors. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

using Mono.Linker.Tests.Cases.Expectations.Assertions;
using Mono.Linker.Tests.Cases.Expectations.Metadata;
using Mono.Linker.Tests.Cases.Warnings.Dependencies;

namespace Mono.Linker.Tests.Cases.Warnings.WarningSuppression
{
    [TestCaseRequirements(TestRunCharacteristics.TargetingNetFramework, "This test is specific to .NET Framework")]
    // For mono though, we have to specify the assembly (Mono.Linker.Tests.Cases.Expectations) because at the time of processing
    // that assembly is not yet loaded into the closure in illink, so it won't find the attribute type.
    [SetupLinkAttributesFile("SuppressWarningsUsingTargetViaXml.mono.xml")]
    [SetupCompileBefore("library.dll", new[] { typeof(TriggerWarnings_Lib) }, new[] { "System.Core.dll" })]

    [KeptAssembly("library.dll")]
    [SetupLinkerAction("link", "library.dll")]
    [LogDoesNotContain("TriggerUnrecognizedPattern()")]
    public class SuppressWarningsUsingTargetViaXmlMono
    {
        public static void Main()
        {
            TriggerWarnings_Lib.Main();
        }
    }
}
