function rep = ResidTablePage(rep, countryAbbr, countryName, db_q, dc_q, trange, vline_after)
% Copyright (C) 2011-2013 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

seriesNames = {{'RES_RS_'}, ...
               {'RES_RR_BAR_'}, ...
               {'RES_BLT_'}, ...
               {'RES_BLT_BAR_'}, ...
               {'RES_YY_'}, ...
               {'RES_Y_'}, ...
               {'RES_LGDP_BAR_'}, ...
               {'RES_G_'}, ...
               {'RES_UNR_GAP_'}, ...
               {'RES_UNR_G_'}, ...
               {'RES_UNR_BAR_'}, ...
               {'RES_RR_DIFF_'}, ...
               {'RES_LZ_BAR_'}, ...
               {'RES_DOT_LZ_BAR_'}, ...
               {'RES_PIETAR_'}, ...
               {'RES_PIE_'}, ...
               {'RES_PIEX_'}, ...
               {'RES_PIE_GAS_'}, ...
               {'RES_PIE_CONSFOOD_'}};

otherThree = {'EA6', 'LA6', 'RC6'};
notForOtherThree = {'RES_BLT_', 'RES_BLT_BAR_', 'RES_UNR_GAP_', 'RES_UNR_G_', 'RES_UNR_BAR_'};

notForUS = {'RES_RR_DIFF_', 'RES_LZ_BAR_'};

firstThree = {'US', 'EU', 'JA'};
notForFirstThree = {'RES_DOT_LZ_BAR_', 'RES_PIETAR_'};

rep = rep.addTable('title', countryName, ...
                   'range', trange, ...
                   'vlineAfter', vline_after);

for i=1:length(seriesNames)
    if (any(strcmp(countryAbbr, otherThree)) && ...
            any(strcmp(seriesNames{i}{1}, notForOtherThree))) || ...
            (any(strcmp(countryAbbr, 'US')) && any(strcmp(seriesNames{i}{1}, notForUS))) || ...
            (any(strcmp(countryAbbr, firstThree)) && any(strcmp(seriesNames{i}{1}, notForFirstThree)))
        continue
    end
    rep = rep.addSeries('data', db_q{[seriesNames{i}{1} countryAbbr]});
    delta = db_q{[seriesNames{i}{1} countryAbbr]}-dc_q{[seriesNames{i}{1} countryAbbr]};
    delta = delta.tex_rename('$\Delta$');
    rep = rep.addSeries('data', delta, ...
                        'tableShowMarkers', true, ...
                        'tableAlignRight', true);
end
end
