/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains implementations of the {@link org.eclipse.collections.api.map.sorted.MutableSortedMap} interface.
 * <p>
 *     This package contains the following implementations:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.map.sorted.mutable.SortedMapAdapter} - a {@link org.eclipse.collections.api.map.sorted.MutableSortedMap} wrapper around a {@link java.util.SortedMap} interface instance.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.map.sorted.mutable.SynchronizedSortedMap} - a synchronized view of a SortedMap.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.map.sorted.mutable.UnmodifiableSortedMap} - an unmodifiable view of a SortedMap.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.map.sorted.mutable.UnmodifiableTreeMap} - an unmodifiable view of a SortedMap.
 *     </li>
 * </ul>
 * <p>
 *     This package contains one factory implementation:
 * <ul>
 *     <li>
 *         {@link org.eclipse.collections.impl.map.sorted.mutable.MutableSortedMapFactoryImpl} - a factory which creates instances of type {@link org.eclipse.collections.api.map.sorted.MutableSortedMap}.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.impl.map.sorted.mutable;
