#!/bin/bash

quilt delete disable_antlr3_embedded_copy.diff
quilt delete disable_asm_embedded_copy.diff 

mv debian/patches/disable_antlr3_embedded_copy.diff debian/patches/disable_antlr3_embedded_copy.diff.old
mv debian/patches/disable_asm_embedded_copy.diff debian/patches/disable_asm_embedded_copy.diff.old

quilt new disable_antlr3_embedded_copy.diff

for file in `fgrep -l -r "org.eclipse.persistence.internal.libraries.antlr" org/ | fgrep -v "org/eclipse/persistence/internal/libraries/antlr"`
do
    echo $file
    quilt add $file
    sed -i -e 's/org\.eclipse\.persistence\.internal\.libraries\.antlr/org.antlr/g' $file
    quilt refresh
done


quilt new disable_asm_embedded_copy.diff

for file in `fgrep -l -r "org.eclipse.persistence.internal.libraries.asm" org/ | fgrep -v "org/eclipse/persistence/internal/libraries/asm"`
do
    echo $file
    quilt add $file
    sed -i -e 's/org\.eclipse\.persistence\.internal\.libraries\.asm/org.objectweb.asm/g' $file
    quilt refresh
done

echo "*****************************************"
echo "Now copy the headers from the old patches"
echo "*****************************************"
