/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.gui.form.LabelTextBox;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class PrettyPlotJFrame
extends JFrame
implements ActionListener {
    private TextFieldInt textInt;
    private TextFieldFloat textFloat;
    private JColorChooser idColour;
    private JColorChooser matchColour;
    private JColorChooser idColourBackground;
    private JColorChooser matchColourBackground;
    private GraphicSequenceCollection gsc;
    private JCheckBox prettyBox;

    public PrettyPlotJFrame(int minID, float plurality, Color colID, Color colMatch, Color colIDBack, Color colMatchBack, boolean lboxPretty) {
        this.textInt = new TextFieldInt();
        this.textInt.setText(Integer.toString(minID));
        this.textFloat = new TextFieldFloat();
        this.textFloat.setValue(plurality);
        this.idColour = new JColorChooser(colID);
        this.matchColour = new JColorChooser(colMatch);
        this.idColourBackground = new JColorChooser(colIDBack);
        this.matchColourBackground = new JColorChooser(colMatchBack);
        this.prettyBox = new JCheckBox();
        this.prettyBox.setSelected(lboxPretty);
    }

    public PrettyPlotJFrame(GraphicSequenceCollection gsc) {
        super("Colour Matches");
        this.gsc = gsc;
        Box bdown = Box.createVerticalBox();
        bdown.add(Box.createVerticalStrut(4));
        Box bacross = Box.createHorizontalBox();
        this.textInt = new TextFieldInt();
        this.textInt.setText(Integer.toString(gsc.getNumberSequences()));
        Dimension d = new Dimension(50, 30);
        this.textInt.setPreferredSize(d);
        this.textInt.setMaximumSize(d);
        bacross.add(this.textInt);
        LabelTextBox idLabel = new LabelTextBox("Identity Number", "Minimum number of identities in a column");
        bacross.add(idLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(4));
        bacross = Box.createHorizontalBox();
        this.textFloat = new TextFieldFloat();
        this.textFloat.setValue(AlignJFrame.getTotalWeight(gsc.getSequenceCollection()) / 2.0f);
        this.textFloat.setPreferredSize(d);
        this.textFloat.setMinimumSize(d);
        bacross.add(this.textFloat);
        LabelTextBox floatLabel = new LabelTextBox("Threshold for positive matches", "Minimum number of positive matches. The default\nis half the total weight of all the sequences.");
        bacross.add(floatLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(4));
        bacross = Box.createHorizontalBox();
        this.idColour = new JColorChooser(Color.red);
        final JButton idButton = new JButton("");
        Dimension buttSize = new Dimension(25, 20);
        idButton.setPreferredSize(buttSize);
        final JDialog dialog = JColorChooser.createDialog(idButton, "Pick a Color", true, this.idColour, null, null);
        idButton.setBackground(Color.red);
        idButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.show();
                idButton.setBackground(PrettyPlotJFrame.this.idColour.getColor());
            }
        });
        bacross.add(idButton);
        idLabel = new LabelTextBox("Identity Colour", "");
        bacross.add(idLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(4));
        bacross = Box.createHorizontalBox();
        this.idColourBackground = new JColorChooser(Color.white);
        final JButton idBackButton = new JButton("");
        idBackButton.setPreferredSize(buttSize);
        final JDialog dialogID = JColorChooser.createDialog(idBackButton, "Pick a Color", true, this.idColourBackground, null, null);
        idBackButton.setBackground(Color.white);
        idBackButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialogID.show();
                idBackButton.setBackground(PrettyPlotJFrame.this.idColourBackground.getColor());
            }
        });
        bacross.add(idBackButton);
        idLabel = new LabelTextBox("Identity Background Colour", "");
        bacross.add(idLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(4));
        bacross = Box.createHorizontalBox();
        this.matchColour = new JColorChooser(Color.blue);
        final JButton matchButton = new JButton("");
        matchButton.setPreferredSize(buttSize);
        final JDialog dialogMatch = JColorChooser.createDialog(matchButton, "Pick a Color", true, this.matchColour, null, null);
        matchButton.setBackground(Color.blue);
        matchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialogMatch.show();
                matchButton.setBackground(PrettyPlotJFrame.this.matchColour.getColor());
            }
        });
        bacross.add(matchButton);
        idLabel = new LabelTextBox("Positive Match Colour", "");
        bacross.add(idLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        this.matchColourBackground = new JColorChooser(Color.white);
        final JButton matchBackButton = new JButton("");
        matchBackButton.setPreferredSize(buttSize);
        final JDialog dialogMatchBack = JColorChooser.createDialog(matchButton, "Pick a Color", true, this.matchColourBackground, null, null);
        matchBackButton.setBackground(Color.white);
        matchBackButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialogMatchBack.show();
                matchBackButton.setBackground(PrettyPlotJFrame.this.matchColourBackground.getColor());
            }
        });
        bacross.add(matchBackButton);
        idLabel = new LabelTextBox("Positive Match Background Colour", "");
        bacross.add(idLabel);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        this.prettyBox = new JCheckBox("Box");
        this.prettyBox.setSelected(true);
        bacross.add(this.prettyBox);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        JButton draw = new JButton("Set");
        draw.addActionListener(this);
        draw.setActionCommand("SET");
        bacross.add(draw);
        bdown.add(bacross);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(new JSeparator());
        JMenuItem fileMenuExit = new JMenuItem("Close");
        fileMenuExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrettyPlotJFrame.this.setVisible(false);
            }
        });
        fileMenu.add(fileMenuExit);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.getContentPane().add(bdown);
        this.pack();
    }

    public int getMinimumIdentity(int nseqs) {
        return Integer.parseInt(this.textInt.getText());
    }

    public double getMatchThreshold() {
        return this.textFloat.getValue();
    }

    public Color getIDColour() {
        return this.idColour.getColor();
    }

    public Color getIDBackgroundColour() {
        return this.idColourBackground.getColor();
    }

    public Color getMatchColour() {
        return this.matchColour.getColor();
    }

    public Color getMatchBackgroundColour() {
        return this.matchColourBackground.getColor();
    }

    protected boolean isPrettyBox() {
        return this.prettyBox.isSelected();
    }

    protected void setGraphicSequenceCollection(GraphicSequenceCollection gsc) {
        this.gsc = gsc;
        this.textInt.setText(Integer.toString(gsc.getNumberSequences()));
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("SET")) {
            this.gsc.setPrettyPlot(true, this);
            this.gsc.setDrawBoxes(false);
            this.gsc.setDrawColor(false);
        }
    }
}

