/******************************************************************************

	conf.h -- handle the configuration file
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: conf.h 223 2011-12-02 10:53:44Z wsl $
	$URL: https://svn.fair.uvt.nl/branches/0.5/src/conf.h $

******************************************************************************/
#ifndef CONF_H
#define CONF_H

#include <regex.h>

#include <avl.h>

#include "chrono.h"

typedef struct option_t {
	avl_node_t node;
	bool (*set)(const char *s, bool);
	char name[1];
} option_t;

extern bool conf_load(const char *, bool);
extern bool conf_reload(const char *);

#undef _StringConfigVal
#undef _BoolConfigVal
#undef _StampConfigVal
#undef _SizeConfigVal
#undef _RegexConfigVal
#define _StringConfigVal(s,d) extern const char *conf_##s;
#define _BoolConfigVal(b,d) extern bool conf_##b;
#define _StampConfigVal(t,d) extern stamp_t conf_##t;
#define _SizeConfigVal(s,d) extern size_t conf_##s;
#define _RegexConfigVal(r,d) extern regex_t *conf_##r;

#include "options.h"

#undef _StringConfigVal
#undef _BoolConfigVal
#undef _StampConfigVal
#undef _SizeConfigVal
#undef _RegexConfigVal

#endif
