package mp4

import "github.com/wader/fq/pkg/scalar"

// from:
// https://cconcolato.github.io/mp4ra/filetype.html
// https://exiftool.org/TagNames/QuickTime.html
var brandDescriptions = scalar.StrToScalar{
	"3g2a": {Description: "3GPP2"},
	"3g2b": {Description: "3GPP2 Media (.3G2) compliant with 3GPP2 C.S0050-A V1.0.0"},
	"3g2c": {Description: "3GPP2 Media (.3G2) compliant with 3GPP2 C.S0050-B v1.0"},
	"3ge6": {Description: "3GPP Release 6 extended-presentation Profile"},
	"3ge7": {Description: "3GPP Release 7 extended-presentation Profile"},
	"3ge9": {Description: "3GPP Release 9 Extended Presentation Profile"},
	"3gf9": {Description: "3GPP Release 9 File-delivery Server Profile"},
	"3gg6": {Description: "3GPP Release 6 General Profile"},
	"3gg9": {Description: "3GPP Release 9 General Profile"},
	"3gh9": {Description: "3GPP Release 9 Adaptive Streaming Profile"},
	"3gm9": {Description: "3GPP Release 9 Media Segment Profile"},
	"3gp1": {Description: "3GPP Media (.3GP) Release 1 (probably non-existent)"},
	"3gp2": {Description: "3GPP Media (.3GP) Release 2 (probably non-existent)"},
	"3gp3": {Description: "3GPP Media (.3GP) Release 3 (probably non-existent)"},
	"3gp4": {Description: "3GPP Release 4"},
	"3gp5": {Description: "3GPP Release 5"},
	"3gp6": {Description: "3GPP Release 6 basic Profile"},
	"3gp7": {Description: "3GPP Release 7"},
	"3gp8": {Description: "3GPP Release 8"},
	"3gp9": {Description: "3GPP Release 9 Basic Profile"},
	"3gr6": {Description: "3GPP Release 6 progressive-download Profile"},
	"3gr9": {Description: "3GPP Release 9 Progressive DownloadProfile"},
	"3gs6": {Description: "3GPP Release 6 streaming-server Profile"},
	"3gs7": {Description: "3GPP Media (.3GP) Release 7 Streaming Servers"},
	"3gs9": {Description: "3GPP Release 9 Streaming ServerProfile"},
	"3gt8": {Description: "3GPP Release 8 Media Stream Recording Profile"},
	"3gt9": {Description: "3GPP Release 9 Media Stream Recording Profile"},
	"aax":  {Description: "Audible Enhanced Audiobook (.AAX)"},
	"ARRI": {Description: "ARRI Digital Camera"},
	"avc1": {Description: "Advanced Video Coding extensions"},
	"avif": {Description: "AV1 Image File Format (.AVIF)"},
	"bbxm": {Description: "Blinkbox Master File: H.264 video and 16-bit little-endian LPCM audio"},
	"caaa": {Description: "CMAF Media Profile - AAC Adaptive Audio"},
	"caac": {Description: "CMAF Media Profile - AAC Core"},
	"CAEP": {Description: "Canon Digital Camera"},
	"caqv": {Description: "Casio Digital Camera"},
	"ccea": {Description: "CMAF Supplemental Data - CEA-608/708"},
	"ccff": {Description: "Common container file format"},
	"CDes": {Description: "Convergent Designs"},
	"cfhd": {Description: "CMAF Media Profile - AVC HD"},
	"cfsd": {Description: "CMAF Media Profile - AVC SD"},
	"chd1": {Description: "CMAF Media Profile - HEVC HDR10"},
	"chdf": {Description: "CMAF Media Profile - AVC HDHF"},
	"chh1": {Description: "CMAF Media Profile - HEVC HHD10"},
	"chhd": {Description: "CMAF Media Profile - HEVC HHD8"},
	"clg1": {Description: "CMAF Media Profile - HEVC HLG10"},
	"cmfc": {Description: "CMAF Track Format"},
	"cmff": {Description: "CMAF Fragment Format"},
	"cmfl": {Description: "CMAF Chunk Format"},
	"cmfs": {Description: "CMAF Segment Format"},
	"crx":  {Description: "Canon Raw (.CRX)"},
	"cud1": {Description: "CMAF Media Profile - HEVC UHD10"},
	"cud8": {Description: "CMAF Media Profile - HEVC UHD8"},
	"cwvt": {Description: "CMAF Media Profile - WebVTT"},
	"da0a": {Description: "DMB AF audio with MPEG Layer II audio, MOT slide show, DLS, JPG/PNG/MNG images"},
	"da0b": {Description: "DMB AF, extending da0a , with 3GPP timed text, DID, TVA, REL, IPMP"},
	"da1a": {Description: "DMB AF audio with ER-BSAC audio, JPG/PNG/MNG images"},
	"da1b": {Description: "DMB AF, extending da1a, with 3GPP timed text, DID, TVA, REL, IPMP"},
	"da2a": {Description: "DMB AF audio with HE-AAC v2 audio, MOT slide show, DLS, JPG/PNG/MNG images"},
	"da2b": {Description: "DMB AF extending da2a, with 3GPP timed text, DID, TVA, REL, IPMP"},
	"da3a": {Description: "DMB AF audio with HE-AAC, JPG/PNG/MNG images"},
	"da3b": {Description: "DMB AF extending da3a with BIFS, 3GPP timed text, DID, TVA, REL, IPMP"},
	"dash": {Description: "ISO base media file format file specifically designed for DASH including movie fragments and Segment Index"},
	"dby1": {Description: "MP4 files with Dolby content (e.g. Dolby AC-4, Dolby Digital Plus, Dolby TrueHD (Dolby MLP))"},
	"dmb1": {Description: "DMB AF supporting all the components defined in the specification"},
	"dmpf": {Description: "Digital Media Project"},
	"drc1": {Description: "Dirac (wavelet compression), encapsulated in ISO base media (MP4)"},
	"dsms": {Description: "Media Segment conforming to the DASH Self-Initializing Media Segment format type for ISO base media file format"},
	"dts1": {Description: "MP4 track file with audio codecs dtsc dtsh or dtse"},
	"dts2": {Description: "MP4 track file with audio codec dtsx"},
	"dts3": {Description: "MP4 track file with audio codec dtsy"},
	"dv1a": {Description: "DMB AF video with AVC video, ER-BSAC audio, BIFS, JPG/PNG/MNG images, TS"},
	"dv1b": {Description: "DMB AF, extending dv1a, with 3GPP timed text, DID, TVA, REL, IPMP"},
	"dv2a": {Description: "DMB AF video with AVC video, HE-AACv2 audio, BIFS, JPG/PNG/MNG images, TS"},
	"dv2b": {Description: "DMB AF extending dv2a, with 3GPP timed text, DID, TVA, REL, IPMP"},
	"dv3a": {Description: "DMB AF video with AVC video, HE-AAC audio, BIFS, JPG/PNG/MNG images, TS"},
	"dv3b": {Description: "DMB AF extending dv3a with 3GPP timed text, DID, TVA, REL, IPMP"},
	"dvr1": {Description: "DVB RTP"},
	"dvt1": {Description: "DVB Transport Stream"},
	"dxo ": {Description: "DxO ONE camera"},
	"emsg": {Description: "Event message box present"},
	"F4A":  {Description: "Audio for Adobe Flash Player 9+ (.F4A)"},
	"F4B":  {Description: "Audio Book for Adobe Flash Player 9+ (.F4B)"},
	"F4P":  {Description: "Protected Video for Adobe Flash Player 9+ (.F4P)"},
	"F4V":  {Description: "Video for Adobe Flash Player 9+ (.F4V)"},
	"heic": {Description: "High Efficiency Image Format HEVC still image (.HEIC)"},
	"heix": {Description: "High Efficiency Image Format still image (.HEIF)"},
	"hevc": {Description: "High Efficiency Image Format HEVC sequence (.HEICS)"},
	"ifrm": {Description: "Apple iFrame Specification, Version 8.1 Jan 2013"},
	"im1i": {Description: "CMAF Media Profile - IMSC1 Image"},
	"im1t": {Description: "CMAF Media Profile - IMSC1 Text"},
	"isc2": {Description: "Files encrypted according to ISMACryp 2.0"},
	"iso2": {Description: "All files based on the 2004 edition of the ISO file format"},
	"iso3": {Description: "Version of the ISO file format"},
	"iso4": {Description: "Version of the ISO file format"},
	"iso5": {Description: "Version of the ISO file format"},
	"iso6": {Description: "Version of the ISO file format"},
	"iso7": {Description: "MP4 Base Media v7"},
	"iso8": {Description: "MP4 Base Media v8"},
	"iso9": {Description: "MP4 Base Media v9"},
	"isom": {Description: "All files based on the ISO Base Media File Format"},
	"J2P0": {Description: "JPEG2000 Profile 0"},
	"J2P1": {Description: "JPEG2000 Profile 1"},
	"JP2":  {Description: "JPEG 2000 Image (.JP2) [ISO 15444-1 ?]"},
	"jp2":  {Description: "JPEG2000 Part 1"},
	"JP20": {Description: "Unknown, from GPAC samples (prob non-existent)"},
	"jpm":  {Description: "JPEG 2000 Part 6 Compound Images"},
	"jpsi": {Description: "The JPSearch data interchange format, for the exchange of image collections and respective metadata"},
	"jpx":  {Description: "JPEG2000 Part 2"},
	"jpxb": {Description: "JPEG XR"},
	"KDDI": {Description: "3GPP2 EZmovie for KDDI 3G cellphones"},
	"LCAG": {Description: "Leica digital camera"},
	"lmsg": {Description: "last Media Segment indicator for ISO base media file format"},
	"M4A":  {Description: "iTunes MPEG-4 audio protected or not"},
	"M4B":  {Description: "iTunes AudioBook protected or not"},
	"M4P":  {Description: "MPEG-4 protected audio"},
	"M4V":  {Description: "MPEG-4 protected audio+video"},
	"M4VH": {Description: "Apple TV (.M4V)"},
	"M4VP": {Description: "Apple iPhone (.M4V)"},
	"MFSM": {Description: "Media File for Samsung video Metadata"},
	"MGSV": {Description: "Home and Mobile Multimedia Platform (HMMP)"},
	"mif1": {Description: "High Efficiency Image Format still image (.HEIF)"},
	"mj2s": {Description: "Motion JPEG 2000 simple profile"},
	"mjp2": {Description: "Motion JPEG 2000, general profile"},
	"mmp4": {Description: "MPEG-4/3GPP Mobile Profile (.MP4/3GP) (for NTT)"},
	"mp21": {Description: "MPEG-21"},
	"mp41": {Description: "MP4 version 1"},
	"mp42": {Description: "MP4 version 2"},
	"mp71": {Description: "MPEG-7 file-level metadata"},
	"MPPI": {Description: "Photo Player Multimedia Application Format"},
	"mpuf": {Description: "Compliance with the MMT Processing Unit format"},
	"mqt":  {Description: "Sony / Mobile QuickTime (.MQV) US Patent 7,477,830 (Sony Corp)"},
	"msdh": {Description: "Media Segment conforming to the general format type for ISO base media file format"},
	"msf1": {Description: "High Efficiency Image Format sequence (.HEIFS)"},
	"msix": {Description: "Media Segment conforming to the Indexed Media Segment format type for ISO base media file format"},
	"MSNV": {Description: "Portable multimedia CE products using MP4 file format with AVC video codec and AAC audio codec"},
	"NDAS": {Description: "MP4 v2 [ISO 14496-14] Nero Digital AAC Audio"},
	"NDSC": {Description: "MPEG-4 (.MP4) Nero Cinema Profile"},
	"NDSH": {Description: "MPEG-4 (.MP4) Nero HDTV Profile"},
	"NDSM": {Description: "MPEG-4 (.MP4) Nero Mobile Profile"},
	"NDSP": {Description: "MPEG-4 (.MP4) Nero Portable Profile"},
	"NDSS": {Description: "MPEG-4 (.MP4) Nero Standard Profile"},
	"NDXC": {Description: "H.264/MPEG-4 AVC (.MP4) Nero Cinema Profile"},
	"NDXH": {Description: "H.264/MPEG-4 AVC (.MP4) Nero HDTV Profile"},
	"NDXM": {Description: "H.264/MPEG-4 AVC (.MP4) Nero Mobile Profile"},
	"NDXP": {Description: "H.264/MPEG-4 AVC (.MP4) Nero Portable Profile"},
	"NDXS": {Description: "H.264/MPEG-4 AVC (.MP4) Nero Standard Profile"},
	"niko": {Description: "Nikon Digital Camera"},
	"odcf": {Description: "OMA DCF (DRM Content Format)"},
	"opf2": {Description: "OMA PDCF (DRM Content Format)"},
	"opx2": {Description: "OMA Adapted PDCF"},
	"pana": {Description: "Panasonic Digital Camera"},
	"piff": {Description: "Protected Interoperable File Format"},
	"pnvi": {Description: "Panasonic Video Intercom Video Intercom"},
	"qt ":  {Description: "QuickTime"},
	"risx": {Description: "Representation Index Segment used to index MPEG-2 TS based Media Segments"},
	"ROSS": {Description: "Ross Video	Ross"},
	"sdv":  {Description: "SD Video"},
	"SEAU": {Description: "Home and Mobile Multimedia Platform (HMMP)"},
	"SEBK": {Description: "Home and Mobile Multimedia Platform (HMMP)"},
	"senv": {Description: "Video contents Sony Entertainment Network provides by using MP4 file format"},
	"sims": {Description: "Media Segment conforming to the Sub-Indexed Media Segment format type for ISO base media file format"},
	"sisx": {Description: "Single Index Segment used to index MPEG-2 TS based Media Segments"},
	"ssc1": {Description: "Samsung stereoscopic, single stream"},
	"ssc2": {Description: "Samsung stereoscopic, dual stream"},
	"ssss": {Description: "Subsegment Index Segment used to index MPEG-2 TS based Media Segments"},
	"uvvu": {Description: "UltraViolet file brand – conforming to the DECE Common File Format spec, Annex E"},
	"XAVC": {Description: "XAVC File Format"},
}
