/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.engine;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IConnectionPointReference;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IEntryPointPseudoState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IExitPointPseudoState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IRegion;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateVertex;
import com.modeliosoft.modelio.api.utils.ObList;
import java.util.List;

public class StateMachineUpdater {
    private IState selectedState;
    private IStateMachine stateMachine;
    private List<IConnectionPointReference> statePoints = new ObList();

    public StateMachineUpdater(IState selectedState) {
        this.selectedState = selectedState;
        this.stateMachine = selectedState.getSubMachine();
        this.statePoints = this.selectedState.getConnection();
    }

    public void updateState(IModelingSession session) {
        IRegion topRegion = this.stateMachine.getTop();
        ObList ownedElements = topRegion.getSub();
        for (IStateVertex point : ownedElements) {
            if (!(point instanceof IEntryPointPseudoState) && !(point instanceof IExitPointPseudoState)) continue;
            this.comparePointName(point, session);
        }
    }

    private void comparePointName(IStateVertex entryExitPoint, IModelingSession session) {
        String pointName = entryExitPoint.getName();
        boolean pointFounded = false;
        for (IConnectionPointReference connectionPoint : this.statePoints) {
            if (!pointName.equals(connectionPoint.getName())) continue;
            pointFounded = true;
            if (entryExitPoint instanceof IExitPointPseudoState) {
                if (connectionPoint.getExit() != null) continue;
                connectionPoint.setExit((IExitPointPseudoState)entryExitPoint);
                continue;
            }
            if (!(entryExitPoint instanceof IEntryPointPseudoState) || connectionPoint.getEntry() != null) continue;
            connectionPoint.setEntry((IEntryPointPseudoState)entryExitPoint);
        }
        if (!pointFounded) {
            IConnectionPointReference connectionPoint;
            connectionPoint = session.getModel().createConnectionPointReference();
            connectionPoint.setName(entryExitPoint.getName());
            if (entryExitPoint instanceof IExitPointPseudoState) {
                connectionPoint.setExit((IExitPointPseudoState)entryExitPoint);
                this.selectedState.addConnection(connectionPoint);
            } else if (entryExitPoint instanceof IEntryPointPseudoState) {
                connectionPoint.setEntry((IEntryPointPseudoState)entryExitPoint);
                this.selectedState.addConnection(connectionPoint);
            }
        }
    }
}

