/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.engine;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IFeature;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.model.uml.statik.IRaisedException;
import com.modeliosoft.modelio.api.model.uml.statik.ObPassingModeEnum;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.api.utils.TagTypeNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;

public class InterfaceImplementer {
    public boolean updateImplementingClassifiers(IModelingSession session, IInterface theInterface) {
        boolean result = false;
        for (IInterfaceRealization theRealization : theInterface.getImplementedLink()) {
            INameSpace theNameSpace = theRealization.getImplementer();
            if (theNameSpace == null || !(theNameSpace instanceof IClassifier)) continue;
            boolean newResult = this.implementInterface(session, (IClassifier)theNameSpace, theInterface);
            boolean bl = result = result || newResult;
        }
        return result;
    }

    public boolean implementInterfaces(IModelingSession session, IClassifier futureOperationOwner) {
        boolean ret = true;
        Iterator iter = futureOperationOwner.getRealized().iterator();
        while (iter.hasNext()) {
            IInterface itf = ((IInterfaceRealization)iter.next()).getImplemented();
            boolean bl = ret = ret && this.implementInterface(session, futureOperationOwner, itf);
        }
        return ret;
    }

    private boolean implementInterface(IModelingSession session, IClassifier futureOperationOwner, IInterface itf) {
        try {
            for (IFeature element : itf.getPart(IOperation.class)) {
                IOperation interfacefOperation = (IOperation)element;
                IOperation implementingOperation = this.getImplementingOperation(interfacefOperation, futureOperationOwner);
                if (implementingOperation == null) {
                    if (futureOperationOwner.isAbstract()) continue;
                    implementingOperation = session.getModel().createOperation(interfacefOperation.getName(), futureOperationOwner);
                    implementingOperation.setRedefines(interfacefOperation);
                    this.copyOperationContent(session, interfacefOperation, implementingOperation);
                    continue;
                }
                this.copyOperationContent(session, interfacefOperation, implementingOperation);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean unImplementInterfaces(IClassifier current) {
        boolean res = false;
        block0: for (IOperation op : current.getPart(IOperation.class)) {
            Iterator iter = current.getRealized().iterator();
            while (iter.hasNext()) {
                IInterface itf = ((IInterfaceRealization)iter.next()).getImplemented();
                IOperation superOperation = this.getSuperOperation(op, itf);
                if (superOperation == null) continue;
                op.delete();
                res = true;
                continue block0;
            }
        }
        return res;
    }

    private boolean contentEquals(IOperation operationToFind, IOperation op) {
        boolean found = true;
        if (this.contentEquals(operationToFind.getReturn(), op.getReturn()) && operationToFind.getIO().size() == op.getIO().size()) {
            Iterator iterator = op.getIO().iterator();
            Iterator iterator2 = operationToFind.getIO().iterator();
            while (iterator2.hasNext() && found) {
                IParameter oldParam = (IParameter)iterator.next();
                IParameter newParam = (IParameter)iterator2.next();
                if (this.contentEquals(newParam, oldParam)) continue;
                found = false;
            }
            if (operationToFind.getThrown().size() == op.getThrown().size()) {
                Iterator itOldExcept = op.getThrown().iterator();
                Iterator itNewExcept = operationToFind.getThrown().iterator();
                while (itNewExcept.hasNext() && found) {
                    IRaisedException oldExcept = (IRaisedException)itOldExcept.next();
                    IRaisedException newExcept = (IRaisedException)itNewExcept.next();
                    if (newExcept.getThrownType().equals((Object)oldExcept.getThrownType())) continue;
                    found = false;
                }
                if (found) {
                    return true;
                }
            }
        }
        return false;
    }

    private IOperation getImplementingOperation(IOperation operationToMatch, IClassifier potentialParent) {
        String operationToMatchName = operationToMatch.getName();
        for (IOperation op : potentialParent.getPart(IOperation.class)) {
            if (!operationToMatch.equals((Object)op.getRedefines())) continue;
            return op;
        }
        for (IOperation op : potentialParent.getPart(IOperation.class)) {
            String opName = op.getName();
            if (!operationToMatchName.equals(opName) || !this.contentEquals(operationToMatch, op)) continue;
            op.setRedefines(operationToMatch);
            return op;
        }
        return null;
    }

    private IOperation getSuperOperation(IOperation operationToMatch, IInterface potentialParent) {
        for (IOperation op : potentialParent.getPart(IOperation.class)) {
            if (!op.equals((Object)operationToMatch.getRedefines())) continue;
            return op;
        }
        for (IOperation op : potentialParent.getPart(IOperation.class)) {
            if (!this.contentEquals(op, operationToMatch)) continue;
            return op;
        }
        return null;
    }

    private boolean contentEquals(IParameter p1, IParameter p2) {
        return p1 == null && p2 == null || p1 != null && p1.getType().equals((Object)p2.getType());
    }

    private void copyOperationContent(IModelingSession session, IOperation originalOperation, IOperation newOperation) {
        IParameter returnParam;
        newOperation.setName(originalOperation.getName());
        newOperation.setClass(originalOperation.isClass());
        newOperation.setConcurrency(originalOperation.isConcurrency());
        this.copyExceptions(session, originalOperation, newOperation);
        newOperation.setFinal(originalOperation.isFinal());
        this.copyImports(session, originalOperation, newOperation);
        this.copyNotes(session, (IModelElement)originalOperation, (IModelElement)newOperation);
        ObList originalParameters = originalOperation.getIO();
        ObList oldParameters = newOperation.getIO();
        for (IParameter theParameter : oldParameters) {
            theParameter.delete();
        }
        for (IParameter oldParam : originalParameters) {
            IParameter newParam = session.getModel().createIOParameter("", null, newOperation);
            this.copyParameterContent(session, oldParam, newParam);
        }
        newOperation.setPassing(originalOperation.getPassing());
        if (originalOperation.getReturn() != null) {
            returnParam = session.getModel().createReturnParameter("", null, newOperation);
            this.copyParameterContent(session, originalOperation.getReturn(), returnParam);
        } else {
            returnParam = newOperation.getReturn();
            if (returnParam != null) {
                session.getModel().deleteElement((IElement)returnParam);
            }
        }
        this.copyStereotypes(session, (IModelElement)originalOperation, (IModelElement)newOperation);
        this.copyTaggedValues(session, (IModelElement)originalOperation, (IModelElement)newOperation);
        newOperation.setVisibility(originalOperation.getVisibility());
    }

    private void copyExceptions(IModelingSession session, IOperation originalOperation, IOperation newOperation) {
        ObList originalExceptions = originalOperation.getThrown();
        ObList oldExceptions = newOperation.getThrown();
        for (IRaisedException theParameter : oldExceptions) {
            session.getModel().deleteElement((IElement)theParameter);
        }
        for (IRaisedException oldException : originalExceptions) {
            IRaisedException newException = session.getModel().createRaisedException();
            newException.setThrownType(oldException.getThrownType());
            newException.setThrower(newOperation);
            this.copyNotes(session, (IModelElement)oldException, (IModelElement)newException);
            this.copyStereotypes(session, (IModelElement)oldException, (IModelElement)newException);
            this.copyTaggedValues(session, (IModelElement)oldException, (IModelElement)newException);
        }
    }

    private void copyStereotypes(IModelingSession session, IModelElement originalElement, IModelElement newElement) {
        for (IStereotype stereo : originalElement.getExtension()) {
            String n = stereo.getName();
            try {
                IStereotype s = session.getMetamodelExtensions().getStereotype(IOperation.class, n);
                if (s == null || newElement.isStereotyped(s.getName())) continue;
                newElement.addExtension(s);
            }
            catch (StereotypeNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyTaggedValues(IModelingSession session, IModelElement originalElement, IModelElement newElement) {
        for (ITaggedValue oldTag : originalElement.getTag()) {
            try {
                ITaggedValue newTag2;
                ITagType oldTagType = oldTag.getDefinition();
                if (oldTagType == null) continue;
                String oldTagTypeName = oldTagType.getName();
                boolean exists = false;
                for (ITaggedValue newTag2 : newElement.getTag()) {
                    ITagType newTagType = newTag2.getDefinition();
                    if (newTagType == null) continue;
                    String newTagTypeName = newTagType.getName();
                    if (oldTagTypeName.equals(newTagTypeName)) {
                        for (ITagParameter param : newTag2.getActual()) {
                            session.getModel().deleteElement((IElement)param);
                        }
                    }
                    newTag2.setQualifier(oldTag.getQualifier());
                    for (ITagParameter param : oldTag.getActual()) {
                        session.getModel().createTagParameter(param.getValue(), newTag2);
                    }
                    exists = true;
                    break;
                }
                if (exists) continue;
                newTag2 = session.getModel().createTaggedValue(oldTagTypeName, newElement);
                newTag2.setQualifier(oldTag.getQualifier());
                for (ITagParameter param : oldTag.getActual()) {
                    session.getModel().createTagParameter(param.getValue(), newTag2);
                }
            }
            catch (TagTypeNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyNotes(IModelingSession session, IModelElement originalElement, IModelElement newElement) {
        for (INote oldNote : originalElement.getDescriptor()) {
            try {
                INoteType oldNoteType = oldNote.getModel();
                if (oldNoteType == null) continue;
                String oldNoteTypeName = oldNoteType.getName();
                boolean exists = false;
                for (INote newNote : newElement.getDescriptor()) {
                    String newNoteTypeName;
                    INoteType newNoteType = newNote.getModel();
                    if (newNoteType == null || !oldNoteTypeName.equals(newNoteTypeName = newNoteType.getName())) continue;
                    newNote.setContent(oldNote.getContent());
                    exists = true;
                    break;
                }
                if (exists) continue;
                session.getModel().createNote(oldNoteTypeName, newElement, oldNote.getContent());
            }
            catch (NoteTypeNotFoundException noteTypeNotFoundException) {
                // empty catch block
            }
        }
    }

    private void copyParameterContent(IModelingSession session, IParameter originalParameter, IParameter newParameter) {
        boolean isReturnParameter = originalParameter.getReturned() != null;
        newParameter.setMultiplicityMin(originalParameter.getMultiplicityMin());
        newParameter.setMultiplicityMax(originalParameter.getMultiplicityMax());
        newParameter.setTypeConstraint(originalParameter.getTypeConstraint());
        newParameter.setType(originalParameter.getType());
        this.copyNotes(session, (IModelElement)originalParameter, (IModelElement)newParameter);
        this.copyStereotypes(session, (IModelElement)originalParameter, (IModelElement)newParameter);
        this.copyTaggedValues(session, (IModelElement)originalParameter, (IModelElement)newParameter);
        if (!isReturnParameter) {
            newParameter.setName(originalParameter.getName());
            newParameter.setDefaultValue(originalParameter.getDefaultValue());
            newParameter.setParameterPassing(originalParameter.getParameterPassing());
        } else {
            newParameter.setParameterPassing(ObPassingModeEnum.OUT);
        }
    }

    private void copyImports(IModelingSession session, IOperation originalOperation, IOperation newOperation) {
        IElementImport newImport2;
        boolean exists;
        for (IElementImport originalImport : originalOperation.getOwnedImport()) {
            exists = false;
            for (IElementImport newImport2 : newOperation.getOwnedImport()) {
                INameSpace newImportedElement = newImport2.getImportedElement();
                INameSpace oldImportedElement = originalImport.getImportedElement();
                if (newImportedElement == null || oldImportedElement == null || !newImportedElement.equals((Object)oldImportedElement)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            newImport2 = session.getModel().createElementImport();
            newImport2.setName(originalImport.getName());
            newImport2.setVisibility(originalImport.getVisibility());
            newImport2.setImportingOperation(newOperation);
            newImport2.setImportedElement(originalImport.getImportedElement());
            this.copyNotes(session, (IModelElement)originalImport, (IModelElement)newImport2);
            this.copyStereotypes(session, (IModelElement)originalImport, (IModelElement)newImport2);
            this.copyTaggedValues(session, (IModelElement)originalImport, (IModelElement)newImport2);
        }
        for (IElementImport originalImport : originalOperation.getOwnedPackageImport()) {
            exists = false;
            for (IElementImport newImport2 : newOperation.getOwnedPackageImport()) {
                IPackage newImportedPackage = newImport2.getImportedPackage();
                IPackage oldImportedPackage = originalImport.getImportedPackage();
                if (newImportedPackage == null || oldImportedPackage == null || !newImportedPackage.equals((Object)oldImportedPackage)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            newImport2 = session.getModel().createPackageImport();
            newImport2.setName(originalImport.getName());
            newImport2.setVisibility(originalImport.getVisibility());
            newImport2.setImportingOperation(newOperation);
            newImport2.setImportedPackage(originalImport.getImportedPackage());
            this.copyNotes(session, (IModelElement)originalImport, (IModelElement)newImport2);
            this.copyStereotypes(session, (IModelElement)originalImport, (IModelElement)newImport2);
            this.copyTaggedValues(session, (IModelElement)originalImport, (IModelElement)newImport2);
        }
    }

    public boolean updateRedefineLinks(IClassifier operationsOwner) {
        boolean hasDoneWork = false;
        ArrayList<IInterface> implementedInterfaces = new ArrayList<IInterface>();
        Iterator iter = operationsOwner.getRealized().iterator();
        while (iter.hasNext()) {
            IInterface itf = ((IInterfaceRealization)iter.next()).getImplemented();
            implementedInterfaces.add(itf);
        }
        for (IOperation operation : operationsOwner.getPart(IOperation.class)) {
            IClassifier redefinedOperationOwner;
            IOperation redefinedOperation = operation.getRedefines();
            if (redefinedOperation == null || !((redefinedOperationOwner = redefinedOperation.getOwner()) instanceof IInterface) || implementedInterfaces.contains(redefinedOperation)) continue;
            operation.setRedefines(null);
            hasDoneWork = true;
        }
        return hasDoneWork;
    }
}

