/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version. Alternatively, you may use the original license
reproduced below.

Copyright 1999 by Comstar.net, Inc., Atlanta, GA, US.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Comstar.net, Inc.
or COMSTAR not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

COMSTAR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL COMSTAR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
*/



// This 2000 lines intentionally left blank.


































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































PyMODINIT_FUNC
PyInit__mysql(void)
#else
DL_EXPORT(void)
init_mysql(void)
#endif
{
	PyObject *dict, *module, *emod, *edict;

    utf8conn = mysql_init(NULL);
    utf8conn->charset = &my_charset_utf8mb4_unicode_ci;

#ifdef IS_PY3K
    module = PyModule_Create(&_mysqlmodule);
	if (!module) return module; /* this really should never happen */
#else
	module = Py_InitModule4("_mysql", _mysql_methods, _mysql___doc__,
				(PyObject *)NULL, PYTHON_API_VERSION);
	if (!module) return; /* this really should never happen */
#endif
#ifdef IS_PY3K
	Py_TYPE(&_mysql_ConnectionObject_Type) = &PyType_Type;
	Py_TYPE(&_mysql_ResultObject_Type) = &PyType_Type;
#else
	_mysql_ConnectionObject_Type.ob_type = &PyType_Type;
	_mysql_ResultObject_Type.ob_type = &PyType_Type;
#endif
#if PY_VERSION_HEX >= 0x02020000
	_mysql_ConnectionObject_Type.tp_alloc = PyType_GenericAlloc;
	_mysql_ResultObject_Type.tp_alloc = PyType_GenericAlloc;
	_mysql_ConnectionObject_Type.tp_new = PyType_GenericNew;
	_mysql_ResultObject_Type.tp_new = PyType_GenericNew;
#ifndef IS_PY3K
	_mysql_ConnectionObject_Type.tp_free = _PyObject_GC_Del;
	_mysql_ResultObject_Type.tp_free = _PyObject_GC_Del;
#endif
#endif

	if (!(dict = PyModule_GetDict(module))) goto error;
	if (PyDict_SetItemString(dict, "version_info",
			       PyRun_String(QUOTE(version_info), Py_eval_input,
				       dict, dict)))
		goto error;
	if (PyDict_SetItemString(dict, "__version__",
			       PyUnicode_FromString(QUOTE(__version__))))
		goto error;
	if (PyDict_SetItemString(dict, "connection",
			       (PyObject *)&_mysql_ConnectionObject_Type))
		goto error;
	Py_INCREF(&_mysql_ConnectionObject_Type);
	if (PyDict_SetItemString(dict, "result",
			       (PyObject *)&_mysql_ResultObject_Type))
		goto error;	
	Py_INCREF(&_mysql_ResultObject_Type);
	if (!(emod = PyImport_ImportModule("_mysql_exceptions"))) {
	    PyErr_Print();
		goto error;
	}
	if (!(edict = PyModule_GetDict(emod))) goto error;
	if (!(_mysql_MySQLError =
	      _mysql_NewException(dict, edict, "MySQLError")))
		goto error;
	if (!(_mysql_Warning =
	      _mysql_NewException(dict, edict, "Warning")))
		goto error;
	if (!(_mysql_Error =
	      _mysql_NewException(dict, edict, "Error")))
		goto error;
	if (!(_mysql_InterfaceError =
	      _mysql_NewException(dict, edict, "InterfaceError")))
		goto error;
	if (!(_mysql_DatabaseError =
	      _mysql_NewException(dict, edict, "DatabaseError")))
		goto error;
	if (!(_mysql_DataError =
	      _mysql_NewException(dict, edict, "DataError")))
		goto error;
	if (!(_mysql_OperationalError =
	      _mysql_NewException(dict, edict, "OperationalError")))
		goto error;
	if (!(_mysql_IntegrityError =
	      _mysql_NewException(dict, edict, "IntegrityError")))
		goto error;
	if (!(_mysql_InternalError =
	      _mysql_NewException(dict, edict, "InternalError")))
		goto error;
	if (!(_mysql_ProgrammingError =
	      _mysql_NewException(dict, edict, "ProgrammingError")))
		goto error;
	if (!(_mysql_NotSupportedError =
	      _mysql_NewException(dict, edict, "NotSupportedError")))
		goto error;
	if (!(_mysql_NULL = PyBytes_FromString("NULL")))
		goto error;
	if (PyDict_SetItemString(dict, "NULL", _mysql_NULL)) goto error;
  error:
	if (emod) Py_DECREF(emod);
	if (PyErr_Occurred()) {
		PyErr_SetString(PyExc_ImportError,
				"_mysql: init failed");
		if (module) Py_DECREF(module);
		module = NULL;
    }
#ifdef IS_PY3K
    return module;
#endif
}


// vim:noet:ts=4:
