
// GENERATED FILE DO NOT EDIT
// $ xsltproc DefaultDicts.xsl Part6.xml > gdcmDefaultDicts.cxx

/*=========================================================================

  Program: GDCM (Grassroots DICOM). A DICOM library

  Copyright (c) 2006-2011 Mathieu Malaterre
  All rights reserved.
  See Copyright.txt or http://gdcm.sourceforge.net/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef GDCMDEFAULTDICTS_CXX
#define GDCMDEFAULTDICTS_CXX

#include "gdcmDicts.h"
#include "gdcmVR.h"
#include "gdcmDict.h"
#include "gdcmDictEntry.h"

namespace gdcm {
typedef struct
{
  uint16_t group;
  uint16_t element;
  VR::VRType vr;
  VM::VMType vm;
  const char *name;
  const char *keyword;
  bool ret;
} DICT_ENTRY;

static const DICT_ENTRY DICOMV3DataDict [] = {
  {0x0000,0x0000,VR::UL,VM::VM1,"Command Group Length","CommandGroupLength",false },
  {0x0000,0x0001,VR::UL,VM::VM1,"Command Length to End","CommandLengthToEnd",true },
  {0x0000,0x0002,VR::UI,VM::VM1,"Affected SOP Class UID","AffectedSOPClassUID",false },
  {0x0000,0x0003,VR::UI,VM::VM1,"Requested SOP Class UID","RequestedSOPClassUID",false },
  {0x0000,0x0010,VR::SH,VM::VM1,"Command Recognition Code","CommandRecognitionCode",true },
  {0x0000,0x0100,VR::US,VM::VM1,"Command Field","CommandField",false },
  {0x0000,0x0110,VR::US,VM::VM1,"Message ID","MessageID",false },
  {0x0000,0x0120,VR::US,VM::VM1,"Message ID Being Responded To","MessageIDBeingRespondedTo",false },
  {0x0000,0x0200,VR::AE,VM::VM1,"Initiator","Initiator",true },
  {0x0000,0x0300,VR::AE,VM::VM1,"Receiver","Receiver",true },
  {0x0000,0x0400,VR::AE,VM::VM1,"Find Location","FindLocation",true },
  {0x0000,0x0600,VR::AE,VM::VM1,"Move Destination","MoveDestination",false },
  {0x0000,0x0700,VR::US,VM::VM1,"Priority","Priority",false },
  {0x0000,0x0800,VR::US,VM::VM1,"Command Data Set Type","CommandDataSetType",false },
  {0x0000,0x0850,VR::US,VM::VM1,"Number of Matches","NumberOfMatches",true },
  {0x0000,0x0860,VR::US,VM::VM1,"Response Sequence Number","ResponseSequenceNumber",true },
  {0x0000,0x0900,VR::US,VM::VM1,"Status","Status",false },
  {0x0000,0x0901,VR::AT,VM::VM1_n,"Offending Element","OffendingElement",false },
  {0x0000,0x0902,VR::LO,VM::VM1,"Error Comment","ErrorComment",false },
  {0x0000,0x0903,VR::US,VM::VM1,"Error ID","ErrorID",false },
  {0x0000,0x1000,VR::UI,VM::VM1,"Affected SOP Instance UID","AffectedSOPInstanceUID",false },
  {0x0000,0x1001,VR::UI,VM::VM1,"Requested SOP Instance UID","RequestedSOPInstanceUID",false },
  {0x0000,0x1002,VR::US,VM::VM1,"Event Type ID","EventTypeID",false },
  {0x0000,0x1005,VR::AT,VM::VM1_n,"Attribute Identifier List","AttributeIdentifierList",false },
  {0x0000,0x1008,VR::US,VM::VM1,"Action Type ID","ActionTypeID",false },
  {0x0000,0x1020,VR::US,VM::VM1,"Number of Remaining Sub-operations","NumberOfRemainingSuboperations",false },
  {0x0000,0x1021,VR::US,VM::VM1,"Number of Completed Sub-operations","NumberOfCompletedSuboperations",false },
  {0x0000,0x1022,VR::US,VM::VM1,"Number of Failed Sub-operations","NumberOfFailedSuboperations",false },
  {0x0000,0x1023,VR::US,VM::VM1,"Number of Warning Sub-operations","NumberOfWarningSuboperations",false },
  {0x0000,0x1030,VR::AE,VM::VM1,"Move Originator Application Entity Title","MoveOriginatorApplicationEntityTitle",false },
  {0x0000,0x1031,VR::US,VM::VM1,"Move Originator Message ID","MoveOriginatorMessageID",false },
  {0x0000,0x4000,VR::LT,VM::VM1,"Dialog Receiver","DialogReceiver",true },
  {0x0000,0x4010,VR::LT,VM::VM1,"Terminal Type","TerminalType",true },
  {0x0000,0x5010,VR::SH,VM::VM1,"Message Set ID","MessageSetID",true },
  {0x0000,0x5020,VR::SH,VM::VM1,"End Message ID","EndMessageID",true },
  {0x0000,0x5110,VR::LT,VM::VM1,"Display Format","DisplayFormat",true },
  {0x0000,0x5120,VR::LT,VM::VM1,"Page Position ID","PagePositionID",true },
  {0x0000,0x5130,VR::CS,VM::VM1,"Text Format ID","TextFormatID",true },
  {0x0000,0x5140,VR::CS,VM::VM1,"Normal/Reverse","NormalReverse",true },
  {0x0000,0x5150,VR::CS,VM::VM1,"Add Gray Scale","AddGrayScale",true },
  {0x0000,0x5160,VR::CS,VM::VM1,"Borders","Borders",true },
  {0x0000,0x5170,VR::IS,VM::VM1,"Copies","Copies",true },
  {0x0000,0x5180,VR::CS,VM::VM1,"Command Magnification Type","CommandMagnificationType",true },
  {0x0000,0x5190,VR::CS,VM::VM1,"Erase","Erase",true },
  {0x0000,0x51a0,VR::CS,VM::VM1,"Print","Print",true },
  {0x0000,0x51b0,VR::US,VM::VM1_n,"Overlays","Overlays",true },
  {0x0002,0x0000,VR::UL,VM::VM1,"File Meta Information Group Length","FileMetaInformationGroupLength",false },
  {0x0002,0x0001,VR::OB,VM::VM1,"File Meta Information Version","FileMetaInformationVersion",false },
  {0x0002,0x0002,VR::UI,VM::VM1,"Media Storage SOP Class UID","MediaStorageSOPClassUID",false },
  {0x0002,0x0003,VR::UI,VM::VM1,"Media Storage SOP Instance UID","MediaStorageSOPInstanceUID",false },
  {0x0002,0x0010,VR::UI,VM::VM1,"Transfer Syntax UID","TransferSyntaxUID",false },
  {0x0002,0x0012,VR::UI,VM::VM1,"Implementation Class UID","ImplementationClassUID",false },
  {0x0002,0x0013,VR::SH,VM::VM1,"Implementation Version Name","ImplementationVersionName",false },
  {0x0002,0x0016,VR::AE,VM::VM1,"Source Application Entity Title","SourceApplicationEntityTitle",false },
  {0x0002,0x0100,VR::UI,VM::VM1,"Private Information Creator UID","PrivateInformationCreatorUID",false },
  {0x0002,0x0102,VR::OB,VM::VM1,"Private Information","PrivateInformation",false },
  {0x0004,0x1130,VR::CS,VM::VM1,"File-set ID","FileSetID",false },
  {0x0004,0x1141,VR::CS,VM::VM1_8,"File-set Descriptor File ID","FileSetDescriptorFileID",false },
  {0x0004,0x1142,VR::CS,VM::VM1,"Specific Character Set of File-set Descriptor File","SpecificCharacterSetOfFileSetDescriptorFile",false },
  {0x0004,0x1200,VR::UL,VM::VM1,"Offset of the First Directory Record of the Root Directory Entity","OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity",false },
  {0x0004,0x1202,VR::UL,VM::VM1,"Offset of the Last Directory Record of the Root Directory Entity","OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity",false },
  {0x0004,0x1212,VR::US,VM::VM1,"File-set Consistency Flag","FileSetConsistencyFlag",false },
  {0x0004,0x1220,VR::SQ,VM::VM1,"Directory Record Sequence","DirectoryRecordSequence",false },
  {0x0004,0x1400,VR::UL,VM::VM1,"Offset of the Next Directory Record","OffsetOfTheNextDirectoryRecord",false },
  {0x0004,0x1410,VR::US,VM::VM1,"Record In-use Flag","RecordInUseFlag",false },
  {0x0004,0x1420,VR::UL,VM::VM1,"Offset of Referenced Lower-Level Directory Entity","OffsetOfReferencedLowerLevelDirectoryEntity",false },
  {0x0004,0x1430,VR::CS,VM::VM1,"Directory Record Type","DirectoryRecordType",false },
  {0x0004,0x1432,VR::UI,VM::VM1,"Private Record UID","PrivateRecordUID",false },
  {0x0004,0x1500,VR::CS,VM::VM1_8,"Referenced File ID","ReferencedFileID",false },
  {0x0004,0x1504,VR::UL,VM::VM1,"MRDR Directory Record Offset","MRDRDirectoryRecordOffset",true },
  {0x0004,0x1510,VR::UI,VM::VM1,"Referenced SOP Class UID in File","ReferencedSOPClassUIDInFile",false },
  {0x0004,0x1511,VR::UI,VM::VM1,"Referenced SOP Instance UID in File","ReferencedSOPInstanceUIDInFile",false },
  {0x0004,0x1512,VR::UI,VM::VM1,"Referenced Transfer Syntax UID in File","ReferencedTransferSyntaxUIDInFile",false },
  {0x0004,0x151a,VR::UI,VM::VM1_n,"Referenced Related General SOP Class UID in File","ReferencedRelatedGeneralSOPClassUIDInFile",false },
  {0x0004,0x1600,VR::UL,VM::VM1,"Number of References","NumberOfReferences",true },
  {0x0008,0x0001,VR::UL,VM::VM1,"Length to End","LengthToEnd",true },
  {0x0008,0x0005,VR::CS,VM::VM1_n,"Specific Character Set","SpecificCharacterSet",false },
  {0x0008,0x0006,VR::SQ,VM::VM1,"Language Code Sequence","LanguageCodeSequence",false },
  {0x0008,0x0008,VR::CS,VM::VM2_n,"Image Type","ImageType",false },
  {0x0008,0x0010,VR::SH,VM::VM1,"Recognition Code","RecognitionCode",true },
  {0x0008,0x0012,VR::DA,VM::VM1,"Instance Creation Date","InstanceCreationDate",false },
  {0x0008,0x0013,VR::TM,VM::VM1,"Instance Creation Time","InstanceCreationTime",false },
  {0x0008,0x0014,VR::UI,VM::VM1,"Instance Creator UID","InstanceCreatorUID",false },
  {0x0008,0x0016,VR::UI,VM::VM1,"SOP Class UID","SOPClassUID",false },
  {0x0008,0x0018,VR::UI,VM::VM1,"SOP Instance UID","SOPInstanceUID",false },
  {0x0008,0x001a,VR::UI,VM::VM1_n,"Related General SOP Class UID","RelatedGeneralSOPClassUID",false },
  {0x0008,0x001b,VR::UI,VM::VM1,"Original Specialized SOP Class UID","OriginalSpecializedSOPClassUID",false },
  {0x0008,0x0020,VR::DA,VM::VM1,"Study Date","StudyDate",false },
  {0x0008,0x0021,VR::DA,VM::VM1,"Series Date","SeriesDate",false },
  {0x0008,0x0022,VR::DA,VM::VM1,"Acquisition Date","AcquisitionDate",false },
  {0x0008,0x0023,VR::DA,VM::VM1,"Content Date","ContentDate",false },
  {0x0008,0x0024,VR::DA,VM::VM1,"Overlay Date","OverlayDate",true },
  {0x0008,0x0025,VR::DA,VM::VM1,"Curve Date","CurveDate",true },
  {0x0008,0x002a,VR::DT,VM::VM1,"Acquisition Date Time","AcquisitionDateTime",false },
  {0x0008,0x0030,VR::TM,VM::VM1,"Study Time","StudyTime",false },
  {0x0008,0x0031,VR::TM,VM::VM1,"Series Time","SeriesTime",false },
  {0x0008,0x0032,VR::TM,VM::VM1,"Acquisition Time","AcquisitionTime",false },
  {0x0008,0x0033,VR::TM,VM::VM1,"Content Time","ContentTime",false },
  {0x0008,0x0034,VR::TM,VM::VM1,"Overlay Time","OverlayTime",true },
  {0x0008,0x0035,VR::TM,VM::VM1,"Curve Time","CurveTime",true },
  {0x0008,0x0040,VR::US,VM::VM1,"Data Set Type","DataSetType",true },
  {0x0008,0x0041,VR::LO,VM::VM1,"Data Set Subtype","DataSetSubtype",true },
  {0x0008,0x0042,VR::CS,VM::VM1,"Nuclear Medicine Series Type","NuclearMedicineSeriesType",true },
  {0x0008,0x0050,VR::SH,VM::VM1,"Accession Number","AccessionNumber",false },
  {0x0008,0x0051,VR::SQ,VM::VM1,"Issuer of Accession Number Sequence","IssuerOfAccessionNumberSequence",false },
  {0x0008,0x0052,VR::CS,VM::VM1,"Query/Retrieve Level","QueryRetrieveLevel",false },
  {0x0008,0x0054,VR::AE,VM::VM1_n,"Retrieve AE Title","RetrieveAETitle",false },
  {0x0008,0x0056,VR::CS,VM::VM1,"Instance Availability","InstanceAvailability",false },
  {0x0008,0x0058,VR::UI,VM::VM1_n,"Failed SOP Instance UID List","FailedSOPInstanceUIDList",false },
  {0x0008,0x0060,VR::CS,VM::VM1,"Modality","Modality",false },
  {0x0008,0x0061,VR::CS,VM::VM1_n,"Modalities in Study","ModalitiesInStudy",false },
  {0x0008,0x0062,VR::UI,VM::VM1_n,"SOP Classes in Study","SOPClassesInStudy",false },
  {0x0008,0x0064,VR::CS,VM::VM1,"Conversion Type","ConversionType",false },
  {0x0008,0x0068,VR::CS,VM::VM1,"Presentation Intent Type","PresentationIntentType",false },
  {0x0008,0x0070,VR::LO,VM::VM1,"Manufacturer","Manufacturer",false },
  {0x0008,0x0080,VR::LO,VM::VM1,"Institution Name","InstitutionName",false },
  {0x0008,0x0081,VR::ST,VM::VM1,"Institution Address","InstitutionAddress",false },
  {0x0008,0x0082,VR::SQ,VM::VM1,"Institution Code Sequence","InstitutionCodeSequence",false },
  {0x0008,0x0090,VR::PN,VM::VM1,"Referring Physician's Name","ReferringPhysicianName",false },
  {0x0008,0x0092,VR::ST,VM::VM1,"Referring Physician's Address","ReferringPhysicianAddress",false },
  {0x0008,0x0094,VR::SH,VM::VM1_n,"Referring Physician's Telephone Numbers","ReferringPhysicianTelephoneNumbers",false },
  {0x0008,0x0096,VR::SQ,VM::VM1,"Referring Physician Identification Sequence","ReferringPhysicianIdentificationSequence",false },
  {0x0008,0x0100,VR::SH,VM::VM1,"Code Value","CodeValue",false },
  {0x0008,0x0102,VR::SH,VM::VM1,"Coding Scheme Designator","CodingSchemeDesignator",false },
  {0x0008,0x0103,VR::SH,VM::VM1,"Coding Scheme Version","CodingSchemeVersion",false },
  {0x0008,0x0104,VR::LO,VM::VM1,"Code Meaning","CodeMeaning",false },
  {0x0008,0x0105,VR::CS,VM::VM1,"Mapping Resource","MappingResource",false },
  {0x0008,0x0106,VR::DT,VM::VM1,"Context Group Version","ContextGroupVersion",false },
  {0x0008,0x0107,VR::DT,VM::VM1,"Context Group Local Version","ContextGroupLocalVersion",false },
  {0x0008,0x010b,VR::CS,VM::VM1,"Context Group Extension Flag","ContextGroupExtensionFlag",false },
  {0x0008,0x010c,VR::UI,VM::VM1,"Coding Scheme UID","CodingSchemeUID",false },
  {0x0008,0x010d,VR::UI,VM::VM1,"Context Group Extension Creator UID","ContextGroupExtensionCreatorUID",false },
  {0x0008,0x010f,VR::CS,VM::VM1,"Context Identifier","ContextIdentifier",false },
  {0x0008,0x0110,VR::SQ,VM::VM1,"Coding Scheme Identification Sequence","CodingSchemeIdentificationSequence",false },
  {0x0008,0x0112,VR::LO,VM::VM1,"Coding Scheme Registry","CodingSchemeRegistry",false },
  {0x0008,0x0114,VR::ST,VM::VM1,"Coding Scheme External ID","CodingSchemeExternalID",false },
  {0x0008,0x0115,VR::ST,VM::VM1,"Coding Scheme Name","CodingSchemeName",false },
  {0x0008,0x0116,VR::ST,VM::VM1,"Coding Scheme Responsible Organization","CodingSchemeResponsibleOrganization",false },
  {0x0008,0x0117,VR::UI,VM::VM1,"Context UID","ContextUID",false },
  {0x0008,0x0201,VR::SH,VM::VM1,"Timezone Offset From UTC","TimezoneOffsetFromUTC",false },
  {0x0008,0x1000,VR::AE,VM::VM1,"Network ID","NetworkID",true },
  {0x0008,0x1010,VR::SH,VM::VM1,"Station Name","StationName",false },
  {0x0008,0x1030,VR::LO,VM::VM1,"Study Description","StudyDescription",false },
  {0x0008,0x1032,VR::SQ,VM::VM1,"Procedure Code Sequence","ProcedureCodeSequence",false },
  {0x0008,0x103e,VR::LO,VM::VM1,"Series Description","SeriesDescription",false },
  {0x0008,0x103f,VR::SQ,VM::VM1,"Series Description Code Sequence","SeriesDescriptionCodeSequence",false },
  {0x0008,0x1040,VR::LO,VM::VM1,"Institutional Department Name","InstitutionalDepartmentName",false },
  {0x0008,0x1048,VR::PN,VM::VM1_n,"Physician(s) of Record","PhysiciansOfRecord",false },
  {0x0008,0x1049,VR::SQ,VM::VM1,"Physician(s) of Record Identification Sequence","PhysiciansOfRecordIdentificationSequence",false },
  {0x0008,0x1050,VR::PN,VM::VM1_n,"Performing Physician's Name","PerformingPhysicianName",false },
  {0x0008,0x1052,VR::SQ,VM::VM1,"Performing Physician Identification Sequence","PerformingPhysicianIdentificationSequence",false },
  {0x0008,0x1060,VR::PN,VM::VM1_n,"Name of Physician(s) Reading Study","NameOfPhysiciansReadingStudy",false },
  {0x0008,0x1062,VR::SQ,VM::VM1,"Physician(s) Reading Study Identification Sequence","PhysiciansReadingStudyIdentificationSequence",false },
  {0x0008,0x1070,VR::PN,VM::VM1_n,"Operators' Name","OperatorsName",false },
  {0x0008,0x1072,VR::SQ,VM::VM1,"Operator Identification Sequence","OperatorIdentificationSequence",false },
  {0x0008,0x1080,VR::LO,VM::VM1_n,"Admitting Diagnoses Description","AdmittingDiagnosesDescription",false },
  {0x0008,0x1084,VR::SQ,VM::VM1,"Admitting Diagnoses Code Sequence","AdmittingDiagnosesCodeSequence",false },
  {0x0008,0x1090,VR::LO,VM::VM1,"Manufacturer's Model Name","ManufacturerModelName",false },
  {0x0008,0x1100,VR::SQ,VM::VM1,"Referenced Results Sequence","ReferencedResultsSequence",true },
  {0x0008,0x1110,VR::SQ,VM::VM1,"Referenced Study Sequence","ReferencedStudySequence",false },
  {0x0008,0x1111,VR::SQ,VM::VM1,"Referenced Performed Procedure Step Sequence","ReferencedPerformedProcedureStepSequence",false },
  {0x0008,0x1115,VR::SQ,VM::VM1,"Referenced Series Sequence","ReferencedSeriesSequence",false },
  {0x0008,0x1120,VR::SQ,VM::VM1,"Referenced Patient Sequence","ReferencedPatientSequence",false },
  {0x0008,0x1125,VR::SQ,VM::VM1,"Referenced Visit Sequence","ReferencedVisitSequence",false },
  {0x0008,0x1130,VR::SQ,VM::VM1,"Referenced Overlay Sequence","ReferencedOverlaySequence",true },
  {0x0008,0x1134,VR::SQ,VM::VM1,"Referenced Stereometric Instance Sequence","ReferencedStereometricInstanceSequence",false },
  {0x0008,0x113a,VR::SQ,VM::VM1,"Referenced Waveform Sequence","ReferencedWaveformSequence",false },
  {0x0008,0x1140,VR::SQ,VM::VM1,"Referenced Image Sequence","ReferencedImageSequence",false },
  {0x0008,0x1145,VR::SQ,VM::VM1,"Referenced Curve Sequence","ReferencedCurveSequence",true },
  {0x0008,0x114a,VR::SQ,VM::VM1,"Referenced Instance Sequence","ReferencedInstanceSequence",false },
  {0x0008,0x114b,VR::SQ,VM::VM1,"Referenced Real World Value Mapping Instance Sequence","ReferencedRealWorldValueMappingInstanceSequence",false },
  {0x0008,0x1150,VR::UI,VM::VM1,"Referenced SOP Class UID","ReferencedSOPClassUID",false },
  {0x0008,0x1155,VR::UI,VM::VM1,"Referenced SOP Instance UID","ReferencedSOPInstanceUID",false },
  {0x0008,0x115a,VR::UI,VM::VM1_n,"SOP Classes Supported","SOPClassesSupported",false },
  {0x0008,0x1160,VR::IS,VM::VM1_n,"Referenced Frame Number","ReferencedFrameNumber",false },
  {0x0008,0x1161,VR::UL,VM::VM1_n,"Simple Frame List","SimpleFrameList",false },
  {0x0008,0x1162,VR::UL,VM::VM3_3n,"Calculated Frame List","CalculatedFrameList",false },
  {0x0008,0x1163,VR::FD,VM::VM2,"Time Range","TimeRange",false },
  {0x0008,0x1164,VR::SQ,VM::VM1,"Frame Extraction Sequence","FrameExtractionSequence",false },
  {0x0008,0x1167,VR::UI,VM::VM1,"Multi-Frame Source SOP Instance UID","MultiFrameSourceSOPInstanceUID",false },
  {0x0008,0x1195,VR::UI,VM::VM1,"Transaction UID","TransactionUID",false },
  {0x0008,0x1197,VR::US,VM::VM1,"Failure Reason","FailureReason",false },
  {0x0008,0x1198,VR::SQ,VM::VM1,"Failed SOP Sequence","FailedSOPSequence",false },
  {0x0008,0x1199,VR::SQ,VM::VM1,"Referenced SOP Sequence","ReferencedSOPSequence",false },
  {0x0008,0x1200,VR::SQ,VM::VM1,"Studies Containing Other Referenced Instances Sequence","StudiesContainingOtherReferencedInstancesSequence",false },
  {0x0008,0x1250,VR::SQ,VM::VM1,"Related Series Sequence","RelatedSeriesSequence",false },
  {0x0008,0x2110,VR::CS,VM::VM1,"Lossy Image Compression (Retired)","LossyImageCompressionRetired",true },
  {0x0008,0x2111,VR::ST,VM::VM1,"Derivation Description","DerivationDescription",false },
  {0x0008,0x2112,VR::SQ,VM::VM1,"Source Image Sequence","SourceImageSequence",false },
  {0x0008,0x2120,VR::SH,VM::VM1,"Stage Name","StageName",false },
  {0x0008,0x2122,VR::IS,VM::VM1,"Stage Number","StageNumber",false },
  {0x0008,0x2124,VR::IS,VM::VM1,"Number of Stages","NumberOfStages",false },
  {0x0008,0x2127,VR::SH,VM::VM1,"View Name","ViewName",false },
  {0x0008,0x2128,VR::IS,VM::VM1,"View Number","ViewNumber",false },
  {0x0008,0x2129,VR::IS,VM::VM1,"Number of Event Timers","NumberOfEventTimers",false },
  {0x0008,0x212a,VR::IS,VM::VM1,"Number of Views in Stage","NumberOfViewsInStage",false },
  {0x0008,0x2130,VR::DS,VM::VM1_n,"Event Elapsed Time(s)","EventElapsedTimes",false },
  {0x0008,0x2132,VR::LO,VM::VM1_n,"Event Timer Name(s)","EventTimerNames",false },
  {0x0008,0x2133,VR::SQ,VM::VM1,"Event Timer Sequence","EventTimerSequence",false },
  {0x0008,0x2134,VR::FD,VM::VM1,"Event Time Offset","EventTimeOffset",false },
  {0x0008,0x2135,VR::SQ,VM::VM1,"Event Code Sequence","EventCodeSequence",false },
  {0x0008,0x2142,VR::IS,VM::VM1,"Start Trim","StartTrim",false },
  {0x0008,0x2143,VR::IS,VM::VM1,"Stop Trim","StopTrim",false },
  {0x0008,0x2144,VR::IS,VM::VM1,"Recommended Display Frame Rate","RecommendedDisplayFrameRate",false },
  {0x0008,0x2200,VR::CS,VM::VM1,"Transducer Position","TransducerPosition",true },
  {0x0008,0x2204,VR::CS,VM::VM1,"Transducer Orientation","TransducerOrientation",true },
  {0x0008,0x2208,VR::CS,VM::VM1,"Anatomic Structure","AnatomicStructure",true },
  {0x0008,0x2218,VR::SQ,VM::VM1,"Anatomic Region Sequence","AnatomicRegionSequence",false },
  {0x0008,0x2220,VR::SQ,VM::VM1,"Anatomic Region Modifier Sequence","AnatomicRegionModifierSequence",false },
  {0x0008,0x2228,VR::SQ,VM::VM1,"Primary Anatomic Structure Sequence","PrimaryAnatomicStructureSequence",false },
  {0x0008,0x2229,VR::SQ,VM::VM1,"Anatomic Structure, Space or Region Sequence","AnatomicStructureSpaceOrRegionSequence",false },
  {0x0008,0x2230,VR::SQ,VM::VM1,"Primary Anatomic Structure Modifier Sequence","PrimaryAnatomicStructureModifierSequence",false },
  {0x0008,0x2240,VR::SQ,VM::VM1,"Transducer Position Sequence","TransducerPositionSequence",true },
  {0x0008,0x2242,VR::SQ,VM::VM1,"Transducer Position Modifier Sequence","TransducerPositionModifierSequence",true },
  {0x0008,0x2244,VR::SQ,VM::VM1,"Transducer Orientation Sequence","TransducerOrientationSequence",true },
  {0x0008,0x2246,VR::SQ,VM::VM1,"Transducer Orientation Modifier Sequence","TransducerOrientationModifierSequence",true },
  {0x0008,0x2251,VR::SQ,VM::VM1,"Anatomic Structure Space Or Region Code Sequence (Trial)","AnatomicStructureSpaceOrRegionCodeSequenceTrial",true },
  {0x0008,0x2253,VR::SQ,VM::VM1,"Anatomic Portal Of Entrance Code Sequence (Trial)","AnatomicPortalOfEntranceCodeSequenceTrial",true },
  {0x0008,0x2255,VR::SQ,VM::VM1,"Anatomic Approach Direction Code Sequence (Trial)","AnatomicApproachDirectionCodeSequenceTrial",true },
  {0x0008,0x2256,VR::ST,VM::VM1,"Anatomic Perspective Description (Trial)","AnatomicPerspectiveDescriptionTrial",true },
  {0x0008,0x2257,VR::SQ,VM::VM1,"Anatomic Perspective Code Sequence (Trial)","AnatomicPerspectiveCodeSequenceTrial",true },
  {0x0008,0x2258,VR::ST,VM::VM1,"Anatomic Location Of Examining Instrument Description (Trial)","AnatomicLocationOfExaminingInstrumentDescriptionTrial",true },
  {0x0008,0x2259,VR::SQ,VM::VM1,"Anatomic Location Of Examining Instrument Code Sequence (Trial)","AnatomicLocationOfExaminingInstrumentCodeSequenceTrial",true },
  {0x0008,0x225a,VR::SQ,VM::VM1,"Anatomic Structure Space Or Region Modifier Code Sequence (Trial)","AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial",true },
  {0x0008,0x225c,VR::SQ,VM::VM1,"OnAxis Background Anatomic Structure Code Sequence (Trial)","OnAxisBackgroundAnatomicStructureCodeSequenceTrial",true },
  {0x0008,0x3001,VR::SQ,VM::VM1,"Alternate Representation Sequence","AlternateRepresentationSequence",false },
  {0x0008,0x3010,VR::UI,VM::VM1,"Irradiation Event UID","IrradiationEventUID",false },
  {0x0008,0x4000,VR::LT,VM::VM1,"Identifying Comments","IdentifyingComments",true },
  {0x0008,0x9007,VR::CS,VM::VM4,"Frame Type","FrameType",false },
  {0x0008,0x9092,VR::SQ,VM::VM1,"Referenced Image Evidence Sequence","ReferencedImageEvidenceSequence",false },
  {0x0008,0x9121,VR::SQ,VM::VM1,"Referenced Raw Data Sequence","ReferencedRawDataSequence",false },
  {0x0008,0x9123,VR::UI,VM::VM1,"Creator-Version UID","CreatorVersionUID",false },
  {0x0008,0x9124,VR::SQ,VM::VM1,"Derivation Image Sequence","DerivationImageSequence",false },
  {0x0008,0x9154,VR::SQ,VM::VM1,"Source Image Evidence Sequence","SourceImageEvidenceSequence",false },
  {0x0008,0x9205,VR::CS,VM::VM1,"Pixel Presentation","PixelPresentation",false },
  {0x0008,0x9206,VR::CS,VM::VM1,"Volumetric Properties","VolumetricProperties",false },
  {0x0008,0x9207,VR::CS,VM::VM1,"Volume Based Calculation Technique","VolumeBasedCalculationTechnique",false },
  {0x0008,0x9208,VR::CS,VM::VM1,"Complex Image Component","ComplexImageComponent",false },
  {0x0008,0x9209,VR::CS,VM::VM1,"Acquisition Contrast","AcquisitionContrast",false },
  {0x0008,0x9215,VR::SQ,VM::VM1,"Derivation Code Sequence","DerivationCodeSequence",false },
  {0x0008,0x9237,VR::SQ,VM::VM1,"Referenced Presentation State Sequence","ReferencedPresentationStateSequence",false },
  {0x0008,0x9410,VR::SQ,VM::VM1,"Referenced Other Plane Sequence","ReferencedOtherPlaneSequence",false },
  {0x0008,0x9458,VR::SQ,VM::VM1,"Frame Display Sequence","FrameDisplaySequence",false },
  {0x0008,0x9459,VR::FL,VM::VM1,"Recommended Display Frame Rate in Float","RecommendedDisplayFrameRateInFloat",false },
  {0x0008,0x9460,VR::CS,VM::VM1,"Skip Frame Range Flag","SkipFrameRangeFlag",false },
  {0x0010,0x0010,VR::PN,VM::VM1,"Patient's Name","PatientName",false },
  {0x0010,0x0020,VR::LO,VM::VM1,"Patient ID","PatientID",false },
  {0x0010,0x0021,VR::LO,VM::VM1,"Issuer of Patient ID","IssuerOfPatientID",false },
  {0x0010,0x0022,VR::CS,VM::VM1,"Type of Patient ID","TypeOfPatientID",false },
  {0x0010,0x0024,VR::SQ,VM::VM1,"Issuer of Patient ID Qualifiers Sequence","IssuerOfPatientIDQualifiersSequence",false },
  {0x0010,0x0030,VR::DA,VM::VM1,"Patient's Birth Date","PatientBirthDate",false },
  {0x0010,0x0032,VR::TM,VM::VM1,"Patient's Birth Time","PatientBirthTime",false },
  {0x0010,0x0040,VR::CS,VM::VM1,"Patient's Sex","PatientSex",false },
  {0x0010,0x0050,VR::SQ,VM::VM1,"Patient's Insurance Plan Code Sequence","PatientInsurancePlanCodeSequence",false },
  {0x0010,0x0101,VR::SQ,VM::VM1,"Patient's Primary Language Code Sequence","PatientPrimaryLanguageCodeSequence",false },
  {0x0010,0x0102,VR::SQ,VM::VM1,"Patient's Primary Language Modifier Code Sequence","PatientPrimaryLanguageModifierCodeSequence",false },
  {0x0010,0x1000,VR::LO,VM::VM1_n,"Other Patient IDs","OtherPatientIDs",false },
  {0x0010,0x1001,VR::PN,VM::VM1_n,"Other Patient Names","OtherPatientNames",false },
  {0x0010,0x1002,VR::SQ,VM::VM1,"Other Patient IDs Sequence","OtherPatientIDsSequence",false },
  {0x0010,0x1005,VR::PN,VM::VM1,"Patient's Birth Name","PatientBirthName",false },
  {0x0010,0x1010,VR::AS,VM::VM1,"Patient's Age","PatientAge",false },
  {0x0010,0x1020,VR::DS,VM::VM1,"Patient's Size","PatientSize",false },
  {0x0010,0x1021,VR::SQ,VM::VM1,"Patient's Size Code Sequence","PatientSizeCodeSequence",false },
  {0x0010,0x1030,VR::DS,VM::VM1,"Patient's Weight","PatientWeight",false },
  {0x0010,0x1040,VR::LO,VM::VM1,"Patient's Address","PatientAddress",false },
  {0x0010,0x1050,VR::LO,VM::VM1_n,"Insurance Plan Identification","InsurancePlanIdentification",true },
  {0x0010,0x1060,VR::PN,VM::VM1,"Patient's Mother's Birth Name","PatientMotherBirthName",false },
  {0x0010,0x1080,VR::LO,VM::VM1,"Military Rank","MilitaryRank",false },
  {0x0010,0x1081,VR::LO,VM::VM1,"Branch of Service","BranchOfService",false },
  {0x0010,0x1090,VR::LO,VM::VM1,"Medical Record Locator","MedicalRecordLocator",false },
  {0x0010,0x2000,VR::LO,VM::VM1_n,"Medical Alerts","MedicalAlerts",false },
  {0x0010,0x2110,VR::LO,VM::VM1_n,"Allergies","Allergies",false },
  {0x0010,0x2150,VR::LO,VM::VM1,"Country of Residence","CountryOfResidence",false },
  {0x0010,0x2152,VR::LO,VM::VM1,"Region of Residence","RegionOfResidence",false },
  {0x0010,0x2154,VR::SH,VM::VM1_n,"Patient's Telephone Numbers","PatientTelephoneNumbers",false },
  {0x0010,0x2160,VR::SH,VM::VM1,"Ethnic Group","EthnicGroup",false },
  {0x0010,0x2180,VR::SH,VM::VM1,"Occupation","Occupation",false },
  {0x0010,0x21a0,VR::CS,VM::VM1,"Smoking Status","SmokingStatus",false },
  {0x0010,0x21b0,VR::LT,VM::VM1,"Additional Patient History","AdditionalPatientHistory",false },
  {0x0010,0x21c0,VR::US,VM::VM1,"Pregnancy Status","PregnancyStatus",false },
  {0x0010,0x21d0,VR::DA,VM::VM1,"Last Menstrual Date","LastMenstrualDate",false },
  {0x0010,0x21f0,VR::LO,VM::VM1,"Patient's Religious Preference","PatientReligiousPreference",false },
  {0x0010,0x2201,VR::LO,VM::VM1,"Patient Species Description","PatientSpeciesDescription",false },
  {0x0010,0x2202,VR::SQ,VM::VM1,"Patient Species Code Sequence","PatientSpeciesCodeSequence",false },
  {0x0010,0x2203,VR::CS,VM::VM1,"Patient's Sex Neutered","PatientSexNeutered",false },
  {0x0010,0x2210,VR::CS,VM::VM1,"Anatomical Orientation Type","AnatomicalOrientationType",false },
  {0x0010,0x2292,VR::LO,VM::VM1,"Patient Breed Description","PatientBreedDescription",false },
  {0x0010,0x2293,VR::SQ,VM::VM1,"Patient Breed Code Sequence","PatientBreedCodeSequence",false },
  {0x0010,0x2294,VR::SQ,VM::VM1,"Breed Registration Sequence","BreedRegistrationSequence",false },
  {0x0010,0x2295,VR::LO,VM::VM1,"Breed Registration Number","BreedRegistrationNumber",false },
  {0x0010,0x2296,VR::SQ,VM::VM1,"Breed Registry Code Sequence","BreedRegistryCodeSequence",false },
  {0x0010,0x2297,VR::PN,VM::VM1,"Responsible Person","ResponsiblePerson",false },
  {0x0010,0x2298,VR::CS,VM::VM1,"Responsible Person Role","ResponsiblePersonRole",false },
  {0x0010,0x2299,VR::LO,VM::VM1,"Responsible Organization","ResponsibleOrganization",false },
  {0x0010,0x4000,VR::LT,VM::VM1,"Patient Comments","PatientComments",false },
  {0x0010,0x9431,VR::FL,VM::VM1,"Examined Body Thickness","ExaminedBodyThickness",false },
  {0x0012,0x0010,VR::LO,VM::VM1,"Clinical Trial Sponsor Name","ClinicalTrialSponsorName",false },
  {0x0012,0x0020,VR::LO,VM::VM1,"Clinical Trial Protocol ID","ClinicalTrialProtocolID",false },
  {0x0012,0x0021,VR::LO,VM::VM1,"Clinical Trial Protocol Name","ClinicalTrialProtocolName",false },
  {0x0012,0x0030,VR::LO,VM::VM1,"Clinical Trial Site ID","ClinicalTrialSiteID",false },
  {0x0012,0x0031,VR::LO,VM::VM1,"Clinical Trial Site Name","ClinicalTrialSiteName",false },
  {0x0012,0x0040,VR::LO,VM::VM1,"Clinical Trial Subject ID","ClinicalTrialSubjectID",false },
  {0x0012,0x0042,VR::LO,VM::VM1,"Clinical Trial Subject Reading ID","ClinicalTrialSubjectReadingID",false },
  {0x0012,0x0050,VR::LO,VM::VM1,"Clinical Trial Time Point ID","ClinicalTrialTimePointID",false },
  {0x0012,0x0051,VR::ST,VM::VM1,"Clinical Trial Time Point Description","ClinicalTrialTimePointDescription",false },
  {0x0012,0x0060,VR::LO,VM::VM1,"Clinical Trial Coordinating Center Name","ClinicalTrialCoordinatingCenterName",false },
  {0x0012,0x0062,VR::CS,VM::VM1,"Patient Identity Removed","PatientIdentityRemoved",false },
  {0x0012,0x0063,VR::LO,VM::VM1_n,"De-identification Method","DeidentificationMethod",false },
  {0x0012,0x0064,VR::SQ,VM::VM1,"De-identification Method Code Sequence","DeidentificationMethodCodeSequence",false },
  {0x0012,0x0071,VR::LO,VM::VM1,"Clinical Trial Series ID","ClinicalTrialSeriesID",false },
  {0x0012,0x0072,VR::LO,VM::VM1,"Clinical Trial Series Description","ClinicalTrialSeriesDescription",false },
  {0x0012,0x0081,VR::LO,VM::VM1,"Clinical Trial Protocol Ethics Committee Name","ClinicalTrialProtocolEthicsCommitteeName",false },
  {0x0012,0x0082,VR::LO,VM::VM1,"Clinical Trial Protocol Ethics Committee Approval Number","ClinicalTrialProtocolEthicsCommitteeApprovalNumber",false },
  {0x0012,0x0083,VR::SQ,VM::VM1,"Consent for Clinical Trial Use Sequence","ConsentForClinicalTrialUseSequence",false },
  {0x0012,0x0084,VR::CS,VM::VM1,"Distribution Type","DistributionType",false },
  {0x0012,0x0085,VR::CS,VM::VM1,"Consent for Distribution Flag","ConsentForDistributionFlag",false },
  {0x0014,0x0023,VR::ST,VM::VM1_n,"CAD File Format","CADFileFormat",false },
  {0x0014,0x0024,VR::ST,VM::VM1_n,"Component Reference System","ComponentReferenceSystem",false },
  {0x0014,0x0025,VR::ST,VM::VM1_n,"Component Manufacturing Procedure","ComponentManufacturingProcedure",false },
  {0x0014,0x0028,VR::ST,VM::VM1_n,"Component Manufacturer","ComponentManufacturer",false },
  {0x0014,0x0030,VR::DS,VM::VM1_n,"Material Thickness","MaterialThickness",false },
  {0x0014,0x0032,VR::DS,VM::VM1_n,"Material Pipe Diameter","MaterialPipeDiameter",false },
  {0x0014,0x0034,VR::DS,VM::VM1_n,"Material Isolation Diameter","MaterialIsolationDiameter",false },
  {0x0014,0x0042,VR::ST,VM::VM1_n,"Material Grade","MaterialGrade",false },
  {0x0014,0x0044,VR::ST,VM::VM1_n,"Material Properties File ID","MaterialPropertiesFileID",false },
  {0x0014,0x0045,VR::ST,VM::VM1_n,"Material Properties File Format","MaterialPropertiesFileFormat",false },
  {0x0014,0x0046,VR::LT,VM::VM1,"Material Notes","MaterialNotes",false },
  {0x0014,0x0050,VR::CS,VM::VM1,"Component Shape","ComponentShape",false },
  {0x0014,0x0052,VR::CS,VM::VM1,"Curvature Type","CurvatureType",false },
  {0x0014,0x0054,VR::DS,VM::VM1,"Outer Diameter","OuterDiameter",false },
  {0x0014,0x0056,VR::DS,VM::VM1,"Inner Diameter","InnerDiameter",false },
  {0x0014,0x1010,VR::ST,VM::VM1,"Actual Environmental Conditions","ActualEnvironmentalConditions",false },
  {0x0014,0x1020,VR::DA,VM::VM1,"Expiry Date","ExpiryDate",false },
  {0x0014,0x1040,VR::ST,VM::VM1,"Environmental Conditions","EnvironmentalConditions",false },
  {0x0014,0x2002,VR::SQ,VM::VM1,"Evaluator Sequence","EvaluatorSequence",false },
  {0x0014,0x2004,VR::IS,VM::VM1,"Evaluator Number","EvaluatorNumber",false },
  {0x0014,0x2006,VR::PN,VM::VM1,"Evaluator Name","EvaluatorName",false },
  {0x0014,0x2008,VR::IS,VM::VM1,"Evaluation Attempt","EvaluationAttempt",false },
  {0x0014,0x2012,VR::SQ,VM::VM1,"Indication Sequence","IndicationSequence",false },
  {0x0014,0x2014,VR::IS,VM::VM1,"Indication Number","IndicationNumber",false },
  {0x0014,0x2016,VR::SH,VM::VM1,"Indication Label","IndicationLabel",false },
  {0x0014,0x2018,VR::ST,VM::VM1,"Indication Description","IndicationDescription",false },
  {0x0014,0x201a,VR::CS,VM::VM1_n,"Indication Type","IndicationType",false },
  {0x0014,0x201c,VR::CS,VM::VM1,"Indication Disposition","IndicationDisposition",false },
  {0x0014,0x201e,VR::SQ,VM::VM1,"Indication ROI Sequence","IndicationROISequence",false },
  {0x0014,0x2030,VR::SQ,VM::VM1,"Indication Physical Property Sequence","IndicationPhysicalPropertySequence",false },
  {0x0014,0x2032,VR::SH,VM::VM1,"Property Label","PropertyLabel",false },
  {0x0014,0x2202,VR::IS,VM::VM1,"Coordinate System Number of Axes","CoordinateSystemNumberOfAxes",false },
  {0x0014,0x2204,VR::SQ,VM::VM1,"Coordinate System Axes Sequence","CoordinateSystemAxesSequence",false },
  {0x0014,0x2206,VR::ST,VM::VM1,"Coordinate System Axis Description","CoordinateSystemAxisDescription",false },
  {0x0014,0x2208,VR::CS,VM::VM1,"Coordinate System Data Set Mapping","CoordinateSystemDataSetMapping",false },
  {0x0014,0x220a,VR::IS,VM::VM1,"Coordinate System Axis Number","CoordinateSystemAxisNumber",false },
  {0x0014,0x220c,VR::CS,VM::VM1,"Coordinate System Axis Type","CoordinateSystemAxisType",false },
  {0x0014,0x220e,VR::CS,VM::VM1,"Coordinate System Axis Units","CoordinateSystemAxisUnits",false },
  {0x0014,0x2210,VR::OB,VM::VM1,"Coordinate System Axis Values","CoordinateSystemAxisValues",false },
  {0x0014,0x2220,VR::SQ,VM::VM1,"Coordinate System Transform Sequence","CoordinateSystemTransformSequence",false },
  {0x0014,0x2222,VR::ST,VM::VM1,"Transform Description","TransformDescription",false },
  {0x0014,0x2224,VR::IS,VM::VM1,"Transform Number of Axes","TransformNumberOfAxes",false },
  {0x0014,0x2226,VR::IS,VM::VM1_n,"Transform Order of Axes","TransformOrderOfAxes",false },
  {0x0014,0x2228,VR::CS,VM::VM1,"Transformed Axis Units","TransformedAxisUnits",false },
  {0x0014,0x222a,VR::DS,VM::VM1_n,"Coordinate System Transform Rotation and Scale Matrix","CoordinateSystemTransformRotationAndScaleMatrix",false },
  {0x0014,0x222c,VR::DS,VM::VM1_n,"Coordinate System Transform Translation Matrix","CoordinateSystemTransformTranslationMatrix",false },
  {0x0014,0x3011,VR::DS,VM::VM1,"Internal Detector Frame Time","InternalDetectorFrameTime",false },
  {0x0014,0x3012,VR::DS,VM::VM1,"Number of Frames Integrated","NumberOfFramesIntegrated",false },
  {0x0014,0x3020,VR::SQ,VM::VM1,"Detector Temperature Sequence","DetectorTemperatureSequence",false },
  {0x0014,0x3022,VR::ST,VM::VM1,"Sensor Name","SensorName",false },
  {0x0014,0x3024,VR::DS,VM::VM1,"Horizontal Offset of Sensor","HorizontalOffsetOfSensor",false },
  {0x0014,0x3026,VR::DS,VM::VM1,"Vertical Offset of Sensor","VerticalOffsetOfSensor",false },
  {0x0014,0x3028,VR::DS,VM::VM1,"Sensor Temperature","SensorTemperature",false },
  {0x0014,0x3040,VR::SQ,VM::VM1,"Dark Current Sequence","DarkCurrentSequence",false },
  {0x0014,0x3050,VR::OB_OW,VM::VM1,"Dark Current Counts","DarkCurrentCounts",false },
  {0x0014,0x3060,VR::SQ,VM::VM1,"Gain Correction Reference Sequence","GainCorrectionReferenceSequence",false },
  {0x0014,0x3070,VR::OB_OW,VM::VM1,"Air Counts","AirCounts",false },
  {0x0014,0x3071,VR::DS,VM::VM1,"KV Used in Gain Calibration","KVUsedInGainCalibration",false },
  {0x0014,0x3072,VR::DS,VM::VM1,"MA Used in Gain Calibration","MAUsedInGainCalibration",false },
  {0x0014,0x3073,VR::DS,VM::VM1,"Number of Frames Used for Integration","NumberOfFramesUsedForIntegration",false },
  {0x0014,0x3074,VR::LO,VM::VM1,"Filter Material Used in Gain Calibration","FilterMaterialUsedInGainCalibration",false },
  {0x0014,0x3075,VR::DS,VM::VM1,"Filter Thickness Used in Gain Calibration","FilterThicknessUsedInGainCalibration",false },
  {0x0014,0x3076,VR::DA,VM::VM1,"Date of Gain Calibration","DateOfGainCalibration",false },
  {0x0014,0x3077,VR::TM,VM::VM1,"Time of Gain Calibration","TimeOfGainCalibration",false },
  {0x0014,0x3080,VR::OB,VM::VM1,"Bad Pixel Image","BadPixelImage",false },
  {0x0014,0x3099,VR::LT,VM::VM1,"Calibration Notes","CalibrationNotes",false },
  {0x0014,0x4002,VR::SQ,VM::VM1,"Pulser Equipment Sequence","PulserEquipmentSequence",false },
  {0x0014,0x4004,VR::CS,VM::VM1,"Pulser Type","PulserType",false },
  {0x0014,0x4006,VR::LT,VM::VM1,"Pulser Notes","PulserNotes",false },
  {0x0014,0x4008,VR::SQ,VM::VM1,"Receiver Equipment Sequence","ReceiverEquipmentSequence",false },
  {0x0014,0x400a,VR::CS,VM::VM1,"Amplifier Type","AmplifierType",false },
  {0x0014,0x400c,VR::LT,VM::VM1,"Receiver Notes","ReceiverNotes",false },
  {0x0014,0x400e,VR::SQ,VM::VM1,"Pre-Amplifier Equipment Sequence","PreAmplifierEquipmentSequence",false },
  {0x0014,0x400f,VR::LT,VM::VM1,"Pre-Amplifier Notes","PreAmplifierNotes",false },
  {0x0014,0x4010,VR::SQ,VM::VM1,"Transmit Transducer Sequence","TransmitTransducerSequence",false },
  {0x0014,0x4011,VR::SQ,VM::VM1,"Receive Transducer Sequence","ReceiveTransducerSequence",false },
  {0x0014,0x4012,VR::US,VM::VM1,"Number of Elements","NumberOfElements",false },
  {0x0014,0x4013,VR::CS,VM::VM1,"Element Shape","ElementShape",false },
  {0x0014,0x4014,VR::DS,VM::VM1,"Element Dimension A","ElementDimensionA",false },
  {0x0014,0x4015,VR::DS,VM::VM1,"Element Dimension B","ElementDimensionB",false },
  {0x0014,0x4016,VR::DS,VM::VM1,"Element Pitch","ElementPitch",false },
  {0x0014,0x4017,VR::DS,VM::VM1,"Measured Beam Dimension A","MeasuredBeamDimensionA",false },
  {0x0014,0x4018,VR::DS,VM::VM1,"Measured Beam Dimension B","MeasuredBeamDimensionB",false },
  {0x0014,0x4019,VR::DS,VM::VM1,"Location of Measured Beam Diameter","LocationOfMeasuredBeamDiameter",false },
  {0x0014,0x401a,VR::DS,VM::VM1,"Nominal Frequency","NominalFrequency",false },
  {0x0014,0x401b,VR::DS,VM::VM1,"Measured Center Frequency","MeasuredCenterFrequency",false },
  {0x0014,0x401c,VR::DS,VM::VM1,"Measured Bandwidth","MeasuredBandwidth",false },
  {0x0014,0x4020,VR::SQ,VM::VM1,"Pulser Settings Sequence","PulserSettingsSequence",false },
  {0x0014,0x4022,VR::DS,VM::VM1,"Pulse Width","PulseWidth",false },
  {0x0014,0x4024,VR::DS,VM::VM1,"Excitation Frequency","ExcitationFrequency",false },
  {0x0014,0x4026,VR::CS,VM::VM1,"Modulation Type","ModulationType",false },
  {0x0014,0x4028,VR::DS,VM::VM1,"Damping","Damping",false },
  {0x0014,0x4030,VR::SQ,VM::VM1,"Receiver Settings Sequence","ReceiverSettingsSequence",false },
  {0x0014,0x4031,VR::DS,VM::VM1,"Acquired Soundpath Length","AcquiredSoundpathLength",false },
  {0x0014,0x4032,VR::CS,VM::VM1,"Acquisition Compression Type","AcquisitionCompressionType",false },
  {0x0014,0x4033,VR::IS,VM::VM1,"Acquisition Sample Size","AcquisitionSampleSize",false },
  {0x0014,0x4034,VR::DS,VM::VM1,"Rectifier Smoothing","RectifierSmoothing",false },
  {0x0014,0x4035,VR::SQ,VM::VM1,"DAC Sequence","DACSequence",false },
  {0x0014,0x4036,VR::CS,VM::VM1,"DAC Type","DACType",false },
  {0x0014,0x4038,VR::DS,VM::VM1_n,"DAC Gain Points","DACGainPoints",false },
  {0x0014,0x403a,VR::DS,VM::VM1_n,"DAC Time Points","DACTimePoints",false },
  {0x0014,0x403c,VR::DS,VM::VM1_n,"DAC Amplitude","DACAmplitude",false },
  {0x0014,0x4040,VR::SQ,VM::VM1,"Pre-Amplifier Settings Sequence","PreAmplifierSettingsSequence",false },
  {0x0014,0x4050,VR::SQ,VM::VM1,"Transmit Transducer Settings Sequence","TransmitTransducerSettingsSequence",false },
  {0x0014,0x4051,VR::SQ,VM::VM1,"Receive Transducer Settings Sequence","ReceiveTransducerSettingsSequence",false },
  {0x0014,0x4052,VR::DS,VM::VM1,"Incident Angle","IncidentAngle",false },
  {0x0014,0x4054,VR::ST,VM::VM1,"Coupling Technique","CouplingTechnique",false },
  {0x0014,0x4056,VR::ST,VM::VM1,"Coupling Medium","CouplingMedium",false },
  {0x0014,0x4057,VR::DS,VM::VM1,"Coupling Velocity","CouplingVelocity",false },
  {0x0014,0x4058,VR::DS,VM::VM1,"Crystal Center Location X","CrystalCenterLocationX",false },
  {0x0014,0x4059,VR::DS,VM::VM1,"Crystal Center Location Z","CrystalCenterLocationZ",false },
  {0x0014,0x405a,VR::DS,VM::VM1,"Sound Path Length","SoundPathLength",false },
  {0x0014,0x405c,VR::ST,VM::VM1,"Delay Law Identifier","DelayLawIdentifier",false },
  {0x0014,0x4060,VR::SQ,VM::VM1,"Gate Settings Sequence","GateSettingsSequence",false },
  {0x0014,0x4062,VR::DS,VM::VM1,"Gate Threshold","GateThreshold",false },
  {0x0014,0x4064,VR::DS,VM::VM1,"Velocity of Sound","VelocityOfSound",false },
  {0x0014,0x4070,VR::SQ,VM::VM1,"Calibration Settings Sequence","CalibrationSettingsSequence",false },
  {0x0014,0x4072,VR::ST,VM::VM1,"Calibration Procedure","CalibrationProcedure",false },
  {0x0014,0x4074,VR::SH,VM::VM1,"Procedure Version","ProcedureVersion",false },
  {0x0014,0x4076,VR::DA,VM::VM1,"Procedure Creation Date","ProcedureCreationDate",false },
  {0x0014,0x4078,VR::DA,VM::VM1,"Procedure Expiration Date","ProcedureExpirationDate",false },
  {0x0014,0x407a,VR::DA,VM::VM1,"Procedure Last Modified Date","ProcedureLastModifiedDate",false },
  {0x0014,0x407c,VR::TM,VM::VM1_n,"Calibration Time","CalibrationTime",false },
  {0x0014,0x407e,VR::DA,VM::VM1_n,"Calibration Date","CalibrationDate",false },
  {0x0014,0x5002,VR::IS,VM::VM1,"LINAC Energy","LINACEnergy",false },
  {0x0014,0x5004,VR::IS,VM::VM1,"LINAC Output","LINACOutput",false },
  {0x0018,0x0010,VR::LO,VM::VM1,"Contrast/Bolus Agent","ContrastBolusAgent",false },
  {0x0018,0x0012,VR::SQ,VM::VM1,"Contrast/Bolus Agent Sequence","ContrastBolusAgentSequence",false },
  {0x0018,0x0014,VR::SQ,VM::VM1,"Contrast/Bolus Administration Route Sequence","ContrastBolusAdministrationRouteSequence",false },
  {0x0018,0x0015,VR::CS,VM::VM1,"Body Part Examined","BodyPartExamined",false },
  {0x0018,0x0020,VR::CS,VM::VM1_n,"Scanning Sequence","ScanningSequence",false },
  {0x0018,0x0021,VR::CS,VM::VM1_n,"Sequence Variant","SequenceVariant",false },
  {0x0018,0x0022,VR::CS,VM::VM1_n,"Scan Options","ScanOptions",false },
  {0x0018,0x0023,VR::CS,VM::VM1,"MR Acquisition Type","MRAcquisitionType",false },
  {0x0018,0x0024,VR::SH,VM::VM1,"Sequence Name","SequenceName",false },
  {0x0018,0x0025,VR::CS,VM::VM1,"Angio Flag","AngioFlag",false },
  {0x0018,0x0026,VR::SQ,VM::VM1,"Intervention Drug Information Sequence","InterventionDrugInformationSequence",false },
  {0x0018,0x0027,VR::TM,VM::VM1,"Intervention Drug Stop Time","InterventionDrugStopTime",false },
  {0x0018,0x0028,VR::DS,VM::VM1,"Intervention Drug Dose","InterventionDrugDose",false },
  {0x0018,0x0029,VR::SQ,VM::VM1,"Intervention Drug Code Sequence","InterventionDrugCodeSequence",false },
  {0x0018,0x002a,VR::SQ,VM::VM1,"Additional Drug Sequence","AdditionalDrugSequence",false },
  {0x0018,0x0030,VR::LO,VM::VM1_n,"Radionuclide","Radionuclide",true },
  {0x0018,0x0031,VR::LO,VM::VM1,"Radiopharmaceutical","Radiopharmaceutical",false },
  {0x0018,0x0032,VR::DS,VM::VM1,"Energy Window Centerline","EnergyWindowCenterline",true },
  {0x0018,0x0033,VR::DS,VM::VM1_n,"Energy Window Total Width","EnergyWindowTotalWidth",true },
  {0x0018,0x0034,VR::LO,VM::VM1,"Intervention Drug Name","InterventionDrugName",false },
  {0x0018,0x0035,VR::TM,VM::VM1,"Intervention Drug Start Time","InterventionDrugStartTime",false },
  {0x0018,0x0036,VR::SQ,VM::VM1,"Intervention Sequence","InterventionSequence",false },
  {0x0018,0x0037,VR::CS,VM::VM1,"Therapy Type","TherapyType",true },
  {0x0018,0x0038,VR::CS,VM::VM1,"Intervention Status","InterventionStatus",false },
  {0x0018,0x0039,VR::CS,VM::VM1,"Therapy Description","TherapyDescription",true },
  {0x0018,0x003a,VR::ST,VM::VM1,"Intervention Description","InterventionDescription",false },
  {0x0018,0x0040,VR::IS,VM::VM1,"Cine Rate","CineRate",false },
  {0x0018,0x0042,VR::CS,VM::VM1,"Initial Cine Run State","InitialCineRunState",false },
  {0x0018,0x0050,VR::DS,VM::VM1,"Slice Thickness","SliceThickness",false },
  {0x0018,0x0060,VR::DS,VM::VM1,"KVP","KVP",false },
  {0x0018,0x0070,VR::IS,VM::VM1,"Counts Accumulated","CountsAccumulated",false },
  {0x0018,0x0071,VR::CS,VM::VM1,"Acquisition Termination Condition","AcquisitionTerminationCondition",false },
  {0x0018,0x0072,VR::DS,VM::VM1,"Effective Duration","EffectiveDuration",false },
  {0x0018,0x0073,VR::CS,VM::VM1,"Acquisition Start Condition","AcquisitionStartCondition",false },
  {0x0018,0x0074,VR::IS,VM::VM1,"Acquisition Start Condition Data","AcquisitionStartConditionData",false },
  {0x0018,0x0075,VR::IS,VM::VM1,"Acquisition Termination Condition Data","AcquisitionTerminationConditionData",false },
  {0x0018,0x0080,VR::DS,VM::VM1,"Repetition Time","RepetitionTime",false },
  {0x0018,0x0081,VR::DS,VM::VM1,"Echo Time","EchoTime",false },
  {0x0018,0x0082,VR::DS,VM::VM1,"Inversion Time","InversionTime",false },
  {0x0018,0x0083,VR::DS,VM::VM1,"Number of Averages","NumberOfAverages",false },
  {0x0018,0x0084,VR::DS,VM::VM1,"Imaging Frequency","ImagingFrequency",false },
  {0x0018,0x0085,VR::SH,VM::VM1,"Imaged Nucleus","ImagedNucleus",false },
  {0x0018,0x0086,VR::IS,VM::VM1_n,"Echo Number(s)","EchoNumbers",false },
  {0x0018,0x0087,VR::DS,VM::VM1,"Magnetic Field Strength","MagneticFieldStrength",false },
  {0x0018,0x0088,VR::DS,VM::VM1,"Spacing Between Slices","SpacingBetweenSlices",false },
  {0x0018,0x0089,VR::IS,VM::VM1,"Number of Phase Encoding Steps","NumberOfPhaseEncodingSteps",false },
  {0x0018,0x0090,VR::DS,VM::VM1,"Data Collection Diameter","DataCollectionDiameter",false },
  {0x0018,0x0091,VR::IS,VM::VM1,"Echo Train Length","EchoTrainLength",false },
  {0x0018,0x0093,VR::DS,VM::VM1,"Percent Sampling","PercentSampling",false },
  {0x0018,0x0094,VR::DS,VM::VM1,"Percent Phase Field of View","PercentPhaseFieldOfView",false },
  {0x0018,0x0095,VR::DS,VM::VM1,"Pixel Bandwidth","PixelBandwidth",false },
  {0x0018,0x1000,VR::LO,VM::VM1,"Device Serial Number","DeviceSerialNumber",false },
  {0x0018,0x1002,VR::UI,VM::VM1,"Device UID","DeviceUID",false },
  {0x0018,0x1003,VR::LO,VM::VM1,"Device ID","DeviceID",false },
  {0x0018,0x1004,VR::LO,VM::VM1,"Plate ID","PlateID",false },
  {0x0018,0x1005,VR::LO,VM::VM1,"Generator ID","GeneratorID",false },
  {0x0018,0x1006,VR::LO,VM::VM1,"Grid ID","GridID",false },
  {0x0018,0x1007,VR::LO,VM::VM1,"Cassette ID","CassetteID",false },
  {0x0018,0x1008,VR::LO,VM::VM1,"Gantry ID","GantryID",false },
  {0x0018,0x1010,VR::LO,VM::VM1,"Secondary Capture Device ID","SecondaryCaptureDeviceID",false },
  {0x0018,0x1011,VR::LO,VM::VM1,"Hardcopy Creation Device ID","HardcopyCreationDeviceID",true },
  {0x0018,0x1012,VR::DA,VM::VM1,"Date of Secondary Capture","DateOfSecondaryCapture",false },
  {0x0018,0x1014,VR::TM,VM::VM1,"Time of Secondary Capture","TimeOfSecondaryCapture",false },
  {0x0018,0x1016,VR::LO,VM::VM1,"Secondary Capture Device Manufacturer","SecondaryCaptureDeviceManufacturer",false },
  {0x0018,0x1017,VR::LO,VM::VM1,"Hardcopy Device Manufacturer","HardcopyDeviceManufacturer",true },
  {0x0018,0x1018,VR::LO,VM::VM1,"Secondary Capture Device Manufacturer's Model Name","SecondaryCaptureDeviceManufacturerModelName",false },
  {0x0018,0x1019,VR::LO,VM::VM1_n,"Secondary Capture Device Software Versions","SecondaryCaptureDeviceSoftwareVersions",false },
  {0x0018,0x101a,VR::LO,VM::VM1_n,"Hardcopy Device Software Version","HardcopyDeviceSoftwareVersion",true },
  {0x0018,0x101b,VR::LO,VM::VM1,"Hardcopy Device Manufacturer's Model Name","HardcopyDeviceManufacturerModelName",true },
  {0x0018,0x1020,VR::LO,VM::VM1_n,"Software Version(s)","SoftwareVersions",false },
  {0x0018,0x1022,VR::SH,VM::VM1,"Video Image Format Acquired","VideoImageFormatAcquired",false },
  {0x0018,0x1023,VR::LO,VM::VM1,"Digital Image Format Acquired","DigitalImageFormatAcquired",false },
  {0x0018,0x1030,VR::LO,VM::VM1,"Protocol Name","ProtocolName",false },
  {0x0018,0x1040,VR::LO,VM::VM1,"Contrast/Bolus Route","ContrastBolusRoute",false },
  {0x0018,0x1041,VR::DS,VM::VM1,"Contrast/Bolus Volume","ContrastBolusVolume",false },
  {0x0018,0x1042,VR::TM,VM::VM1,"Contrast/Bolus Start Time","ContrastBolusStartTime",false },
  {0x0018,0x1043,VR::TM,VM::VM1,"Contrast/Bolus Stop Time","ContrastBolusStopTime",false },
  {0x0018,0x1044,VR::DS,VM::VM1,"Contrast/Bolus Total Dose","ContrastBolusTotalDose",false },
  {0x0018,0x1045,VR::IS,VM::VM1,"Syringe Counts","SyringeCounts",false },
  {0x0018,0x1046,VR::DS,VM::VM1_n,"Contrast Flow Rate","ContrastFlowRate",false },
  {0x0018,0x1047,VR::DS,VM::VM1_n,"Contrast Flow Duration","ContrastFlowDuration",false },
  {0x0018,0x1048,VR::CS,VM::VM1,"Contrast/Bolus Ingredient","ContrastBolusIngredient",false },
  {0x0018,0x1049,VR::DS,VM::VM1,"Contrast/Bolus Ingredient Concentration","ContrastBolusIngredientConcentration",false },
  {0x0018,0x1050,VR::DS,VM::VM1,"Spatial Resolution","SpatialResolution",false },
  {0x0018,0x1060,VR::DS,VM::VM1,"Trigger Time","TriggerTime",false },
  {0x0018,0x1061,VR::LO,VM::VM1,"Trigger Source or Type","TriggerSourceOrType",false },
  {0x0018,0x1062,VR::IS,VM::VM1,"Nominal Interval","NominalInterval",false },
  {0x0018,0x1063,VR::DS,VM::VM1,"Frame Time","FrameTime",false },
  {0x0018,0x1064,VR::LO,VM::VM1,"Cardiac Framing Type","CardiacFramingType",false },
  {0x0018,0x1065,VR::DS,VM::VM1_n,"Frame Time Vector","FrameTimeVector",false },
  {0x0018,0x1066,VR::DS,VM::VM1,"Frame Delay","FrameDelay",false },
  {0x0018,0x1067,VR::DS,VM::VM1,"Image Trigger Delay","ImageTriggerDelay",false },
  {0x0018,0x1068,VR::DS,VM::VM1,"Multiplex Group Time Offset","MultiplexGroupTimeOffset",false },
  {0x0018,0x1069,VR::DS,VM::VM1,"Trigger Time Offset","TriggerTimeOffset",false },
  {0x0018,0x106a,VR::CS,VM::VM1,"Synchronization Trigger","SynchronizationTrigger",false },
  {0x0018,0x106c,VR::US,VM::VM2,"Synchronization Channel","SynchronizationChannel",false },
  {0x0018,0x106e,VR::UL,VM::VM1,"Trigger Sample Position","TriggerSamplePosition",false },
  {0x0018,0x1070,VR::LO,VM::VM1,"Radiopharmaceutical Route","RadiopharmaceuticalRoute",false },
  {0x0018,0x1071,VR::DS,VM::VM1,"Radiopharmaceutical Volume","RadiopharmaceuticalVolume",false },
  {0x0018,0x1072,VR::TM,VM::VM1,"Radiopharmaceutical Start Time","RadiopharmaceuticalStartTime",false },
  {0x0018,0x1073,VR::TM,VM::VM1,"Radiopharmaceutical Stop Time","RadiopharmaceuticalStopTime",false },
  {0x0018,0x1074,VR::DS,VM::VM1,"Radionuclide Total Dose","RadionuclideTotalDose",false },
  {0x0018,0x1075,VR::DS,VM::VM1,"Radionuclide Half Life","RadionuclideHalfLife",false },
  {0x0018,0x1076,VR::DS,VM::VM1,"Radionuclide Positron Fraction","RadionuclidePositronFraction",false },
  {0x0018,0x1077,VR::DS,VM::VM1,"Radiopharmaceutical Specific Activity","RadiopharmaceuticalSpecificActivity",false },
  {0x0018,0x1078,VR::DT,VM::VM1,"Radiopharmaceutical Start DateTime","RadiopharmaceuticalStartDateTime",false },
  {0x0018,0x1079,VR::DT,VM::VM1,"Radiopharmaceutical Stop DateTime","RadiopharmaceuticalStopDateTime",false },
  {0x0018,0x1080,VR::CS,VM::VM1,"Beat Rejection Flag","BeatRejectionFlag",false },
  {0x0018,0x1081,VR::IS,VM::VM1,"Low R-R Value","LowRRValue",false },
  {0x0018,0x1082,VR::IS,VM::VM1,"High R-R Value","HighRRValue",false },
  {0x0018,0x1083,VR::IS,VM::VM1,"Intervals Acquired","IntervalsAcquired",false },
  {0x0018,0x1084,VR::IS,VM::VM1,"Intervals Rejected","IntervalsRejected",false },
  {0x0018,0x1085,VR::LO,VM::VM1,"PVC Rejection","PVCRejection",false },
  {0x0018,0x1086,VR::IS,VM::VM1,"Skip Beats","SkipBeats",false },
  {0x0018,0x1088,VR::IS,VM::VM1,"Heart Rate","HeartRate",false },
  {0x0018,0x1090,VR::IS,VM::VM1,"Cardiac Number of Images","CardiacNumberOfImages",false },
  {0x0018,0x1094,VR::IS,VM::VM1,"Trigger Window","TriggerWindow",false },
  {0x0018,0x1100,VR::DS,VM::VM1,"Reconstruction Diameter","ReconstructionDiameter",false },
  {0x0018,0x1110,VR::DS,VM::VM1,"Distance Source to Detector","DistanceSourceToDetector",false },
  {0x0018,0x1111,VR::DS,VM::VM1,"Distance Source to Patient","DistanceSourceToPatient",false },
  {0x0018,0x1114,VR::DS,VM::VM1,"Estimated Radiographic Magnification Factor","EstimatedRadiographicMagnificationFactor",false },
  {0x0018,0x1120,VR::DS,VM::VM1,"Gantry/Detector Tilt","GantryDetectorTilt",false },
  {0x0018,0x1121,VR::DS,VM::VM1,"Gantry/Detector Slew","GantryDetectorSlew",false },
  {0x0018,0x1130,VR::DS,VM::VM1,"Table Height","TableHeight",false },
  {0x0018,0x1131,VR::DS,VM::VM1,"Table Traverse","TableTraverse",false },
  {0x0018,0x1134,VR::CS,VM::VM1,"Table Motion","TableMotion",false },
  {0x0018,0x1135,VR::DS,VM::VM1_n,"Table Vertical Increment","TableVerticalIncrement",false },
  {0x0018,0x1136,VR::DS,VM::VM1_n,"Table Lateral Increment","TableLateralIncrement",false },
  {0x0018,0x1137,VR::DS,VM::VM1_n,"Table Longitudinal Increment","TableLongitudinalIncrement",false },
  {0x0018,0x1138,VR::DS,VM::VM1,"Table Angle","TableAngle",false },
  {0x0018,0x113a,VR::CS,VM::VM1,"Table Type","TableType",false },
  {0x0018,0x1140,VR::CS,VM::VM1,"Rotation Direction","RotationDirection",false },
  {0x0018,0x1141,VR::DS,VM::VM1,"Angular Position","AngularPosition",true },
  {0x0018,0x1142,VR::DS,VM::VM1_n,"Radial Position","RadialPosition",false },
  {0x0018,0x1143,VR::DS,VM::VM1,"Scan Arc","ScanArc",false },
  {0x0018,0x1144,VR::DS,VM::VM1,"Angular Step","AngularStep",false },
  {0x0018,0x1145,VR::DS,VM::VM1,"Center of Rotation Offset","CenterOfRotationOffset",false },
  {0x0018,0x1146,VR::DS,VM::VM1_n,"Rotation Offset","RotationOffset",true },
  {0x0018,0x1147,VR::CS,VM::VM1,"Field of View Shape","FieldOfViewShape",false },
  {0x0018,0x1149,VR::IS,VM::VM1_2,"Field of View Dimension(s)","FieldOfViewDimensions",false },
  {0x0018,0x1150,VR::IS,VM::VM1,"Exposure Time","ExposureTime",false },
  {0x0018,0x1151,VR::IS,VM::VM1,"X-Ray Tube Current","XRayTubeCurrent",false },
  {0x0018,0x1152,VR::IS,VM::VM1,"Exposure","Exposure",false },
  {0x0018,0x1153,VR::IS,VM::VM1,"Exposure in µAs","ExposureInuAs",false },
  {0x0018,0x1154,VR::DS,VM::VM1,"Average Pulse Width","AveragePulseWidth",false },
  {0x0018,0x1155,VR::CS,VM::VM1,"Radiation Setting","RadiationSetting",false },
  {0x0018,0x1156,VR::CS,VM::VM1,"Rectification Type","RectificationType",false },
  {0x0018,0x115a,VR::CS,VM::VM1,"Radiation Mode","RadiationMode",false },
  {0x0018,0x115e,VR::DS,VM::VM1,"Image and Fluoroscopy Area Dose Product","ImageAndFluoroscopyAreaDoseProduct",false },
  {0x0018,0x1160,VR::SH,VM::VM1,"Filter Type","FilterType",false },
  {0x0018,0x1161,VR::LO,VM::VM1_n,"Type of Filters","TypeOfFilters",false },
  {0x0018,0x1162,VR::DS,VM::VM1,"Intensifier Size","IntensifierSize",false },
  {0x0018,0x1164,VR::DS,VM::VM2,"Imager Pixel Spacing","ImagerPixelSpacing",false },
  {0x0018,0x1166,VR::CS,VM::VM1_n,"Grid","Grid",false },
  {0x0018,0x1170,VR::IS,VM::VM1,"Generator Power","GeneratorPower",false },
  {0x0018,0x1180,VR::SH,VM::VM1,"Collimator/grid Name","CollimatorGridName",false },
  {0x0018,0x1181,VR::CS,VM::VM1,"Collimator Type","CollimatorType",false },
  {0x0018,0x1182,VR::IS,VM::VM1_2,"Focal Distance","FocalDistance",false },
  {0x0018,0x1183,VR::DS,VM::VM1_2,"X Focus Center","XFocusCenter",false },
  {0x0018,0x1184,VR::DS,VM::VM1_2,"Y Focus Center","YFocusCenter",false },
  {0x0018,0x1190,VR::DS,VM::VM1_n,"Focal Spot(s)","FocalSpots",false },
  {0x0018,0x1191,VR::CS,VM::VM1,"Anode Target Material","AnodeTargetMaterial",false },
  {0x0018,0x11a0,VR::DS,VM::VM1,"Body Part Thickness","BodyPartThickness",false },
  {0x0018,0x11a2,VR::DS,VM::VM1,"Compression Force","CompressionForce",false },
  {0x0018,0x11a4,VR::LO,VM::VM1,"Paddle Description","PaddleDescription",false },
  {0x0018,0x1200,VR::DA,VM::VM1_n,"Date of Last Calibration","DateOfLastCalibration",false },
  {0x0018,0x1201,VR::TM,VM::VM1_n,"Time of Last Calibration","TimeOfLastCalibration",false },
  {0x0018,0x1210,VR::SH,VM::VM1_n,"Convolution Kernel","ConvolutionKernel",false },
  {0x0018,0x1240,VR::IS,VM::VM1_n,"Upper/Lower Pixel Values","UpperLowerPixelValues",true },
  {0x0018,0x1242,VR::IS,VM::VM1,"Actual Frame Duration","ActualFrameDuration",false },
  {0x0018,0x1243,VR::IS,VM::VM1,"Count Rate","CountRate",false },
  {0x0018,0x1244,VR::US,VM::VM1,"Preferred Playback Sequencing","PreferredPlaybackSequencing",false },
  {0x0018,0x1250,VR::SH,VM::VM1,"Receive Coil Name","ReceiveCoilName",false },
  {0x0018,0x1251,VR::SH,VM::VM1,"Transmit Coil Name","TransmitCoilName",false },
  {0x0018,0x1260,VR::SH,VM::VM1,"Plate Type","PlateType",false },
  {0x0018,0x1261,VR::LO,VM::VM1,"Phosphor Type","PhosphorType",false },
  {0x0018,0x1300,VR::DS,VM::VM1,"Scan Velocity","ScanVelocity",false },
  {0x0018,0x1301,VR::CS,VM::VM1_n,"Whole Body Technique","WholeBodyTechnique",false },
  {0x0018,0x1302,VR::IS,VM::VM1,"Scan Length","ScanLength",false },
  {0x0018,0x1310,VR::US,VM::VM4,"Acquisition Matrix","AcquisitionMatrix",false },
  {0x0018,0x1312,VR::CS,VM::VM1,"In-plane Phase Encoding Direction","InPlanePhaseEncodingDirection",false },
  {0x0018,0x1314,VR::DS,VM::VM1,"Flip Angle","FlipAngle",false },
  {0x0018,0x1315,VR::CS,VM::VM1,"Variable Flip Angle Flag","VariableFlipAngleFlag",false },
  {0x0018,0x1316,VR::DS,VM::VM1,"SAR","SAR",false },
  {0x0018,0x1318,VR::DS,VM::VM1,"dB/dt","dBdt",false },
  {0x0018,0x1400,VR::LO,VM::VM1,"Acquisition Device Processing Description","AcquisitionDeviceProcessingDescription",false },
  {0x0018,0x1401,VR::LO,VM::VM1,"Acquisition Device Processing Code","AcquisitionDeviceProcessingCode",false },
  {0x0018,0x1402,VR::CS,VM::VM1,"Cassette Orientation","CassetteOrientation",false },
  {0x0018,0x1403,VR::CS,VM::VM1,"Cassette Size","CassetteSize",false },
  {0x0018,0x1404,VR::US,VM::VM1,"Exposures on Plate","ExposuresOnPlate",false },
  {0x0018,0x1405,VR::IS,VM::VM1,"Relative X-Ray Exposure","RelativeXRayExposure",false },
  {0x0018,0x1411,VR::DS,VM::VM1,"Exposure Index","ExposureIndex",false },
  {0x0018,0x1412,VR::DS,VM::VM1,"Target Exposure Index","TargetExposureIndex",false },
  {0x0018,0x1413,VR::DS,VM::VM1,"Deviation Index","DeviationIndex",false },
  {0x0018,0x1450,VR::DS,VM::VM1,"Column Angulation","ColumnAngulation",false },
  {0x0018,0x1460,VR::DS,VM::VM1,"Tomo Layer Height","TomoLayerHeight",false },
  {0x0018,0x1470,VR::DS,VM::VM1,"Tomo Angle","TomoAngle",false },
  {0x0018,0x1480,VR::DS,VM::VM1,"Tomo Time","TomoTime",false },
  {0x0018,0x1490,VR::CS,VM::VM1,"Tomo Type","TomoType",false },
  {0x0018,0x1491,VR::CS,VM::VM1,"Tomo Class","TomoClass",false },
  {0x0018,0x1495,VR::IS,VM::VM1,"Number of Tomosynthesis Source Images","NumberOfTomosynthesisSourceImages",false },
  {0x0018,0x1500,VR::CS,VM::VM1,"Positioner Motion","PositionerMotion",false },
  {0x0018,0x1508,VR::CS,VM::VM1,"Positioner Type","PositionerType",false },
  {0x0018,0x1510,VR::DS,VM::VM1,"Positioner Primary Angle","PositionerPrimaryAngle",false },
  {0x0018,0x1511,VR::DS,VM::VM1,"Positioner Secondary Angle","PositionerSecondaryAngle",false },
  {0x0018,0x1520,VR::DS,VM::VM1_n,"Positioner Primary Angle Increment","PositionerPrimaryAngleIncrement",false },
  {0x0018,0x1521,VR::DS,VM::VM1_n,"Positioner Secondary Angle Increment","PositionerSecondaryAngleIncrement",false },
  {0x0018,0x1530,VR::DS,VM::VM1,"Detector Primary Angle","DetectorPrimaryAngle",false },
  {0x0018,0x1531,VR::DS,VM::VM1,"Detector Secondary Angle","DetectorSecondaryAngle",false },
  {0x0018,0x1600,VR::CS,VM::VM1_3,"Shutter Shape","ShutterShape",false },
  {0x0018,0x1602,VR::IS,VM::VM1,"Shutter Left Vertical Edge","ShutterLeftVerticalEdge",false },
  {0x0018,0x1604,VR::IS,VM::VM1,"Shutter Right Vertical Edge","ShutterRightVerticalEdge",false },
  {0x0018,0x1606,VR::IS,VM::VM1,"Shutter Upper Horizontal Edge","ShutterUpperHorizontalEdge",false },
  {0x0018,0x1608,VR::IS,VM::VM1,"Shutter Lower Horizontal Edge","ShutterLowerHorizontalEdge",false },
  {0x0018,0x1610,VR::IS,VM::VM2,"Center of Circular Shutter","CenterOfCircularShutter",false },
  {0x0018,0x1612,VR::IS,VM::VM1,"Radius of Circular Shutter","RadiusOfCircularShutter",false },
  {0x0018,0x1620,VR::IS,VM::VM2_2n,"Vertices of the Polygonal Shutter","VerticesOfThePolygonalShutter",false },
  {0x0018,0x1622,VR::US,VM::VM1,"Shutter Presentation Value","ShutterPresentationValue",false },
  {0x0018,0x1623,VR::US,VM::VM1,"Shutter Overlay Group","ShutterOverlayGroup",false },
  {0x0018,0x1624,VR::US,VM::VM3,"Shutter Presentation Color CIELab Value","ShutterPresentationColorCIELabValue",false },
  {0x0018,0x1700,VR::CS,VM::VM1_3,"Collimator Shape","CollimatorShape",false },
  {0x0018,0x1702,VR::IS,VM::VM1,"Collimator Left Vertical Edge","CollimatorLeftVerticalEdge",false },
  {0x0018,0x1704,VR::IS,VM::VM1,"Collimator Right Vertical Edge","CollimatorRightVerticalEdge",false },
  {0x0018,0x1706,VR::IS,VM::VM1,"Collimator Upper Horizontal Edge","CollimatorUpperHorizontalEdge",false },
  {0x0018,0x1708,VR::IS,VM::VM1,"Collimator Lower Horizontal Edge","CollimatorLowerHorizontalEdge",false },
  {0x0018,0x1710,VR::IS,VM::VM2,"Center of Circular Collimator","CenterOfCircularCollimator",false },
  {0x0018,0x1712,VR::IS,VM::VM1,"Radius of Circular Collimator","RadiusOfCircularCollimator",false },
  {0x0018,0x1720,VR::IS,VM::VM2_2n,"Vertices of the Polygonal Collimator","VerticesOfThePolygonalCollimator",false },
  {0x0018,0x1800,VR::CS,VM::VM1,"Acquisition Time Synchronized","AcquisitionTimeSynchronized",false },
  {0x0018,0x1801,VR::SH,VM::VM1,"Time Source","TimeSource",false },
  {0x0018,0x1802,VR::CS,VM::VM1,"Time Distribution Protocol","TimeDistributionProtocol",false },
  {0x0018,0x1803,VR::LO,VM::VM1,"NTP Source Address","NTPSourceAddress",false },
  {0x0018,0x2001,VR::IS,VM::VM1_n,"Page Number Vector","PageNumberVector",false },
  {0x0018,0x2002,VR::SH,VM::VM1_n,"Frame Label Vector","FrameLabelVector",false },
  {0x0018,0x2003,VR::DS,VM::VM1_n,"Frame Primary Angle Vector","FramePrimaryAngleVector",false },
  {0x0018,0x2004,VR::DS,VM::VM1_n,"Frame Secondary Angle Vector","FrameSecondaryAngleVector",false },
  {0x0018,0x2005,VR::DS,VM::VM1_n,"Slice Location Vector","SliceLocationVector",false },
  {0x0018,0x2006,VR::SH,VM::VM1_n,"Display Window Label Vector","DisplayWindowLabelVector",false },
  {0x0018,0x2010,VR::DS,VM::VM2,"Nominal Scanned Pixel Spacing","NominalScannedPixelSpacing",false },
  {0x0018,0x2020,VR::CS,VM::VM1,"Digitizing Device Transport Direction","DigitizingDeviceTransportDirection",false },
  {0x0018,0x2030,VR::DS,VM::VM1,"Rotation of Scanned Film","RotationOfScannedFilm",false },
  {0x0018,0x3100,VR::CS,VM::VM1,"IVUS Acquisition","IVUSAcquisition",false },
  {0x0018,0x3101,VR::DS,VM::VM1,"IVUS Pullback Rate","IVUSPullbackRate",false },
  {0x0018,0x3102,VR::DS,VM::VM1,"IVUS Gated Rate","IVUSGatedRate",false },
  {0x0018,0x3103,VR::IS,VM::VM1,"IVUS Pullback Start Frame Number","IVUSPullbackStartFrameNumber",false },
  {0x0018,0x3104,VR::IS,VM::VM1,"IVUS Pullback Stop Frame Number","IVUSPullbackStopFrameNumber",false },
  {0x0018,0x3105,VR::IS,VM::VM1_n,"Lesion Number","LesionNumber",false },
  {0x0018,0x4000,VR::LT,VM::VM1,"Acquisition Comments","AcquisitionComments",true },
  {0x0018,0x5000,VR::SH,VM::VM1_n,"Output Power","OutputPower",false },
  {0x0018,0x5010,VR::LO,VM::VM1_n,"Transducer Data","TransducerData",false },
  {0x0018,0x5012,VR::DS,VM::VM1,"Focus Depth","FocusDepth",false },
  {0x0018,0x5020,VR::LO,VM::VM1,"Processing Function","ProcessingFunction",false },
  {0x0018,0x5021,VR::LO,VM::VM1,"Postprocessing Function","PostprocessingFunction",true },
  {0x0018,0x5022,VR::DS,VM::VM1,"Mechanical Index","MechanicalIndex",false },
  {0x0018,0x5024,VR::DS,VM::VM1,"Bone Thermal Index","BoneThermalIndex",false },
  {0x0018,0x5026,VR::DS,VM::VM1,"Cranial Thermal Index","CranialThermalIndex",false },
  {0x0018,0x5027,VR::DS,VM::VM1,"Soft Tissue Thermal Index","SoftTissueThermalIndex",false },
  {0x0018,0x5028,VR::DS,VM::VM1,"Soft Tissue-focus Thermal Index","SoftTissueFocusThermalIndex",false },
  {0x0018,0x5029,VR::DS,VM::VM1,"Soft Tissue-surface Thermal Index","SoftTissueSurfaceThermalIndex",false },
  {0x0018,0x5030,VR::DS,VM::VM1,"Dynamic Range","DynamicRange",true },
  {0x0018,0x5040,VR::DS,VM::VM1,"Total Gain","TotalGain",true },
  {0x0018,0x5050,VR::IS,VM::VM1,"Depth of Scan Field","DepthOfScanField",false },
  {0x0018,0x5100,VR::CS,VM::VM1,"Patient Position","PatientPosition",false },
  {0x0018,0x5101,VR::CS,VM::VM1,"View Position","ViewPosition",false },
  {0x0018,0x5104,VR::SQ,VM::VM1,"Projection Eponymous Name Code Sequence","ProjectionEponymousNameCodeSequence",false },
  {0x0018,0x5210,VR::DS,VM::VM6,"Image Transformation Matrix","ImageTransformationMatrix",true },
  {0x0018,0x5212,VR::DS,VM::VM3,"Image Translation Vector","ImageTranslationVector",true },
  {0x0018,0x6000,VR::DS,VM::VM1,"Sensitivity","Sensitivity",false },
  {0x0018,0x6011,VR::SQ,VM::VM1,"Sequence of Ultrasound Regions","SequenceOfUltrasoundRegions",false },
  {0x0018,0x6012,VR::US,VM::VM1,"Region Spatial Format","RegionSpatialFormat",false },
  {0x0018,0x6014,VR::US,VM::VM1,"Region Data Type","RegionDataType",false },
  {0x0018,0x6016,VR::UL,VM::VM1,"Region Flags","RegionFlags",false },
  {0x0018,0x6018,VR::UL,VM::VM1,"Region Location Min X0","RegionLocationMinX0",false },
  {0x0018,0x601a,VR::UL,VM::VM1,"Region Location Min Y0","RegionLocationMinY0",false },
  {0x0018,0x601c,VR::UL,VM::VM1,"Region Location Max X1","RegionLocationMaxX1",false },
  {0x0018,0x601e,VR::UL,VM::VM1,"Region Location Max Y1","RegionLocationMaxY1",false },
  {0x0018,0x6020,VR::SL,VM::VM1,"Reference Pixel X0","ReferencePixelX0",false },
  {0x0018,0x6022,VR::SL,VM::VM1,"Reference Pixel Y0","ReferencePixelY0",false },
  {0x0018,0x6024,VR::US,VM::VM1,"Physical Units X Direction","PhysicalUnitsXDirection",false },
  {0x0018,0x6026,VR::US,VM::VM1,"Physical Units Y Direction","PhysicalUnitsYDirection",false },
  {0x0018,0x6028,VR::FD,VM::VM1,"Reference Pixel Physical Value X","ReferencePixelPhysicalValueX",false },
  {0x0018,0x602a,VR::FD,VM::VM1,"Reference Pixel Physical Value Y","ReferencePixelPhysicalValueY",false },
  {0x0018,0x602c,VR::FD,VM::VM1,"Physical Delta X","PhysicalDeltaX",false },
  {0x0018,0x602e,VR::FD,VM::VM1,"Physical Delta Y","PhysicalDeltaY",false },
  {0x0018,0x6030,VR::UL,VM::VM1,"Transducer Frequency","TransducerFrequency",false },
  {0x0018,0x6031,VR::CS,VM::VM1,"Transducer Type","TransducerType",false },
  {0x0018,0x6032,VR::UL,VM::VM1,"Pulse Repetition Frequency","PulseRepetitionFrequency",false },
  {0x0018,0x6034,VR::FD,VM::VM1,"Doppler Correction Angle","DopplerCorrectionAngle",false },
  {0x0018,0x6036,VR::FD,VM::VM1,"Steering Angle","SteeringAngle",false },
  {0x0018,0x6038,VR::UL,VM::VM1,"Doppler Sample Volume X Position (Retired)","DopplerSampleVolumeXPositionRetired",true },
  {0x0018,0x6039,VR::SL,VM::VM1,"Doppler Sample Volume X Position","DopplerSampleVolumeXPosition",false },
  {0x0018,0x603a,VR::UL,VM::VM1,"Doppler Sample Volume Y Position (Retired)","DopplerSampleVolumeYPositionRetired",true },
  {0x0018,0x603b,VR::SL,VM::VM1,"Doppler Sample Volume Y Position","DopplerSampleVolumeYPosition",false },
  {0x0018,0x603c,VR::UL,VM::VM1,"TM-Line Position X0 (Retired)","TMLinePositionX0Retired",true },
  {0x0018,0x603d,VR::SL,VM::VM1,"TM-Line Position X0","TMLinePositionX0",false },
  {0x0018,0x603e,VR::UL,VM::VM1,"TM-Line Position Y0 (Retired)","TMLinePositionY0Retired",true },
  {0x0018,0x603f,VR::SL,VM::VM1,"TM-Line Position Y0","TMLinePositionY0",false },
  {0x0018,0x6040,VR::UL,VM::VM1,"TM-Line Position X1 (Retired)","TMLinePositionX1Retired",true },
  {0x0018,0x6041,VR::SL,VM::VM1,"TM-Line Position X1","TMLinePositionX1",false },
  {0x0018,0x6042,VR::UL,VM::VM1,"TM-Line Position Y1 (Retired)","TMLinePositionY1Retired",true },
  {0x0018,0x6043,VR::SL,VM::VM1,"TM-Line Position Y1","TMLinePositionY1",false },
  {0x0018,0x6044,VR::US,VM::VM1,"Pixel Component Organization","PixelComponentOrganization",false },
  {0x0018,0x6046,VR::UL,VM::VM1,"Pixel Component Mask","PixelComponentMask",false },
  {0x0018,0x6048,VR::UL,VM::VM1,"Pixel Component Range Start","PixelComponentRangeStart",false },
  {0x0018,0x604a,VR::UL,VM::VM1,"Pixel Component Range Stop","PixelComponentRangeStop",false },
  {0x0018,0x604c,VR::US,VM::VM1,"Pixel Component Physical Units","PixelComponentPhysicalUnits",false },
  {0x0018,0x604e,VR::US,VM::VM1,"Pixel Component Data Type","PixelComponentDataType",false },
  {0x0018,0x6050,VR::UL,VM::VM1,"Number of Table Break Points","NumberOfTableBreakPoints",false },
  {0x0018,0x6052,VR::UL,VM::VM1_n,"Table of X Break Points","TableOfXBreakPoints",false },
  {0x0018,0x6054,VR::FD,VM::VM1_n,"Table of Y Break Points","TableOfYBreakPoints",false },
  {0x0018,0x6056,VR::UL,VM::VM1,"Number of Table Entries","NumberOfTableEntries",false },
  {0x0018,0x6058,VR::UL,VM::VM1_n,"Table of Pixel Values","TableOfPixelValues",false },
  {0x0018,0x605a,VR::FL,VM::VM1_n,"Table of Parameter Values","TableOfParameterValues",false },
  {0x0018,0x6060,VR::FL,VM::VM1_n,"R Wave Time Vector","RWaveTimeVector",false },
  {0x0018,0x7000,VR::CS,VM::VM1,"Detector Conditions Nominal Flag","DetectorConditionsNominalFlag",false },
  {0x0018,0x7001,VR::DS,VM::VM1,"Detector Temperature","DetectorTemperature",false },
  {0x0018,0x7004,VR::CS,VM::VM1,"Detector Type","DetectorType",false },
  {0x0018,0x7005,VR::CS,VM::VM1,"Detector Configuration","DetectorConfiguration",false },
  {0x0018,0x7006,VR::LT,VM::VM1,"Detector Description","DetectorDescription",false },
  {0x0018,0x7008,VR::LT,VM::VM1,"Detector Mode","DetectorMode",false },
  {0x0018,0x700a,VR::SH,VM::VM1,"Detector ID","DetectorID",false },
  {0x0018,0x700c,VR::DA,VM::VM1,"Date of Last Detector Calibration","DateOfLastDetectorCalibration",false },
  {0x0018,0x700e,VR::TM,VM::VM1,"Time of Last Detector Calibration","TimeOfLastDetectorCalibration",false },
  {0x0018,0x7010,VR::IS,VM::VM1,"Exposures on Detector Since Last Calibration","ExposuresOnDetectorSinceLastCalibration",false },
  {0x0018,0x7011,VR::IS,VM::VM1,"Exposures on Detector Since Manufactured","ExposuresOnDetectorSinceManufactured",false },
  {0x0018,0x7012,VR::DS,VM::VM1,"Detector Time Since Last Exposure","DetectorTimeSinceLastExposure",false },
  {0x0018,0x7014,VR::DS,VM::VM1,"Detector Active Time","DetectorActiveTime",false },
  {0x0018,0x7016,VR::DS,VM::VM1,"Detector Activation Offset From Exposure","DetectorActivationOffsetFromExposure",false },
  {0x0018,0x701a,VR::DS,VM::VM2,"Detector Binning","DetectorBinning",false },
  {0x0018,0x7020,VR::DS,VM::VM2,"Detector Element Physical Size","DetectorElementPhysicalSize",false },
  {0x0018,0x7022,VR::DS,VM::VM2,"Detector Element Spacing","DetectorElementSpacing",false },
  {0x0018,0x7024,VR::CS,VM::VM1,"Detector Active Shape","DetectorActiveShape",false },
  {0x0018,0x7026,VR::DS,VM::VM1_2,"Detector Active Dimension(s)","DetectorActiveDimensions",false },
  {0x0018,0x7028,VR::DS,VM::VM2,"Detector Active Origin","DetectorActiveOrigin",false },
  {0x0018,0x702a,VR::LO,VM::VM1,"Detector Manufacturer Name","DetectorManufacturerName",false },
  {0x0018,0x702b,VR::LO,VM::VM1,"Detector Manufacturer's Model Name","DetectorManufacturerModelName",false },
  {0x0018,0x7030,VR::DS,VM::VM2,"Field of View Origin","FieldOfViewOrigin",false },
  {0x0018,0x7032,VR::DS,VM::VM1,"Field of View Rotation","FieldOfViewRotation",false },
  {0x0018,0x7034,VR::CS,VM::VM1,"Field of View Horizontal Flip","FieldOfViewHorizontalFlip",false },
  {0x0018,0x7036,VR::FL,VM::VM2,"Pixel Data Area Origin Relative To FOV","PixelDataAreaOriginRelativeToFOV",false },
  {0x0018,0x7038,VR::FL,VM::VM1,"Pixel Data Area Rotation Angle Relative To FOV","PixelDataAreaRotationAngleRelativeToFOV",false },
  {0x0018,0x7040,VR::LT,VM::VM1,"Grid Absorbing Material","GridAbsorbingMaterial",false },
  {0x0018,0x7041,VR::LT,VM::VM1,"Grid Spacing Material","GridSpacingMaterial",false },
  {0x0018,0x7042,VR::DS,VM::VM1,"Grid Thickness","GridThickness",false },
  {0x0018,0x7044,VR::DS,VM::VM1,"Grid Pitch","GridPitch",false },
  {0x0018,0x7046,VR::IS,VM::VM2,"Grid Aspect Ratio","GridAspectRatio",false },
  {0x0018,0x7048,VR::DS,VM::VM1,"Grid Period","GridPeriod",false },
  {0x0018,0x704c,VR::DS,VM::VM1,"Grid Focal Distance","GridFocalDistance",false },
  {0x0018,0x7050,VR::CS,VM::VM1_n,"Filter Material","FilterMaterial",false },
  {0x0018,0x7052,VR::DS,VM::VM1_n,"Filter Thickness Minimum","FilterThicknessMinimum",false },
  {0x0018,0x7054,VR::DS,VM::VM1_n,"Filter Thickness Maximum","FilterThicknessMaximum",false },
  {0x0018,0x7056,VR::FL,VM::VM1_n,"Filter Beam Path Length Minimum","FilterBeamPathLengthMinimum",false },
  {0x0018,0x7058,VR::FL,VM::VM1_n,"Filter Beam Path Length Maximum","FilterBeamPathLengthMaximum",false },
  {0x0018,0x7060,VR::CS,VM::VM1,"Exposure Control Mode","ExposureControlMode",false },
  {0x0018,0x7062,VR::LT,VM::VM1,"Exposure Control Mode Description","ExposureControlModeDescription",false },
  {0x0018,0x7064,VR::CS,VM::VM1,"Exposure Status","ExposureStatus",false },
  {0x0018,0x7065,VR::DS,VM::VM1,"Phototimer Setting","PhototimerSetting",false },
  {0x0018,0x8150,VR::DS,VM::VM1,"Exposure Time in µS","ExposureTimeInuS",false },
  {0x0018,0x8151,VR::DS,VM::VM1,"X-Ray Tube Current in µA","XRayTubeCurrentInuA",false },
  {0x0018,0x9004,VR::CS,VM::VM1,"Content Qualification","ContentQualification",false },
  {0x0018,0x9005,VR::SH,VM::VM1,"Pulse Sequence Name","PulseSequenceName",false },
  {0x0018,0x9006,VR::SQ,VM::VM1,"MR Imaging Modifier Sequence","MRImagingModifierSequence",false },
  {0x0018,0x9008,VR::CS,VM::VM1,"Echo Pulse Sequence","EchoPulseSequence",false },
  {0x0018,0x9009,VR::CS,VM::VM1,"Inversion Recovery","InversionRecovery",false },
  {0x0018,0x9010,VR::CS,VM::VM1,"Flow Compensation","FlowCompensation",false },
  {0x0018,0x9011,VR::CS,VM::VM1,"Multiple Spin Echo","MultipleSpinEcho",false },
  {0x0018,0x9012,VR::CS,VM::VM1,"Multi-planar Excitation","MultiPlanarExcitation",false },
  {0x0018,0x9014,VR::CS,VM::VM1,"Phase Contrast","PhaseContrast",false },
  {0x0018,0x9015,VR::CS,VM::VM1,"Time of Flight Contrast","TimeOfFlightContrast",false },
  {0x0018,0x9016,VR::CS,VM::VM1,"Spoiling","Spoiling",false },
  {0x0018,0x9017,VR::CS,VM::VM1,"Steady State Pulse Sequence","SteadyStatePulseSequence",false },
  {0x0018,0x9018,VR::CS,VM::VM1,"Echo Planar Pulse Sequence","EchoPlanarPulseSequence",false },
  {0x0018,0x9019,VR::FD,VM::VM1,"Tag Angle First Axis","TagAngleFirstAxis",false },
  {0x0018,0x9020,VR::CS,VM::VM1,"Magnetization Transfer","MagnetizationTransfer",false },
  {0x0018,0x9021,VR::CS,VM::VM1,"T2 Preparation","T2Preparation",false },
  {0x0018,0x9022,VR::CS,VM::VM1,"Blood Signal Nulling","BloodSignalNulling",false },
  {0x0018,0x9024,VR::CS,VM::VM1,"Saturation Recovery","SaturationRecovery",false },
  {0x0018,0x9025,VR::CS,VM::VM1,"Spectrally Selected Suppression","SpectrallySelectedSuppression",false },
  {0x0018,0x9026,VR::CS,VM::VM1,"Spectrally Selected Excitation","SpectrallySelectedExcitation",false },
  {0x0018,0x9027,VR::CS,VM::VM1,"Spatial Pre-saturation","SpatialPresaturation",false },
  {0x0018,0x9028,VR::CS,VM::VM1,"Tagging","Tagging",false },
  {0x0018,0x9029,VR::CS,VM::VM1,"Oversampling Phase","OversamplingPhase",false },
  {0x0018,0x9030,VR::FD,VM::VM1,"Tag Spacing First Dimension","TagSpacingFirstDimension",false },
  {0x0018,0x9032,VR::CS,VM::VM1,"Geometry of k-Space Traversal","GeometryOfKSpaceTraversal",false },
  {0x0018,0x9033,VR::CS,VM::VM1,"Segmented k-Space Traversal","SegmentedKSpaceTraversal",false },
  {0x0018,0x9034,VR::CS,VM::VM1,"Rectilinear Phase Encode Reordering","RectilinearPhaseEncodeReordering",false },
  {0x0018,0x9035,VR::FD,VM::VM1,"Tag Thickness","TagThickness",false },
  {0x0018,0x9036,VR::CS,VM::VM1,"Partial Fourier Direction","PartialFourierDirection",false },
  {0x0018,0x9037,VR::CS,VM::VM1,"Cardiac Synchronization Technique","CardiacSynchronizationTechnique",false },
  {0x0018,0x9041,VR::LO,VM::VM1,"Receive Coil Manufacturer Name","ReceiveCoilManufacturerName",false },
  {0x0018,0x9042,VR::SQ,VM::VM1,"MR Receive Coil Sequence","MRReceiveCoilSequence",false },
  {0x0018,0x9043,VR::CS,VM::VM1,"Receive Coil Type","ReceiveCoilType",false },
  {0x0018,0x9044,VR::CS,VM::VM1,"Quadrature Receive Coil","QuadratureReceiveCoil",false },
  {0x0018,0x9045,VR::SQ,VM::VM1,"Multi-Coil Definition Sequence","MultiCoilDefinitionSequence",false },
  {0x0018,0x9046,VR::LO,VM::VM1,"Multi-Coil Configuration","MultiCoilConfiguration",false },
  {0x0018,0x9047,VR::SH,VM::VM1,"Multi-Coil Element Name","MultiCoilElementName",false },
  {0x0018,0x9048,VR::CS,VM::VM1,"Multi-Coil Element Used","MultiCoilElementUsed",false },
  {0x0018,0x9049,VR::SQ,VM::VM1,"MR Transmit Coil Sequence","MRTransmitCoilSequence",false },
  {0x0018,0x9050,VR::LO,VM::VM1,"Transmit Coil Manufacturer Name","TransmitCoilManufacturerName",false },
  {0x0018,0x9051,VR::CS,VM::VM1,"Transmit Coil Type","TransmitCoilType",false },
  {0x0018,0x9052,VR::FD,VM::VM1_2,"Spectral Width","SpectralWidth",false },
  {0x0018,0x9053,VR::FD,VM::VM1_2,"Chemical Shift Reference","ChemicalShiftReference",false },
  {0x0018,0x9054,VR::CS,VM::VM1,"Volume Localization Technique","VolumeLocalizationTechnique",false },
  {0x0018,0x9058,VR::US,VM::VM1,"MR Acquisition Frequency Encoding Steps","MRAcquisitionFrequencyEncodingSteps",false },
  {0x0018,0x9059,VR::CS,VM::VM1,"De-coupling","Decoupling",false },
  {0x0018,0x9060,VR::CS,VM::VM1_2,"De-coupled Nucleus","DecoupledNucleus",false },
  {0x0018,0x9061,VR::FD,VM::VM1_2,"De-coupling Frequency","DecouplingFrequency",false },
  {0x0018,0x9062,VR::CS,VM::VM1,"De-coupling Method","DecouplingMethod",false },
  {0x0018,0x9063,VR::FD,VM::VM1_2,"De-coupling Chemical Shift Reference","DecouplingChemicalShiftReference",false },
  {0x0018,0x9064,VR::CS,VM::VM1,"k-space Filtering","KSpaceFiltering",false },
  {0x0018,0x9065,VR::CS,VM::VM1_2,"Time Domain Filtering","TimeDomainFiltering",false },
  {0x0018,0x9066,VR::US,VM::VM1_2,"Number of Zero Fills","NumberOfZeroFills",false },
  {0x0018,0x9067,VR::CS,VM::VM1,"Baseline Correction","BaselineCorrection",false },
  {0x0018,0x9069,VR::FD,VM::VM1,"Parallel Reduction Factor In-plane","ParallelReductionFactorInPlane",false },
  {0x0018,0x9070,VR::FD,VM::VM1,"Cardiac R-R Interval Specified","CardiacRRIntervalSpecified",false },
  {0x0018,0x9073,VR::FD,VM::VM1,"Acquisition Duration","AcquisitionDuration",false },
  {0x0018,0x9074,VR::DT,VM::VM1,"Frame Acquisition DateTime","FrameAcquisitionDateTime",false },
  {0x0018,0x9075,VR::CS,VM::VM1,"Diffusion Directionality","DiffusionDirectionality",false },
  {0x0018,0x9076,VR::SQ,VM::VM1,"Diffusion Gradient Direction Sequence","DiffusionGradientDirectionSequence",false },
  {0x0018,0x9077,VR::CS,VM::VM1,"Parallel Acquisition","ParallelAcquisition",false },
  {0x0018,0x9078,VR::CS,VM::VM1,"Parallel Acquisition Technique","ParallelAcquisitionTechnique",false },
  {0x0018,0x9079,VR::FD,VM::VM1_n,"Inversion Times","InversionTimes",false },
  {0x0018,0x9080,VR::ST,VM::VM1,"Metabolite Map Description","MetaboliteMapDescription",false },
  {0x0018,0x9081,VR::CS,VM::VM1,"Partial Fourier","PartialFourier",false },
  {0x0018,0x9082,VR::FD,VM::VM1,"Effective Echo Time","EffectiveEchoTime",false },
  {0x0018,0x9083,VR::SQ,VM::VM1,"Metabolite Map Code Sequence","MetaboliteMapCodeSequence",false },
  {0x0018,0x9084,VR::SQ,VM::VM1,"Chemical Shift Sequence","ChemicalShiftSequence",false },
  {0x0018,0x9085,VR::CS,VM::VM1,"Cardiac Signal Source","CardiacSignalSource",false },
  {0x0018,0x9087,VR::FD,VM::VM1,"Diffusion b-value","DiffusionBValue",false },
  {0x0018,0x9089,VR::FD,VM::VM3,"Diffusion Gradient Orientation","DiffusionGradientOrientation",false },
  {0x0018,0x9090,VR::FD,VM::VM3,"Velocity Encoding Direction","VelocityEncodingDirection",false },
  {0x0018,0x9091,VR::FD,VM::VM1,"Velocity Encoding Minimum Value","VelocityEncodingMinimumValue",false },
  {0x0018,0x9092,VR::SQ,VM::VM1,"Velocity Encoding Acquisition Sequence","VelocityEncodingAcquisitionSequence",false },
  {0x0018,0x9093,VR::US,VM::VM1,"Number of k-Space Trajectories","NumberOfKSpaceTrajectories",false },
  {0x0018,0x9094,VR::CS,VM::VM1,"Coverage of k-Space","CoverageOfKSpace",false },
  {0x0018,0x9095,VR::UL,VM::VM1,"Spectroscopy Acquisition Phase Rows","SpectroscopyAcquisitionPhaseRows",false },
  {0x0018,0x9096,VR::FD,VM::VM1,"Parallel Reduction Factor In-plane (Retired)","ParallelReductionFactorInPlaneRetired",true },
  {0x0018,0x9098,VR::FD,VM::VM1_2,"Transmitter Frequency","TransmitterFrequency",false },
  {0x0018,0x9100,VR::CS,VM::VM1_2,"Resonant Nucleus","ResonantNucleus",false },
  {0x0018,0x9101,VR::CS,VM::VM1,"Frequency Correction","FrequencyCorrection",false },
  {0x0018,0x9103,VR::SQ,VM::VM1,"MR Spectroscopy FOV/Geometry Sequence","MRSpectroscopyFOVGeometrySequence",false },
  {0x0018,0x9104,VR::FD,VM::VM1,"Slab Thickness","SlabThickness",false },
  {0x0018,0x9105,VR::FD,VM::VM3,"Slab Orientation","SlabOrientation",false },
  {0x0018,0x9106,VR::FD,VM::VM3,"Mid Slab Position","MidSlabPosition",false },
  {0x0018,0x9107,VR::SQ,VM::VM1,"MR Spatial Saturation Sequence","MRSpatialSaturationSequence",false },
  {0x0018,0x9112,VR::SQ,VM::VM1,"MR Timing and Related Parameters Sequence","MRTimingAndRelatedParametersSequence",false },
  {0x0018,0x9114,VR::SQ,VM::VM1,"MR Echo Sequence","MREchoSequence",false },
  {0x0018,0x9115,VR::SQ,VM::VM1,"MR Modifier Sequence","MRModifierSequence",false },
  {0x0018,0x9117,VR::SQ,VM::VM1,"MR Diffusion Sequence","MRDiffusionSequence",false },
  {0x0018,0x9118,VR::SQ,VM::VM1,"Cardiac Synchronization Sequence","CardiacSynchronizationSequence",false },
  {0x0018,0x9119,VR::SQ,VM::VM1,"MR Averages Sequence","MRAveragesSequence",false },
  {0x0018,0x9125,VR::SQ,VM::VM1,"MR FOV/Geometry Sequence","MRFOVGeometrySequence",false },
  {0x0018,0x9126,VR::SQ,VM::VM1,"Volume Localization Sequence","VolumeLocalizationSequence",false },
  {0x0018,0x9127,VR::UL,VM::VM1,"Spectroscopy Acquisition Data Columns","SpectroscopyAcquisitionDataColumns",false },
  {0x0018,0x9147,VR::CS,VM::VM1,"Diffusion Anisotropy Type","DiffusionAnisotropyType",false },
  {0x0018,0x9151,VR::DT,VM::VM1,"Frame Reference DateTime","FrameReferenceDateTime",false },
  {0x0018,0x9152,VR::SQ,VM::VM1,"MR Metabolite Map Sequence","MRMetaboliteMapSequence",false },
  {0x0018,0x9155,VR::FD,VM::VM1,"Parallel Reduction Factor out-of-plane","ParallelReductionFactorOutOfPlane",false },
  {0x0018,0x9159,VR::UL,VM::VM1,"Spectroscopy Acquisition Out-of-plane Phase Steps","SpectroscopyAcquisitionOutOfPlanePhaseSteps",false },
  {0x0018,0x9166,VR::CS,VM::VM1,"Bulk Motion Status","BulkMotionStatus",true },
  {0x0018,0x9168,VR::FD,VM::VM1,"Parallel Reduction Factor Second In-plane","ParallelReductionFactorSecondInPlane",false },
  {0x0018,0x9169,VR::CS,VM::VM1,"Cardiac Beat Rejection Technique","CardiacBeatRejectionTechnique",false },
  {0x0018,0x9170,VR::CS,VM::VM1,"Respiratory Motion Compensation Technique","RespiratoryMotionCompensationTechnique",false },
  {0x0018,0x9171,VR::CS,VM::VM1,"Respiratory Signal Source","RespiratorySignalSource",false },
  {0x0018,0x9172,VR::CS,VM::VM1,"Bulk Motion Compensation Technique","BulkMotionCompensationTechnique",false },
  {0x0018,0x9173,VR::CS,VM::VM1,"Bulk Motion Signal Source","BulkMotionSignalSource",false },
  {0x0018,0x9174,VR::CS,VM::VM1,"Applicable Safety Standard Agency","ApplicableSafetyStandardAgency",false },
  {0x0018,0x9175,VR::LO,VM::VM1,"Applicable Safety Standard Description","ApplicableSafetyStandardDescription",false },
  {0x0018,0x9176,VR::SQ,VM::VM1,"Operating Mode Sequence","OperatingModeSequence",false },
  {0x0018,0x9177,VR::CS,VM::VM1,"Operating Mode Type","OperatingModeType",false },
  {0x0018,0x9178,VR::CS,VM::VM1,"Operating Mode","OperatingMode",false },
  {0x0018,0x9179,VR::CS,VM::VM1,"Specific Absorption Rate Definition","SpecificAbsorptionRateDefinition",false },
  {0x0018,0x9180,VR::CS,VM::VM1,"Gradient Output Type","GradientOutputType",false },
  {0x0018,0x9181,VR::FD,VM::VM1,"Specific Absorption Rate Value","SpecificAbsorptionRateValue",false },
  {0x0018,0x9182,VR::FD,VM::VM1,"Gradient Output","GradientOutput",false },
  {0x0018,0x9183,VR::CS,VM::VM1,"Flow Compensation Direction","FlowCompensationDirection",false },
  {0x0018,0x9184,VR::FD,VM::VM1,"Tagging Delay","TaggingDelay",false },
  {0x0018,0x9185,VR::ST,VM::VM1,"Respiratory Motion Compensation Technique Description","RespiratoryMotionCompensationTechniqueDescription",false },
  {0x0018,0x9186,VR::SH,VM::VM1,"Respiratory Signal Source ID","RespiratorySignalSourceID",false },
  {0x0018,0x9195,VR::FD,VM::VM1,"Chemical Shift Minimum Integration Limit in Hz","ChemicalShiftMinimumIntegrationLimitInHz",true },
  {0x0018,0x9196,VR::FD,VM::VM1,"Chemical Shift Maximum Integration Limit in Hz","ChemicalShiftMaximumIntegrationLimitInHz",true },
  {0x0018,0x9197,VR::SQ,VM::VM1,"MR Velocity Encoding Sequence","MRVelocityEncodingSequence",false },
  {0x0018,0x9198,VR::CS,VM::VM1,"First Order Phase Correction","FirstOrderPhaseCorrection",false },
  {0x0018,0x9199,VR::CS,VM::VM1,"Water Referenced Phase Correction","WaterReferencedPhaseCorrection",false },
  {0x0018,0x9200,VR::CS,VM::VM1,"MR Spectroscopy Acquisition Type","MRSpectroscopyAcquisitionType",false },
  {0x0018,0x9214,VR::CS,VM::VM1,"Respiratory Cycle Position","RespiratoryCyclePosition",false },
  {0x0018,0x9217,VR::FD,VM::VM1,"Velocity Encoding Maximum Value","VelocityEncodingMaximumValue",false },
  {0x0018,0x9218,VR::FD,VM::VM1,"Tag Spacing Second Dimension","TagSpacingSecondDimension",false },
  {0x0018,0x9219,VR::SS,VM::VM1,"Tag Angle Second Axis","TagAngleSecondAxis",false },
  {0x0018,0x9220,VR::FD,VM::VM1,"Frame Acquisition Duration","FrameAcquisitionDuration",false },
  {0x0018,0x9226,VR::SQ,VM::VM1,"MR Image Frame Type Sequence","MRImageFrameTypeSequence",false },
  {0x0018,0x9227,VR::SQ,VM::VM1,"MR Spectroscopy Frame Type Sequence","MRSpectroscopyFrameTypeSequence",false },
  {0x0018,0x9231,VR::US,VM::VM1,"MR Acquisition Phase Encoding Steps in-plane","MRAcquisitionPhaseEncodingStepsInPlane",false },
  {0x0018,0x9232,VR::US,VM::VM1,"MR Acquisition Phase Encoding Steps out-of-plane","MRAcquisitionPhaseEncodingStepsOutOfPlane",false },
  {0x0018,0x9234,VR::UL,VM::VM1,"Spectroscopy Acquisition Phase Columns","SpectroscopyAcquisitionPhaseColumns",false },
  {0x0018,0x9236,VR::CS,VM::VM1,"Cardiac Cycle Position","CardiacCyclePosition",false },
  {0x0018,0x9239,VR::SQ,VM::VM1,"Specific Absorption Rate Sequence","SpecificAbsorptionRateSequence",false },
  {0x0018,0x9240,VR::US,VM::VM1,"RF Echo Train Length","RFEchoTrainLength",false },
  {0x0018,0x9241,VR::US,VM::VM1,"Gradient Echo Train Length","GradientEchoTrainLength",false },
  {0x0018,0x9250,VR::CS,VM::VM1,"Arterial Spin Labeling Contrast","ArterialSpinLabelingContrast",false },
  {0x0018,0x9251,VR::SQ,VM::VM1,"MR Arterial Spin Labeling Sequence","MRArterialSpinLabelingSequence",false },
  {0x0018,0x9252,VR::LO,VM::VM1,"ASL Technique Description","ASLTechniqueDescription",false },
  {0x0018,0x9253,VR::US,VM::VM1,"ASL Slab Number","ASLSlabNumber",false },
  {0x0018,0x9254,VR::FD,VM::VM1,"ASL Slab Thickness","ASLSlabThickness",false },
  {0x0018,0x9255,VR::FD,VM::VM3,"ASL Slab Orientation","ASLSlabOrientation",false },
  {0x0018,0x9256,VR::FD,VM::VM3,"ASL Mid Slab Position","ASLMidSlabPosition",false },
  {0x0018,0x9257,VR::CS,VM::VM1,"ASL Context","ASLContext",false },
  {0x0018,0x9258,VR::UL,VM::VM1,"ASL Pulse Train Duration","ASLPulseTrainDuration",false },
  {0x0018,0x9259,VR::CS,VM::VM1,"ASL Crusher Flag","ASLCrusherFlag",false },
  {0x0018,0x925a,VR::FD,VM::VM1,"ASL Crusher Flow","ASLCrusherFlow",false },
  {0x0018,0x925b,VR::LO,VM::VM1,"ASL Crusher Description","ASLCrusherDescription",false },
  {0x0018,0x925c,VR::CS,VM::VM1,"ASL Bolus Cut-off Flag","ASLBolusCutoffFlag",false },
  {0x0018,0x925d,VR::SQ,VM::VM1,"ASL Bolus Cut-off Timing Sequence","ASLBolusCutoffTimingSequence",false },
  {0x0018,0x925e,VR::LO,VM::VM1,"ASL Bolus Cut-off Technique","ASLBolusCutoffTechnique",false },
  {0x0018,0x925f,VR::UL,VM::VM1,"ASL Bolus Cut-off Delay Time","ASLBolusCutoffDelayTime",false },
  {0x0018,0x9260,VR::SQ,VM::VM1,"ASL Slab Sequence","ASLSlabSequence",false },
  {0x0018,0x9295,VR::FD,VM::VM1,"Chemical Shift Minimum Integration Limit in ppm","ChemicalShiftMinimumIntegrationLimitInppm",false },
  {0x0018,0x9296,VR::FD,VM::VM1,"Chemical Shift Maximum Integration Limit in ppm","ChemicalShiftMaximumIntegrationLimitInppm",false },
  {0x0018,0x9301,VR::SQ,VM::VM1,"CT Acquisition Type Sequence","CTAcquisitionTypeSequence",false },
  {0x0018,0x9302,VR::CS,VM::VM1,"Acquisition Type","AcquisitionType",false },
  {0x0018,0x9303,VR::FD,VM::VM1,"Tube Angle","TubeAngle",false },
  {0x0018,0x9304,VR::SQ,VM::VM1,"CT Acquisition Details Sequence","CTAcquisitionDetailsSequence",false },
  {0x0018,0x9305,VR::FD,VM::VM1,"Revolution Time","RevolutionTime",false },
  {0x0018,0x9306,VR::FD,VM::VM1,"Single Collimation Width","SingleCollimationWidth",false },
  {0x0018,0x9307,VR::FD,VM::VM1,"Total Collimation Width","TotalCollimationWidth",false },
  {0x0018,0x9308,VR::SQ,VM::VM1,"CT Table Dynamics Sequence","CTTableDynamicsSequence",false },
  {0x0018,0x9309,VR::FD,VM::VM1,"Table Speed","TableSpeed",false },
  {0x0018,0x9310,VR::FD,VM::VM1,"Table Feed per Rotation","TableFeedPerRotation",false },
  {0x0018,0x9311,VR::FD,VM::VM1,"Spiral Pitch Factor","SpiralPitchFactor",false },
  {0x0018,0x9312,VR::SQ,VM::VM1,"CT Geometry Sequence","CTGeometrySequence",false },
  {0x0018,0x9313,VR::FD,VM::VM3,"Data Collection Center (Patient)","DataCollectionCenterPatient",false },
  {0x0018,0x9314,VR::SQ,VM::VM1,"CT Reconstruction Sequence","CTReconstructionSequence",false },
  {0x0018,0x9315,VR::CS,VM::VM1,"Reconstruction Algorithm","ReconstructionAlgorithm",false },
  {0x0018,0x9316,VR::CS,VM::VM1,"Convolution Kernel Group","ConvolutionKernelGroup",false },
  {0x0018,0x9317,VR::FD,VM::VM2,"Reconstruction Field of View","ReconstructionFieldOfView",false },
  {0x0018,0x9318,VR::FD,VM::VM3,"Reconstruction Target Center (Patient)","ReconstructionTargetCenterPatient",false },
  {0x0018,0x9319,VR::FD,VM::VM1,"Reconstruction Angle","ReconstructionAngle",false },
  {0x0018,0x9320,VR::SH,VM::VM1,"Image Filter","ImageFilter",false },
  {0x0018,0x9321,VR::SQ,VM::VM1,"CT Exposure Sequence","CTExposureSequence",false },
  {0x0018,0x9322,VR::FD,VM::VM2,"Reconstruction Pixel Spacing","ReconstructionPixelSpacing",false },
  {0x0018,0x9323,VR::CS,VM::VM1,"Exposure Modulation Type","ExposureModulationType",false },
  {0x0018,0x9324,VR::FD,VM::VM1,"Estimated Dose Saving","EstimatedDoseSaving",false },
  {0x0018,0x9325,VR::SQ,VM::VM1,"CT X-Ray Details Sequence","CTXRayDetailsSequence",false },
  {0x0018,0x9326,VR::SQ,VM::VM1,"CT Position Sequence","CTPositionSequence",false },
  {0x0018,0x9327,VR::FD,VM::VM1,"Table Position","TablePosition",false },
  {0x0018,0x9328,VR::FD,VM::VM1,"Exposure Time in ms","ExposureTimeInms",false },
  {0x0018,0x9329,VR::SQ,VM::VM1,"CT Image Frame Type Sequence","CTImageFrameTypeSequence",false },
  {0x0018,0x9330,VR::FD,VM::VM1,"X-Ray Tube Current in mA","XRayTubeCurrentInmA",false },
  {0x0018,0x9332,VR::FD,VM::VM1,"Exposure in mAs","ExposureInmAs",false },
  {0x0018,0x9333,VR::CS,VM::VM1,"Constant Volume Flag","ConstantVolumeFlag",false },
  {0x0018,0x9334,VR::CS,VM::VM1,"Fluoroscopy Flag","FluoroscopyFlag",false },
  {0x0018,0x9335,VR::FD,VM::VM1,"Distance Source to Data Collection Center","DistanceSourceToDataCollectionCenter",false },
  {0x0018,0x9337,VR::US,VM::VM1,"Contrast/Bolus Agent Number","ContrastBolusAgentNumber",false },
  {0x0018,0x9338,VR::SQ,VM::VM1,"Contrast/Bolus Ingredient Code Sequence","ContrastBolusIngredientCodeSequence",false },
  {0x0018,0x9340,VR::SQ,VM::VM1,"Contrast Administration Profile Sequence","ContrastAdministrationProfileSequence",false },
  {0x0018,0x9341,VR::SQ,VM::VM1,"Contrast/Bolus Usage Sequence","ContrastBolusUsageSequence",false },
  {0x0018,0x9342,VR::CS,VM::VM1,"Contrast/Bolus Agent Administered","ContrastBolusAgentAdministered",false },
  {0x0018,0x9343,VR::CS,VM::VM1,"Contrast/Bolus Agent Detected","ContrastBolusAgentDetected",false },
  {0x0018,0x9344,VR::CS,VM::VM1,"Contrast/Bolus Agent Phase","ContrastBolusAgentPhase",false },
  {0x0018,0x9345,VR::FD,VM::VM1,"CTDIvol","CTDIvol",false },
  {0x0018,0x9346,VR::SQ,VM::VM1,"CTDI Phantom Type Code Sequence","CTDIPhantomTypeCodeSequence",false },
  {0x0018,0x9351,VR::FL,VM::VM1,"Calcium Scoring Mass Factor Patient","CalciumScoringMassFactorPatient",false },
  {0x0018,0x9352,VR::FL,VM::VM3,"Calcium Scoring Mass Factor Device","CalciumScoringMassFactorDevice",false },
  {0x0018,0x9353,VR::FL,VM::VM1,"Energy Weighting Factor","EnergyWeightingFactor",false },
  {0x0018,0x9360,VR::SQ,VM::VM1,"CT Additional X-Ray Source Sequence","CTAdditionalXRaySourceSequence",false },
  {0x0018,0x9401,VR::SQ,VM::VM1,"Projection Pixel Calibration Sequence","ProjectionPixelCalibrationSequence",false },
  {0x0018,0x9402,VR::FL,VM::VM1,"Distance Source to Isocenter","DistanceSourceToIsocenter",false },
  {0x0018,0x9403,VR::FL,VM::VM1,"Distance Object to Table Top","DistanceObjectToTableTop",false },
  {0x0018,0x9404,VR::FL,VM::VM2,"Object Pixel Spacing in Center of Beam","ObjectPixelSpacingInCenterOfBeam",false },
  {0x0018,0x9405,VR::SQ,VM::VM1,"Positioner Position Sequence","PositionerPositionSequence",false },
  {0x0018,0x9406,VR::SQ,VM::VM1,"Table Position Sequence","TablePositionSequence",false },
  {0x0018,0x9407,VR::SQ,VM::VM1,"Collimator Shape Sequence","CollimatorShapeSequence",false },
  {0x0018,0x9410,VR::CS,VM::VM1,"Planes in Acquisition","PlanesInAcquisition",false },
  {0x0018,0x9412,VR::SQ,VM::VM1,"XA/XRF Frame Characteristics Sequence","XAXRFFrameCharacteristicsSequence",false },
  {0x0018,0x9417,VR::SQ,VM::VM1,"Frame Acquisition Sequence","FrameAcquisitionSequence",false },
  {0x0018,0x9420,VR::CS,VM::VM1,"X-Ray Receptor Type","XRayReceptorType",false },
  {0x0018,0x9423,VR::LO,VM::VM1,"Acquisition Protocol Name","AcquisitionProtocolName",false },
  {0x0018,0x9424,VR::LT,VM::VM1,"Acquisition Protocol Description","AcquisitionProtocolDescription",false },
  {0x0018,0x9425,VR::CS,VM::VM1,"Contrast/Bolus Ingredient Opaque","ContrastBolusIngredientOpaque",false },
  {0x0018,0x9426,VR::FL,VM::VM1,"Distance Receptor Plane to Detector Housing","DistanceReceptorPlaneToDetectorHousing",false },
  {0x0018,0x9427,VR::CS,VM::VM1,"Intensifier Active Shape","IntensifierActiveShape",false },
  {0x0018,0x9428,VR::FL,VM::VM1_2,"Intensifier Active Dimension(s)","IntensifierActiveDimensions",false },
  {0x0018,0x9429,VR::FL,VM::VM2,"Physical Detector Size","PhysicalDetectorSize",false },
  {0x0018,0x9430,VR::FL,VM::VM2,"Position of Isocenter Projection","PositionOfIsocenterProjection",false },
  {0x0018,0x9432,VR::SQ,VM::VM1,"Field of View Sequence","FieldOfViewSequence",false },
  {0x0018,0x9433,VR::LO,VM::VM1,"Field of View Description","FieldOfViewDescription",false },
  {0x0018,0x9434,VR::SQ,VM::VM1,"Exposure Control Sensing Regions Sequence","ExposureControlSensingRegionsSequence",false },
  {0x0018,0x9435,VR::CS,VM::VM1,"Exposure Control Sensing Region Shape","ExposureControlSensingRegionShape",false },
  {0x0018,0x9436,VR::SS,VM::VM1,"Exposure Control Sensing Region Left Vertical Edge","ExposureControlSensingRegionLeftVerticalEdge",false },
  {0x0018,0x9437,VR::SS,VM::VM1,"Exposure Control Sensing Region Right Vertical Edge","ExposureControlSensingRegionRightVerticalEdge",false },
  {0x0018,0x9438,VR::SS,VM::VM1,"Exposure Control Sensing Region Upper Horizontal Edge","ExposureControlSensingRegionUpperHorizontalEdge",false },
  {0x0018,0x9439,VR::SS,VM::VM1,"Exposure Control Sensing Region Lower Horizontal Edge","ExposureControlSensingRegionLowerHorizontalEdge",false },
  {0x0018,0x9440,VR::SS,VM::VM2,"Center of Circular Exposure Control Sensing Region","CenterOfCircularExposureControlSensingRegion",false },
  {0x0018,0x9441,VR::US,VM::VM1,"Radius of Circular Exposure Control Sensing Region","RadiusOfCircularExposureControlSensingRegion",false },
  {0x0018,0x9442,VR::SS,VM::VM2_n,"Vertices of the Polygonal Exposure Control Sensing Region","VerticesOfThePolygonalExposureControlSensingRegion",false },
  {0x0018,0x9445,VR::INVALID,VM::VM0,"","",true },
  {0x0018,0x9447,VR::FL,VM::VM1,"Column Angulation (Patient)","ColumnAngulationPatient",false },
  {0x0018,0x9449,VR::FL,VM::VM1,"Beam Angle","BeamAngle",false },
  {0x0018,0x9451,VR::SQ,VM::VM1,"Frame Detector Parameters Sequence","FrameDetectorParametersSequence",false },
  {0x0018,0x9452,VR::FL,VM::VM1,"Calculated Anatomy Thickness","CalculatedAnatomyThickness",false },
  {0x0018,0x9455,VR::SQ,VM::VM1,"Calibration Sequence","CalibrationSequence",false },
  {0x0018,0x9456,VR::SQ,VM::VM1,"Object Thickness Sequence","ObjectThicknessSequence",false },
  {0x0018,0x9457,VR::CS,VM::VM1,"Plane Identification","PlaneIdentification",false },
  {0x0018,0x9461,VR::FL,VM::VM1_2,"Field of View Dimension(s) in Float","FieldOfViewDimensionsInFloat",false },
  {0x0018,0x9462,VR::SQ,VM::VM1,"Isocenter Reference System Sequence","IsocenterReferenceSystemSequence",false },
  {0x0018,0x9463,VR::FL,VM::VM1,"Positioner Isocenter Primary Angle","PositionerIsocenterPrimaryAngle",false },
  {0x0018,0x9464,VR::FL,VM::VM1,"Positioner Isocenter Secondary Angle","PositionerIsocenterSecondaryAngle",false },
  {0x0018,0x9465,VR::FL,VM::VM1,"Positioner Isocenter Detector Rotation Angle","PositionerIsocenterDetectorRotationAngle",false },
  {0x0018,0x9466,VR::FL,VM::VM1,"Table X Position to Isocenter","TableXPositionToIsocenter",false },
  {0x0018,0x9467,VR::FL,VM::VM1,"Table Y Position to Isocenter","TableYPositionToIsocenter",false },
  {0x0018,0x9468,VR::FL,VM::VM1,"Table Z Position to Isocenter","TableZPositionToIsocenter",false },
  {0x0018,0x9469,VR::FL,VM::VM1,"Table Horizontal Rotation Angle","TableHorizontalRotationAngle",false },
  {0x0018,0x9470,VR::FL,VM::VM1,"Table Head Tilt Angle","TableHeadTiltAngle",false },
  {0x0018,0x9471,VR::FL,VM::VM1,"Table Cradle Tilt Angle","TableCradleTiltAngle",false },
  {0x0018,0x9472,VR::SQ,VM::VM1,"Frame Display Shutter Sequence","FrameDisplayShutterSequence",false },
  {0x0018,0x9473,VR::FL,VM::VM1,"Acquired Image Area Dose Product","AcquiredImageAreaDoseProduct",false },
  {0x0018,0x9474,VR::CS,VM::VM1,"C-arm Positioner Tabletop Relationship","CArmPositionerTabletopRelationship",false },
  {0x0018,0x9476,VR::SQ,VM::VM1,"X-Ray Geometry Sequence","XRayGeometrySequence",false },
  {0x0018,0x9477,VR::SQ,VM::VM1,"Irradiation Event Identification Sequence","IrradiationEventIdentificationSequence",false },
  {0x0018,0x9504,VR::SQ,VM::VM1,"X-Ray 3D Frame Type Sequence","XRay3DFrameTypeSequence",false },
  {0x0018,0x9506,VR::SQ,VM::VM1,"Contributing Sources Sequence","ContributingSourcesSequence",false },
  {0x0018,0x9507,VR::SQ,VM::VM1,"X-Ray 3D Acquisition Sequence","XRay3DAcquisitionSequence",false },
  {0x0018,0x9508,VR::FL,VM::VM1,"Primary Positioner Scan Arc","PrimaryPositionerScanArc",false },
  {0x0018,0x9509,VR::FL,VM::VM1,"Secondary Positioner Scan Arc","SecondaryPositionerScanArc",false },
  {0x0018,0x9510,VR::FL,VM::VM1,"Primary Positioner Scan Start Angle","PrimaryPositionerScanStartAngle",false },
  {0x0018,0x9511,VR::FL,VM::VM1,"Secondary Positioner Scan Start Angle","SecondaryPositionerScanStartAngle",false },
  {0x0018,0x9514,VR::FL,VM::VM1,"Primary Positioner Increment","PrimaryPositionerIncrement",false },
  {0x0018,0x9515,VR::FL,VM::VM1,"Secondary Positioner Increment","SecondaryPositionerIncrement",false },
  {0x0018,0x9516,VR::DT,VM::VM1,"Start Acquisition DateTime","StartAcquisitionDateTime",false },
  {0x0018,0x9517,VR::DT,VM::VM1,"End Acquisition DateTime","EndAcquisitionDateTime",false },
  {0x0018,0x9524,VR::LO,VM::VM1,"Application Name","ApplicationName",false },
  {0x0018,0x9525,VR::LO,VM::VM1,"Application Version","ApplicationVersion",false },
  {0x0018,0x9526,VR::LO,VM::VM1,"Application Manufacturer","ApplicationManufacturer",false },
  {0x0018,0x9527,VR::CS,VM::VM1,"Algorithm Type","AlgorithmType",false },
  {0x0018,0x9528,VR::LO,VM::VM1,"Algorithm Description","AlgorithmDescription",false },
  {0x0018,0x9530,VR::SQ,VM::VM1,"X-Ray 3D Reconstruction Sequence","XRay3DReconstructionSequence",false },
  {0x0018,0x9531,VR::LO,VM::VM1,"Reconstruction Description","ReconstructionDescription",false },
  {0x0018,0x9538,VR::SQ,VM::VM1,"Per Projection Acquisition Sequence","PerProjectionAcquisitionSequence",false },
  {0x0018,0x9601,VR::SQ,VM::VM1,"Diffusion b-matrix Sequence","DiffusionBMatrixSequence",false },
  {0x0018,0x9602,VR::FD,VM::VM1,"Diffusion b-value XX","DiffusionBValueXX",false },
  {0x0018,0x9603,VR::FD,VM::VM1,"Diffusion b-value XY","DiffusionBValueXY",false },
  {0x0018,0x9604,VR::FD,VM::VM1,"Diffusion b-value XZ","DiffusionBValueXZ",false },
  {0x0018,0x9605,VR::FD,VM::VM1,"Diffusion b-value YY","DiffusionBValueYY",false },
  {0x0018,0x9606,VR::FD,VM::VM1,"Diffusion b-value YZ","DiffusionBValueYZ",false },
  {0x0018,0x9607,VR::FD,VM::VM1,"Diffusion b-value ZZ","DiffusionBValueZZ",false },
  {0x0018,0x9701,VR::DT,VM::VM1,"Decay Correction DateTime","DecayCorrectionDateTime",false },
  {0x0018,0x9715,VR::FD,VM::VM1,"Start Density Threshold","StartDensityThreshold",false },
  {0x0018,0x9716,VR::FD,VM::VM1,"Start Relative Density Difference Threshold","StartRelativeDensityDifferenceThreshold",false },
  {0x0018,0x9717,VR::FD,VM::VM1,"Start Cardiac Trigger Count Threshold","StartCardiacTriggerCountThreshold",false },
  {0x0018,0x9718,VR::FD,VM::VM1,"Start Respiratory Trigger Count Threshold","StartRespiratoryTriggerCountThreshold",false },
  {0x0018,0x9719,VR::FD,VM::VM1,"Termination Counts Threshold","TerminationCountsThreshold",false },
  {0x0018,0x9720,VR::FD,VM::VM1,"Termination Density Threshold","TerminationDensityThreshold",false },
  {0x0018,0x9721,VR::FD,VM::VM1,"Termination Relative Density Threshold","TerminationRelativeDensityThreshold",false },
  {0x0018,0x9722,VR::FD,VM::VM1,"Termination Time Threshold","TerminationTimeThreshold",false },
  {0x0018,0x9723,VR::FD,VM::VM1,"Termination Cardiac Trigger Count Threshold","TerminationCardiacTriggerCountThreshold",false },
  {0x0018,0x9724,VR::FD,VM::VM1,"Termination Respiratory Trigger Count Threshold","TerminationRespiratoryTriggerCountThreshold",false },
  {0x0018,0x9725,VR::CS,VM::VM1,"Detector Geometry","DetectorGeometry",false },
  {0x0018,0x9726,VR::FD,VM::VM1,"Transverse Detector Separation","TransverseDetectorSeparation",false },
  {0x0018,0x9727,VR::FD,VM::VM1,"Axial Detector Dimension","AxialDetectorDimension",false },
  {0x0018,0x9729,VR::US,VM::VM1,"Radiopharmaceutical Agent Number","RadiopharmaceuticalAgentNumber",false },
  {0x0018,0x9732,VR::SQ,VM::VM1,"PET Frame Acquisition Sequence","PETFrameAcquisitionSequence",false },
  {0x0018,0x9733,VR::SQ,VM::VM1,"PET Detector Motion Details Sequence","PETDetectorMotionDetailsSequence",false },
  {0x0018,0x9734,VR::SQ,VM::VM1,"PET Table Dynamics Sequence","PETTableDynamicsSequence",false },
  {0x0018,0x9735,VR::SQ,VM::VM1,"PET Position Sequence","PETPositionSequence",false },
  {0x0018,0x9736,VR::SQ,VM::VM1,"PET Frame Correction Factors Sequence","PETFrameCorrectionFactorsSequence",false },
  {0x0018,0x9737,VR::SQ,VM::VM1,"Radiopharmaceutical Usage Sequence","RadiopharmaceuticalUsageSequence",false },
  {0x0018,0x9738,VR::CS,VM::VM1,"Attenuation Correction Source","AttenuationCorrectionSource",false },
  {0x0018,0x9739,VR::US,VM::VM1,"Number of Iterations","NumberOfIterations",false },
  {0x0018,0x9740,VR::US,VM::VM1,"Number of Subsets","NumberOfSubsets",false },
  {0x0018,0x9749,VR::SQ,VM::VM1,"PET Reconstruction Sequence","PETReconstructionSequence",false },
  {0x0018,0x9751,VR::SQ,VM::VM1,"PET Frame Type Sequence","PETFrameTypeSequence",false },
  {0x0018,0x9755,VR::CS,VM::VM1,"Time of Flight Information Used","TimeOfFlightInformationUsed",false },
  {0x0018,0x9756,VR::CS,VM::VM1,"Reconstruction Type","ReconstructionType",false },
  {0x0018,0x9758,VR::CS,VM::VM1,"Decay Corrected","DecayCorrected",false },
  {0x0018,0x9759,VR::CS,VM::VM1,"Attenuation Corrected","AttenuationCorrected",false },
  {0x0018,0x9760,VR::CS,VM::VM1,"Scatter Corrected","ScatterCorrected",false },
  {0x0018,0x9761,VR::CS,VM::VM1,"Dead Time Corrected","DeadTimeCorrected",false },
  {0x0018,0x9762,VR::CS,VM::VM1,"Gantry Motion Corrected","GantryMotionCorrected",false },
  {0x0018,0x9763,VR::CS,VM::VM1,"Patient Motion Corrected","PatientMotionCorrected",false },
  {0x0018,0x9764,VR::CS,VM::VM1,"Count Loss Normalization Corrected","CountLossNormalizationCorrected",false },
  {0x0018,0x9765,VR::CS,VM::VM1,"Randoms Corrected","RandomsCorrected",false },
  {0x0018,0x9766,VR::CS,VM::VM1,"Non-uniform Radial Sampling Corrected","NonUniformRadialSamplingCorrected",false },
  {0x0018,0x9767,VR::CS,VM::VM1,"Sensitivity Calibrated","SensitivityCalibrated",false },
  {0x0018,0x9768,VR::CS,VM::VM1,"Detector Normalization Correction","DetectorNormalizationCorrection",false },
  {0x0018,0x9769,VR::CS,VM::VM1,"Iterative Reconstruction Method","IterativeReconstructionMethod",false },
  {0x0018,0x9770,VR::CS,VM::VM1,"Attenuation Correction Temporal Relationship","AttenuationCorrectionTemporalRelationship",false },
  {0x0018,0x9771,VR::SQ,VM::VM1,"Patient Physiological State Sequence","PatientPhysiologicalStateSequence",false },
  {0x0018,0x9772,VR::SQ,VM::VM1,"Patient Physiological State Code Sequence","PatientPhysiologicalStateCodeSequence",false },
  {0x0018,0x9801,VR::FD,VM::VM1_n,"Depth(s) of Focus","DepthsOfFocus",false },
  {0x0018,0x9803,VR::SQ,VM::VM1,"Excluded Intervals Sequence","ExcludedIntervalsSequence",false },
  {0x0018,0x9804,VR::DT,VM::VM1,"Exclusion Start Datetime","ExclusionStartDatetime",false },
  {0x0018,0x9805,VR::FD,VM::VM1,"Exclusion Duration","ExclusionDuration",false },
  {0x0018,0x9806,VR::SQ,VM::VM1,"US Image Description Sequence","USImageDescriptionSequence",false },
  {0x0018,0x9807,VR::SQ,VM::VM1,"Image Data Type Sequence","ImageDataTypeSequence",false },
  {0x0018,0x9808,VR::CS,VM::VM1,"Data Type","DataType",false },
  {0x0018,0x9809,VR::SQ,VM::VM1,"Transducer Scan Pattern Code Sequence","TransducerScanPatternCodeSequence",false },
  {0x0018,0x980b,VR::CS,VM::VM1,"Aliased Data Type","AliasedDataType",false },
  {0x0018,0x980c,VR::CS,VM::VM1,"Position Measuring Device Used","PositionMeasuringDeviceUsed",false },
  {0x0018,0x980d,VR::SQ,VM::VM1,"Transducer Geometry Code Sequence","TransducerGeometryCodeSequence",false },
  {0x0018,0x980e,VR::SQ,VM::VM1,"Transducer Beam Steering Code Sequence","TransducerBeamSteeringCodeSequence",false },
  {0x0018,0x980f,VR::SQ,VM::VM1,"Transducer Application Code Sequence","TransducerApplicationCodeSequence",false },
  {0x0018,0xa001,VR::SQ,VM::VM1,"Contributing Equipment Sequence","ContributingEquipmentSequence",false },
  {0x0018,0xa002,VR::DT,VM::VM1,"Contribution Date Time","ContributionDateTime",false },
  {0x0018,0xa003,VR::ST,VM::VM1,"Contribution Description","ContributionDescription",false },
  {0x0020,0x000d,VR::UI,VM::VM1,"Study Instance UID","StudyInstanceUID",false },
  {0x0020,0x000e,VR::UI,VM::VM1,"Series Instance UID","SeriesInstanceUID",false },
  {0x0020,0x0010,VR::SH,VM::VM1,"Study ID","StudyID",false },
  {0x0020,0x0011,VR::IS,VM::VM1,"Series Number","SeriesNumber",false },
  {0x0020,0x0012,VR::IS,VM::VM1,"Acquisition Number","AcquisitionNumber",false },
  {0x0020,0x0013,VR::IS,VM::VM1,"Instance Number","InstanceNumber",false },
  {0x0020,0x0014,VR::IS,VM::VM1,"Isotope Number","IsotopeNumber",true },
  {0x0020,0x0015,VR::IS,VM::VM1,"Phase Number","PhaseNumber",true },
  {0x0020,0x0016,VR::IS,VM::VM1,"Interval Number","IntervalNumber",true },
  {0x0020,0x0017,VR::IS,VM::VM1,"Time Slot Number","TimeSlotNumber",true },
  {0x0020,0x0018,VR::IS,VM::VM1,"Angle Number","AngleNumber",true },
  {0x0020,0x0019,VR::IS,VM::VM1,"Item Number","ItemNumber",false },
  {0x0020,0x0020,VR::CS,VM::VM2,"Patient Orientation","PatientOrientation",false },
  {0x0020,0x0022,VR::IS,VM::VM1,"Overlay Number","OverlayNumber",true },
  {0x0020,0x0024,VR::IS,VM::VM1,"Curve Number","CurveNumber",true },
  {0x0020,0x0026,VR::IS,VM::VM1,"LUT Number","LUTNumber",true },
  {0x0020,0x0030,VR::DS,VM::VM3,"Image Position","ImagePosition",true },
  {0x0020,0x0032,VR::DS,VM::VM3,"Image Position (Patient)","ImagePositionPatient",false },
  {0x0020,0x0035,VR::DS,VM::VM6,"Image Orientation","ImageOrientation",true },
  {0x0020,0x0037,VR::DS,VM::VM6,"Image Orientation (Patient)","ImageOrientationPatient",false },
  {0x0020,0x0050,VR::DS,VM::VM1,"Location","Location",true },
  {0x0020,0x0052,VR::UI,VM::VM1,"Frame of Reference UID","FrameOfReferenceUID",false },
  {0x0020,0x0060,VR::CS,VM::VM1,"Laterality","Laterality",false },
  {0x0020,0x0062,VR::CS,VM::VM1,"Image Laterality","ImageLaterality",false },
  {0x0020,0x0070,VR::LO,VM::VM1,"Image Geometry Type","ImageGeometryType",true },
  {0x0020,0x0080,VR::CS,VM::VM1_n,"Masking Image","MaskingImage",true },
  {0x0020,0x00aa,VR::IS,VM::VM1,"Report Number","ReportNumber",true },
  {0x0020,0x0100,VR::IS,VM::VM1,"Temporal Position Identifier","TemporalPositionIdentifier",false },
  {0x0020,0x0105,VR::IS,VM::VM1,"Number of Temporal Positions","NumberOfTemporalPositions",false },
  {0x0020,0x0110,VR::DS,VM::VM1,"Temporal Resolution","TemporalResolution",false },
  {0x0020,0x0200,VR::UI,VM::VM1,"Synchronization Frame of Reference UID","SynchronizationFrameOfReferenceUID",false },
  {0x0020,0x0242,VR::UI,VM::VM1,"SOP Instance UID of Concatenation Source","SOPInstanceUIDOfConcatenationSource",false },
  {0x0020,0x1000,VR::IS,VM::VM1,"Series in Study","SeriesInStudy",true },
  {0x0020,0x1001,VR::IS,VM::VM1,"Acquisitions in Series","AcquisitionsInSeries",true },
  {0x0020,0x1002,VR::IS,VM::VM1,"Images in Acquisition","ImagesInAcquisition",false },
  {0x0020,0x1003,VR::IS,VM::VM1,"Images in Series","ImagesInSeries",true },
  {0x0020,0x1004,VR::IS,VM::VM1,"Acquisitions in Study","AcquisitionsInStudy",true },
  {0x0020,0x1005,VR::IS,VM::VM1,"Images in Study","ImagesInStudy",true },
  {0x0020,0x1020,VR::LO,VM::VM1_n,"Reference","Reference",true },
  {0x0020,0x1040,VR::LO,VM::VM1,"Position Reference Indicator","PositionReferenceIndicator",false },
  {0x0020,0x1041,VR::DS,VM::VM1,"Slice Location","SliceLocation",false },
  {0x0020,0x1070,VR::IS,VM::VM1_n,"Other Study Numbers","OtherStudyNumbers",true },
  {0x0020,0x1200,VR::IS,VM::VM1,"Number of Patient Related Studies","NumberOfPatientRelatedStudies",false },
  {0x0020,0x1202,VR::IS,VM::VM1,"Number of Patient Related Series","NumberOfPatientRelatedSeries",false },
  {0x0020,0x1204,VR::IS,VM::VM1,"Number of Patient Related Instances","NumberOfPatientRelatedInstances",false },
  {0x0020,0x1206,VR::IS,VM::VM1,"Number of Study Related Series","NumberOfStudyRelatedSeries",false },
  {0x0020,0x1208,VR::IS,VM::VM1,"Number of Study Related Instances","NumberOfStudyRelatedInstances",false },
  {0x0020,0x1209,VR::IS,VM::VM1,"Number of Series Related Instances","NumberOfSeriesRelatedInstances",false },
  {0x0020,0x3100,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3101,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3102,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3103,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3104,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3105,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3106,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3107,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3108,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3109,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x310a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x310b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x310c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x310d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x310e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x310f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3110,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3111,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3112,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3113,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3114,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3115,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3116,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3117,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3118,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3119,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x311a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x311b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x311c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x311d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x311e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x311f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3120,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3121,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3122,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3123,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3124,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3125,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3126,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3127,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3128,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3129,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x312a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x312b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x312c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x312d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x312e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x312f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3130,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3131,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3132,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3133,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3134,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3135,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3136,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3137,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3138,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3139,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x313a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x313b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x313c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x313d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x313e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x313f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3140,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3141,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3142,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3143,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3144,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3145,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3146,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3147,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3148,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3149,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x314a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x314b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x314c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x314d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x314e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x314f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3150,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3151,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3152,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3153,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3154,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3155,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3156,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3157,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3158,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3159,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x315a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x315b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x315c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x315d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x315e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x315f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3160,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3161,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3162,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3163,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3164,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3165,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3166,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3167,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3168,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3169,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x316a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x316b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x316c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x316d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x316e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x316f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3170,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3171,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3172,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3173,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3174,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3175,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3176,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3177,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3178,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3179,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x317a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x317b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x317c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x317d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x317e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x317f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3180,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3181,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3182,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3183,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3184,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3185,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3186,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3187,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3188,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3189,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x318a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x318b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x318c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x318d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x318e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x318f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3190,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3191,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3192,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3193,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3194,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3195,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3196,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3197,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3198,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3199,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x319a,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x319b,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x319c,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x319d,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x319e,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x319f,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a0,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a1,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a2,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a3,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a4,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a5,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a6,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a7,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a8,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31a9,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31aa,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ab,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ac,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ad,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ae,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31af,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b0,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b1,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b2,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b3,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b4,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b5,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b6,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b7,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b8,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31b9,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ba,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31bb,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31bc,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31bd,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31be,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31bf,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c0,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c1,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c2,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c3,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c4,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c5,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c6,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c7,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c8,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31c9,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ca,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31cb,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31cc,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31cd,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ce,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31cf,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d0,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d1,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d2,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d3,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d4,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d5,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d6,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d7,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d8,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31d9,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31da,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31db,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31dc,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31dd,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31de,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31df,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e0,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e1,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e2,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e3,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e4,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e5,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e6,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e7,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e8,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31e9,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ea,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31eb,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ec,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ed,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ee,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ef,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f0,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f1,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f2,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f3,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f4,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f5,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f6,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f7,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f8,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31f9,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31fa,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31fb,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31fc,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31fd,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31fe,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x31ff,VR::CS,VM::VM1_n,"Source Image IDs","SourceImageIDs",true },
  {0x0020,0x3401,VR::CS,VM::VM1,"Modifying Device ID","ModifyingDeviceID",true },
  {0x0020,0x3402,VR::CS,VM::VM1,"Modified Image ID","ModifiedImageID",true },
  {0x0020,0x3403,VR::DA,VM::VM1,"Modified Image Date","ModifiedImageDate",true },
  {0x0020,0x3404,VR::LO,VM::VM1,"Modifying Device Manufacturer","ModifyingDeviceManufacturer",true },
  {0x0020,0x3405,VR::TM,VM::VM1,"Modified Image Time","ModifiedImageTime",true },
  {0x0020,0x3406,VR::LO,VM::VM1,"Modified Image Description","ModifiedImageDescription",true },
  {0x0020,0x4000,VR::LT,VM::VM1,"Image Comments","ImageComments",false },
  {0x0020,0x5000,VR::AT,VM::VM1_n,"Original Image Identification","OriginalImageIdentification",true },
  {0x0020,0x5002,VR::LO,VM::VM1_n,"Original Image Identification Nomenclature","OriginalImageIdentificationNomenclature",true },
  {0x0020,0x9056,VR::SH,VM::VM1,"Stack ID","StackID",false },
  {0x0020,0x9057,VR::UL,VM::VM1,"In-Stack Position Number","InStackPositionNumber",false },
  {0x0020,0x9071,VR::SQ,VM::VM1,"Frame Anatomy Sequence","FrameAnatomySequence",false },
  {0x0020,0x9072,VR::CS,VM::VM1,"Frame Laterality","FrameLaterality",false },
  {0x0020,0x9111,VR::SQ,VM::VM1,"Frame Content Sequence","FrameContentSequence",false },
  {0x0020,0x9113,VR::SQ,VM::VM1,"Plane Position Sequence","PlanePositionSequence",false },
  {0x0020,0x9116,VR::SQ,VM::VM1,"Plane Orientation Sequence","PlaneOrientationSequence",false },
  {0x0020,0x9128,VR::UL,VM::VM1,"Temporal Position Index","TemporalPositionIndex",false },
  {0x0020,0x9153,VR::FD,VM::VM1,"Nominal Cardiac Trigger Delay Time","NominalCardiacTriggerDelayTime",false },
  {0x0020,0x9154,VR::FL,VM::VM1,"Nominal Cardiac Trigger Time Prior To R-Peak","NominalCardiacTriggerTimePriorToRPeak",false },
  {0x0020,0x9155,VR::FL,VM::VM1,"Actual Cardiac Trigger Time Prior To R-Peak","ActualCardiacTriggerTimePriorToRPeak",false },
  {0x0020,0x9156,VR::US,VM::VM1,"Frame Acquisition Number","FrameAcquisitionNumber",false },
  {0x0020,0x9157,VR::UL,VM::VM1_n,"Dimension Index Values","DimensionIndexValues",false },
  {0x0020,0x9158,VR::LT,VM::VM1,"Frame Comments","FrameComments",false },
  {0x0020,0x9161,VR::UI,VM::VM1,"Concatenation UID","ConcatenationUID",false },
  {0x0020,0x9162,VR::US,VM::VM1,"In-concatenation Number","InConcatenationNumber",false },
  {0x0020,0x9163,VR::US,VM::VM1,"In-concatenation Total Number","InConcatenationTotalNumber",false },
  {0x0020,0x9164,VR::UI,VM::VM1,"Dimension Organization UID","DimensionOrganizationUID",false },
  {0x0020,0x9165,VR::AT,VM::VM1,"Dimension Index Pointer","DimensionIndexPointer",false },
  {0x0020,0x9167,VR::AT,VM::VM1,"Functional Group Pointer","FunctionalGroupPointer",false },
  {0x0020,0x9213,VR::LO,VM::VM1,"Dimension Index Private Creator","DimensionIndexPrivateCreator",false },
  {0x0020,0x9221,VR::SQ,VM::VM1,"Dimension Organization Sequence","DimensionOrganizationSequence",false },
  {0x0020,0x9222,VR::SQ,VM::VM1,"Dimension Index Sequence","DimensionIndexSequence",false },
  {0x0020,0x9228,VR::UL,VM::VM1,"Concatenation Frame Offset Number","ConcatenationFrameOffsetNumber",false },
  {0x0020,0x9238,VR::LO,VM::VM1,"Functional Group Private Creator","FunctionalGroupPrivateCreator",false },
  {0x0020,0x9241,VR::FL,VM::VM1,"Nominal Percentage of Cardiac Phase","NominalPercentageOfCardiacPhase",false },
  {0x0020,0x9245,VR::FL,VM::VM1,"Nominal Percentage of Respiratory Phase","NominalPercentageOfRespiratoryPhase",false },
  {0x0020,0x9246,VR::FL,VM::VM1,"Starting Respiratory Amplitude","StartingRespiratoryAmplitude",false },
  {0x0020,0x9247,VR::CS,VM::VM1,"Starting Respiratory Phase","StartingRespiratoryPhase",false },
  {0x0020,0x9248,VR::FL,VM::VM1,"Ending Respiratory Amplitude","EndingRespiratoryAmplitude",false },
  {0x0020,0x9249,VR::CS,VM::VM1,"Ending Respiratory Phase","EndingRespiratoryPhase",false },
  {0x0020,0x9250,VR::CS,VM::VM1,"Respiratory Trigger Type","RespiratoryTriggerType",false },
  {0x0020,0x9251,VR::FD,VM::VM1,"R-R Interval Time Nominal","RRIntervalTimeNominal",false },
  {0x0020,0x9252,VR::FD,VM::VM1,"Actual Cardiac Trigger Delay Time","ActualCardiacTriggerDelayTime",false },
  {0x0020,0x9253,VR::SQ,VM::VM1,"Respiratory Synchronization Sequence","RespiratorySynchronizationSequence",false },
  {0x0020,0x9254,VR::FD,VM::VM1,"Respiratory Interval Time","RespiratoryIntervalTime",false },
  {0x0020,0x9255,VR::FD,VM::VM1,"Nominal Respiratory Trigger Delay Time","NominalRespiratoryTriggerDelayTime",false },
  {0x0020,0x9256,VR::FD,VM::VM1,"Respiratory Trigger Delay Threshold","RespiratoryTriggerDelayThreshold",false },
  {0x0020,0x9257,VR::FD,VM::VM1,"Actual Respiratory Trigger Delay Time","ActualRespiratoryTriggerDelayTime",false },
  {0x0020,0x9301,VR::FD,VM::VM3,"Image Position (Volume)","ImagePositionVolume",false },
  {0x0020,0x9302,VR::FD,VM::VM6,"Image Orientation (Volume)","ImageOrientationVolume",false },
  {0x0020,0x9307,VR::CS,VM::VM1,"Ultrasound Acquisition Geometry","UltrasoundAcquisitionGeometry",false },
  {0x0020,0x9308,VR::FD,VM::VM3,"Apex Position","ApexPosition",false },
  {0x0020,0x9309,VR::FD,VM::VM16,"Volume to Transducer Mapping Matrix","VolumeToTransducerMappingMatrix",false },
  {0x0020,0x930a,VR::FD,VM::VM16,"Volume to Table Mapping Matrix","VolumeToTableMappingMatrix",false },
  {0x0020,0x930c,VR::CS,VM::VM1,"Patient Frame of Reference Source","PatientFrameOfReferenceSource",false },
  {0x0020,0x930d,VR::FD,VM::VM1,"Temporal Position Time Offset","TemporalPositionTimeOffset",false },
  {0x0020,0x930e,VR::SQ,VM::VM1,"Plane Position (Volume) Sequence","PlanePositionVolumeSequence",false },
  {0x0020,0x930f,VR::SQ,VM::VM1,"Plane Orientation (Volume) Sequence","PlaneOrientationVolumeSequence",false },
  {0x0020,0x9310,VR::SQ,VM::VM1,"Temporal Position Sequence","TemporalPositionSequence",false },
  {0x0020,0x9311,VR::CS,VM::VM1,"Dimension Organization Type","DimensionOrganizationType",false },
  {0x0020,0x9312,VR::UI,VM::VM1,"Volume Frame of Reference UID","VolumeFrameOfReferenceUID",false },
  {0x0020,0x9313,VR::UI,VM::VM1,"Table Frame of Reference UID","TableFrameOfReferenceUID",false },
  {0x0020,0x9421,VR::LO,VM::VM1,"Dimension Description Label","DimensionDescriptionLabel",false },
  {0x0020,0x9450,VR::SQ,VM::VM1,"Patient Orientation in Frame Sequence","PatientOrientationInFrameSequence",false },
  {0x0020,0x9453,VR::LO,VM::VM1,"Frame Label","FrameLabel",false },
  {0x0020,0x9518,VR::US,VM::VM1_n,"Acquisition Index","AcquisitionIndex",false },
  {0x0020,0x9529,VR::SQ,VM::VM1,"Contributing SOP Instances Reference Sequence","ContributingSOPInstancesReferenceSequence",false },
  {0x0020,0x9536,VR::US,VM::VM1,"Reconstruction Index","ReconstructionIndex",false },
  {0x0022,0x0001,VR::US,VM::VM1,"Light Path Filter Pass-Through Wavelength","LightPathFilterPassThroughWavelength",false },
  {0x0022,0x0002,VR::US,VM::VM2,"Light Path Filter Pass Band","LightPathFilterPassBand",false },
  {0x0022,0x0003,VR::US,VM::VM1,"Image Path Filter Pass-Through Wavelength","ImagePathFilterPassThroughWavelength",false },
  {0x0022,0x0004,VR::US,VM::VM2,"Image Path Filter Pass Band","ImagePathFilterPassBand",false },
  {0x0022,0x0005,VR::CS,VM::VM1,"Patient Eye Movement Commanded","PatientEyeMovementCommanded",false },
  {0x0022,0x0006,VR::SQ,VM::VM1,"Patient Eye Movement Command Code Sequence","PatientEyeMovementCommandCodeSequence",false },
  {0x0022,0x0007,VR::FL,VM::VM1,"Spherical Lens Power","SphericalLensPower",false },
  {0x0022,0x0008,VR::FL,VM::VM1,"Cylinder Lens Power","CylinderLensPower",false },
  {0x0022,0x0009,VR::FL,VM::VM1,"Cylinder Axis","CylinderAxis",false },
  {0x0022,0x000a,VR::FL,VM::VM1,"Emmetropic Magnification","EmmetropicMagnification",false },
  {0x0022,0x000b,VR::FL,VM::VM1,"Intra Ocular Pressure","IntraOcularPressure",false },
  {0x0022,0x000c,VR::FL,VM::VM1,"Horizontal Field of View","HorizontalFieldOfView",false },
  {0x0022,0x000d,VR::CS,VM::VM1,"Pupil Dilated","PupilDilated",false },
  {0x0022,0x000e,VR::FL,VM::VM1,"Degree of Dilation","DegreeOfDilation",false },
  {0x0022,0x0010,VR::FL,VM::VM1,"Stereo Baseline Angle","StereoBaselineAngle",false },
  {0x0022,0x0011,VR::FL,VM::VM1,"Stereo Baseline Displacement","StereoBaselineDisplacement",false },
  {0x0022,0x0012,VR::FL,VM::VM1,"Stereo Horizontal Pixel Offset","StereoHorizontalPixelOffset",false },
  {0x0022,0x0013,VR::FL,VM::VM1,"Stereo Vertical Pixel Offset","StereoVerticalPixelOffset",false },
  {0x0022,0x0014,VR::FL,VM::VM1,"Stereo Rotation","StereoRotation",false },
  {0x0022,0x0015,VR::SQ,VM::VM1,"Acquisition Device Type Code Sequence","AcquisitionDeviceTypeCodeSequence",false },
  {0x0022,0x0016,VR::SQ,VM::VM1,"Illumination Type Code Sequence","IlluminationTypeCodeSequence",false },
  {0x0022,0x0017,VR::SQ,VM::VM1,"Light Path Filter Type Stack Code Sequence","LightPathFilterTypeStackCodeSequence",false },
  {0x0022,0x0018,VR::SQ,VM::VM1,"Image Path Filter Type Stack Code Sequence","ImagePathFilterTypeStackCodeSequence",false },
  {0x0022,0x0019,VR::SQ,VM::VM1,"Lenses Code Sequence","LensesCodeSequence",false },
  {0x0022,0x001a,VR::SQ,VM::VM1,"Channel Description Code Sequence","ChannelDescriptionCodeSequence",false },
  {0x0022,0x001b,VR::SQ,VM::VM1,"Refractive State Sequence","RefractiveStateSequence",false },
  {0x0022,0x001c,VR::SQ,VM::VM1,"Mydriatic Agent Code Sequence","MydriaticAgentCodeSequence",false },
  {0x0022,0x001d,VR::SQ,VM::VM1,"Relative Image Position Code Sequence","RelativeImagePositionCodeSequence",false },
  {0x0022,0x001e,VR::FL,VM::VM1,"Camera Angle of View","CameraAngleOfView",false },
  {0x0022,0x0020,VR::SQ,VM::VM1,"Stereo Pairs Sequence","StereoPairsSequence",false },
  {0x0022,0x0021,VR::SQ,VM::VM1,"Left Image Sequence","LeftImageSequence",false },
  {0x0022,0x0022,VR::SQ,VM::VM1,"Right Image Sequence","RightImageSequence",false },
  {0x0022,0x0030,VR::FL,VM::VM1,"Axial Length of the Eye","AxialLengthOfTheEye",false },
  {0x0022,0x0031,VR::SQ,VM::VM1,"Ophthalmic Frame Location Sequence","OphthalmicFrameLocationSequence",false },
  {0x0022,0x0032,VR::FL,VM::VM2_2n,"Reference Coordinates","ReferenceCoordinates",false },
  {0x0022,0x0035,VR::FL,VM::VM1,"Depth Spatial Resolution","DepthSpatialResolution",false },
  {0x0022,0x0036,VR::FL,VM::VM1,"Maximum Depth Distortion","MaximumDepthDistortion",false },
  {0x0022,0x0037,VR::FL,VM::VM1,"Along-scan Spatial Resolution","AlongScanSpatialResolution",false },
  {0x0022,0x0038,VR::FL,VM::VM1,"Maximum Along-scan Distortion","MaximumAlongScanDistortion",false },
  {0x0022,0x0039,VR::CS,VM::VM1,"Ophthalmic Image Orientation","OphthalmicImageOrientation",false },
  {0x0022,0x0041,VR::FL,VM::VM1,"Depth of Transverse Image","DepthOfTransverseImage",false },
  {0x0022,0x0042,VR::SQ,VM::VM1,"Mydriatic Agent Concentration Units Sequence","MydriaticAgentConcentrationUnitsSequence",false },
  {0x0022,0x0048,VR::FL,VM::VM1,"Across-scan Spatial Resolution","AcrossScanSpatialResolution",false },
  {0x0022,0x0049,VR::FL,VM::VM1,"Maximum Across-scan Distortion","MaximumAcrossScanDistortion",false },
  {0x0022,0x004e,VR::DS,VM::VM1,"Mydriatic Agent Concentration","MydriaticAgentConcentration",false },
  {0x0022,0x0055,VR::FL,VM::VM1,"Illumination Wave Length","IlluminationWaveLength",false },
  {0x0022,0x0056,VR::FL,VM::VM1,"Illumination Power","IlluminationPower",false },
  {0x0022,0x0057,VR::FL,VM::VM1,"Illumination Bandwidth","IlluminationBandwidth",false },
  {0x0022,0x0058,VR::SQ,VM::VM1,"Mydriatic Agent Sequence","MydriaticAgentSequence",false },
  {0x0022,0x1007,VR::SQ,VM::VM1,"Ophthalmic Axial Measurements Right Eye Sequence","OphthalmicAxialMeasurementsRightEyeSequence",false },
  {0x0022,0x1008,VR::SQ,VM::VM1,"Ophthalmic Axial Measurements Left Eye Sequence","OphthalmicAxialMeasurementsLeftEyeSequence",false },
  {0x0022,0x1009,VR::CS,VM::VM1,"Ophthalmic Axial Measurements Device Type","OphthalmicAxialMeasurementsDeviceType",false },
  {0x0022,0x1010,VR::CS,VM::VM1,"Ophthalmic Axial Length Measurements Type","OphthalmicAxialLengthMeasurementsType",false },
  {0x0022,0x1012,VR::SQ,VM::VM1,"Ophthalmic Axial Length Sequence","OphthalmicAxialLengthSequence",false },
  {0x0022,0x1019,VR::FL,VM::VM1,"Ophthalmic Axial Length","OphthalmicAxialLength",false },
  {0x0022,0x1024,VR::SQ,VM::VM1,"Lens Status Code Sequence","LensStatusCodeSequence",false },
  {0x0022,0x1025,VR::SQ,VM::VM1,"Vitreous Status Code Sequence","VitreousStatusCodeSequence",false },
  {0x0022,0x1028,VR::SQ,VM::VM1,"IOL Formula Code Sequence","IOLFormulaCodeSequence",false },
  {0x0022,0x1029,VR::LO,VM::VM1,"IOL Formula Detail","IOLFormulaDetail",false },
  {0x0022,0x1033,VR::FL,VM::VM1,"Keratometer Index","KeratometerIndex",false },
  {0x0022,0x1035,VR::SQ,VM::VM1,"Source of Ophthalmic Axial Length Code Sequence","SourceOfOphthalmicAxialLengthCodeSequence",false },
  {0x0022,0x1037,VR::FL,VM::VM1,"Target Refraction","TargetRefraction",false },
  {0x0022,0x1039,VR::CS,VM::VM1,"Refractive Procedure Occurred","RefractiveProcedureOccurred",false },
  {0x0022,0x1040,VR::SQ,VM::VM1,"Refractive Surgery Type Code Sequence","RefractiveSurgeryTypeCodeSequence",false },
  {0x0022,0x1044,VR::SQ,VM::VM1,"Ophthalmic Ultrasound Method Code Sequence","OphthalmicUltrasoundMethodCodeSequence",false },
  {0x0022,0x1050,VR::SQ,VM::VM1,"Ophthalmic Axial Length Measurements Sequence","OphthalmicAxialLengthMeasurementsSequence",false },
  {0x0022,0x1053,VR::FL,VM::VM1,"IOL Power","IOLPower",false },
  {0x0022,0x1054,VR::FL,VM::VM1,"Predicted Refractive Error","PredictedRefractiveError",false },
  {0x0022,0x1059,VR::FL,VM::VM1,"Ophthalmic Axial Length Velocity","OphthalmicAxialLengthVelocity",false },
  {0x0022,0x1065,VR::LO,VM::VM1,"Lens Status Description","LensStatusDescription",false },
  {0x0022,0x1066,VR::LO,VM::VM1,"Vitreous Status Description","VitreousStatusDescription",false },
  {0x0022,0x1090,VR::SQ,VM::VM1,"IOL Power Sequence","IOLPowerSequence",false },
  {0x0022,0x1092,VR::SQ,VM::VM1,"Lens Constant Sequence","LensConstantSequence",false },
  {0x0022,0x1093,VR::LO,VM::VM1,"IOL Manufacturer","IOLManufacturer",false },
  {0x0022,0x1094,VR::LO,VM::VM1,"Lens Constant Description","LensConstantDescription",false },
  {0x0022,0x1095,VR::LO,VM::VM1,"Implant Name","ImplantName",false },
  {0x0022,0x1096,VR::SQ,VM::VM1,"Keratometry Measurement Type Code Sequence","KeratometryMeasurementTypeCodeSequence",false },
  {0x0022,0x1097,VR::LO,VM::VM1,"Implant Part Number","ImplantPartNumber",false },
  {0x0022,0x1100,VR::SQ,VM::VM1,"Referenced Ophthalmic Axial Measurements Sequence","ReferencedOphthalmicAxialMeasurementsSequence",false },
  {0x0022,0x1101,VR::SQ,VM::VM1,"Ophthalmic Axial Length Measurements Segment Name Code Sequence","OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence",false },
  {0x0022,0x1103,VR::SQ,VM::VM1,"Refractive Error Before Refractive Surgery Code Sequence","RefractiveErrorBeforeRefractiveSurgeryCodeSequence",false },
  {0x0022,0x1121,VR::FL,VM::VM1,"IOL Power For Exact Emmetropia","IOLPowerForExactEmmetropia",false },
  {0x0022,0x1122,VR::FL,VM::VM1,"IOL Power For Exact Target Refraction","IOLPowerForExactTargetRefraction",false },
  {0x0022,0x1125,VR::SQ,VM::VM1,"Anterior Chamber Depth Definition Code Sequence","AnteriorChamberDepthDefinitionCodeSequence",false },
  {0x0022,0x1127,VR::SQ,VM::VM1,"Lens Thickness Sequence","LensThicknessSequence",false },
  {0x0022,0x1128,VR::SQ,VM::VM1,"Anterior Chamber Depth Sequence","AnteriorChamberDepthSequence",false },
  {0x0022,0x1130,VR::FL,VM::VM1,"Lens Thickness","LensThickness",false },
  {0x0022,0x1131,VR::FL,VM::VM1,"Anterior Chamber Depth","AnteriorChamberDepth",false },
  {0x0022,0x1132,VR::SQ,VM::VM1,"Source of Lens Thickness Data Code Sequence","SourceOfLensThicknessDataCodeSequence",false },
  {0x0022,0x1133,VR::SQ,VM::VM1,"Source of Anterior Chamber Depth Data Code Sequence","SourceOfAnteriorChamberDepthDataCodeSequence",false },
  {0x0022,0x1134,VR::SQ,VM::VM1,"Source of Refractive Measurements Sequence","SourceOfRefractiveMeasurementsSequence",false },
  {0x0022,0x1135,VR::SQ,VM::VM1,"Source of Refractive Measurements Code Sequence","SourceOfRefractiveMeasurementsCodeSequence",false },
  {0x0022,0x1140,VR::CS,VM::VM1,"Ophthalmic Axial Length Measurement Modified","OphthalmicAxialLengthMeasurementModified",false },
  {0x0022,0x1150,VR::SQ,VM::VM1,"Ophthalmic Axial Length Data Source Code Sequence","OphthalmicAxialLengthDataSourceCodeSequence",false },
  {0x0022,0x1153,VR::SQ,VM::VM1,"Ophthalmic Axial Length Acquisition Method Code Sequence","OphthalmicAxialLengthAcquisitionMethodCodeSequence",false },
  {0x0022,0x1155,VR::FL,VM::VM1,"Signal to Noise Ratio","SignalToNoiseRatio",false },
  {0x0022,0x1159,VR::LO,VM::VM1,"Ophthalmic Axial Length Data Source Description","OphthalmicAxialLengthDataSourceDescription",false },
  {0x0022,0x1210,VR::SQ,VM::VM1,"Ophthalmic Axial Length Measurements Total Length Sequence","OphthalmicAxialLengthMeasurementsTotalLengthSequence",false },
  {0x0022,0x1211,VR::SQ,VM::VM1,"Ophthalmic Axial Length Measurements Segmental Length Sequence","OphthalmicAxialLengthMeasurementsSegmentalLengthSequence",false },
  {0x0022,0x1212,VR::SQ,VM::VM1,"Ophthalmic Axial Length Measurements Length Summation Sequence","OphthalmicAxialLengthMeasurementsLengthSummationSequence",false },
  {0x0022,0x1220,VR::SQ,VM::VM1,"Ultrasound Ophthalmic Axial Length Measurements Sequence","UltrasoundOphthalmicAxialLengthMeasurementsSequence",false },
  {0x0022,0x1225,VR::SQ,VM::VM1,"Optical Ophthalmic Axial Length Measurements Sequence","OpticalOphthalmicAxialLengthMeasurementsSequence",false },
  {0x0022,0x1230,VR::SQ,VM::VM1,"Ultrasound Selected Ophthalmic Axial Length Sequence","UltrasoundSelectedOphthalmicAxialLengthSequence",false },
  {0x0022,0x1250,VR::SQ,VM::VM1,"Ophthalmic Axial Length Selection Method Code Sequence","OphthalmicAxialLengthSelectionMethodCodeSequence",false },
  {0x0022,0x1255,VR::SQ,VM::VM1,"Optical Selected Ophthalmic Axial Length Sequence","OpticalSelectedOphthalmicAxialLengthSequence",false },
  {0x0022,0x1257,VR::SQ,VM::VM1,"Selected Segmental Ophthalmic Axial Length Sequence","SelectedSegmentalOphthalmicAxialLengthSequence",false },
  {0x0022,0x1260,VR::SQ,VM::VM1,"Selected Total Ophthalmic Axial Length Sequence","SelectedTotalOphthalmicAxialLengthSequence",false },
  {0x0022,0x1262,VR::SQ,VM::VM1,"Ophthalmic Axial Length Quality Metric Sequence","OphthalmicAxialLengthQualityMetricSequence",false },
  {0x0022,0x1273,VR::LO,VM::VM1,"Ophthalmic Axial Length Quality Metric Type Description","OphthalmicAxialLengthQualityMetricTypeDescription",false },
  {0x0022,0x1300,VR::SQ,VM::VM1,"Intraocular Lens Calculations Right Eye Sequence","IntraocularLensCalculationsRightEyeSequence",false },
  {0x0022,0x1310,VR::SQ,VM::VM1,"Intraocular Lens Calculations Left Eye Sequence","IntraocularLensCalculationsLeftEyeSequence",false },
  {0x0022,0x1330,VR::SQ,VM::VM1,"Referenced Ophthalmic Axial Length Measurement QC Image Sequence","ReferencedOphthalmicAxialLengthMeasurementQCImageSequence",false },
  {0x0024,0x0010,VR::FL,VM::VM1,"Visual Field Horizontal Extent","VisualFieldHorizontalExtent",false },
  {0x0024,0x0011,VR::FL,VM::VM1,"Visual Field Vertical Extent","VisualFieldVerticalExtent",false },
  {0x0024,0x0012,VR::CS,VM::VM1,"Visual Field Shape","VisualFieldShape",false },
  {0x0024,0x0016,VR::SQ,VM::VM1,"Screening Test Mode Code Sequence","ScreeningTestModeCodeSequence",false },
  {0x0024,0x0018,VR::FL,VM::VM1,"Maximum Stimulus Luminance","MaximumStimulusLuminance",false },
  {0x0024,0x0020,VR::FL,VM::VM1,"Background Luminance","BackgroundLuminance",false },
  {0x0024,0x0021,VR::SQ,VM::VM1,"Stimulus Color Code Sequence","StimulusColorCodeSequence",false },
  {0x0024,0x0024,VR::SQ,VM::VM1,"Background Illumination Color Code Sequence","BackgroundIlluminationColorCodeSequence",false },
  {0x0024,0x0025,VR::FL,VM::VM1,"Stimulus Area","StimulusArea",false },
  {0x0024,0x0028,VR::FL,VM::VM1,"Stimulus Presentation Time","StimulusPresentationTime",false },
  {0x0024,0x0032,VR::SQ,VM::VM1,"Fixation Sequence","FixationSequence",false },
  {0x0024,0x0033,VR::SQ,VM::VM1,"Fixation Monitoring Code Sequence","FixationMonitoringCodeSequence",false },
  {0x0024,0x0034,VR::SQ,VM::VM1,"Visual Field Catch Trial Sequence","VisualFieldCatchTrialSequence",false },
  {0x0024,0x0035,VR::US,VM::VM1,"Fixation Checked Quantity","FixationCheckedQuantity",false },
  {0x0024,0x0036,VR::US,VM::VM1,"Patient Not Properly Fixated Quantity","PatientNotProperlyFixatedQuantity",false },
  {0x0024,0x0037,VR::CS,VM::VM1,"Presented Visual Stimuli Data Flag","PresentedVisualStimuliDataFlag",false },
  {0x0024,0x0038,VR::US,VM::VM1,"Number of Visual Stimuli","NumberOfVisualStimuli",false },
  {0x0024,0x0039,VR::CS,VM::VM1,"Excessive Fixation Losses Data Flag","ExcessiveFixationLossesDataFlag",false },
  {0x0024,0x0040,VR::CS,VM::VM1,"Excessive Fixation Losses","ExcessiveFixationLosses",false },
  {0x0024,0x0042,VR::US,VM::VM1,"Stimuli Retesting Quantity","StimuliRetestingQuantity",false },
  {0x0024,0x0044,VR::LT,VM::VM1,"Comments on Patient's Performance of Visual Field","CommentsOnPatientPerformanceOfVisualField",false },
  {0x0024,0x0045,VR::CS,VM::VM1,"False Negatives Estimate Flag","FalseNegativesEstimateFlag",false },
  {0x0024,0x0046,VR::FL,VM::VM1,"False Negatives Estimate","FalseNegativesEstimate",false },
  {0x0024,0x0048,VR::US,VM::VM1,"Negative Catch Trials Quantity","NegativeCatchTrialsQuantity",false },
  {0x0024,0x0050,VR::US,VM::VM1,"False Negatives Quantity","FalseNegativesQuantity",false },
  {0x0024,0x0051,VR::CS,VM::VM1,"Excessive False Negatives Data Flag","ExcessiveFalseNegativesDataFlag",false },
  {0x0024,0x0052,VR::CS,VM::VM1,"Excessive False Negatives","ExcessiveFalseNegatives",false },
  {0x0024,0x0053,VR::CS,VM::VM1,"False Positives Estimate Flag","FalsePositivesEstimateFlag",false },
  {0x0024,0x0054,VR::FL,VM::VM1,"False Positives Estimate","FalsePositivesEstimate",false },
  {0x0024,0x0055,VR::CS,VM::VM1,"Catch Trials Data Flag","CatchTrialsDataFlag",false },
  {0x0024,0x0056,VR::US,VM::VM1,"Positive Catch Trials Quantity","PositiveCatchTrialsQuantity",false },
  {0x0024,0x0057,VR::CS,VM::VM1,"Test Point Normals Data Flag","TestPointNormalsDataFlag",false },
  {0x0024,0x0058,VR::SQ,VM::VM1,"Test Point Normals Sequence","TestPointNormalsSequence",false },
  {0x0024,0x0059,VR::CS,VM::VM1,"Global Deviation Probability Normals Flag","GlobalDeviationProbabilityNormalsFlag",false },
  {0x0024,0x0060,VR::US,VM::VM1,"False Positives Quantity","FalsePositivesQuantity",false },
  {0x0024,0x0061,VR::CS,VM::VM1,"Excessive False Positives Data Flag","ExcessiveFalsePositivesDataFlag",false },
  {0x0024,0x0062,VR::CS,VM::VM1,"Excessive False Positives","ExcessiveFalsePositives",false },
  {0x0024,0x0063,VR::CS,VM::VM1,"Visual Field Test Normals Flag","VisualFieldTestNormalsFlag",false },
  {0x0024,0x0064,VR::SQ,VM::VM1,"Results Normals Sequence","ResultsNormalsSequence",false },
  {0x0024,0x0065,VR::SQ,VM::VM1,"Age Corrected Sensitivity Deviation Algorithm Sequence","AgeCorrectedSensitivityDeviationAlgorithmSequence",false },
  {0x0024,0x0066,VR::FL,VM::VM1,"Global Deviation From Normal","GlobalDeviationFromNormal",false },
  {0x0024,0x0067,VR::SQ,VM::VM1,"Generalized Defect Sensitivity Deviation Algorithm Sequence","GeneralizedDefectSensitivityDeviationAlgorithmSequence",false },
  {0x0024,0x0068,VR::FL,VM::VM1,"Localized Deviation from Normal","LocalizedDeviationfromNormal",false },
  {0x0024,0x0069,VR::LO,VM::VM1,"Patient Reliability Indicator","PatientReliabilityIndicator",false },
  {0x0024,0x0070,VR::FL,VM::VM1,"Visual Field Mean Sensitivity","VisualFieldMeanSensitivity",false },
  {0x0024,0x0071,VR::FL,VM::VM1,"Global Deviation Probability","GlobalDeviationProbability",false },
  {0x0024,0x0072,VR::CS,VM::VM1,"Local Deviation Probability Normals Flag","LocalDeviationProbabilityNormalsFlag",false },
  {0x0024,0x0073,VR::FL,VM::VM1,"Localized Deviation Probability","LocalizedDeviationProbability",false },
  {0x0024,0x0074,VR::CS,VM::VM1,"Short Term Fluctuation Calculated","ShortTermFluctuationCalculated",false },
  {0x0024,0x0075,VR::FL,VM::VM1,"Short Term Fluctuation","ShortTermFluctuation",false },
  {0x0024,0x0076,VR::CS,VM::VM1,"Short Term Fluctuation Probability Calculated","ShortTermFluctuationProbabilityCalculated",false },
  {0x0024,0x0077,VR::FL,VM::VM1,"Short Term Fluctuation Probability","ShortTermFluctuationProbability",false },
  {0x0024,0x0078,VR::CS,VM::VM1,"Corrected Localized Deviation From Normal Calculated","CorrectedLocalizedDeviationFromNormalCalculated",false },
  {0x0024,0x0079,VR::FL,VM::VM1,"Corrected Localized Deviation From Normal","CorrectedLocalizedDeviationFromNormal",false },
  {0x0024,0x0080,VR::CS,VM::VM1,"Corrected Localized Deviation From Normal Probability Calculated","CorrectedLocalizedDeviationFromNormalProbabilityCalculated",false },
  {0x0024,0x0081,VR::FL,VM::VM1,"Corrected Localized Deviation From Normal Probability","CorrectedLocalizedDeviationFromNormalProbability",false },
  {0x0024,0x0083,VR::SQ,VM::VM1,"Global Deviation Probability Sequence","GlobalDeviationProbabilitySequence",false },
  {0x0024,0x0085,VR::SQ,VM::VM1,"Localized Deviation Probability Sequence","LocalizedDeviationProbabilitySequence",false },
  {0x0024,0x0086,VR::CS,VM::VM1,"Foveal Sensitivity Measured","FovealSensitivityMeasured",false },
  {0x0024,0x0087,VR::FL,VM::VM1,"Foveal Sensitivity","FovealSensitivity",false },
  {0x0024,0x0088,VR::FL,VM::VM1,"Visual Field Test Duration","VisualFieldTestDuration",false },
  {0x0024,0x0089,VR::SQ,VM::VM1,"Visual Field Test Point Sequence","VisualFieldTestPointSequence",false },
  {0x0024,0x0090,VR::FL,VM::VM1,"Visual Field Test Point X-Coordinate","VisualFieldTestPointXCoordinate",false },
  {0x0024,0x0091,VR::FL,VM::VM1,"Visual Field Test Point Y-Coordinate","VisualFieldTestPointYCoordinate",false },
  {0x0024,0x0092,VR::FL,VM::VM1,"Age Corrected Sensitivity Deviation Value","AgeCorrectedSensitivityDeviationValue",false },
  {0x0024,0x0093,VR::CS,VM::VM1,"Stimulus Results","StimulusResults",false },
  {0x0024,0x0094,VR::FL,VM::VM1,"Sensitivity Value","SensitivityValue",false },
  {0x0024,0x0095,VR::CS,VM::VM1,"Retest Stimulus Seen","RetestStimulusSeen",false },
  {0x0024,0x0096,VR::FL,VM::VM1,"Retest Sensitivity Value","RetestSensitivityValue",false },
  {0x0024,0x0097,VR::SQ,VM::VM1,"Visual Field Test Point Normals Sequence","VisualFieldTestPointNormalsSequence",false },
  {0x0024,0x0098,VR::FL,VM::VM1,"Quantified Defect","QuantifiedDefect",false },
  {0x0024,0x0100,VR::FL,VM::VM1,"Age Corrected Sensitivity Deviation Probability Value","AgeCorrectedSensitivityDeviationProbabilityValue",false },
  {0x0024,0x0102,VR::CS,VM::VM1,"Generalized Defect Corrected Sensitivity Deviation Flag","GeneralizedDefectCorrectedSensitivityDeviationFlag",false },
  {0x0024,0x0103,VR::FL,VM::VM1,"Generalized Defect Corrected Sensitivity Deviation Value","GeneralizedDefectCorrectedSensitivityDeviationValue",false },
  {0x0024,0x0104,VR::FL,VM::VM1,"Generalized Defect Corrected Sensitivity Deviation Probability Value","GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue",false },
  {0x0024,0x0105,VR::FL,VM::VM1,"Minimum Sensitivity Value","MinimumSensitivityValue",false },
  {0x0024,0x0106,VR::CS,VM::VM1,"Blind Spot Localized","BlindSpotLocalized",false },
  {0x0024,0x0107,VR::FL,VM::VM1,"Blind Spot X-Coordinate","BlindSpotXCoordinate",false },
  {0x0024,0x0108,VR::FL,VM::VM1,"Blind Spot Y-Coordinate","BlindSpotYCoordinate",false },
  {0x0024,0x0110,VR::SQ,VM::VM1,"Visual Acuity Measurement Sequence","VisualAcuityMeasurementSequence",false },
  {0x0024,0x0112,VR::SQ,VM::VM1,"Refractive Parameters Used on Patient Sequence","RefractiveParametersUsedOnPatientSequence",false },
  {0x0024,0x0113,VR::CS,VM::VM1,"Measurement Laterality","MeasurementLaterality",false },
  {0x0024,0x0114,VR::SQ,VM::VM1,"Ophthalmic Patient Clinical Information Left Eye Sequence","OphthalmicPatientClinicalInformationLeftEyeSequence",false },
  {0x0024,0x0115,VR::SQ,VM::VM1,"Ophthalmic Patient Clinical Information Right Eye Sequence","OphthalmicPatientClinicalInformationRightEyeSequence",false },
  {0x0024,0x0117,VR::CS,VM::VM1,"Foveal Point Normative Data Flag","FovealPointNormativeDataFlag",false },
  {0x0024,0x0118,VR::FL,VM::VM1,"Foveal Point Probability Value","FovealPointProbabilityValue",false },
  {0x0024,0x0120,VR::CS,VM::VM1,"Screening Baseline Measured","ScreeningBaselineMeasured",false },
  {0x0024,0x0122,VR::SQ,VM::VM1,"Screening Baseline Measured Sequence","ScreeningBaselineMeasuredSequence",false },
  {0x0024,0x0124,VR::CS,VM::VM1,"Screening Baseline Type","ScreeningBaselineType",false },
  {0x0024,0x0126,VR::FL,VM::VM1,"Screening Baseline Value","ScreeningBaselineValue",false },
  {0x0024,0x0202,VR::LO,VM::VM1,"Algorithm Source","AlgorithmSource",false },
  {0x0024,0x0306,VR::LO,VM::VM1,"Data Set Name","DataSetName",false },
  {0x0024,0x0307,VR::LO,VM::VM1,"Data Set Version","DataSetVersion",false },
  {0x0024,0x0308,VR::LO,VM::VM1,"Data Set Source","DataSetSource",false },
  {0x0024,0x0309,VR::LO,VM::VM1,"Data Set Description","DataSetDescription",false },
  {0x0024,0x0317,VR::SQ,VM::VM1,"Visual Field Test Reliability Global Index Sequence","VisualFieldTestReliabilityGlobalIndexSequence",false },
  {0x0024,0x0320,VR::SQ,VM::VM1,"Visual Field Global Results Index Sequence","VisualFieldGlobalResultsIndexSequence",false },
  {0x0024,0x0325,VR::SQ,VM::VM1,"Data Observation Sequence","DataObservationSequence",false },
  {0x0024,0x0338,VR::CS,VM::VM1,"Index Normals Flag","IndexNormalsFlag",false },
  {0x0024,0x0341,VR::FL,VM::VM1,"Index Probability","IndexProbability",false },
  {0x0024,0x0344,VR::SQ,VM::VM1,"Index Probability Sequence","IndexProbabilitySequence",false },
  {0x0028,0x0002,VR::US,VM::VM1,"Samples per Pixel","SamplesPerPixel",false },
  {0x0028,0x0003,VR::US,VM::VM1,"Samples per Pixel Used","SamplesPerPixelUsed",false },
  {0x0028,0x0004,VR::CS,VM::VM1,"Photometric Interpretation","PhotometricInterpretation",false },
  {0x0028,0x0005,VR::US,VM::VM1,"Image Dimensions","ImageDimensions",true },
  {0x0028,0x0006,VR::US,VM::VM1,"Planar Configuration","PlanarConfiguration",false },
  {0x0028,0x0008,VR::IS,VM::VM1,"Number of Frames","NumberOfFrames",false },
  {0x0028,0x0009,VR::AT,VM::VM1_n,"Frame Increment Pointer","FrameIncrementPointer",false },
  {0x0028,0x000a,VR::AT,VM::VM1_n,"Frame Dimension Pointer","FrameDimensionPointer",false },
  {0x0028,0x0010,VR::US,VM::VM1,"Rows","Rows",false },
  {0x0028,0x0011,VR::US,VM::VM1,"Columns","Columns",false },
  {0x0028,0x0012,VR::US,VM::VM1,"Planes","Planes",true },
  {0x0028,0x0014,VR::US,VM::VM1,"Ultrasound Color Data Present","UltrasoundColorDataPresent",false },
  {0x0028,0x0020,VR::INVALID,VM::VM0,"","",true },
  {0x0028,0x0030,VR::DS,VM::VM2,"Pixel Spacing","PixelSpacing",false },
  {0x0028,0x0031,VR::DS,VM::VM2,"Zoom Factor","ZoomFactor",false },
  {0x0028,0x0032,VR::DS,VM::VM2,"Zoom Center","ZoomCenter",false },
  {0x0028,0x0034,VR::IS,VM::VM2,"Pixel Aspect Ratio","PixelAspectRatio",false },
  {0x0028,0x0040,VR::CS,VM::VM1,"Image Format","ImageFormat",true },
  {0x0028,0x0050,VR::LO,VM::VM1_n,"Manipulated Image","ManipulatedImage",true },
  {0x0028,0x0051,VR::CS,VM::VM1_n,"Corrected Image","CorrectedImage",false },
  {0x0028,0x005f,VR::LO,VM::VM1,"Compression Recognition Code","CompressionRecognitionCode",true },
  {0x0028,0x0060,VR::CS,VM::VM1,"Compression Code","CompressionCode",true },
  {0x0028,0x0061,VR::SH,VM::VM1,"Compression Originator","CompressionOriginator",true },
  {0x0028,0x0062,VR::LO,VM::VM1,"Compression Label","CompressionLabel",true },
  {0x0028,0x0063,VR::SH,VM::VM1,"Compression Description","CompressionDescription",true },
  {0x0028,0x0065,VR::CS,VM::VM1_n,"Compression Sequence","CompressionSequence",true },
  {0x0028,0x0066,VR::AT,VM::VM1_n,"Compression Step Pointers","CompressionStepPointers",true },
  {0x0028,0x0068,VR::US,VM::VM1,"Repeat Interval","RepeatInterval",true },
  {0x0028,0x0069,VR::US,VM::VM1,"Bits Grouped","BitsGrouped",true },
  {0x0028,0x0070,VR::US,VM::VM1_n,"Perimeter Table","PerimeterTable",true },
  {0x0028,0x0071,VR::US_SS,VM::VM1,"Perimeter Value","PerimeterValue",true },
  {0x0028,0x0080,VR::US,VM::VM1,"Predictor Rows","PredictorRows",true },
  {0x0028,0x0081,VR::US,VM::VM1,"Predictor Columns","PredictorColumns",true },
  {0x0028,0x0082,VR::US,VM::VM1_n,"Predictor Constants","PredictorConstants",true },
  {0x0028,0x0090,VR::CS,VM::VM1,"Blocked Pixels","BlockedPixels",true },
  {0x0028,0x0091,VR::US,VM::VM1,"Block Rows","BlockRows",true },
  {0x0028,0x0092,VR::US,VM::VM1,"Block Columns","BlockColumns",true },
  {0x0028,0x0093,VR::US,VM::VM1,"Row Overlap","RowOverlap",true },
  {0x0028,0x0094,VR::US,VM::VM1,"Column Overlap","ColumnOverlap",true },
  {0x0028,0x0100,VR::US,VM::VM1,"Bits Allocated","BitsAllocated",false },
  {0x0028,0x0101,VR::US,VM::VM1,"Bits Stored","BitsStored",false },
  {0x0028,0x0102,VR::US,VM::VM1,"High Bit","HighBit",false },
  {0x0028,0x0103,VR::US,VM::VM1,"Pixel Representation","PixelRepresentation",false },
  {0x0028,0x0104,VR::US_SS,VM::VM1,"Smallest Valid Pixel Value","SmallestValidPixelValue",true },
  {0x0028,0x0105,VR::US_SS,VM::VM1,"Largest Valid Pixel Value","LargestValidPixelValue",true },
  {0x0028,0x0106,VR::US_SS,VM::VM1,"Smallest Image Pixel Value","SmallestImagePixelValue",false },
  {0x0028,0x0107,VR::US_SS,VM::VM1,"Largest Image Pixel Value","LargestImagePixelValue",false },
  {0x0028,0x0108,VR::US_SS,VM::VM1,"Smallest Pixel Value in Series","SmallestPixelValueInSeries",false },
  {0x0028,0x0109,VR::US_SS,VM::VM1,"Largest Pixel Value in Series","LargestPixelValueInSeries",false },
  {0x0028,0x0110,VR::US_SS,VM::VM1,"Smallest Image Pixel Value in Plane","SmallestImagePixelValueInPlane",true },
  {0x0028,0x0111,VR::US_SS,VM::VM1,"Largest Image Pixel Value in Plane","LargestImagePixelValueInPlane",true },
  {0x0028,0x0120,VR::US_SS,VM::VM1,"Pixel Padding Value","PixelPaddingValue",false },
  {0x0028,0x0121,VR::US_SS,VM::VM1,"Pixel Padding Range Limit","PixelPaddingRangeLimit",false },
  {0x0028,0x0200,VR::US,VM::VM1,"Image Location","ImageLocation",true },
  {0x0028,0x0300,VR::CS,VM::VM1,"Quality Control Image","QualityControlImage",false },
  {0x0028,0x0301,VR::CS,VM::VM1,"Burned In Annotation","BurnedInAnnotation",false },
  {0x0028,0x0302,VR::CS,VM::VM1,"Recognizable Visual Features","RecognizableVisualFeatures",false },
  {0x0028,0x0303,VR::CS,VM::VM1,"Longitudinal Temporal Information Modified","LongitudinalTemporalInformationModified",false },
  {0x0028,0x0304,VR::UI,VM::VM1,"Referenced Color Palette Instance UID","ReferencedColorPaletteInstanceUID",false },
  {0x0028,0x0400,VR::LO,VM::VM1,"Transform Label","TransformLabel",true },
  {0x0028,0x0401,VR::LO,VM::VM1,"Transform Version Number","TransformVersionNumber",true },
  {0x0028,0x0402,VR::US,VM::VM1,"Number of Transform Steps","NumberOfTransformSteps",true },
  {0x0028,0x0403,VR::LO,VM::VM1_n,"Sequence of Compressed Data","SequenceOfCompressedData",true },
  {0x0028,0x0404,VR::AT,VM::VM1_n,"Details of Coefficients","DetailsOfCoefficients",true },
  {0x0028,0x0700,VR::LO,VM::VM1,"DCT Label","DCTLabel",true },
  {0x0028,0x0701,VR::CS,VM::VM1_n,"Data Block Description","DataBlockDescription",true },
  {0x0028,0x0702,VR::AT,VM::VM1_n,"Data Block","DataBlock",true },
  {0x0028,0x0710,VR::US,VM::VM1,"Normalization Factor Format","NormalizationFactorFormat",true },
  {0x0028,0x0720,VR::US,VM::VM1,"Zonal Map Number Format","ZonalMapNumberFormat",true },
  {0x0028,0x0721,VR::AT,VM::VM1_n,"Zonal Map Location","ZonalMapLocation",true },
  {0x0028,0x0722,VR::US,VM::VM1,"Zonal Map Format","ZonalMapFormat",true },
  {0x0028,0x0730,VR::US,VM::VM1,"Adaptive Map Format","AdaptiveMapFormat",true },
  {0x0028,0x0740,VR::US,VM::VM1,"Code Number Format","CodeNumberFormat",true },
  {0x0028,0x0a02,VR::CS,VM::VM1,"Pixel Spacing Calibration Type","PixelSpacingCalibrationType",false },
  {0x0028,0x0a04,VR::LO,VM::VM1,"Pixel Spacing Calibration Description","PixelSpacingCalibrationDescription",false },
  {0x0028,0x1040,VR::CS,VM::VM1,"Pixel Intensity Relationship","PixelIntensityRelationship",false },
  {0x0028,0x1041,VR::SS,VM::VM1,"Pixel Intensity Relationship Sign","PixelIntensityRelationshipSign",false },
  {0x0028,0x1050,VR::DS,VM::VM1_n,"Window Center","WindowCenter",false },
  {0x0028,0x1051,VR::DS,VM::VM1_n,"Window Width","WindowWidth",false },
  {0x0028,0x1052,VR::DS,VM::VM1,"Rescale Intercept","RescaleIntercept",false },
  {0x0028,0x1053,VR::DS,VM::VM1,"Rescale Slope","RescaleSlope",false },
  {0x0028,0x1054,VR::LO,VM::VM1,"Rescale Type","RescaleType",false },
  {0x0028,0x1055,VR::LO,VM::VM1_n,"Window Center & Width Explanation","WindowCenterWidthExplanation",false },
  {0x0028,0x1056,VR::CS,VM::VM1,"VOI LUT Function","VOILUTFunction",false },
  {0x0028,0x1080,VR::CS,VM::VM1,"Gray Scale","GrayScale",true },
  {0x0028,0x1090,VR::CS,VM::VM1,"Recommended Viewing Mode","RecommendedViewingMode",false },
  {0x0028,0x1100,VR::US_SS,VM::VM3,"Gray Lookup Table Descriptor","GrayLookupTableDescriptor",true },
  {0x0028,0x1101,VR::US_SS,VM::VM3,"Red Palette Color Lookup Table Descriptor","RedPaletteColorLookupTableDescriptor",false },
  {0x0028,0x1102,VR::US_SS,VM::VM3,"Green Palette Color Lookup Table Descriptor","GreenPaletteColorLookupTableDescriptor",false },
  {0x0028,0x1103,VR::US_SS,VM::VM3,"Blue Palette Color Lookup Table Descriptor","BluePaletteColorLookupTableDescriptor",false },
  {0x0028,0x1104,VR::US,VM::VM3,"Alpha Palette Color Lookup Table Descriptor","AlphaPaletteColorLookupTableDescriptor",false },
  {0x0028,0x1111,VR::US_SS,VM::VM4,"Large Red Palette Color Lookup Table Descriptor","LargeRedPaletteColorLookupTableDescriptor",true },
  {0x0028,0x1112,VR::US_SS,VM::VM4,"Large Green Palette Color Lookup Table Descriptor","LargeGreenPaletteColorLookupTableDescriptor",true },
  {0x0028,0x1113,VR::US_SS,VM::VM4,"Large Blue Palette Color Lookup Table Descriptor","LargeBluePaletteColorLookupTableDescriptor",true },
  {0x0028,0x1199,VR::UI,VM::VM1,"Palette Color Lookup Table UID","PaletteColorLookupTableUID",false },
  {0x0028,0x1200,VR::US_SS_OW,VM::VM1_n,"Gray Lookup Table Data","GrayLookupTableData",true },
  {0x0028,0x1201,VR::OW,VM::VM1,"Red Palette Color Lookup Table Data","RedPaletteColorLookupTableData",false },
  {0x0028,0x1202,VR::OW,VM::VM1,"Green Palette Color Lookup Table Data","GreenPaletteColorLookupTableData",false },
  {0x0028,0x1203,VR::OW,VM::VM1,"Blue Palette Color Lookup Table Data","BluePaletteColorLookupTableData",false },
  {0x0028,0x1204,VR::OW,VM::VM1,"Alpha Palette Color Lookup Table Data","AlphaPaletteColorLookupTableData",false },
  {0x0028,0x1211,VR::OW,VM::VM1,"Large Red Palette Color Lookup Table Data","LargeRedPaletteColorLookupTableData",true },
  {0x0028,0x1212,VR::OW,VM::VM1,"Large Green Palette Color Lookup Table Data","LargeGreenPaletteColorLookupTableData",true },
  {0x0028,0x1213,VR::OW,VM::VM1,"Large Blue Palette Color Lookup Table Data","LargeBluePaletteColorLookupTableData",true },
  {0x0028,0x1214,VR::UI,VM::VM1,"Large Palette Color Lookup Table UID","LargePaletteColorLookupTableUID",true },
  {0x0028,0x1221,VR::OW,VM::VM1,"Segmented Red Palette Color Lookup Table Data","SegmentedRedPaletteColorLookupTableData",false },
  {0x0028,0x1222,VR::OW,VM::VM1,"Segmented Green Palette Color Lookup Table Data","SegmentedGreenPaletteColorLookupTableData",false },
  {0x0028,0x1223,VR::OW,VM::VM1,"Segmented Blue Palette Color Lookup Table Data","SegmentedBluePaletteColorLookupTableData",false },
  {0x0028,0x1300,VR::CS,VM::VM1,"Breast Implant Present","BreastImplantPresent",false },
  {0x0028,0x1350,VR::CS,VM::VM1,"Partial View","PartialView",false },
  {0x0028,0x1351,VR::ST,VM::VM1,"Partial View Description","PartialViewDescription",false },
  {0x0028,0x1352,VR::SQ,VM::VM1,"Partial View Code Sequence","PartialViewCodeSequence",false },
  {0x0028,0x135a,VR::CS,VM::VM1,"Spatial Locations Preserved","SpatialLocationsPreserved",false },
  {0x0028,0x1401,VR::SQ,VM::VM1,"Data Frame Assignment Sequence","DataFrameAssignmentSequence",false },
  {0x0028,0x1402,VR::CS,VM::VM1,"Data Path Assignment","DataPathAssignment",false },
  {0x0028,0x1403,VR::US,VM::VM1,"Bits Mapped to Color Lookup Table","BitsMappedToColorLookupTable",false },
  {0x0028,0x1404,VR::SQ,VM::VM1,"Blending LUT 1 Sequence","BlendingLUT1Sequence",false },
  {0x0028,0x1405,VR::CS,VM::VM1,"Blending LUT 1 Transfer Function","BlendingLUT1TransferFunction",false },
  {0x0028,0x1406,VR::FD,VM::VM1,"Blending Weight Constant","BlendingWeightConstant",false },
  {0x0028,0x1407,VR::US,VM::VM3,"Blending Lookup Table Descriptor","BlendingLookupTableDescriptor",false },
  {0x0028,0x1408,VR::OW,VM::VM1,"Blending Lookup Table Data","BlendingLookupTableData",false },
  {0x0028,0x140b,VR::SQ,VM::VM1,"Enhanced Palette Color Lookup Table Sequence","EnhancedPaletteColorLookupTableSequence",false },
  {0x0028,0x140c,VR::SQ,VM::VM1,"Blending LUT 2 Sequence","BlendingLUT2Sequence",false },
  {0x0028,0x140d,VR::CS,VM::VM1,"Blending LUT 2 Transfer Function","BlendingLUT2TransferFunction",false },
  {0x0028,0x140e,VR::CS,VM::VM1,"Data Path ID","DataPathID",false },
  {0x0028,0x140f,VR::CS,VM::VM1,"RGB LUT Transfer Function","RGBLUTTransferFunction",false },
  {0x0028,0x1410,VR::CS,VM::VM1,"Alpha LUT Transfer Function","AlphaLUTTransferFunction",false },
  {0x0028,0x2000,VR::OB,VM::VM1,"ICC Profile","ICCProfile",false },
  {0x0028,0x2110,VR::CS,VM::VM1,"Lossy Image Compression","LossyImageCompression",false },
  {0x0028,0x2112,VR::DS,VM::VM1_n,"Lossy Image Compression Ratio","LossyImageCompressionRatio",false },
  {0x0028,0x2114,VR::CS,VM::VM1_n,"Lossy Image Compression Method","LossyImageCompressionMethod",false },
  {0x0028,0x3000,VR::SQ,VM::VM1,"Modality LUT Sequence","ModalityLUTSequence",false },
  {0x0028,0x3002,VR::US_SS,VM::VM3,"LUT Descriptor","LUTDescriptor",false },
  {0x0028,0x3003,VR::LO,VM::VM1,"LUT Explanation","LUTExplanation",false },
  {0x0028,0x3004,VR::LO,VM::VM1,"Modality LUT Type","ModalityLUTType",false },
  {0x0028,0x3006,VR::US_SS_OW,VM::VM1_n,"LUT Data","LUTData",false },
  {0x0028,0x3010,VR::SQ,VM::VM1,"VOI LUT Sequence","VOILUTSequence",false },
  {0x0028,0x3110,VR::SQ,VM::VM1,"Softcopy VOI LUT Sequence","SoftcopyVOILUTSequence",false },
  {0x0028,0x4000,VR::LT,VM::VM1,"Image Presentation Comments","ImagePresentationComments",true },
  {0x0028,0x5000,VR::SQ,VM::VM1,"Bi-Plane Acquisition Sequence","BiPlaneAcquisitionSequence",true },
  {0x0028,0x6010,VR::US,VM::VM1,"Representative Frame Number","RepresentativeFrameNumber",false },
  {0x0028,0x6020,VR::US,VM::VM1_n,"Frame Numbers of Interest (FOI)","FrameNumbersOfInterest",false },
  {0x0028,0x6022,VR::LO,VM::VM1_n,"Frame of Interest Description","FrameOfInterestDescription",false },
  {0x0028,0x6023,VR::CS,VM::VM1_n,"Frame of Interest Type","FrameOfInterestType",false },
  {0x0028,0x6030,VR::US,VM::VM1_n,"Mask Pointer(s)","MaskPointers",true },
  {0x0028,0x6040,VR::US,VM::VM1_n,"R Wave Pointer","RWavePointer",false },
  {0x0028,0x6100,VR::SQ,VM::VM1,"Mask Subtraction Sequence","MaskSubtractionSequence",false },
  {0x0028,0x6101,VR::CS,VM::VM1,"Mask Operation","MaskOperation",false },
  {0x0028,0x6102,VR::US,VM::VM2_2n,"Applicable Frame Range","ApplicableFrameRange",false },
  {0x0028,0x6110,VR::US,VM::VM1_n,"Mask Frame Numbers","MaskFrameNumbers",false },
  {0x0028,0x6112,VR::US,VM::VM1,"Contrast Frame Averaging","ContrastFrameAveraging",false },
  {0x0028,0x6114,VR::FL,VM::VM2,"Mask Sub-pixel Shift","MaskSubPixelShift",false },
  {0x0028,0x6120,VR::SS,VM::VM1,"TID Offset","TIDOffset",false },
  {0x0028,0x6190,VR::ST,VM::VM1,"Mask Operation Explanation","MaskOperationExplanation",false },
  {0x0028,0x7fe0,VR::UT,VM::VM1,"Pixel Data Provider URL","PixelDataProviderURL",false },
  {0x0028,0x9001,VR::UL,VM::VM1,"Data Point Rows","DataPointRows",false },
  {0x0028,0x9002,VR::UL,VM::VM1,"Data Point Columns","DataPointColumns",false },
  {0x0028,0x9003,VR::CS,VM::VM1,"Signal Domain Columns","SignalDomainColumns",false },
  {0x0028,0x9099,VR::US,VM::VM1,"Largest Monochrome Pixel Value","LargestMonochromePixelValue",true },
  {0x0028,0x9108,VR::CS,VM::VM1,"Data Representation","DataRepresentation",false },
  {0x0028,0x9110,VR::SQ,VM::VM1,"Pixel Measures Sequence","PixelMeasuresSequence",false },
  {0x0028,0x9132,VR::SQ,VM::VM1,"Frame VOI LUT Sequence","FrameVOILUTSequence",false },
  {0x0028,0x9145,VR::SQ,VM::VM1,"Pixel Value Transformation Sequence","PixelValueTransformationSequence",false },
  {0x0028,0x9235,VR::CS,VM::VM1,"Signal Domain Rows","SignalDomainRows",false },
  {0x0028,0x9411,VR::FL,VM::VM1,"Display Filter Percentage","DisplayFilterPercentage",false },
  {0x0028,0x9415,VR::SQ,VM::VM1,"Frame Pixel Shift Sequence","FramePixelShiftSequence",false },
  {0x0028,0x9416,VR::US,VM::VM1,"Subtraction Item ID","SubtractionItemID",false },
  {0x0028,0x9422,VR::SQ,VM::VM1,"Pixel Intensity Relationship LUT Sequence","PixelIntensityRelationshipLUTSequence",false },
  {0x0028,0x9443,VR::SQ,VM::VM1,"Frame Pixel Data Properties Sequence","FramePixelDataPropertiesSequence",false },
  {0x0028,0x9444,VR::CS,VM::VM1,"Geometrical Properties","GeometricalProperties",false },
  {0x0028,0x9445,VR::FL,VM::VM1,"Geometric Maximum Distortion","GeometricMaximumDistortion",false },
  {0x0028,0x9446,VR::CS,VM::VM1_n,"Image Processing Applied","ImageProcessingApplied",false },
  {0x0028,0x9454,VR::CS,VM::VM1,"Mask Selection Mode","MaskSelectionMode",false },
  {0x0028,0x9474,VR::CS,VM::VM1,"LUT Function","LUTFunction",false },
  {0x0028,0x9478,VR::FL,VM::VM1,"Mask Visibility Percentage","MaskVisibilityPercentage",false },
  {0x0028,0x9501,VR::SQ,VM::VM1,"Pixel Shift Sequence","PixelShiftSequence",false },
  {0x0028,0x9502,VR::SQ,VM::VM1,"Region Pixel Shift Sequence","RegionPixelShiftSequence",false },
  {0x0028,0x9503,VR::SS,VM::VM2_2n,"Vertices of the Region","VerticesOfTheRegion",false },
  {0x0028,0x9505,VR::SQ,VM::VM1,"Multi-frame Presentation Sequence","MultiFramePresentationSequence",false },
  {0x0028,0x9506,VR::US,VM::VM2_2n,"Pixel Shift Frame Range","PixelShiftFrameRange",false },
  {0x0028,0x9507,VR::US,VM::VM2_2n,"LUT Frame Range","LUTFrameRange",false },
  {0x0028,0x9520,VR::DS,VM::VM16,"Image to Equipment Mapping Matrix","ImageToEquipmentMappingMatrix",false },
  {0x0028,0x9537,VR::CS,VM::VM1,"Equipment Coordinate System Identification","EquipmentCoordinateSystemIdentification",false },
  {0x0032,0x000a,VR::CS,VM::VM1,"Study Status ID","StudyStatusID",true },
  {0x0032,0x000c,VR::CS,VM::VM1,"Study Priority ID","StudyPriorityID",true },
  {0x0032,0x0012,VR::LO,VM::VM1,"Study ID Issuer","StudyIDIssuer",true },
  {0x0032,0x0032,VR::DA,VM::VM1,"Study Verified Date","StudyVerifiedDate",true },
  {0x0032,0x0033,VR::TM,VM::VM1,"Study Verified Time","StudyVerifiedTime",true },
  {0x0032,0x0034,VR::DA,VM::VM1,"Study Read Date","StudyReadDate",true },
  {0x0032,0x0035,VR::TM,VM::VM1,"Study Read Time","StudyReadTime",true },
  {0x0032,0x1000,VR::DA,VM::VM1,"Scheduled Study Start Date","ScheduledStudyStartDate",true },
  {0x0032,0x1001,VR::TM,VM::VM1,"Scheduled Study Start Time","ScheduledStudyStartTime",true },
  {0x0032,0x1010,VR::DA,VM::VM1,"Scheduled Study Stop Date","ScheduledStudyStopDate",true },
  {0x0032,0x1011,VR::TM,VM::VM1,"Scheduled Study Stop Time","ScheduledStudyStopTime",true },
  {0x0032,0x1020,VR::LO,VM::VM1,"Scheduled Study Location","ScheduledStudyLocation",true },
  {0x0032,0x1021,VR::AE,VM::VM1_n,"Scheduled Study Location AE Title","ScheduledStudyLocationAETitle",true },
  {0x0032,0x1030,VR::LO,VM::VM1,"Reason for Study","ReasonForStudy",true },
  {0x0032,0x1031,VR::SQ,VM::VM1,"Requesting Physician Identification Sequence","RequestingPhysicianIdentificationSequence",false },
  {0x0032,0x1032,VR::PN,VM::VM1,"Requesting Physician","RequestingPhysician",false },
  {0x0032,0x1033,VR::LO,VM::VM1,"Requesting Service","RequestingService",false },
  {0x0032,0x1034,VR::SQ,VM::VM1,"Requesting Service Code Sequence","RequestingServiceCodeSequence",false },
  {0x0032,0x1040,VR::DA,VM::VM1,"Study Arrival Date","StudyArrivalDate",true },
  {0x0032,0x1041,VR::TM,VM::VM1,"Study Arrival Time","StudyArrivalTime",true },
  {0x0032,0x1050,VR::DA,VM::VM1,"Study Completion Date","StudyCompletionDate",true },
  {0x0032,0x1051,VR::TM,VM::VM1,"Study Completion Time","StudyCompletionTime",true },
  {0x0032,0x1055,VR::CS,VM::VM1,"Study Component Status ID","StudyComponentStatusID",true },
  {0x0032,0x1060,VR::LO,VM::VM1,"Requested Procedure Description","RequestedProcedureDescription",false },
  {0x0032,0x1064,VR::SQ,VM::VM1,"Requested Procedure Code Sequence","RequestedProcedureCodeSequence",false },
  {0x0032,0x1070,VR::LO,VM::VM1,"Requested Contrast Agent","RequestedContrastAgent",false },
  {0x0032,0x4000,VR::LT,VM::VM1,"Study Comments","StudyComments",true },
  {0x0038,0x0004,VR::SQ,VM::VM1,"Referenced Patient Alias Sequence","ReferencedPatientAliasSequence",false },
  {0x0038,0x0008,VR::CS,VM::VM1,"Visit Status ID","VisitStatusID",false },
  {0x0038,0x0010,VR::LO,VM::VM1,"Admission ID","AdmissionID",false },
  {0x0038,0x0011,VR::LO,VM::VM1,"Issuer of Admission ID","IssuerOfAdmissionID",true },
  {0x0038,0x0014,VR::SQ,VM::VM1,"Issuer of Admission ID Sequence","IssuerOfAdmissionIDSequence",false },
  {0x0038,0x0016,VR::LO,VM::VM1,"Route of Admissions","RouteOfAdmissions",false },
  {0x0038,0x001a,VR::DA,VM::VM1,"Scheduled Admission Date","ScheduledAdmissionDate",true },
  {0x0038,0x001b,VR::TM,VM::VM1,"Scheduled Admission Time","ScheduledAdmissionTime",true },
  {0x0038,0x001c,VR::DA,VM::VM1,"Scheduled Discharge Date","ScheduledDischargeDate",true },
  {0x0038,0x001d,VR::TM,VM::VM1,"Scheduled Discharge Time","ScheduledDischargeTime",true },
  {0x0038,0x001e,VR::LO,VM::VM1,"Scheduled Patient Institution Residence","ScheduledPatientInstitutionResidence",true },
  {0x0038,0x0020,VR::DA,VM::VM1,"Admitting Date","AdmittingDate",false },
  {0x0038,0x0021,VR::TM,VM::VM1,"Admitting Time","AdmittingTime",false },
  {0x0038,0x0030,VR::DA,VM::VM1,"Discharge Date","DischargeDate",true },
  {0x0038,0x0032,VR::TM,VM::VM1,"Discharge Time","DischargeTime",true },
  {0x0038,0x0040,VR::LO,VM::VM1,"Discharge Diagnosis Description","DischargeDiagnosisDescription",true },
  {0x0038,0x0044,VR::SQ,VM::VM1,"Discharge Diagnosis Code Sequence","DischargeDiagnosisCodeSequence",true },
  {0x0038,0x0050,VR::LO,VM::VM1,"Special Needs","SpecialNeeds",false },
  {0x0038,0x0060,VR::LO,VM::VM1,"Service Episode ID","ServiceEpisodeID",false },
  {0x0038,0x0061,VR::LO,VM::VM1,"Issuer of Service Episode ID","IssuerOfServiceEpisodeID",true },
  {0x0038,0x0062,VR::LO,VM::VM1,"Service Episode Description","ServiceEpisodeDescription",false },
  {0x0038,0x0064,VR::SQ,VM::VM1,"Issuer of Service Episode ID Sequence","IssuerOfServiceEpisodeIDSequence",false },
  {0x0038,0x0100,VR::SQ,VM::VM1,"Pertinent Documents Sequence","PertinentDocumentsSequence",false },
  {0x0038,0x0300,VR::LO,VM::VM1,"Current Patient Location","CurrentPatientLocation",false },
  {0x0038,0x0400,VR::LO,VM::VM1,"Patient's Institution Residence","PatientInstitutionResidence",false },
  {0x0038,0x0500,VR::LO,VM::VM1,"Patient State","PatientState",false },
  {0x0038,0x0502,VR::SQ,VM::VM1,"Patient Clinical Trial Participation Sequence","PatientClinicalTrialParticipationSequence",false },
  {0x0038,0x4000,VR::LT,VM::VM1,"Visit Comments","VisitComments",false },
  {0x003a,0x0004,VR::CS,VM::VM1,"Waveform Originality","WaveformOriginality",false },
  {0x003a,0x0005,VR::US,VM::VM1,"Number of Waveform Channels","NumberOfWaveformChannels",false },
  {0x003a,0x0010,VR::UL,VM::VM1,"Number of Waveform Samples","NumberOfWaveformSamples",false },
  {0x003a,0x001a,VR::DS,VM::VM1,"Sampling Frequency","SamplingFrequency",false },
  {0x003a,0x0020,VR::SH,VM::VM1,"Multiplex Group Label","MultiplexGroupLabel",false },
  {0x003a,0x0200,VR::SQ,VM::VM1,"Channel Definition Sequence","ChannelDefinitionSequence",false },
  {0x003a,0x0202,VR::IS,VM::VM1,"Waveform Channel Number","WaveformChannelNumber",false },
  {0x003a,0x0203,VR::SH,VM::VM1,"Channel Label","ChannelLabel",false },
  {0x003a,0x0205,VR::CS,VM::VM1_n,"Channel Status","ChannelStatus",false },
  {0x003a,0x0208,VR::SQ,VM::VM1,"Channel Source Sequence","ChannelSourceSequence",false },
  {0x003a,0x0209,VR::SQ,VM::VM1,"Channel Source Modifiers Sequence","ChannelSourceModifiersSequence",false },
  {0x003a,0x020a,VR::SQ,VM::VM1,"Source Waveform Sequence","SourceWaveformSequence",false },
  {0x003a,0x020c,VR::LO,VM::VM1,"Channel Derivation Description","ChannelDerivationDescription",false },
  {0x003a,0x0210,VR::DS,VM::VM1,"Channel Sensitivity","ChannelSensitivity",false },
  {0x003a,0x0211,VR::SQ,VM::VM1,"Channel Sensitivity Units Sequence","ChannelSensitivityUnitsSequence",false },
  {0x003a,0x0212,VR::DS,VM::VM1,"Channel Sensitivity Correction Factor","ChannelSensitivityCorrectionFactor",false },
  {0x003a,0x0213,VR::DS,VM::VM1,"Channel Baseline","ChannelBaseline",false },
  {0x003a,0x0214,VR::DS,VM::VM1,"Channel Time Skew","ChannelTimeSkew",false },
  {0x003a,0x0215,VR::DS,VM::VM1,"Channel Sample Skew","ChannelSampleSkew",false },
  {0x003a,0x0218,VR::DS,VM::VM1,"Channel Offset","ChannelOffset",false },
  {0x003a,0x021a,VR::US,VM::VM1,"Waveform Bits Stored","WaveformBitsStored",false },
  {0x003a,0x0220,VR::DS,VM::VM1,"Filter Low Frequency","FilterLowFrequency",false },
  {0x003a,0x0221,VR::DS,VM::VM1,"Filter High Frequency","FilterHighFrequency",false },
  {0x003a,0x0222,VR::DS,VM::VM1,"Notch Filter Frequency","NotchFilterFrequency",false },
  {0x003a,0x0223,VR::DS,VM::VM1,"Notch Filter Bandwidth","NotchFilterBandwidth",false },
  {0x003a,0x0230,VR::FL,VM::VM1,"Waveform Data Display Scale","WaveformDataDisplayScale",false },
  {0x003a,0x0231,VR::US,VM::VM3,"Waveform Display Background CIELab Value","WaveformDisplayBackgroundCIELabValue",false },
  {0x003a,0x0240,VR::SQ,VM::VM1,"Waveform Presentation Group Sequence","WaveformPresentationGroupSequence",false },
  {0x003a,0x0241,VR::US,VM::VM1,"Presentation Group Number","PresentationGroupNumber",false },
  {0x003a,0x0242,VR::SQ,VM::VM1,"Channel Display Sequence","ChannelDisplaySequence",false },
  {0x003a,0x0244,VR::US,VM::VM3,"Channel Recommended Display CIELab Value","ChannelRecommendedDisplayCIELabValue",false },
  {0x003a,0x0245,VR::FL,VM::VM1,"Channel Position","ChannelPosition",false },
  {0x003a,0x0246,VR::CS,VM::VM1,"Display Shading Flag","DisplayShadingFlag",false },
  {0x003a,0x0247,VR::FL,VM::VM1,"Fractional Channel Display Scale","FractionalChannelDisplayScale",false },
  {0x003a,0x0248,VR::FL,VM::VM1,"Absolute Channel Display Scale","AbsoluteChannelDisplayScale",false },
  {0x003a,0x0300,VR::SQ,VM::VM1,"Multiplexed Audio Channels Description Code Sequence","MultiplexedAudioChannelsDescriptionCodeSequence",false },
  {0x003a,0x0301,VR::IS,VM::VM1,"Channel Identification Code","ChannelIdentificationCode",false },
  {0x003a,0x0302,VR::CS,VM::VM1,"Channel Mode","ChannelMode",false },
  {0x0040,0x0001,VR::AE,VM::VM1_n,"Scheduled Station AE Title","ScheduledStationAETitle",false },
  {0x0040,0x0002,VR::DA,VM::VM1,"Scheduled Procedure Step Start Date","ScheduledProcedureStepStartDate",false },
  {0x0040,0x0003,VR::TM,VM::VM1,"Scheduled Procedure Step Start Time","ScheduledProcedureStepStartTime",false },
  {0x0040,0x0004,VR::DA,VM::VM1,"Scheduled Procedure Step End Date","ScheduledProcedureStepEndDate",false },
  {0x0040,0x0005,VR::TM,VM::VM1,"Scheduled Procedure Step End Time","ScheduledProcedureStepEndTime",false },
  {0x0040,0x0006,VR::PN,VM::VM1,"Scheduled Performing Physician's Name","ScheduledPerformingPhysicianName",false },
  {0x0040,0x0007,VR::LO,VM::VM1,"Scheduled Procedure Step Description","ScheduledProcedureStepDescription",false },
  {0x0040,0x0008,VR::SQ,VM::VM1,"Scheduled Protocol Code Sequence","ScheduledProtocolCodeSequence",false },
  {0x0040,0x0009,VR::SH,VM::VM1,"Scheduled Procedure Step ID","ScheduledProcedureStepID",false },
  {0x0040,0x000a,VR::SQ,VM::VM1,"Stage Code Sequence","StageCodeSequence",false },
  {0x0040,0x000b,VR::SQ,VM::VM1,"Scheduled Performing Physician Identification Sequence","ScheduledPerformingPhysicianIdentificationSequence",false },
  {0x0040,0x0010,VR::SH,VM::VM1_n,"Scheduled Station Name","ScheduledStationName",false },
  {0x0040,0x0011,VR::SH,VM::VM1,"Scheduled Procedure Step Location","ScheduledProcedureStepLocation",false },
  {0x0040,0x0012,VR::LO,VM::VM1,"Pre-Medication","PreMedication",false },
  {0x0040,0x0020,VR::CS,VM::VM1,"Scheduled Procedure Step Status","ScheduledProcedureStepStatus",false },
  {0x0040,0x0026,VR::SQ,VM::VM1,"Order Placer Identifier Sequence","OrderPlacerIdentifierSequence",false },
  {0x0040,0x0027,VR::SQ,VM::VM1,"Order Filler Identifier Sequence","OrderFillerIdentifierSequence",false },
  {0x0040,0x0031,VR::UT,VM::VM1,"Local Namespace Entity ID","LocalNamespaceEntityID",false },
  {0x0040,0x0032,VR::UT,VM::VM1,"Universal Entity ID","UniversalEntityID",false },
  {0x0040,0x0033,VR::CS,VM::VM1,"Universal Entity ID Type","UniversalEntityIDType",false },
  {0x0040,0x0035,VR::CS,VM::VM1,"Identifier Type Code","IdentifierTypeCode",false },
  {0x0040,0x0036,VR::SQ,VM::VM1,"Assigning Facility Sequence","AssigningFacilitySequence",false },
  {0x0040,0x0039,VR::SQ,VM::VM1,"Assigning Jurisdiction Code Sequence","AssigningJurisdictionCodeSequence",false },
  {0x0040,0x003a,VR::SQ,VM::VM1,"Assigning Agency or Department Code Sequence","AssigningAgencyOrDepartmentCodeSequence",false },
  {0x0040,0x0100,VR::SQ,VM::VM1,"Scheduled Procedure Step Sequence","ScheduledProcedureStepSequence",false },
  {0x0040,0x0220,VR::SQ,VM::VM1,"Referenced Non-Image Composite SOP Instance Sequence","ReferencedNonImageCompositeSOPInstanceSequence",false },
  {0x0040,0x0241,VR::AE,VM::VM1,"Performed Station AE Title","PerformedStationAETitle",false },
  {0x0040,0x0242,VR::SH,VM::VM1,"Performed Station Name","PerformedStationName",false },
  {0x0040,0x0243,VR::SH,VM::VM1,"Performed Location","PerformedLocation",false },
  {0x0040,0x0244,VR::DA,VM::VM1,"Performed Procedure Step Start Date","PerformedProcedureStepStartDate",false },
  {0x0040,0x0245,VR::TM,VM::VM1,"Performed Procedure Step Start Time","PerformedProcedureStepStartTime",false },
  {0x0040,0x0250,VR::DA,VM::VM1,"Performed Procedure Step End Date","PerformedProcedureStepEndDate",false },
  {0x0040,0x0251,VR::TM,VM::VM1,"Performed Procedure Step End Time","PerformedProcedureStepEndTime",false },
  {0x0040,0x0252,VR::CS,VM::VM1,"Performed Procedure Step Status","PerformedProcedureStepStatus",false },
  {0x0040,0x0253,VR::SH,VM::VM1,"Performed Procedure Step ID","PerformedProcedureStepID",false },
  {0x0040,0x0254,VR::LO,VM::VM1,"Performed Procedure Step Description","PerformedProcedureStepDescription",false },
  {0x0040,0x0255,VR::LO,VM::VM1,"Performed Procedure Type Description","PerformedProcedureTypeDescription",false },
  {0x0040,0x0260,VR::SQ,VM::VM1,"Performed Protocol Code Sequence","PerformedProtocolCodeSequence",false },
  {0x0040,0x0261,VR::CS,VM::VM1,"Performed Protocol Type","PerformedProtocolType",false },
  {0x0040,0x0270,VR::SQ,VM::VM1,"Scheduled Step Attributes Sequence","ScheduledStepAttributesSequence",false },
  {0x0040,0x0275,VR::SQ,VM::VM1,"Request Attributes Sequence","RequestAttributesSequence",false },
  {0x0040,0x0280,VR::ST,VM::VM1,"Comments on the Performed Procedure Step","CommentsOnThePerformedProcedureStep",false },
  {0x0040,0x0281,VR::SQ,VM::VM1,"Performed Procedure Step Discontinuation Reason Code Sequence","PerformedProcedureStepDiscontinuationReasonCodeSequence",false },
  {0x0040,0x0293,VR::SQ,VM::VM1,"Quantity Sequence","QuantitySequence",false },
  {0x0040,0x0294,VR::DS,VM::VM1,"Quantity","Quantity",false },
  {0x0040,0x0295,VR::SQ,VM::VM1,"Measuring Units Sequence","MeasuringUnitsSequence",false },
  {0x0040,0x0296,VR::SQ,VM::VM1,"Billing Item Sequence","BillingItemSequence",false },
  {0x0040,0x0300,VR::US,VM::VM1,"Total Time of Fluoroscopy","TotalTimeOfFluoroscopy",false },
  {0x0040,0x0301,VR::US,VM::VM1,"Total Number of Exposures","TotalNumberOfExposures",false },
  {0x0040,0x0302,VR::US,VM::VM1,"Entrance Dose","EntranceDose",false },
  {0x0040,0x0303,VR::US,VM::VM1_2,"Exposed Area","ExposedArea",false },
  {0x0040,0x0306,VR::DS,VM::VM1,"Distance Source to Entrance","DistanceSourceToEntrance",false },
  {0x0040,0x0307,VR::DS,VM::VM1,"Distance Source to Support","DistanceSourceToSupport",true },
  {0x0040,0x030e,VR::SQ,VM::VM1,"Exposure Dose Sequence","ExposureDoseSequence",false },
  {0x0040,0x0310,VR::ST,VM::VM1,"Comments on Radiation Dose","CommentsOnRadiationDose",false },
  {0x0040,0x0312,VR::DS,VM::VM1,"X-Ray Output","XRayOutput",false },
  {0x0040,0x0314,VR::DS,VM::VM1,"Half Value Layer","HalfValueLayer",false },
  {0x0040,0x0316,VR::DS,VM::VM1,"Organ Dose","OrganDose",false },
  {0x0040,0x0318,VR::CS,VM::VM1,"Organ Exposed","OrganExposed",false },
  {0x0040,0x0320,VR::SQ,VM::VM1,"Billing Procedure Step Sequence","BillingProcedureStepSequence",false },
  {0x0040,0x0321,VR::SQ,VM::VM1,"Film Consumption Sequence","FilmConsumptionSequence",false },
  {0x0040,0x0324,VR::SQ,VM::VM1,"Billing Supplies and Devices Sequence","BillingSuppliesAndDevicesSequence",false },
  {0x0040,0x0330,VR::SQ,VM::VM1,"Referenced Procedure Step Sequence","ReferencedProcedureStepSequence",true },
  {0x0040,0x0340,VR::SQ,VM::VM1,"Performed Series Sequence","PerformedSeriesSequence",false },
  {0x0040,0x0400,VR::LT,VM::VM1,"Comments on the Scheduled Procedure Step","CommentsOnTheScheduledProcedureStep",false },
  {0x0040,0x0440,VR::SQ,VM::VM1,"Protocol Context Sequence","ProtocolContextSequence",false },
  {0x0040,0x0441,VR::SQ,VM::VM1,"Content Item Modifier Sequence","ContentItemModifierSequence",false },
  {0x0040,0x0500,VR::SQ,VM::VM1,"Scheduled Specimen Sequence","ScheduledSpecimenSequence",false },
  {0x0040,0x050a,VR::LO,VM::VM1,"Specimen Accession Number","SpecimenAccessionNumber",true },
  {0x0040,0x0512,VR::LO,VM::VM1,"Container Identifier","ContainerIdentifier",false },
  {0x0040,0x0513,VR::SQ,VM::VM1,"Issuer of the Container Identifier Sequence","IssuerOfTheContainerIdentifierSequence",false },
  {0x0040,0x0515,VR::SQ,VM::VM1,"Alternate Container Identifier Sequence","AlternateContainerIdentifierSequence",false },
  {0x0040,0x0518,VR::SQ,VM::VM1,"Container Type Code Sequence","ContainerTypeCodeSequence",false },
  {0x0040,0x051a,VR::LO,VM::VM1,"Container Description","ContainerDescription",false },
  {0x0040,0x0520,VR::SQ,VM::VM1,"Container Component Sequence","ContainerComponentSequence",false },
  {0x0040,0x0550,VR::SQ,VM::VM1,"Specimen Sequence","SpecimenSequence",true },
  {0x0040,0x0551,VR::LO,VM::VM1,"Specimen Identifier","SpecimenIdentifier",false },
  {0x0040,0x0552,VR::SQ,VM::VM1,"Specimen Description Sequence (Trial)","SpecimenDescriptionSequenceTrial",true },
  {0x0040,0x0553,VR::ST,VM::VM1,"Specimen Description (Trial)","SpecimenDescriptionTrial",true },
  {0x0040,0x0554,VR::UI,VM::VM1,"Specimen UID","SpecimenUID",false },
  {0x0040,0x0555,VR::SQ,VM::VM1,"Acquisition Context Sequence","AcquisitionContextSequence",false },
  {0x0040,0x0556,VR::ST,VM::VM1,"Acquisition Context Description","AcquisitionContextDescription",false },
  {0x0040,0x0560,VR::SQ,VM::VM1,"Specimen Description Sequence","SpecimenDescriptionSequence",false },
  {0x0040,0x0562,VR::SQ,VM::VM1,"Issuer of the Specimen Identifier Sequence","IssuerOfTheSpecimenIdentifierSequence",false },
  {0x0040,0x059a,VR::SQ,VM::VM1,"Specimen Type Code Sequence","SpecimenTypeCodeSequence",false },
  {0x0040,0x0600,VR::LO,VM::VM1,"Specimen Short Description","SpecimenShortDescription",false },
  {0x0040,0x0602,VR::UT,VM::VM1,"Specimen Detailed Description","SpecimenDetailedDescription",false },
  {0x0040,0x0610,VR::SQ,VM::VM1,"Specimen Preparation Sequence","SpecimenPreparationSequence",false },
  {0x0040,0x0612,VR::SQ,VM::VM1,"Specimen Preparation Step Content Item Sequence","SpecimenPreparationStepContentItemSequence",false },
  {0x0040,0x0620,VR::SQ,VM::VM1,"Specimen Localization Content Item Sequence","SpecimenLocalizationContentItemSequence",false },
  {0x0040,0x06fa,VR::LO,VM::VM1,"Slide Identifier","SlideIdentifier",true },
  {0x0040,0x071a,VR::SQ,VM::VM1,"Image Center Point Coordinates Sequence","ImageCenterPointCoordinatesSequence",false },
  {0x0040,0x072a,VR::DS,VM::VM1,"X Offset in Slide Coordinate System","XOffsetInSlideCoordinateSystem",false },
  {0x0040,0x073a,VR::DS,VM::VM1,"Y Offset in Slide Coordinate System","YOffsetInSlideCoordinateSystem",false },
  {0x0040,0x074a,VR::DS,VM::VM1,"Z Offset in Slide Coordinate System","ZOffsetInSlideCoordinateSystem",false },
  {0x0040,0x08d8,VR::SQ,VM::VM1,"Pixel Spacing Sequence","PixelSpacingSequence",true },
  {0x0040,0x08da,VR::SQ,VM::VM1,"Coordinate System Axis Code Sequence","CoordinateSystemAxisCodeSequence",true },
  {0x0040,0x08ea,VR::SQ,VM::VM1,"Measurement Units Code Sequence","MeasurementUnitsCodeSequence",false },
  {0x0040,0x09f8,VR::SQ,VM::VM1,"Vital Stain Code Sequence (Trial)","VitalStainCodeSequenceTrial",true },
  {0x0040,0x1001,VR::SH,VM::VM1,"Requested Procedure ID","RequestedProcedureID",false },
  {0x0040,0x1002,VR::LO,VM::VM1,"Reason for the Requested Procedure","ReasonForTheRequestedProcedure",false },
  {0x0040,0x1003,VR::SH,VM::VM1,"Requested Procedure Priority","RequestedProcedurePriority",false },
  {0x0040,0x1004,VR::LO,VM::VM1,"Patient Transport Arrangements","PatientTransportArrangements",false },
  {0x0040,0x1005,VR::LO,VM::VM1,"Requested Procedure Location","RequestedProcedureLocation",false },
  {0x0040,0x1006,VR::SH,VM::VM1,"Placer Order Number / Procedure","PlacerOrderNumberProcedure",true },
  {0x0040,0x1007,VR::SH,VM::VM1,"Filler Order Number / Procedure","FillerOrderNumberProcedure",true },
  {0x0040,0x1008,VR::LO,VM::VM1,"Confidentiality Code","ConfidentialityCode",false },
  {0x0040,0x1009,VR::SH,VM::VM1,"Reporting Priority","ReportingPriority",false },
  {0x0040,0x100a,VR::SQ,VM::VM1,"Reason for Requested Procedure Code Sequence","ReasonForRequestedProcedureCodeSequence",false },
  {0x0040,0x1010,VR::PN,VM::VM1_n,"Names of Intended Recipients of Results","NamesOfIntendedRecipientsOfResults",false },
  {0x0040,0x1011,VR::SQ,VM::VM1,"Intended Recipients of Results Identification Sequence","IntendedRecipientsOfResultsIdentificationSequence",false },
  {0x0040,0x1012,VR::SQ,VM::VM1,"Reason For Performed Procedure Code Sequence","ReasonForPerformedProcedureCodeSequence",false },
  {0x0040,0x1060,VR::LO,VM::VM1,"Requested Procedure Description (Trial)","RequestedProcedureDescriptionTrial",true },
  {0x0040,0x1101,VR::SQ,VM::VM1,"Person Identification Code Sequence","PersonIdentificationCodeSequence",false },
  {0x0040,0x1102,VR::ST,VM::VM1,"Person's Address","PersonAddress",false },
  {0x0040,0x1103,VR::LO,VM::VM1_n,"Person's Telephone Numbers","PersonTelephoneNumbers",false },
  {0x0040,0x1400,VR::LT,VM::VM1,"Requested Procedure Comments","RequestedProcedureComments",false },
  {0x0040,0x2001,VR::LO,VM::VM1,"Reason for the Imaging Service Request","ReasonForTheImagingServiceRequest",true },
  {0x0040,0x2004,VR::DA,VM::VM1,"Issue Date of Imaging Service Request","IssueDateOfImagingServiceRequest",false },
  {0x0040,0x2005,VR::TM,VM::VM1,"Issue Time of Imaging Service Request","IssueTimeOfImagingServiceRequest",false },
  {0x0040,0x2006,VR::SH,VM::VM1,"Placer Order Number / Imaging Service Request (Retired)","PlacerOrderNumberImagingServiceRequestRetired",true },
  {0x0040,0x2007,VR::SH,VM::VM1,"Filler Order Number / Imaging Service Request (Retired)","FillerOrderNumberImagingServiceRequestRetired",true },
  {0x0040,0x2008,VR::PN,VM::VM1,"Order Entered By","OrderEnteredBy",false },
  {0x0040,0x2009,VR::SH,VM::VM1,"Order Enterer's Location","OrderEntererLocation",false },
  {0x0040,0x2010,VR::SH,VM::VM1,"Order Callback Phone Number","OrderCallbackPhoneNumber",false },
  {0x0040,0x2016,VR::LO,VM::VM1,"Placer Order Number / Imaging Service Request","PlacerOrderNumberImagingServiceRequest",false },
  {0x0040,0x2017,VR::LO,VM::VM1,"Filler Order Number / Imaging Service Request","FillerOrderNumberImagingServiceRequest",false },
  {0x0040,0x2400,VR::LT,VM::VM1,"Imaging Service Request Comments","ImagingServiceRequestComments",false },
  {0x0040,0x3001,VR::LO,VM::VM1,"Confidentiality Constraint on Patient Data Description","ConfidentialityConstraintOnPatientDataDescription",false },
  {0x0040,0x4001,VR::CS,VM::VM1,"General Purpose Scheduled Procedure Step Status","GeneralPurposeScheduledProcedureStepStatus",false },
  {0x0040,0x4002,VR::CS,VM::VM1,"General Purpose Performed Procedure Step Status","GeneralPurposePerformedProcedureStepStatus",false },
  {0x0040,0x4003,VR::CS,VM::VM1,"General Purpose Scheduled Procedure Step Priority","GeneralPurposeScheduledProcedureStepPriority",false },
  {0x0040,0x4004,VR::SQ,VM::VM1,"Scheduled Processing Applications Code Sequence","ScheduledProcessingApplicationsCodeSequence",false },
  {0x0040,0x4005,VR::DT,VM::VM1,"Scheduled Procedure Step Start DateTime","ScheduledProcedureStepStartDateTime",false },
  {0x0040,0x4006,VR::CS,VM::VM1,"Multiple Copies Flag","MultipleCopiesFlag",false },
  {0x0040,0x4007,VR::SQ,VM::VM1,"Performed Processing Applications Code Sequence","PerformedProcessingApplicationsCodeSequence",false },
  {0x0040,0x4009,VR::SQ,VM::VM1,"Human Performer Code Sequence","HumanPerformerCodeSequence",false },
  {0x0040,0x4010,VR::DT,VM::VM1,"Scheduled Procedure Step Modification Date Time","ScheduledProcedureStepModificationDateTime",false },
  {0x0040,0x4011,VR::DT,VM::VM1,"Expected Completion Date Time","ExpectedCompletionDateTime",false },
  {0x0040,0x4015,VR::SQ,VM::VM1,"Resulting General Purpose Performed Procedure Steps Sequence","ResultingGeneralPurposePerformedProcedureStepsSequence",false },
  {0x0040,0x4016,VR::SQ,VM::VM1,"Referenced General Purpose Scheduled Procedure Step Sequence","ReferencedGeneralPurposeScheduledProcedureStepSequence",false },
  {0x0040,0x4018,VR::SQ,VM::VM1,"Scheduled Workitem Code Sequence","ScheduledWorkitemCodeSequence",false },
  {0x0040,0x4019,VR::SQ,VM::VM1,"Performed Workitem Code Sequence","PerformedWorkitemCodeSequence",false },
  {0x0040,0x4020,VR::CS,VM::VM1,"Input Availability Flag","InputAvailabilityFlag",false },
  {0x0040,0x4021,VR::SQ,VM::VM1,"Input Information Sequence","InputInformationSequence",false },
  {0x0040,0x4022,VR::SQ,VM::VM1,"Relevant Information Sequence","RelevantInformationSequence",false },
  {0x0040,0x4023,VR::UI,VM::VM1,"Referenced General Purpose Scheduled Procedure Step Transaction UID","ReferencedGeneralPurposeScheduledProcedureStepTransactionUID",false },
  {0x0040,0x4025,VR::SQ,VM::VM1,"Scheduled Station Name Code Sequence","ScheduledStationNameCodeSequence",false },
  {0x0040,0x4026,VR::SQ,VM::VM1,"Scheduled Station Class Code Sequence","ScheduledStationClassCodeSequence",false },
  {0x0040,0x4027,VR::SQ,VM::VM1,"Scheduled Station Geographic Location Code Sequence","ScheduledStationGeographicLocationCodeSequence",false },
  {0x0040,0x4028,VR::SQ,VM::VM1,"Performed Station Name Code Sequence","PerformedStationNameCodeSequence",false },
  {0x0040,0x4029,VR::SQ,VM::VM1,"Performed Station Class Code Sequence","PerformedStationClassCodeSequence",false },
  {0x0040,0x4030,VR::SQ,VM::VM1,"Performed Station Geographic Location Code Sequence","PerformedStationGeographicLocationCodeSequence",false },
  {0x0040,0x4031,VR::SQ,VM::VM1,"Requested Subsequent Workitem Code Sequence","RequestedSubsequentWorkitemCodeSequence",false },
  {0x0040,0x4032,VR::SQ,VM::VM1,"Non-DICOM Output Code Sequence","NonDICOMOutputCodeSequence",false },
  {0x0040,0x4033,VR::SQ,VM::VM1,"Output Information Sequence","OutputInformationSequence",false },
  {0x0040,0x4034,VR::SQ,VM::VM1,"Scheduled Human Performers Sequence","ScheduledHumanPerformersSequence",false },
  {0x0040,0x4035,VR::SQ,VM::VM1,"Actual Human Performers Sequence","ActualHumanPerformersSequence",false },
  {0x0040,0x4036,VR::LO,VM::VM1,"Human Performer's Organization","HumanPerformerOrganization",false },
  {0x0040,0x4037,VR::PN,VM::VM1,"Human Performer's Name","HumanPerformerName",false },
  {0x0040,0x4040,VR::CS,VM::VM1,"Raw Data Handling","RawDataHandling",false },
  {0x0040,0x4041,VR::CS,VM::VM1,"Input Readiness State","InputReadinessState",false },
  {0x0040,0x4050,VR::DT,VM::VM1,"Performed Procedure Step Start DateTime","PerformedProcedureStepStartDateTime",false },
  {0x0040,0x4051,VR::DT,VM::VM1,"Performed Procedure Step End DateTime","PerformedProcedureStepEndDateTime",false },
  {0x0040,0x4052,VR::DT,VM::VM1,"Procedure Step Cancellation DateTime","ProcedureStepCancellationDateTime",false },
  {0x0040,0x8302,VR::DS,VM::VM1,"Entrance Dose in mGy","EntranceDoseInmGy",false },
  {0x0040,0x9094,VR::SQ,VM::VM1,"Referenced Image Real World Value Mapping Sequence","ReferencedImageRealWorldValueMappingSequence",false },
  {0x0040,0x9096,VR::SQ,VM::VM1,"Real World Value Mapping Sequence","RealWorldValueMappingSequence",false },
  {0x0040,0x9098,VR::SQ,VM::VM1,"Pixel Value Mapping Code Sequence","PixelValueMappingCodeSequence",false },
  {0x0040,0x9210,VR::SH,VM::VM1,"LUT Label","LUTLabel",false },
  {0x0040,0x9211,VR::US_SS,VM::VM1,"Real World Value Last Value Mapped","RealWorldValueLastValueMapped",false },
  {0x0040,0x9212,VR::FD,VM::VM1_n,"Real World Value LUT Data","RealWorldValueLUTData",false },
  {0x0040,0x9216,VR::US_SS,VM::VM1,"Real World Value First Value Mapped","RealWorldValueFirstValueMapped",false },
  {0x0040,0x9224,VR::FD,VM::VM1,"Real World Value Intercept","RealWorldValueIntercept",false },
  {0x0040,0x9225,VR::FD,VM::VM1,"Real World Value Slope","RealWorldValueSlope",false },
  {0x0040,0xa007,VR::CS,VM::VM1,"Findings Flag (Trial)","FindingsFlagTrial",true },
  {0x0040,0xa010,VR::CS,VM::VM1,"Relationship Type","RelationshipType",false },
  {0x0040,0xa020,VR::SQ,VM::VM1,"Findings Sequence (Trial)","FindingsSequenceTrial",true },
  {0x0040,0xa021,VR::UI,VM::VM1,"Findings Group UID (Trial)","FindingsGroupUIDTrial",true },
  {0x0040,0xa022,VR::UI,VM::VM1,"Referenced Findings Group UID (Trial)","ReferencedFindingsGroupUIDTrial",true },
  {0x0040,0xa023,VR::DA,VM::VM1,"Findings Group Recording Date (Trial)","FindingsGroupRecordingDateTrial",true },
  {0x0040,0xa024,VR::TM,VM::VM1,"Findings Group Recording Time (Trial)","FindingsGroupRecordingTimeTrial",true },
  {0x0040,0xa026,VR::SQ,VM::VM1,"Findings Source Category Code Sequence (Trial)","FindingsSourceCategoryCodeSequenceTrial",true },
  {0x0040,0xa027,VR::LO,VM::VM1,"Verifying Organization","VerifyingOrganization",false },
  {0x0040,0xa028,VR::SQ,VM::VM1,"Documenting Organization Identifier Code Sequence (Trial)","DocumentingOrganizationIdentifierCodeSequenceTrial",true },
  {0x0040,0xa030,VR::DT,VM::VM1,"Verification Date Time","VerificationDateTime",false },
  {0x0040,0xa032,VR::DT,VM::VM1,"Observation Date Time","ObservationDateTime",false },
  {0x0040,0xa040,VR::CS,VM::VM1,"Value Type","ValueType",false },
  {0x0040,0xa043,VR::SQ,VM::VM1,"Concept Name Code Sequence","ConceptNameCodeSequence",false },
  {0x0040,0xa047,VR::LO,VM::VM1,"Measurement Precision Description (Trial)","MeasurementPrecisionDescriptionTrial",true },
  {0x0040,0xa050,VR::CS,VM::VM1,"Continuity Of Content","ContinuityOfContent",false },
  {0x0040,0xa057,VR::CS,VM::VM1_n,"Urgency or Priority Alerts (Trial)","UrgencyOrPriorityAlertsTrial",true },
  {0x0040,0xa060,VR::LO,VM::VM1,"Sequencing Indicator (Trial)","SequencingIndicatorTrial",true },
  {0x0040,0xa066,VR::SQ,VM::VM1,"Document Identifier Code Sequence (Trial)","DocumentIdentifierCodeSequenceTrial",true },
  {0x0040,0xa067,VR::PN,VM::VM1,"Document Author (Trial)","DocumentAuthorTrial",true },
  {0x0040,0xa068,VR::SQ,VM::VM1,"Document Author Identifier Code Sequence (Trial)","DocumentAuthorIdentifierCodeSequenceTrial",true },
  {0x0040,0xa070,VR::SQ,VM::VM1,"Identifier Code Sequence (Trial)","IdentifierCodeSequenceTrial",true },
  {0x0040,0xa073,VR::SQ,VM::VM1,"Verifying Observer Sequence","VerifyingObserverSequence",false },
  {0x0040,0xa074,VR::OB,VM::VM1,"Object Binary Identifier (Trial)","ObjectBinaryIdentifierTrial",true },
  {0x0040,0xa075,VR::PN,VM::VM1,"Verifying Observer Name","VerifyingObserverName",false },
  {0x0040,0xa076,VR::SQ,VM::VM1,"Documenting Observer Identifier Code Sequence (Trial)","DocumentingObserverIdentifierCodeSequenceTrial",true },
  {0x0040,0xa078,VR::SQ,VM::VM1,"Author Observer Sequence","AuthorObserverSequence",false },
  {0x0040,0xa07a,VR::SQ,VM::VM1,"Participant Sequence","ParticipantSequence",false },
  {0x0040,0xa07c,VR::SQ,VM::VM1,"Custodial Organization Sequence","CustodialOrganizationSequence",false },
  {0x0040,0xa080,VR::CS,VM::VM1,"Participation Type","ParticipationType",false },
  {0x0040,0xa082,VR::DT,VM::VM1,"Participation DateTime","ParticipationDateTime",false },
  {0x0040,0xa084,VR::CS,VM::VM1,"Observer Type","ObserverType",false },
  {0x0040,0xa085,VR::SQ,VM::VM1,"Procedure Identifier Code Sequence (Trial)","ProcedureIdentifierCodeSequenceTrial",true },
  {0x0040,0xa088,VR::SQ,VM::VM1,"Verifying Observer Identification Code Sequence","VerifyingObserverIdentificationCodeSequence",false },
  {0x0040,0xa089,VR::OB,VM::VM1,"Object Directory Binary Identifier (Trial)","ObjectDirectoryBinaryIdentifierTrial",true },
  {0x0040,0xa090,VR::SQ,VM::VM1,"Equivalent CDA Document Sequence","EquivalentCDADocumentSequence",true },
  {0x0040,0xa0b0,VR::US,VM::VM2_2n,"Referenced Waveform Channels","ReferencedWaveformChannels",false },
  {0x0040,0xa110,VR::DA,VM::VM1,"Date of Document or Verbal Transaction (Trial)","DateOfDocumentOrVerbalTransactionTrial",true },
  {0x0040,0xa112,VR::TM,VM::VM1,"Time of Document Creation or Verbal Transaction (Trial)","TimeOfDocumentCreationOrVerbalTransactionTrial",true },
  {0x0040,0xa120,VR::DT,VM::VM1,"DateTime","DateTime",false },
  {0x0040,0xa121,VR::DA,VM::VM1,"Date","Date",false },
  {0x0040,0xa122,VR::TM,VM::VM1,"Time","Time",false },
  {0x0040,0xa123,VR::PN,VM::VM1,"Person Name","PersonName",false },
  {0x0040,0xa124,VR::UI,VM::VM1,"UID","UID",false },
  {0x0040,0xa125,VR::CS,VM::VM2,"Report Status ID (Trial)","ReportStatusIDTrial",true },
  {0x0040,0xa130,VR::CS,VM::VM1,"Temporal Range Type","TemporalRangeType",false },
  {0x0040,0xa132,VR::UL,VM::VM1_n,"Referenced Sample Positions","ReferencedSamplePositions",false },
  {0x0040,0xa136,VR::US,VM::VM1_n,"Referenced Frame Numbers","ReferencedFrameNumbers",false },
  {0x0040,0xa138,VR::DS,VM::VM1_n,"Referenced Time Offsets","ReferencedTimeOffsets",false },
  {0x0040,0xa13a,VR::DT,VM::VM1_n,"Referenced DateTime","ReferencedDateTime",false },
  {0x0040,0xa160,VR::UT,VM::VM1,"Text Value","TextValue",false },
  {0x0040,0xa167,VR::SQ,VM::VM1,"Observation Category Code Sequence (Trial)","ObservationCategoryCodeSequenceTrial",true },
  {0x0040,0xa168,VR::SQ,VM::VM1,"Concept Code Sequence","ConceptCodeSequence",false },
  {0x0040,0xa16a,VR::ST,VM::VM1,"Bibliographic Citation (Trial)","BibliographicCitationTrial",true },
  {0x0040,0xa170,VR::SQ,VM::VM1,"Purpose of Reference Code Sequence","PurposeOfReferenceCodeSequence",false },
  {0x0040,0xa171,VR::UI,VM::VM1,"Observation UID (Trial)","ObservationUIDTrial",true },
  {0x0040,0xa172,VR::UI,VM::VM1,"Referenced Observation UID (Trial)","ReferencedObservationUIDTrial",true },
  {0x0040,0xa173,VR::CS,VM::VM1,"Referenced Observation Class (Trial)","ReferencedObservationClassTrial",true },
  {0x0040,0xa174,VR::CS,VM::VM1,"Referenced Object Observation Class (Trial)","ReferencedObjectObservationClassTrial",true },
  {0x0040,0xa180,VR::US,VM::VM1,"Annotation Group Number","AnnotationGroupNumber",false },
  {0x0040,0xa192,VR::DA,VM::VM1,"Observation Date (Trial)","ObservationDateTrial",true },
  {0x0040,0xa193,VR::TM,VM::VM1,"Observation Time (Trial)","ObservationTimeTrial",true },
  {0x0040,0xa194,VR::CS,VM::VM1,"Measurement Automation (Trial)","MeasurementAutomationTrial",true },
  {0x0040,0xa195,VR::SQ,VM::VM1,"Modifier Code Sequence","ModifierCodeSequence",false },
  {0x0040,0xa224,VR::ST,VM::VM1,"Identification Description (Trial)","IdentificationDescriptionTrial",true },
  {0x0040,0xa290,VR::CS,VM::VM1,"Coordinates Set Geometric Type (Trial)","CoordinatesSetGeometricTypeTrial",true },
  {0x0040,0xa296,VR::SQ,VM::VM1,"Algorithm Code Sequence (Trial)","AlgorithmCodeSequenceTrial",true },
  {0x0040,0xa297,VR::ST,VM::VM1,"Algorithm Description (Trial)","AlgorithmDescriptionTrial",true },
  {0x0040,0xa29a,VR::SL,VM::VM2_2n,"Pixel Coordinates Set (Trial)","PixelCoordinatesSetTrial",true },
  {0x0040,0xa300,VR::SQ,VM::VM1,"Measured Value Sequence","MeasuredValueSequence",false },
  {0x0040,0xa301,VR::SQ,VM::VM1,"Numeric Value Qualifier Code Sequence","NumericValueQualifierCodeSequence",false },
  {0x0040,0xa307,VR::PN,VM::VM1,"Current Observer (Trial)","CurrentObserverTrial",true },
  {0x0040,0xa30a,VR::DS,VM::VM1_n,"Numeric Value","NumericValue",false },
  {0x0040,0xa313,VR::SQ,VM::VM1,"Referenced Accession Sequence (Trial)","ReferencedAccessionSequenceTrial",true },
  {0x0040,0xa33a,VR::ST,VM::VM1,"Report Status Comment (Trial)","ReportStatusCommentTrial",true },
  {0x0040,0xa340,VR::SQ,VM::VM1,"Procedure Context Sequence (Trial)","ProcedureContextSequenceTrial",true },
  {0x0040,0xa352,VR::PN,VM::VM1,"Verbal Source (Trial)","VerbalSourceTrial",true },
  {0x0040,0xa353,VR::ST,VM::VM1,"Address (Trial)","AddressTrial",true },
  {0x0040,0xa354,VR::LO,VM::VM1,"Telephone Number (Trial)","TelephoneNumberTrial",true },
  {0x0040,0xa358,VR::SQ,VM::VM1,"Verbal Source Identifier Code Sequence (Trial)","VerbalSourceIdentifierCodeSequenceTrial",true },
  {0x0040,0xa360,VR::SQ,VM::VM1,"Predecessor Documents Sequence","PredecessorDocumentsSequence",false },
  {0x0040,0xa370,VR::SQ,VM::VM1,"Referenced Request Sequence","ReferencedRequestSequence",false },
  {0x0040,0xa372,VR::SQ,VM::VM1,"Performed Procedure Code Sequence","PerformedProcedureCodeSequence",false },
  {0x0040,0xa375,VR::SQ,VM::VM1,"Current Requested Procedure Evidence Sequence","CurrentRequestedProcedureEvidenceSequence",false },
  {0x0040,0xa380,VR::SQ,VM::VM1,"Report Detail Sequence (Trial)","ReportDetailSequenceTrial",true },
  {0x0040,0xa385,VR::SQ,VM::VM1,"Pertinent Other Evidence Sequence","PertinentOtherEvidenceSequence",false },
  {0x0040,0xa390,VR::SQ,VM::VM1,"HL7 Structured Document Reference Sequence","HL7StructuredDocumentReferenceSequence",false },
  {0x0040,0xa402,VR::UI,VM::VM1,"Observation Subject UID (Trial)","ObservationSubjectUIDTrial",true },
  {0x0040,0xa403,VR::CS,VM::VM1,"Observation Subject Class (Trial)","ObservationSubjectClassTrial",true },
  {0x0040,0xa404,VR::SQ,VM::VM1,"Observation Subject Type Code Sequence (Trial)","ObservationSubjectTypeCodeSequenceTrial",true },
  {0x0040,0xa491,VR::CS,VM::VM1,"Completion Flag","CompletionFlag",false },
  {0x0040,0xa492,VR::LO,VM::VM1,"Completion Flag Description","CompletionFlagDescription",false },
  {0x0040,0xa493,VR::CS,VM::VM1,"Verification Flag","VerificationFlag",false },
  {0x0040,0xa494,VR::CS,VM::VM1,"Archive Requested","ArchiveRequested",false },
  {0x0040,0xa496,VR::CS,VM::VM1,"Preliminary Flag","PreliminaryFlag",false },
  {0x0040,0xa504,VR::SQ,VM::VM1,"Content Template Sequence","ContentTemplateSequence",false },
  {0x0040,0xa525,VR::SQ,VM::VM1,"Identical Documents Sequence","IdenticalDocumentsSequence",false },
  {0x0040,0xa600,VR::CS,VM::VM1,"Observation Subject Context Flag (Trial)","ObservationSubjectContextFlagTrial",true },
  {0x0040,0xa601,VR::CS,VM::VM1,"Observer Context Flag (Trial)","ObserverContextFlagTrial",true },
  {0x0040,0xa603,VR::CS,VM::VM1,"Procedure Context Flag (Trial)","ProcedureContextFlagTrial",true },
  {0x0040,0xa730,VR::SQ,VM::VM1,"Content Sequence","ContentSequence",false },
  {0x0040,0xa731,VR::SQ,VM::VM1,"Relationship Sequence (Trial)","RelationshipSequenceTrial",true },
  {0x0040,0xa732,VR::SQ,VM::VM1,"Relationship Type Code Sequence (Trial)","RelationshipTypeCodeSequenceTrial",true },
  {0x0040,0xa744,VR::SQ,VM::VM1,"Language Code Sequence (Trial)","LanguageCodeSequenceTrial",true },
  {0x0040,0xa992,VR::ST,VM::VM1,"Uniform Resource Locator (Trial)","UniformResourceLocatorTrial",true },
  {0x0040,0xb020,VR::SQ,VM::VM1,"Waveform Annotation Sequence","WaveformAnnotationSequence",false },
  {0x0040,0xdb00,VR::CS,VM::VM1,"Template Identifier","TemplateIdentifier",false },
  {0x0040,0xdb06,VR::DT,VM::VM1,"Template Version","TemplateVersion",true },
  {0x0040,0xdb07,VR::DT,VM::VM1,"Template Local Version","TemplateLocalVersion",true },
  {0x0040,0xdb0b,VR::CS,VM::VM1,"Template Extension Flag","TemplateExtensionFlag",true },
  {0x0040,0xdb0c,VR::UI,VM::VM1,"Template Extension Organization UID","TemplateExtensionOrganizationUID",true },
  {0x0040,0xdb0d,VR::UI,VM::VM1,"Template Extension Creator UID","TemplateExtensionCreatorUID",true },
  {0x0040,0xdb73,VR::UL,VM::VM1_n,"Referenced Content Item Identifier","ReferencedContentItemIdentifier",false },
  {0x0040,0xe001,VR::ST,VM::VM1,"HL7 Instance Identifier","HL7InstanceIdentifier",false },
  {0x0040,0xe004,VR::DT,VM::VM1,"HL7 Document Effective Time","HL7DocumentEffectiveTime",false },
  {0x0040,0xe006,VR::SQ,VM::VM1,"HL7 Document Type Code Sequence","HL7DocumentTypeCodeSequence",false },
  {0x0040,0xe008,VR::SQ,VM::VM1,"Document Class Code Sequence","DocumentClassCodeSequence",false },
  {0x0040,0xe010,VR::UT,VM::VM1,"Retrieve URI","RetrieveURI",false },
  {0x0040,0xe011,VR::UI,VM::VM1,"Retrieve Location UID","RetrieveLocationUID",false },
  {0x0040,0xe020,VR::CS,VM::VM1,"Type of Instances","TypeOfInstances",false },
  {0x0040,0xe021,VR::SQ,VM::VM1,"DICOM Retrieval Sequence","DICOMRetrievalSequence",false },
  {0x0040,0xe022,VR::SQ,VM::VM1,"DICOM Media Retrieval Sequence","DICOMMediaRetrievalSequence",false },
  {0x0040,0xe023,VR::SQ,VM::VM1,"WADO Retrieval Sequence","WADORetrievalSequence",false },
  {0x0040,0xe024,VR::SQ,VM::VM1,"XDS Retrieval Sequence","XDSRetrievalSequence",false },
  {0x0040,0xe030,VR::UI,VM::VM1,"Repository Unique ID","RepositoryUniqueID",false },
  {0x0040,0xe031,VR::UI,VM::VM1,"Home Community ID","HomeCommunityID",false },
  {0x0042,0x0010,VR::ST,VM::VM1,"Document Title","DocumentTitle",false },
  {0x0042,0x0011,VR::OB,VM::VM1,"Encapsulated Document","EncapsulatedDocument",false },
  {0x0042,0x0012,VR::LO,VM::VM1,"MIME Type of Encapsulated Document","MIMETypeOfEncapsulatedDocument",false },
  {0x0042,0x0013,VR::SQ,VM::VM1,"Source Instance Sequence","SourceInstanceSequence",false },
  {0x0042,0x0014,VR::LO,VM::VM1_n,"List of MIME Types","ListOfMIMETypes",false },
  {0x0044,0x0001,VR::ST,VM::VM1,"Product Package Identifier","ProductPackageIdentifier",false },
  {0x0044,0x0002,VR::CS,VM::VM1,"Substance Administration Approval","SubstanceAdministrationApproval",false },
  {0x0044,0x0003,VR::LT,VM::VM1,"Approval Status Further Description","ApprovalStatusFurtherDescription",false },
  {0x0044,0x0004,VR::DT,VM::VM1,"Approval Status DateTime","ApprovalStatusDateTime",false },
  {0x0044,0x0007,VR::SQ,VM::VM1,"Product Type Code Sequence","ProductTypeCodeSequence",false },
  {0x0044,0x0008,VR::LO,VM::VM1_n,"Product Name","ProductName",false },
  {0x0044,0x0009,VR::LT,VM::VM1,"Product Description","ProductDescription",false },
  {0x0044,0x000a,VR::LO,VM::VM1,"Product Lot Identifier","ProductLotIdentifier",false },
  {0x0044,0x000b,VR::DT,VM::VM1,"Product Expiration DateTime","ProductExpirationDateTime",false },
  {0x0044,0x0010,VR::DT,VM::VM1,"Substance Administration DateTime","SubstanceAdministrationDateTime",false },
  {0x0044,0x0011,VR::LO,VM::VM1,"Substance Administration Notes","SubstanceAdministrationNotes",false },
  {0x0044,0x0012,VR::LO,VM::VM1,"Substance Administration Device ID","SubstanceAdministrationDeviceID",false },
  {0x0044,0x0013,VR::SQ,VM::VM1,"Product Parameter Sequence","ProductParameterSequence",false },
  {0x0044,0x0019,VR::SQ,VM::VM1,"Substance Administration Parameter Sequence","SubstanceAdministrationParameterSequence",false },
  {0x0046,0x0012,VR::LO,VM::VM1,"Lens Description","LensDescription",false },
  {0x0046,0x0014,VR::SQ,VM::VM1,"Right Lens Sequence","RightLensSequence",false },
  {0x0046,0x0015,VR::SQ,VM::VM1,"Left Lens Sequence","LeftLensSequence",false },
  {0x0046,0x0016,VR::SQ,VM::VM1,"Unspecified Laterality Lens Sequence","UnspecifiedLateralityLensSequence",false },
  {0x0046,0x0018,VR::SQ,VM::VM1,"Cylinder Sequence","CylinderSequence",false },
  {0x0046,0x0028,VR::SQ,VM::VM1,"Prism Sequence","PrismSequence",false },
  {0x0046,0x0030,VR::FD,VM::VM1,"Horizontal Prism Power","HorizontalPrismPower",false },
  {0x0046,0x0032,VR::CS,VM::VM1,"Horizontal Prism Base","HorizontalPrismBase",false },
  {0x0046,0x0034,VR::FD,VM::VM1,"Vertical Prism Power","VerticalPrismPower",false },
  {0x0046,0x0036,VR::CS,VM::VM1,"Vertical Prism Base","VerticalPrismBase",false },
  {0x0046,0x0038,VR::CS,VM::VM1,"Lens Segment Type","LensSegmentType",false },
  {0x0046,0x0040,VR::FD,VM::VM1,"Optical Transmittance","OpticalTransmittance",false },
  {0x0046,0x0042,VR::FD,VM::VM1,"Channel Width","ChannelWidth",false },
  {0x0046,0x0044,VR::FD,VM::VM1,"Pupil Size","PupilSize",false },
  {0x0046,0x0046,VR::FD,VM::VM1,"Corneal Size","CornealSize",false },
  {0x0046,0x0050,VR::SQ,VM::VM1,"Autorefraction Right Eye Sequence","AutorefractionRightEyeSequence",false },
  {0x0046,0x0052,VR::SQ,VM::VM1,"Autorefraction Left Eye Sequence","AutorefractionLeftEyeSequence",false },
  {0x0046,0x0060,VR::FD,VM::VM1,"Distance Pupillary Distance","DistancePupillaryDistance",false },
  {0x0046,0x0062,VR::FD,VM::VM1,"Near Pupillary Distance","NearPupillaryDistance",false },
  {0x0046,0x0063,VR::FD,VM::VM1,"Intermediate Pupillary Distance","IntermediatePupillaryDistance",false },
  {0x0046,0x0064,VR::FD,VM::VM1,"Other Pupillary Distance","OtherPupillaryDistance",false },
  {0x0046,0x0070,VR::SQ,VM::VM1,"Keratometry Right Eye Sequence","KeratometryRightEyeSequence",false },
  {0x0046,0x0071,VR::SQ,VM::VM1,"Keratometry Left Eye Sequence","KeratometryLeftEyeSequence",false },
  {0x0046,0x0074,VR::SQ,VM::VM1,"Steep Keratometric Axis Sequence","SteepKeratometricAxisSequence",false },
  {0x0046,0x0075,VR::FD,VM::VM1,"Radius of Curvature","RadiusOfCurvature",false },
  {0x0046,0x0076,VR::FD,VM::VM1,"Keratometric Power","KeratometricPower",false },
  {0x0046,0x0077,VR::FD,VM::VM1,"Keratometric Axis","KeratometricAxis",false },
  {0x0046,0x0080,VR::SQ,VM::VM1,"Flat Keratometric Axis Sequence","FlatKeratometricAxisSequence",false },
  {0x0046,0x0092,VR::CS,VM::VM1,"Background Color","BackgroundColor",false },
  {0x0046,0x0094,VR::CS,VM::VM1,"Optotype","Optotype",false },
  {0x0046,0x0095,VR::CS,VM::VM1,"Optotype Presentation","OptotypePresentation",false },
  {0x0046,0x0097,VR::SQ,VM::VM1,"Subjective Refraction Right Eye Sequence","SubjectiveRefractionRightEyeSequence",false },
  {0x0046,0x0098,VR::SQ,VM::VM1,"Subjective Refraction Left Eye Sequence","SubjectiveRefractionLeftEyeSequence",false },
  {0x0046,0x0100,VR::SQ,VM::VM1,"Add Near Sequence","AddNearSequence",false },
  {0x0046,0x0101,VR::SQ,VM::VM1,"Add Intermediate Sequence","AddIntermediateSequence",false },
  {0x0046,0x0102,VR::SQ,VM::VM1,"Add Other Sequence","AddOtherSequence",false },
  {0x0046,0x0104,VR::FD,VM::VM1,"Add Power","AddPower",false },
  {0x0046,0x0106,VR::FD,VM::VM1,"Viewing Distance","ViewingDistance",false },
  {0x0046,0x0121,VR::SQ,VM::VM1,"Visual Acuity Type Code Sequence","VisualAcuityTypeCodeSequence",false },
  {0x0046,0x0122,VR::SQ,VM::VM1,"Visual Acuity Right Eye Sequence","VisualAcuityRightEyeSequence",false },
  {0x0046,0x0123,VR::SQ,VM::VM1,"Visual Acuity Left Eye Sequence","VisualAcuityLeftEyeSequence",false },
  {0x0046,0x0124,VR::SQ,VM::VM1,"Visual Acuity Both Eyes Open Sequence","VisualAcuityBothEyesOpenSequence",false },
  {0x0046,0x0125,VR::CS,VM::VM1,"Viewing Distance Type","ViewingDistanceType",false },
  {0x0046,0x0135,VR::SS,VM::VM2,"Visual Acuity Modifiers","VisualAcuityModifiers",false },
  {0x0046,0x0137,VR::FD,VM::VM1,"Decimal Visual Acuity","DecimalVisualAcuity",false },
  {0x0046,0x0139,VR::LO,VM::VM1,"Optotype Detailed Definition","OptotypeDetailedDefinition",false },
  {0x0046,0x0145,VR::SQ,VM::VM1,"Referenced Refractive Measurements Sequence","ReferencedRefractiveMeasurementsSequence",false },
  {0x0046,0x0146,VR::FD,VM::VM1,"Sphere Power","SpherePower",false },
  {0x0046,0x0147,VR::FD,VM::VM1,"Cylinder Power","CylinderPower",false },
  {0x0048,0x0001,VR::FL,VM::VM1,"Imaged Volume Width","ImagedVolumeWidth",false },
  {0x0048,0x0002,VR::FL,VM::VM1,"Imaged Volume Height","ImagedVolumeHeight",false },
  {0x0048,0x0003,VR::FL,VM::VM1,"Imaged Volume Depth","ImagedVolumeDepth",false },
  {0x0048,0x0006,VR::UL,VM::VM1,"Total Pixel Matrix Columns","TotalPixelMatrixColumns",false },
  {0x0048,0x0007,VR::UL,VM::VM1,"Total Pixel Matrix Rows","TotalPixelMatrixRows",false },
  {0x0048,0x0008,VR::SQ,VM::VM1,"Total Pixel Matrix Origin Sequence","TotalPixelMatrixOriginSequence",false },
  {0x0048,0x0010,VR::CS,VM::VM1,"Specimen Label in Image","SpecimenLabelInImage",false },
  {0x0048,0x0011,VR::CS,VM::VM1,"Focus Method","FocusMethod",false },
  {0x0048,0x0012,VR::CS,VM::VM1,"Extended Depth of Field","ExtendedDepthOfField",false },
  {0x0048,0x0013,VR::US,VM::VM1,"Number of Focal Planes","NumberOfFocalPlanes",false },
  {0x0048,0x0014,VR::FL,VM::VM1,"Distance Between Focal Planes","DistanceBetweenFocalPlanes",false },
  {0x0048,0x0015,VR::US,VM::VM3,"Recommended Absent Pixel CIELab Value","RecommendedAbsentPixelCIELabValue",false },
  {0x0048,0x0100,VR::SQ,VM::VM1,"Illuminator Type Code Sequence","IlluminatorTypeCodeSequence",false },
  {0x0048,0x0102,VR::DS,VM::VM6,"Image Orientation (Slide)","ImageOrientationSlide",false },
  {0x0048,0x0105,VR::SQ,VM::VM1,"Optical Path Sequence","OpticalPathSequence",false },
  {0x0048,0x0106,VR::SH,VM::VM1,"Optical Path Identifier","OpticalPathIdentifier",false },
  {0x0048,0x0107,VR::ST,VM::VM1,"Optical Path Description","OpticalPathDescription",false },
  {0x0048,0x0108,VR::SQ,VM::VM1,"Illumination Color Code Sequence","IlluminationColorCodeSequence",false },
  {0x0048,0x0110,VR::SQ,VM::VM1,"Specimen Reference Sequence","SpecimenReferenceSequence",false },
  {0x0048,0x0111,VR::DS,VM::VM1,"Condenser Lens Power","CondenserLensPower",false },
  {0x0048,0x0112,VR::DS,VM::VM1,"Objective Lens Power","ObjectiveLensPower",false },
  {0x0048,0x0113,VR::DS,VM::VM1,"Objective Lens Numerical Aperture","ObjectiveLensNumericalAperture",false },
  {0x0048,0x0120,VR::SQ,VM::VM1,"Palette Color Lookup Table Sequence","PaletteColorLookupTableSequence",false },
  {0x0048,0x0200,VR::SQ,VM::VM1,"Referenced Image Navigation Sequence","ReferencedImageNavigationSequence",false },
  {0x0048,0x0201,VR::US,VM::VM2,"Top Left Hand Corner of Localizer Area","TopLeftHandCornerOfLocalizerArea",false },
  {0x0048,0x0202,VR::US,VM::VM2,"Bottom Right Hand Corner of Localizer Area","BottomRightHandCornerOfLocalizerArea",false },
  {0x0048,0x0207,VR::SQ,VM::VM1,"Optical Path Identification Sequence","OpticalPathIdentificationSequence",false },
  {0x0048,0x021a,VR::SQ,VM::VM1,"Plane Position (Slide) Sequence","PlanePositionSlideSequence",false },
  {0x0048,0x021e,VR::SL,VM::VM1,"Column Position In Total Image Pixel Matrix","ColumnPositionInTotalImagePixelMatrix",false },
  {0x0048,0x021f,VR::SL,VM::VM1,"Row Position In Total Image Pixel Matrix","RowPositionInTotalImagePixelMatrix",false },
  {0x0048,0x0301,VR::CS,VM::VM1,"Pixel Origin Interpretation","PixelOriginInterpretation",false },
  {0x0050,0x0004,VR::CS,VM::VM1,"Calibration Image","CalibrationImage",false },
  {0x0050,0x0010,VR::SQ,VM::VM1,"Device Sequence","DeviceSequence",false },
  {0x0050,0x0012,VR::SQ,VM::VM1,"Container Component Type Code Sequence","ContainerComponentTypeCodeSequence",false },
  {0x0050,0x0013,VR::FD,VM::VM1,"Container Component Thickness","ContainerComponentThickness",false },
  {0x0050,0x0014,VR::DS,VM::VM1,"Device Length","DeviceLength",false },
  {0x0050,0x0015,VR::FD,VM::VM1,"Container Component Width","ContainerComponentWidth",false },
  {0x0050,0x0016,VR::DS,VM::VM1,"Device Diameter","DeviceDiameter",false },
  {0x0050,0x0017,VR::CS,VM::VM1,"Device Diameter Units","DeviceDiameterUnits",false },
  {0x0050,0x0018,VR::DS,VM::VM1,"Device Volume","DeviceVolume",false },
  {0x0050,0x0019,VR::DS,VM::VM1,"Inter-Marker Distance","InterMarkerDistance",false },
  {0x0050,0x001a,VR::CS,VM::VM1,"Container Component Material","ContainerComponentMaterial",false },
  {0x0050,0x001b,VR::LO,VM::VM1,"Container Component ID","ContainerComponentID",false },
  {0x0050,0x001c,VR::FD,VM::VM1,"Container Component Length","ContainerComponentLength",false },
  {0x0050,0x001d,VR::FD,VM::VM1,"Container Component Diameter","ContainerComponentDiameter",false },
  {0x0050,0x001e,VR::LO,VM::VM1,"Container Component Description","ContainerComponentDescription",false },
  {0x0050,0x0020,VR::LO,VM::VM1,"Device Description","DeviceDescription",false },
  {0x0052,0x0001,VR::FL,VM::VM1,"Contrast/Bolus Ingredient Percent by Volume","ContrastBolusIngredientPercentByVolume",false },
  {0x0052,0x0002,VR::FD,VM::VM1,"OCT Focal Distance","OCTFocalDistance",false },
  {0x0052,0x0003,VR::FD,VM::VM1,"Beam Spot Size","BeamSpotSize",false },
  {0x0052,0x0004,VR::FD,VM::VM1,"Effective Refractive Index","EffectiveRefractiveIndex",false },
  {0x0052,0x0006,VR::CS,VM::VM1,"OCT Acquisition Domain","OCTAcquisitionDomain",false },
  {0x0052,0x0007,VR::FD,VM::VM1,"OCT Optical Center Wavelength","OCTOpticalCenterWavelength",false },
  {0x0052,0x0008,VR::FD,VM::VM1,"Axial Resolution","AxialResolution",false },
  {0x0052,0x0009,VR::FD,VM::VM1,"Ranging Depth","RangingDepth",false },
  {0x0052,0x0011,VR::FD,VM::VM1,"A-line Rate","ALineRate",false },
  {0x0052,0x0012,VR::US,VM::VM1,"A-lines Per Frame","ALinesPerFrame",false },
  {0x0052,0x0013,VR::FD,VM::VM1,"Catheter Rotational Rate","CatheterRotationalRate",false },
  {0x0052,0x0014,VR::FD,VM::VM1,"A-line Pixel Spacing","ALinePixelSpacing",false },
  {0x0052,0x0016,VR::SQ,VM::VM1,"Mode of Percutaneous Access Sequence","ModeOfPercutaneousAccessSequence",false },
  {0x0052,0x0025,VR::SQ,VM::VM1,"Intravascular OCT Frame Type Sequence","IntravascularOCTFrameTypeSequence",false },
  {0x0052,0x0026,VR::CS,VM::VM1,"OCT Z Offset Applied","OCTZOffsetApplied",false },
  {0x0052,0x0027,VR::SQ,VM::VM1,"Intravascular Frame Content Sequence","IntravascularFrameContentSequence",false },
  {0x0052,0x0028,VR::FD,VM::VM1,"Intravascular Longitudinal Distance","IntravascularLongitudinalDistance",false },
  {0x0052,0x0029,VR::SQ,VM::VM1,"Intravascular OCT Frame Content Sequence","IntravascularOCTFrameContentSequence",false },
  {0x0052,0x0030,VR::SS,VM::VM1,"OCT Z Offset Correction","OCTZOffsetCorrection",false },
  {0x0052,0x0031,VR::CS,VM::VM1,"Catheter Direction of Rotation","CatheterDirectionOfRotation",false },
  {0x0052,0x0033,VR::FD,VM::VM1,"Seam Line Location","SeamLineLocation",false },
  {0x0052,0x0034,VR::FD,VM::VM1,"First A-line Location","FirstALineLocation",false },
  {0x0052,0x0036,VR::US,VM::VM1,"Seam Line Index","SeamLineIndex",false },
  {0x0052,0x0038,VR::US,VM::VM1,"Number of Padded A-lines","NumberOfPaddedAlines",false },
  {0x0052,0x0039,VR::CS,VM::VM1,"Interpolation Type","InterpolationType",false },
  {0x0052,0x003a,VR::CS,VM::VM1,"Refractive Index Applied","RefractiveIndexApplied",false },
  {0x0054,0x0010,VR::US,VM::VM1_n,"Energy Window Vector","EnergyWindowVector",false },
  {0x0054,0x0011,VR::US,VM::VM1,"Number of Energy Windows","NumberOfEnergyWindows",false },
  {0x0054,0x0012,VR::SQ,VM::VM1,"Energy Window Information Sequence","EnergyWindowInformationSequence",false },
  {0x0054,0x0013,VR::SQ,VM::VM1,"Energy Window Range Sequence","EnergyWindowRangeSequence",false },
  {0x0054,0x0014,VR::DS,VM::VM1,"Energy Window Lower Limit","EnergyWindowLowerLimit",false },
  {0x0054,0x0015,VR::DS,VM::VM1,"Energy Window Upper Limit","EnergyWindowUpperLimit",false },
  {0x0054,0x0016,VR::SQ,VM::VM1,"Radiopharmaceutical Information Sequence","RadiopharmaceuticalInformationSequence",false },
  {0x0054,0x0017,VR::IS,VM::VM1,"Residual Syringe Counts","ResidualSyringeCounts",false },
  {0x0054,0x0018,VR::SH,VM::VM1,"Energy Window Name","EnergyWindowName",false },
  {0x0054,0x0020,VR::US,VM::VM1_n,"Detector Vector","DetectorVector",false },
  {0x0054,0x0021,VR::US,VM::VM1,"Number of Detectors","NumberOfDetectors",false },
  {0x0054,0x0022,VR::SQ,VM::VM1,"Detector Information Sequence","DetectorInformationSequence",false },
  {0x0054,0x0030,VR::US,VM::VM1_n,"Phase Vector","PhaseVector",false },
  {0x0054,0x0031,VR::US,VM::VM1,"Number of Phases","NumberOfPhases",false },
  {0x0054,0x0032,VR::SQ,VM::VM1,"Phase Information Sequence","PhaseInformationSequence",false },
  {0x0054,0x0033,VR::US,VM::VM1,"Number of Frames in Phase","NumberOfFramesInPhase",false },
  {0x0054,0x0036,VR::IS,VM::VM1,"Phase Delay","PhaseDelay",false },
  {0x0054,0x0038,VR::IS,VM::VM1,"Pause Between Frames","PauseBetweenFrames",false },
  {0x0054,0x0039,VR::CS,VM::VM1,"Phase Description","PhaseDescription",false },
  {0x0054,0x0050,VR::US,VM::VM1_n,"Rotation Vector","RotationVector",false },
  {0x0054,0x0051,VR::US,VM::VM1,"Number of Rotations","NumberOfRotations",false },
  {0x0054,0x0052,VR::SQ,VM::VM1,"Rotation Information Sequence","RotationInformationSequence",false },
  {0x0054,0x0053,VR::US,VM::VM1,"Number of Frames in Rotation","NumberOfFramesInRotation",false },
  {0x0054,0x0060,VR::US,VM::VM1_n,"R-R Interval Vector","RRIntervalVector",false },
  {0x0054,0x0061,VR::US,VM::VM1,"Number of R-R Intervals","NumberOfRRIntervals",false },
  {0x0054,0x0062,VR::SQ,VM::VM1,"Gated Information Sequence","GatedInformationSequence",false },
  {0x0054,0x0063,VR::SQ,VM::VM1,"Data Information Sequence","DataInformationSequence",false },
  {0x0054,0x0070,VR::US,VM::VM1_n,"Time Slot Vector","TimeSlotVector",false },
  {0x0054,0x0071,VR::US,VM::VM1,"Number of Time Slots","NumberOfTimeSlots",false },
  {0x0054,0x0072,VR::SQ,VM::VM1,"Time Slot Information Sequence","TimeSlotInformationSequence",false },
  {0x0054,0x0073,VR::DS,VM::VM1,"Time Slot Time","TimeSlotTime",false },
  {0x0054,0x0080,VR::US,VM::VM1_n,"Slice Vector","SliceVector",false },
  {0x0054,0x0081,VR::US,VM::VM1,"Number of Slices","NumberOfSlices",false },
  {0x0054,0x0090,VR::US,VM::VM1_n,"Angular View Vector","AngularViewVector",false },
  {0x0054,0x0100,VR::US,VM::VM1_n,"Time Slice Vector","TimeSliceVector",false },
  {0x0054,0x0101,VR::US,VM::VM1,"Number of Time Slices","NumberOfTimeSlices",false },
  {0x0054,0x0200,VR::DS,VM::VM1,"Start Angle","StartAngle",false },
  {0x0054,0x0202,VR::CS,VM::VM1,"Type of Detector Motion","TypeOfDetectorMotion",false },
  {0x0054,0x0210,VR::IS,VM::VM1_n,"Trigger Vector","TriggerVector",false },
  {0x0054,0x0211,VR::US,VM::VM1,"Number of Triggers in Phase","NumberOfTriggersInPhase",false },
  {0x0054,0x0220,VR::SQ,VM::VM1,"View Code Sequence","ViewCodeSequence",false },
  {0x0054,0x0222,VR::SQ,VM::VM1,"View Modifier Code Sequence","ViewModifierCodeSequence",false },
  {0x0054,0x0300,VR::SQ,VM::VM1,"Radionuclide Code Sequence","RadionuclideCodeSequence",false },
  {0x0054,0x0302,VR::SQ,VM::VM1,"Administration Route Code Sequence","AdministrationRouteCodeSequence",false },
  {0x0054,0x0304,VR::SQ,VM::VM1,"Radiopharmaceutical Code Sequence","RadiopharmaceuticalCodeSequence",false },
  {0x0054,0x0306,VR::SQ,VM::VM1,"Calibration Data Sequence","CalibrationDataSequence",false },
  {0x0054,0x0308,VR::US,VM::VM1,"Energy Window Number","EnergyWindowNumber",false },
  {0x0054,0x0400,VR::SH,VM::VM1,"Image ID","ImageID",false },
  {0x0054,0x0410,VR::SQ,VM::VM1,"Patient Orientation Code Sequence","PatientOrientationCodeSequence",false },
  {0x0054,0x0412,VR::SQ,VM::VM1,"Patient Orientation Modifier Code Sequence","PatientOrientationModifierCodeSequence",false },
  {0x0054,0x0414,VR::SQ,VM::VM1,"Patient Gantry Relationship Code Sequence","PatientGantryRelationshipCodeSequence",false },
  {0x0054,0x0500,VR::CS,VM::VM1,"Slice Progression Direction","SliceProgressionDirection",false },
  {0x0054,0x1000,VR::CS,VM::VM2,"Series Type","SeriesType",false },
  {0x0054,0x1001,VR::CS,VM::VM1,"Units","Units",false },
  {0x0054,0x1002,VR::CS,VM::VM1,"Counts Source","CountsSource",false },
  {0x0054,0x1004,VR::CS,VM::VM1,"Reprojection Method","ReprojectionMethod",false },
  {0x0054,0x1006,VR::CS,VM::VM1,"SUV Type","SUVType",false },
  {0x0054,0x1100,VR::CS,VM::VM1,"Randoms Correction Method","RandomsCorrectionMethod",false },
  {0x0054,0x1101,VR::LO,VM::VM1,"Attenuation Correction Method","AttenuationCorrectionMethod",false },
  {0x0054,0x1102,VR::CS,VM::VM1,"Decay Correction","DecayCorrection",false },
  {0x0054,0x1103,VR::LO,VM::VM1,"Reconstruction Method","ReconstructionMethod",false },
  {0x0054,0x1104,VR::LO,VM::VM1,"Detector Lines of Response Used","DetectorLinesOfResponseUsed",false },
  {0x0054,0x1105,VR::LO,VM::VM1,"Scatter Correction Method","ScatterCorrectionMethod",false },
  {0x0054,0x1200,VR::DS,VM::VM1,"Axial Acceptance","AxialAcceptance",false },
  {0x0054,0x1201,VR::IS,VM::VM2,"Axial Mash","AxialMash",false },
  {0x0054,0x1202,VR::IS,VM::VM1,"Transverse Mash","TransverseMash",false },
  {0x0054,0x1203,VR::DS,VM::VM2,"Detector Element Size","DetectorElementSize",false },
  {0x0054,0x1210,VR::DS,VM::VM1,"Coincidence Window Width","CoincidenceWindowWidth",false },
  {0x0054,0x1220,VR::CS,VM::VM1_n,"Secondary Counts Type","SecondaryCountsType",false },
  {0x0054,0x1300,VR::DS,VM::VM1,"Frame Reference Time","FrameReferenceTime",false },
  {0x0054,0x1310,VR::IS,VM::VM1,"Primary (Prompts) Counts Accumulated","PrimaryPromptsCountsAccumulated",false },
  {0x0054,0x1311,VR::IS,VM::VM1_n,"Secondary Counts Accumulated","SecondaryCountsAccumulated",false },
  {0x0054,0x1320,VR::DS,VM::VM1,"Slice Sensitivity Factor","SliceSensitivityFactor",false },
  {0x0054,0x1321,VR::DS,VM::VM1,"Decay Factor","DecayFactor",false },
  {0x0054,0x1322,VR::DS,VM::VM1,"Dose Calibration Factor","DoseCalibrationFactor",false },
  {0x0054,0x1323,VR::DS,VM::VM1,"Scatter Fraction Factor","ScatterFractionFactor",false },
  {0x0054,0x1324,VR::DS,VM::VM1,"Dead Time Factor","DeadTimeFactor",false },
  {0x0054,0x1330,VR::US,VM::VM1,"Image Index","ImageIndex",false },
  {0x0054,0x1400,VR::CS,VM::VM1_n,"Counts Included","CountsIncluded",true },
  {0x0054,0x1401,VR::CS,VM::VM1,"Dead Time Correction Flag","DeadTimeCorrectionFlag",true },
  {0x0060,0x3000,VR::SQ,VM::VM1,"Histogram Sequence","HistogramSequence",false },
  {0x0060,0x3002,VR::US,VM::VM1,"Histogram Number of Bins","HistogramNumberOfBins",false },
  {0x0060,0x3004,VR::US_SS,VM::VM1,"Histogram First Bin Value","HistogramFirstBinValue",false },
  {0x0060,0x3006,VR::US_SS,VM::VM1,"Histogram Last Bin Value","HistogramLastBinValue",false },
  {0x0060,0x3008,VR::US,VM::VM1,"Histogram Bin Width","HistogramBinWidth",false },
  {0x0060,0x3010,VR::LO,VM::VM1,"Histogram Explanation","HistogramExplanation",false },
  {0x0060,0x3020,VR::UL,VM::VM1_n,"Histogram Data","HistogramData",false },
  {0x0062,0x0001,VR::CS,VM::VM1,"Segmentation Type","SegmentationType",false },
  {0x0062,0x0002,VR::SQ,VM::VM1,"Segment Sequence","SegmentSequence",false },
  {0x0062,0x0003,VR::SQ,VM::VM1,"Segmented Property Category Code Sequence","SegmentedPropertyCategoryCodeSequence",false },
  {0x0062,0x0004,VR::US,VM::VM1,"Segment Number","SegmentNumber",false },
  {0x0062,0x0005,VR::LO,VM::VM1,"Segment Label","SegmentLabel",false },
  {0x0062,0x0006,VR::ST,VM::VM1,"Segment Description","SegmentDescription",false },
  {0x0062,0x0008,VR::CS,VM::VM1,"Segment Algorithm Type","SegmentAlgorithmType",false },
  {0x0062,0x0009,VR::LO,VM::VM1,"Segment Algorithm Name","SegmentAlgorithmName",false },
  {0x0062,0x000a,VR::SQ,VM::VM1,"Segment Identification Sequence","SegmentIdentificationSequence",false },
  {0x0062,0x000b,VR::US,VM::VM1_n,"Referenced Segment Number","ReferencedSegmentNumber",false },
  {0x0062,0x000c,VR::US,VM::VM1,"Recommended Display Grayscale Value","RecommendedDisplayGrayscaleValue",false },
  {0x0062,0x000d,VR::US,VM::VM3,"Recommended Display CIELab Value","RecommendedDisplayCIELabValue",false },
  {0x0062,0x000e,VR::US,VM::VM1,"Maximum Fractional Value","MaximumFractionalValue",false },
  {0x0062,0x000f,VR::SQ,VM::VM1,"Segmented Property Type Code Sequence","SegmentedPropertyTypeCodeSequence",false },
  {0x0062,0x0010,VR::CS,VM::VM1,"Segmentation Fractional Type","SegmentationFractionalType",false },
  {0x0064,0x0002,VR::SQ,VM::VM1,"Deformable Registration Sequence","DeformableRegistrationSequence",false },
  {0x0064,0x0003,VR::UI,VM::VM1,"Source Frame of Reference UID","SourceFrameOfReferenceUID",false },
  {0x0064,0x0005,VR::SQ,VM::VM1,"Deformable Registration Grid Sequence","DeformableRegistrationGridSequence",false },
  {0x0064,0x0007,VR::UL,VM::VM3,"Grid Dimensions","GridDimensions",false },
  {0x0064,0x0008,VR::FD,VM::VM3,"Grid Resolution","GridResolution",false },
  {0x0064,0x0009,VR::OF,VM::VM1,"Vector Grid Data","VectorGridData",false },
  {0x0064,0x000f,VR::SQ,VM::VM1,"Pre Deformation Matrix Registration Sequence","PreDeformationMatrixRegistrationSequence",false },
  {0x0064,0x0010,VR::SQ,VM::VM1,"Post Deformation Matrix Registration Sequence","PostDeformationMatrixRegistrationSequence",false },
  {0x0066,0x0001,VR::UL,VM::VM1,"Number of Surfaces","NumberOfSurfaces",false },
  {0x0066,0x0002,VR::SQ,VM::VM1,"Surface Sequence","SurfaceSequence",false },
  {0x0066,0x0003,VR::UL,VM::VM1,"Surface Number","SurfaceNumber",false },
  {0x0066,0x0004,VR::LT,VM::VM1,"Surface Comments","SurfaceComments",false },
  {0x0066,0x0009,VR::CS,VM::VM1,"Surface Processing","SurfaceProcessing",false },
  {0x0066,0x000a,VR::FL,VM::VM1,"Surface Processing Ratio","SurfaceProcessingRatio",false },
  {0x0066,0x000b,VR::LO,VM::VM1,"Surface Processing Description","SurfaceProcessingDescription",false },
  {0x0066,0x000c,VR::FL,VM::VM1,"Recommended Presentation Opacity","RecommendedPresentationOpacity",false },
  {0x0066,0x000d,VR::CS,VM::VM1,"Recommended Presentation Type","RecommendedPresentationType",false },
  {0x0066,0x000e,VR::CS,VM::VM1,"Finite Volume","FiniteVolume",false },
  {0x0066,0x0010,VR::CS,VM::VM1,"Manifold","Manifold",false },
  {0x0066,0x0011,VR::SQ,VM::VM1,"Surface Points Sequence","SurfacePointsSequence",false },
  {0x0066,0x0012,VR::SQ,VM::VM1,"Surface Points Normals Sequence","SurfacePointsNormalsSequence",false },
  {0x0066,0x0013,VR::SQ,VM::VM1,"Surface Mesh Primitives Sequence","SurfaceMeshPrimitivesSequence",false },
  {0x0066,0x0015,VR::UL,VM::VM1,"Number of Surface Points","NumberOfSurfacePoints",false },
  {0x0066,0x0016,VR::OF,VM::VM1,"Point Coordinates Data","PointCoordinatesData",false },
  {0x0066,0x0017,VR::FL,VM::VM3,"Point Position Accuracy","PointPositionAccuracy",false },
  {0x0066,0x0018,VR::FL,VM::VM1,"Mean Point Distance","MeanPointDistance",false },
  {0x0066,0x0019,VR::FL,VM::VM1,"Maximum Point Distance","MaximumPointDistance",false },
  {0x0066,0x001a,VR::FL,VM::VM6,"Points Bounding Box Coordinates","PointsBoundingBoxCoordinates",false },
  {0x0066,0x001b,VR::FL,VM::VM3,"Axis of Rotation","AxisOfRotation",false },
  {0x0066,0x001c,VR::FL,VM::VM3,"Center of Rotation","CenterOfRotation",false },
  {0x0066,0x001e,VR::UL,VM::VM1,"Number of Vectors","NumberOfVectors",false },
  {0x0066,0x001f,VR::US,VM::VM1,"Vector Dimensionality","VectorDimensionality",false },
  {0x0066,0x0020,VR::FL,VM::VM1_n,"Vector Accuracy","VectorAccuracy",false },
  {0x0066,0x0021,VR::OF,VM::VM1,"Vector Coordinate Data","VectorCoordinateData",false },
  {0x0066,0x0023,VR::OW,VM::VM1,"Triangle Point Index List","TrianglePointIndexList",false },
  {0x0066,0x0024,VR::OW,VM::VM1,"Edge Point Index List","EdgePointIndexList",false },
  {0x0066,0x0025,VR::OW,VM::VM1,"Vertex Point Index List","VertexPointIndexList",false },
  {0x0066,0x0026,VR::SQ,VM::VM1,"Triangle Strip Sequence","TriangleStripSequence",false },
  {0x0066,0x0027,VR::SQ,VM::VM1,"Triangle Fan Sequence","TriangleFanSequence",false },
  {0x0066,0x0028,VR::SQ,VM::VM1,"Line Sequence","LineSequence",false },
  {0x0066,0x0029,VR::OW,VM::VM1,"Primitive Point Index List","PrimitivePointIndexList",false },
  {0x0066,0x002a,VR::UL,VM::VM1,"Surface Count","SurfaceCount",false },
  {0x0066,0x002b,VR::SQ,VM::VM1,"Referenced Surface Sequence","ReferencedSurfaceSequence",false },
  {0x0066,0x002c,VR::UL,VM::VM1,"Referenced Surface Number","ReferencedSurfaceNumber",false },
  {0x0066,0x002d,VR::SQ,VM::VM1,"Segment Surface Generation Algorithm Identification Sequence","SegmentSurfaceGenerationAlgorithmIdentificationSequence",false },
  {0x0066,0x002e,VR::SQ,VM::VM1,"Segment Surface Source Instance Sequence","SegmentSurfaceSourceInstanceSequence",false },
  {0x0066,0x002f,VR::SQ,VM::VM1,"Algorithm Family Code Sequence","AlgorithmFamilyCodeSequence",false },
  {0x0066,0x0030,VR::SQ,VM::VM1,"Algorithm Name Code Sequence","AlgorithmNameCodeSequence",false },
  {0x0066,0x0031,VR::LO,VM::VM1,"Algorithm Version","AlgorithmVersion",false },
  {0x0066,0x0032,VR::LT,VM::VM1,"Algorithm Parameters","AlgorithmParameters",false },
  {0x0066,0x0034,VR::SQ,VM::VM1,"Facet Sequence","FacetSequence",false },
  {0x0066,0x0035,VR::SQ,VM::VM1,"Surface Processing Algorithm Identification Sequence","SurfaceProcessingAlgorithmIdentificationSequence",false },
  {0x0066,0x0036,VR::LO,VM::VM1,"Algorithm Name","AlgorithmName",false },
  {0x0068,0x6210,VR::LO,VM::VM1,"Implant Size","ImplantSize",false },
  {0x0068,0x6221,VR::LO,VM::VM1,"Implant Template Version","ImplantTemplateVersion",false },
  {0x0068,0x6222,VR::SQ,VM::VM1,"Replaced Implant Template Sequence","ReplacedImplantTemplateSequence",false },
  {0x0068,0x6223,VR::CS,VM::VM1,"Implant Type","ImplantType",false },
  {0x0068,0x6224,VR::SQ,VM::VM1,"Derivation Implant Template Sequence","DerivationImplantTemplateSequence",false },
  {0x0068,0x6225,VR::SQ,VM::VM1,"Original Implant Template Sequence","OriginalImplantTemplateSequence",false },
  {0x0068,0x6226,VR::DT,VM::VM1,"Effective DateTime","EffectiveDateTime",false },
  {0x0068,0x6230,VR::SQ,VM::VM1,"Implant Target Anatomy Sequence","ImplantTargetAnatomySequence",false },
  {0x0068,0x6260,VR::SQ,VM::VM1,"Information From Manufacturer Sequence","InformationFromManufacturerSequence",false },
  {0x0068,0x6265,VR::SQ,VM::VM1,"Notification From Manufacturer Sequence","NotificationFromManufacturerSequence",false },
  {0x0068,0x6270,VR::DT,VM::VM1,"Information Issue DateTime","InformationIssueDateTime",false },
  {0x0068,0x6280,VR::ST,VM::VM1,"Information Summary","InformationSummary",false },
  {0x0068,0x62a0,VR::SQ,VM::VM1,"Implant Regulatory Disapproval Code Sequence","ImplantRegulatoryDisapprovalCodeSequence",false },
  {0x0068,0x62a5,VR::FD,VM::VM1,"Overall Template Spatial Tolerance","OverallTemplateSpatialTolerance",false },
  {0x0068,0x62c0,VR::SQ,VM::VM1,"HPGL Document Sequence","HPGLDocumentSequence",false },
  {0x0068,0x62d0,VR::US,VM::VM1,"HPGL Document ID","HPGLDocumentID",false },
  {0x0068,0x62d5,VR::LO,VM::VM1,"HPGL Document Label","HPGLDocumentLabel",false },
  {0x0068,0x62e0,VR::SQ,VM::VM1,"View Orientation Code Sequence","ViewOrientationCodeSequence",false },
  {0x0068,0x62f0,VR::FD,VM::VM9,"View Orientation Modifier","ViewOrientationModifier",false },
  {0x0068,0x62f2,VR::FD,VM::VM1,"HPGL Document Scaling","HPGLDocumentScaling",false },
  {0x0068,0x6300,VR::OB,VM::VM1,"HPGL Document","HPGLDocument",false },
  {0x0068,0x6310,VR::US,VM::VM1,"HPGL Contour Pen Number","HPGLContourPenNumber",false },
  {0x0068,0x6320,VR::SQ,VM::VM1,"HPGL Pen Sequence","HPGLPenSequence",false },
  {0x0068,0x6330,VR::US,VM::VM1,"HPGL Pen Number","HPGLPenNumber",false },
  {0x0068,0x6340,VR::LO,VM::VM1,"HPGL Pen Label","HPGLPenLabel",false },
  {0x0068,0x6345,VR::ST,VM::VM1,"HPGL Pen Description","HPGLPenDescription",false },
  {0x0068,0x6346,VR::FD,VM::VM2,"Recommended Rotation Point","RecommendedRotationPoint",false },
  {0x0068,0x6347,VR::FD,VM::VM4,"Bounding Rectangle","BoundingRectangle",false },
  {0x0068,0x6350,VR::US,VM::VM1_n,"Implant Template 3D Model Surface Number","ImplantTemplate3DModelSurfaceNumber",false },
  {0x0068,0x6360,VR::SQ,VM::VM1,"Surface Model Description Sequence","SurfaceModelDescriptionSequence",false },
  {0x0068,0x6380,VR::LO,VM::VM1,"Surface Model Label","SurfaceModelLabel",false },
  {0x0068,0x6390,VR::FD,VM::VM1,"Surface Model Scaling Factor","SurfaceModelScalingFactor",false },
  {0x0068,0x63a0,VR::SQ,VM::VM1,"Materials Code Sequence","MaterialsCodeSequence",false },
  {0x0068,0x63a4,VR::SQ,VM::VM1,"Coating Materials Code Sequence","CoatingMaterialsCodeSequence",false },
  {0x0068,0x63a8,VR::SQ,VM::VM1,"Implant Type Code Sequence","ImplantTypeCodeSequence",false },
  {0x0068,0x63ac,VR::SQ,VM::VM1,"Fixation Method Code Sequence","FixationMethodCodeSequence",false },
  {0x0068,0x63b0,VR::SQ,VM::VM1,"Mating Feature Sets Sequence","MatingFeatureSetsSequence",false },
  {0x0068,0x63c0,VR::US,VM::VM1,"Mating Feature Set ID","MatingFeatureSetID",false },
  {0x0068,0x63d0,VR::LO,VM::VM1,"Mating Feature Set Label","MatingFeatureSetLabel",false },
  {0x0068,0x63e0,VR::SQ,VM::VM1,"Mating Feature Sequence","MatingFeatureSequence",false },
  {0x0068,0x63f0,VR::US,VM::VM1,"Mating Feature ID","MatingFeatureID",false },
  {0x0068,0x6400,VR::SQ,VM::VM1,"Mating Feature Degree of Freedom Sequence","MatingFeatureDegreeOfFreedomSequence",false },
  {0x0068,0x6410,VR::US,VM::VM1,"Degree of Freedom ID","DegreeOfFreedomID",false },
  {0x0068,0x6420,VR::CS,VM::VM1,"Degree of Freedom Type","DegreeOfFreedomType",false },
  {0x0068,0x6430,VR::SQ,VM::VM1,"2D Mating Feature Coordinates Sequence","TwoDMatingFeatureCoordinatesSequence",false },
  {0x0068,0x6440,VR::US,VM::VM1,"Referenced HPGL Document ID","ReferencedHPGLDocumentID",false },
  {0x0068,0x6450,VR::FD,VM::VM2,"2D Mating Point","TwoDMatingPoint",false },
  {0x0068,0x6460,VR::FD,VM::VM4,"2D Mating Axes","TwoDMatingAxes",false },
  {0x0068,0x6470,VR::SQ,VM::VM1,"2D Degree of Freedom Sequence","TwoDDegreeOfFreedomSequence",false },
  {0x0068,0x6490,VR::FD,VM::VM3,"3D Degree of Freedom Axis","ThreeDDegreeOfFreedomAxis",false },
  {0x0068,0x64a0,VR::FD,VM::VM2,"Range of Freedom","RangeOfFreedom",false },
  {0x0068,0x64c0,VR::FD,VM::VM3,"3D Mating Point","ThreeDMatingPoint",false },
  {0x0068,0x64d0,VR::FD,VM::VM9,"3D Mating Axes","ThreeDMatingAxes",false },
  {0x0068,0x64f0,VR::FD,VM::VM3,"2D Degree of Freedom Axis","TwoDDegreeOfFreedomAxis",false },
  {0x0068,0x6500,VR::SQ,VM::VM1,"Planning Landmark Point Sequence","PlanningLandmarkPointSequence",false },
  {0x0068,0x6510,VR::SQ,VM::VM1,"Planning Landmark Line Sequence","PlanningLandmarkLineSequence",false },
  {0x0068,0x6520,VR::SQ,VM::VM1,"Planning Landmark Plane Sequence","PlanningLandmarkPlaneSequence",false },
  {0x0068,0x6530,VR::US,VM::VM1,"Planning Landmark ID","PlanningLandmarkID",false },
  {0x0068,0x6540,VR::LO,VM::VM1,"Planning Landmark Description","PlanningLandmarkDescription",false },
  {0x0068,0x6545,VR::SQ,VM::VM1,"Planning Landmark Identification Code Sequence","PlanningLandmarkIdentificationCodeSequence",false },
  {0x0068,0x6550,VR::SQ,VM::VM1,"2D Point Coordinates Sequence","TwoDPointCoordinatesSequence",false },
  {0x0068,0x6560,VR::FD,VM::VM2,"2D Point Coordinates","TwoDPointCoordinates",false },
  {0x0068,0x6590,VR::FD,VM::VM3,"3D Point Coordinates","ThreeDPointCoordinates",false },
  {0x0068,0x65a0,VR::SQ,VM::VM1,"2D Line Coordinates Sequence","TwoDLineCoordinatesSequence",false },
  {0x0068,0x65b0,VR::FD,VM::VM4,"2D Line Coordinates","TwoDLineCoordinates",false },
  {0x0068,0x65d0,VR::FD,VM::VM6,"3D Line Coordinates","ThreeDLineCoordinates",false },
  {0x0068,0x65e0,VR::SQ,VM::VM1,"2D Plane Coordinates Sequence","TwoDPlaneCoordinatesSequence",false },
  {0x0068,0x65f0,VR::FD,VM::VM4,"2D Plane Intersection","TwoDPlaneIntersection",false },
  {0x0068,0x6610,VR::FD,VM::VM3,"3D Plane Origin","ThreeDPlaneOrigin",false },
  {0x0068,0x6620,VR::FD,VM::VM3,"3D Plane Normal","ThreeDPlaneNormal",false },
  {0x0070,0x0001,VR::SQ,VM::VM1,"Graphic Annotation Sequence","GraphicAnnotationSequence",false },
  {0x0070,0x0002,VR::CS,VM::VM1,"Graphic Layer","GraphicLayer",false },
  {0x0070,0x0003,VR::CS,VM::VM1,"Bounding Box Annotation Units","BoundingBoxAnnotationUnits",false },
  {0x0070,0x0004,VR::CS,VM::VM1,"Anchor Point Annotation Units","AnchorPointAnnotationUnits",false },
  {0x0070,0x0005,VR::CS,VM::VM1,"Graphic Annotation Units","GraphicAnnotationUnits",false },
  {0x0070,0x0006,VR::ST,VM::VM1,"Unformatted Text Value","UnformattedTextValue",false },
  {0x0070,0x0008,VR::SQ,VM::VM1,"Text Object Sequence","TextObjectSequence",false },
  {0x0070,0x0009,VR::SQ,VM::VM1,"Graphic Object Sequence","GraphicObjectSequence",false },
  {0x0070,0x0010,VR::FL,VM::VM2,"Bounding Box Top Left Hand Corner","BoundingBoxTopLeftHandCorner",false },
  {0x0070,0x0011,VR::FL,VM::VM2,"Bounding Box Bottom Right Hand Corner","BoundingBoxBottomRightHandCorner",false },
  {0x0070,0x0012,VR::CS,VM::VM1,"Bounding Box Text Horizontal Justification","BoundingBoxTextHorizontalJustification",false },
  {0x0070,0x0014,VR::FL,VM::VM2,"Anchor Point","AnchorPoint",false },
  {0x0070,0x0015,VR::CS,VM::VM1,"Anchor Point Visibility","AnchorPointVisibility",false },
  {0x0070,0x0020,VR::US,VM::VM1,"Graphic Dimensions","GraphicDimensions",false },
  {0x0070,0x0021,VR::US,VM::VM1,"Number of Graphic Points","NumberOfGraphicPoints",false },
  {0x0070,0x0022,VR::FL,VM::VM2_n,"Graphic Data","GraphicData",false },
  {0x0070,0x0023,VR::CS,VM::VM1,"Graphic Type","GraphicType",false },
  {0x0070,0x0024,VR::CS,VM::VM1,"Graphic Filled","GraphicFilled",false },
  {0x0070,0x0040,VR::IS,VM::VM1,"Image Rotation (Retired)","ImageRotationRetired",true },
  {0x0070,0x0041,VR::CS,VM::VM1,"Image Horizontal Flip","ImageHorizontalFlip",false },
  {0x0070,0x0042,VR::US,VM::VM1,"Image Rotation","ImageRotation",false },
  {0x0070,0x0050,VR::US,VM::VM2,"Displayed Area Top Left Hand Corner (Trial)","DisplayedAreaTopLeftHandCornerTrial",true },
  {0x0070,0x0051,VR::US,VM::VM2,"Displayed Area Bottom Right Hand Corner (Trial)","DisplayedAreaBottomRightHandCornerTrial",true },
  {0x0070,0x0052,VR::SL,VM::VM2,"Displayed Area Top Left Hand Corner","DisplayedAreaTopLeftHandCorner",false },
  {0x0070,0x0053,VR::SL,VM::VM2,"Displayed Area Bottom Right Hand Corner","DisplayedAreaBottomRightHandCorner",false },
  {0x0070,0x005a,VR::SQ,VM::VM1,"Displayed Area Selection Sequence","DisplayedAreaSelectionSequence",false },
  {0x0070,0x0060,VR::SQ,VM::VM1,"Graphic Layer Sequence","GraphicLayerSequence",false },
  {0x0070,0x0062,VR::IS,VM::VM1,"Graphic Layer Order","GraphicLayerOrder",false },
  {0x0070,0x0066,VR::US,VM::VM1,"Graphic Layer Recommended Display Grayscale Value","GraphicLayerRecommendedDisplayGrayscaleValue",false },
  {0x0070,0x0067,VR::US,VM::VM3,"Graphic Layer Recommended Display RGB Value","GraphicLayerRecommendedDisplayRGBValue",true },
  {0x0070,0x0068,VR::LO,VM::VM1,"Graphic Layer Description","GraphicLayerDescription",false },
  {0x0070,0x0080,VR::CS,VM::VM1,"Content Label","ContentLabel",false },
  {0x0070,0x0081,VR::LO,VM::VM1,"Content Description","ContentDescription",false },
  {0x0070,0x0082,VR::DA,VM::VM1,"Presentation Creation Date","PresentationCreationDate",false },
  {0x0070,0x0083,VR::TM,VM::VM1,"Presentation Creation Time","PresentationCreationTime",false },
  {0x0070,0x0084,VR::PN,VM::VM1,"Content Creator's Name","ContentCreatorName",false },
  {0x0070,0x0086,VR::SQ,VM::VM1,"Content Creator's Identification Code Sequence","ContentCreatorIdentificationCodeSequence",false },
  {0x0070,0x0087,VR::SQ,VM::VM1,"Alternate Content Description Sequence","AlternateContentDescriptionSequence",false },
  {0x0070,0x0100,VR::CS,VM::VM1,"Presentation Size Mode","PresentationSizeMode",false },
  {0x0070,0x0101,VR::DS,VM::VM2,"Presentation Pixel Spacing","PresentationPixelSpacing",false },
  {0x0070,0x0102,VR::IS,VM::VM2,"Presentation Pixel Aspect Ratio","PresentationPixelAspectRatio",false },
  {0x0070,0x0103,VR::FL,VM::VM1,"Presentation Pixel Magnification Ratio","PresentationPixelMagnificationRatio",false },
  {0x0070,0x0207,VR::LO,VM::VM1,"Graphic Group Label","GraphicGroupLabel",false },
  {0x0070,0x0208,VR::ST,VM::VM1,"Graphic Group Description","GraphicGroupDescription",false },
  {0x0070,0x0209,VR::SQ,VM::VM1,"Compound Graphic Sequence","CompoundGraphicSequence",false },
  {0x0070,0x0226,VR::UL,VM::VM1,"Compound Graphic Instance ID","CompoundGraphicInstanceID",false },
  {0x0070,0x0227,VR::LO,VM::VM1,"Font Name","FontName",false },
  {0x0070,0x0228,VR::CS,VM::VM1,"Font Name Type","FontNameType",false },
  {0x0070,0x0229,VR::LO,VM::VM1,"CSS Font Name","CSSFontName",false },
  {0x0070,0x0230,VR::FD,VM::VM1,"Rotation Angle","RotationAngle",false },
  {0x0070,0x0231,VR::SQ,VM::VM1,"Text Style Sequence","TextStyleSequence",false },
  {0x0070,0x0232,VR::SQ,VM::VM1,"Line Style Sequence","LineStyleSequence",false },
  {0x0070,0x0233,VR::SQ,VM::VM1,"Fill Style Sequence","FillStyleSequence",false },
  {0x0070,0x0234,VR::SQ,VM::VM1,"Graphic Group Sequence","GraphicGroupSequence",false },
  {0x0070,0x0241,VR::US,VM::VM3,"Text Color CIELab Value","TextColorCIELabValue",false },
  {0x0070,0x0242,VR::CS,VM::VM1,"Horizontal Alignment","HorizontalAlignment",false },
  {0x0070,0x0243,VR::CS,VM::VM1,"Vertical Alignment","VerticalAlignment",false },
  {0x0070,0x0244,VR::CS,VM::VM1,"Shadow Style","ShadowStyle",false },
  {0x0070,0x0245,VR::FL,VM::VM1,"Shadow Offset X","ShadowOffsetX",false },
  {0x0070,0x0246,VR::FL,VM::VM1,"Shadow Offset Y","ShadowOffsetY",false },
  {0x0070,0x0247,VR::US,VM::VM3,"Shadow Color CIELab Value","ShadowColorCIELabValue",false },
  {0x0070,0x0248,VR::CS,VM::VM1,"Underlined","Underlined",false },
  {0x0070,0x0249,VR::CS,VM::VM1,"Bold","Bold",false },
  {0x0070,0x0250,VR::CS,VM::VM1,"Italic","Italic",false },
  {0x0070,0x0251,VR::US,VM::VM3,"Pattern On Color CIELab Value","PatternOnColorCIELabValue",false },
  {0x0070,0x0252,VR::US,VM::VM3,"Pattern Off Color CIELab Value","PatternOffColorCIELabValue",false },
  {0x0070,0x0253,VR::FL,VM::VM1,"Line Thickness","LineThickness",false },
  {0x0070,0x0254,VR::CS,VM::VM1,"Line Dashing Style","LineDashingStyle",false },
  {0x0070,0x0255,VR::UL,VM::VM1,"Line Pattern","LinePattern",false },
  {0x0070,0x0256,VR::OB,VM::VM1,"Fill Pattern","FillPattern",false },
  {0x0070,0x0257,VR::CS,VM::VM1,"Fill Mode","FillMode",false },
  {0x0070,0x0258,VR::FL,VM::VM1,"Shadow Opacity","ShadowOpacity",false },
  {0x0070,0x0261,VR::FL,VM::VM1,"Gap Length","GapLength",false },
  {0x0070,0x0262,VR::FL,VM::VM1,"Diameter of Visibility","DiameterOfVisibility",false },
  {0x0070,0x0273,VR::FL,VM::VM2,"Rotation Point","RotationPoint",false },
  {0x0070,0x0274,VR::CS,VM::VM1,"Tick Alignment","TickAlignment",false },
  {0x0070,0x0278,VR::CS,VM::VM1,"Show Tick Label","ShowTickLabel",false },
  {0x0070,0x0279,VR::CS,VM::VM1,"Tick Label Alignment","TickLabelAlignment",false },
  {0x0070,0x0282,VR::CS,VM::VM1,"Compound Graphic Units","CompoundGraphicUnits",false },
  {0x0070,0x0284,VR::FL,VM::VM1,"Pattern On Opacity","PatternOnOpacity",false },
  {0x0070,0x0285,VR::FL,VM::VM1,"Pattern Off Opacity","PatternOffOpacity",false },
  {0x0070,0x0287,VR::SQ,VM::VM1,"Major Ticks Sequence","MajorTicksSequence",false },
  {0x0070,0x0288,VR::FL,VM::VM1,"Tick Position","TickPosition",false },
  {0x0070,0x0289,VR::SH,VM::VM1,"Tick Label","TickLabel",false },
  {0x0070,0x0294,VR::CS,VM::VM1,"Compound Graphic Type","CompoundGraphicType",false },
  {0x0070,0x0295,VR::UL,VM::VM1,"Graphic Group ID","GraphicGroupID",false },
  {0x0070,0x0306,VR::CS,VM::VM1,"Shape Type","ShapeType",false },
  {0x0070,0x0308,VR::SQ,VM::VM1,"Registration Sequence","RegistrationSequence",false },
  {0x0070,0x0309,VR::SQ,VM::VM1,"Matrix Registration Sequence","MatrixRegistrationSequence",false },
  {0x0070,0x030a,VR::SQ,VM::VM1,"Matrix Sequence","MatrixSequence",false },
  {0x0070,0x030c,VR::CS,VM::VM1,"Frame of Reference Transformation Matrix Type","FrameOfReferenceTransformationMatrixType",false },
  {0x0070,0x030d,VR::SQ,VM::VM1,"Registration Type Code Sequence","RegistrationTypeCodeSequence",false },
  {0x0070,0x030f,VR::ST,VM::VM1,"Fiducial Description","FiducialDescription",false },
  {0x0070,0x0310,VR::SH,VM::VM1,"Fiducial Identifier","FiducialIdentifier",false },
  {0x0070,0x0311,VR::SQ,VM::VM1,"Fiducial Identifier Code Sequence","FiducialIdentifierCodeSequence",false },
  {0x0070,0x0312,VR::FD,VM::VM1,"Contour Uncertainty Radius","ContourUncertaintyRadius",false },
  {0x0070,0x0314,VR::SQ,VM::VM1,"Used Fiducials Sequence","UsedFiducialsSequence",false },
  {0x0070,0x0318,VR::SQ,VM::VM1,"Graphic Coordinates Data Sequence","GraphicCoordinatesDataSequence",false },
  {0x0070,0x031a,VR::UI,VM::VM1,"Fiducial UID","FiducialUID",false },
  {0x0070,0x031c,VR::SQ,VM::VM1,"Fiducial Set Sequence","FiducialSetSequence",false },
  {0x0070,0x031e,VR::SQ,VM::VM1,"Fiducial Sequence","FiducialSequence",false },
  {0x0070,0x0401,VR::US,VM::VM3,"Graphic Layer Recommended Display CIELab Value","GraphicLayerRecommendedDisplayCIELabValue",false },
  {0x0070,0x0402,VR::SQ,VM::VM1,"Blending Sequence","BlendingSequence",false },
  {0x0070,0x0403,VR::FL,VM::VM1,"Relative Opacity","RelativeOpacity",false },
  {0x0070,0x0404,VR::SQ,VM::VM1,"Referenced Spatial Registration Sequence","ReferencedSpatialRegistrationSequence",false },
  {0x0070,0x0405,VR::CS,VM::VM1,"Blending Position","BlendingPosition",false },
  {0x0072,0x0002,VR::SH,VM::VM1,"Hanging Protocol Name","HangingProtocolName",false },
  {0x0072,0x0004,VR::LO,VM::VM1,"Hanging Protocol Description","HangingProtocolDescription",false },
  {0x0072,0x0006,VR::CS,VM::VM1,"Hanging Protocol Level","HangingProtocolLevel",false },
  {0x0072,0x0008,VR::LO,VM::VM1,"Hanging Protocol Creator","HangingProtocolCreator",false },
  {0x0072,0x000a,VR::DT,VM::VM1,"Hanging Protocol Creation DateTime","HangingProtocolCreationDateTime",false },
  {0x0072,0x000c,VR::SQ,VM::VM1,"Hanging Protocol Definition Sequence","HangingProtocolDefinitionSequence",false },
  {0x0072,0x000e,VR::SQ,VM::VM1,"Hanging Protocol User Identification Code Sequence","HangingProtocolUserIdentificationCodeSequence",false },
  {0x0072,0x0010,VR::LO,VM::VM1,"Hanging Protocol User Group Name","HangingProtocolUserGroupName",false },
  {0x0072,0x0012,VR::SQ,VM::VM1,"Source Hanging Protocol Sequence","SourceHangingProtocolSequence",false },
  {0x0072,0x0014,VR::US,VM::VM1,"Number of Priors Referenced","NumberOfPriorsReferenced",false },
  {0x0072,0x0020,VR::SQ,VM::VM1,"Image Sets Sequence","ImageSetsSequence",false },
  {0x0072,0x0022,VR::SQ,VM::VM1,"Image Set Selector Sequence","ImageSetSelectorSequence",false },
  {0x0072,0x0024,VR::CS,VM::VM1,"Image Set Selector Usage Flag","ImageSetSelectorUsageFlag",false },
  {0x0072,0x0026,VR::AT,VM::VM1,"Selector Attribute","SelectorAttribute",false },
  {0x0072,0x0028,VR::US,VM::VM1,"Selector Value Number","SelectorValueNumber",false },
  {0x0072,0x0030,VR::SQ,VM::VM1,"Time Based Image Sets Sequence","TimeBasedImageSetsSequence",false },
  {0x0072,0x0032,VR::US,VM::VM1,"Image Set Number","ImageSetNumber",false },
  {0x0072,0x0034,VR::CS,VM::VM1,"Image Set Selector Category","ImageSetSelectorCategory",false },
  {0x0072,0x0038,VR::US,VM::VM2,"Relative Time","RelativeTime",false },
  {0x0072,0x003a,VR::CS,VM::VM1,"Relative Time Units","RelativeTimeUnits",false },
  {0x0072,0x003c,VR::SS,VM::VM2,"Abstract Prior Value","AbstractPriorValue",false },
  {0x0072,0x003e,VR::SQ,VM::VM1,"Abstract Prior Code Sequence","AbstractPriorCodeSequence",false },
  {0x0072,0x0040,VR::LO,VM::VM1,"Image Set Label","ImageSetLabel",false },
  {0x0072,0x0050,VR::CS,VM::VM1,"Selector Attribute VR","SelectorAttributeVR",false },
  {0x0072,0x0052,VR::AT,VM::VM1_n,"Selector Sequence Pointer","SelectorSequencePointer",false },
  {0x0072,0x0054,VR::LO,VM::VM1_n,"Selector Sequence Pointer Private Creator","SelectorSequencePointerPrivateCreator",false },
  {0x0072,0x0056,VR::LO,VM::VM1,"Selector Attribute Private Creator","SelectorAttributePrivateCreator",false },
  {0x0072,0x0060,VR::AT,VM::VM1_n,"Selector AT Value","SelectorATValue",false },
  {0x0072,0x0062,VR::CS,VM::VM1_n,"Selector CS Value","SelectorCSValue",false },
  {0x0072,0x0064,VR::IS,VM::VM1_n,"Selector IS Value","SelectorISValue",false },
  {0x0072,0x0066,VR::LO,VM::VM1_n,"Selector LO Value","SelectorLOValue",false },
  {0x0072,0x0068,VR::LT,VM::VM1,"Selector LT Value","SelectorLTValue",false },
  {0x0072,0x006a,VR::PN,VM::VM1_n,"Selector PN Value","SelectorPNValue",false },
  {0x0072,0x006c,VR::SH,VM::VM1_n,"Selector SH Value","SelectorSHValue",false },
  {0x0072,0x006e,VR::ST,VM::VM1,"Selector ST Value","SelectorSTValue",false },
  {0x0072,0x0070,VR::UT,VM::VM1,"Selector UT Value","SelectorUTValue",false },
  {0x0072,0x0072,VR::DS,VM::VM1_n,"Selector DS Value","SelectorDSValue",false },
  {0x0072,0x0074,VR::FD,VM::VM1_n,"Selector FD Value","SelectorFDValue",false },
  {0x0072,0x0076,VR::FL,VM::VM1_n,"Selector FL Value","SelectorFLValue",false },
  {0x0072,0x0078,VR::UL,VM::VM1_n,"Selector UL Value","SelectorULValue",false },
  {0x0072,0x007a,VR::US,VM::VM1_n,"Selector US Value","SelectorUSValue",false },
  {0x0072,0x007c,VR::SL,VM::VM1_n,"Selector SL Value","SelectorSLValue",false },
  {0x0072,0x007e,VR::SS,VM::VM1_n,"Selector SS Value","SelectorSSValue",false },
  {0x0072,0x0080,VR::SQ,VM::VM1,"Selector Code Sequence Value","SelectorCodeSequenceValue",false },
  {0x0072,0x0100,VR::US,VM::VM1,"Number of Screens","NumberOfScreens",false },
  {0x0072,0x0102,VR::SQ,VM::VM1,"Nominal Screen Definition Sequence","NominalScreenDefinitionSequence",false },
  {0x0072,0x0104,VR::US,VM::VM1,"Number of Vertical Pixels","NumberOfVerticalPixels",false },
  {0x0072,0x0106,VR::US,VM::VM1,"Number of Horizontal Pixels","NumberOfHorizontalPixels",false },
  {0x0072,0x0108,VR::FD,VM::VM4,"Display Environment Spatial Position","DisplayEnvironmentSpatialPosition",false },
  {0x0072,0x010a,VR::US,VM::VM1,"Screen Minimum Grayscale Bit Depth","ScreenMinimumGrayscaleBitDepth",false },
  {0x0072,0x010c,VR::US,VM::VM1,"Screen Minimum Color Bit Depth","ScreenMinimumColorBitDepth",false },
  {0x0072,0x010e,VR::US,VM::VM1,"Application Maximum Repaint Time","ApplicationMaximumRepaintTime",false },
  {0x0072,0x0200,VR::SQ,VM::VM1,"Display Sets Sequence","DisplaySetsSequence",false },
  {0x0072,0x0202,VR::US,VM::VM1,"Display Set Number","DisplaySetNumber",false },
  {0x0072,0x0203,VR::LO,VM::VM1,"Display Set Label","DisplaySetLabel",false },
  {0x0072,0x0204,VR::US,VM::VM1,"Display Set Presentation Group","DisplaySetPresentationGroup",false },
  {0x0072,0x0206,VR::LO,VM::VM1,"Display Set Presentation Group Description","DisplaySetPresentationGroupDescription",false },
  {0x0072,0x0208,VR::CS,VM::VM1,"Partial Data Display Handling","PartialDataDisplayHandling",false },
  {0x0072,0x0210,VR::SQ,VM::VM1,"Synchronized Scrolling Sequence","SynchronizedScrollingSequence",false },
  {0x0072,0x0212,VR::US,VM::VM2_n,"Display Set Scrolling Group","DisplaySetScrollingGroup",false },
  {0x0072,0x0214,VR::SQ,VM::VM1,"Navigation Indicator Sequence","NavigationIndicatorSequence",false },
  {0x0072,0x0216,VR::US,VM::VM1,"Navigation Display Set","NavigationDisplaySet",false },
  {0x0072,0x0218,VR::US,VM::VM1_n,"Reference Display Sets","ReferenceDisplaySets",false },
  {0x0072,0x0300,VR::SQ,VM::VM1,"Image Boxes Sequence","ImageBoxesSequence",false },
  {0x0072,0x0302,VR::US,VM::VM1,"Image Box Number","ImageBoxNumber",false },
  {0x0072,0x0304,VR::CS,VM::VM1,"Image Box Layout Type","ImageBoxLayoutType",false },
  {0x0072,0x0306,VR::US,VM::VM1,"Image Box Tile Horizontal Dimension","ImageBoxTileHorizontalDimension",false },
  {0x0072,0x0308,VR::US,VM::VM1,"Image Box Tile Vertical Dimension","ImageBoxTileVerticalDimension",false },
  {0x0072,0x0310,VR::CS,VM::VM1,"Image Box Scroll Direction","ImageBoxScrollDirection",false },
  {0x0072,0x0312,VR::CS,VM::VM1,"Image Box Small Scroll Type","ImageBoxSmallScrollType",false },
  {0x0072,0x0314,VR::US,VM::VM1,"Image Box Small Scroll Amount","ImageBoxSmallScrollAmount",false },
  {0x0072,0x0316,VR::CS,VM::VM1,"Image Box Large Scroll Type","ImageBoxLargeScrollType",false },
  {0x0072,0x0318,VR::US,VM::VM1,"Image Box Large Scroll Amount","ImageBoxLargeScrollAmount",false },
  {0x0072,0x0320,VR::US,VM::VM1,"Image Box Overlap Priority","ImageBoxOverlapPriority",false },
  {0x0072,0x0330,VR::FD,VM::VM1,"Cine Relative to Real-Time","CineRelativeToRealTime",false },
  {0x0072,0x0400,VR::SQ,VM::VM1,"Filter Operations Sequence","FilterOperationsSequence",false },
  {0x0072,0x0402,VR::CS,VM::VM1,"Filter-by Category","FilterByCategory",false },
  {0x0072,0x0404,VR::CS,VM::VM1,"Filter-by Attribute Presence","FilterByAttributePresence",false },
  {0x0072,0x0406,VR::CS,VM::VM1,"Filter-by Operator","FilterByOperator",false },
  {0x0072,0x0420,VR::US,VM::VM3,"Structured Display Background CIELab Value","StructuredDisplayBackgroundCIELabValue",false },
  {0x0072,0x0421,VR::US,VM::VM3,"Empty Image Box CIELab Value","EmptyImageBoxCIELabValue",false },
  {0x0072,0x0422,VR::SQ,VM::VM1,"Structured Display Image Box Sequence","StructuredDisplayImageBoxSequence",false },
  {0x0072,0x0424,VR::SQ,VM::VM1,"Structured Display Text Box Sequence","StructuredDisplayTextBoxSequence",false },
  {0x0072,0x0427,VR::SQ,VM::VM1,"Referenced First Frame Sequence","ReferencedFirstFrameSequence",false },
  {0x0072,0x0430,VR::SQ,VM::VM1,"Image Box Synchronization Sequence","ImageBoxSynchronizationSequence",false },
  {0x0072,0x0432,VR::US,VM::VM2_n,"Synchronized Image Box List","SynchronizedImageBoxList",false },
  {0x0072,0x0434,VR::CS,VM::VM1,"Type of Synchronization","TypeOfSynchronization",false },
  {0x0072,0x0500,VR::CS,VM::VM1,"Blending Operation Type","BlendingOperationType",false },
  {0x0072,0x0510,VR::CS,VM::VM1,"Reformatting Operation Type","ReformattingOperationType",false },
  {0x0072,0x0512,VR::FD,VM::VM1,"Reformatting Thickness","ReformattingThickness",false },
  {0x0072,0x0514,VR::FD,VM::VM1,"Reformatting Interval","ReformattingInterval",false },
  {0x0072,0x0516,VR::CS,VM::VM1,"Reformatting Operation Initial View Direction","ReformattingOperationInitialViewDirection",false },
  {0x0072,0x0520,VR::CS,VM::VM1_n,"3D Rendering Type","ThreeDRenderingType",false },
  {0x0072,0x0600,VR::SQ,VM::VM1,"Sorting Operations Sequence","SortingOperationsSequence",false },
  {0x0072,0x0602,VR::CS,VM::VM1,"Sort-by Category","SortByCategory",false },
  {0x0072,0x0604,VR::CS,VM::VM1,"Sorting Direction","SortingDirection",false },
  {0x0072,0x0700,VR::CS,VM::VM2,"Display Set Patient Orientation","DisplaySetPatientOrientation",false },
  {0x0072,0x0702,VR::CS,VM::VM1,"VOI Type","VOIType",false },
  {0x0072,0x0704,VR::CS,VM::VM1,"Pseudo-Color Type","PseudoColorType",false },
  {0x0072,0x0705,VR::SQ,VM::VM1,"Pseudo-Color Palette Instance Reference Sequence","PseudoColorPaletteInstanceReferenceSequence",false },
  {0x0072,0x0706,VR::CS,VM::VM1,"Show Grayscale Inverted","ShowGrayscaleInverted",false },
  {0x0072,0x0710,VR::CS,VM::VM1,"Show Image True Size Flag","ShowImageTrueSizeFlag",false },
  {0x0072,0x0712,VR::CS,VM::VM1,"Show Graphic Annotation Flag","ShowGraphicAnnotationFlag",false },
  {0x0072,0x0714,VR::CS,VM::VM1,"Show Patient Demographics Flag","ShowPatientDemographicsFlag",false },
  {0x0072,0x0716,VR::CS,VM::VM1,"Show Acquisition Techniques Flag","ShowAcquisitionTechniquesFlag",false },
  {0x0072,0x0717,VR::CS,VM::VM1,"Display Set Horizontal Justification","DisplaySetHorizontalJustification",false },
  {0x0072,0x0718,VR::CS,VM::VM1,"Display Set Vertical Justification","DisplaySetVerticalJustification",false },
  {0x0074,0x0120,VR::FD,VM::VM1,"Continuation Start Meterset","ContinuationStartMeterset",false },
  {0x0074,0x0121,VR::FD,VM::VM1,"Continuation End Meterset","ContinuationEndMeterset",false },
  {0x0074,0x1000,VR::CS,VM::VM1,"Procedure Step State","ProcedureStepState",false },
  {0x0074,0x1002,VR::SQ,VM::VM1,"Procedure Step Progress Information Sequence","ProcedureStepProgressInformationSequence",false },
  {0x0074,0x1004,VR::DS,VM::VM1,"Procedure Step Progress","ProcedureStepProgress",false },
  {0x0074,0x1006,VR::ST,VM::VM1,"Procedure Step Progress Description","ProcedureStepProgressDescription",false },
  {0x0074,0x1008,VR::SQ,VM::VM1,"Procedure Step Communications URI Sequence","ProcedureStepCommunicationsURISequence",false },
  {0x0074,0x100a,VR::ST,VM::VM1,"Contact URI","ContactURI",false },
  {0x0074,0x100c,VR::LO,VM::VM1,"Contact Display Name","ContactDisplayName",false },
  {0x0074,0x100e,VR::SQ,VM::VM1,"Procedure Step Discontinuation Reason Code Sequence","ProcedureStepDiscontinuationReasonCodeSequence",false },
  {0x0074,0x1020,VR::SQ,VM::VM1,"Beam Task Sequence","BeamTaskSequence",false },
  {0x0074,0x1022,VR::CS,VM::VM1,"Beam Task Type","BeamTaskType",false },
  {0x0074,0x1024,VR::IS,VM::VM1,"Beam Order Index (Trial)","BeamOrderIndexTrial",true },
  {0x0074,0x1026,VR::FD,VM::VM1,"Table Top Vertical Adjusted Position","TableTopVerticalAdjustedPosition",false },
  {0x0074,0x1027,VR::FD,VM::VM1,"Table Top Longitudinal Adjusted Position","TableTopLongitudinalAdjustedPosition",false },
  {0x0074,0x1028,VR::FD,VM::VM1,"Table Top Lateral Adjusted Position","TableTopLateralAdjustedPosition",false },
  {0x0074,0x102a,VR::FD,VM::VM1,"Patient Support Adjusted Angle","PatientSupportAdjustedAngle",false },
  {0x0074,0x102b,VR::FD,VM::VM1,"Table Top Eccentric Adjusted Angle","TableTopEccentricAdjustedAngle",false },
  {0x0074,0x102c,VR::FD,VM::VM1,"Table Top Pitch Adjusted Angle","TableTopPitchAdjustedAngle",false },
  {0x0074,0x102d,VR::FD,VM::VM1,"Table Top Roll Adjusted Angle","TableTopRollAdjustedAngle",false },
  {0x0074,0x1030,VR::SQ,VM::VM1,"Delivery Verification Image Sequence","DeliveryVerificationImageSequence",false },
  {0x0074,0x1032,VR::CS,VM::VM1,"Verification Image Timing","VerificationImageTiming",false },
  {0x0074,0x1034,VR::CS,VM::VM1,"Double Exposure Flag","DoubleExposureFlag",false },
  {0x0074,0x1036,VR::CS,VM::VM1,"Double Exposure Ordering","DoubleExposureOrdering",false },
  {0x0074,0x1038,VR::DS,VM::VM1,"Double Exposure Meterset (Trial)","DoubleExposureMetersetTrial",true },
  {0x0074,0x103a,VR::DS,VM::VM4,"Double Exposure Field Delta (Trial)","DoubleExposureFieldDeltaTrial",true },
  {0x0074,0x1040,VR::SQ,VM::VM1,"Related Reference RT Image Sequence","RelatedReferenceRTImageSequence",false },
  {0x0074,0x1042,VR::SQ,VM::VM1,"General Machine Verification Sequence","GeneralMachineVerificationSequence",false },
  {0x0074,0x1044,VR::SQ,VM::VM1,"Conventional Machine Verification Sequence","ConventionalMachineVerificationSequence",false },
  {0x0074,0x1046,VR::SQ,VM::VM1,"Ion Machine Verification Sequence","IonMachineVerificationSequence",false },
  {0x0074,0x1048,VR::SQ,VM::VM1,"Failed Attributes Sequence","FailedAttributesSequence",false },
  {0x0074,0x104a,VR::SQ,VM::VM1,"Overridden Attributes Sequence","OverriddenAttributesSequence",false },
  {0x0074,0x104c,VR::SQ,VM::VM1,"Conventional Control Point Verification Sequence","ConventionalControlPointVerificationSequence",false },
  {0x0074,0x104e,VR::SQ,VM::VM1,"Ion Control Point Verification Sequence","IonControlPointVerificationSequence",false },
  {0x0074,0x1050,VR::SQ,VM::VM1,"Attribute Occurrence Sequence","AttributeOccurrenceSequence",false },
  {0x0074,0x1052,VR::AT,VM::VM1,"Attribute Occurrence Pointer","AttributeOccurrencePointer",false },
  {0x0074,0x1054,VR::UL,VM::VM1,"Attribute Item Selector","AttributeItemSelector",false },
  {0x0074,0x1056,VR::LO,VM::VM1,"Attribute Occurrence Private Creator","AttributeOccurrencePrivateCreator",false },
  {0x0074,0x1057,VR::IS,VM::VM1_n,"Selector Sequence Pointer Items","SelectorSequencePointerItems",false },
  {0x0074,0x1200,VR::CS,VM::VM1,"Scheduled Procedure Step Priority","ScheduledProcedureStepPriority",false },
  {0x0074,0x1202,VR::LO,VM::VM1,"Worklist Label","WorklistLabel",false },
  {0x0074,0x1204,VR::LO,VM::VM1,"Procedure Step Label","ProcedureStepLabel",false },
  {0x0074,0x1210,VR::SQ,VM::VM1,"Scheduled Processing Parameters Sequence","ScheduledProcessingParametersSequence",false },
  {0x0074,0x1212,VR::SQ,VM::VM1,"Performed Processing Parameters Sequence","PerformedProcessingParametersSequence",false },
  {0x0074,0x1216,VR::SQ,VM::VM1,"Unified Procedure Step Performed Procedure Sequence","UnifiedProcedureStepPerformedProcedureSequence",false },
  {0x0074,0x1220,VR::SQ,VM::VM1,"Related Procedure Step Sequence","RelatedProcedureStepSequence",true },
  {0x0074,0x1222,VR::LO,VM::VM1,"Procedure Step Relationship Type","ProcedureStepRelationshipType",true },
  {0x0074,0x1224,VR::SQ,VM::VM1,"Replaced Procedure Step Sequence","ReplacedProcedureStepSequence",false },
  {0x0074,0x1230,VR::LO,VM::VM1,"Deletion Lock","DeletionLock",false },
  {0x0074,0x1234,VR::AE,VM::VM1,"Receiving AE","ReceivingAE",false },
  {0x0074,0x1236,VR::AE,VM::VM1,"Requesting AE","RequestingAE",false },
  {0x0074,0x1238,VR::LT,VM::VM1,"Reason for Cancellation","ReasonForCancellation",false },
  {0x0074,0x1242,VR::CS,VM::VM1,"SCP Status","SCPStatus",false },
  {0x0074,0x1244,VR::CS,VM::VM1,"Subscription List Status","SubscriptionListStatus",false },
  {0x0074,0x1246,VR::CS,VM::VM1,"Unified Procedure Step List Status","UnifiedProcedureStepListStatus",false },
  {0x0074,0x1324,VR::UL,VM::VM1,"Beam Order Index","BeamOrderIndex",false },
  {0x0074,0x1338,VR::FD,VM::VM1,"Double Exposure Meterset","DoubleExposureMeterset",false },
  {0x0074,0x133a,VR::FD,VM::VM4,"Double Exposure Field Delta","DoubleExposureFieldDelta",false },
  {0x0076,0x0001,VR::LO,VM::VM1,"Implant Assembly Template Name","ImplantAssemblyTemplateName",false },
  {0x0076,0x0003,VR::LO,VM::VM1,"Implant Assembly Template Issuer","ImplantAssemblyTemplateIssuer",false },
  {0x0076,0x0006,VR::LO,VM::VM1,"Implant Assembly Template Version","ImplantAssemblyTemplateVersion",false },
  {0x0076,0x0008,VR::SQ,VM::VM1,"Replaced Implant Assembly Template Sequence","ReplacedImplantAssemblyTemplateSequence",false },
  {0x0076,0x000a,VR::CS,VM::VM1,"Implant Assembly Template Type","ImplantAssemblyTemplateType",false },
  {0x0076,0x000c,VR::SQ,VM::VM1,"Original Implant Assembly Template Sequence","OriginalImplantAssemblyTemplateSequence",false },
  {0x0076,0x000e,VR::SQ,VM::VM1,"Derivation Implant Assembly Template Sequence","DerivationImplantAssemblyTemplateSequence",false },
  {0x0076,0x0010,VR::SQ,VM::VM1,"Implant Assembly Template Target Anatomy Sequence","ImplantAssemblyTemplateTargetAnatomySequence",false },
  {0x0076,0x0020,VR::SQ,VM::VM1,"Procedure Type Code Sequence","ProcedureTypeCodeSequence",false },
  {0x0076,0x0030,VR::LO,VM::VM1,"Surgical Technique","SurgicalTechnique",false },
  {0x0076,0x0032,VR::SQ,VM::VM1,"Component Types Sequence","ComponentTypesSequence",false },
  {0x0076,0x0034,VR::CS,VM::VM1,"Component Type Code Sequence","ComponentTypeCodeSequence",false },
  {0x0076,0x0036,VR::CS,VM::VM1,"Exclusive Component Type","ExclusiveComponentType",false },
  {0x0076,0x0038,VR::CS,VM::VM1,"Mandatory Component Type","MandatoryComponentType",false },
  {0x0076,0x0040,VR::SQ,VM::VM1,"Component Sequence","ComponentSequence",false },
  {0x0076,0x0055,VR::US,VM::VM1,"Component ID","ComponentID",false },
  {0x0076,0x0060,VR::SQ,VM::VM1,"Component Assembly Sequence","ComponentAssemblySequence",false },
  {0x0076,0x0070,VR::US,VM::VM1,"Component 1 Referenced ID","Component1ReferencedID",false },
  {0x0076,0x0080,VR::US,VM::VM1,"Component 1 Referenced Mating Feature Set ID","Component1ReferencedMatingFeatureSetID",false },
  {0x0076,0x0090,VR::US,VM::VM1,"Component 1 Referenced Mating Feature ID","Component1ReferencedMatingFeatureID",false },
  {0x0076,0x00a0,VR::US,VM::VM1,"Component 2 Referenced ID","Component2ReferencedID",false },
  {0x0076,0x00b0,VR::US,VM::VM1,"Component 2 Referenced Mating Feature Set ID","Component2ReferencedMatingFeatureSetID",false },
  {0x0076,0x00c0,VR::US,VM::VM1,"Component 2 Referenced Mating Feature ID","Component2ReferencedMatingFeatureID",false },
  {0x0078,0x0001,VR::LO,VM::VM1,"Implant Template Group Name","ImplantTemplateGroupName",false },
  {0x0078,0x0010,VR::ST,VM::VM1,"Implant Template Group Description","ImplantTemplateGroupDescription",false },
  {0x0078,0x0020,VR::LO,VM::VM1,"Implant Template Group Issuer","ImplantTemplateGroupIssuer",false },
  {0x0078,0x0024,VR::LO,VM::VM1,"Implant Template Group Version","ImplantTemplateGroupVersion",false },
  {0x0078,0x0026,VR::SQ,VM::VM1,"Replaced Implant Template Group Sequence","ReplacedImplantTemplateGroupSequence",false },
  {0x0078,0x0028,VR::SQ,VM::VM1,"Implant Template Group Target Anatomy Sequence","ImplantTemplateGroupTargetAnatomySequence",false },
  {0x0078,0x002a,VR::SQ,VM::VM1,"Implant Template Group Members Sequence","ImplantTemplateGroupMembersSequence",false },
  {0x0078,0x002e,VR::US,VM::VM1,"Implant Template Group Member ID","ImplantTemplateGroupMemberID",false },
  {0x0078,0x0050,VR::FD,VM::VM3,"3D Implant Template Group Member Matching Point","ThreeDImplantTemplateGroupMemberMatchingPoint",false },
  {0x0078,0x0060,VR::FD,VM::VM9,"3D Implant Template Group Member Matching Axes","ThreeDImplantTemplateGroupMemberMatchingAxes",false },
  {0x0078,0x0070,VR::SQ,VM::VM1,"Implant Template Group Member Matching 2D Coordinates Sequence","ImplantTemplateGroupMemberMatching2DCoordinatesSequence",false },
  {0x0078,0x0090,VR::FD,VM::VM2,"2D Implant Template Group Member Matching Point","TwoDImplantTemplateGroupMemberMatchingPoint",false },
  {0x0078,0x00a0,VR::FD,VM::VM4,"2D Implant Template Group Member Matching Axes","TwoDImplantTemplateGroupMemberMatchingAxes",false },
  {0x0078,0x00b0,VR::SQ,VM::VM1,"Implant Template Group Variation Dimension Sequence","ImplantTemplateGroupVariationDimensionSequence",false },
  {0x0078,0x00b2,VR::LO,VM::VM1,"Implant Template Group Variation Dimension Name","ImplantTemplateGroupVariationDimensionName",false },
  {0x0078,0x00b4,VR::SQ,VM::VM1,"Implant Template Group Variation Dimension Rank Sequence","ImplantTemplateGroupVariationDimensionRankSequence",false },
  {0x0078,0x00b6,VR::US,VM::VM1,"Referenced Implant Template Group Member ID","ReferencedImplantTemplateGroupMemberID",false },
  {0x0078,0x00b8,VR::US,VM::VM1,"Implant Template Group Variation Dimension Rank","ImplantTemplateGroupVariationDimensionRank",false },
  {0x0088,0x0130,VR::SH,VM::VM1,"Storage Media File-set ID","StorageMediaFileSetID",false },
  {0x0088,0x0140,VR::UI,VM::VM1,"Storage Media File-set UID","StorageMediaFileSetUID",false },
  {0x0088,0x0200,VR::SQ,VM::VM1,"Icon Image Sequence","IconImageSequence",false },
  {0x0088,0x0904,VR::LO,VM::VM1,"Topic Title","TopicTitle",true },
  {0x0088,0x0906,VR::ST,VM::VM1,"Topic Subject","TopicSubject",true },
  {0x0088,0x0910,VR::LO,VM::VM1,"Topic Author","TopicAuthor",true },
  {0x0088,0x0912,VR::LO,VM::VM1_32,"Topic Keywords","TopicKeywords",true },
  {0x0100,0x0410,VR::CS,VM::VM1,"SOP Instance Status","SOPInstanceStatus",false },
  {0x0100,0x0420,VR::DT,VM::VM1,"SOP Authorization DateTime","SOPAuthorizationDateTime",false },
  {0x0100,0x0424,VR::LT,VM::VM1,"SOP Authorization Comment","SOPAuthorizationComment",false },
  {0x0100,0x0426,VR::LO,VM::VM1,"Authorization Equipment Certification Number","AuthorizationEquipmentCertificationNumber",false },
  {0x0400,0x0005,VR::US,VM::VM1,"MAC ID Number","MACIDNumber",false },
  {0x0400,0x0010,VR::UI,VM::VM1,"MAC Calculation Transfer Syntax UID","MACCalculationTransferSyntaxUID",false },
  {0x0400,0x0015,VR::CS,VM::VM1,"MAC Algorithm","MACAlgorithm",false },
  {0x0400,0x0020,VR::AT,VM::VM1_n,"Data Elements Signed","DataElementsSigned",false },
  {0x0400,0x0100,VR::UI,VM::VM1,"Digital Signature UID","DigitalSignatureUID",false },
  {0x0400,0x0105,VR::DT,VM::VM1,"Digital Signature DateTime","DigitalSignatureDateTime",false },
  {0x0400,0x0110,VR::CS,VM::VM1,"Certificate Type","CertificateType",false },
  {0x0400,0x0115,VR::OB,VM::VM1,"Certificate of Signer","CertificateOfSigner",false },
  {0x0400,0x0120,VR::OB,VM::VM1,"Signature","Signature",false },
  {0x0400,0x0305,VR::CS,VM::VM1,"Certified Timestamp Type","CertifiedTimestampType",false },
  {0x0400,0x0310,VR::OB,VM::VM1,"Certified Timestamp","CertifiedTimestamp",false },
  {0x0400,0x0401,VR::SQ,VM::VM1,"Digital Signature Purpose Code Sequence","DigitalSignaturePurposeCodeSequence",false },
  {0x0400,0x0402,VR::SQ,VM::VM1,"Referenced Digital Signature Sequence","ReferencedDigitalSignatureSequence",false },
  {0x0400,0x0403,VR::SQ,VM::VM1,"Referenced SOP Instance MAC Sequence","ReferencedSOPInstanceMACSequence",false },
  {0x0400,0x0404,VR::OB,VM::VM1,"MAC","MAC",false },
  {0x0400,0x0500,VR::SQ,VM::VM1,"Encrypted Attributes Sequence","EncryptedAttributesSequence",false },
  {0x0400,0x0510,VR::UI,VM::VM1,"Encrypted Content Transfer Syntax UID","EncryptedContentTransferSyntaxUID",false },
  {0x0400,0x0520,VR::OB,VM::VM1,"Encrypted Content","EncryptedContent",false },
  {0x0400,0x0550,VR::SQ,VM::VM1,"Modified Attributes Sequence","ModifiedAttributesSequence",false },
  {0x0400,0x0561,VR::SQ,VM::VM1,"Original Attributes Sequence","OriginalAttributesSequence",false },
  {0x0400,0x0562,VR::DT,VM::VM1,"Attribute Modification DateTime","AttributeModificationDateTime",false },
  {0x0400,0x0563,VR::LO,VM::VM1,"Modifying System","ModifyingSystem",false },
  {0x0400,0x0564,VR::LO,VM::VM1,"Source of Previous Values","SourceOfPreviousValues",false },
  {0x0400,0x0565,VR::CS,VM::VM1,"Reason for the Attribute Modification","ReasonForTheAttributeModification",false },
//  {0x1010,0x0000,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0001,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0002,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0003,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0004,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0005,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0006,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0007,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0008,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0009,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x000a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x000b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x000c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x000d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x000e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x000f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0010,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0011,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0012,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0013,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0014,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0015,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0016,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0017,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0018,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0019,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x001a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x001b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x001c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x001d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x001e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x001f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0020,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0021,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0022,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0023,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0024,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0025,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0026,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0027,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0028,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0029,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x002a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x002b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x002c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x002d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x002e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x002f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0030,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0031,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0032,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0033,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0034,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0035,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0036,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0037,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0038,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0039,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x003a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x003b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x003c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x003d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x003e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x003f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0040,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0041,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0042,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0043,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0044,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0045,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0046,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0047,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0048,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0049,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x004a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x004b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x004c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x004d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x004e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x004f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0050,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0051,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0052,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0053,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0054,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0055,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0056,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0057,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0058,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0059,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x005a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x005b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x005c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x005d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x005e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x005f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0060,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0061,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0062,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0063,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0064,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0065,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0066,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0067,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0068,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0069,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x006a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x006b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x006c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x006d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x006e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x006f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0070,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0071,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0072,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0073,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0074,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0075,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0076,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0077,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0078,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0079,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x007a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x007b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x007c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x007d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x007e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x007f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0080,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0081,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0082,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0083,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0084,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0085,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0086,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0087,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0088,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0089,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x008a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x008b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x008c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x008d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x008e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x008f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0090,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0091,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0092,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0093,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0094,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0095,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0096,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0097,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0098,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x0099,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x009a,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x009b,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x009c,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x009d,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x009e,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x009f,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a0,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a1,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a2,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a3,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a4,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a5,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a6,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a7,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a8,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00a9,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00aa,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ab,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ac,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ad,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ae,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00af,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b0,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b1,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b2,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b3,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b4,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b5,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b6,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b7,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b8,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00b9,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ba,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00bb,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00bc,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00bd,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00be,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00bf,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c0,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c1,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c2,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c3,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c4,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c5,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c6,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c7,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c8,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00c9,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ca,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00cb,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00cc,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00cd,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ce,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00cf,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d0,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d1,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d2,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d3,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d4,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d5,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d6,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d7,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d8,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00d9,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00da,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00db,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00dc,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00dd,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00de,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00df,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e0,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e1,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e2,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e3,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e4,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e5,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e6,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e7,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e8,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00e9,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ea,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00eb,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ec,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ed,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ee,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ef,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f0,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f1,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f2,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f3,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f4,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f5,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f6,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f7,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f8,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00f9,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00fa,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00fb,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00fc,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00fd,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00fe,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x1010,0x00ff,VR::US,VM::VM1_n,"Zonal Map","ZonalMap",true },
  {0x2000,0x0010,VR::IS,VM::VM1,"Number of Copies","NumberOfCopies",false },
  {0x2000,0x001e,VR::SQ,VM::VM1,"Printer Configuration Sequence","PrinterConfigurationSequence",false },
  {0x2000,0x0020,VR::CS,VM::VM1,"Print Priority","PrintPriority",false },
  {0x2000,0x0030,VR::CS,VM::VM1,"Medium Type","MediumType",false },
  {0x2000,0x0040,VR::CS,VM::VM1,"Film Destination","FilmDestination",false },
  {0x2000,0x0050,VR::LO,VM::VM1,"Film Session Label","FilmSessionLabel",false },
  {0x2000,0x0060,VR::IS,VM::VM1,"Memory Allocation","MemoryAllocation",false },
  {0x2000,0x0061,VR::IS,VM::VM1,"Maximum Memory Allocation","MaximumMemoryAllocation",false },
  {0x2000,0x0062,VR::CS,VM::VM1,"Color Image Printing Flag","ColorImagePrintingFlag",true },
  {0x2000,0x0063,VR::CS,VM::VM1,"Collation Flag","CollationFlag",true },
  {0x2000,0x0065,VR::CS,VM::VM1,"Annotation Flag","AnnotationFlag",true },
  {0x2000,0x0067,VR::CS,VM::VM1,"Image Overlay Flag","ImageOverlayFlag",true },
  {0x2000,0x0069,VR::CS,VM::VM1,"Presentation LUT Flag","PresentationLUTFlag",true },
  {0x2000,0x006a,VR::CS,VM::VM1,"Image Box Presentation LUT Flag","ImageBoxPresentationLUTFlag",true },
  {0x2000,0x00a0,VR::US,VM::VM1,"Memory Bit Depth","MemoryBitDepth",false },
  {0x2000,0x00a1,VR::US,VM::VM1,"Printing Bit Depth","PrintingBitDepth",false },
  {0x2000,0x00a2,VR::SQ,VM::VM1,"Media Installed Sequence","MediaInstalledSequence",false },
  {0x2000,0x00a4,VR::SQ,VM::VM1,"Other Media Available Sequence","OtherMediaAvailableSequence",false },
  {0x2000,0x00a8,VR::SQ,VM::VM1,"Supported Image Display Formats Sequence","SupportedImageDisplayFormatsSequence",false },
  {0x2000,0x0500,VR::SQ,VM::VM1,"Referenced Film Box Sequence","ReferencedFilmBoxSequence",false },
  {0x2000,0x0510,VR::SQ,VM::VM1,"Referenced Stored Print Sequence","ReferencedStoredPrintSequence",true },
  {0x2010,0x0010,VR::ST,VM::VM1,"Image Display Format","ImageDisplayFormat",false },
  {0x2010,0x0030,VR::CS,VM::VM1,"Annotation Display Format ID","AnnotationDisplayFormatID",false },
  {0x2010,0x0040,VR::CS,VM::VM1,"Film Orientation","FilmOrientation",false },
  {0x2010,0x0050,VR::CS,VM::VM1,"Film Size ID","FilmSizeID",false },
  {0x2010,0x0052,VR::CS,VM::VM1,"Printer Resolution ID","PrinterResolutionID",false },
  {0x2010,0x0054,VR::CS,VM::VM1,"Default Printer Resolution ID","DefaultPrinterResolutionID",false },
  {0x2010,0x0060,VR::CS,VM::VM1,"Magnification Type","MagnificationType",false },
  {0x2010,0x0080,VR::CS,VM::VM1,"Smoothing Type","SmoothingType",false },
  {0x2010,0x00a6,VR::CS,VM::VM1,"Default Magnification Type","DefaultMagnificationType",false },
  {0x2010,0x00a7,VR::CS,VM::VM1_n,"Other Magnification Types Available","OtherMagnificationTypesAvailable",false },
  {0x2010,0x00a8,VR::CS,VM::VM1,"Default Smoothing Type","DefaultSmoothingType",false },
  {0x2010,0x00a9,VR::CS,VM::VM1_n,"Other Smoothing Types Available","OtherSmoothingTypesAvailable",false },
  {0x2010,0x0100,VR::CS,VM::VM1,"Border Density","BorderDensity",false },
  {0x2010,0x0110,VR::CS,VM::VM1,"Empty Image Density","EmptyImageDensity",false },
  {0x2010,0x0120,VR::US,VM::VM1,"Min Density","MinDensity",false },
  {0x2010,0x0130,VR::US,VM::VM1,"Max Density","MaxDensity",false },
  {0x2010,0x0140,VR::CS,VM::VM1,"Trim","Trim",false },
  {0x2010,0x0150,VR::ST,VM::VM1,"Configuration Information","ConfigurationInformation",false },
  {0x2010,0x0152,VR::LT,VM::VM1,"Configuration Information Description","ConfigurationInformationDescription",false },
  {0x2010,0x0154,VR::IS,VM::VM1,"Maximum Collated Films","MaximumCollatedFilms",false },
  {0x2010,0x015e,VR::US,VM::VM1,"Illumination","Illumination",false },
  {0x2010,0x0160,VR::US,VM::VM1,"Reflected Ambient Light","ReflectedAmbientLight",false },
  {0x2010,0x0376,VR::DS,VM::VM2,"Printer Pixel Spacing","PrinterPixelSpacing",false },
  {0x2010,0x0500,VR::SQ,VM::VM1,"Referenced Film Session Sequence","ReferencedFilmSessionSequence",false },
  {0x2010,0x0510,VR::SQ,VM::VM1,"Referenced Image Box Sequence","ReferencedImageBoxSequence",false },
  {0x2010,0x0520,VR::SQ,VM::VM1,"Referenced Basic Annotation Box Sequence","ReferencedBasicAnnotationBoxSequence",false },
  {0x2020,0x0010,VR::US,VM::VM1,"Image Box Position","ImageBoxPosition",false },
  {0x2020,0x0020,VR::CS,VM::VM1,"Polarity","Polarity",false },
  {0x2020,0x0030,VR::DS,VM::VM1,"Requested Image Size","RequestedImageSize",false },
  {0x2020,0x0040,VR::CS,VM::VM1,"Requested Decimate/Crop Behavior","RequestedDecimateCropBehavior",false },
  {0x2020,0x0050,VR::CS,VM::VM1,"Requested Resolution ID","RequestedResolutionID",false },
  {0x2020,0x00a0,VR::CS,VM::VM1,"Requested Image Size Flag","RequestedImageSizeFlag",false },
  {0x2020,0x00a2,VR::CS,VM::VM1,"Decimate/Crop Result","DecimateCropResult",false },
  {0x2020,0x0110,VR::SQ,VM::VM1,"Basic Grayscale Image Sequence","BasicGrayscaleImageSequence",false },
  {0x2020,0x0111,VR::SQ,VM::VM1,"Basic Color Image Sequence","BasicColorImageSequence",false },
  {0x2020,0x0130,VR::SQ,VM::VM1,"Referenced Image Overlay Box Sequence","ReferencedImageOverlayBoxSequence",true },
  {0x2020,0x0140,VR::SQ,VM::VM1,"Referenced VOI LUT Box Sequence","ReferencedVOILUTBoxSequence",true },
  {0x2030,0x0010,VR::US,VM::VM1,"Annotation Position","AnnotationPosition",false },
  {0x2030,0x0020,VR::LO,VM::VM1,"Text String","TextString",false },
  {0x2040,0x0010,VR::SQ,VM::VM1,"Referenced Overlay Plane Sequence","ReferencedOverlayPlaneSequence",true },
  {0x2040,0x0011,VR::US,VM::VM1_99,"Referenced Overlay Plane Groups","ReferencedOverlayPlaneGroups",true },
  {0x2040,0x0020,VR::SQ,VM::VM1,"Overlay Pixel Data Sequence","OverlayPixelDataSequence",true },
  {0x2040,0x0060,VR::CS,VM::VM1,"Overlay Magnification Type","OverlayMagnificationType",true },
  {0x2040,0x0070,VR::CS,VM::VM1,"Overlay Smoothing Type","OverlaySmoothingType",true },
  {0x2040,0x0072,VR::CS,VM::VM1,"Overlay or Image Magnification","OverlayOrImageMagnification",true },
  {0x2040,0x0074,VR::US,VM::VM1,"Magnify to Number of Columns","MagnifyToNumberOfColumns",true },
  {0x2040,0x0080,VR::CS,VM::VM1,"Overlay Foreground Density","OverlayForegroundDensity",true },
  {0x2040,0x0082,VR::CS,VM::VM1,"Overlay Background Density","OverlayBackgroundDensity",true },
  {0x2040,0x0090,VR::CS,VM::VM1,"Overlay Mode","OverlayMode",true },
  {0x2040,0x0100,VR::CS,VM::VM1,"Threshold Density","ThresholdDensity",true },
  {0x2040,0x0500,VR::SQ,VM::VM1,"Referenced Image Box Sequence (Retired)","ReferencedImageBoxSequenceRetired",true },
  {0x2050,0x0010,VR::SQ,VM::VM1,"Presentation LUT Sequence","PresentationLUTSequence",false },
  {0x2050,0x0020,VR::CS,VM::VM1,"Presentation LUT Shape","PresentationLUTShape",false },
  {0x2050,0x0500,VR::SQ,VM::VM1,"Referenced Presentation LUT Sequence","ReferencedPresentationLUTSequence",false },
  {0x2100,0x0010,VR::SH,VM::VM1,"Print Job ID","PrintJobID",true },
  {0x2100,0x0020,VR::CS,VM::VM1,"Execution Status","ExecutionStatus",false },
  {0x2100,0x0030,VR::CS,VM::VM1,"Execution Status Info","ExecutionStatusInfo",false },
  {0x2100,0x0040,VR::DA,VM::VM1,"Creation Date","CreationDate",false },
  {0x2100,0x0050,VR::TM,VM::VM1,"Creation Time","CreationTime",false },
  {0x2100,0x0070,VR::AE,VM::VM1,"Originator","Originator",false },
  {0x2100,0x0140,VR::AE,VM::VM1,"Destination AE","DestinationAE",true },
  {0x2100,0x0160,VR::SH,VM::VM1,"Owner ID","OwnerID",false },
  {0x2100,0x0170,VR::IS,VM::VM1,"Number of Films","NumberOfFilms",false },
  {0x2100,0x0500,VR::SQ,VM::VM1,"Referenced Print Job Sequence (Pull Stored Print)","ReferencedPrintJobSequencePullStoredPrint",true },
  {0x2110,0x0010,VR::CS,VM::VM1,"Printer Status","PrinterStatus",false },
  {0x2110,0x0020,VR::CS,VM::VM1,"Printer Status Info","PrinterStatusInfo",false },
  {0x2110,0x0030,VR::LO,VM::VM1,"Printer Name","PrinterName",false },
  {0x2110,0x0099,VR::SH,VM::VM1,"Print Queue ID","PrintQueueID",true },
  {0x2120,0x0010,VR::CS,VM::VM1,"Queue Status","QueueStatus",true },
  {0x2120,0x0050,VR::SQ,VM::VM1,"Print Job Description Sequence","PrintJobDescriptionSequence",true },
  {0x2120,0x0070,VR::SQ,VM::VM1,"Referenced Print Job Sequence","ReferencedPrintJobSequence",true },
  {0x2130,0x0010,VR::SQ,VM::VM1,"Print Management Capabilities Sequence","PrintManagementCapabilitiesSequence",true },
  {0x2130,0x0015,VR::SQ,VM::VM1,"Printer Characteristics Sequence","PrinterCharacteristicsSequence",true },
  {0x2130,0x0030,VR::SQ,VM::VM1,"Film Box Content Sequence","FilmBoxContentSequence",true },
  {0x2130,0x0040,VR::SQ,VM::VM1,"Image Box Content Sequence","ImageBoxContentSequence",true },
  {0x2130,0x0050,VR::SQ,VM::VM1,"Annotation Content Sequence","AnnotationContentSequence",true },
  {0x2130,0x0060,VR::SQ,VM::VM1,"Image Overlay Box Content Sequence","ImageOverlayBoxContentSequence",true },
  {0x2130,0x0080,VR::SQ,VM::VM1,"Presentation LUT Content Sequence","PresentationLUTContentSequence",true },
  {0x2130,0x00a0,VR::SQ,VM::VM1,"Proposed Study Sequence","ProposedStudySequence",true },
  {0x2130,0x00c0,VR::SQ,VM::VM1,"Original Image Sequence","OriginalImageSequence",true },
  {0x2200,0x0001,VR::CS,VM::VM1,"Label Using Information Extracted From Instances","LabelUsingInformationExtractedFromInstances",false },
  {0x2200,0x0002,VR::UT,VM::VM1,"Label Text","LabelText",false },
  {0x2200,0x0003,VR::CS,VM::VM1,"Label Style Selection","LabelStyleSelection",false },
  {0x2200,0x0004,VR::LT,VM::VM1,"Media Disposition","MediaDisposition",false },
  {0x2200,0x0005,VR::LT,VM::VM1,"Barcode Value","BarcodeValue",false },
  {0x2200,0x0006,VR::CS,VM::VM1,"Barcode Symbology","BarcodeSymbology",false },
  {0x2200,0x0007,VR::CS,VM::VM1,"Allow Media Splitting","AllowMediaSplitting",false },
  {0x2200,0x0008,VR::CS,VM::VM1,"Include Non-DICOM Objects","IncludeNonDICOMObjects",false },
  {0x2200,0x0009,VR::CS,VM::VM1,"Include Display Application","IncludeDisplayApplication",false },
  {0x2200,0x000a,VR::CS,VM::VM1,"Preserve Composite Instances After Media Creation","PreserveCompositeInstancesAfterMediaCreation",false },
  {0x2200,0x000b,VR::US,VM::VM1,"Total Number of Pieces of Media Created","TotalNumberOfPiecesOfMediaCreated",false },
  {0x2200,0x000c,VR::LO,VM::VM1,"Requested Media Application Profile","RequestedMediaApplicationProfile",false },
  {0x2200,0x000d,VR::SQ,VM::VM1,"Referenced Storage Media Sequence","ReferencedStorageMediaSequence",false },
  {0x2200,0x000e,VR::AT,VM::VM1_n,"Failure Attributes","FailureAttributes",false },
  {0x2200,0x000f,VR::CS,VM::VM1,"Allow Lossy Compression","AllowLossyCompression",false },
  {0x2200,0x0020,VR::CS,VM::VM1,"Request Priority","RequestPriority",false },
  {0x3002,0x0002,VR::SH,VM::VM1,"RT Image Label","RTImageLabel",false },
  {0x3002,0x0003,VR::LO,VM::VM1,"RT Image Name","RTImageName",false },
  {0x3002,0x0004,VR::ST,VM::VM1,"RT Image Description","RTImageDescription",false },
  {0x3002,0x000a,VR::CS,VM::VM1,"Reported Values Origin","ReportedValuesOrigin",false },
  {0x3002,0x000c,VR::CS,VM::VM1,"RT Image Plane","RTImagePlane",false },
  {0x3002,0x000d,VR::DS,VM::VM3,"X-Ray Image Receptor Translation","XRayImageReceptorTranslation",false },
  {0x3002,0x000e,VR::DS,VM::VM1,"X-Ray Image Receptor Angle","XRayImageReceptorAngle",false },
  {0x3002,0x0010,VR::DS,VM::VM6,"RT Image Orientation","RTImageOrientation",false },
  {0x3002,0x0011,VR::DS,VM::VM2,"Image Plane Pixel Spacing","ImagePlanePixelSpacing",false },
  {0x3002,0x0012,VR::DS,VM::VM2,"RT Image Position","RTImagePosition",false },
  {0x3002,0x0020,VR::SH,VM::VM1,"Radiation Machine Name","RadiationMachineName",false },
  {0x3002,0x0022,VR::DS,VM::VM1,"Radiation Machine SAD","RadiationMachineSAD",false },
  {0x3002,0x0024,VR::DS,VM::VM1,"Radiation Machine SSD","RadiationMachineSSD",false },
  {0x3002,0x0026,VR::DS,VM::VM1,"RT Image SID","RTImageSID",false },
  {0x3002,0x0028,VR::DS,VM::VM1,"Source to Reference Object Distance","SourceToReferenceObjectDistance",false },
  {0x3002,0x0029,VR::IS,VM::VM1,"Fraction Number","FractionNumber",false },
  {0x3002,0x0030,VR::SQ,VM::VM1,"Exposure Sequence","ExposureSequence",false },
  {0x3002,0x0032,VR::DS,VM::VM1,"Meterset Exposure","MetersetExposure",false },
  {0x3002,0x0034,VR::DS,VM::VM4,"Diaphragm Position","DiaphragmPosition",false },
  {0x3002,0x0040,VR::SQ,VM::VM1,"Fluence Map Sequence","FluenceMapSequence",false },
  {0x3002,0x0041,VR::CS,VM::VM1,"Fluence Data Source","FluenceDataSource",false },
  {0x3002,0x0042,VR::DS,VM::VM1,"Fluence Data Scale","FluenceDataScale",false },
  {0x3002,0x0050,VR::SQ,VM::VM1,"Primary Fluence Mode Sequence","PrimaryFluenceModeSequence",false },
  {0x3002,0x0051,VR::CS,VM::VM1,"Fluence Mode","FluenceMode",false },
  {0x3002,0x0052,VR::SH,VM::VM1,"Fluence Mode ID","FluenceModeID",false },
  {0x3004,0x0001,VR::CS,VM::VM1,"DVH Type","DVHType",false },
  {0x3004,0x0002,VR::CS,VM::VM1,"Dose Units","DoseUnits",false },
  {0x3004,0x0004,VR::CS,VM::VM1,"Dose Type","DoseType",false },
  {0x3004,0x0006,VR::LO,VM::VM1,"Dose Comment","DoseComment",false },
  {0x3004,0x0008,VR::DS,VM::VM3,"Normalization Point","NormalizationPoint",false },
  {0x3004,0x000a,VR::CS,VM::VM1,"Dose Summation Type","DoseSummationType",false },
  {0x3004,0x000c,VR::DS,VM::VM2_n,"Grid Frame Offset Vector","GridFrameOffsetVector",false },
  {0x3004,0x000e,VR::DS,VM::VM1,"Dose Grid Scaling","DoseGridScaling",false },
  {0x3004,0x0010,VR::SQ,VM::VM1,"RT Dose ROI Sequence","RTDoseROISequence",false },
  {0x3004,0x0012,VR::DS,VM::VM1,"Dose Value","DoseValue",false },
  {0x3004,0x0014,VR::CS,VM::VM1_3,"Tissue Heterogeneity Correction","TissueHeterogeneityCorrection",false },
  {0x3004,0x0040,VR::DS,VM::VM3,"DVH Normalization Point","DVHNormalizationPoint",false },
  {0x3004,0x0042,VR::DS,VM::VM1,"DVH Normalization Dose Value","DVHNormalizationDoseValue",false },
  {0x3004,0x0050,VR::SQ,VM::VM1,"DVH Sequence","DVHSequence",false },
  {0x3004,0x0052,VR::DS,VM::VM1,"DVH Dose Scaling","DVHDoseScaling",false },
  {0x3004,0x0054,VR::CS,VM::VM1,"DVH Volume Units","DVHVolumeUnits",false },
  {0x3004,0x0056,VR::IS,VM::VM1,"DVH Number of Bins","DVHNumberOfBins",false },
  {0x3004,0x0058,VR::DS,VM::VM2_2n,"DVH Data","DVHData",false },
  {0x3004,0x0060,VR::SQ,VM::VM1,"DVH Referenced ROI Sequence","DVHReferencedROISequence",false },
  {0x3004,0x0062,VR::CS,VM::VM1,"DVH ROI Contribution Type","DVHROIContributionType",false },
  {0x3004,0x0070,VR::DS,VM::VM1,"DVH Minimum Dose","DVHMinimumDose",false },
  {0x3004,0x0072,VR::DS,VM::VM1,"DVH Maximum Dose","DVHMaximumDose",false },
  {0x3004,0x0074,VR::DS,VM::VM1,"DVH Mean Dose","DVHMeanDose",false },
  {0x3006,0x0002,VR::SH,VM::VM1,"Structure Set Label","StructureSetLabel",false },
  {0x3006,0x0004,VR::LO,VM::VM1,"Structure Set Name","StructureSetName",false },
  {0x3006,0x0006,VR::ST,VM::VM1,"Structure Set Description","StructureSetDescription",false },
  {0x3006,0x0008,VR::DA,VM::VM1,"Structure Set Date","StructureSetDate",false },
  {0x3006,0x0009,VR::TM,VM::VM1,"Structure Set Time","StructureSetTime",false },
  {0x3006,0x0010,VR::SQ,VM::VM1,"Referenced Frame of Reference Sequence","ReferencedFrameOfReferenceSequence",false },
  {0x3006,0x0012,VR::SQ,VM::VM1,"RT Referenced Study Sequence","RTReferencedStudySequence",false },
  {0x3006,0x0014,VR::SQ,VM::VM1,"RT Referenced Series Sequence","RTReferencedSeriesSequence",false },
  {0x3006,0x0016,VR::SQ,VM::VM1,"Contour Image Sequence","ContourImageSequence",false },
  {0x3006,0x0020,VR::SQ,VM::VM1,"Structure Set ROI Sequence","StructureSetROISequence",false },
  {0x3006,0x0022,VR::IS,VM::VM1,"ROI Number","ROINumber",false },
  {0x3006,0x0024,VR::UI,VM::VM1,"Referenced Frame of Reference UID","ReferencedFrameOfReferenceUID",false },
  {0x3006,0x0026,VR::LO,VM::VM1,"ROI Name","ROIName",false },
  {0x3006,0x0028,VR::ST,VM::VM1,"ROI Description","ROIDescription",false },
  {0x3006,0x002a,VR::IS,VM::VM3,"ROI Display Color","ROIDisplayColor",false },
  {0x3006,0x002c,VR::DS,VM::VM1,"ROI Volume","ROIVolume",false },
  {0x3006,0x0030,VR::SQ,VM::VM1,"RT Related ROI Sequence","RTRelatedROISequence",false },
  {0x3006,0x0033,VR::CS,VM::VM1,"RT ROI Relationship","RTROIRelationship",false },
  {0x3006,0x0036,VR::CS,VM::VM1,"ROI Generation Algorithm","ROIGenerationAlgorithm",false },
  {0x3006,0x0038,VR::LO,VM::VM1,"ROI Generation Description","ROIGenerationDescription",false },
  {0x3006,0x0039,VR::SQ,VM::VM1,"ROI Contour Sequence","ROIContourSequence",false },
  {0x3006,0x0040,VR::SQ,VM::VM1,"Contour Sequence","ContourSequence",false },
  {0x3006,0x0042,VR::CS,VM::VM1,"Contour Geometric Type","ContourGeometricType",false },
  {0x3006,0x0044,VR::DS,VM::VM1,"Contour Slab Thickness","ContourSlabThickness",false },
  {0x3006,0x0045,VR::DS,VM::VM3,"Contour Offset Vector","ContourOffsetVector",false },
  {0x3006,0x0046,VR::IS,VM::VM1,"Number of Contour Points","NumberOfContourPoints",false },
  {0x3006,0x0048,VR::IS,VM::VM1,"Contour Number","ContourNumber",false },
  {0x3006,0x0049,VR::IS,VM::VM1_n,"Attached Contours","AttachedContours",false },
  {0x3006,0x0050,VR::DS,VM::VM3_3n,"Contour Data","ContourData",false },
  {0x3006,0x0080,VR::SQ,VM::VM1,"RT ROI Observations Sequence","RTROIObservationsSequence",false },
  {0x3006,0x0082,VR::IS,VM::VM1,"Observation Number","ObservationNumber",false },
  {0x3006,0x0084,VR::IS,VM::VM1,"Referenced ROI Number","ReferencedROINumber",false },
  {0x3006,0x0085,VR::SH,VM::VM1,"ROI Observation Label","ROIObservationLabel",false },
  {0x3006,0x0086,VR::SQ,VM::VM1,"RT ROI Identification Code Sequence","RTROIIdentificationCodeSequence",false },
  {0x3006,0x0088,VR::ST,VM::VM1,"ROI Observation Description","ROIObservationDescription",false },
  {0x3006,0x00a0,VR::SQ,VM::VM1,"Related RT ROI Observations Sequence","RelatedRTROIObservationsSequence",false },
  {0x3006,0x00a4,VR::CS,VM::VM1,"RT ROI Interpreted Type","RTROIInterpretedType",false },
  {0x3006,0x00a6,VR::PN,VM::VM1,"ROI Interpreter","ROIInterpreter",false },
  {0x3006,0x00b0,VR::SQ,VM::VM1,"ROI Physical Properties Sequence","ROIPhysicalPropertiesSequence",false },
  {0x3006,0x00b2,VR::CS,VM::VM1,"ROI Physical Property","ROIPhysicalProperty",false },
  {0x3006,0x00b4,VR::DS,VM::VM1,"ROI Physical Property Value","ROIPhysicalPropertyValue",false },
  {0x3006,0x00b6,VR::SQ,VM::VM1,"ROI Elemental Composition Sequence","ROIElementalCompositionSequence",false },
  {0x3006,0x00b7,VR::US,VM::VM1,"ROI Elemental Composition Atomic Number","ROIElementalCompositionAtomicNumber",false },
  {0x3006,0x00b8,VR::FL,VM::VM1,"ROI Elemental Composition Atomic Mass Fraction","ROIElementalCompositionAtomicMassFraction",false },
  {0x3006,0x00c0,VR::SQ,VM::VM1,"Frame of Reference Relationship Sequence","FrameOfReferenceRelationshipSequence",false },
  {0x3006,0x00c2,VR::UI,VM::VM1,"Related Frame of Reference UID","RelatedFrameOfReferenceUID",false },
  {0x3006,0x00c4,VR::CS,VM::VM1,"Frame of Reference Transformation Type","FrameOfReferenceTransformationType",false },
  {0x3006,0x00c6,VR::DS,VM::VM16,"Frame of Reference Transformation Matrix","FrameOfReferenceTransformationMatrix",false },
  {0x3006,0x00c8,VR::LO,VM::VM1,"Frame of Reference Transformation Comment","FrameOfReferenceTransformationComment",false },
  {0x3008,0x0010,VR::SQ,VM::VM1,"Measured Dose Reference Sequence","MeasuredDoseReferenceSequence",false },
  {0x3008,0x0012,VR::ST,VM::VM1,"Measured Dose Description","MeasuredDoseDescription",false },
  {0x3008,0x0014,VR::CS,VM::VM1,"Measured Dose Type","MeasuredDoseType",false },
  {0x3008,0x0016,VR::DS,VM::VM1,"Measured Dose Value","MeasuredDoseValue",false },
  {0x3008,0x0020,VR::SQ,VM::VM1,"Treatment Session Beam Sequence","TreatmentSessionBeamSequence",false },
  {0x3008,0x0021,VR::SQ,VM::VM1,"Treatment Session Ion Beam Sequence","TreatmentSessionIonBeamSequence",false },
  {0x3008,0x0022,VR::IS,VM::VM1,"Current Fraction Number","CurrentFractionNumber",false },
  {0x3008,0x0024,VR::DA,VM::VM1,"Treatment Control Point Date","TreatmentControlPointDate",false },
  {0x3008,0x0025,VR::TM,VM::VM1,"Treatment Control Point Time","TreatmentControlPointTime",false },
  {0x3008,0x002a,VR::CS,VM::VM1,"Treatment Termination Status","TreatmentTerminationStatus",false },
  {0x3008,0x002b,VR::SH,VM::VM1,"Treatment Termination Code","TreatmentTerminationCode",false },
  {0x3008,0x002c,VR::CS,VM::VM1,"Treatment Verification Status","TreatmentVerificationStatus",false },
  {0x3008,0x0030,VR::SQ,VM::VM1,"Referenced Treatment Record Sequence","ReferencedTreatmentRecordSequence",false },
  {0x3008,0x0032,VR::DS,VM::VM1,"Specified Primary Meterset","SpecifiedPrimaryMeterset",false },
  {0x3008,0x0033,VR::DS,VM::VM1,"Specified Secondary Meterset","SpecifiedSecondaryMeterset",false },
  {0x3008,0x0036,VR::DS,VM::VM1,"Delivered Primary Meterset","DeliveredPrimaryMeterset",false },
  {0x3008,0x0037,VR::DS,VM::VM1,"Delivered Secondary Meterset","DeliveredSecondaryMeterset",false },
  {0x3008,0x003a,VR::DS,VM::VM1,"Specified Treatment Time","SpecifiedTreatmentTime",false },
  {0x3008,0x003b,VR::DS,VM::VM1,"Delivered Treatment Time","DeliveredTreatmentTime",false },
  {0x3008,0x0040,VR::SQ,VM::VM1,"Control Point Delivery Sequence","ControlPointDeliverySequence",false },
  {0x3008,0x0041,VR::SQ,VM::VM1,"Ion Control Point Delivery Sequence","IonControlPointDeliverySequence",false },
  {0x3008,0x0042,VR::DS,VM::VM1,"Specified Meterset","SpecifiedMeterset",false },
  {0x3008,0x0044,VR::DS,VM::VM1,"Delivered Meterset","DeliveredMeterset",false },
  {0x3008,0x0045,VR::FL,VM::VM1,"Meterset Rate Set","MetersetRateSet",false },
  {0x3008,0x0046,VR::FL,VM::VM1,"Meterset Rate Delivered","MetersetRateDelivered",false },
  {0x3008,0x0047,VR::FL,VM::VM1_n,"Scan Spot Metersets Delivered","ScanSpotMetersetsDelivered",false },
  {0x3008,0x0048,VR::DS,VM::VM1,"Dose Rate Delivered","DoseRateDelivered",false },
  {0x3008,0x0050,VR::SQ,VM::VM1,"Treatment Summary Calculated Dose Reference Sequence","TreatmentSummaryCalculatedDoseReferenceSequence",false },
  {0x3008,0x0052,VR::DS,VM::VM1,"Cumulative Dose to Dose Reference","CumulativeDoseToDoseReference",false },
  {0x3008,0x0054,VR::DA,VM::VM1,"First Treatment Date","FirstTreatmentDate",false },
  {0x3008,0x0056,VR::DA,VM::VM1,"Most Recent Treatment Date","MostRecentTreatmentDate",false },
  {0x3008,0x005a,VR::IS,VM::VM1,"Number of Fractions Delivered","NumberOfFractionsDelivered",false },
  {0x3008,0x0060,VR::SQ,VM::VM1,"Override Sequence","OverrideSequence",false },
  {0x3008,0x0061,VR::AT,VM::VM1,"Parameter Sequence Pointer","ParameterSequencePointer",false },
  {0x3008,0x0062,VR::AT,VM::VM1,"Override Parameter Pointer","OverrideParameterPointer",false },
  {0x3008,0x0063,VR::IS,VM::VM1,"Parameter Item Index","ParameterItemIndex",false },
  {0x3008,0x0064,VR::IS,VM::VM1,"Measured Dose Reference Number","MeasuredDoseReferenceNumber",false },
  {0x3008,0x0065,VR::AT,VM::VM1,"Parameter Pointer","ParameterPointer",false },
  {0x3008,0x0066,VR::ST,VM::VM1,"Override Reason","OverrideReason",false },
  {0x3008,0x0068,VR::SQ,VM::VM1,"Corrected Parameter Sequence","CorrectedParameterSequence",false },
  {0x3008,0x006a,VR::FL,VM::VM1,"Correction Value","CorrectionValue",false },
  {0x3008,0x0070,VR::SQ,VM::VM1,"Calculated Dose Reference Sequence","CalculatedDoseReferenceSequence",false },
  {0x3008,0x0072,VR::IS,VM::VM1,"Calculated Dose Reference Number","CalculatedDoseReferenceNumber",false },
  {0x3008,0x0074,VR::ST,VM::VM1,"Calculated Dose Reference Description","CalculatedDoseReferenceDescription",false },
  {0x3008,0x0076,VR::DS,VM::VM1,"Calculated Dose Reference Dose Value","CalculatedDoseReferenceDoseValue",false },
  {0x3008,0x0078,VR::DS,VM::VM1,"Start Meterset","StartMeterset",false },
  {0x3008,0x007a,VR::DS,VM::VM1,"End Meterset","EndMeterset",false },
  {0x3008,0x0080,VR::SQ,VM::VM1,"Referenced Measured Dose Reference Sequence","ReferencedMeasuredDoseReferenceSequence",false },
  {0x3008,0x0082,VR::IS,VM::VM1,"Referenced Measured Dose Reference Number","ReferencedMeasuredDoseReferenceNumber",false },
  {0x3008,0x0090,VR::SQ,VM::VM1,"Referenced Calculated Dose Reference Sequence","ReferencedCalculatedDoseReferenceSequence",false },
  {0x3008,0x0092,VR::IS,VM::VM1,"Referenced Calculated Dose Reference Number","ReferencedCalculatedDoseReferenceNumber",false },
  {0x3008,0x00a0,VR::SQ,VM::VM1,"Beam Limiting Device Leaf Pairs Sequence","BeamLimitingDeviceLeafPairsSequence",false },
  {0x3008,0x00b0,VR::SQ,VM::VM1,"Recorded Wedge Sequence","RecordedWedgeSequence",false },
  {0x3008,0x00c0,VR::SQ,VM::VM1,"Recorded Compensator Sequence","RecordedCompensatorSequence",false },
  {0x3008,0x00d0,VR::SQ,VM::VM1,"Recorded Block Sequence","RecordedBlockSequence",false },
  {0x3008,0x00e0,VR::SQ,VM::VM1,"Treatment Summary Measured Dose Reference Sequence","TreatmentSummaryMeasuredDoseReferenceSequence",false },
  {0x3008,0x00f0,VR::SQ,VM::VM1,"Recorded Snout Sequence","RecordedSnoutSequence",false },
  {0x3008,0x00f2,VR::SQ,VM::VM1,"Recorded Range Shifter Sequence","RecordedRangeShifterSequence",false },
  {0x3008,0x00f4,VR::SQ,VM::VM1,"Recorded Lateral Spreading Device Sequence","RecordedLateralSpreadingDeviceSequence",false },
  {0x3008,0x00f6,VR::SQ,VM::VM1,"Recorded Range Modulator Sequence","RecordedRangeModulatorSequence",false },
  {0x3008,0x0100,VR::SQ,VM::VM1,"Recorded Source Sequence","RecordedSourceSequence",false },
  {0x3008,0x0105,VR::LO,VM::VM1,"Source Serial Number","SourceSerialNumber",false },
  {0x3008,0x0110,VR::SQ,VM::VM1,"Treatment Session Application Setup Sequence","TreatmentSessionApplicationSetupSequence",false },
  {0x3008,0x0116,VR::CS,VM::VM1,"Application Setup Check","ApplicationSetupCheck",false },
  {0x3008,0x0120,VR::SQ,VM::VM1,"Recorded Brachy Accessory Device Sequence","RecordedBrachyAccessoryDeviceSequence",false },
  {0x3008,0x0122,VR::IS,VM::VM1,"Referenced Brachy Accessory Device Number","ReferencedBrachyAccessoryDeviceNumber",false },
  {0x3008,0x0130,VR::SQ,VM::VM1,"Recorded Channel Sequence","RecordedChannelSequence",false },
  {0x3008,0x0132,VR::DS,VM::VM1,"Specified Channel Total Time","SpecifiedChannelTotalTime",false },
  {0x3008,0x0134,VR::DS,VM::VM1,"Delivered Channel Total Time","DeliveredChannelTotalTime",false },
  {0x3008,0x0136,VR::IS,VM::VM1,"Specified Number of Pulses","SpecifiedNumberOfPulses",false },
  {0x3008,0x0138,VR::IS,VM::VM1,"Delivered Number of Pulses","DeliveredNumberOfPulses",false },
  {0x3008,0x013a,VR::DS,VM::VM1,"Specified Pulse Repetition Interval","SpecifiedPulseRepetitionInterval",false },
  {0x3008,0x013c,VR::DS,VM::VM1,"Delivered Pulse Repetition Interval","DeliveredPulseRepetitionInterval",false },
  {0x3008,0x0140,VR::SQ,VM::VM1,"Recorded Source Applicator Sequence","RecordedSourceApplicatorSequence",false },
  {0x3008,0x0142,VR::IS,VM::VM1,"Referenced Source Applicator Number","ReferencedSourceApplicatorNumber",false },
  {0x3008,0x0150,VR::SQ,VM::VM1,"Recorded Channel Shield Sequence","RecordedChannelShieldSequence",false },
  {0x3008,0x0152,VR::IS,VM::VM1,"Referenced Channel Shield Number","ReferencedChannelShieldNumber",false },
  {0x3008,0x0160,VR::SQ,VM::VM1,"Brachy Control Point Delivered Sequence","BrachyControlPointDeliveredSequence",false },
  {0x3008,0x0162,VR::DA,VM::VM1,"Safe Position Exit Date","SafePositionExitDate",false },
  {0x3008,0x0164,VR::TM,VM::VM1,"Safe Position Exit Time","SafePositionExitTime",false },
  {0x3008,0x0166,VR::DA,VM::VM1,"Safe Position Return Date","SafePositionReturnDate",false },
  {0x3008,0x0168,VR::TM,VM::VM1,"Safe Position Return Time","SafePositionReturnTime",false },
  {0x3008,0x0200,VR::CS,VM::VM1,"Current Treatment Status","CurrentTreatmentStatus",false },
  {0x3008,0x0202,VR::ST,VM::VM1,"Treatment Status Comment","TreatmentStatusComment",false },
  {0x3008,0x0220,VR::SQ,VM::VM1,"Fraction Group Summary Sequence","FractionGroupSummarySequence",false },
  {0x3008,0x0223,VR::IS,VM::VM1,"Referenced Fraction Number","ReferencedFractionNumber",false },
  {0x3008,0x0224,VR::CS,VM::VM1,"Fraction Group Type","FractionGroupType",false },
  {0x3008,0x0230,VR::CS,VM::VM1,"Beam Stopper Position","BeamStopperPosition",false },
  {0x3008,0x0240,VR::SQ,VM::VM1,"Fraction Status Summary Sequence","FractionStatusSummarySequence",false },
  {0x3008,0x0250,VR::DA,VM::VM1,"Treatment Date","TreatmentDate",false },
  {0x3008,0x0251,VR::TM,VM::VM1,"Treatment Time","TreatmentTime",false },
  {0x300a,0x0002,VR::SH,VM::VM1,"RT Plan Label","RTPlanLabel",false },
  {0x300a,0x0003,VR::LO,VM::VM1,"RT Plan Name","RTPlanName",false },
  {0x300a,0x0004,VR::ST,VM::VM1,"RT Plan Description","RTPlanDescription",false },
  {0x300a,0x0006,VR::DA,VM::VM1,"RT Plan Date","RTPlanDate",false },
  {0x300a,0x0007,VR::TM,VM::VM1,"RT Plan Time","RTPlanTime",false },
  {0x300a,0x0009,VR::LO,VM::VM1_n,"Treatment Protocols","TreatmentProtocols",false },
  {0x300a,0x000a,VR::CS,VM::VM1,"Plan Intent","PlanIntent",false },
  {0x300a,0x000b,VR::LO,VM::VM1_n,"Treatment Sites","TreatmentSites",false },
  {0x300a,0x000c,VR::CS,VM::VM1,"RT Plan Geometry","RTPlanGeometry",false },
  {0x300a,0x000e,VR::ST,VM::VM1,"Prescription Description","PrescriptionDescription",false },
  {0x300a,0x0010,VR::SQ,VM::VM1,"Dose Reference Sequence","DoseReferenceSequence",false },
  {0x300a,0x0012,VR::IS,VM::VM1,"Dose Reference Number","DoseReferenceNumber",false },
  {0x300a,0x0013,VR::UI,VM::VM1,"Dose Reference UID","DoseReferenceUID",false },
  {0x300a,0x0014,VR::CS,VM::VM1,"Dose Reference Structure Type","DoseReferenceStructureType",false },
  {0x300a,0x0015,VR::CS,VM::VM1,"Nominal Beam Energy Unit","NominalBeamEnergyUnit",false },
  {0x300a,0x0016,VR::LO,VM::VM1,"Dose Reference Description","DoseReferenceDescription",false },
  {0x300a,0x0018,VR::DS,VM::VM3,"Dose Reference Point Coordinates","DoseReferencePointCoordinates",false },
  {0x300a,0x001a,VR::DS,VM::VM1,"Nominal Prior Dose","NominalPriorDose",false },
  {0x300a,0x0020,VR::CS,VM::VM1,"Dose Reference Type","DoseReferenceType",false },
  {0x300a,0x0021,VR::DS,VM::VM1,"Constraint Weight","ConstraintWeight",false },
  {0x300a,0x0022,VR::DS,VM::VM1,"Delivery Warning Dose","DeliveryWarningDose",false },
  {0x300a,0x0023,VR::DS,VM::VM1,"Delivery Maximum Dose","DeliveryMaximumDose",false },
  {0x300a,0x0025,VR::DS,VM::VM1,"Target Minimum Dose","TargetMinimumDose",false },
  {0x300a,0x0026,VR::DS,VM::VM1,"Target Prescription Dose","TargetPrescriptionDose",false },
  {0x300a,0x0027,VR::DS,VM::VM1,"Target Maximum Dose","TargetMaximumDose",false },
  {0x300a,0x0028,VR::DS,VM::VM1,"Target Underdose Volume Fraction","TargetUnderdoseVolumeFraction",false },
  {0x300a,0x002a,VR::DS,VM::VM1,"Organ at Risk Full-volume Dose","OrganAtRiskFullVolumeDose",false },
  {0x300a,0x002b,VR::DS,VM::VM1,"Organ at Risk Limit Dose","OrganAtRiskLimitDose",false },
  {0x300a,0x002c,VR::DS,VM::VM1,"Organ at Risk Maximum Dose","OrganAtRiskMaximumDose",false },
  {0x300a,0x002d,VR::DS,VM::VM1,"Organ at Risk Overdose Volume Fraction","OrganAtRiskOverdoseVolumeFraction",false },
  {0x300a,0x0040,VR::SQ,VM::VM1,"Tolerance Table Sequence","ToleranceTableSequence",false },
  {0x300a,0x0042,VR::IS,VM::VM1,"Tolerance Table Number","ToleranceTableNumber",false },
  {0x300a,0x0043,VR::SH,VM::VM1,"Tolerance Table Label","ToleranceTableLabel",false },
  {0x300a,0x0044,VR::DS,VM::VM1,"Gantry Angle Tolerance","GantryAngleTolerance",false },
  {0x300a,0x0046,VR::DS,VM::VM1,"Beam Limiting Device Angle Tolerance","BeamLimitingDeviceAngleTolerance",false },
  {0x300a,0x0048,VR::SQ,VM::VM1,"Beam Limiting Device Tolerance Sequence","BeamLimitingDeviceToleranceSequence",false },
  {0x300a,0x004a,VR::DS,VM::VM1,"Beam Limiting Device Position Tolerance","BeamLimitingDevicePositionTolerance",false },
  {0x300a,0x004b,VR::FL,VM::VM1,"Snout Position Tolerance","SnoutPositionTolerance",false },
  {0x300a,0x004c,VR::DS,VM::VM1,"Patient Support Angle Tolerance","PatientSupportAngleTolerance",false },
  {0x300a,0x004e,VR::DS,VM::VM1,"Table Top Eccentric Angle Tolerance","TableTopEccentricAngleTolerance",false },
  {0x300a,0x004f,VR::FL,VM::VM1,"Table Top Pitch Angle Tolerance","TableTopPitchAngleTolerance",false },
  {0x300a,0x0050,VR::FL,VM::VM1,"Table Top Roll Angle Tolerance","TableTopRollAngleTolerance",false },
  {0x300a,0x0051,VR::DS,VM::VM1,"Table Top Vertical Position Tolerance","TableTopVerticalPositionTolerance",false },
  {0x300a,0x0052,VR::DS,VM::VM1,"Table Top Longitudinal Position Tolerance","TableTopLongitudinalPositionTolerance",false },
  {0x300a,0x0053,VR::DS,VM::VM1,"Table Top Lateral Position Tolerance","TableTopLateralPositionTolerance",false },
  {0x300a,0x0055,VR::CS,VM::VM1,"RT Plan Relationship","RTPlanRelationship",false },
  {0x300a,0x0070,VR::SQ,VM::VM1,"Fraction Group Sequence","FractionGroupSequence",false },
  {0x300a,0x0071,VR::IS,VM::VM1,"Fraction Group Number","FractionGroupNumber",false },
  {0x300a,0x0072,VR::LO,VM::VM1,"Fraction Group Description","FractionGroupDescription",false },
  {0x300a,0x0078,VR::IS,VM::VM1,"Number of Fractions Planned","NumberOfFractionsPlanned",false },
  {0x300a,0x0079,VR::IS,VM::VM1,"Number of Fraction Pattern Digits Per Day","NumberOfFractionPatternDigitsPerDay",false },
  {0x300a,0x007a,VR::IS,VM::VM1,"Repeat Fraction Cycle Length","RepeatFractionCycleLength",false },
  {0x300a,0x007b,VR::LT,VM::VM1,"Fraction Pattern","FractionPattern",false },
  {0x300a,0x0080,VR::IS,VM::VM1,"Number of Beams","NumberOfBeams",false },
  {0x300a,0x0082,VR::DS,VM::VM3,"Beam Dose Specification Point","BeamDoseSpecificationPoint",false },
  {0x300a,0x0084,VR::DS,VM::VM1,"Beam Dose","BeamDose",false },
  {0x300a,0x0086,VR::DS,VM::VM1,"Beam Meterset","BeamMeterset",false },
  {0x300a,0x0088,VR::FL,VM::VM1,"Beam Dose Point Depth","BeamDosePointDepth",false },
  {0x300a,0x0089,VR::FL,VM::VM1,"Beam Dose Point Equivalent Depth","BeamDosePointEquivalentDepth",false },
  {0x300a,0x008a,VR::FL,VM::VM1,"Beam Dose Point SSD","BeamDosePointSSD",false },
  {0x300a,0x00a0,VR::IS,VM::VM1,"Number of Brachy Application Setups","NumberOfBrachyApplicationSetups",false },
  {0x300a,0x00a2,VR::DS,VM::VM3,"Brachy Application Setup Dose Specification Point","BrachyApplicationSetupDoseSpecificationPoint",false },
  {0x300a,0x00a4,VR::DS,VM::VM1,"Brachy Application Setup Dose","BrachyApplicationSetupDose",false },
  {0x300a,0x00b0,VR::SQ,VM::VM1,"Beam Sequence","BeamSequence",false },
  {0x300a,0x00b2,VR::SH,VM::VM1,"Treatment Machine Name","TreatmentMachineName",false },
  {0x300a,0x00b3,VR::CS,VM::VM1,"Primary Dosimeter Unit","PrimaryDosimeterUnit",false },
  {0x300a,0x00b4,VR::DS,VM::VM1,"Source-Axis Distance","SourceAxisDistance",false },
  {0x300a,0x00b6,VR::SQ,VM::VM1,"Beam Limiting Device Sequence","BeamLimitingDeviceSequence",false },
  {0x300a,0x00b8,VR::CS,VM::VM1,"RT Beam Limiting Device Type","RTBeamLimitingDeviceType",false },
  {0x300a,0x00ba,VR::DS,VM::VM1,"Source to Beam Limiting Device Distance","SourceToBeamLimitingDeviceDistance",false },
  {0x300a,0x00bb,VR::FL,VM::VM1,"Isocenter to Beam Limiting Device Distance","IsocenterToBeamLimitingDeviceDistance",false },
  {0x300a,0x00bc,VR::IS,VM::VM1,"Number of Leaf/Jaw Pairs","NumberOfLeafJawPairs",false },
  {0x300a,0x00be,VR::DS,VM::VM3_n,"Leaf Position Boundaries","LeafPositionBoundaries",false },
  {0x300a,0x00c0,VR::IS,VM::VM1,"Beam Number","BeamNumber",false },
  {0x300a,0x00c2,VR::LO,VM::VM1,"Beam Name","BeamName",false },
  {0x300a,0x00c3,VR::ST,VM::VM1,"Beam Description","BeamDescription",false },
  {0x300a,0x00c4,VR::CS,VM::VM1,"Beam Type","BeamType",false },
  {0x300a,0x00c6,VR::CS,VM::VM1,"Radiation Type","RadiationType",false },
  {0x300a,0x00c7,VR::CS,VM::VM1,"High-Dose Technique Type","HighDoseTechniqueType",false },
  {0x300a,0x00c8,VR::IS,VM::VM1,"Reference Image Number","ReferenceImageNumber",false },
  {0x300a,0x00ca,VR::SQ,VM::VM1,"Planned Verification Image Sequence","PlannedVerificationImageSequence",false },
  {0x300a,0x00cc,VR::LO,VM::VM1_n,"Imaging Device-Specific Acquisition Parameters","ImagingDeviceSpecificAcquisitionParameters",false },
  {0x300a,0x00ce,VR::CS,VM::VM1,"Treatment Delivery Type","TreatmentDeliveryType",false },
  {0x300a,0x00d0,VR::IS,VM::VM1,"Number of Wedges","NumberOfWedges",false },
  {0x300a,0x00d1,VR::SQ,VM::VM1,"Wedge Sequence","WedgeSequence",false },
  {0x300a,0x00d2,VR::IS,VM::VM1,"Wedge Number","WedgeNumber",false },
  {0x300a,0x00d3,VR::CS,VM::VM1,"Wedge Type","WedgeType",false },
  {0x300a,0x00d4,VR::SH,VM::VM1,"Wedge ID","WedgeID",false },
  {0x300a,0x00d5,VR::IS,VM::VM1,"Wedge Angle","WedgeAngle",false },
  {0x300a,0x00d6,VR::DS,VM::VM1,"Wedge Factor","WedgeFactor",false },
  {0x300a,0x00d7,VR::FL,VM::VM1,"Total Wedge Tray Water-Equivalent Thickness","TotalWedgeTrayWaterEquivalentThickness",false },
  {0x300a,0x00d8,VR::DS,VM::VM1,"Wedge Orientation","WedgeOrientation",false },
  {0x300a,0x00d9,VR::FL,VM::VM1,"Isocenter to Wedge Tray Distance","IsocenterToWedgeTrayDistance",false },
  {0x300a,0x00da,VR::DS,VM::VM1,"Source to Wedge Tray Distance","SourceToWedgeTrayDistance",false },
  {0x300a,0x00db,VR::FL,VM::VM1,"Wedge Thin Edge Position","WedgeThinEdgePosition",false },
  {0x300a,0x00dc,VR::SH,VM::VM1,"Bolus ID","BolusID",false },
  {0x300a,0x00dd,VR::ST,VM::VM1,"Bolus Description","BolusDescription",false },
  {0x300a,0x00e0,VR::IS,VM::VM1,"Number of Compensators","NumberOfCompensators",false },
  {0x300a,0x00e1,VR::SH,VM::VM1,"Material ID","MaterialID",false },
  {0x300a,0x00e2,VR::DS,VM::VM1,"Total Compensator Tray Factor","TotalCompensatorTrayFactor",false },
  {0x300a,0x00e3,VR::SQ,VM::VM1,"Compensator Sequence","CompensatorSequence",false },
  {0x300a,0x00e4,VR::IS,VM::VM1,"Compensator Number","CompensatorNumber",false },
  {0x300a,0x00e5,VR::SH,VM::VM1,"Compensator ID","CompensatorID",false },
  {0x300a,0x00e6,VR::DS,VM::VM1,"Source to Compensator Tray Distance","SourceToCompensatorTrayDistance",false },
  {0x300a,0x00e7,VR::IS,VM::VM1,"Compensator Rows","CompensatorRows",false },
  {0x300a,0x00e8,VR::IS,VM::VM1,"Compensator Columns","CompensatorColumns",false },
  {0x300a,0x00e9,VR::DS,VM::VM2,"Compensator Pixel Spacing","CompensatorPixelSpacing",false },
  {0x300a,0x00ea,VR::DS,VM::VM2,"Compensator Position","CompensatorPosition",false },
  {0x300a,0x00eb,VR::DS,VM::VM1_n,"Compensator Transmission Data","CompensatorTransmissionData",false },
  {0x300a,0x00ec,VR::DS,VM::VM1_n,"Compensator Thickness Data","CompensatorThicknessData",false },
  {0x300a,0x00ed,VR::IS,VM::VM1,"Number of Boli","NumberOfBoli",false },
  {0x300a,0x00ee,VR::CS,VM::VM1,"Compensator Type","CompensatorType",false },
  {0x300a,0x00f0,VR::IS,VM::VM1,"Number of Blocks","NumberOfBlocks",false },
  {0x300a,0x00f2,VR::DS,VM::VM1,"Total Block Tray Factor","TotalBlockTrayFactor",false },
  {0x300a,0x00f3,VR::FL,VM::VM1,"Total Block Tray Water-Equivalent Thickness","TotalBlockTrayWaterEquivalentThickness",false },
  {0x300a,0x00f4,VR::SQ,VM::VM1,"Block Sequence","BlockSequence",false },
  {0x300a,0x00f5,VR::SH,VM::VM1,"Block Tray ID","BlockTrayID",false },
  {0x300a,0x00f6,VR::DS,VM::VM1,"Source to Block Tray Distance","SourceToBlockTrayDistance",false },
  {0x300a,0x00f7,VR::FL,VM::VM1,"Isocenter to Block Tray Distance","IsocenterToBlockTrayDistance",false },
  {0x300a,0x00f8,VR::CS,VM::VM1,"Block Type","BlockType",false },
  {0x300a,0x00f9,VR::LO,VM::VM1,"Accessory Code","AccessoryCode",false },
  {0x300a,0x00fa,VR::CS,VM::VM1,"Block Divergence","BlockDivergence",false },
  {0x300a,0x00fb,VR::CS,VM::VM1,"Block Mounting Position","BlockMountingPosition",false },
  {0x300a,0x00fc,VR::IS,VM::VM1,"Block Number","BlockNumber",false },
  {0x300a,0x00fe,VR::LO,VM::VM1,"Block Name","BlockName",false },
  {0x300a,0x0100,VR::DS,VM::VM1,"Block Thickness","BlockThickness",false },
  {0x300a,0x0102,VR::DS,VM::VM1,"Block Transmission","BlockTransmission",false },
  {0x300a,0x0104,VR::IS,VM::VM1,"Block Number of Points","BlockNumberOfPoints",false },
  {0x300a,0x0106,VR::DS,VM::VM2_2n,"Block Data","BlockData",false },
  {0x300a,0x0107,VR::SQ,VM::VM1,"Applicator Sequence","ApplicatorSequence",false },
  {0x300a,0x0108,VR::SH,VM::VM1,"Applicator ID","ApplicatorID",false },
  {0x300a,0x0109,VR::CS,VM::VM1,"Applicator Type","ApplicatorType",false },
  {0x300a,0x010a,VR::LO,VM::VM1,"Applicator Description","ApplicatorDescription",false },
  {0x300a,0x010c,VR::DS,VM::VM1,"Cumulative Dose Reference Coefficient","CumulativeDoseReferenceCoefficient",false },
  {0x300a,0x010e,VR::DS,VM::VM1,"Final Cumulative Meterset Weight","FinalCumulativeMetersetWeight",false },
  {0x300a,0x0110,VR::IS,VM::VM1,"Number of Control Points","NumberOfControlPoints",false },
  {0x300a,0x0111,VR::SQ,VM::VM1,"Control Point Sequence","ControlPointSequence",false },
  {0x300a,0x0112,VR::IS,VM::VM1,"Control Point Index","ControlPointIndex",false },
  {0x300a,0x0114,VR::DS,VM::VM1,"Nominal Beam Energy","NominalBeamEnergy",false },
  {0x300a,0x0115,VR::DS,VM::VM1,"Dose Rate Set","DoseRateSet",false },
  {0x300a,0x0116,VR::SQ,VM::VM1,"Wedge Position Sequence","WedgePositionSequence",false },
  {0x300a,0x0118,VR::CS,VM::VM1,"Wedge Position","WedgePosition",false },
  {0x300a,0x011a,VR::SQ,VM::VM1,"Beam Limiting Device Position Sequence","BeamLimitingDevicePositionSequence",false },
  {0x300a,0x011c,VR::DS,VM::VM2_2n,"Leaf/Jaw Positions","LeafJawPositions",false },
  {0x300a,0x011e,VR::DS,VM::VM1,"Gantry Angle","GantryAngle",false },
  {0x300a,0x011f,VR::CS,VM::VM1,"Gantry Rotation Direction","GantryRotationDirection",false },
  {0x300a,0x0120,VR::DS,VM::VM1,"Beam Limiting Device Angle","BeamLimitingDeviceAngle",false },
  {0x300a,0x0121,VR::CS,VM::VM1,"Beam Limiting Device Rotation Direction","BeamLimitingDeviceRotationDirection",false },
  {0x300a,0x0122,VR::DS,VM::VM1,"Patient Support Angle","PatientSupportAngle",false },
  {0x300a,0x0123,VR::CS,VM::VM1,"Patient Support Rotation Direction","PatientSupportRotationDirection",false },
  {0x300a,0x0124,VR::DS,VM::VM1,"Table Top Eccentric Axis Distance","TableTopEccentricAxisDistance",false },
  {0x300a,0x0125,VR::DS,VM::VM1,"Table Top Eccentric Angle","TableTopEccentricAngle",false },
  {0x300a,0x0126,VR::CS,VM::VM1,"Table Top Eccentric Rotation Direction","TableTopEccentricRotationDirection",false },
  {0x300a,0x0128,VR::DS,VM::VM1,"Table Top Vertical Position","TableTopVerticalPosition",false },
  {0x300a,0x0129,VR::DS,VM::VM1,"Table Top Longitudinal Position","TableTopLongitudinalPosition",false },
  {0x300a,0x012a,VR::DS,VM::VM1,"Table Top Lateral Position","TableTopLateralPosition",false },
  {0x300a,0x012c,VR::DS,VM::VM3,"Isocenter Position","IsocenterPosition",false },
  {0x300a,0x012e,VR::DS,VM::VM3,"Surface Entry Point","SurfaceEntryPoint",false },
  {0x300a,0x0130,VR::DS,VM::VM1,"Source to Surface Distance","SourceToSurfaceDistance",false },
  {0x300a,0x0134,VR::DS,VM::VM1,"Cumulative Meterset Weight","CumulativeMetersetWeight",false },
  {0x300a,0x0140,VR::FL,VM::VM1,"Table Top Pitch Angle","TableTopPitchAngle",false },
  {0x300a,0x0142,VR::CS,VM::VM1,"Table Top Pitch Rotation Direction","TableTopPitchRotationDirection",false },
  {0x300a,0x0144,VR::FL,VM::VM1,"Table Top Roll Angle","TableTopRollAngle",false },
  {0x300a,0x0146,VR::CS,VM::VM1,"Table Top Roll Rotation Direction","TableTopRollRotationDirection",false },
  {0x300a,0x0148,VR::FL,VM::VM1,"Head Fixation Angle","HeadFixationAngle",false },
  {0x300a,0x014a,VR::FL,VM::VM1,"Gantry Pitch Angle","GantryPitchAngle",false },
  {0x300a,0x014c,VR::CS,VM::VM1,"Gantry Pitch Rotation Direction","GantryPitchRotationDirection",false },
  {0x300a,0x014e,VR::FL,VM::VM1,"Gantry Pitch Angle Tolerance","GantryPitchAngleTolerance",false },
  {0x300a,0x0180,VR::SQ,VM::VM1,"Patient Setup Sequence","PatientSetupSequence",false },
  {0x300a,0x0182,VR::IS,VM::VM1,"Patient Setup Number","PatientSetupNumber",false },
  {0x300a,0x0183,VR::LO,VM::VM1,"Patient Setup Label","PatientSetupLabel",false },
  {0x300a,0x0184,VR::LO,VM::VM1,"Patient Additional Position","PatientAdditionalPosition",false },
  {0x300a,0x0190,VR::SQ,VM::VM1,"Fixation Device Sequence","FixationDeviceSequence",false },
  {0x300a,0x0192,VR::CS,VM::VM1,"Fixation Device Type","FixationDeviceType",false },
  {0x300a,0x0194,VR::SH,VM::VM1,"Fixation Device Label","FixationDeviceLabel",false },
  {0x300a,0x0196,VR::ST,VM::VM1,"Fixation Device Description","FixationDeviceDescription",false },
  {0x300a,0x0198,VR::SH,VM::VM1,"Fixation Device Position","FixationDevicePosition",false },
  {0x300a,0x0199,VR::FL,VM::VM1,"Fixation Device Pitch Angle","FixationDevicePitchAngle",false },
  {0x300a,0x019a,VR::FL,VM::VM1,"Fixation Device Roll Angle","FixationDeviceRollAngle",false },
  {0x300a,0x01a0,VR::SQ,VM::VM1,"Shielding Device Sequence","ShieldingDeviceSequence",false },
  {0x300a,0x01a2,VR::CS,VM::VM1,"Shielding Device Type","ShieldingDeviceType",false },
  {0x300a,0x01a4,VR::SH,VM::VM1,"Shielding Device Label","ShieldingDeviceLabel",false },
  {0x300a,0x01a6,VR::ST,VM::VM1,"Shielding Device Description","ShieldingDeviceDescription",false },
  {0x300a,0x01a8,VR::SH,VM::VM1,"Shielding Device Position","ShieldingDevicePosition",false },
  {0x300a,0x01b0,VR::CS,VM::VM1,"Setup Technique","SetupTechnique",false },
  {0x300a,0x01b2,VR::ST,VM::VM1,"Setup Technique Description","SetupTechniqueDescription",false },
  {0x300a,0x01b4,VR::SQ,VM::VM1,"Setup Device Sequence","SetupDeviceSequence",false },
  {0x300a,0x01b6,VR::CS,VM::VM1,"Setup Device Type","SetupDeviceType",false },
  {0x300a,0x01b8,VR::SH,VM::VM1,"Setup Device Label","SetupDeviceLabel",false },
  {0x300a,0x01ba,VR::ST,VM::VM1,"Setup Device Description","SetupDeviceDescription",false },
  {0x300a,0x01bc,VR::DS,VM::VM1,"Setup Device Parameter","SetupDeviceParameter",false },
  {0x300a,0x01d0,VR::ST,VM::VM1,"Setup Reference Description","SetupReferenceDescription",false },
  {0x300a,0x01d2,VR::DS,VM::VM1,"Table Top Vertical Setup Displacement","TableTopVerticalSetupDisplacement",false },
  {0x300a,0x01d4,VR::DS,VM::VM1,"Table Top Longitudinal Setup Displacement","TableTopLongitudinalSetupDisplacement",false },
  {0x300a,0x01d6,VR::DS,VM::VM1,"Table Top Lateral Setup Displacement","TableTopLateralSetupDisplacement",false },
  {0x300a,0x0200,VR::CS,VM::VM1,"Brachy Treatment Technique","BrachyTreatmentTechnique",false },
  {0x300a,0x0202,VR::CS,VM::VM1,"Brachy Treatment Type","BrachyTreatmentType",false },
  {0x300a,0x0206,VR::SQ,VM::VM1,"Treatment Machine Sequence","TreatmentMachineSequence",false },
  {0x300a,0x0210,VR::SQ,VM::VM1,"Source Sequence","SourceSequence",false },
  {0x300a,0x0212,VR::IS,VM::VM1,"Source Number","SourceNumber",false },
  {0x300a,0x0214,VR::CS,VM::VM1,"Source Type","SourceType",false },
  {0x300a,0x0216,VR::LO,VM::VM1,"Source Manufacturer","SourceManufacturer",false },
  {0x300a,0x0218,VR::DS,VM::VM1,"Active Source Diameter","ActiveSourceDiameter",false },
  {0x300a,0x021a,VR::DS,VM::VM1,"Active Source Length","ActiveSourceLength",false },
  {0x300a,0x0222,VR::DS,VM::VM1,"Source Encapsulation Nominal Thickness","SourceEncapsulationNominalThickness",false },
  {0x300a,0x0224,VR::DS,VM::VM1,"Source Encapsulation Nominal Transmission","SourceEncapsulationNominalTransmission",false },
  {0x300a,0x0226,VR::LO,VM::VM1,"Source Isotope Name","SourceIsotopeName",false },
  {0x300a,0x0228,VR::DS,VM::VM1,"Source Isotope Half Life","SourceIsotopeHalfLife",false },
  {0x300a,0x0229,VR::CS,VM::VM1,"Source Strength Units","SourceStrengthUnits",false },
  {0x300a,0x022a,VR::DS,VM::VM1,"Reference Air Kerma Rate","ReferenceAirKermaRate",false },
  {0x300a,0x022b,VR::DS,VM::VM1,"Source Strength","SourceStrength",false },
  {0x300a,0x022c,VR::DA,VM::VM1,"Source Strength Reference Date","SourceStrengthReferenceDate",false },
  {0x300a,0x022e,VR::TM,VM::VM1,"Source Strength Reference Time","SourceStrengthReferenceTime",false },
  {0x300a,0x0230,VR::SQ,VM::VM1,"Application Setup Sequence","ApplicationSetupSequence",false },
  {0x300a,0x0232,VR::CS,VM::VM1,"Application Setup Type","ApplicationSetupType",false },
  {0x300a,0x0234,VR::IS,VM::VM1,"Application Setup Number","ApplicationSetupNumber",false },
  {0x300a,0x0236,VR::LO,VM::VM1,"Application Setup Name","ApplicationSetupName",false },
  {0x300a,0x0238,VR::LO,VM::VM1,"Application Setup Manufacturer","ApplicationSetupManufacturer",false },
  {0x300a,0x0240,VR::IS,VM::VM1,"Template Number","TemplateNumber",false },
  {0x300a,0x0242,VR::SH,VM::VM1,"Template Type","TemplateType",false },
  {0x300a,0x0244,VR::LO,VM::VM1,"Template Name","TemplateName",false },
  {0x300a,0x0250,VR::DS,VM::VM1,"Total Reference Air Kerma","TotalReferenceAirKerma",false },
  {0x300a,0x0260,VR::SQ,VM::VM1,"Brachy Accessory Device Sequence","BrachyAccessoryDeviceSequence",false },
  {0x300a,0x0262,VR::IS,VM::VM1,"Brachy Accessory Device Number","BrachyAccessoryDeviceNumber",false },
  {0x300a,0x0263,VR::SH,VM::VM1,"Brachy Accessory Device ID","BrachyAccessoryDeviceID",false },
  {0x300a,0x0264,VR::CS,VM::VM1,"Brachy Accessory Device Type","BrachyAccessoryDeviceType",false },
  {0x300a,0x0266,VR::LO,VM::VM1,"Brachy Accessory Device Name","BrachyAccessoryDeviceName",false },
  {0x300a,0x026a,VR::DS,VM::VM1,"Brachy Accessory Device Nominal Thickness","BrachyAccessoryDeviceNominalThickness",false },
  {0x300a,0x026c,VR::DS,VM::VM1,"Brachy Accessory Device Nominal Transmission","BrachyAccessoryDeviceNominalTransmission",false },
  {0x300a,0x0280,VR::SQ,VM::VM1,"Channel Sequence","ChannelSequence",false },
  {0x300a,0x0282,VR::IS,VM::VM1,"Channel Number","ChannelNumber",false },
  {0x300a,0x0284,VR::DS,VM::VM1,"Channel Length","ChannelLength",false },
  {0x300a,0x0286,VR::DS,VM::VM1,"Channel Total Time","ChannelTotalTime",false },
  {0x300a,0x0288,VR::CS,VM::VM1,"Source Movement Type","SourceMovementType",false },
  {0x300a,0x028a,VR::IS,VM::VM1,"Number of Pulses","NumberOfPulses",false },
  {0x300a,0x028c,VR::DS,VM::VM1,"Pulse Repetition Interval","PulseRepetitionInterval",false },
  {0x300a,0x0290,VR::IS,VM::VM1,"Source Applicator Number","SourceApplicatorNumber",false },
  {0x300a,0x0291,VR::SH,VM::VM1,"Source Applicator ID","SourceApplicatorID",false },
  {0x300a,0x0292,VR::CS,VM::VM1,"Source Applicator Type","SourceApplicatorType",false },
  {0x300a,0x0294,VR::LO,VM::VM1,"Source Applicator Name","SourceApplicatorName",false },
  {0x300a,0x0296,VR::DS,VM::VM1,"Source Applicator Length","SourceApplicatorLength",false },
  {0x300a,0x0298,VR::LO,VM::VM1,"Source Applicator Manufacturer","SourceApplicatorManufacturer",false },
  {0x300a,0x029c,VR::DS,VM::VM1,"Source Applicator Wall Nominal Thickness","SourceApplicatorWallNominalThickness",false },
  {0x300a,0x029e,VR::DS,VM::VM1,"Source Applicator Wall Nominal Transmission","SourceApplicatorWallNominalTransmission",false },
  {0x300a,0x02a0,VR::DS,VM::VM1,"Source Applicator Step Size","SourceApplicatorStepSize",false },
  {0x300a,0x02a2,VR::IS,VM::VM1,"Transfer Tube Number","TransferTubeNumber",false },
  {0x300a,0x02a4,VR::DS,VM::VM1,"Transfer Tube Length","TransferTubeLength",false },
  {0x300a,0x02b0,VR::SQ,VM::VM1,"Channel Shield Sequence","ChannelShieldSequence",false },
  {0x300a,0x02b2,VR::IS,VM::VM1,"Channel Shield Number","ChannelShieldNumber",false },
  {0x300a,0x02b3,VR::SH,VM::VM1,"Channel Shield ID","ChannelShieldID",false },
  {0x300a,0x02b4,VR::LO,VM::VM1,"Channel Shield Name","ChannelShieldName",false },
  {0x300a,0x02b8,VR::DS,VM::VM1,"Channel Shield Nominal Thickness","ChannelShieldNominalThickness",false },
  {0x300a,0x02ba,VR::DS,VM::VM1,"Channel Shield Nominal Transmission","ChannelShieldNominalTransmission",false },
  {0x300a,0x02c8,VR::DS,VM::VM1,"Final Cumulative Time Weight","FinalCumulativeTimeWeight",false },
  {0x300a,0x02d0,VR::SQ,VM::VM1,"Brachy Control Point Sequence","BrachyControlPointSequence",false },
  {0x300a,0x02d2,VR::DS,VM::VM1,"Control Point Relative Position","ControlPointRelativePosition",false },
  {0x300a,0x02d4,VR::DS,VM::VM3,"Control Point 3D Position","ControlPoint3DPosition",false },
  {0x300a,0x02d6,VR::DS,VM::VM1,"Cumulative Time Weight","CumulativeTimeWeight",false },
  {0x300a,0x02e0,VR::CS,VM::VM1,"Compensator Divergence","CompensatorDivergence",false },
  {0x300a,0x02e1,VR::CS,VM::VM1,"Compensator Mounting Position","CompensatorMountingPosition",false },
  {0x300a,0x02e2,VR::DS,VM::VM1_n,"Source to Compensator Distance","SourceToCompensatorDistance",false },
  {0x300a,0x02e3,VR::FL,VM::VM1,"Total Compensator Tray Water-Equivalent Thickness","TotalCompensatorTrayWaterEquivalentThickness",false },
  {0x300a,0x02e4,VR::FL,VM::VM1,"Isocenter to Compensator Tray Distance","IsocenterToCompensatorTrayDistance",false },
  {0x300a,0x02e5,VR::FL,VM::VM1,"Compensator Column Offset","CompensatorColumnOffset",false },
  {0x300a,0x02e6,VR::FL,VM::VM1_n,"Isocenter to Compensator Distances","IsocenterToCompensatorDistances",false },
  {0x300a,0x02e7,VR::FL,VM::VM1,"Compensator Relative Stopping Power Ratio","CompensatorRelativeStoppingPowerRatio",false },
  {0x300a,0x02e8,VR::FL,VM::VM1,"Compensator Milling Tool Diameter","CompensatorMillingToolDiameter",false },
  {0x300a,0x02ea,VR::SQ,VM::VM1,"Ion Range Compensator Sequence","IonRangeCompensatorSequence",false },
  {0x300a,0x02eb,VR::LT,VM::VM1,"Compensator Description","CompensatorDescription",false },
  {0x300a,0x0302,VR::IS,VM::VM1,"Radiation Mass Number","RadiationMassNumber",false },
  {0x300a,0x0304,VR::IS,VM::VM1,"Radiation Atomic Number","RadiationAtomicNumber",false },
  {0x300a,0x0306,VR::SS,VM::VM1,"Radiation Charge State","RadiationChargeState",false },
  {0x300a,0x0308,VR::CS,VM::VM1,"Scan Mode","ScanMode",false },
  {0x300a,0x030a,VR::FL,VM::VM2,"Virtual Source-Axis Distances","VirtualSourceAxisDistances",false },
  {0x300a,0x030c,VR::SQ,VM::VM1,"Snout Sequence","SnoutSequence",false },
  {0x300a,0x030d,VR::FL,VM::VM1,"Snout Position","SnoutPosition",false },
  {0x300a,0x030f,VR::SH,VM::VM1,"Snout ID","SnoutID",false },
  {0x300a,0x0312,VR::IS,VM::VM1,"Number of Range Shifters","NumberOfRangeShifters",false },
  {0x300a,0x0314,VR::SQ,VM::VM1,"Range Shifter Sequence","RangeShifterSequence",false },
  {0x300a,0x0316,VR::IS,VM::VM1,"Range Shifter Number","RangeShifterNumber",false },
  {0x300a,0x0318,VR::SH,VM::VM1,"Range Shifter ID","RangeShifterID",false },
  {0x300a,0x0320,VR::CS,VM::VM1,"Range Shifter Type","RangeShifterType",false },
  {0x300a,0x0322,VR::LO,VM::VM1,"Range Shifter Description","RangeShifterDescription",false },
  {0x300a,0x0330,VR::IS,VM::VM1,"Number of Lateral Spreading Devices","NumberOfLateralSpreadingDevices",false },
  {0x300a,0x0332,VR::SQ,VM::VM1,"Lateral Spreading Device Sequence","LateralSpreadingDeviceSequence",false },
  {0x300a,0x0334,VR::IS,VM::VM1,"Lateral Spreading Device Number","LateralSpreadingDeviceNumber",false },
  {0x300a,0x0336,VR::SH,VM::VM1,"Lateral Spreading Device ID","LateralSpreadingDeviceID",false },
  {0x300a,0x0338,VR::CS,VM::VM1,"Lateral Spreading Device Type","LateralSpreadingDeviceType",false },
  {0x300a,0x033a,VR::LO,VM::VM1,"Lateral Spreading Device Description","LateralSpreadingDeviceDescription",false },
  {0x300a,0x033c,VR::FL,VM::VM1,"Lateral Spreading Device Water Equivalent Thickness","LateralSpreadingDeviceWaterEquivalentThickness",false },
  {0x300a,0x0340,VR::IS,VM::VM1,"Number of Range Modulators","NumberOfRangeModulators",false },
  {0x300a,0x0342,VR::SQ,VM::VM1,"Range Modulator Sequence","RangeModulatorSequence",false },
  {0x300a,0x0344,VR::IS,VM::VM1,"Range Modulator Number","RangeModulatorNumber",false },
  {0x300a,0x0346,VR::SH,VM::VM1,"Range Modulator ID","RangeModulatorID",false },
  {0x300a,0x0348,VR::CS,VM::VM1,"Range Modulator Type","RangeModulatorType",false },
  {0x300a,0x034a,VR::LO,VM::VM1,"Range Modulator Description","RangeModulatorDescription",false },
  {0x300a,0x034c,VR::SH,VM::VM1,"Beam Current Modulation ID","BeamCurrentModulationID",false },
  {0x300a,0x0350,VR::CS,VM::VM1,"Patient Support Type","PatientSupportType",false },
  {0x300a,0x0352,VR::SH,VM::VM1,"Patient Support ID","PatientSupportID",false },
  {0x300a,0x0354,VR::LO,VM::VM1,"Patient Support Accessory Code","PatientSupportAccessoryCode",false },
  {0x300a,0x0356,VR::FL,VM::VM1,"Fixation Light Azimuthal Angle","FixationLightAzimuthalAngle",false },
  {0x300a,0x0358,VR::FL,VM::VM1,"Fixation Light Polar Angle","FixationLightPolarAngle",false },
  {0x300a,0x035a,VR::FL,VM::VM1,"Meterset Rate","MetersetRate",false },
  {0x300a,0x0360,VR::SQ,VM::VM1,"Range Shifter Settings Sequence","RangeShifterSettingsSequence",false },
  {0x300a,0x0362,VR::LO,VM::VM1,"Range Shifter Setting","RangeShifterSetting",false },
  {0x300a,0x0364,VR::FL,VM::VM1,"Isocenter to Range Shifter Distance","IsocenterToRangeShifterDistance",false },
  {0x300a,0x0366,VR::FL,VM::VM1,"Range Shifter Water Equivalent Thickness","RangeShifterWaterEquivalentThickness",false },
  {0x300a,0x0370,VR::SQ,VM::VM1,"Lateral Spreading Device Settings Sequence","LateralSpreadingDeviceSettingsSequence",false },
  {0x300a,0x0372,VR::LO,VM::VM1,"Lateral Spreading Device Setting","LateralSpreadingDeviceSetting",false },
  {0x300a,0x0374,VR::FL,VM::VM1,"Isocenter to Lateral Spreading Device Distance","IsocenterToLateralSpreadingDeviceDistance",false },
  {0x300a,0x0380,VR::SQ,VM::VM1,"Range Modulator Settings Sequence","RangeModulatorSettingsSequence",false },
  {0x300a,0x0382,VR::FL,VM::VM1,"Range Modulator Gating Start Value","RangeModulatorGatingStartValue",false },
  {0x300a,0x0384,VR::FL,VM::VM1,"Range Modulator Gating Stop Value","RangeModulatorGatingStopValue",false },
  {0x300a,0x0386,VR::FL,VM::VM1,"Range Modulator Gating Start Water Equivalent Thickness","RangeModulatorGatingStartWaterEquivalentThickness",false },
  {0x300a,0x0388,VR::FL,VM::VM1,"Range Modulator Gating Stop Water Equivalent Thickness","RangeModulatorGatingStopWaterEquivalentThickness",false },
  {0x300a,0x038a,VR::FL,VM::VM1,"Isocenter to Range Modulator Distance","IsocenterToRangeModulatorDistance",false },
  {0x300a,0x0390,VR::SH,VM::VM1,"Scan Spot Tune ID","ScanSpotTuneID",false },
  {0x300a,0x0392,VR::IS,VM::VM1,"Number of Scan Spot Positions","NumberOfScanSpotPositions",false },
  {0x300a,0x0394,VR::FL,VM::VM1_n,"Scan Spot Position Map","ScanSpotPositionMap",false },
  {0x300a,0x0396,VR::FL,VM::VM1_n,"Scan Spot Meterset Weights","ScanSpotMetersetWeights",false },
  {0x300a,0x0398,VR::FL,VM::VM2,"Scanning Spot Size","ScanningSpotSize",false },
  {0x300a,0x039a,VR::IS,VM::VM1,"Number of Paintings","NumberOfPaintings",false },
  {0x300a,0x03a0,VR::SQ,VM::VM1,"Ion Tolerance Table Sequence","IonToleranceTableSequence",false },
  {0x300a,0x03a2,VR::SQ,VM::VM1,"Ion Beam Sequence","IonBeamSequence",false },
  {0x300a,0x03a4,VR::SQ,VM::VM1,"Ion Beam Limiting Device Sequence","IonBeamLimitingDeviceSequence",false },
  {0x300a,0x03a6,VR::SQ,VM::VM1,"Ion Block Sequence","IonBlockSequence",false },
  {0x300a,0x03a8,VR::SQ,VM::VM1,"Ion Control Point Sequence","IonControlPointSequence",false },
  {0x300a,0x03aa,VR::SQ,VM::VM1,"Ion Wedge Sequence","IonWedgeSequence",false },
  {0x300a,0x03ac,VR::SQ,VM::VM1,"Ion Wedge Position Sequence","IonWedgePositionSequence",false },
  {0x300a,0x0401,VR::SQ,VM::VM1,"Referenced Setup Image Sequence","ReferencedSetupImageSequence",false },
  {0x300a,0x0402,VR::ST,VM::VM1,"Setup Image Comment","SetupImageComment",false },
  {0x300a,0x0410,VR::SQ,VM::VM1,"Motion Synchronization Sequence","MotionSynchronizationSequence",false },
  {0x300a,0x0412,VR::FL,VM::VM3,"Control Point Orientation","ControlPointOrientation",false },
  {0x300a,0x0420,VR::SQ,VM::VM1,"General Accessory Sequence","GeneralAccessorySequence",false },
  {0x300a,0x0421,VR::SH,VM::VM1,"General Accessory ID","GeneralAccessoryID",false },
  {0x300a,0x0422,VR::ST,VM::VM1,"General Accessory Description","GeneralAccessoryDescription",false },
  {0x300a,0x0423,VR::CS,VM::VM1,"General Accessory Type","GeneralAccessoryType",false },
  {0x300a,0x0424,VR::IS,VM::VM1,"General Accessory Number","GeneralAccessoryNumber",false },
  {0x300a,0x0431,VR::SQ,VM::VM1,"Applicator Geometry Sequence","ApplicatorGeometrySequence",false },
  {0x300a,0x0432,VR::CS,VM::VM1,"Applicator Aperture Shape","ApplicatorApertureShape",false },
  {0x300a,0x0433,VR::FL,VM::VM1,"Applicator Opening","ApplicatorOpening",false },
  {0x300a,0x0434,VR::FL,VM::VM1,"Applicator Opening X","ApplicatorOpeningX",false },
  {0x300a,0x0435,VR::FL,VM::VM1,"Applicator Opening Y","ApplicatorOpeningY",false },
  {0x300a,0x0436,VR::FL,VM::VM1,"Source to Applicator Mounting Position Distance","SourceToApplicatorMountingPositionDistance",false },
  {0x300c,0x0002,VR::SQ,VM::VM1,"Referenced RT Plan Sequence","ReferencedRTPlanSequence",false },
  {0x300c,0x0004,VR::SQ,VM::VM1,"Referenced Beam Sequence","ReferencedBeamSequence",false },
  {0x300c,0x0006,VR::IS,VM::VM1,"Referenced Beam Number","ReferencedBeamNumber",false },
  {0x300c,0x0007,VR::IS,VM::VM1,"Referenced Reference Image Number","ReferencedReferenceImageNumber",false },
  {0x300c,0x0008,VR::DS,VM::VM1,"Start Cumulative Meterset Weight","StartCumulativeMetersetWeight",false },
  {0x300c,0x0009,VR::DS,VM::VM1,"End Cumulative Meterset Weight","EndCumulativeMetersetWeight",false },
  {0x300c,0x000a,VR::SQ,VM::VM1,"Referenced Brachy Application Setup Sequence","ReferencedBrachyApplicationSetupSequence",false },
  {0x300c,0x000c,VR::IS,VM::VM1,"Referenced Brachy Application Setup Number","ReferencedBrachyApplicationSetupNumber",false },
  {0x300c,0x000e,VR::IS,VM::VM1,"Referenced Source Number","ReferencedSourceNumber",false },
  {0x300c,0x0020,VR::SQ,VM::VM1,"Referenced Fraction Group Sequence","ReferencedFractionGroupSequence",false },
  {0x300c,0x0022,VR::IS,VM::VM1,"Referenced Fraction Group Number","ReferencedFractionGroupNumber",false },
  {0x300c,0x0040,VR::SQ,VM::VM1,"Referenced Verification Image Sequence","ReferencedVerificationImageSequence",false },
  {0x300c,0x0042,VR::SQ,VM::VM1,"Referenced Reference Image Sequence","ReferencedReferenceImageSequence",false },
  {0x300c,0x0050,VR::SQ,VM::VM1,"Referenced Dose Reference Sequence","ReferencedDoseReferenceSequence",false },
  {0x300c,0x0051,VR::IS,VM::VM1,"Referenced Dose Reference Number","ReferencedDoseReferenceNumber",false },
  {0x300c,0x0055,VR::SQ,VM::VM1,"Brachy Referenced Dose Reference Sequence","BrachyReferencedDoseReferenceSequence",false },
  {0x300c,0x0060,VR::SQ,VM::VM1,"Referenced Structure Set Sequence","ReferencedStructureSetSequence",false },
  {0x300c,0x006a,VR::IS,VM::VM1,"Referenced Patient Setup Number","ReferencedPatientSetupNumber",false },
  {0x300c,0x0080,VR::SQ,VM::VM1,"Referenced Dose Sequence","ReferencedDoseSequence",false },
  {0x300c,0x00a0,VR::IS,VM::VM1,"Referenced Tolerance Table Number","ReferencedToleranceTableNumber",false },
  {0x300c,0x00b0,VR::SQ,VM::VM1,"Referenced Bolus Sequence","ReferencedBolusSequence",false },
  {0x300c,0x00c0,VR::IS,VM::VM1,"Referenced Wedge Number","ReferencedWedgeNumber",false },
  {0x300c,0x00d0,VR::IS,VM::VM1,"Referenced Compensator Number","ReferencedCompensatorNumber",false },
  {0x300c,0x00e0,VR::IS,VM::VM1,"Referenced Block Number","ReferencedBlockNumber",false },
  {0x300c,0x00f0,VR::IS,VM::VM1,"Referenced Control Point Index","ReferencedControlPointIndex",false },
  {0x300c,0x00f2,VR::SQ,VM::VM1,"Referenced Control Point Sequence","ReferencedControlPointSequence",false },
  {0x300c,0x00f4,VR::IS,VM::VM1,"Referenced Start Control Point Index","ReferencedStartControlPointIndex",false },
  {0x300c,0x00f6,VR::IS,VM::VM1,"Referenced Stop Control Point Index","ReferencedStopControlPointIndex",false },
  {0x300c,0x0100,VR::IS,VM::VM1,"Referenced Range Shifter Number","ReferencedRangeShifterNumber",false },
  {0x300c,0x0102,VR::IS,VM::VM1,"Referenced Lateral Spreading Device Number","ReferencedLateralSpreadingDeviceNumber",false },
  {0x300c,0x0104,VR::IS,VM::VM1,"Referenced Range Modulator Number","ReferencedRangeModulatorNumber",false },
  {0x300e,0x0002,VR::CS,VM::VM1,"Approval Status","ApprovalStatus",false },
  {0x300e,0x0004,VR::DA,VM::VM1,"Review Date","ReviewDate",false },
  {0x300e,0x0005,VR::TM,VM::VM1,"Review Time","ReviewTime",false },
  {0x300e,0x0008,VR::PN,VM::VM1,"Reviewer Name","ReviewerName",false },
  {0x4000,0x0010,VR::LT,VM::VM1,"Arbitrary","Arbitrary",true },
  {0x4000,0x4000,VR::LT,VM::VM1,"Text Comments","TextComments",true },
  {0x4008,0x0040,VR::SH,VM::VM1,"Results ID","ResultsID",true },
  {0x4008,0x0042,VR::LO,VM::VM1,"Results ID Issuer","ResultsIDIssuer",true },
  {0x4008,0x0050,VR::SQ,VM::VM1,"Referenced Interpretation Sequence","ReferencedInterpretationSequence",true },
  {0x4008,0x00ff,VR::CS,VM::VM1,"Report Production Status (Trial)","ReportProductionStatusTrial",true },
  {0x4008,0x0100,VR::DA,VM::VM1,"Interpretation Recorded Date","InterpretationRecordedDate",true },
  {0x4008,0x0101,VR::TM,VM::VM1,"Interpretation Recorded Time","InterpretationRecordedTime",true },
  {0x4008,0x0102,VR::PN,VM::VM1,"Interpretation Recorder","InterpretationRecorder",true },
  {0x4008,0x0103,VR::LO,VM::VM1,"Reference to Recorded Sound","ReferenceToRecordedSound",true },
  {0x4008,0x0108,VR::DA,VM::VM1,"Interpretation Transcription Date","InterpretationTranscriptionDate",true },
  {0x4008,0x0109,VR::TM,VM::VM1,"Interpretation Transcription Time","InterpretationTranscriptionTime",true },
  {0x4008,0x010a,VR::PN,VM::VM1,"Interpretation Transcriber","InterpretationTranscriber",true },
  {0x4008,0x010b,VR::ST,VM::VM1,"Interpretation Text","InterpretationText",true },
  {0x4008,0x010c,VR::PN,VM::VM1,"Interpretation Author","InterpretationAuthor",true },
  {0x4008,0x0111,VR::SQ,VM::VM1,"Interpretation Approver Sequence","InterpretationApproverSequence",true },
  {0x4008,0x0112,VR::DA,VM::VM1,"Interpretation Approval Date","InterpretationApprovalDate",true },
  {0x4008,0x0113,VR::TM,VM::VM1,"Interpretation Approval Time","InterpretationApprovalTime",true },
  {0x4008,0x0114,VR::PN,VM::VM1,"Physician Approving Interpretation","PhysicianApprovingInterpretation",true },
  {0x4008,0x0115,VR::LT,VM::VM1,"Interpretation Diagnosis Description","InterpretationDiagnosisDescription",true },
  {0x4008,0x0117,VR::SQ,VM::VM1,"Interpretation Diagnosis Code Sequence","InterpretationDiagnosisCodeSequence",true },
  {0x4008,0x0118,VR::SQ,VM::VM1,"Results Distribution List Sequence","ResultsDistributionListSequence",true },
  {0x4008,0x0119,VR::PN,VM::VM1,"Distribution Name","DistributionName",true },
  {0x4008,0x011a,VR::LO,VM::VM1,"Distribution Address","DistributionAddress",true },
  {0x4008,0x0200,VR::SH,VM::VM1,"Interpretation ID","InterpretationID",true },
  {0x4008,0x0202,VR::LO,VM::VM1,"Interpretation ID Issuer","InterpretationIDIssuer",true },
  {0x4008,0x0210,VR::CS,VM::VM1,"Interpretation Type ID","InterpretationTypeID",true },
  {0x4008,0x0212,VR::CS,VM::VM1,"Interpretation Status ID","InterpretationStatusID",true },
  {0x4008,0x0300,VR::ST,VM::VM1,"Impressions","Impressions",true },
  {0x4008,0x4000,VR::ST,VM::VM1,"Results Comments","ResultsComments",true },
  {0x4010,0x0001,VR::CS,VM::VM1,"Low Energy Detectors","LowEnergyDetectors",false },
  {0x4010,0x0002,VR::CS,VM::VM1,"High Energy Detectors","HighEnergyDetectors",false },
  {0x4010,0x0004,VR::SQ,VM::VM1,"Detector Geometry Sequence","DetectorGeometrySequence",false },
  {0x4010,0x1001,VR::SQ,VM::VM1,"Threat ROI Voxel Sequence","ThreatROIVoxelSequence",false },
  {0x4010,0x1004,VR::FL,VM::VM3,"Threat ROI Base","ThreatROIBase",false },
  {0x4010,0x1005,VR::FL,VM::VM3,"Threat ROI Extents","ThreatROIExtents",false },
  {0x4010,0x1006,VR::OB,VM::VM1,"Threat ROI Bitmap","ThreatROIBitmap",false },
  {0x4010,0x1007,VR::SH,VM::VM1,"Route Segment ID","RouteSegmentID",false },
  {0x4010,0x1008,VR::CS,VM::VM1,"Gantry Type","GantryType",false },
  {0x4010,0x1009,VR::CS,VM::VM1,"OOI Owner Type","OOIOwnerType",false },
  {0x4010,0x100a,VR::SQ,VM::VM1,"Route Segment Sequence","RouteSegmentSequence",false },
  {0x4010,0x1010,VR::US,VM::VM1,"Potential Threat Object ID","PotentialThreatObjectID",false },
  {0x4010,0x1011,VR::SQ,VM::VM1,"Threat Sequence","ThreatSequence",false },
  {0x4010,0x1012,VR::CS,VM::VM1,"Threat Category","ThreatCategory",false },
  {0x4010,0x1013,VR::LT,VM::VM1,"Threat Category Description","ThreatCategoryDescription",false },
  {0x4010,0x1014,VR::CS,VM::VM1,"ATD Ability Assessment","ATDAbilityAssessment",false },
  {0x4010,0x1015,VR::CS,VM::VM1,"ATD Assessment Flag","ATDAssessmentFlag",false },
  {0x4010,0x1016,VR::FL,VM::VM1,"ATD Assessment Probability","ATDAssessmentProbability",false },
  {0x4010,0x1017,VR::FL,VM::VM1,"Mass","Mass",false },
  {0x4010,0x1018,VR::FL,VM::VM1,"Density","Density",false },
  {0x4010,0x1019,VR::FL,VM::VM1,"Z Effective","ZEffective",false },
  {0x4010,0x101a,VR::SH,VM::VM1,"Boarding Pass ID","BoardingPassID",false },
  {0x4010,0x101b,VR::FL,VM::VM3,"Center of Mass","CenterOfMass",false },
  {0x4010,0x101c,VR::FL,VM::VM3,"Center of PTO","CenterOfPTO",false },
  {0x4010,0x101d,VR::FL,VM::VM6_6n,"Bounding Polygon","BoundingPolygon",false },
  {0x4010,0x101e,VR::SH,VM::VM1,"Route Segment Start Location ID","RouteSegmentStartLocationID",false },
  {0x4010,0x101f,VR::SH,VM::VM1,"Route Segment End Location ID","RouteSegmentEndLocationID",false },
  {0x4010,0x1020,VR::CS,VM::VM1,"Route Segment Location ID Type","RouteSegmentLocationIDType",false },
  {0x4010,0x1021,VR::CS,VM::VM1_n,"Abort Reason","AbortReason",false },
  {0x4010,0x1023,VR::FL,VM::VM1,"Volume of PTO","VolumeOfPTO",false },
  {0x4010,0x1024,VR::CS,VM::VM1,"Abort Flag","AbortFlag",false },
  {0x4010,0x1025,VR::DT,VM::VM1,"Route Segment Start Time","RouteSegmentStartTime",false },
  {0x4010,0x1026,VR::DT,VM::VM1,"Route Segment End Time","RouteSegmentEndTime",false },
  {0x4010,0x1027,VR::CS,VM::VM1,"TDR Type","TDRType",false },
  {0x4010,0x1028,VR::CS,VM::VM1,"International Route Segment","InternationalRouteSegment",false },
  {0x4010,0x1029,VR::LO,VM::VM1_n,"Threat Detection Algorithm and Version","ThreatDetectionAlgorithmandVersion",false },
  {0x4010,0x102a,VR::SH,VM::VM1,"Assigned Location","AssignedLocation",false },
  {0x4010,0x102b,VR::DT,VM::VM1,"Alarm Decision Time","AlarmDecisionTime",false },
  {0x4010,0x1031,VR::CS,VM::VM1,"Alarm Decision","AlarmDecision",false },
  {0x4010,0x1033,VR::US,VM::VM1,"Number of Total Objects","NumberOfTotalObjects",false },
  {0x4010,0x1034,VR::US,VM::VM1,"Number of Alarm Objects","NumberOfAlarmObjects",false },
  {0x4010,0x1037,VR::SQ,VM::VM1,"PTO Representation Sequence","PTORepresentationSequence",false },
  {0x4010,0x1038,VR::SQ,VM::VM1,"ATD Assessment Sequence","ATDAssessmentSequence",false },
  {0x4010,0x1039,VR::CS,VM::VM1,"TIP Type","TIPType",false },
  {0x4010,0x103a,VR::CS,VM::VM1,"DICOS Version","DICOSVersion",false },
  {0x4010,0x1041,VR::DT,VM::VM1,"OOI Owner Creation Time","OOIOwnerCreationTime",false },
  {0x4010,0x1042,VR::CS,VM::VM1,"OOI Type","OOIType",false },
  {0x4010,0x1043,VR::FL,VM::VM3,"OOI Size","OOISize",false },
  {0x4010,0x1044,VR::CS,VM::VM1,"Acquisition Status","AcquisitionStatus",false },
  {0x4010,0x1045,VR::SQ,VM::VM1,"Basis Materials Code Sequence","BasisMaterialsCodeSequence",false },
  {0x4010,0x1046,VR::CS,VM::VM1,"Phantom Type","PhantomType",false },
  {0x4010,0x1047,VR::SQ,VM::VM1,"OOI Owner Sequence","OOIOwnerSequence",false },
  {0x4010,0x1048,VR::CS,VM::VM1,"Scan Type","ScanType",false },
  {0x4010,0x1051,VR::LO,VM::VM1,"Itinerary ID","ItineraryID",false },
  {0x4010,0x1052,VR::SH,VM::VM1,"Itinerary ID Type","ItineraryIDType",false },
  {0x4010,0x1053,VR::LO,VM::VM1,"Itinerary ID Assigning Authority","ItineraryIDAssigningAuthority",false },
  {0x4010,0x1054,VR::SH,VM::VM1,"Route ID","RouteID",false },
  {0x4010,0x1055,VR::SH,VM::VM1,"Route ID Assigning Authority","RouteIDAssigningAuthority",false },
  {0x4010,0x1056,VR::CS,VM::VM1,"Inbound Arrival Type","InboundArrivalType",false },
  {0x4010,0x1058,VR::SH,VM::VM1,"Carrier ID","CarrierID",false },
  {0x4010,0x1059,VR::CS,VM::VM1,"Carrier ID Assigning Authority","CarrierIDAssigningAuthority",false },
  {0x4010,0x1060,VR::FL,VM::VM3,"Source Orientation","SourceOrientation",false },
  {0x4010,0x1061,VR::FL,VM::VM3,"Source Position","SourcePosition",false },
  {0x4010,0x1062,VR::FL,VM::VM1,"Belt Height","BeltHeight",false },
  {0x4010,0x1064,VR::SQ,VM::VM1,"Algorithm Routing Code Sequence","AlgorithmRoutingCodeSequence",false },
  {0x4010,0x1067,VR::CS,VM::VM1,"Transport Classification","TransportClassification",false },
  {0x4010,0x1068,VR::LT,VM::VM1,"OOI Type Descriptor","OOITypeDescriptor",false },
  {0x4010,0x1069,VR::FL,VM::VM1,"Total Processing Time","TotalProcessingTime",false },
  {0x4010,0x106c,VR::OB,VM::VM1,"Detector Calibration Data","DetectorCalibrationData",false },
  {0x4ffe,0x0001,VR::SQ,VM::VM1,"MAC Parameters Sequence","MACParametersSequence",false },
  {0x5000,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5002,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5004,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5006,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5008,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x500a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x500c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x500e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5010,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5012,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5014,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5016,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5018,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x501a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x501c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x501e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5020,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5022,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5024,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5026,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5028,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x502a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x502c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x502e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5030,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5032,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5034,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5036,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5038,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x503a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x503c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x503e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5040,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5042,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5044,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5046,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5048,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x504a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x504c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x504e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5050,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5052,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5054,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5056,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5058,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x505a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x505c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x505e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5060,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5062,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5064,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5066,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5068,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x506a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x506c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x506e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5070,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5072,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5074,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5076,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5078,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x507a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x507c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x507e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5080,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5082,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5084,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5086,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5088,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x508a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x508c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x508e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5090,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5092,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5094,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5096,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5098,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x509a,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x509c,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x509e,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50a0,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50a2,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50a4,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50a6,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50a8,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50aa,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50ac,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50ae,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50b0,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50b2,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50b4,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50b6,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50b8,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50ba,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50bc,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50be,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50c0,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50c2,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50c4,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50c6,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50c8,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50ca,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50cc,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50ce,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50d0,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50d2,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50d4,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50d6,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50d8,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50da,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50dc,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50de,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50e0,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50e2,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50e4,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50e6,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50e8,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50ea,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50ec,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50ee,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50f0,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50f2,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50f4,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50f6,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50f8,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50fa,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50fc,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x50fe,0x0005,VR::US,VM::VM1,"Curve Dimensions","CurveDimensions",true },
  {0x5000,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5002,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5004,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5006,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5008,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x500a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x500c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x500e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5010,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5012,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5014,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5016,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5018,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x501a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x501c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x501e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5020,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5022,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5024,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5026,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5028,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x502a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x502c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x502e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5030,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5032,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5034,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5036,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5038,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x503a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x503c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x503e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5040,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5042,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5044,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5046,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5048,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x504a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x504c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x504e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5050,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5052,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5054,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5056,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5058,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x505a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x505c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x505e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5060,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5062,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5064,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5066,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5068,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x506a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x506c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x506e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5070,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5072,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5074,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5076,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5078,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x507a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x507c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x507e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5080,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5082,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5084,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5086,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5088,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x508a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x508c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x508e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5090,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5092,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5094,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5096,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5098,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x509a,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x509c,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x509e,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50a0,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50a2,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50a4,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50a6,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50a8,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50aa,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50ac,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50ae,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50b0,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50b2,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50b4,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50b6,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50b8,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50ba,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50bc,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50be,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50c0,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50c2,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50c4,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50c6,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50c8,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50ca,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50cc,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50ce,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50d0,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50d2,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50d4,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50d6,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50d8,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50da,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50dc,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50de,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50e0,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50e2,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50e4,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50e6,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50e8,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50ea,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50ec,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50ee,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50f0,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50f2,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50f4,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50f6,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50f8,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50fa,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50fc,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x50fe,0x0010,VR::US,VM::VM1,"Number of Points","NumberOfPoints",true },
  {0x5000,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5002,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5004,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5006,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5008,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x500a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x500c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x500e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5010,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5012,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5014,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5016,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5018,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x501a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x501c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x501e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5020,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5022,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5024,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5026,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5028,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x502a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x502c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x502e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5030,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5032,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5034,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5036,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5038,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x503a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x503c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x503e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5040,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5042,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5044,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5046,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5048,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x504a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x504c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x504e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5050,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5052,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5054,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5056,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5058,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x505a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x505c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x505e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5060,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5062,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5064,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5066,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5068,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x506a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x506c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x506e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5070,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5072,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5074,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5076,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5078,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x507a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x507c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x507e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5080,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5082,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5084,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5086,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5088,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x508a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x508c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x508e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5090,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5092,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5094,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5096,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5098,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x509a,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x509c,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x509e,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50a0,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50a2,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50a4,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50a6,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50a8,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50aa,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50ac,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50ae,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50b0,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50b2,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50b4,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50b6,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50b8,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50ba,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50bc,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50be,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50c0,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50c2,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50c4,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50c6,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50c8,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50ca,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50cc,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50ce,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50d0,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50d2,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50d4,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50d6,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50d8,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50da,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50dc,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50de,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50e0,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50e2,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50e4,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50e6,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50e8,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50ea,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50ec,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50ee,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50f0,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50f2,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50f4,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50f6,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50f8,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50fa,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50fc,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x50fe,0x0020,VR::CS,VM::VM1,"Type of Data","TypeOfData",true },
  {0x5000,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5002,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5004,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5006,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5008,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x500a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x500c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x500e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5010,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5012,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5014,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5016,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5018,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x501a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x501c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x501e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5020,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5022,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5024,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5026,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5028,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x502a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x502c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x502e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5030,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5032,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5034,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5036,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5038,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x503a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x503c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x503e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5040,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5042,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5044,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5046,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5048,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x504a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x504c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x504e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5050,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5052,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5054,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5056,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5058,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x505a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x505c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x505e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5060,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5062,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5064,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5066,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5068,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x506a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x506c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x506e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5070,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5072,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5074,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5076,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5078,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x507a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x507c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x507e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5080,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5082,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5084,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5086,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5088,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x508a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x508c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x508e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5090,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5092,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5094,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5096,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5098,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x509a,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x509c,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x509e,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50a0,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50a2,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50a4,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50a6,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50a8,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50aa,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50ac,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50ae,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50b0,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50b2,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50b4,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50b6,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50b8,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50ba,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50bc,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50be,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50c0,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50c2,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50c4,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50c6,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50c8,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50ca,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50cc,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50ce,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50d0,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50d2,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50d4,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50d6,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50d8,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50da,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50dc,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50de,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50e0,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50e2,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50e4,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50e6,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50e8,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50ea,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50ec,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50ee,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50f0,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50f2,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50f4,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50f6,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50f8,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50fa,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50fc,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x50fe,0x0022,VR::LO,VM::VM1,"Curve Description","CurveDescription",true },
  {0x5000,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5002,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5004,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5006,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5008,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x500a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x500c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x500e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5010,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5012,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5014,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5016,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5018,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x501a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x501c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x501e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5020,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5022,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5024,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5026,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5028,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x502a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x502c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x502e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5030,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5032,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5034,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5036,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5038,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x503a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x503c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x503e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5040,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5042,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5044,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5046,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5048,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x504a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x504c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x504e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5050,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5052,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5054,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5056,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5058,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x505a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x505c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x505e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5060,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5062,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5064,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5066,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5068,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x506a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x506c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x506e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5070,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5072,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5074,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5076,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5078,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x507a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x507c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x507e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5080,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5082,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5084,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5086,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5088,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x508a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x508c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x508e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5090,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5092,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5094,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5096,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5098,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x509a,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x509c,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x509e,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50a0,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50a2,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50a4,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50a6,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50a8,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50aa,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50ac,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50ae,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50b0,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50b2,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50b4,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50b6,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50b8,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50ba,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50bc,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50be,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50c0,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50c2,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50c4,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50c6,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50c8,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50ca,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50cc,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50ce,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50d0,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50d2,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50d4,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50d6,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50d8,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50da,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50dc,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50de,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50e0,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50e2,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50e4,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50e6,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50e8,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50ea,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50ec,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50ee,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50f0,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50f2,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50f4,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50f6,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50f8,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50fa,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50fc,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x50fe,0x0030,VR::SH,VM::VM1_n,"Axis Units","AxisUnits",true },
  {0x5000,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5002,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5004,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5006,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5008,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x500a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x500c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x500e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5010,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5012,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5014,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5016,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5018,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x501a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x501c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x501e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5020,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5022,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5024,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5026,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5028,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x502a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x502c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x502e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5030,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5032,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5034,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5036,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5038,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x503a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x503c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x503e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5040,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5042,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5044,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5046,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5048,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x504a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x504c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x504e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5050,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5052,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5054,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5056,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5058,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x505a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x505c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x505e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5060,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5062,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5064,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5066,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5068,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x506a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x506c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x506e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5070,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5072,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5074,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5076,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5078,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x507a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x507c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x507e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5080,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5082,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5084,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5086,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5088,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x508a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x508c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x508e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5090,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5092,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5094,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5096,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5098,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x509a,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x509c,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x509e,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50a0,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50a2,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50a4,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50a6,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50a8,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50aa,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50ac,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50ae,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50b0,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50b2,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50b4,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50b6,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50b8,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50ba,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50bc,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50be,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50c0,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50c2,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50c4,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50c6,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50c8,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50ca,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50cc,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50ce,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50d0,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50d2,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50d4,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50d6,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50d8,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50da,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50dc,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50de,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50e0,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50e2,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50e4,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50e6,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50e8,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50ea,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50ec,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50ee,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50f0,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50f2,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50f4,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50f6,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50f8,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50fa,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50fc,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x50fe,0x0040,VR::SH,VM::VM1_n,"Axis Labels","AxisLabels",true },
  {0x5000,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5002,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5004,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5006,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5008,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x500a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x500c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x500e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5010,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5012,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5014,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5016,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5018,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x501a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x501c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x501e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5020,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5022,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5024,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5026,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5028,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x502a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x502c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x502e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5030,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5032,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5034,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5036,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5038,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x503a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x503c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x503e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5040,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5042,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5044,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5046,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5048,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x504a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x504c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x504e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5050,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5052,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5054,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5056,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5058,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x505a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x505c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x505e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5060,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5062,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5064,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5066,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5068,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x506a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x506c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x506e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5070,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5072,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5074,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5076,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5078,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x507a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x507c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x507e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5080,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5082,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5084,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5086,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5088,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x508a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x508c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x508e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5090,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5092,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5094,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5096,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5098,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x509a,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x509c,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x509e,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50a0,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50a2,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50a4,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50a6,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50a8,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50aa,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50ac,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50ae,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50b0,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50b2,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50b4,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50b6,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50b8,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50ba,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50bc,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50be,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50c0,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50c2,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50c4,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50c6,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50c8,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50ca,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50cc,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50ce,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50d0,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50d2,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50d4,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50d6,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50d8,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50da,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50dc,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50de,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50e0,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50e2,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50e4,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50e6,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50e8,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50ea,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50ec,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50ee,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50f0,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50f2,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50f4,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50f6,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50f8,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50fa,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50fc,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x50fe,0x0103,VR::US,VM::VM1,"Data Value Representation","DataValueRepresentation",true },
  {0x5000,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5002,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5004,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5006,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5008,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x500a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x500c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x500e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5010,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5012,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5014,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5016,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5018,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x501a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x501c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x501e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5020,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5022,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5024,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5026,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5028,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x502a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x502c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x502e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5030,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5032,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5034,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5036,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5038,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x503a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x503c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x503e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5040,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5042,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5044,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5046,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5048,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x504a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x504c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x504e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5050,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5052,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5054,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5056,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5058,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x505a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x505c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x505e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5060,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5062,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5064,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5066,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5068,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x506a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x506c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x506e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5070,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5072,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5074,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5076,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5078,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x507a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x507c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x507e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5080,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5082,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5084,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5086,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5088,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x508a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x508c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x508e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5090,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5092,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5094,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5096,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5098,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x509a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x509c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x509e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50a0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50a2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50a4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50a6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50a8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50aa,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50ac,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50ae,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50b0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50b2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50b4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50b6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50b8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50ba,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50bc,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50be,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50c0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50c2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50c4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50c6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50c8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50ca,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50cc,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50ce,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50d0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50d2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50d4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50d6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50d8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50da,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50dc,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50de,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50e0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50e2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50e4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50e6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50e8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50ea,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50ec,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50ee,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50f0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50f2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50f4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50f6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50f8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50fa,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50fc,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x50fe,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value","MinimumCoordinateValue",true },
  {0x5000,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5002,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5004,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5006,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5008,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x500a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x500c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x500e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5010,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5012,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5014,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5016,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5018,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x501a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x501c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x501e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5020,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5022,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5024,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5026,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5028,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x502a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x502c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x502e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5030,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5032,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5034,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5036,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5038,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x503a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x503c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x503e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5040,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5042,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5044,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5046,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5048,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x504a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x504c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x504e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5050,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5052,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5054,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5056,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5058,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x505a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x505c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x505e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5060,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5062,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5064,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5066,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5068,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x506a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x506c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x506e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5070,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5072,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5074,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5076,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5078,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x507a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x507c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x507e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5080,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5082,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5084,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5086,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5088,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x508a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x508c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x508e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5090,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5092,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5094,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5096,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5098,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x509a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x509c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x509e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50a0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50a2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50a4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50a6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50a8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50aa,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50ac,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50ae,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50b0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50b2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50b4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50b6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50b8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50ba,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50bc,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50be,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50c0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50c2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50c4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50c6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50c8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50ca,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50cc,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50ce,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50d0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50d2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50d4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50d6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50d8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50da,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50dc,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50de,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50e0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50e2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50e4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50e6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50e8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50ea,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50ec,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50ee,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50f0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50f2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50f4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50f6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50f8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50fa,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50fc,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x50fe,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value","MaximumCoordinateValue",true },
  {0x5000,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5002,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5004,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5006,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5008,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x500a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x500c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x500e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5010,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5012,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5014,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5016,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5018,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x501a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x501c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x501e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5020,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5022,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5024,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5026,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5028,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x502a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x502c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x502e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5030,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5032,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5034,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5036,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5038,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x503a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x503c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x503e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5040,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5042,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5044,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5046,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5048,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x504a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x504c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x504e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5050,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5052,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5054,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5056,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5058,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x505a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x505c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x505e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5060,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5062,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5064,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5066,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5068,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x506a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x506c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x506e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5070,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5072,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5074,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5076,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5078,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x507a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x507c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x507e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5080,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5082,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5084,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5086,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5088,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x508a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x508c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x508e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5090,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5092,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5094,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5096,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5098,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x509a,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x509c,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x509e,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50a0,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50a2,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50a4,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50a6,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50a8,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50aa,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50ac,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50ae,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50b0,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50b2,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50b4,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50b6,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50b8,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50ba,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50bc,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50be,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50c0,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50c2,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50c4,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50c6,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50c8,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50ca,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50cc,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50ce,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50d0,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50d2,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50d4,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50d6,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50d8,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50da,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50dc,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50de,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50e0,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50e2,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50e4,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50e6,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50e8,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50ea,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50ec,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50ee,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50f0,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50f2,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50f4,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50f6,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50f8,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50fa,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50fc,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x50fe,0x0106,VR::SH,VM::VM1_n,"Curve Range","CurveRange",true },
  {0x5000,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5002,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5004,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5006,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5008,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x500a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x500c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x500e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5010,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5012,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5014,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5016,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5018,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x501a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x501c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x501e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5020,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5022,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5024,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5026,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5028,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x502a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x502c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x502e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5030,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5032,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5034,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5036,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5038,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x503a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x503c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x503e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5040,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5042,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5044,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5046,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5048,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x504a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x504c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x504e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5050,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5052,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5054,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5056,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5058,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x505a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x505c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x505e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5060,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5062,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5064,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5066,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5068,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x506a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x506c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x506e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5070,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5072,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5074,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5076,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5078,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x507a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x507c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x507e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5080,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5082,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5084,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5086,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5088,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x508a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x508c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x508e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5090,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5092,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5094,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5096,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5098,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x509a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x509c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x509e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50a0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50a2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50a4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50a6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50a8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50aa,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50ac,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50ae,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50b0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50b2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50b4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50b6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50b8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50ba,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50bc,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50be,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50c0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50c2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50c4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50c6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50c8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50ca,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50cc,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50ce,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50d0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50d2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50d4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50d6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50d8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50da,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50dc,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50de,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50e0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50e2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50e4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50e6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50e8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50ea,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50ec,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50ee,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50f0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50f2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50f4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50f6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50f8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50fa,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50fc,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x50fe,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor","CurveDataDescriptor",true },
  {0x5000,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5002,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5004,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5006,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5008,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x500a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x500c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x500e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5010,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5012,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5014,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5016,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5018,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x501a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x501c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x501e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5020,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5022,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5024,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5026,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5028,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x502a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x502c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x502e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5030,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5032,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5034,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5036,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5038,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x503a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x503c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x503e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5040,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5042,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5044,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5046,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5048,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x504a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x504c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x504e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5050,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5052,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5054,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5056,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5058,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x505a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x505c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x505e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5060,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5062,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5064,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5066,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5068,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x506a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x506c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x506e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5070,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5072,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5074,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5076,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5078,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x507a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x507c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x507e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5080,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5082,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5084,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5086,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5088,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x508a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x508c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x508e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5090,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5092,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5094,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5096,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5098,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x509a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x509c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x509e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50a0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50a2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50a4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50a6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50a8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50aa,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50ac,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50ae,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50b0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50b2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50b4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50b6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50b8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50ba,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50bc,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50be,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50c0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50c2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50c4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50c6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50c8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50ca,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50cc,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50ce,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50d0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50d2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50d4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50d6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50d8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50da,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50dc,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50de,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50e0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50e2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50e4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50e6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50e8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50ea,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50ec,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50ee,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50f0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50f2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50f4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50f6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50f8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50fa,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50fc,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x50fe,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value","CoordinateStartValue",true },
  {0x5000,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5002,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5004,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5006,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5008,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x500a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x500c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x500e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5010,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5012,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5014,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5016,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5018,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x501a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x501c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x501e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5020,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5022,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5024,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5026,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5028,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x502a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x502c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x502e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5030,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5032,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5034,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5036,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5038,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x503a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x503c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x503e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5040,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5042,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5044,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5046,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5048,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x504a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x504c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x504e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5050,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5052,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5054,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5056,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5058,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x505a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x505c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x505e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5060,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5062,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5064,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5066,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5068,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x506a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x506c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x506e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5070,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5072,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5074,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5076,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5078,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x507a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x507c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x507e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5080,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5082,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5084,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5086,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5088,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x508a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x508c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x508e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5090,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5092,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5094,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5096,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5098,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x509a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x509c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x509e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50a0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50a2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50a4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50a6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50a8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50aa,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50ac,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50ae,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50b0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50b2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50b4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50b6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50b8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50ba,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50bc,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50be,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50c0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50c2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50c4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50c6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50c8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50ca,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50cc,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50ce,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50d0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50d2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50d4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50d6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50d8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50da,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50dc,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50de,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50e0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50e2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50e4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50e6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50e8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50ea,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50ec,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50ee,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50f0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50f2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50f4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50f6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50f8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50fa,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50fc,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x50fe,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value","CoordinateStepValue",true },
  {0x5000,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5002,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5004,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5006,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5008,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x500a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x500c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x500e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5010,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5012,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5014,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5016,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5018,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x501a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x501c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x501e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5020,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5022,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5024,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5026,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5028,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x502a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x502c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x502e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5030,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5032,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5034,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5036,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5038,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x503a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x503c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x503e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5040,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5042,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5044,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5046,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5048,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x504a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x504c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x504e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5050,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5052,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5054,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5056,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5058,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x505a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x505c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x505e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5060,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5062,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5064,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5066,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5068,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x506a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x506c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x506e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5070,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5072,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5074,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5076,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5078,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x507a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x507c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x507e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5080,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5082,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5084,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5086,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5088,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x508a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x508c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x508e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5090,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5092,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5094,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5096,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5098,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x509a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x509c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x509e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50a0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50a2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50a4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50a6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50a8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50aa,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50ac,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50ae,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50b0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50b2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50b4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50b6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50b8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50ba,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50bc,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50be,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50c0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50c2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50c4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50c6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50c8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50ca,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50cc,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50ce,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50d0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50d2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50d4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50d6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50d8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50da,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50dc,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50de,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50e0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50e2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50e4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50e6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50e8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50ea,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50ec,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50ee,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50f0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50f2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50f4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50f6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50f8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50fa,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50fc,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x50fe,0x1001,VR::CS,VM::VM1,"Curve Activation Layer","CurveActivationLayer",true },
  {0x5000,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5002,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5004,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5006,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5008,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x500a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x500c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x500e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5010,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5012,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5014,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5016,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5018,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x501a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x501c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x501e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5020,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5022,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5024,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5026,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5028,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x502a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x502c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x502e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5030,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5032,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5034,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5036,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5038,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x503a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x503c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x503e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5040,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5042,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5044,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5046,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5048,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x504a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x504c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x504e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5050,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5052,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5054,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5056,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5058,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x505a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x505c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x505e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5060,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5062,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5064,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5066,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5068,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x506a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x506c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x506e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5070,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5072,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5074,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5076,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5078,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x507a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x507c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x507e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5080,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5082,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5084,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5086,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5088,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x508a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x508c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x508e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5090,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5092,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5094,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5096,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5098,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x509a,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x509c,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x509e,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50a0,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50a2,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50a4,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50a6,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50a8,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50aa,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50ac,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50ae,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50b0,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50b2,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50b4,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50b6,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50b8,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50ba,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50bc,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50be,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50c0,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50c2,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50c4,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50c6,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50c8,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50ca,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50cc,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50ce,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50d0,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50d2,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50d4,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50d6,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50d8,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50da,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50dc,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50de,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50e0,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50e2,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50e4,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50e6,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50e8,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50ea,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50ec,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50ee,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50f0,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50f2,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50f4,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50f6,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50f8,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50fa,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50fc,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x50fe,0x2000,VR::US,VM::VM1,"Audio Type","AudioType",true },
  {0x5000,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5002,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5004,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5006,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5008,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x500a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x500c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x500e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5010,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5012,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5014,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5016,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5018,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x501a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x501c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x501e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5020,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5022,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5024,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5026,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5028,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x502a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x502c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x502e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5030,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5032,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5034,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5036,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5038,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x503a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x503c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x503e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5040,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5042,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5044,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5046,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5048,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x504a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x504c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x504e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5050,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5052,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5054,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5056,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5058,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x505a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x505c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x505e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5060,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5062,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5064,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5066,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5068,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x506a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x506c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x506e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5070,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5072,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5074,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5076,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5078,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x507a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x507c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x507e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5080,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5082,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5084,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5086,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5088,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x508a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x508c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x508e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5090,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5092,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5094,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5096,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5098,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x509a,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x509c,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x509e,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50a0,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50a2,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50a4,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50a6,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50a8,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50aa,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50ac,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50ae,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50b0,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50b2,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50b4,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50b6,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50b8,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50ba,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50bc,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50be,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50c0,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50c2,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50c4,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50c6,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50c8,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50ca,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50cc,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50ce,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50d0,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50d2,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50d4,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50d6,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50d8,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50da,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50dc,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50de,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50e0,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50e2,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50e4,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50e6,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50e8,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50ea,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50ec,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50ee,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50f0,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50f2,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50f4,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50f6,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50f8,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50fa,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50fc,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x50fe,0x2002,VR::US,VM::VM1,"Audio Sample Format","AudioSampleFormat",true },
  {0x5000,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5002,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5004,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5006,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5008,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x500a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x500c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x500e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5010,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5012,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5014,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5016,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5018,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x501a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x501c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x501e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5020,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5022,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5024,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5026,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5028,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x502a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x502c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x502e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5030,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5032,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5034,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5036,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5038,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x503a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x503c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x503e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5040,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5042,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5044,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5046,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5048,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x504a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x504c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x504e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5050,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5052,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5054,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5056,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5058,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x505a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x505c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x505e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5060,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5062,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5064,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5066,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5068,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x506a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x506c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x506e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5070,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5072,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5074,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5076,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5078,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x507a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x507c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x507e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5080,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5082,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5084,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5086,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5088,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x508a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x508c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x508e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5090,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5092,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5094,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5096,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5098,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x509a,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x509c,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x509e,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50a0,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50a2,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50a4,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50a6,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50a8,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50aa,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50ac,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50ae,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50b0,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50b2,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50b4,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50b6,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50b8,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50ba,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50bc,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50be,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50c0,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50c2,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50c4,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50c6,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50c8,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50ca,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50cc,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50ce,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50d0,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50d2,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50d4,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50d6,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50d8,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50da,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50dc,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50de,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50e0,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50e2,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50e4,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50e6,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50e8,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50ea,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50ec,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50ee,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50f0,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50f2,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50f4,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50f6,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50f8,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50fa,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50fc,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x50fe,0x2004,VR::US,VM::VM1,"Number of Channels","NumberOfChannels",true },
  {0x5000,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5002,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5004,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5006,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5008,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x500a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x500c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x500e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5010,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5012,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5014,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5016,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5018,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x501a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x501c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x501e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5020,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5022,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5024,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5026,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5028,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x502a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x502c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x502e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5030,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5032,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5034,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5036,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5038,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x503a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x503c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x503e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5040,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5042,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5044,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5046,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5048,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x504a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x504c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x504e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5050,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5052,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5054,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5056,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5058,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x505a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x505c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x505e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5060,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5062,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5064,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5066,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5068,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x506a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x506c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x506e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5070,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5072,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5074,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5076,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5078,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x507a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x507c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x507e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5080,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5082,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5084,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5086,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5088,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x508a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x508c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x508e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5090,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5092,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5094,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5096,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5098,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x509a,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x509c,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x509e,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50a0,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50a2,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50a4,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50a6,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50a8,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50aa,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50ac,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50ae,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50b0,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50b2,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50b4,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50b6,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50b8,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50ba,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50bc,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50be,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50c0,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50c2,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50c4,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50c6,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50c8,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50ca,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50cc,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50ce,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50d0,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50d2,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50d4,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50d6,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50d8,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50da,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50dc,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50de,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50e0,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50e2,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50e4,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50e6,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50e8,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50ea,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50ec,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50ee,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50f0,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50f2,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50f4,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50f6,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50f8,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50fa,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50fc,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x50fe,0x2006,VR::UL,VM::VM1,"Number of Samples","NumberOfSamples",true },
  {0x5000,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5002,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5004,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5006,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5008,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x500a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x500c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x500e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5010,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5012,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5014,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5016,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5018,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x501a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x501c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x501e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5020,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5022,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5024,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5026,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5028,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x502a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x502c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x502e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5030,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5032,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5034,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5036,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5038,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x503a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x503c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x503e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5040,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5042,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5044,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5046,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5048,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x504a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x504c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x504e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5050,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5052,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5054,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5056,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5058,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x505a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x505c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x505e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5060,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5062,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5064,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5066,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5068,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x506a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x506c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x506e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5070,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5072,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5074,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5076,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5078,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x507a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x507c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x507e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5080,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5082,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5084,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5086,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5088,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x508a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x508c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x508e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5090,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5092,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5094,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5096,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5098,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x509a,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x509c,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x509e,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50a0,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50a2,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50a4,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50a6,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50a8,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50aa,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50ac,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50ae,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50b0,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50b2,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50b4,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50b6,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50b8,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50ba,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50bc,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50be,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50c0,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50c2,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50c4,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50c6,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50c8,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50ca,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50cc,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50ce,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50d0,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50d2,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50d4,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50d6,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50d8,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50da,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50dc,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50de,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50e0,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50e2,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50e4,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50e6,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50e8,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50ea,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50ec,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50ee,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50f0,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50f2,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50f4,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50f6,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50f8,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50fa,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50fc,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x50fe,0x2008,VR::UL,VM::VM1,"Sample Rate","SampleRate",true },
  {0x5000,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5002,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5004,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5006,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5008,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x500a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x500c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x500e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5010,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5012,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5014,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5016,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5018,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x501a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x501c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x501e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5020,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5022,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5024,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5026,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5028,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x502a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x502c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x502e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5030,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5032,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5034,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5036,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5038,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x503a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x503c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x503e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5040,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5042,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5044,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5046,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5048,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x504a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x504c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x504e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5050,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5052,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5054,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5056,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5058,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x505a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x505c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x505e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5060,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5062,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5064,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5066,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5068,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x506a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x506c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x506e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5070,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5072,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5074,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5076,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5078,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x507a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x507c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x507e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5080,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5082,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5084,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5086,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5088,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x508a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x508c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x508e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5090,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5092,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5094,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5096,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5098,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x509a,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x509c,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x509e,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50a0,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50a2,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50a4,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50a6,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50a8,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50aa,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50ac,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50ae,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50b0,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50b2,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50b4,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50b6,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50b8,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50ba,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50bc,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50be,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50c0,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50c2,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50c4,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50c6,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50c8,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50ca,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50cc,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50ce,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50d0,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50d2,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50d4,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50d6,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50d8,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50da,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50dc,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50de,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50e0,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50e2,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50e4,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50e6,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50e8,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50ea,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50ec,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50ee,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50f0,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50f2,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50f4,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50f6,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50f8,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50fa,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50fc,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x50fe,0x200a,VR::UL,VM::VM1,"Total Time","TotalTime",true },
  {0x5000,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5002,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5004,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5006,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5008,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x500a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x500c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x500e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5010,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5012,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5014,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5016,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5018,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x501a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x501c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x501e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5020,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5022,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5024,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5026,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5028,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x502a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x502c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x502e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5030,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5032,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5034,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5036,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5038,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x503a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x503c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x503e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5040,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5042,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5044,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5046,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5048,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x504a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x504c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x504e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5050,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5052,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5054,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5056,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5058,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x505a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x505c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x505e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5060,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5062,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5064,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5066,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5068,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x506a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x506c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x506e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5070,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5072,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5074,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5076,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5078,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x507a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x507c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x507e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5080,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5082,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5084,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5086,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5088,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x508a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x508c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x508e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5090,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5092,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5094,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5096,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5098,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x509a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x509c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x509e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50a0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50a2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50a4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50a6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50a8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50aa,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50ac,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50ae,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50b0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50b2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50b4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50b6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50b8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50ba,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50bc,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50be,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50c0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50c2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50c4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50c6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50c8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50ca,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50cc,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50ce,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50d0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50d2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50d4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50d6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50d8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50da,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50dc,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50de,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50e0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50e2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50e4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50e6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50e8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50ea,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50ec,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50ee,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50f0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50f2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50f4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50f6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50f8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50fa,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50fc,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x50fe,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data","AudioSampleData",true },
  {0x5000,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5002,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5004,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5006,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5008,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x500a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x500c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x500e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5010,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5012,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5014,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5016,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5018,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x501a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x501c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x501e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5020,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5022,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5024,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5026,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5028,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x502a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x502c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x502e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5030,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5032,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5034,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5036,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5038,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x503a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x503c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x503e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5040,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5042,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5044,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5046,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5048,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x504a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x504c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x504e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5050,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5052,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5054,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5056,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5058,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x505a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x505c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x505e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5060,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5062,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5064,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5066,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5068,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x506a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x506c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x506e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5070,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5072,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5074,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5076,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5078,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x507a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x507c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x507e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5080,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5082,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5084,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5086,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5088,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x508a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x508c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x508e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5090,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5092,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5094,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5096,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5098,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x509a,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x509c,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x509e,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50a0,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50a2,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50a4,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50a6,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50a8,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50aa,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50ac,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50ae,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50b0,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50b2,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50b4,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50b6,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50b8,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50ba,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50bc,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50be,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50c0,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50c2,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50c4,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50c6,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50c8,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50ca,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50cc,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50ce,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50d0,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50d2,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50d4,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50d6,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50d8,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50da,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50dc,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50de,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50e0,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50e2,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50e4,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50e6,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50e8,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50ea,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50ec,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50ee,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50f0,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50f2,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50f4,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50f6,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50f8,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50fa,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50fc,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x50fe,0x200e,VR::LT,VM::VM1,"Audio Comments","AudioComments",true },
  {0x5000,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5002,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5004,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5006,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5008,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x500a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x500c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x500e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5010,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5012,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5014,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5016,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5018,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x501a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x501c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x501e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5020,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5022,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5024,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5026,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5028,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x502a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x502c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x502e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5030,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5032,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5034,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5036,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5038,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x503a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x503c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x503e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5040,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5042,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5044,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5046,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5048,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x504a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x504c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x504e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5050,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5052,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5054,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5056,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5058,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x505a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x505c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x505e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5060,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5062,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5064,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5066,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5068,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x506a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x506c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x506e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5070,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5072,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5074,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5076,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5078,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x507a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x507c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x507e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5080,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5082,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5084,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5086,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5088,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x508a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x508c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x508e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5090,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5092,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5094,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5096,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5098,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x509a,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x509c,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x509e,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50a0,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50a2,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50a4,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50a6,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50a8,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50aa,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50ac,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50ae,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50b0,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50b2,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50b4,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50b6,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50b8,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50ba,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50bc,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50be,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50c0,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50c2,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50c4,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50c6,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50c8,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50ca,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50cc,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50ce,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50d0,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50d2,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50d4,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50d6,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50d8,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50da,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50dc,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50de,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50e0,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50e2,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50e4,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50e6,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50e8,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50ea,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50ec,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50ee,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50f0,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50f2,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50f4,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50f6,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50f8,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50fa,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50fc,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x50fe,0x2500,VR::LO,VM::VM1,"Curve Label","CurveLabel",true },
  {0x5000,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5002,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5004,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5006,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5008,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x500a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x500c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x500e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5010,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5012,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5014,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5016,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5018,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x501a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x501c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x501e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5020,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5022,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5024,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5026,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5028,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x502a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x502c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x502e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5030,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5032,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5034,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5036,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5038,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x503a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x503c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x503e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5040,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5042,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5044,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5046,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5048,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x504a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x504c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x504e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5050,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5052,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5054,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5056,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5058,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x505a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x505c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x505e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5060,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5062,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5064,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5066,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5068,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x506a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x506c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x506e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5070,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5072,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5074,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5076,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5078,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x507a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x507c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x507e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5080,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5082,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5084,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5086,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5088,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x508a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x508c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x508e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5090,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5092,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5094,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5096,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5098,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x509a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x509c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x509e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50a0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50a2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50a4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50a6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50a8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50aa,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50ac,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50ae,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50b0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50b2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50b4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50b6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50b8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50ba,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50bc,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50be,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50c0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50c2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50c4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50c6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50c8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50ca,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50cc,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50ce,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50d0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50d2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50d4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50d6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50d8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50da,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50dc,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50de,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50e0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50e2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50e4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50e6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50e8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50ea,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50ec,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50ee,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50f0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50f2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50f4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50f6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50f8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50fa,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50fc,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x50fe,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence","CurveReferencedOverlaySequence",true },
  {0x5000,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5002,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5004,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5006,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5008,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x500a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x500c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x500e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5010,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5012,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5014,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5016,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5018,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x501a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x501c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x501e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5020,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5022,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5024,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5026,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5028,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x502a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x502c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x502e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5030,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5032,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5034,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5036,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5038,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x503a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x503c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x503e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5040,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5042,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5044,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5046,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5048,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x504a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x504c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x504e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5050,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5052,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5054,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5056,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5058,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x505a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x505c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x505e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5060,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5062,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5064,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5066,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5068,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x506a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x506c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x506e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5070,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5072,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5074,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5076,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5078,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x507a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x507c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x507e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5080,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5082,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5084,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5086,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5088,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x508a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x508c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x508e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5090,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5092,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5094,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5096,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5098,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x509a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x509c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x509e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50a0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50a2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50a4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50a6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50a8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50aa,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50ac,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50ae,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50b0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50b2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50b4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50b6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50b8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50ba,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50bc,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50be,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50c0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50c2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50c4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50c6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50c8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50ca,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50cc,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50ce,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50d0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50d2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50d4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50d6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50d8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50da,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50dc,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50de,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50e0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50e2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50e4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50e6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50e8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50ea,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50ec,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50ee,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50f0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50f2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50f4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50f6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50f8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50fa,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50fc,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x50fe,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group","CurveReferencedOverlayGroup",true },
  {0x5000,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5002,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5004,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5006,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5008,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x500a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x500c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x500e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5010,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5012,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5014,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5016,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5018,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x501a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x501c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x501e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5020,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5022,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5024,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5026,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5028,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x502a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x502c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x502e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5030,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5032,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5034,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5036,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5038,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x503a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x503c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x503e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5040,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5042,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5044,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5046,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5048,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x504a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x504c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x504e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5050,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5052,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5054,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5056,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5058,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x505a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x505c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x505e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5060,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5062,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5064,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5066,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5068,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x506a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x506c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x506e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5070,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5072,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5074,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5076,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5078,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x507a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x507c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x507e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5080,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5082,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5084,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5086,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5088,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x508a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x508c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x508e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5090,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5092,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5094,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5096,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5098,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x509a,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x509c,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x509e,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50a0,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50a2,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50a4,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50a6,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50a8,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50aa,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50ac,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50ae,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50b0,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50b2,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50b4,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50b6,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50b8,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50ba,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50bc,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50be,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50c0,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50c2,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50c4,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50c6,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50c8,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50ca,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50cc,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50ce,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50d0,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50d2,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50d4,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50d6,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50d8,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50da,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50dc,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50de,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50e0,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50e2,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50e4,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50e6,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50e8,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50ea,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50ec,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50ee,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50f0,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50f2,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50f4,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50f6,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50f8,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50fa,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50fc,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x50fe,0x3000,VR::OB_OW,VM::VM1,"Curve Data","CurveData",true },
  {0x5200,0x9229,VR::SQ,VM::VM1,"Shared Functional Groups Sequence","SharedFunctionalGroupsSequence",false },
  {0x5200,0x9230,VR::SQ,VM::VM1,"Per-frame Functional Groups Sequence","PerFrameFunctionalGroupsSequence",false },
  {0x5400,0x0100,VR::SQ,VM::VM1,"Waveform Sequence","WaveformSequence",false },
  {0x5400,0x0110,VR::OB_OW,VM::VM1,"Channel Minimum Value","ChannelMinimumValue",false },
  {0x5400,0x0112,VR::OB_OW,VM::VM1,"Channel Maximum Value","ChannelMaximumValue",false },
  {0x5400,0x1004,VR::US,VM::VM1,"Waveform Bits Allocated","WaveformBitsAllocated",false },
  {0x5400,0x1006,VR::CS,VM::VM1,"Waveform Sample Interpretation","WaveformSampleInterpretation",false },
  {0x5400,0x100a,VR::OB_OW,VM::VM1,"Waveform Padding Value","WaveformPaddingValue",false },
  {0x5400,0x1010,VR::OB_OW,VM::VM1,"Waveform Data","WaveformData",false },
  {0x5600,0x0010,VR::OF,VM::VM1,"First Order Phase Correction Angle","FirstOrderPhaseCorrectionAngle",false },
  {0x5600,0x0020,VR::OF,VM::VM1,"Spectroscopy Data","SpectroscopyData",false },
  {0x6000,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6002,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6004,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6006,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6008,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x600a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x600c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x600e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6010,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6012,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6014,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6016,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6018,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x601a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x601c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x601e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6020,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6022,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6024,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6026,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6028,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x602a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x602c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x602e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6030,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6032,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6034,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6036,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6038,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x603a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x603c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x603e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6040,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6042,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6044,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6046,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6048,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x604a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x604c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x604e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6050,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6052,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6054,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6056,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6058,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x605a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x605c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x605e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6060,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6062,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6064,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6066,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6068,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x606a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x606c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x606e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6070,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6072,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6074,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6076,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6078,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x607a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x607c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x607e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6080,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6082,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6084,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6086,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6088,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x608a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x608c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x608e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6090,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6092,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6094,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6096,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6098,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x609a,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x609c,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x609e,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60a0,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60a2,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60a4,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60a6,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60a8,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60aa,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60ac,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60ae,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60b0,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60b2,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60b4,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60b6,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60b8,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60ba,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60bc,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60be,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60c0,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60c2,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60c4,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60c6,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60c8,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60ca,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60cc,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60ce,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60d0,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60d2,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60d4,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60d6,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60d8,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60da,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60dc,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60de,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60e0,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60e2,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60e4,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60e6,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60e8,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60ea,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60ec,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60ee,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60f0,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60f2,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60f4,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60f6,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60f8,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60fa,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60fc,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x60fe,0x0010,VR::US,VM::VM1,"Overlay Rows","OverlayRows",false },
  {0x6000,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6002,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6004,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6006,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6008,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x600a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x600c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x600e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6010,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6012,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6014,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6016,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6018,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x601a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x601c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x601e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6020,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6022,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6024,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6026,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6028,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x602a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x602c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x602e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6030,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6032,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6034,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6036,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6038,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x603a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x603c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x603e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6040,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6042,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6044,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6046,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6048,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x604a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x604c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x604e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6050,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6052,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6054,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6056,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6058,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x605a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x605c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x605e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6060,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6062,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6064,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6066,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6068,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x606a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x606c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x606e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6070,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6072,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6074,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6076,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6078,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x607a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x607c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x607e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6080,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6082,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6084,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6086,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6088,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x608a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x608c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x608e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6090,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6092,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6094,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6096,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6098,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x609a,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x609c,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x609e,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60a0,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60a2,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60a4,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60a6,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60a8,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60aa,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60ac,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60ae,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60b0,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60b2,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60b4,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60b6,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60b8,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60ba,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60bc,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60be,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60c0,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60c2,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60c4,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60c6,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60c8,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60ca,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60cc,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60ce,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60d0,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60d2,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60d4,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60d6,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60d8,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60da,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60dc,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60de,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60e0,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60e2,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60e4,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60e6,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60e8,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60ea,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60ec,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60ee,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60f0,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60f2,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60f4,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60f6,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60f8,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60fa,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60fc,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x60fe,0x0011,VR::US,VM::VM1,"Overlay Columns","OverlayColumns",false },
  {0x6000,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6002,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6004,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6006,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6008,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x600a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x600c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x600e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6010,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6012,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6014,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6016,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6018,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x601a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x601c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x601e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6020,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6022,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6024,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6026,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6028,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x602a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x602c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x602e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6030,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6032,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6034,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6036,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6038,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x603a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x603c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x603e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6040,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6042,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6044,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6046,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6048,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x604a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x604c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x604e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6050,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6052,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6054,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6056,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6058,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x605a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x605c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x605e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6060,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6062,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6064,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6066,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6068,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x606a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x606c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x606e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6070,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6072,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6074,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6076,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6078,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x607a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x607c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x607e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6080,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6082,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6084,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6086,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6088,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x608a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x608c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x608e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6090,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6092,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6094,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6096,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6098,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x609a,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x609c,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x609e,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60a0,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60a2,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60a4,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60a6,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60a8,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60aa,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60ac,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60ae,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60b0,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60b2,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60b4,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60b6,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60b8,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60ba,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60bc,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60be,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60c0,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60c2,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60c4,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60c6,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60c8,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60ca,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60cc,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60ce,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60d0,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60d2,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60d4,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60d6,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60d8,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60da,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60dc,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60de,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60e0,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60e2,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60e4,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60e6,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60e8,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60ea,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60ec,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60ee,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60f0,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60f2,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60f4,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60f6,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60f8,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60fa,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60fc,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x60fe,0x0012,VR::US,VM::VM1,"Overlay Planes","OverlayPlanes",true },
  {0x6000,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6002,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6004,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6006,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6008,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x600a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x600c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x600e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6010,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6012,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6014,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6016,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6018,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x601a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x601c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x601e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6020,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6022,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6024,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6026,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6028,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x602a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x602c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x602e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6030,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6032,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6034,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6036,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6038,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x603a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x603c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x603e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6040,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6042,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6044,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6046,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6048,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x604a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x604c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x604e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6050,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6052,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6054,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6056,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6058,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x605a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x605c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x605e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6060,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6062,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6064,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6066,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6068,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x606a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x606c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x606e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6070,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6072,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6074,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6076,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6078,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x607a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x607c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x607e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6080,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6082,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6084,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6086,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6088,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x608a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x608c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x608e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6090,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6092,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6094,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6096,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6098,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x609a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x609c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x609e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60a0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60a2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60a4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60a6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60a8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60aa,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60ac,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60ae,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60b0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60b2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60b4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60b6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60b8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60ba,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60bc,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60be,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60c0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60c2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60c4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60c6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60c8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60ca,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60cc,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60ce,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60d0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60d2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60d4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60d6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60d8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60da,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60dc,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60de,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60e0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60e2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60e4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60e6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60e8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60ea,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60ec,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60ee,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60f0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60f2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60f4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60f6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60f8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60fa,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60fc,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x60fe,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay","NumberOfFramesInOverlay",false },
  {0x6000,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6002,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6004,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6006,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6008,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x600a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x600c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x600e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6010,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6012,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6014,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6016,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6018,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x601a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x601c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x601e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6020,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6022,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6024,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6026,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6028,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x602a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x602c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x602e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6030,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6032,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6034,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6036,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6038,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x603a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x603c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x603e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6040,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6042,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6044,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6046,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6048,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x604a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x604c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x604e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6050,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6052,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6054,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6056,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6058,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x605a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x605c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x605e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6060,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6062,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6064,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6066,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6068,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x606a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x606c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x606e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6070,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6072,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6074,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6076,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6078,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x607a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x607c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x607e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6080,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6082,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6084,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6086,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6088,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x608a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x608c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x608e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6090,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6092,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6094,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6096,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6098,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x609a,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x609c,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x609e,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60a0,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60a2,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60a4,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60a6,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60a8,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60aa,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60ac,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60ae,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60b0,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60b2,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60b4,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60b6,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60b8,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60ba,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60bc,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60be,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60c0,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60c2,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60c4,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60c6,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60c8,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60ca,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60cc,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60ce,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60d0,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60d2,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60d4,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60d6,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60d8,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60da,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60dc,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60de,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60e0,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60e2,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60e4,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60e6,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60e8,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60ea,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60ec,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60ee,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60f0,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60f2,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60f4,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60f6,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60f8,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60fa,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60fc,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x60fe,0x0022,VR::LO,VM::VM1,"Overlay Description","OverlayDescription",false },
  {0x6000,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6002,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6004,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6006,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6008,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x600a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x600c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x600e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6010,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6012,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6014,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6016,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6018,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x601a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x601c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x601e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6020,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6022,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6024,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6026,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6028,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x602a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x602c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x602e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6030,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6032,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6034,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6036,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6038,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x603a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x603c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x603e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6040,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6042,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6044,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6046,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6048,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x604a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x604c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x604e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6050,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6052,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6054,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6056,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6058,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x605a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x605c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x605e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6060,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6062,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6064,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6066,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6068,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x606a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x606c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x606e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6070,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6072,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6074,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6076,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6078,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x607a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x607c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x607e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6080,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6082,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6084,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6086,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6088,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x608a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x608c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x608e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6090,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6092,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6094,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6096,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6098,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x609a,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x609c,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x609e,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60a0,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60a2,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60a4,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60a6,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60a8,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60aa,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60ac,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60ae,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60b0,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60b2,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60b4,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60b6,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60b8,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60ba,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60bc,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60be,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60c0,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60c2,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60c4,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60c6,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60c8,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60ca,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60cc,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60ce,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60d0,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60d2,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60d4,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60d6,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60d8,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60da,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60dc,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60de,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60e0,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60e2,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60e4,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60e6,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60e8,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60ea,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60ec,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60ee,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60f0,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60f2,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60f4,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60f6,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60f8,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60fa,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60fc,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x60fe,0x0040,VR::CS,VM::VM1,"Overlay Type","OverlayType",false },
  {0x6000,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6002,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6004,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6006,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6008,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x600a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x600c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x600e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6010,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6012,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6014,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6016,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6018,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x601a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x601c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x601e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6020,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6022,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6024,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6026,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6028,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x602a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x602c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x602e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6030,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6032,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6034,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6036,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6038,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x603a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x603c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x603e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6040,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6042,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6044,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6046,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6048,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x604a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x604c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x604e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6050,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6052,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6054,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6056,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6058,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x605a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x605c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x605e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6060,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6062,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6064,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6066,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6068,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x606a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x606c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x606e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6070,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6072,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6074,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6076,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6078,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x607a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x607c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x607e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6080,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6082,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6084,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6086,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6088,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x608a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x608c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x608e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6090,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6092,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6094,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6096,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6098,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x609a,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x609c,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x609e,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60a0,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60a2,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60a4,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60a6,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60a8,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60aa,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60ac,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60ae,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60b0,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60b2,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60b4,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60b6,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60b8,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60ba,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60bc,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60be,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60c0,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60c2,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60c4,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60c6,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60c8,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60ca,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60cc,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60ce,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60d0,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60d2,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60d4,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60d6,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60d8,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60da,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60dc,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60de,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60e0,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60e2,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60e4,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60e6,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60e8,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60ea,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60ec,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60ee,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60f0,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60f2,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60f4,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60f6,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60f8,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60fa,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60fc,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x60fe,0x0045,VR::LO,VM::VM1,"Overlay Subtype","OverlaySubtype",false },
  {0x6000,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6002,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6004,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6006,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6008,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x600a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x600c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x600e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6010,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6012,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6014,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6016,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6018,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x601a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x601c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x601e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6020,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6022,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6024,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6026,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6028,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x602a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x602c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x602e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6030,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6032,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6034,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6036,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6038,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x603a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x603c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x603e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6040,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6042,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6044,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6046,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6048,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x604a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x604c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x604e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6050,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6052,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6054,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6056,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6058,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x605a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x605c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x605e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6060,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6062,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6064,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6066,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6068,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x606a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x606c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x606e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6070,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6072,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6074,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6076,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6078,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x607a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x607c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x607e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6080,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6082,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6084,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6086,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6088,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x608a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x608c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x608e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6090,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6092,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6094,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6096,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6098,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x609a,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x609c,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x609e,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60a0,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60a2,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60a4,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60a6,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60a8,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60aa,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60ac,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60ae,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60b0,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60b2,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60b4,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60b6,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60b8,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60ba,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60bc,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60be,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60c0,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60c2,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60c4,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60c6,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60c8,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60ca,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60cc,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60ce,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60d0,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60d2,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60d4,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60d6,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60d8,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60da,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60dc,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60de,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60e0,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60e2,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60e4,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60e6,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60e8,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60ea,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60ec,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60ee,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60f0,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60f2,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60f4,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60f6,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60f8,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60fa,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60fc,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x60fe,0x0050,VR::SS,VM::VM2,"Overlay Origin","OverlayOrigin",false },
  {0x6000,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6002,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6004,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6006,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6008,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x600a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x600c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x600e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6010,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6012,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6014,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6016,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6018,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x601a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x601c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x601e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6020,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6022,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6024,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6026,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6028,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x602a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x602c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x602e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6030,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6032,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6034,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6036,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6038,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x603a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x603c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x603e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6040,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6042,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6044,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6046,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6048,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x604a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x604c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x604e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6050,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6052,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6054,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6056,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6058,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x605a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x605c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x605e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6060,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6062,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6064,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6066,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6068,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x606a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x606c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x606e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6070,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6072,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6074,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6076,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6078,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x607a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x607c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x607e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6080,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6082,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6084,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6086,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6088,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x608a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x608c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x608e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6090,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6092,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6094,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6096,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6098,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x609a,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x609c,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x609e,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60a0,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60a2,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60a4,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60a6,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60a8,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60aa,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60ac,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60ae,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60b0,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60b2,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60b4,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60b6,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60b8,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60ba,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60bc,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60be,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60c0,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60c2,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60c4,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60c6,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60c8,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60ca,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60cc,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60ce,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60d0,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60d2,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60d4,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60d6,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60d8,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60da,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60dc,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60de,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60e0,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60e2,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60e4,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60e6,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60e8,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60ea,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60ec,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60ee,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60f0,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60f2,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60f4,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60f6,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60f8,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60fa,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60fc,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x60fe,0x0051,VR::US,VM::VM1,"Image Frame Origin","ImageFrameOrigin",false },
  {0x6000,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6002,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6004,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6006,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6008,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x600a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x600c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x600e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6010,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6012,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6014,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6016,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6018,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x601a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x601c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x601e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6020,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6022,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6024,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6026,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6028,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x602a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x602c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x602e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6030,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6032,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6034,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6036,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6038,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x603a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x603c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x603e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6040,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6042,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6044,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6046,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6048,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x604a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x604c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x604e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6050,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6052,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6054,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6056,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6058,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x605a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x605c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x605e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6060,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6062,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6064,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6066,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6068,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x606a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x606c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x606e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6070,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6072,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6074,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6076,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6078,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x607a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x607c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x607e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6080,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6082,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6084,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6086,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6088,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x608a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x608c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x608e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6090,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6092,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6094,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6096,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6098,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x609a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x609c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x609e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60a0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60a2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60a4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60a6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60a8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60aa,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60ac,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60ae,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60b0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60b2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60b4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60b6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60b8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60ba,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60bc,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60be,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60c0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60c2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60c4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60c6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60c8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60ca,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60cc,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60ce,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60d0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60d2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60d4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60d6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60d8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60da,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60dc,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60de,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60e0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60e2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60e4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60e6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60e8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60ea,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60ec,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60ee,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60f0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60f2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60f4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60f6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60f8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60fa,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60fc,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x60fe,0x0052,VR::US,VM::VM1,"Overlay Plane Origin","OverlayPlaneOrigin",true },
  {0x6000,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6002,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6004,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6006,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6008,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x600a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x600c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x600e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6010,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6012,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6014,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6016,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6018,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x601a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x601c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x601e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6020,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6022,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6024,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6026,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6028,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x602a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x602c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x602e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6030,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6032,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6034,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6036,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6038,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x603a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x603c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x603e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6040,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6042,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6044,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6046,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6048,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x604a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x604c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x604e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6050,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6052,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6054,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6056,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6058,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x605a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x605c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x605e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6060,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6062,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6064,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6066,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6068,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x606a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x606c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x606e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6070,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6072,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6074,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6076,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6078,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x607a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x607c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x607e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6080,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6082,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6084,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6086,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6088,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x608a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x608c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x608e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6090,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6092,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6094,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6096,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6098,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x609a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x609c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x609e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60a0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60a2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60a4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60a6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60a8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60aa,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60ac,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60ae,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60b0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60b2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60b4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60b6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60b8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60ba,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60bc,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60be,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60c0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60c2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60c4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60c6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60c8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60ca,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60cc,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60ce,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60d0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60d2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60d4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60d6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60d8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60da,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60dc,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60de,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60e0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60e2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60e4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60e6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60e8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60ea,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60ec,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60ee,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60f0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60f2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60f4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60f6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60f8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60fa,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60fc,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x60fe,0x0060,VR::CS,VM::VM1,"Overlay Compression Code","OverlayCompressionCode",true },
  {0x6000,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6002,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6004,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6006,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6008,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x600a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x600c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x600e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6010,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6012,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6014,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6016,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6018,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x601a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x601c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x601e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6020,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6022,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6024,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6026,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6028,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x602a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x602c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x602e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6030,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6032,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6034,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6036,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6038,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x603a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x603c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x603e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6040,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6042,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6044,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6046,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6048,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x604a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x604c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x604e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6050,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6052,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6054,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6056,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6058,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x605a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x605c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x605e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6060,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6062,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6064,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6066,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6068,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x606a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x606c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x606e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6070,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6072,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6074,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6076,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6078,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x607a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x607c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x607e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6080,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6082,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6084,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6086,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6088,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x608a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x608c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x608e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6090,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6092,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6094,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6096,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6098,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x609a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x609c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x609e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60a0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60a2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60a4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60a6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60a8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60aa,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60ac,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60ae,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60b0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60b2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60b4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60b6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60b8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60ba,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60bc,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60be,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60c0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60c2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60c4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60c6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60c8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60ca,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60cc,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60ce,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60d0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60d2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60d4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60d6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60d8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60da,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60dc,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60de,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60e0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60e2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60e4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60e6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60e8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60ea,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60ec,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60ee,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60f0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60f2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60f4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60f6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60f8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60fa,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60fc,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x60fe,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator","OverlayCompressionOriginator",true },
  {0x6000,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6002,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6004,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6006,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6008,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x600a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x600c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x600e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6010,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6012,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6014,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6016,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6018,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x601a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x601c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x601e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6020,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6022,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6024,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6026,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6028,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x602a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x602c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x602e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6030,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6032,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6034,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6036,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6038,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x603a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x603c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x603e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6040,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6042,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6044,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6046,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6048,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x604a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x604c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x604e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6050,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6052,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6054,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6056,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6058,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x605a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x605c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x605e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6060,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6062,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6064,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6066,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6068,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x606a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x606c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x606e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6070,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6072,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6074,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6076,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6078,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x607a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x607c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x607e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6080,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6082,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6084,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6086,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6088,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x608a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x608c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x608e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6090,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6092,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6094,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6096,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6098,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x609a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x609c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x609e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60a0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60a2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60a4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60a6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60a8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60aa,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60ac,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60ae,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60b0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60b2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60b4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60b6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60b8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60ba,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60bc,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60be,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60c0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60c2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60c4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60c6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60c8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60ca,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60cc,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60ce,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60d0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60d2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60d4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60d6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60d8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60da,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60dc,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60de,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60e0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60e2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60e4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60e6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60e8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60ea,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60ec,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60ee,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60f0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60f2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60f4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60f6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60f8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60fa,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60fc,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x60fe,0x0062,VR::SH,VM::VM1,"Overlay Compression Label","OverlayCompressionLabel",true },
  {0x6000,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6002,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6004,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6006,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6008,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x600a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x600c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x600e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6010,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6012,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6014,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6016,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6018,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x601a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x601c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x601e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6020,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6022,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6024,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6026,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6028,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x602a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x602c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x602e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6030,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6032,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6034,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6036,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6038,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x603a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x603c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x603e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6040,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6042,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6044,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6046,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6048,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x604a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x604c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x604e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6050,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6052,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6054,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6056,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6058,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x605a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x605c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x605e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6060,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6062,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6064,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6066,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6068,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x606a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x606c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x606e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6070,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6072,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6074,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6076,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6078,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x607a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x607c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x607e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6080,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6082,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6084,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6086,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6088,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x608a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x608c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x608e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6090,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6092,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6094,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6096,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6098,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x609a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x609c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x609e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60a0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60a2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60a4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60a6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60a8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60aa,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60ac,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60ae,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60b0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60b2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60b4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60b6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60b8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60ba,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60bc,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60be,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60c0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60c2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60c4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60c6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60c8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60ca,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60cc,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60ce,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60d0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60d2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60d4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60d6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60d8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60da,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60dc,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60de,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60e0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60e2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60e4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60e6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60e8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60ea,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60ec,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60ee,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60f0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60f2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60f4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60f6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60f8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60fa,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60fc,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x60fe,0x0063,VR::CS,VM::VM1,"Overlay Compression Description","OverlayCompressionDescription",true },
  {0x6000,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6002,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6004,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6006,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6008,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x600a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x600c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x600e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6010,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6012,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6014,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6016,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6018,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x601a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x601c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x601e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6020,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6022,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6024,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6026,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6028,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x602a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x602c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x602e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6030,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6032,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6034,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6036,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6038,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x603a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x603c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x603e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6040,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6042,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6044,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6046,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6048,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x604a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x604c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x604e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6050,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6052,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6054,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6056,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6058,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x605a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x605c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x605e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6060,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6062,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6064,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6066,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6068,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x606a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x606c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x606e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6070,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6072,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6074,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6076,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6078,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x607a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x607c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x607e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6080,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6082,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6084,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6086,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6088,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x608a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x608c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x608e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6090,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6092,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6094,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6096,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6098,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x609a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x609c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x609e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60a0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60a2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60a4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60a6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60a8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60aa,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60ac,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60ae,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60b0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60b2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60b4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60b6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60b8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60ba,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60bc,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60be,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60c0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60c2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60c4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60c6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60c8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60ca,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60cc,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60ce,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60d0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60d2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60d4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60d6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60d8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60da,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60dc,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60de,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60e0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60e2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60e4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60e6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60e8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60ea,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60ec,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60ee,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60f0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60f2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60f4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60f6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60f8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60fa,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60fc,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x60fe,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers","OverlayCompressionStepPointers",true },
  {0x6000,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6002,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6004,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6006,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6008,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x600a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x600c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x600e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6010,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6012,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6014,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6016,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6018,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x601a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x601c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x601e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6020,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6022,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6024,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6026,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6028,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x602a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x602c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x602e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6030,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6032,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6034,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6036,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6038,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x603a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x603c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x603e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6040,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6042,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6044,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6046,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6048,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x604a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x604c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x604e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6050,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6052,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6054,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6056,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6058,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x605a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x605c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x605e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6060,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6062,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6064,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6066,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6068,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x606a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x606c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x606e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6070,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6072,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6074,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6076,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6078,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x607a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x607c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x607e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6080,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6082,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6084,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6086,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6088,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x608a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x608c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x608e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6090,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6092,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6094,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6096,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6098,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x609a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x609c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x609e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60a0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60a2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60a4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60a6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60a8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60aa,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60ac,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60ae,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60b0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60b2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60b4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60b6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60b8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60ba,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60bc,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60be,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60c0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60c2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60c4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60c6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60c8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60ca,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60cc,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60ce,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60d0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60d2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60d4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60d6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60d8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60da,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60dc,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60de,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60e0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60e2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60e4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60e6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60e8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60ea,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60ec,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60ee,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60f0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60f2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60f4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60f6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60f8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60fa,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60fc,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x60fe,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval","OverlayRepeatInterval",true },
  {0x6000,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6002,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6004,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6006,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6008,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x600a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x600c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x600e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6010,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6012,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6014,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6016,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6018,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x601a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x601c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x601e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6020,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6022,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6024,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6026,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6028,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x602a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x602c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x602e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6030,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6032,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6034,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6036,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6038,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x603a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x603c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x603e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6040,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6042,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6044,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6046,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6048,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x604a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x604c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x604e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6050,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6052,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6054,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6056,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6058,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x605a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x605c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x605e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6060,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6062,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6064,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6066,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6068,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x606a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x606c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x606e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6070,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6072,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6074,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6076,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6078,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x607a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x607c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x607e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6080,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6082,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6084,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6086,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6088,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x608a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x608c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x608e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6090,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6092,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6094,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6096,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6098,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x609a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x609c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x609e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60a0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60a2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60a4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60a6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60a8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60aa,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60ac,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60ae,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60b0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60b2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60b4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60b6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60b8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60ba,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60bc,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60be,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60c0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60c2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60c4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60c6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60c8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60ca,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60cc,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60ce,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60d0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60d2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60d4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60d6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60d8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60da,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60dc,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60de,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60e0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60e2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60e4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60e6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60e8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60ea,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60ec,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60ee,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60f0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60f2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60f4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60f6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60f8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60fa,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60fc,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x60fe,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped","OverlayBitsGrouped",true },
  {0x6000,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6002,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6004,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6006,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6008,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x600a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x600c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x600e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6010,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6012,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6014,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6016,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6018,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x601a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x601c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x601e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6020,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6022,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6024,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6026,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6028,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x602a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x602c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x602e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6030,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6032,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6034,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6036,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6038,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x603a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x603c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x603e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6040,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6042,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6044,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6046,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6048,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x604a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x604c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x604e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6050,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6052,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6054,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6056,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6058,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x605a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x605c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x605e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6060,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6062,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6064,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6066,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6068,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x606a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x606c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x606e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6070,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6072,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6074,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6076,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6078,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x607a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x607c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x607e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6080,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6082,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6084,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6086,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6088,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x608a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x608c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x608e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6090,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6092,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6094,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6096,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6098,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x609a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x609c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x609e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60a0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60a2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60a4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60a6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60a8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60aa,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60ac,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60ae,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60b0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60b2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60b4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60b6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60b8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60ba,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60bc,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60be,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60c0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60c2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60c4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60c6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60c8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60ca,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60cc,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60ce,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60d0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60d2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60d4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60d6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60d8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60da,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60dc,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60de,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60e0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60e2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60e4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60e6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60e8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60ea,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60ec,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60ee,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60f0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60f2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60f4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60f6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60f8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60fa,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60fc,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x60fe,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated","OverlayBitsAllocated",false },
  {0x6000,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6002,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6004,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6006,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6008,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x600a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x600c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x600e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6010,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6012,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6014,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6016,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6018,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x601a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x601c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x601e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6020,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6022,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6024,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6026,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6028,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x602a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x602c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x602e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6030,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6032,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6034,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6036,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6038,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x603a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x603c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x603e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6040,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6042,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6044,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6046,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6048,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x604a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x604c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x604e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6050,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6052,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6054,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6056,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6058,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x605a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x605c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x605e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6060,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6062,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6064,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6066,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6068,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x606a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x606c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x606e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6070,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6072,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6074,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6076,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6078,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x607a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x607c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x607e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6080,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6082,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6084,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6086,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6088,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x608a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x608c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x608e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6090,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6092,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6094,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6096,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6098,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x609a,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x609c,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x609e,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60a0,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60a2,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60a4,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60a6,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60a8,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60aa,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60ac,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60ae,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60b0,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60b2,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60b4,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60b6,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60b8,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60ba,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60bc,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60be,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60c0,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60c2,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60c4,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60c6,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60c8,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60ca,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60cc,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60ce,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60d0,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60d2,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60d4,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60d6,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60d8,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60da,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60dc,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60de,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60e0,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60e2,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60e4,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60e6,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60e8,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60ea,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60ec,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60ee,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60f0,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60f2,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60f4,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60f6,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60f8,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60fa,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60fc,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x60fe,0x0102,VR::US,VM::VM1,"Overlay Bit Position","OverlayBitPosition",false },
  {0x6000,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6002,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6004,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6006,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6008,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x600a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x600c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x600e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6010,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6012,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6014,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6016,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6018,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x601a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x601c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x601e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6020,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6022,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6024,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6026,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6028,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x602a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x602c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x602e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6030,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6032,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6034,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6036,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6038,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x603a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x603c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x603e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6040,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6042,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6044,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6046,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6048,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x604a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x604c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x604e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6050,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6052,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6054,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6056,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6058,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x605a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x605c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x605e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6060,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6062,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6064,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6066,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6068,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x606a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x606c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x606e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6070,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6072,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6074,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6076,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6078,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x607a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x607c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x607e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6080,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6082,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6084,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6086,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6088,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x608a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x608c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x608e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6090,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6092,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6094,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6096,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6098,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x609a,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x609c,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x609e,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60a0,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60a2,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60a4,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60a6,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60a8,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60aa,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60ac,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60ae,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60b0,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60b2,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60b4,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60b6,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60b8,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60ba,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60bc,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60be,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60c0,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60c2,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60c4,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60c6,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60c8,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60ca,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60cc,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60ce,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60d0,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60d2,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60d4,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60d6,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60d8,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60da,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60dc,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60de,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60e0,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60e2,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60e4,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60e6,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60e8,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60ea,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60ec,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60ee,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60f0,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60f2,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60f4,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60f6,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60f8,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60fa,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60fc,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x60fe,0x0110,VR::CS,VM::VM1,"Overlay Format","OverlayFormat",true },
  {0x6000,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6002,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6004,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6006,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6008,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x600a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x600c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x600e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6010,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6012,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6014,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6016,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6018,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x601a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x601c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x601e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6020,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6022,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6024,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6026,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6028,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x602a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x602c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x602e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6030,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6032,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6034,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6036,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6038,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x603a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x603c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x603e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6040,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6042,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6044,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6046,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6048,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x604a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x604c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x604e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6050,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6052,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6054,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6056,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6058,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x605a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x605c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x605e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6060,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6062,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6064,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6066,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6068,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x606a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x606c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x606e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6070,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6072,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6074,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6076,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6078,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x607a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x607c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x607e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6080,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6082,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6084,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6086,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6088,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x608a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x608c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x608e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6090,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6092,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6094,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6096,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6098,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x609a,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x609c,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x609e,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60a0,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60a2,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60a4,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60a6,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60a8,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60aa,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60ac,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60ae,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60b0,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60b2,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60b4,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60b6,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60b8,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60ba,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60bc,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60be,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60c0,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60c2,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60c4,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60c6,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60c8,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60ca,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60cc,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60ce,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60d0,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60d2,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60d4,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60d6,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60d8,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60da,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60dc,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60de,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60e0,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60e2,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60e4,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60e6,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60e8,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60ea,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60ec,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60ee,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60f0,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60f2,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60f4,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60f6,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60f8,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60fa,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60fc,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x60fe,0x0200,VR::US,VM::VM1,"Overlay Location","OverlayLocation",true },
  {0x6000,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6002,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6004,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6006,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6008,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x600a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x600c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x600e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6010,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6012,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6014,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6016,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6018,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x601a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x601c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x601e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6020,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6022,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6024,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6026,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6028,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x602a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x602c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x602e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6030,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6032,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6034,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6036,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6038,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x603a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x603c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x603e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6040,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6042,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6044,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6046,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6048,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x604a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x604c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x604e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6050,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6052,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6054,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6056,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6058,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x605a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x605c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x605e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6060,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6062,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6064,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6066,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6068,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x606a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x606c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x606e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6070,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6072,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6074,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6076,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6078,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x607a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x607c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x607e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6080,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6082,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6084,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6086,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6088,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x608a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x608c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x608e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6090,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6092,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6094,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6096,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6098,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x609a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x609c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x609e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60a0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60a2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60a4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60a6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60a8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60aa,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60ac,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60ae,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60b0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60b2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60b4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60b6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60b8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60ba,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60bc,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60be,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60c0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60c2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60c4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60c6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60c8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60ca,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60cc,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60ce,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60d0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60d2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60d4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60d6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60d8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60da,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60dc,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60de,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60e0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60e2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60e4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60e6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60e8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60ea,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60ec,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60ee,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60f0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60f2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60f4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60f6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60f8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60fa,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60fc,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x60fe,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label","OverlayCodeLabel",true },
  {0x6000,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6002,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6004,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6006,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6008,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x600a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x600c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x600e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6010,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6012,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6014,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6016,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6018,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x601a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x601c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x601e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6020,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6022,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6024,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6026,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6028,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x602a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x602c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x602e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6030,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6032,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6034,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6036,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6038,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x603a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x603c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x603e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6040,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6042,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6044,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6046,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6048,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x604a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x604c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x604e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6050,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6052,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6054,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6056,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6058,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x605a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x605c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x605e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6060,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6062,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6064,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6066,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6068,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x606a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x606c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x606e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6070,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6072,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6074,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6076,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6078,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x607a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x607c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x607e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6080,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6082,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6084,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6086,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6088,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x608a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x608c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x608e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6090,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6092,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6094,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6096,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6098,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x609a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x609c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x609e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60a0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60a2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60a4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60a6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60a8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60aa,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60ac,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60ae,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60b0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60b2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60b4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60b6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60b8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60ba,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60bc,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60be,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60c0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60c2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60c4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60c6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60c8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60ca,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60cc,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60ce,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60d0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60d2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60d4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60d6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60d8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60da,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60dc,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60de,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60e0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60e2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60e4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60e6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60e8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60ea,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60ec,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60ee,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60f0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60f2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60f4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60f6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60f8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60fa,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60fc,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x60fe,0x0802,VR::US,VM::VM1,"Overlay Number of Tables","OverlayNumberOfTables",true },
  {0x6000,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6002,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6004,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6006,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6008,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x600a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x600c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x600e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6010,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6012,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6014,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6016,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6018,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x601a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x601c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x601e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6020,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6022,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6024,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6026,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6028,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x602a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x602c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x602e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6030,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6032,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6034,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6036,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6038,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x603a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x603c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x603e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6040,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6042,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6044,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6046,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6048,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x604a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x604c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x604e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6050,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6052,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6054,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6056,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6058,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x605a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x605c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x605e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6060,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6062,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6064,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6066,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6068,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x606a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x606c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x606e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6070,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6072,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6074,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6076,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6078,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x607a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x607c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x607e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6080,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6082,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6084,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6086,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6088,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x608a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x608c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x608e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6090,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6092,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6094,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6096,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6098,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x609a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x609c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x609e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60a0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60a2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60a4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60a6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60a8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60aa,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60ac,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60ae,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60b0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60b2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60b4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60b6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60b8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60ba,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60bc,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60be,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60c0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60c2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60c4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60c6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60c8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60ca,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60cc,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60ce,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60d0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60d2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60d4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60d6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60d8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60da,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60dc,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60de,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60e0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60e2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60e4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60e6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60e8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60ea,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60ec,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60ee,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60f0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60f2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60f4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60f6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60f8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60fa,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60fc,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x60fe,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location","OverlayCodeTableLocation",true },
  {0x6000,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6002,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6004,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6006,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6008,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x600a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x600c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x600e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6010,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6012,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6014,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6016,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6018,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x601a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x601c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x601e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6020,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6022,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6024,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6026,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6028,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x602a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x602c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x602e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6030,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6032,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6034,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6036,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6038,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x603a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x603c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x603e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6040,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6042,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6044,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6046,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6048,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x604a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x604c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x604e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6050,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6052,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6054,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6056,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6058,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x605a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x605c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x605e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6060,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6062,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6064,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6066,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6068,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x606a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x606c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x606e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6070,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6072,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6074,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6076,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6078,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x607a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x607c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x607e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6080,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6082,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6084,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6086,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6088,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x608a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x608c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x608e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6090,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6092,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6094,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6096,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6098,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x609a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x609c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x609e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60a0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60a2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60a4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60a6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60a8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60aa,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60ac,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60ae,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60b0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60b2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60b4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60b6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60b8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60ba,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60bc,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60be,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60c0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60c2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60c4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60c6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60c8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60ca,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60cc,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60ce,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60d0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60d2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60d4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60d6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60d8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60da,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60dc,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60de,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60e0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60e2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60e4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60e6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60e8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60ea,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60ec,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60ee,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60f0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60f2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60f4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60f6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60f8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60fa,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60fc,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x60fe,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word","OverlayBitsForCodeWord",true },
  {0x6000,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6002,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6004,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6006,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6008,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x600a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x600c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x600e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6010,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6012,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6014,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6016,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6018,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x601a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x601c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x601e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6020,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6022,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6024,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6026,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6028,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x602a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x602c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x602e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6030,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6032,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6034,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6036,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6038,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x603a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x603c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x603e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6040,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6042,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6044,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6046,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6048,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x604a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x604c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x604e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6050,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6052,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6054,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6056,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6058,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x605a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x605c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x605e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6060,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6062,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6064,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6066,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6068,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x606a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x606c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x606e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6070,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6072,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6074,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6076,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6078,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x607a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x607c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x607e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6080,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6082,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6084,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6086,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6088,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x608a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x608c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x608e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6090,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6092,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6094,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6096,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6098,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x609a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x609c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x609e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60a0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60a2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60a4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60a6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60a8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60aa,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60ac,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60ae,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60b0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60b2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60b4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60b6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60b8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60ba,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60bc,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60be,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60c0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60c2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60c4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60c6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60c8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60ca,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60cc,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60ce,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60d0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60d2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60d4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60d6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60d8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60da,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60dc,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60de,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60e0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60e2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60e4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60e6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60e8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60ea,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60ec,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60ee,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60f0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60f2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60f4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60f6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60f8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60fa,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60fc,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x60fe,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer","OverlayActivationLayer",false },
  {0x6000,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6002,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6004,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6006,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6008,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x600a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x600c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x600e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6010,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6012,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6014,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6016,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6018,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x601a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x601c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x601e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6020,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6022,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6024,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6026,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6028,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x602a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x602c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x602e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6030,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6032,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6034,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6036,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6038,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x603a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x603c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x603e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6040,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6042,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6044,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6046,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6048,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x604a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x604c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x604e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6050,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6052,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6054,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6056,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6058,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x605a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x605c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x605e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6060,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6062,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6064,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6066,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6068,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x606a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x606c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x606e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6070,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6072,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6074,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6076,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6078,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x607a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x607c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x607e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6080,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6082,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6084,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6086,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6088,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x608a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x608c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x608e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6090,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6092,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6094,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6096,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6098,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x609a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x609c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x609e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60a0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60a2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60a4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60a6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60a8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60aa,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60ac,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60ae,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60b0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60b2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60b4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60b6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60b8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60ba,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60bc,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60be,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60c0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60c2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60c4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60c6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60c8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60ca,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60cc,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60ce,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60d0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60d2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60d4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60d6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60d8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60da,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60dc,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60de,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60e0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60e2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60e4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60e6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60e8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60ea,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60ec,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60ee,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60f0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60f2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60f4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60f6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60f8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60fa,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60fc,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x60fe,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray","OverlayDescriptorGray",true },
  {0x6000,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6002,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6004,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6006,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6008,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x600a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x600c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x600e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6010,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6012,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6014,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6016,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6018,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x601a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x601c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x601e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6020,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6022,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6024,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6026,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6028,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x602a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x602c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x602e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6030,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6032,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6034,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6036,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6038,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x603a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x603c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x603e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6040,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6042,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6044,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6046,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6048,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x604a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x604c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x604e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6050,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6052,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6054,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6056,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6058,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x605a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x605c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x605e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6060,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6062,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6064,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6066,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6068,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x606a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x606c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x606e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6070,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6072,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6074,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6076,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6078,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x607a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x607c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x607e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6080,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6082,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6084,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6086,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6088,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x608a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x608c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x608e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6090,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6092,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6094,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6096,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6098,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x609a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x609c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x609e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60a0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60a2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60a4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60a6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60a8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60aa,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60ac,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60ae,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60b0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60b2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60b4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60b6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60b8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60ba,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60bc,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60be,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60c0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60c2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60c4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60c6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60c8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60ca,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60cc,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60ce,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60d0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60d2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60d4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60d6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60d8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60da,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60dc,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60de,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60e0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60e2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60e4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60e6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60e8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60ea,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60ec,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60ee,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60f0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60f2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60f4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60f6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60f8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60fa,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60fc,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x60fe,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red","OverlayDescriptorRed",true },
  {0x6000,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6002,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6004,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6006,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6008,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x600a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x600c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x600e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6010,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6012,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6014,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6016,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6018,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x601a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x601c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x601e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6020,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6022,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6024,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6026,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6028,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x602a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x602c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x602e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6030,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6032,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6034,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6036,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6038,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x603a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x603c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x603e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6040,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6042,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6044,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6046,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6048,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x604a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x604c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x604e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6050,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6052,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6054,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6056,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6058,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x605a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x605c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x605e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6060,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6062,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6064,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6066,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6068,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x606a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x606c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x606e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6070,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6072,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6074,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6076,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6078,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x607a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x607c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x607e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6080,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6082,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6084,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6086,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6088,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x608a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x608c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x608e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6090,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6092,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6094,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6096,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6098,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x609a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x609c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x609e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60a0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60a2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60a4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60a6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60a8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60aa,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60ac,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60ae,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60b0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60b2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60b4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60b6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60b8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60ba,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60bc,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60be,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60c0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60c2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60c4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60c6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60c8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60ca,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60cc,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60ce,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60d0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60d2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60d4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60d6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60d8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60da,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60dc,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60de,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60e0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60e2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60e4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60e6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60e8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60ea,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60ec,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60ee,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60f0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60f2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60f4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60f6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60f8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60fa,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60fc,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x60fe,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green","OverlayDescriptorGreen",true },
  {0x6000,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6002,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6004,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6006,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6008,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x600a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x600c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x600e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6010,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6012,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6014,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6016,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6018,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x601a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x601c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x601e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6020,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6022,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6024,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6026,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6028,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x602a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x602c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x602e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6030,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6032,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6034,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6036,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6038,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x603a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x603c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x603e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6040,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6042,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6044,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6046,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6048,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x604a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x604c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x604e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6050,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6052,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6054,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6056,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6058,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x605a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x605c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x605e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6060,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6062,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6064,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6066,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6068,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x606a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x606c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x606e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6070,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6072,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6074,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6076,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6078,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x607a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x607c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x607e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6080,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6082,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6084,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6086,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6088,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x608a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x608c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x608e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6090,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6092,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6094,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6096,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6098,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x609a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x609c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x609e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60a0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60a2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60a4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60a6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60a8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60aa,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60ac,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60ae,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60b0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60b2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60b4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60b6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60b8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60ba,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60bc,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60be,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60c0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60c2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60c4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60c6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60c8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60ca,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60cc,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60ce,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60d0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60d2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60d4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60d6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60d8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60da,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60dc,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60de,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60e0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60e2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60e4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60e6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60e8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60ea,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60ec,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60ee,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60f0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60f2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60f4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60f6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60f8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60fa,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60fc,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x60fe,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue","OverlayDescriptorBlue",true },
  {0x6000,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6002,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6004,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6006,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6008,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x600a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x600c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x600e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6010,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6012,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6014,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6016,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6018,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x601a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x601c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x601e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6020,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6022,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6024,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6026,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6028,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x602a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x602c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x602e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6030,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6032,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6034,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6036,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6038,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x603a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x603c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x603e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6040,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6042,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6044,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6046,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6048,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x604a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x604c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x604e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6050,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6052,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6054,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6056,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6058,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x605a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x605c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x605e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6060,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6062,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6064,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6066,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6068,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x606a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x606c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x606e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6070,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6072,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6074,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6076,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6078,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x607a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x607c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x607e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6080,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6082,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6084,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6086,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6088,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x608a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x608c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x608e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6090,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6092,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6094,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6096,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6098,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x609a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x609c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x609e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60a0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60a2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60a4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60a6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60a8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60aa,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60ac,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60ae,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60b0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60b2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60b4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60b6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60b8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60ba,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60bc,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60be,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60c0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60c2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60c4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60c6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60c8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60ca,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60cc,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60ce,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60d0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60d2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60d4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60d6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60d8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60da,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60dc,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60de,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60e0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60e2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60e4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60e6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60e8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60ea,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60ec,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60ee,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60f0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60f2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60f4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60f6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60f8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60fa,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60fc,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x60fe,0x1200,VR::US,VM::VM1_n,"Overlays - Gray","OverlaysGray",true },
  {0x6000,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6002,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6004,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6006,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6008,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x600a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x600c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x600e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6010,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6012,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6014,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6016,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6018,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x601a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x601c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x601e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6020,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6022,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6024,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6026,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6028,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x602a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x602c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x602e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6030,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6032,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6034,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6036,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6038,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x603a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x603c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x603e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6040,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6042,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6044,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6046,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6048,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x604a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x604c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x604e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6050,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6052,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6054,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6056,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6058,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x605a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x605c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x605e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6060,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6062,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6064,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6066,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6068,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x606a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x606c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x606e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6070,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6072,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6074,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6076,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6078,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x607a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x607c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x607e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6080,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6082,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6084,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6086,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6088,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x608a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x608c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x608e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6090,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6092,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6094,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6096,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6098,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x609a,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x609c,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x609e,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60a0,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60a2,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60a4,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60a6,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60a8,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60aa,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60ac,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60ae,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60b0,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60b2,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60b4,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60b6,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60b8,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60ba,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60bc,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60be,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60c0,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60c2,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60c4,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60c6,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60c8,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60ca,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60cc,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60ce,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60d0,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60d2,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60d4,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60d6,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60d8,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60da,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60dc,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60de,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60e0,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60e2,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60e4,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60e6,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60e8,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60ea,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60ec,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60ee,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60f0,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60f2,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60f4,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60f6,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60f8,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60fa,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60fc,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x60fe,0x1201,VR::US,VM::VM1_n,"Overlays - Red","OverlaysRed",true },
  {0x6000,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6002,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6004,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6006,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6008,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x600a,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x600c,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x600e,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6010,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6012,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6014,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6016,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6018,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x601a,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x601c,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x601e,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6020,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6022,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6024,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6026,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6028,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x602a,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x602c,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x602e,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6030,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6032,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6034,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6036,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6038,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x603a,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x603c,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x603e,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6040,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6042,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6044,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6046,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6048,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x604a,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x604c,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x604e,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6050,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6052,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6054,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6056,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6058,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x605a,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x605c,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x605e,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6060,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6062,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6064,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6066,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6068,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x606a,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x606c,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x606e,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGreen",true },
  {0x6070,0x1202,VR::US,VM::VM1_n,"Overlays - Green","OverlaysGree